(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     95328,       1670]
NotebookOptionsPosition[     94754,       1647]
NotebookOutlinePosition[     95097,       1662]
CellTagsIndexPosition[     95054,       1659]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Plot a trimmed surface",
  FontWeight->"Bold"],
 "\nPolygons are defined in the  domain of a parametric surface. The areas \
inside these polygons are trimmed away from the 3D surface, resulting in a \
trimmed surface.\nSee Figure 18.5"
}], "Subsubtitle",
 CellChangeTimes->{{3.58472170693862*^9, 3.584721718448636*^9}, {
  3.5847218148587713`*^9, 3.58472187840886*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"RegionFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], 
          RowBox[{"Sin", "[", "y", "]"}]}], "<", "0.33"}]}], "]"}]}], ",", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", " ", 
     RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", " ", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"RegionFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], 
          RowBox[{"Sin", "[", "y", "]"}]}], "<", "0.33"}]}], "]"}]}], ",", 
     RowBox[{"BoundaryStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", " ", 
     RowBox[{"Contours", "\[Rule]", "0"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5646654614044533`*^9, 3.564665461778854*^9}, {
  3.564665562461431*^9, 3.564665564115034*^9}, {3.564665928687214*^9, 
  3.56466605208259*^9}, {3.564666158207551*^9, 3.5646661586875515`*^9}, {
  3.5646664558431854`*^9, 3.564666523548088*^9}, {3.5646667061595807`*^9, 
  3.5646667512008514`*^9}, {3.5646667871421065`*^9, 3.564666917386309*^9}, {
  3.5646669777624054`*^9, 3.5646670852049713`*^9}, {3.5646671555750823`*^9, 
  3.564667157634286*^9}, {3.564667192978339*^9, 3.564667206361558*^9}, {
  3.56466728554847*^9, 3.5646673234421253`*^9}, {3.5646673579737763`*^9, 
  3.564667437300692*^9}, {3.564667481625556*^9, 3.564667502396386*^9}, {
  3.5646675596284666`*^9, 3.5646675720784845`*^9}, {3.564667608498535*^9, 
  3.564667632726971*^9}, {3.5646676663670187`*^9, 3.564667679287837*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mwuYzmX6x2fMgaxDjMPMLGPwru2ASkJ683sc0iR/REs5zJb0bxZTVrYD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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmnncl9PWxu+9H0SHTE3SoJIkRJRKnSaV4eC8hCZRKp1QKFKUylvRpMiY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         "]], Polygon3DBox[CompressedData["
1:eJwtlXnwl1MYxd/7vE2USj9EKvRrSkKYYtLCEKaoSZs/FIYkWaYfQjGEEirL
lLVllEqZUGhRBi2KtCElS3u0056U6HM67x9nvufce7/vvfd5nvPc0m5lHXtF
lmUDQDnwPWiUsqwhv88yMQl0BBvR+8BYeCvwI3wnuAV+I1gD3wIegZ+b8x++
8Tr6NnQHsB5+KmMfwvuA+ehvwL3wn0BN5pqgF8OXgmpai74V3h6sg5/C2H3w
d8AOdC30g/BR4b2/AIfgfcEC+O/gB50VVGftZI3B24IZ8NqM1eOsc9FV4e2T
z/4oel7mO3wG/wj8ja6MbgcvZU0beBlj/6KPgPfgi4CCuUMxYL4+GAe/Aaxk
7i/wFvxNMAG+EKwFZ/C9K1n7CuMvgNro69FTmVuHbqMYwc9m7FV4XebbJcfw
NPiLjP0G3wsWwL8Ox+pL9BT4ZHAw8x0ehg8Dm+D7wWrlJvztaejH4R+DQ/D/
wQb4H+FYTUeXsN8Q9K/wPaob+DQVEPMXJ9fPCaxpDB/I+FHwVDg2WxUjeA/w
PnwJ6Ab/BPwDP6I94c+AxfBtYCb8U5DzvXKgPDgf9GPsW9UQvwvDtTUb/QH8
pnDuD2Q+R6PiXAOLve4AhzPv2YS5y8FJnLl7ceer0a/p3vB3i5woF7vAcPiI
8NkngdbhHCu3K0AFvnMzejP8Mu0L76k4KM/JtTc+/C3VYKfwmXVW5WQi/GS+
cQVrd2eunTXgrOQaGhrOoXInT3YoPCpvymNXsa6lvFec/2l+3w7HXjHtrdiD
DZlrfHB4T+2lnD4Hvx/8mdnj14U9L68vBzlnG43eDr+QfWaFPSJvVFLNhnOm
XCnGqqXpICXX1M/wVWGvy3N3KhfhnMpDs+FzwntNAdfo7uzZivkS9O3Ke9g7
E8FL6hW5a1EemIF+Q2fOvKd6i3qGeoV6jLzwEPgvsyfWhj2g2leMT+RbK9Bn
wi8Fd4dzqNypxsszvwx9OvwS8Iu8AEoUd5asDPcc9Rp947twT1Mv03+q8P/5
6FnoFuitih1jzeF1ilqcEK5F1eSScMwVa/XE/ujI7Y2lmXOR0Bck50S9cj9o
kNwzt4d7knpRXXkot2fl1YvAprDH5e1zknvNxjBXz9ml2g73OvW0xxSb3DWm
Hnu48GG/IofyjmpQtScP6a7bwnfTnZ/UWfh/5+Qe+BV6CyhFz0QPglfM7cum
ybmsgb42Oafykbyst0lvlGr1+bD3VLPqoxWS+6r66U7Vcvjuiqneqr3gvOQ3
S71cb4jeDvX0l5Xb3L10Ndgc9rS8rDPKm13DuZNHK+W+g87eLLk3dw6/ferR
I8N30l3UE5TrLuG1yvmBcA9T71LO5oXfJL1Fqim9DQ8w9nlxt33hHq/erjuU
wfeEz6o1y8M1qtrUm6defE/YS+qFY8I1rtrWG3r8rQnXrt4cee2ucG+T55Rr
5VL9RDlX7p4Ie1E5PAZZSxfb
         "]]}]}, {}, {}, {}, {}}, 
    {GrayLevel[0], Thickness[Large], Line3DBox[CompressedData["
1:eJwt0Lsvg1EYgPFPL7R1TWPB5DIyGFgrMTI16aITAxH3kZGRGaWtu4lBgz9N
SJro7006PHme9+R853w5kxsH5f2eJEnWkUL0CCYwZ5jhdjTmzYu8w0uxzwev
elWP6ndd1S3e4iOc4AwXuMI1arjBLer4tL/BY8740m004x/M3/ofd+Y9vucS
V/Cgf+Nu/cjL/MTPeMElztFv/ZR/cIyc+ZB3eZOn3POh13RRv+mVOINLvIBZ
TGMcwxjCIAbifBTQtD8fa85o6JzO67ru09vcy1nO8h8y8e7mdPf9O7E0Jfc=

      "]], Line3DBox[CompressedData["
1:eJwl0ccu5WEYB+D/OUe7CHUhFi5DLysblpxRh5ilBaIluAMl0U0s7JCQ6LNT
Z0bv3U3oz4nFk9/3lrybLyP6q6w5FARBC6FIEGTHCtkdDoKwrJafdPFBJ6O8
08Ebr6zwgxe2nIjKOaqYZ4lFkt2cMV/2rozt0sogA7STZadNjpBDirpGDjFM
LtvUssqse/F24uhRL1DHP+pjaZ5o1uC9xjob5DFJAanmvbKJPtLUhXKKYq65
4Yo7binhgUfueeaJUqb5TT/pbhXJCi4554I/ZJptyjNOyaecn5zQyATjJNk9
ksf855ADEvT35V922GOXiP5Y+PtfvwBankVB
      "]], Line3DBox[CompressedData["
1:eJwl0ccuRAEUgOGLFdF7WQ3iGbyENkqiJ/Zm9PYGapTEhrVeFySsJBiewk7v
nZ0vsfjyn3PP3MkkE+qIhiNxQRD0MhofBEkJQVDuwZK5ggceuSPCPc88kemz
K1pJyNyti7RQxRvvnBKjlWo++OSMc9qoYY0wxb5rRvuYpcReqxvU88MQ3wxT
4H7p94+Yd9ljn3kK3YqIuf/aG9hkkDlK3eq0nX7K7APayzrTfHHk/Xy3A/Mh
O2yzRQ8X7nnuXeYXorwyRa7nq5qtE5qlk5qjnZqh45quY7pMmrlZU/VEb7kh
xd6kyXqs11yRaG/Uhfj///EPUGQ+uw==
      "]]}},
   VertexNormals->CompressedData["
1:eJx1WgdQVUmwxZzdNSfMEV1dE2tC24Q5oIIJc1oUUTErZsW0ooJ51TWBCbMI
ik9bckYQBEQySOaxrllUPt93en756ru1VVNv7kzP6dOnu+deaT5n6fj5pQ0M
DNqWMTAo+d/gW07qivC1mYSRHzqOT7N6/4jWus3a1/BKBvXc2OjTPw2z2fBE
/zVc4wll8sq0MUvSKJGWXTgXlsO/x8X39+rmRXO8NlT+b3Ey9TDqGDRhcx5X
9K52J83cm3wrlzdzyIsjp6oVdj+tWcDDq65LSp7tQwsqfqo/YVok3Q+/a+04
W8sav+thVQb4Uj3LoqVDE7xoZfKHMhsHFLLp33l7JsT4ktUmp4OBo69q1ndd
WrTnYCHvDKkeX76KH7XSrWf99Yt19lnffpAODzsCzzDgmafDz8bAXwH4s3X+
cgL87QR/1+v44R7gpxH4ER71+QSPwqvic8L0LZPOLcqUkV13v+0+e6kX7Qw5
EHDsqi+Z357kml6s5YEWrz9YGgbSMIMx7uX23tB8yHl0dd7CQj67oN/HRUsC
6YhuPeuvn2pq+9EwK4pLZV9Z6RpfwBuCnt8Y1TOAfEOuuwZ1TeAn38d8Nhlj
88tprR8VPDq/zN8+lVMN316+MiyXz7n+6fanrS/VdznhGDswg7Od8lKNzbJ5
+7I2ztVyvMkcuMdjvAr8oht9f6Eb0ZHSz6f7nr5XOt7RFB44UP6eUSFP2//B
JqFOGPl9Wei8Ym0g59rtcDh4VMse5tmddu0LpZ5TN1fM7h3L3PlM5fOVCjjH
Ys+76g1DKKifVZeYVin8/tH1S79k53JRu40uLw2D6P62Gzanr6bz3JYNgwYf
KdGz5p9Uj9f+lNXl88gpEzI5A6PoJxd+1oXf4q/oXh8/dC95oPS/zz/l2IIF
7pqhs/jVuPtavmA9eoh9XiTtjynbtX1yGG/5PhawjcFr/7jFkTT42OFzibdf
ct/vYx5Xne681KttBDnu0UScuZPGj6petG6vzeap4Oevm+W29DTK5N0YC/0v
t/OOD6L58NMNfjeCv+mIay7iLPGVvNXHj7yVPFb5+6nR2I2Z3zSaKnxycdGz
Au6UHvd1XNdYMrZ1SI/88oy9jMyf97bL55P2WbXetYmhGkbul/9MT2GnvjU2
NrLI4eZj7jf5dDeK5mx7MG5k5CuejnFF/+CRTT5GkBf8dIDf4u9HxNUPcf6M
+PpAx4+ga9Gz1B19/KgLUodUfejz+z9WhrNeEH0fc7jDlUl1Q/9OJIvIkWEX
2vpqjqeuPVLLOY9rDIjp6940hUbo1rMJ1rfD+slbo73e5WawGUa/pyOGrvwz
jo7B/8rgoyl4IMS7J+JfBXH3gr47Qe/Z0HkZ5PN45Lcd8lrqnb5fqI9SX5XO
US+k3qi6Af+FD8WDS6Z5+ekrU2Vkiw4Jc+pNz6DQ6fYcNCNck2C1aNywqAzu
u6nHieiR2XQD685hHIf1g8CXMey3gn1f6KYVdHQc+tmGPFmFvLFGvuSjLtxB
nbiH+jARddAefg2AX9In9HlAX5E+YyL9BXVW6q6J1FvUKalbJlKvkOeS9yaS
78gTyRsTyRfoSfRlIroCj8KrifBp8P2/aA1GE934L2WAd2+sN8b6U9CrGexX
g/1qyNu3wNMeeKRO7QH+c8AvdfkD/J0Mf6UPmYKff8CP9Gl9PkWH6Nukr0P0
MRIdou5LHyCp/6ibUkdJ6ifqjtQhkvqD/JR8JclT6FJ0SqJP8KgBryR8XoWO
MdIorO8PPQ+G/eawL/34EPzqr6dDfR6kLuH+QpK/6N/Sz0n6OPqf9EOSPoj+
If2EpI+g/ko9JqnDqFNSt0jqFfJT8pUkT6EnDfRFoiv4z+BD8SB1Sd8v3MPk
XkZyH8O9RO4pJPUcfV36PEl/R1+UPknSL9BXpM+Q9BfUX6nHJHUYdUfqEEn9
QZ5okDck+SL3SH38uEfKvZLkPol7ldyzSPov7iVyTyG5n6CvS58n6e/oi9In
lb/oH9JPSPoI6qbUUZL6uefH+wlJvss9WB8/7sFyLya5D+NeKPdEkvsS7lVy
z1I6x71E7ikk9xP0denzJP0d/U/6IUkfRN2XPkBS/z/8eJ8kqVdyj9fHj3u8
3OtJ7vO418o9l+R+i3uh3BOVv7hXyT1LxRf3ErmnKD2jf0s/J+nj6FvSx0j6
l+mP93+Senvox/u/qjPyXjFBD7+8t+j7q/c+SD95H6SfvA/ST94H6Sfvg/ST
90H6yfsg/eR9kH7yPkg/eR+kn7wP0k/eB+kn74P0k/dBfT5Zn8+Zh5LnHlqf
QWG9Kq7265bNE25UM6JZXvTx6QbbemXS6MXyvY/7V8xlj+POKffcvem3L1VG
3rgcQ7EB3ofTVhawYdTq7h9b+9H8hVXGVpwaSt3unLNIctfyxiHFhi2r+Ytd
OUfZh105R9nvvyO4fJ/r7lS4aqJRl06FnNT9qqHfymBaX7buunGzHlITv56X
LUO1XFQxcsrMf5+SVd9fv97q7EV7rRM8jeto2XPrp1KtqkcLPsGrcNoENM4/
GOVPk3u1brtqdz6ndz93edO5eMEtfij8wCG4FB7sF3vKDvAJXoUT+ASvwvkm
avO4rWsLaIDD1b9cXXy41Yh9Zd/kxdAU4NsNvAmwL35ugt/usCO8nAFPH3Bu
AXicAV7jgV/itAxxs4O/MYhrZ8S5IXgDDgYuhQc4WPwTPMDBwofgET2Jvu4h
7sDHwKtwii5nQafjoR/gZomb4Mc6Ft3JevjD8E/5JfoTPQqey46fDr0zS+ep
fR1XLDfMobC0Of4jK6h5wjw/xXz70B7fDtjHk8db8+WuV/PZ8FFC8I69vvT7
9JENtPueke2ahjmlW2vZ9uDscdbOfmReVLTFdWs4Tf0+arllu5dDO3sGiF11
vtjnRttG1F3kT10yl19MitSyR9GJI0vbBJNxl3oPGkfcp2Nfp7VtXbaQz3Ud
fzrsv1B6tW127dFbHtOn76OW311PDIkNjhR8glfhhP5Ej0qHwC1+KPzALX4o
/MAneBVO4BO8CifwCV6F8y1wTAGuJsDzGf5U367z7w3WH4f/E8HHadjvDL5C
wd9d4JkC3mciDs2AfzniZIy4LYW/wMHApfDcR7w7I/6NwCfwMfAqnMDHwKtw
ip5EX6I34Gb4ofADN8MPhR+4GX4o/MDHwKtw9t5y7/R8p3weaeB/eFKHp2R4
yC2zbb84wm/GczXfpu4qO21RBB26tCrByLzkHv2+R+d+Lv50+U5AcpFrMG2s
tm9lp2taNj9+uVNQRiA53f9wL/m6VwkftpuG/qvlYdOehNOWEOqO8/rg/Oaw
D7tyjrIPu3KOsg+7co6yD7tyjrIvOM4BlynWC+578GO84IefHeD3QuDBfpbz
xQ72s+AVO9jPsKfsOLW3aFtjbD4f+T4mUI0KTf+blexNcQ0aej+8nMenLZYP
t3uYRDPPWh8e39SHsI6xT60/gP1iT+ZPYL/YEzsJNbf99WXJS7KPs3jTYGM+
H4twqdv6jo/sF3vKDtbJPrV+B/anwd5RzOM347maBw7BpfDAT5bnMj8m6/OJ
ohaptL7mxypdL5fcQ4b3TVzt50Vp7z0i4pNSaKqv5y7LkFzObzzc33SnNy18
MvdIWosUumtef1pS7zz+uMXq5fQob5q05Erd9EHPKcPAs6mtXwGfXXZ/8Ps4
H7IOsHmojY0l4yHGZzsPKuCAJ/Mn1O/jS14ztJPuXHtBp9vnnx+Wls9vm+U1
afDRh9KxfxrsiZ3u2L8U9vxhR/YHwJ7YWQd/xsI/d/g1Bf6kw788+CX+WMM/
8avMVf9TZYdHUI1io7ydNtncoattRnxxmvyW52re/uVp16SwRLo0z93gz6mZ
fGhRQDXvOanyW56r+U67z9ZzLR3Iv1/dnWhRRkuHXt5q8fjaM8qtnLN+2wIf
7jtuSMEFDy3VPXA+/EbHcCplP23FvcxE/jZlYt352XmU7GPXR/u3N73UrSfS
redGWH/R610V03V+9KDtKbtQay0nNze8cOluBJk0O3PQsnY+ZbWfEnesSSJr
/vF+7LnQhxrp8BDw8FHgGWQ4M61UhxAyr5Q189iSAn5RtXDZiubPadXh3BYu
ZUNo+/cxj+9PffOPtX0y7X/a6FZlo2c008Oo4sG+efxf/jiDuJK3sjoX+z2p
FRxBvy2y6r+6qGR9p7G1MxvHC27xQ+EHbvFD4Re+gFfhBD7Bq3BOAG4L+BGF
+fvg5T54SoT92oh3HcS/FeJ7BXE9gDjvQxyxjrFPrcc6xj61vnjT55oX09IY
I4V0Pps58WwqAR8D7//hhP/Aq3BO3pRVft7fcbToP/sNDrUK2H7P0VL1UnzJ
NLbOMbu0AKrbydR5zS0tj301vOquoSGUeyXgruUWb6JG5zton5fU4+Dz01wD
QiX/pR6oOoD8l3qg6gDyReqBqgN93v9X+c01fyr/ZtADbR8t522fVPf9+Uip
C1InVH1AXZA6oeoD/BH/lF9lXqfbhlcJo1++jwUcvfOXjD+PxajfDfD8KeZF
l07Q6TXoU3T5N3SaA30uLj9RM3d/Lr97seuOt2cMTb9qE9pp70ul12bQ7y3o
VvIEeazytwL8HwM+ssED8pmR3yqvJR6fEZ87iIvE1RJx3g4eUB8Z9VLVSdRH
Rr1UdRL1kVEvVZ2EXRa+xT7qJqOOqvqJusmoo6p+/t7Wd6/98kwZeWfe6Gn3
Gj+hKkVRO6PHZpFN0c2Ovjte8baaNo+Oa55Q0yDj8ZfMs8jDoPGs2NWv2Hrl
+K+Hrb0kXlJXVD1BvKSuqHqCuLLsk/giriz7JL6CT/DaA6fgE7xbgFPwNQPe
RcDZbMKtgaU3P6dJ7mGjO9bO4erR/1o2uZ9CRchnjPwMeQ27jHOUfdhlnKPs
yzrZt+1HPMKf4u2IzaX4ys1i2cBz1ooTJXVjYPSpNjXO+JCb3ZTfK5uk0bjz
+zS7cnI4NaZG09a5JTwPs3KNdkwlv8WGpXhqLpeynvvvop7eFPmnzefwJZmM
keqmj054z09oXnFqi27vCuhIcZ5X6Mcotnk2KsnI3Zdmh69dX/tMAX2c6XSx
/uvnvMnD7uGZ9b7krjuXzXTnUgrO3aE7l3Euybnzc193T14ZKyPvr3Xb/Ob0
PNqdM7GTc1g6bf0+RvGI9Q3rH2mYRYcfVKr85+JXlFxj+fJh917wrslRXv7f
0skB79GT8H6fivfolQ/ql5qS+0QT3Xi2ZkVxPjc70NZq/68vqUuZfoHGzR+Q
xsd06zTTfJ7ZL+3mwnGJcp6cr859VCNj9wjbJBm52LK49orrWVRzeKiFw5R7
dDbjo0ULywLe1az5qvXZcbT1x/d39V1iOt53/sN7WEu875jp7LC+nQeLzGus
XBtMezakPU5I1XJph8GWh476kuOIxbaTRz3QNPVrXfW0pZYv9fnXoVbfaFkn
+9T63djvB3ulMI/fjOdqfvHSP3L9J9ylNquOm7S0KuQxm0cMtdrnT3t086w/
b4vvBl3x/WMDvhvYGqXGtnFK4k3n+1QKWZfDG0Mnfi0VEEsN0Dd/Qb81Qt9s
P6tzJZeodG6O0eLR16DlsUm0HfqYjXEvdFIX+4uv6Oy1hp3tOG8mzrfDuZbQ
hxX0kvjjdyqeAz/kuwf8FD6Uv/JdBnEmiS/0J3ok0SH8FL9J/F03Oze03Jxn
mrlVm9T7ZPyCp5Vek3p+YQHBT/GbxF9H6NIOeTEY+twEXjDSDqw3tSyzaebA
HJ58rdLZJ/sDTda3XJK5wCWdYpAPy3T5YdIQefEX9LoA+vWAX82gMwed7kyc
oTfRgTX4GQV+hDfohYQ36EB0QaIHe+T7SeTfUPgFHYguSPSwGrxt1/FGk8Ab
dCC6INHDfvB2FPYHwD5+M56refFrF/CLX9C36J1E55txL7yO+94B3PfAuwZx
IOEfuhSdkugTuhSdkugTcdIgbiTxQpwkbiTxQpw0iBtJvOb8+D1Zfd+z/jHf
lb+7fsx3NY/6K/VY1eHDRbV6xbj5E38Jv3q2Qirn7VgU67wxl6pXXTuu4rfb
9Hsdp/37NxRynVWWjm5ffamdbp47Yb425vXqEktdevVhwIMRT59zxCqnPxsP
ymNvlxWLYm1f0Czw3B963wKej+AefgH394OIC3TG0B2L3hA/RjxZ4hiN857h
/Mc4V+qyfr2Fn+K38hf1Wuq3idRt9CfpVybSp+CP+GcifqFeSP0wkbqBfGDk
h4nkhfCujwe8SxxI+Ae/wjcJz+BReCXhE/VI6hNJXZK46tuXfqPfj8Cv8E3C
s14fJOFZT1f0E12pc1t+nHAxtHUWRf026P6FHd6csMnamP9+Red+e7ugzspM
utbyoP2a95E88rHHx5S3GaJj0bXS843EQwOnDk2h/W39Jq91e85l7w5w3jc+
R+zKOco+7Mo5yj72iz1lpzlwVuyosxcPO9HA8Qj5lQ08Kdmr6+ZTsIzc13xI
9ZwzWkrAvFGObuyF+WDsd4C9dNgJwnwY8jgF8210+xkj/QE7YfDXCHifA2dp
HW5uh/lozAMHAxcLns3WMyqP0wSS4/cxji+eON7G7WU++ejm2QHz5zAfjXuY
B8Yi3Mc8weMexOXbHR2fwMfAy4LzJOpXHO6TW1HHgJvhh8LviPvnW9S/7VgP
HIKLBA/iJHEjiRd4lziQ8A/eGXFQ/K8DPzd1PNAZ8MDg5zrmT2E+DLxgpHfA
cxz+FgD/JuB3gS4ZOh0IfbqAx/vQ+2fwif0Me8oO9MrQL4tuwReDPxbefJFv
Z3D+MJzrinOvIZ6lkBeZ+5M5bXQqHRg+dvPzZxEmd1bV71qYmyu6ER0p/UA3
oiMS/RR3n9nmRWQwr6/we+cp+6NM3lepP7rdiELhl8E3C8/gl8G34hk6E92R
6A16En2R6OoS+L2MemMKf7+4L95eur0Pzb1ysM7gVoX8cXpu+HXLknvA7tkP
fRIe0uoHYV2nTS5km/imaW6ufmQ5t1NPo8HXNMXuXce32VzIN7f95V9wyp9+
WZn/y8Jr5/lameQRr7cV8rOdq2xbB/kR1sk+E1mPdfRihW6frN9VyS43bF4W
OTZ13vjviBCTAQ3Mujg8fyW8axAHFv7ddHzSBvD5GXy+wbq/EC9XrJ8HPz/r
/Ob38Ff8hN/K3zm69VTJQ8fTB6xfpVtPq8DTYqxHXDWIM0l8ha8p4OH6jzww
+CPhYY/Of40D+OgNHqb8yD+JHfCoeBU7SUm/njxa/jx13Tn9wK6/CunQJLOs
mxX8qILOHxb/3olf8F/8E79ab7neIjLLkw2fNJ0QNLeQNnw1qd2lwFd41yAO
LPxDZwzdsegN/jD8MxG/kIeSlyT5iDyUvCTJR8RVgziTxBf1glE/VN1AfWHU
G1Vn9Hjjn/DGwlulH3njD/8/b/wT3lh4g7410DuLzpGHkpcqH6FP0tenxKMK
zhH74o9+fok/8E/5JbrR16Hopmayjg9ZL/5DR/+nH/ivnxfIN8k/ev//1xkS
v+AP6etNr84onMDH+jq3HjTpYOb5O5Qw4FCtV8sLud++2C7VHvvRTt08x2O+
L+axTvap9bJffx77xR71/XGe9edFB9CF8svrrUPNTuUKuWbvQWUtP/tTqfSO
Zbst96MGn0dVqJPsRn3WvNl7ZkwhZ0WkeB+fEkgps06ecfj6iMbED9i5om8h
H+nkPmPJhABqvKflt+npGtIajYtyGVnILlHbi96s8Zf9Yk/ZOXt0f5mbSwpJ
G9H4YkpjZ560v9rnzmsDqLlB3aez1hXS0jnH3s2ZcYE3mU4pDjzuT72Boztw
Zfxoh9tEfrdDFrDTUmeHL+ns0EbYsdjTrfzFboXs9oATrTd6k83wWrMnOPnR
rB//boQT8XcjfwB3L5yfiXPl74r6YV8C1gtf9bDvFdYLX0k6/vgQeJO/U8H5
JOfiPDmf5NzROjv0BXE4DDvgUfEhfB5YrZnzrYYbWawbsr7xtEJ+UNvMdcKi
ANnPsMdiR+LSDnyKHVn3Cec6Yb3YvYpzPGD/peuVC7dHF1JW34oRN0/cMqk6
t//dzQeCqaG2KLa5RSEtSnQolxfiQgY2Nj5ZNkFUNshx2pzNEfzctEpxUj8t
V53+y+17V4LoKf5uQf/vVfK/zutZ0PsJv+uzuNSpRoX86Ppky54URHN+/HsG
boG/Z/DAv6fb4d/nJ+Df063Ldr7QMSSTCvO9390om8kbpvK3tZ5e9M/Lt629
XmfT4yo+Ua3s0/lOor+VQU9vmmrlv/JSOS0l3/OcNLlFFN8+Hn9SM96fSvdw
MOq1MZ66/TZozW6jHE7v1n5DU8tEel7NiL3XaGnF++rzFrZ6yl9qDiC7OwHk
XLmgdNmbWrp/eMaHVS4BnFi1Ws+ZR0Po5LKgjcbFOTTdOzJx5PA4frF3uu12
iwQadfRGm8WXtOS5sGad6EoBvHXtpFqDToVSB82THpc7aum358bzumsDOLWM
x4jzf0dSrsv6uZey8+nAb2/35q15yhFf3c78uiFG4asCvC+AcwHOk/MjcO55
7M+BvRDY6Yfz2uP8JJwbDHyCdxNwBsBP8Tse/m4GL8LTZ/Aj8ZD4rEdcMsD7
FMThBvhnxOk04nYL8Zq/+FG1jIQXlLwioumyBTm82mzw86J6ifJbnqv54OM5
Wxo65POTpuE1qiRE0Lj6r28cXxdLmSv+XlO/uIDjs+6Nv5gZSO+M1u9qvPEZ
mZ29FtX5vJa7PnJYfDDXnxbMHbS8VfUwwn6GPWUH+xn2lB3sZ9hTdja7adpm
WGUyRprjVK/XVHcvmpiYtK9lzTSKfjDyYNVvORz4yvLN7tvelBpil37LMIls
H+x7bROax5l+e3dMfeZDGWOc2sTsSaQDs/YMXPJfHndbMi3FqNCHBpwata7r
0Fia9VabFWFewOFO75ou6+dH97rPNbk+PIS+DG74aHOJf6c7XtSe+hhIR9oX
u168k0W3TzmZtar0ikM+HO//xwsvwSG4FB7gEFwKD3AILoUHOASXwoN8kPxQ
eXF0hubDi6gocq6ZH9/DKY8rOIXFuD58IbjFD4Vf/PGGfycx36fSHy/3H0tn
jHQvZkzustIpNHZt3NIKuwp4SNWsmr92j6HmK4vat9/sRzPAlyn4CwbOszo8
DDxU7KjDI7xnIQ5d4O+yq82qtaZsrrjFItxtXgbtc2xhNrvIi4CPxQ/BiXxg
5IfKC8SFERcKQlxgl3GOsg9/GP4pv+APwz/lF3CzxE3woz5KvVR1UvAJXqmr
gk/win7se1ssLeX1ghZX29t16/N8ttozNnPvXV+6NKZiysAWUZQ8bHbla+W0
3C+j+8ELJfmOeir1VdXVv2aeGFfdJZy+lfrzgOEmLb9eHFHe/XkAPc5Psds4
OohcL9w6fOCmliMHdRs2oVIwXU9sdLDnl1xqd2nkBZ9tKdy8bRnvXoN8KKjh
qLluN/OpX7NyoS+XxPMRvwX5hgd8BZ/gVThxnpyvzsV5cr46V/QB/Srdio6h
I6Uf1E1GHVX1U/wJhX/hsC+8oL6quvoVvBwFTwXAKfxeA98m4NkG8diL+CyA
v6izjLqr6i1wsPgteHAe43x1rtQRqSui24HgPRBxOAT+gYOBS+ExQvwkns0Q
x0rIK1vk2QHov2z1IMM139LJNSI0cJtTNjca8inbs463rJN9aj3WyT61vsFc
txWzi/I45l6KS7uTz6hU9VJPxryMI/xmPFfzUselrs9DPbd5UDv68r1Imr/J
s3xIDy23fWHVMzHYn477hGvPdSm5z9YY83L0FS2n9Uqos98ylNzRn6RfTUZ/
CQWOesBVEefCrpyj7MOunKPsS9/COco+7Mo5yr7016Xot4vRT5sD90X4kQT7
WMfSh2X9PPi/HHy0Ak7sZ9hTdq4ifuUQzwaIC/Yz7Ck7WMfYp9a7NXy07kty
HltnhRceiUyky7Y7nlZPLanP6KOv0FfT0b/KtX9U6nP1PP63bcdNteem0MPy
oTVajvUh7GfYU3asYFfOccV8IfaLvcewg9/yXM0DBwOXwgMcLPsEz6LiThFT
z6TQ/ErmZq3ycjmof4uiFj19pN5J/VN1T9ZZY18A1ss65JnKrxP1or9Nr5RG
la2fRpUum8v2ackXZ7t5U8jn1R5FCf/bL6f0drIq4F1p2wyCJvrJOtmn1mOd
7FPrzdCfBqJftUKfis+oWq5NTAHdHvDk6xPLaJ5pvOffDh/96O/4VRnmZ9LI
yLPu0tN7M/j33tWda7xNlt/yXM0XPzU3nX27gK83dHZMdQ6m0AFXpx8NiaJz
ttFdttlpeUykc5c9Xv40cGJFs12nnhLWMfap9drZV+cXDgrieR6cUUVbQKUN
OuycEvKMsJ9hT9mJu2+/s+ttfx4x9ORY971aijjfZpqZZzg17tSxZcTAdOoW
53GlV6scXlHGZdrWkd7yW56reQK+C8A7DPZb4D46FvfThbhPBurOpeG6czka
53a84TSTRwTQf1ZWxifNtLzT0dvMNDGCvNcfyrIsE0BGteOerp+r5UZ8ZZbN
4gjRseha6fkEePwGXiPATwDuza9wj/6Ie+9LHW80X8cblwNvx6e+qjFmfBhV
zZxotmxQAXv2/djg+uTn1CW62yKbuaHUvVxbq4KFBWwXuK9jt+hoqjnxr1FX
7kXTjKvDvMk0j+vsHFPH2Cyemu7zvvvHgAT6La7TZc912dz1W5OOg8on0RCP
SslrmqZQxcfHs4ufZvKaUJs1ET2SZZ3sU+uxTvap9Xifkvc/9d6HeEh8VFwQ
D4mPigviIfFRcUE8JD4qLoiHxEfFBbxLHBT/4F3ioPgH7xIHxT94lzgo/sG7
xEHxL3FyRdzcsN4YcRqMuK3G+tfQWT/obvuPfnE0dNcAfv2GfD6N/G6J/MVv
xnM13xHxbov4t0UcKyHeIxD/xYgj1jH2qfVYx9in1ktdi0Cd24l6hbrE7rq6
RDNQl8ALC6/CD3hh8KT4AS8MnhQ/4IUl/sJPF9QLQ9SPZagPwMdSXwUn8LHU
UcGJ/Qx7yo7JyalFHq5xtKt8hVk9fyngyFav4oK1vlKXpU6r+oy6rPiQ+rzG
osrQGddK6uKI1ZqtdbW8MjLbrfsafyrdZED9bWnhFNhPY1elpI6Vb9puZHO/
ADpimHC7lmMIDfV+Y17mrJYjWvT7kB0fSA1bmMZ4eQRS59R/LvS6reVmRQsG
x6wNlu8p6r4s31V6R+8zdyoIpmm1mtVd76LlOiZpQwxaBMn3FPm+or6roA9K
/1R9s/SYI289t+XSN8fdvQcPS+XDa1s/K/vZW76/yPcY9R0GfAl/ijd8l5Hv
NOr7DL6zML67qO8t01DXDFHnqqG+LW3vt6p2yfvwJ/MUn10l78djEhtMCCp5
L0YfYvQl1Y/wvYbx/UZ9t0EfYvQl1Y+EF3zXUd9zhPd2iEMT8C/8DgPfNcEz
vjex1Ev57uSPeFdF/Msg7rm9RoYtHKpl9/2uBna9I2l2qzc9nD/60xDo4Bx0
EQo9jIae7KAvW+hK9ErQbwT4L6WLIyOO5IQ4Yh1L3GQ97kMsupB7kegA9pQd
sQu9KJ0M3t2mTptJWVR75nz3SUtf8WRjgzMvA71E95IHSv/gWfSudI4+J31P
9Tvog6EXpRPEicWexAu8M+Kg+Bd8gncicPbE9xGM/BDfSbCOsU+tl9/yXPz9
HwVpHEo=
    "]],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  BoxRatios->{1, 1, 0.4},
  Boxed->False,
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-3, 3}, {-3, 3}, {-8.999997428571612, 8.999997428571612}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.584721759078693*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnF2MXdV1x2fu3HsZUKRKSClBBJTAmEREiDzNS1XOaVLROFAXuVUeYrWV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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnAfcl2MXx+/1V9kyympHQxqiUmmHQkS2tlFWlIYZlV6pUCGbrPd97T2K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         "]], PolygonBox[CompressedData["
1:eJwtlElsjlEUhr//u/cvygILY0ooEkFYmTdlQRtJE2KInXmMYWMjUVoERUgN
EdRQNQsSoeZ5FjMVFJVWRVFBDTU+b85dvP95z3C//9xz33vbjZ05dEYcRdE4
4MEHfk6BkQSTLoq2w3+CwfgdEsTge+GV2HXYHdhfoA+5jmAkazKSUZQFmoJU
ciOILfEWy4aPAtf4ryb434hvBe1Zq0b07bLwbf1Hd+IHsWfx32IbJK1H9dYL
1IE8cveI3eSbZ+B/4XvgVdg6UOSt95nkdsMvgVnwo2COs56bhp5bgBXkS1n/
mPgVsJ66hcQOEqvBrgVfIpuJcvtjy6lmPvyyMz8Pfzz+B/zX6g3/AHgMphLv
lrDeBzrrXXtIgG3EXmE3YgtBgp6ukl9K7Ir2Bo4Tnw3ew+uT78k3PEhJ2h61
t+7450ABPIfY7shmPwDkezsD8YxwHoq1ga+hfn6ob4nfVzX0eoTYU/AMZFJT
Tb4QfgFM1AzAZ/UN0qjvDR5IL6BrwtY8gu/3tvcs/H3wh2BKbDXaWz320MPZ
Hr9rHiCd3CD83/Bib1qbhP8Gvgt0wp8c2+xehNlphq2caaoCfod+q7HvhMg0
q1wy5FSzSrMFw4insnYzPKafdPgyYvPwu+CXYHux5i42n/gTbK70BYqpPUzu
NbF/3mLiikWszQSL8c9EpusUZzqXvqUHaToHex9/JTgJflBbCS7CF4EFsWnY
J+0MNPturOsNmoFD4e6sxjakpj+xRuCvs35Lid/gewXYj97OqiYyrUgDOntp
ZjT+cnAY3oOa69i2fO8rNWXUDMd21h2n5kTQrjRcQe4l9jy4DebGphFp63z4
vjQ21Nkd0d3QHRniLCbemP9pDn9Ovhb/T5i19pAbZi6/tbO9aE+6i7qDeeG+
3nZ2h3R3dIcGhDdIb480v4V4rTdt6Q065m1mmlW2NJA0TUgL/cAYYjvBLdae
9vbWqWf1qp43EPsEplHTKmFnfd3ZWevMN+ntANNjuyODnc3sZZiZzvayt7ut
M5bW8pxprSTM8iyYENtMi0DsrZ9y6ThoSNrJCb2qpjzUpOktgd+Ff3L2NusN
1NunN/qcN81L6/qPet7e1Krwpr4PMzgdvvcf9zPdwQ==
         "]]}]}, {}, {}, {}, {}}, 
    {GrayLevel[0], Thickness[Large], LineBox[CompressedData["
1:eJwt0T0vQ1EcgPHTlmq9VURENAbRkUWiKyEmJotgkBgYhDIyMjJrvVW9hYmB
4EtIzFaJxFcQxO+E4cnz/O85996e3t6F0tRqIoSwjCRit+HdkOf5uhAGXSzo
j/8NA1TkIq/wCLdbu9aTulPf6jl9z0u8jk1sYxdlVLCPAxziCA/2H3PeMx71
D6rmHvOTTvCJuaRrPMrTONWvqRC+uMt8xuN8zi/uueBL7OHZvMMzzpazZyu+
T3/yGG9ws+trHP+cRS64507P6g59oyf0FQ/zEPrRh27k0IqW+Cw0oRE1+7Nx
LZ5DZ+KaruqG+B04zVmu52/4SSFtdrzwlvz7Tr/c4irI
      "]], LineBox[CompressedData["
1:eJwl0ktIlFEYxvHTpJvMbGOaKKQFWdFooRVCIpi6tzatBIVWoQRGoClom4KR
SotumlqLxILKUGnjvYSuUG3btcxyTK0Mqt+Hiz/P5Zz3/Wbmm/z6ptrGDSGE
UXzdGMIbGksJoSQ1hCl5SJ6mpXIdfSu30MNy3OAc3+H+X0zEQjggP+aLnG3j
u/k2eh7VZsqwYEclzUCVft6dPL7YTMKOXN0zXEex/qHuIo7Li+7ewmb9TVpq
5jbNpUl62r0ftDfaqbtDlzCCb+jBUXsyUIEEMu3qovtou/OW6J5cJMfQJ09h
Oz9J32EaOfIMvYsU/olnL/ONZk9hr24HXuuq5a0oj76X/B1bnP2m97DLZ71P
19Bkzy+6UzdIf6JGt0L7kW5ugK7ihH0jzuL0KR2mrfpLtAF73H0ldyGbT/rt
P+r381/oqP4aqszeoAXRO+f/8Wf5ZtS4ewSfzA7Kh/iX0XuWX9C4/Id+kJM0
X561Y4x/pDsm9/Of7RzW5/DpSNNf1Y0ji++k55wX8idpLdqQ0D/HFWxylma2
Ehecvddd5s/ggWf10YPu7E5d/z//BwomXh0=
      "]], LineBox[CompressedData["
1:eJwl0j1IlWEYxvHHTietISg1C62wUofOItEQqXWEyPxoEBJaGlpCh5wNdRNF
yZoEl9AoTU1BpQh1yqzEAqEPsCIkQTRzFIIa+j00/Lmu+7rv537f9zmn8GZz
/e2MEMIUridCWKU1yRAuYt/uEKppGj/k2/qn+KVdIczyL2WX1AP8d7OD8ir+
ALLkv2RdfDafg1b9FG2ndbiDe2bmsI29egfN56NHb1l2n2/Bomf101Izxdjh
N2V5ZirVb/m0LFe9wVfzRfJl2i3L4B/YeVo9ob7K99HnWJetO7NCf9NZWS/e
o9ZcU3wftKmb6Rm7SuiIXg79LB9HQv6Ufor3pveNHnK5a7RR/ZGOISUbpR+w
ia/4gmK7HppL0HfxrH29fBVtjN+BF5jEOVkmRsy9RgG/QDswj3z1K/oEe/hn
9o4716o+St+oT8iPxbuTXZbtx1n8VG9hGn/wCEXe+TH9i1vOrtByWQWG+KQ9
w/EukW3HXTOF9IK8HH38DVxDg95x2aLZrPgtyMOOuy+TV+A8DstqcARpz0nF
ffE3xowdV8wEdNqzJDuZ/P8f/gcmP1fZ
      "]]}}],
  AspectRatio->1,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 18},
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5847217591586933`*^9}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mn+MFdUVx4ddBLINxLUiSgB37YYULFJ+FNfdkXdbSMTWCAKBYHVLt5IQ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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmgnYV9MWh882T1ERoSiSEkmZKhkqNEppUmkgKlGJUJQyVSgzGVKiKEVS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        "]]]}, {}, {}, {}, {}}, 
    {GrayLevel[0], Thickness[Large], Line3DBox[CompressedData["
1:eJwt0LtKgmEAx+EvzdJOdgVFVC6SW06FbhVFJ7fa2myw1a7ArsAIWhNcQkIh
3MKuIDPtYNmd+AgOD7//y/cu37tycXVamAiCIEeI0V5kmRTbHJD04VwfNc2l
/aRZru1dvdFbKjR4pc07HT7o0uPQ/U991iPu+HJu6jH3fDuf6I/2+eWPAf+8
0aLOA2X23C/pi+5QtGuaIW9v6pnus8UGS8RZYJ45Zpkh4X5Mq7pOdPR/usa0
vapTGmGS8PgdhxjmJV8=
      "]]}},
   VertexNormals->CompressedData["
1:eJx1WGlYldUW1jRnMjPTHPKaI3UjNS3Tg8sxDdNUMAeiFE1NJEOxLMV5ogRF
0zQzxSkVyasRDh1aMgoqJk4oooAgM5y61xmN2+P3vt99zvdc+LMf9lnf2mu9
613D3m18Z4z86Ilq1arlVq9Wrcbf619FObPOzMkXrPpr2MgbU+/EyJyo8aua
782THkEt7v/QvFBbburzuTY6LvkaeGPYJzfkmny6Izy1SF+9nNEn9rVY8Y2d
V+/f07PkDddXUjwXlGidOJdDN7ziJKFereEhJZdlbYPaK39/pkzfbvDF9awJ
8TK5zv1mnu+nyZEzP/uFTShXe2Jkav2+CdLUu2LGoMxYCcy6WyOor0MHflcS
7HkpQabOX7smeeg++5ddZ1QEr3Ho8lNPZdSqnyjtDHm1yk839KtVf4phj4bB
nsGwZ5Jhv3aH/bVhf6Hhr2bCXzf4+6WBj74BfFoAH+JoxRM4ElcTT0+fhaPD
p+Vz1YiVt7pNmBErTXdtCkvvlydFa0tyug8v1KWfdtjpUhQnpTHbP01aliO5
LW/t2Tu4WHdETImaEpAgeioyIqVrpsQ9Xku19zD/hlvKE8VrYMC9lgXnpUbh
3sCIjDINSrn40zs9TsjyU6tPfLsvQbwOjo7IrSzXfqP+vOvdMlkGVxsW/eRX
P9nvFsXsm/SxQ7dN7n1v2ifJst6QV6v8OEO/Vof+edCfYNijx2GPDfaUGfZr
DuwPh/3NDH+1EP4ugb9ewGUk1n3Ah7y04glekqcmP4EjcTXxvNnlwZCxnvlc
9S3wJ3rxT/5b9uXKpLbNUwasL9RW9h9yDv+ZJEm9p3a51C5b7sZE/tiwsFgf
dgradbVlinQZt6BOYc90ie28td72umVaMir49lPNT8kvDz/eOWtOspTOXRqy
ZkO5HvUqdFux6rTcP3IsYe8rh+yO1atr/eLq0PdD7/pnNkmVRENeiyF/GPI9
DP2q0F8E/SmGPXoH9lTAniOG/ToR9reE/QXwMw8r86UYuD8HfIg/89yKJ/Kc
eW/mO3hJnpr8BI7E1cTzqwNPLuzhms9V/520p1NcRoqsDraf3XrohhxvsNvv
pfJC9QE+vb79JvzawavS+/Faoi4+O2fEdjwrX1yq2fWlrFRZ9HgtU/9qfyZd
np4mq5Kyv508Odo+aLzeHHGkXHf4DX1rWUmahBryutAiP8DQr+7Q3wD6wwx7
NAb2jIM9X8PulVgdsP8j4B4Ff1vAX+ZtMfAh/1k3rXiibrKOmvUTec68N/Md
vCRPTX4CR+Jq4vnh4qMjhqTd5KqBfU4OeeHeWXFxjd4zJTdbvnFvFNRiVJG+
OOzIC/d/Pi+dAkJy0x6ek3hXr4s955bqlmUFjW93uCT3W7wblP+X3V5fN0+v
OFembrmXH43omi7dDXmNhfxmyDcy9Ota6G8D/b6wwwfrLNgTC9xDYD/xvwfe
J8LfB/A3HnUnBviw/rAPWfFEn2BfMvsF6ibrqFk/kefMezPfwUvy1OQncCSu
Jp6eiy7E3i7O46rJv3sMCpxyWXq9+sPUluOviDxei/TlvaOfO/3dNRmVNiR1
R8cE+8acOesb7yzRRn0vuUe3zhYPQ15tkO8E+THQOxxrIvR/C9zrwZ7WsEfA
+x6wvz7sZ11zg7+F8Jd9ZSTwmQt82HeteKJPs8+b9Qd9hX3J7C+om6yjZv1E
njPvzfwFL8lTk5/AkbiaeO7K96rlE5jDVUe9nOnb1CdPTvss05QPztgzp04b
Mfh8nrrPf2PThSGF8hPkwrGOgHx/4N4d+ttBfwJ43w72bIQ9i1F3ZsN+P9jP
PnEI/v4Cf99D310GfPoCH849VjwxJ3FusnFeQl9nn7exv6MPsS/Z2I9QN1lH
bayfyHPmvY35Dl6SpzbyEzgSVxvxrPb474Idq81Y/5A84B4H+e6Q/x68Hw79
LtDvgrpzC/a8BHtY94NhfzjsZ9+9C3/HwF/OPQOBzw/Ah3OnFU/yGXOoWPmM
uUnIZ/R19nlhf0cfYl8S8hl1k3VUWD+R58x7Yb6Dl+SpkJ/A0Q5chXjuA4+x
yjuQ7wM+D4D+NtAfBz53hj0bYA/7bjDsnwb7OcfEw98o+Ms5ch3w6WPhsxVP
1mfM9cJ6grmTc6hw/sScxLlJOC+hr7PPC/s7+hD7krAfoW6yjgrrJ/KceS/M
d/DSDp4K+QkcFbiaeHqhLmOV49C/HvW5Iex5AfZwLukD++tZ6vMb8Ndan8cC
H2t9tuKJexHvScL7EeZ4zvXCfoq5k3OocP7EnMS5Sdiv0dfZ54X9HX2IfUnY
j1A3WUeF9RN5bkfeC/MdvFTw1OQncFTgauI5HnMGVgmAPYp5Yw3sZ33gnJ0M
f+/D31jMG/HApxfw4T3Tiifumbx3Cu+buBfxniScDzHHc64XzvOYOzmHCudP
zEmcm0z80dfZ54X9HX2IfUnYj4Kd52dh/USeK/sw872P8/xs8hM4KnA18eTc
z3tAOeznvYX3sObw9wbmZ96DtwEf3tuteOLeznu88P6OeybvncL7Du5FvCeZ
9QdzPOd64TyPuZNzqHD+dHO+D5r5eMj5Pijs73ed74MmPvHO90GzfiLP1ao/
2fk+aPIz2vk+aOLJey/vwf3hL+/hfIdYDHz4DmLFE+8gfBcRvofg3s57vPD+
jnsm750m/sXO7xsm/zHHc643689I5/cNs75hTuLcJJyXBjq/bwj7+zrn9w2z
H6FuqlU/8lyR92a+894Lnpr8bOr8vmHiyXcfTws+fFey4ml5r5Mq3uukivc6
qeK9Tqp4r5Mq3uukivc6qeK9Tqp4r5Mq3uukivc6qeK9Tqp4r5Mq3uuseKoV
z48+rv9unXGn5bVD4aOuR5dr0FuVLdu6JMn0Ga8XJ3n+LB1mb7S1nerQYQs8
Bk1dlSTBxr5a9wMMPdoVeuZBz1T3px/9q3OsfOWXeax7k3I9tuh+9XZPXZBF
xr5a9z9yzUnvsPa6LNzeq+6pL4p0wen3HlU/kS7+J1qVrjmfJGPebN9x9spS
ze0Wvmd+eIaEGPs6Gvs52A8w9Oh86AmCHvhJv01/cR7PN8/FeTzfPLfd+M51
d53P5arjYh6lzEy/LjX2JX1f8+2z0qjStWS5f6G+3DUgL6PyBv/n7+b+8/i/
IeRdsf9R8Z/dsgLTuWpo44NeB3xK5CWc1wbrKJy7BHITsH4F+eegt3KvcU57
6F8CXD6Ev3PhrzdwnAp/r8Ff8sMXuM0FbuAB+WLyAXFl/M34ch/xF+4jfoyn
MI4ri95z25maK4ser+fV48vmzdY3LxDgRfyEuH0xofj0k77n7BMbvND0fvcr
+v4Tn+ds/7hMgAtxEuITZujXudA/APrnA0esshTyzwLPJji3Hc4dC9xWwv5M
2P81+D0ZOBx2xkHnA4do7DOv/IDnO8CTOCP/hDiD3+S7kOfLgNtmwy8ZBL/A
G/JIyJ/PgNsSAzcZDdzAG/JIyJ9Q4LYB+vtCP3BR4GTi0xF8xSrv4lzmuR/s
nwP7icMK+EscUF9Yb4R1ZsHVLRHXU69J5KToalPG5cvqaSdc4nxzZMz+utuO
hybbB3rXmP9hvyL5su0n+ZN35cpqQ173Qn4V5MnzT6GfPEeeMG+E+YI8Yd4I
8wU8UPDC5AP8VNYb+gt+kC9Cnsx3rpMmT3yd67Zpp59z3TZxW+Fct819+KlW
PUeneTUKnHNSgufd+C0zp1yfCBngvW5DgjzVYM6IOn8dlFebrA0NnefQJrO9
w6IeJUgnY1/dsP8s9hMNPboSeqpDT5jH9IAx7xy1t05s32CLd7n+2OuPkMbu
FyT9bt+jHr9flHOz105p1b9E43fNmpYecEUCjzarPrb4uP1Cqwn2WZWl+o/V
HaeGPn1VbhryehbycZCH3fTDtB96eY6pfxn486PBB10HPuB//m7ujwev+hi8
0oXgFeoU65ZZr9bj+x3QvwZ6kJ+KfFXmKXis4LWSzxfg5znY/5uzv2r1F3Fi
3Mx4AXfGwUb8gS/xthFn+Em/bfQXdZZ118Z6izqiqCs21hPkoSIvbczHS4jr
pzi3Oc79B/gRAjt3wk7yz+oX+Ec+CnkIfpAvQp4gHoyPMC7oB+wPwr6Aeqeo
f2bdQx1R1BWznpDH2TjXjnOZJ1Y7kSfMG2G+MH+s++ABeSHkA3C0A1chnrBD
mQe0B/jagbcQZ0sdkCrqgFRRB6SKOmDa3/ae5+7T7Qvk/D/7H9mxNE4z5/t1
1+9uShvs13nl8b5kYP+bisZvXopKEn14Zt+22jlasnRa+s6gYrlg7GsM9gux
n1342XOlcpKrunu99VTR1nLJxL5rkbG+if2T+D4E+nKhJwX7qTg/G/sdjO8V
q7wOPamGP+IKPy7C/icMf7QT9i/Qr6N1602ZflOyGs2cOfiXK7pizPnYpL9y
JfyftyY3CcyX/W3XLPv8TpoO+e3wvexbefSfeJg4xDTKW+kRcJ2rVnpXPjsr
soB+KvxW+rvA74N6I+zJEvZ4vay7N23sEHW1VOKNfQ3Bfjj2L0DvYawV0H/s
2rp+4wZla3DHxDFzoi7qX4f67lw1soj+K/BQ4rDZ8Fcvw99F8DcMONwy9mUJ
9nEezxeei3gz/sK4I36MpzCOiJ8inmYcvwAOBwx/ZSv8VeAQif3vsZ8K/7HK
bdizEX6Vwf75sB/xVsTfjDt4zzww+Q/eK/JAyX/wg3wxeRJq4C4/IQ41fzbw
B44KXJV4JoBPWw1+6WDwKgLx2w891aEnPzRLbwzNkdVvv7vg4rmztkOzm3V1
FBeTN+SRyR/whjwS8qey24cdrqSd1C9rv9p5bOh52536zYZ28nAQd0UclPgD
d0UcTPxD6s4tTp1UoMGtdwb94XHK1vP54V1CLt4U8I98FPIQPCPvhHz70cBB
9iDPBgKHXcDhCPQ8gB7EVRFnM74Po6cveeKleJm4d02TAe0ces+n+Eyk999z
4coJv8Zn/iqfHU3t+v4Yh/pntL4RFZEo3hPdergO2G+vjO46ssMChx5Y/HVS
2fdJ0jCwtOHH+7fr/hpZHn8udui55bMD2qckCuT4nY3ykJMrs4zvKL/CwEfC
gE9f4IP42RFPZRyjjLjIPMTlAeLyH8h9jbhHQH4S/Hxg+K134C/9hN+mv76G
vNQ9bOB0F/KzDXmZDZymQx78sIMvQp4Qr7HAIdIZBwV+QhzADzv4IuTJWGf8
hXqAo4kr9Vy//vTmDbW2S9flPqtXfO2QdaOHFxyonSi1DX+U/t2mX/Cf/tGv
9gsjX0wrOKYtj7f2TJnokHmPbM92KUtg3jKPzfxFPOyIjzIu4KuCv0reIp+Z
38K8Rj4zv4V5jbjaEWdhfMF7RR6Y/N+FcxX6+0G/BTetAjclbnWdcdO7/x83
rQI3JW7gtx18V/Ic/ZL90+ybyE/mq5mn4K1Yecs41cf5PJd+WvOOfsJv01/y
ycpP8umZLAMnygNfBd4mzsQLvPsf34CXNY+Qn8xXufP/65LQX/gpVn5a6pJp
P+xWa1749R+9Jn/7Icnsu67xzZkO7b0qvYvLb4my3NjXDOy7Yx9y/M6U5/fW
fXxPfeLuvK/WffIGPDL9ir0V8ozbkw59pmf/mt4PkqR67is1X5uZKKOCX6u1
+zWHRh3Va35BceL/duMJnmsTpc/Sk7V6RUaLY/Z7rl3c/o5zt30tEwNPyvMP
3qndJCtKen3+n6+2DnNowdnsuI1jk2W8Ia9lkL8G+dcNeX0T8vmQh16eY+qH
Xp5j6t+2IbTGgU8cUn621e7sVjt1dKjLg85zTpj29YaeTGc92hR6bkLPsIy+
y2e5/+3P+M1bQx7F6Dq36A8+8TwhsJt+CO2H3fRDaP9QQ488NPTIN8569APo
yYCenrCnG/TkOfulHdIe+yWj4Bf8NH+nvzhPcb7yXPgl2fh9PfaJWyfop54C
9zpnD2z6l/1qxN4dB4c6tMHEPj8vWH1SXr4W8mTJqV3SvLwivc0oh1bz948v
8E8RyPE7G+UhJ9PwHeVrpoS977vgrF4cWL/yeu9ybeDT8OAve1Pk9xaLPZ6b
lqRd8mfuvp5WrocrNq2f0eGklD6a1KOs53G93Wt69e9bODQmcox3D0mRS8b3
8ijZ0OcCPfheFPqoB99LJvRRj29FxcKIRWd07OO1XF/sdHVQ52Mn5PChE1kV
ESd1rsuqQLf95eq5cY9bSl6y/BdUfjag
    "]],
  AutomaticImageSize->True,
  BoxRatios->{1, 1, 0.4},
  Boxed->False,
  ImageSize->{422.67884773465386`, 295.8911933868167},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-3, 3}, {-3, 3}, {-8.999997428571612, 8.999997428571612}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{2.3544330234662696`, 1.9036721632903193`, 1.5108532134939692`},
  ViewVertical->{0., 0., 1.}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.5646655653006363`*^9, {3.5646659389928284`*^9, 3.5646659816944895`*^9}, {
   3.564666016081738*^9, 3.5646660532325916`*^9}, {3.5646664515731797`*^9, 
   3.5646664942376437`*^9}, 3.5646665246880894`*^9, {3.5646667101639867`*^9, 
   3.5646667525308533`*^9}, 3.564666791176513*^9, {3.564666822492563*^9, 
   3.5646668744166403`*^9}, {3.5646669063994913`*^9, 
   3.5646669229083185`*^9}, {3.5646669855380173`*^9, 3.564667003821645*^9}, 
   3.564667049799317*^9, {3.5646670810737658`*^9, 3.5646670859149723`*^9}, 
   3.5646671591162887`*^9, {3.5646671990483475`*^9, 3.564667206901559*^9}, {
   3.564667287078472*^9, 3.5646673246521273`*^9}, {3.5646673599237795`*^9, 
   3.564667408573848*^9}}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyF20+o5lUZB/BxvJoQtEsKQlInAyFIWsfvpcicNAO37YRaSJNFbXSTm2lT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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3f4VcXRgM/ZK3YBC3YUUAFBRYXYC00BC4iAigWxYUWNFQuIvSCKijX2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         "]], PolygonBox[CompressedData["
1:eJwlkjkvRVEQgM+58zy7kNj3Z3/2/RFLK9ZCp1UoRPhpIsKjkCgoLI2tsCdI
CBGJXYNvMsWX+905586ZmXMj0wuT84FzLgohCMS5Vnj2zu1CAt4GL/gBRPEs
uMaPoQhvgjt8DRLxZnjAj+CP5C28P+FbUIvH4As/9HaWhx1vZ1bg6XDhLSZ4
I9ziezBHvhnIJfZIvYU80+Cctbi33PVw4u2MMjwFTvFNGMTHIU6OMPTgdWK1
fkM7niTW2yv04yOwxN4A8vAGuGFt1VvuSrFZ6RkRsZyaaxuSxXJqLq1JeykQ
q1V70lmVwIa3memsnNi3OjOdbQj2vc24Gu+CD2+xIWqKQY7O3Fltv4H1qjXq
3YXFZq13OMvaFNyzN5v4KHTDJ2vLxIfxPq0BX4ROvFzs7t4hFc8X6/3MWy1V
YnejNZXiHfDmracBfAxWyBWCDLxY7F+5hEy8RuzfuoIJvBd+8HX2/wO2cVFN

         "]]}]}, {}, {}, {}, {}}, 
    {GrayLevel[0], Thickness[Large], LineBox[CompressedData["
1:eJwt0E9KAgEYh+ExS63MPEHiAfIEua+tgf+tHGtjUBtFgqDCTbSpLpAnKMuy
sjqcz2CLh/c38A0Mkw/PS2exIAj2WSLaWXIUKLJHPba4udImDXuoB3TsIz3V
Pjc8MOKFMa+8MeGd0P2H3kbv02Pq+U6PGfDp+US/9JsZP/zyxzNP3HNNj7b7
rj7qIWH0Pdqibje0pLvssM0Wm2TYIM06a9Tcr+qlVknZF1ohaZc1oSssE///
j3PuHiGt
      "]], LineBox[CompressedData["
1:eJwl08lLVWEYB+DjvZVTZWlgg1baPJfllE3mkEOpadrgJqQ5SIKiFkFBQYKB
btrbTGD/QAvbFOWiRS3CRUI7q4V/QDQ9Ly4efu/7ft8599zv3FvS1995JSNJ
kvdcTiXJD9klfxn+piKdJK3pmfVB83r1AzllrVp26odlgxyS4/YdVu+lQJ/F
E36an5PnOchcnvHRvEfeZKdrllPMVjJZTxUlJGzjn70r5S5uqK8zafmFPGFW
LwtkB3885259tbqNz/aN6A+pH8lsKjimfygb5Sd7jsh9wWwRb9wnX1+nnsdz
vtrXJy+y0NoGsigjm41Uso457GA2a1nABded5pT6OLXqPHlNtseeOFf2qz/4
rPvqOvWAnPY8ZbJLfy/OVN6V7+xrUe+Jd6DP53WcQczUOfFdeWtfu+yI72Ot
lAy2k2IVOazgrz2bZCGLyeWMWS8n1d3UqF9yKX4b7v1YZsa5UGO9mTHzXnmA
W+bfPFeVPKq/I2vl7Thr+0Zlk/5VvBMK+W5eKVviTMilmy/xvmRb/K5cs5Ql
bCbNaspZwyy2sIwi5nPVdf1MuM9T2RPPKM/Smpr5X/wHMA1JZA==
      "]]}}],
  AspectRatio->1,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5646655653006363`*^9, {3.5646659389928284`*^9, 3.5646659816944895`*^9}, {
   3.564666016081738*^9, 3.5646660532325916`*^9}, {3.5646664515731797`*^9, 
   3.5646664942376437`*^9}, 3.5646665246880894`*^9, {3.5646667101639867`*^9, 
   3.5646667525308533`*^9}, 3.564666791176513*^9, {3.564666822492563*^9, 
   3.5646668744166403`*^9}, {3.5646669063994913`*^9, 
   3.5646669229083185`*^9}, {3.5646669855380173`*^9, 3.564667003821645*^9}, 
   3.564667049799317*^9, {3.5646670810737658`*^9, 3.5646670859149723`*^9}, 
   3.5646671591162887`*^9, {3.5646671990483475`*^9, 3.564667206901559*^9}, {
   3.564667287078472*^9, 3.5646673246521273`*^9}, {3.5646673599237795`*^9, 
   3.5646673971730313`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{920, 630},
WindowMargins->{{Automatic, 88}, {52, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 397, 8, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1695, 48, 2912, 68, 152, "Input"],
Cell[4610, 118, 31152, 524, 307, "Output"],
Cell[35765, 644, 25408, 426, 375, "Output"],
Cell[61176, 1072, 17718, 301, 311, "Output"],
Cell[78897, 1375, 15829, 268, 375, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
