(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    518541,       8954]
NotebookOptionsPosition[    517916,       8930]
NotebookOutlinePosition[    518260,       8945]
CellTagsIndexPosition[    518217,       8942]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Vector field visualization",
  FontWeight->"Bold"],
 "\nSome example of vector field visualization using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ".\n\nSeveral sample functions are given or choose your own."
}], "Subsubtitle",
 CellChangeTimes->{
  3.5847294059547358`*^9, {3.5847300089455795`*^9, 3.58473004506563*^9}, {
   3.5849687973485146`*^9, 3.584968859467823*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", " ", "Function"}]}]}]}], " ", 
     RowBox[{
      RowBox[{
       RowBox[{"selection", " ", "--"}], "--"}], "--"}]}], "-"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"More", " ", "example", " ", 
    RowBox[{"functions", ":", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "y"}]}], "}"}], "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "y"}], ",", "x"}], "}"}], "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "^", "2"}], ",", "0"}], "}"}]}]}]}], " ", 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"myfct", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "y"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d1", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"myfct", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"VectorPlot", "[", 
    RowBox[{
     RowBox[{"myfct", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"VectorStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "\"\<Disk\>\""}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"VectorDensityPlot", "[", 
    RowBox[{
     RowBox[{"myfct", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"StreamDensityPlot", "[", 
    RowBox[{
     RowBox[{"myfct", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d1", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"d2", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<ThermometerColors\>\""}]}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584729417854752*^9, 3.5847294202047553`*^9}, {
  3.584729482144842*^9, 3.584729491204855*^9}, {3.5847295386449213`*^9, 
  3.5847297003551474`*^9}, {3.584729747785214*^9, 3.5847297633252354`*^9}, {
  3.584729859765371*^9, 3.584729941655485*^9}, {3.5847299724855285`*^9, 
  3.584729984765546*^9}, {3.5847300602556515`*^9, 3.584730155135784*^9}, {
  3.584968862088628*^9, 3.584968874069449*^9}, {3.584968906969907*^9, 
  3.58496890873271*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    {Arrowheads[{{0.045873685240266346`, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -3.2142857142857144`}, \
{-3.2142857142857144`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.042722834164836215`, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -2.7551020408163267`}, \
{-3.2142857142857144`, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.03986267624374094, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -2.295918367346939}, \
{-3.2142857142857144`, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.037360034692631945`, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -1.8367346938775515`}, \
{-3.2142857142857144`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.03529105076134969, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -1.3775510204081636`}, \
{-3.2142857142857144`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.033735606888416904`, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -0.9183673469387759}, \
{-3.2142857142857144`, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.03276691802876167, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -0.4591836734693881}, \
{-3.2142857142857144`, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.03243759391140957, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, -3.5685740077237176`*^-16}, \
{-3.2142857142857144`, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.03276691802876167, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 
      0.4591836734693874}, {-3.2142857142857144`, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.0337356068884169, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 
      0.9183673469387751}, {-3.2142857142857144`, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.03529105076134969, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 
      1.377551020408163}, {-3.2142857142857144`, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.03736003469263194, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 
      1.8367346938775506`}, {-3.2142857142857144`, 1.5918367346938773`}}]}, 
    {Arrowheads[{{0.03986267624374092, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 
      2.295918367346938}, {-3.2142857142857144`, 1.9897959183673466`}}]}, 
    {Arrowheads[{{0.04272283416483619, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 2.755102040816326}, {-3.214285714285714,
       2.3877551020408156`}}]}, 
    {Arrowheads[{{0.04587368524026632, 1.}}], 
     ArrowBox[{{-2.7857142857142856`, 
      3.2142857142857135`}, {-3.2142857142857144`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.042722834164836215`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -3.2142857142857144`}, \
{-2.7551020408163267`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.03932030163451398, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -2.7551020408163267`}, \
{-2.7551020408163267`, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.036192243904825436`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -2.295918367346939}, \
{-2.7551020408163267`, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.03341583088579017, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -1.8367346938775513`}, \
{-2.7551020408163267`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.031085427862476447`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -1.3775510204081636`}, \
{-2.7551020408163267`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.029307622450189818`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -0.9183673469387759}, \
{-2.755102040816327, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.028187168688193095`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -0.4591836734693881}, \
{-2.7551020408163267`, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.027803651924065326`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, -3.5685740077237176`*^-16}, \
{-2.7551020408163267`, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.02818716868819309, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      0.4591836734693874}, {-2.7551020408163267`, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.029307622450189818`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      0.9183673469387751}, {-2.755102040816327, 0.7959183673469383}}]}, 
    {Arrowheads[{{0.031085427862476447`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      1.377551020408163}, {-2.7551020408163267`, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.033415830885790185`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      1.8367346938775506`}, {-2.7551020408163267`, 1.591836734693877}}]}, 
    {Arrowheads[{{0.036192243904825436`, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      2.295918367346938}, {-2.7551020408163267`, 1.9897959183673464`}}]}, 
    {Arrowheads[{{0.03932030163451398, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      2.755102040816326}, {-2.7551020408163267`, 2.3877551020408156`}}]}, 
    {Arrowheads[{{0.04272283416483619, 1.}}], 
     ArrowBox[{{-2.3877551020408165`, 
      3.2142857142857135`}, {-2.7551020408163267`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.03986267624374095, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -3.2142857142857144`}, \
{-2.2959183673469394`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.036192243904825436`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -2.7551020408163267`}, \
{-2.295918367346939, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.032766918028761645`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -2.295918367346939}, \
{-2.295918367346939, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.029671706254021542`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -1.8367346938775513`}, \
{-2.2959183673469394`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.027020292811708004`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -1.3775510204081636`}, \
{-2.2959183673469394`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.024954541308549048`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -0.9183673469387759}, \
{-2.2959183673469394`, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.023628560618325106`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -0.4591836734693881}, \
{-2.295918367346939, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.0231697099367211, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, -3.5685740077237176`*^-16}, \
{-2.295918367346939, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.023628560618325106`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 
      0.4591836734693874}, {-2.295918367346939, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.024954541308549013`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 
      0.9183673469387751}, {-2.295918367346939, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.027020292811708004`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 
      1.377551020408163}, {-2.2959183673469394`, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.02967170625402155, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 
      1.8367346938775506`}, {-2.2959183673469394`, 1.591836734693877}}]}, 
    {Arrowheads[{{0.03276691802876163, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 2.295918367346938}, {-2.295918367346939,
       1.9897959183673466`}}]}, 
    {Arrowheads[{{0.036192243904825436`, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 2.755102040816326}, {-2.295918367346939,
       2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03986267624374092, 1.}}], 
     ArrowBox[{{-1.9897959183673473`, 
      3.2142857142857135`}, {-2.2959183673469394`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.037360034692631945`, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, -3.2142857142857144`}, \
{-1.8367346938775513`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.03341583088579017, 1.}}], 
     ArrowBox[{{-1.591836734693878, -2.7551020408163267`}, \
{-1.8367346938775513`, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.02967170625402151, 1.}}], 
     ArrowBox[{{-1.591836734693878, -2.295918367346939}, \
{-1.8367346938775513`, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.02621353442300933, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, -1.8367346938775515`}, \
{-1.8367346938775513`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, -1.3775510204081636`}, \
{-1.8367346938775513`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.020723618574984302`, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, -0.9183673469387759}, \
{-1.8367346938775513`, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.019106232276804847`, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, -0.4591836734693881}, \
{-1.8367346938775513`, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.018535767949376888`, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, -3.5685740077237176`*^-16}, \
{-1.8367346938775513`, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.01910623227680484, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      0.4591836734693874}, {-1.8367346938775513`, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.0207236185749843, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      0.9183673469387751}, {-1.8367346938775513`, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      1.377551020408163}, {-1.8367346938775513`, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.02621353442300933, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      1.8367346938775506`}, {-1.8367346938775513`, 1.591836734693877}}]}, 
    {Arrowheads[{{0.02967170625402151, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      2.295918367346938}, {-1.8367346938775513`, 1.9897959183673466`}}]}, 
    {Arrowheads[{{0.033415830885790185`, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      2.755102040816326}, {-1.8367346938775513`, 2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03736003469263192, 1.}}], 
     ArrowBox[{{-1.5918367346938778`, 
      3.2142857142857135`}, {-1.8367346938775513`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.03529105076134969, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -3.2142857142857144`}, \
{-1.3775510204081636`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.031085427862476447`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -2.7551020408163267`}, \
{-1.3775510204081636`, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.027020292811707976`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -2.295918367346939}, \
{-1.3775510204081636`, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -1.8367346938775515`}, \
{-1.3775510204081636`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.01966015081725699, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -1.3775510204081636`}, \
{-1.3775510204081636`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.016707915442895092`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -0.9183673469387759}, \
{-1.3775510204081636`, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.014653811225094895`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -0.4591836734693881}, \
{-1.3775510204081636`, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.013901825962032663`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, -3.5685740077237176`*^-16}, \
{-1.3775510204081636`, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.014653811225094892`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      0.4591836734693874}, {-1.3775510204081636`, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.016707915442895085`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      0.9183673469387751}, {-1.3775510204081636`, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.01966015081725699, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      1.377551020408163}, {-1.3775510204081636`, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      1.8367346938775506`}, {-1.3775510204081636`, 1.591836734693877}}]}, 
    {Arrowheads[{{0.027020292811707966`, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      2.295918367346938}, {-1.3775510204081636`, 1.9897959183673466`}}]}, 
    {Arrowheads[{{0.03108542786247645, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      2.755102040816326}, {-1.3775510204081638`, 2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03529105076134966, 1.}}], 
     ArrowBox[{{-1.1938775510204085`, 
      3.2142857142857135`}, {-1.3775510204081636`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.033735606888416904`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -3.2142857142857144`}, \
{-0.9183673469387758, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.029307622450189818`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -2.7551020408163267`}, \
{-0.9183673469387758, -2.387755102040816}}]}, 
    {Arrowheads[{{0.024954541308549016`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -2.295918367346939}, \
{-0.9183673469387758, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.020723618574984302`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -1.8367346938775515`}, \
{-0.9183673469387758, -1.591836734693878}}]}, 
    {Arrowheads[{{0.016707915442895092`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -1.3775510204081636`}, \
{-0.9183673469387758, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.013106767211504665`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -0.9183673469387759}, \
{-0.9183673469387758, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.010361809287492153`, 1.}}], 
     ArrowBox[{{-0.795918367346939, -0.4591836734693881}, \
{-0.9183673469387758, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.009267883974688444, 1.}}], 
     ArrowBox[{{-0.795918367346939, -3.5685740077237176`*^-16}, \
{-0.9183673469387758, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.01036180928749215, 1.}}], 
     ArrowBox[{{-0.795918367346939, 0.4591836734693874}, {-0.9183673469387758,
       0.39795918367346905`}}]}, 
    {Arrowheads[{{0.01310676721150466, 1.}}], 
     ArrowBox[{{-0.795918367346939, 0.9183673469387751}, {-0.9183673469387758,
       0.7959183673469384}}]}, 
    {Arrowheads[{{0.016707915442895092`, 1.}}], 
     ArrowBox[{{-0.795918367346939, 1.377551020408163}, {-0.9183673469387758, 
      1.1938775510204078`}}]}, 
    {Arrowheads[{{0.020723618574984302`, 1.}}], 
     ArrowBox[{{-0.795918367346939, 
      1.8367346938775506`}, {-0.9183673469387758, 1.591836734693877}}]}, 
    {Arrowheads[{{0.024954541308549016`, 1.}}], 
     ArrowBox[{{-0.795918367346939, 2.295918367346938}, {-0.9183673469387758, 
      1.9897959183673464`}}]}, 
    {Arrowheads[{{0.029307622450189787`, 1.}}], 
     ArrowBox[{{-0.795918367346939, 2.755102040816326}, {-0.9183673469387758, 
      2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03373560688841687, 1.}}], 
     ArrowBox[{{-0.795918367346939, 
      3.2142857142857135`}, {-0.9183673469387758, 2.785714285714285}}]}, 
    {Arrowheads[{{0.03276691802876167, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -3.2142857142857144`}, \
{-0.4591836734693881, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.028187168688193095`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -2.7551020408163267`}, \
{-0.4591836734693881, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.02362856061832514, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -2.2959183673469394`}, \
{-0.4591836734693881, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.019106232276804847`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -1.8367346938775515`}, \
{-0.4591836734693881, -1.591836734693878}}]}, 
    {Arrowheads[{{0.014653811225094895`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -1.3775510204081636`}, \
{-0.4591836734693881, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.010361809287492153`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -0.9183673469387759}, \
{-0.4591836734693881, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.0065533836057523375`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -0.4591836734693881}, \
{-0.4591836734693881, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.004633941987344226, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, -3.5685740077237176`*^-16}, \
{-0.4591836734693881, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.006553383605752332, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      0.4591836734693874}, {-0.4591836734693881, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.010361809287492144`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      0.9183673469387751}, {-0.4591836734693881, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.014653811225094895`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      1.377551020408163}, {-0.4591836734693881, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.019106232276804847`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      1.8367346938775506`}, {-0.4591836734693881, 1.591836734693877}}]}, 
    {Arrowheads[{{0.023628560618325106`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      2.295918367346938}, {-0.4591836734693881, 1.9897959183673464`}}]}, 
    {Arrowheads[{{0.028187168688193095`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      2.755102040816326}, {-0.4591836734693881, 2.3877551020408156`}}]}, 
    {Arrowheads[{{0.032766918028761645`, 1.}}], 
     ArrowBox[{{-0.39795918367346966`, 
      3.2142857142857135`}, {-0.4591836734693881, 2.785714285714285}}]}, 
    {Arrowheads[{{0.03243759391140957, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -3.2142857142857144`}, \
{-3.5685740077237176`*^-16, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.027803651924065326`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -2.7551020408163267`}, \
{-3.5685740077237176`*^-16, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.0231697099367211, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -2.295918367346939}, \
{-3.5685740077237176`*^-16, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.018535767949376888`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -1.8367346938775515`}, \
{-3.5685740077237176`*^-16, -1.591836734693878}}]}, 
    {Arrowheads[{{0.013901825962032663`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -1.3775510204081636`}, \
{-3.5685740077237176`*^-16, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.009267883974688444, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -0.9183673469387759}, \
{-3.5685740077237176`*^-16, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.004633941987344226, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, -0.4591836734693881}, \
{-3.5685740077237176`*^-16, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.0046339419873442185`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      0.4591836734693874}, {-3.5685740077237176`*^-16, 
      0.39795918367346905`}}]}, 
    {Arrowheads[{{0.009267883974688437, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      0.9183673469387751}, {-3.5685740077237176`*^-16, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.013901825962032663`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      1.377551020408163}, {-3.5685740077237176`*^-16, 1.1938775510204078`}}]}, 
    {Arrowheads[{{0.018535767949376888`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      1.8367346938775506`}, {-3.5685740077237176`*^-16, 1.591836734693877}}]}, 
    {Arrowheads[{{0.023169709936721083`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      2.295918367346938}, {-3.5685740077237176`*^-16, 1.9897959183673466`}}]}, 
    {Arrowheads[{{0.027803651924065326`, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      2.755102040816326}, {-3.5685740077237176`*^-16, 2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03243759391140954, 1.}}], 
     ArrowBox[{{-3.0927641400272217`*^-16, 
      3.2142857142857135`}, {-3.5685740077237176`*^-16, 2.785714285714285}}]}, 
    {Arrowheads[{{0.03276691802876167, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -3.2142857142857144`}, {
      0.4591836734693874, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.02818716868819309, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -2.7551020408163267`}, {
      0.4591836734693874, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.02362856061832514, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -2.2959183673469394`}, {
      0.4591836734693874, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.01910623227680484, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -1.8367346938775515`}, {
      0.4591836734693874, -1.591836734693878}}]}, 
    {Arrowheads[{{0.014653811225094892`, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -1.3775510204081636`}, {
      0.4591836734693874, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.01036180928749215, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -0.9183673469387759}, {
      0.4591836734693874, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.006553383605752332, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -0.4591836734693881}, {
      0.4591836734693874, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.0046339419873442185`, 1.}}], 
     ArrowBox[{{0.39795918367346905`, -3.5685740077237176`*^-16}, {
      0.4591836734693874, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.006553383605752326, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 0.4591836734693874}, {
      0.4591836734693874, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.010361809287492143`, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 0.9183673469387751}, {
      0.4591836734693874, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.014653811225094892`, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 1.377551020408163}, {0.4591836734693874,
       1.1938775510204078`}}]}, 
    {Arrowheads[{{0.01910623227680484, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 1.8367346938775506`}, {
      0.4591836734693874, 1.591836734693877}}]}, 
    {Arrowheads[{{0.023628560618325106`, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 2.295918367346938}, {0.4591836734693874,
       1.9897959183673464`}}]}, 
    {Arrowheads[{{0.02818716868819309, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 2.755102040816326}, {0.4591836734693874,
       2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03276691802876164, 1.}}], 
     ArrowBox[{{0.39795918367346905`, 3.2142857142857135`}, {
      0.4591836734693874, 2.785714285714285}}]}, 
    {Arrowheads[{{0.0337356068884169, 1.}}], 
     ArrowBox[{{0.7959183673469384, -3.2142857142857144`}, {
      0.9183673469387751, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.029307622450189818`, 1.}}], 
     ArrowBox[{{0.7959183673469384, -2.7551020408163267`}, {
      0.9183673469387752, -2.387755102040816}}]}, 
    {Arrowheads[{{0.024954541308549013`, 1.}}], 
     ArrowBox[{{0.7959183673469384, -2.295918367346939}, {
      0.9183673469387751, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.0207236185749843, 1.}}], 
     ArrowBox[{{0.7959183673469384, -1.8367346938775515`}, {
      0.9183673469387751, -1.591836734693878}}]}, 
    {Arrowheads[{{0.016707915442895085`, 1.}}], 
     ArrowBox[{{0.7959183673469384, -1.3775510204081636`}, {
      0.9183673469387751, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.01310676721150466, 1.}}], 
     ArrowBox[{{0.7959183673469384, -0.9183673469387759}, {
      0.9183673469387751, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.010361809287492144`, 1.}}], 
     ArrowBox[{{0.7959183673469384, -0.4591836734693881}, {
      0.9183673469387751, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.009267883974688437, 1.}}], 
     ArrowBox[{{0.7959183673469384, -3.5685740077237176`*^-16}, {
      0.9183673469387751, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.010361809287492143`, 1.}}], 
     ArrowBox[{{0.7959183673469384, 0.4591836734693874}, {0.9183673469387751, 
      0.39795918367346905`}}]}, 
    {Arrowheads[{{0.013106767211504652`, 1.}}], 
     ArrowBox[{{0.7959183673469384, 0.9183673469387751}, {0.9183673469387751, 
      0.7959183673469384}}]}, 
    {Arrowheads[{{0.016707915442895085`, 1.}}], 
     ArrowBox[{{0.7959183673469384, 1.377551020408163}, {0.9183673469387751, 
      1.1938775510204078`}}]}, 
    {Arrowheads[{{0.0207236185749843, 1.}}], 
     ArrowBox[{{0.7959183673469384, 1.8367346938775506`}, {0.9183673469387751,
       1.591836734693877}}]}, 
    {Arrowheads[{{0.024954541308549013`, 1.}}], 
     ArrowBox[{{0.7959183673469384, 2.295918367346938}, {0.9183673469387751, 
      1.9897959183673464`}}]}, 
    {Arrowheads[{{0.029307622450189783`, 1.}}], 
     ArrowBox[{{0.7959183673469384, 2.755102040816326}, {0.9183673469387751, 
      2.3877551020408156`}}]}, 
    {Arrowheads[{{0.033735606888416904`, 1.}}], 
     ArrowBox[{{0.7959183673469384, 3.2142857142857135`}, {0.9183673469387752,
       2.7857142857142847`}}]}, 
    {Arrowheads[{{0.03529105076134969, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -3.2142857142857144`}, {
      1.377551020408163, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.031085427862476447`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -2.7551020408163267`}, {
      1.377551020408163, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.027020292811707976`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -2.295918367346939}, {
      1.377551020408163, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -1.8367346938775515`}, {
      1.377551020408163, -1.591836734693878}}]}, 
    {Arrowheads[{{0.01966015081725699, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -1.3775510204081636`}, {
      1.377551020408163, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.016707915442895092`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -0.9183673469387759}, {
      1.377551020408163, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.014653811225094895`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -0.4591836734693881}, {
      1.377551020408163, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.013901825962032663`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, -3.5685740077237176`*^-16}, {
      1.377551020408163, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.014653811225094892`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 0.4591836734693874}, {1.377551020408163, 
      0.39795918367346905`}}]}, 
    {Arrowheads[{{0.016707915442895085`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 0.9183673469387751}, {1.377551020408163, 
      0.7959183673469384}}]}, 
    {Arrowheads[{{0.01966015081725699, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 1.377551020408163}, {1.377551020408163, 
      1.1938775510204078`}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 1.8367346938775506`}, {1.377551020408163,
       1.591836734693877}}]}, 
    {Arrowheads[{{0.027020292811707976`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 2.295918367346938}, {1.377551020408163, 
      1.9897959183673464`}}]}, 
    {Arrowheads[{{0.031085427862476447`, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 2.755102040816326}, {1.377551020408163, 
      2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03529105076134966, 1.}}], 
     ArrowBox[{{1.1938775510204078`, 3.2142857142857135`}, {1.377551020408163,
       2.785714285714285}}]}, 
    {Arrowheads[{{0.03736003469263194, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -3.2142857142857144`}, {
      1.8367346938775506`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.033415830885790185`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -2.7551020408163267`}, {
      1.8367346938775508`, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.029671706254021525`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -2.295918367346939}, {
      1.8367346938775508`, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.02621353442300933, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -1.8367346938775515`}, {
      1.8367346938775508`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -1.3775510204081636`}, {
      1.8367346938775508`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.020723618574984302`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -0.9183673469387759}, {
      1.8367346938775508`, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.019106232276804847`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -0.4591836734693881}, {
      1.8367346938775508`, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.018535767949376888`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, -3.5685740077237176`*^-16}, {
      1.8367346938775508`, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.01910623227680484, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 0.4591836734693874}, {
      1.8367346938775508`, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.0207236185749843, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 0.9183673469387751}, {
      1.8367346938775508`, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.02316970993672111, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 1.377551020408163}, {1.8367346938775508`,
       1.1938775510204078`}}]}, 
    {Arrowheads[{{0.02621353442300933, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 1.8367346938775506`}, {
      1.8367346938775508`, 1.591836734693877}}]}, 
    {Arrowheads[{{0.029671706254021525`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 2.295918367346938}, {1.8367346938775508`,
       1.9897959183673464`}}]}, 
    {Arrowheads[{{0.033415830885790185`, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 2.755102040816326}, {1.8367346938775508`,
       2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03736003469263192, 1.}}], 
     ArrowBox[{{1.5918367346938773`, 3.2142857142857135`}, {
      1.8367346938775508`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.03986267624374095, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -3.2142857142857144`}, {
      2.2959183673469385`, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.03619224390482546, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -2.7551020408163267`}, {
      2.2959183673469385`, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.03276691802876169, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -2.2959183673469394`}, {
      2.2959183673469385`, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.02967170625402155, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -1.8367346938775515`}, {
      2.2959183673469385`, -1.591836734693878}}]}, 
    {Arrowheads[{{0.027020292811708004`, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -1.3775510204081636`}, {
      2.2959183673469385`, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.024954541308549048`, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -0.9183673469387759}, {
      2.2959183673469385`, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.02362856061832514, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -0.4591836734693881}, {
      2.2959183673469385`, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.02316970993672113, 1.}}], 
     ArrowBox[{{1.9897959183673464`, -3.5685740077237176`*^-16}, {
      2.2959183673469385`, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.02362856061832514, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 0.4591836734693874}, {
      2.2959183673469385`, 0.39795918367346905`}}]}, 
    {Arrowheads[{{0.024954541308549048`, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 0.9183673469387751}, {
      2.2959183673469385`, 0.7959183673469384}}]}, 
    {Arrowheads[{{0.027020292811708004`, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 1.377551020408163}, {2.2959183673469385`,
       1.1938775510204078`}}]}, 
    {Arrowheads[{{0.02967170625402155, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 1.8367346938775506`}, {
      2.2959183673469385`, 1.591836734693877}}]}, 
    {Arrowheads[{{0.03276691802876165, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 2.295918367346938}, {2.2959183673469385`,
       1.9897959183673466`}}]}, 
    {Arrowheads[{{0.03619224390482546, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 2.755102040816326}, {2.2959183673469385`,
       2.3877551020408156`}}]}, 
    {Arrowheads[{{0.03986267624374092, 1.}}], 
     ArrowBox[{{1.9897959183673464`, 3.2142857142857135`}, {
      2.2959183673469385`, 2.785714285714285}}]}, 
    {Arrowheads[{{0.04272283416483619, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -3.2142857142857144`}, {
      2.755102040816326, -2.785714285714286}}]}, 
    {Arrowheads[{{0.03932030163451398, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -2.7551020408163267`}, {
      2.755102040816326, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.036192243904825436`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -2.295918367346939}, {
      2.755102040816326, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.033415830885790185`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -1.8367346938775515`}, {
      2.755102040816326, -1.591836734693878}}]}, 
    {Arrowheads[{{0.03108542786247645, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -1.3775510204081636`}, {
      2.755102040816326, -1.1938775510204083`}}]}, 
    {Arrowheads[{{0.029307622450189787`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -0.9183673469387759}, {
      2.755102040816326, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.028187168688193095`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -0.4591836734693881}, {
      2.755102040816326, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.027803651924065326`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, -3.5685740077237176`*^-16}, {
      2.755102040816326, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.02818716868819309, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 0.4591836734693874}, {2.755102040816326, 
      0.39795918367346905`}}]}, 
    {Arrowheads[{{0.029307622450189783`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 0.9183673469387751}, {2.755102040816326, 
      0.7959183673469384}}]}, 
    {Arrowheads[{{0.031085427862476447`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 1.377551020408163}, {2.755102040816326, 
      1.1938775510204078`}}]}, 
    {Arrowheads[{{0.033415830885790185`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 1.8367346938775506`}, {2.755102040816326,
       1.591836734693877}}]}, 
    {Arrowheads[{{0.036192243904825436`, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 2.295918367346938}, {2.755102040816326, 
      1.9897959183673464`}}]}, 
    {Arrowheads[{{0.03932030163451398, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 2.755102040816326}, {2.755102040816326, 
      2.3877551020408156`}}]}, 
    {Arrowheads[{{0.04272283416483619, 1.}}], 
     ArrowBox[{{2.3877551020408156`, 3.2142857142857135`}, {2.755102040816326,
       2.785714285714285}}]}, 
    {Arrowheads[{{0.04587368524026632, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -3.2142857142857144`}, {
      3.214285714285713, -2.7857142857142856`}}]}, 
    {Arrowheads[{{0.04272283416483619, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -2.7551020408163267`}, {
      3.214285714285713, -2.3877551020408165`}}]}, 
    {Arrowheads[{{0.0398626762437409, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -2.295918367346939}, {
      3.214285714285713, -1.9897959183673473`}}]}, 
    {Arrowheads[{{0.03736003469263192, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -1.8367346938775515`}, {
      3.214285714285713, -1.591836734693878}}]}, 
    {Arrowheads[{{0.03529105076134966, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -1.3775510204081636`}, {
      3.214285714285713, -1.1938775510204085`}}]}, 
    {Arrowheads[{{0.03373560688841687, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -0.9183673469387759}, {
      3.214285714285713, -0.7959183673469391}}]}, 
    {Arrowheads[{{0.032766918028761645`, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -0.4591836734693881}, {
      3.214285714285713, -0.39795918367346966`}}]}, 
    {Arrowheads[{{0.03243759391140954, 1.}}], 
     ArrowBox[{{2.7857142857142847`, -3.5685740077237176`*^-16}, {
      3.214285714285713, -3.0927641400272217`*^-16}}]}, 
    {Arrowheads[{{0.03276691802876164, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 0.4591836734693874}, {3.214285714285713, 
      0.39795918367346905`}}]}, 
    {Arrowheads[{{0.033735606888416904`, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 0.9183673469387751}, {
      3.2142857142857135`, 0.7959183673469383}}]}, 
    {Arrowheads[{{0.03529105076134966, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 1.377551020408163}, {3.214285714285713, 
      1.1938775510204078`}}]}, 
    {Arrowheads[{{0.03736003469263192, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 1.8367346938775506`}, {3.214285714285713,
       1.591836734693877}}]}, 
    {Arrowheads[{{0.0398626762437409, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 2.295918367346938}, {3.214285714285713, 
      1.9897959183673464`}}]}, 
    {Arrowheads[{{0.04272283416483619, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 2.755102040816326}, {3.214285714285713, 
      2.3877551020408156`}}]}, 
    {Arrowheads[{{0.0458736852402663, 1.}}], 
     ArrowBox[{{2.7857142857142847`, 3.2142857142857135`}, {3.214285714285713,
       2.785714285714285}}]}}},
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-3.303045763365663, 3.303045763365663}, {-3.303045763365663, 
   3.303045763365663}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.584729819995315*^9, {3.584729861585373*^9, 3.584729889925413*^9}, 
   3.58472993814548*^9, 3.5847299874655495`*^9, {3.5847301255757427`*^9, 
   3.584730156365786*^9}, 3.5849687741980734`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {GrayLevel[0], DiskBox[{-3., -3.}, 0.3030457633656634], 
    DiskBox[{-3., -2.5714285714285716`}, 0.2822309527742721], 
    DiskBox[{-3., -2.1428571428571432`}, 0.2633364877666111], 
    DiskBox[{-3., -1.7142857142857149`}, 0.2468038086213843], 
    DiskBox[{-3., -1.285714285714286}, 0.2331359114039973], 
    DiskBox[{-3., -0.8571428571428574}, 0.22286050681470987`], 
    DiskBox[{-3., -0.4285714285714289}, 0.21646125954690243`], 
    DiskBox[{-3., -3.3306690738754696`*^-16}, 0.2142857142857144], 
    DiskBox[{-3., 0.4285714285714282}, 0.2164612595469024], 
    DiskBox[{-3., 0.8571428571428568}, 0.22286050681470984`], 
    DiskBox[{-3., 1.2857142857142854`}, 0.2331359114039973], 
    DiskBox[{-3., 1.714285714285714}, 0.24680380862138424`], 
    DiskBox[{-3., 2.1428571428571423`}, 0.26333648776661106`], 
    DiskBox[{-3., 2.5714285714285707`}, 0.28223095277427196`], 
    DiskBox[{-3., 2.999999999999999}, 0.30304576336566325`], 
    DiskBox[{-2.5714285714285716`, -3.}, 0.2822309527742721], 
    DiskBox[{-2.5714285714285716`, -2.5714285714285716`}, 0.2597535114562827],
     DiskBox[{-2.5714285714285716`, -2.1428571428571432`}, 
     0.2390892757930608], 
    DiskBox[{-2.5714285714285716`, -1.7142857142857146`}, 
     0.22074803727330541`], 
    DiskBox[{-2.5714285714285716`, -1.285714285714286}, 0.20535318160712354`],
     DiskBox[{-2.571428571428572, -0.8571428571428574}, 0.19360883633683976`],
     DiskBox[{-2.5714285714285716`, -0.4285714285714289}, 
     0.18620701623361896`], 
    DiskBox[{-2.5714285714285716`, -3.3306690738754696`*^-16}, 
     0.18367346938775508`], 
    DiskBox[{-2.5714285714285716`, 0.4285714285714282}, 0.18620701623361893`],
     DiskBox[{-2.571428571428572, 0.8571428571428568}, 0.19360883633683976`], 
    DiskBox[{-2.5714285714285716`, 1.2857142857142854`}, 
     0.20535318160712354`], 
    DiskBox[{-2.5714285714285716`, 1.714285714285714}, 0.22074803727330547`], 
    DiskBox[{-2.5714285714285716`, 2.1428571428571423`}, 0.2390892757930608], 
    DiskBox[{-2.5714285714285716`, 2.5714285714285707`}, 0.2597535114562827], 
    DiskBox[{-2.5714285714285716`, 2.999999999999999}, 0.28223095277427196`], 
    DiskBox[{-2.1428571428571432`, -3.}, 0.2633364877666112], 
    DiskBox[{-2.1428571428571432`, -2.5714285714285716`}, 0.2390892757930608],
     DiskBox[{-2.1428571428571432`, -2.1428571428571432`}, 
     0.21646125954690223`], 
    DiskBox[{-2.1428571428571432`, -1.7142857142857146`}, 0.1960140072683526],
     DiskBox[{-2.1428571428571432`, -1.285714285714286}, 0.1784985273932236], 
    DiskBox[{-2.1428571428571432`, -0.8571428571428574}, 
     0.16485198389187272`], 
    DiskBox[{-2.1428571428571432`, -0.4285714285714289}, 0.156092434089575], 
    DiskBox[{-2.1428571428571432`, -3.3306690738754696`*^-16}, 
     0.15306122448979587`], 
    DiskBox[{-2.1428571428571432`, 0.4285714285714282}, 0.156092434089575], 
    DiskBox[{-2.1428571428571432`, 0.8571428571428568}, 0.1648519838918725], 
    DiskBox[{-2.1428571428571432`, 1.2857142857142854`}, 0.1784985273932236], 
    DiskBox[{-2.1428571428571432`, 1.714285714285714}, 0.19601400726835266`], 
    DiskBox[{-2.1428571428571432`, 2.1428571428571423`}, 
     0.21646125954690215`], 
    DiskBox[{-2.1428571428571432`, 2.5714285714285707`}, 0.2390892757930608], 
    DiskBox[{-2.1428571428571432`, 2.999999999999999}, 0.26333648776661106`], 
    DiskBox[{-1.7142857142857144`, -3.}, 0.2468038086213843], 
    DiskBox[{-1.7142857142857146`, -2.5714285714285716`}, 
     0.22074803727330541`], 
    DiskBox[{-1.7142857142857146`, -2.1428571428571432`}, 0.1960140072683524],
     DiskBox[{-1.7142857142857144`, -1.7142857142857149`}, 
     0.17316900763752188`], 
    DiskBox[{-1.7142857142857144`, -1.285714285714286}, 0.15306122448979595`],
     DiskBox[{-1.7142857142857144`, -0.8571428571428574}, 
     0.13690212107141572`], 
    DiskBox[{-1.7142857142857144`, -0.4285714285714289}, 
     0.12621751915156107`], 
    DiskBox[{-1.7142857142857144`, -3.3306690738754696`*^-16}, 
     0.12244897959183676`], 
    DiskBox[{-1.7142857142857144`, 0.4285714285714282}, 0.12621751915156104`],
     DiskBox[{-1.7142857142857144`, 0.8571428571428568}, 0.1369021210714157], 
    DiskBox[{-1.7142857142857144`, 1.2857142857142854`}, 
     0.15306122448979595`], 
    DiskBox[{-1.7142857142857144`, 1.714285714285714}, 0.17316900763752188`], 
    DiskBox[{-1.7142857142857144`, 2.1428571428571423`}, 0.1960140072683524], 
    DiskBox[{-1.7142857142857144`, 2.5714285714285707`}, 
     0.22074803727330547`], 
    DiskBox[{-1.7142857142857144`, 2.999999999999999}, 0.2468038086213841], 
    DiskBox[{-1.285714285714286, -3.}, 0.2331359114039973], 
    DiskBox[{-1.285714285714286, -2.5714285714285716`}, 0.20535318160712354`],
     DiskBox[{-1.285714285714286, -2.1428571428571432`}, 
     0.17849852739322342`], 
    DiskBox[{-1.285714285714286, -1.7142857142857149`}, 0.15306122448979595`],
     DiskBox[{-1.285714285714286, -1.285714285714286}, 0.12987675572814136`], 
    DiskBox[{-1.285714285714286, -0.8571428571428574}, 0.11037401863665273`], 
    DiskBox[{-1.285714285714286, -0.4285714285714289}, 0.09680441816841978], 
    DiskBox[{-1.285714285714286, -3.3306690738754696`*^-16}, 
     0.09183673469387754], 
    DiskBox[{-1.285714285714286, 0.4285714285714282}, 0.09680441816841975], 
    DiskBox[{-1.285714285714286, 0.8571428571428568}, 0.11037401863665271`], 
    DiskBox[{-1.285714285714286, 1.2857142857142854`}, 0.12987675572814136`], 
    DiskBox[{-1.285714285714286, 1.714285714285714}, 0.15306122448979595`], 
    DiskBox[{-1.285714285714286, 2.1428571428571423`}, 0.17849852739322336`], 
    DiskBox[{-1.285714285714286, 2.5714285714285707`}, 0.20535318160712357`], 
    DiskBox[{-1.285714285714286, 2.999999999999999}, 0.23313591140399711`], 
    DiskBox[{-0.8571428571428574, -3.}, 0.22286050681470987`], 
    DiskBox[{-0.8571428571428574, -2.571428571428571}, 0.19360883633683976`], 
    DiskBox[{-0.8571428571428574, -2.1428571428571432`}, 
     0.16485198389187253`], 
    DiskBox[{-0.8571428571428574, -1.7142857142857149`}, 
     0.13690212107141572`], 
    DiskBox[{-0.8571428571428574, -1.285714285714286}, 0.11037401863665273`], 
    DiskBox[{-0.8571428571428574, -0.8571428571428574}, 0.08658450381876094], 
    DiskBox[{-0.8571428571428574, -0.4285714285714289}, 0.06845106053570787], 
    DiskBox[{-0.8571428571428574, -3.3306690738754696`*^-16}, 
     0.06122448979591838], 
    DiskBox[{-0.8571428571428574, 0.4285714285714282}, 0.06845106053570785], 
    DiskBox[{-0.8571428571428574, 0.8571428571428568}, 0.0865845038187609], 
    DiskBox[{-0.8571428571428574, 1.2857142857142854`}, 0.11037401863665273`],
     DiskBox[{-0.8571428571428574, 1.714285714285714}, 0.13690212107141572`], 
    DiskBox[{-0.8571428571428574, 2.1428571428571423`}, 0.16485198389187253`],
     DiskBox[{-0.8571428571428574, 2.5714285714285707`}, 
     0.19360883633683953`], 
    DiskBox[{-0.8571428571428574, 2.999999999999999}, 0.22286050681470965`], 
    DiskBox[{-0.4285714285714289, -3.}, 0.21646125954690243`], 
    DiskBox[{-0.4285714285714289, -2.5714285714285716`}, 
     0.18620701623361896`], 
    DiskBox[{-0.4285714285714289, -2.1428571428571432`}, 0.1560924340895752], 
    DiskBox[{-0.4285714285714289, -1.7142857142857149`}, 
     0.12621751915156107`], 
    DiskBox[{-0.4285714285714289, -1.285714285714286}, 0.09680441816841978], 
    DiskBox[{-0.4285714285714289, -0.8571428571428574}, 0.06845106053570787], 
    DiskBox[{-0.4285714285714289, -0.4285714285714289}, 
     0.043292251909380505`], 
    DiskBox[{-0.4285714285714289, -3.3306690738754696`*^-16}, 
     0.030612244897959218`], 
    DiskBox[{-0.4285714285714289, 0.4285714285714282}, 0.04329225190938047], 
    DiskBox[{-0.4285714285714289, 0.8571428571428568}, 0.06845106053570782], 
    DiskBox[{-0.4285714285714289, 1.2857142857142854`}, 0.09680441816841978], 
    DiskBox[{-0.4285714285714289, 1.714285714285714}, 0.12621751915156107`], 
    DiskBox[{-0.4285714285714289, 2.1428571428571423`}, 0.156092434089575], 
    DiskBox[{-0.4285714285714289, 2.5714285714285707`}, 0.18620701623361896`],
     DiskBox[{-0.4285714285714289, 2.999999999999999}, 0.21646125954690223`], 
    DiskBox[{-3.3306690738754696`*^-16, -3.}, 0.2142857142857144], 
    DiskBox[{-3.3306690738754696`*^-16, -2.5714285714285716`}, 
     0.18367346938775508`], 
    DiskBox[{-3.3306690738754696`*^-16, -2.1428571428571432`}, 
     0.15306122448979587`], 
    DiskBox[{-3.3306690738754696`*^-16, -1.7142857142857149`}, 
     0.12244897959183676`], 
    DiskBox[{-3.3306690738754696`*^-16, -1.285714285714286}, 
     0.09183673469387754], 
    DiskBox[{-3.3306690738754696`*^-16, -0.8571428571428574}, 
     0.06122448979591838], 
    DiskBox[{-3.3306690738754696`*^-16, -0.4285714285714289}, 
     0.030612244897959218`], 
    DiskBox[{-3.3306690738754696`*^-16, 0.4285714285714282}, 
     0.030612244897959162`], 
    DiskBox[{-3.3306690738754696`*^-16, 0.8571428571428568}, 
     0.061224489795918324`], 
    DiskBox[{-3.3306690738754696`*^-16, 1.2857142857142854`}, 
     0.09183673469387754], 
    DiskBox[{-3.3306690738754696`*^-16, 1.714285714285714}, 
     0.12244897959183676`], 
    DiskBox[{-3.3306690738754696`*^-16, 2.1428571428571423`}, 
     0.15306122448979576`], 
    DiskBox[{-3.3306690738754696`*^-16, 2.5714285714285707`}, 
     0.18367346938775508`], 
    DiskBox[{-3.3306690738754696`*^-16, 2.999999999999999}, 
     0.2142857142857142], 
    DiskBox[{0.4285714285714282, -3.}, 0.2164612595469024], 
    DiskBox[{0.4285714285714282, -2.5714285714285716`}, 0.18620701623361893`],
     DiskBox[{0.4285714285714282, -2.1428571428571432`}, 0.1560924340895752], 
    DiskBox[{0.4285714285714282, -1.7142857142857149`}, 0.12621751915156104`],
     DiskBox[{0.4285714285714282, -1.285714285714286}, 0.09680441816841975], 
    DiskBox[{0.4285714285714282, -0.8571428571428574}, 0.06845106053570785], 
    DiskBox[{0.4285714285714282, -0.4285714285714289}, 0.04329225190938047], 
    DiskBox[{0.4285714285714282, -3.3306690738754696`*^-16}, 
     0.030612244897959162`], 
    DiskBox[{0.4285714285714282, 0.4285714285714282}, 0.04329225190938043], 
    DiskBox[{0.4285714285714282, 0.8571428571428568}, 0.0684510605357078], 
    DiskBox[{0.4285714285714282, 1.2857142857142854`}, 0.09680441816841975], 
    DiskBox[{0.4285714285714282, 1.714285714285714}, 0.12621751915156104`], 
    DiskBox[{0.4285714285714282, 2.1428571428571423`}, 0.156092434089575], 
    DiskBox[{0.4285714285714282, 2.5714285714285707`}, 0.18620701623361893`], 
    DiskBox[{0.4285714285714282, 2.999999999999999}, 0.2164612595469022], 
    DiskBox[{0.8571428571428568, -3.}, 0.22286050681470984`], 
    DiskBox[{0.8571428571428568, -2.571428571428571}, 0.19360883633683976`], 
    DiskBox[{0.8571428571428568, -2.1428571428571432`}, 0.1648519838918725], 
    DiskBox[{0.8571428571428568, -1.7142857142857149`}, 0.1369021210714157], 
    DiskBox[{0.8571428571428568, -1.285714285714286}, 0.11037401863665271`], 
    DiskBox[{0.8571428571428568, -0.8571428571428574}, 0.0865845038187609], 
    DiskBox[{0.8571428571428568, -0.4285714285714289}, 0.06845106053570782], 
    DiskBox[{0.8571428571428568, -3.3306690738754696`*^-16}, 
     0.061224489795918324`], 
    DiskBox[{0.8571428571428568, 0.4285714285714282}, 0.0684510605357078], 
    DiskBox[{0.8571428571428568, 0.8571428571428568}, 0.08658450381876086], 
    DiskBox[{0.8571428571428568, 1.2857142857142854`}, 0.11037401863665271`], 
    DiskBox[{0.8571428571428568, 1.714285714285714}, 0.1369021210714157], 
    DiskBox[{0.8571428571428568, 2.1428571428571423`}, 0.1648519838918725], 
    DiskBox[{0.8571428571428568, 2.5714285714285707`}, 0.1936088363368395], 
    DiskBox[{0.8571428571428568, 2.999999999999999}, 0.22286050681470987`], 
    DiskBox[{1.2857142857142854`, -3.}, 0.2331359114039973], 
    DiskBox[{1.2857142857142854`, -2.5714285714285716`}, 
     0.20535318160712354`], 
    DiskBox[{1.2857142857142854`, -2.1428571428571432`}, 
     0.17849852739322342`], 
    DiskBox[{1.2857142857142854`, -1.7142857142857149`}, 
     0.15306122448979595`], 
    DiskBox[{1.2857142857142854`, -1.285714285714286}, 0.12987675572814136`], 
    DiskBox[{1.2857142857142854`, -0.8571428571428574}, 0.11037401863665273`],
     DiskBox[{1.2857142857142854`, -0.4285714285714289}, 0.09680441816841978],
     DiskBox[{1.2857142857142854`, -3.3306690738754696`*^-16}, 
     0.09183673469387754], 
    DiskBox[{1.2857142857142854`, 0.4285714285714282}, 0.09680441816841975], 
    DiskBox[{1.2857142857142854`, 0.8571428571428568}, 0.11037401863665271`], 
    DiskBox[{1.2857142857142854`, 1.2857142857142854`}, 0.12987675572814136`],
     DiskBox[{1.2857142857142854`, 1.714285714285714}, 0.15306122448979595`], 
    DiskBox[{1.2857142857142854`, 2.1428571428571423`}, 0.17849852739322342`],
     DiskBox[{1.2857142857142854`, 2.5714285714285707`}, 
     0.20535318160712354`], 
    DiskBox[{1.2857142857142854`, 2.999999999999999}, 0.23313591140399711`], 
    DiskBox[{1.714285714285714, -3.}, 0.24680380862138424`], 
    DiskBox[{1.714285714285714, -2.5714285714285716`}, 0.22074803727330547`], 
    DiskBox[{1.714285714285714, -2.1428571428571432`}, 0.1960140072683525], 
    DiskBox[{1.714285714285714, -1.7142857142857149`}, 0.17316900763752188`], 
    DiskBox[{1.714285714285714, -1.285714285714286}, 0.15306122448979595`], 
    DiskBox[{1.714285714285714, -0.8571428571428574}, 0.13690212107141572`], 
    DiskBox[{1.714285714285714, -0.4285714285714289}, 0.12621751915156107`], 
    DiskBox[{1.714285714285714, -3.3306690738754696`*^-16}, 
     0.12244897959183676`], 
    DiskBox[{1.714285714285714, 0.4285714285714282}, 0.12621751915156104`], 
    DiskBox[{1.714285714285714, 0.8571428571428568}, 0.1369021210714157], 
    DiskBox[{1.714285714285714, 1.2857142857142854`}, 0.15306122448979595`], 
    DiskBox[{1.714285714285714, 1.714285714285714}, 0.17316900763752188`], 
    DiskBox[{1.714285714285714, 2.1428571428571423`}, 0.1960140072683525], 
    DiskBox[{1.714285714285714, 2.5714285714285707`}, 0.22074803727330547`], 
    DiskBox[{1.714285714285714, 2.999999999999999}, 0.2468038086213841], 
    DiskBox[{2.1428571428571423`, -3.}, 0.2633364877666112], 
    DiskBox[{2.1428571428571423`, -2.5714285714285716`}, 
     0.23908927579306094`], 
    DiskBox[{2.1428571428571423`, -2.1428571428571432`}, 
     0.21646125954690254`], 
    DiskBox[{2.1428571428571423`, -1.7142857142857149`}, 
     0.19601400726835266`], 
    DiskBox[{2.1428571428571423`, -1.285714285714286}, 0.1784985273932236], 
    DiskBox[{2.1428571428571423`, -0.8571428571428574}, 0.16485198389187272`],
     DiskBox[{2.1428571428571423`, -0.4285714285714289}, 0.1560924340895752], 
    DiskBox[{2.1428571428571423`, -3.3306690738754696`*^-16}, 
     0.1530612244897961], 
    DiskBox[{2.1428571428571423`, 0.4285714285714282}, 0.1560924340895752], 
    DiskBox[{2.1428571428571423`, 0.8571428571428568}, 0.16485198389187272`], 
    DiskBox[{2.1428571428571423`, 1.2857142857142854`}, 0.1784985273932236], 
    DiskBox[{2.1428571428571423`, 1.714285714285714}, 0.19601400726835266`], 
    DiskBox[{2.1428571428571423`, 2.1428571428571423`}, 0.2164612595469023], 
    DiskBox[{2.1428571428571423`, 2.5714285714285707`}, 0.23908927579306094`],
     DiskBox[{2.1428571428571423`, 2.999999999999999}, 0.26333648776661106`], 
    DiskBox[{2.5714285714285707`, -3.}, 0.28223095277427196`], 
    DiskBox[{2.5714285714285707`, -2.5714285714285716`}, 0.2597535114562827], 
    DiskBox[{2.5714285714285707`, -2.1428571428571432`}, 0.2390892757930608], 
    DiskBox[{2.5714285714285707`, -1.7142857142857149`}, 
     0.22074803727330547`], 
    DiskBox[{2.5714285714285707`, -1.285714285714286}, 0.20535318160712357`], 
    DiskBox[{2.5714285714285707`, -0.8571428571428574}, 0.19360883633683953`],
     DiskBox[{2.5714285714285707`, -0.4285714285714289}, 
     0.18620701623361896`], 
    DiskBox[{2.5714285714285707`, -3.3306690738754696`*^-16}, 
     0.18367346938775508`], 
    DiskBox[{2.5714285714285707`, 0.4285714285714282}, 0.18620701623361893`], 
    DiskBox[{2.5714285714285707`, 0.8571428571428568}, 0.1936088363368395], 
    DiskBox[{2.5714285714285707`, 1.2857142857142854`}, 0.20535318160712354`],
     DiskBox[{2.5714285714285707`, 1.714285714285714}, 0.22074803727330547`], 
    DiskBox[{2.5714285714285707`, 2.1428571428571423`}, 0.2390892757930608], 
    DiskBox[{2.5714285714285707`, 2.5714285714285707`}, 0.2597535114562827], 
    DiskBox[{2.5714285714285707`, 2.999999999999999}, 0.28223095277427196`], 
    DiskBox[{2.999999999999999, -3.}, 0.30304576336566325`], 
    DiskBox[{2.999999999999999, -2.5714285714285716`}, 0.28223095277427196`], 
    DiskBox[{2.999999999999999, -2.1428571428571432`}, 0.2633364877666109], 
    DiskBox[{2.999999999999999, -1.7142857142857149`}, 0.2468038086213841], 
    DiskBox[{2.999999999999999, -1.285714285714286}, 0.23313591140399711`], 
    DiskBox[{2.999999999999999, -0.8571428571428574}, 0.22286050681470965`], 
    DiskBox[{2.999999999999999, -0.4285714285714289}, 0.21646125954690223`], 
    DiskBox[{2.999999999999999, -3.3306690738754696`*^-16}, 
     0.2142857142857142], 
    DiskBox[{2.999999999999999, 0.4285714285714282}, 0.2164612595469022], 
    DiskBox[{2.999999999999999, 0.8571428571428568}, 0.22286050681470987`], 
    DiskBox[{2.999999999999999, 1.2857142857142854`}, 0.23313591140399711`], 
    DiskBox[{2.999999999999999, 1.714285714285714}, 0.2468038086213841], 
    DiskBox[{2.999999999999999, 2.1428571428571423`}, 0.2633364877666109], 
    DiskBox[{2.999999999999999, 2.5714285714285707`}, 0.28223095277427196`], 
    DiskBox[{2.999999999999999, 2.999999999999999}, 0.3030457633656631]}},
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-3.303045763365663, 3.303045763365663}, {-3.303045763365663, 
   3.303045763365663}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.584729819995315*^9, {3.584729861585373*^9, 3.584729889925413*^9}, 
   3.58472993814548*^9, 3.5847299874655495`*^9, {3.5847301255757427`*^9, 
   3.584730156365786*^9}, 3.5849687742136736`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {GraphicsComplexBox[CompressedData["
1:eJx117GKXVUUgOFJckgkCJbWYpIX8AESrYylvoEgKCRY+SLprAUfIZziwATB
KPaKGIxoK1ipjRBl7vHbw/4PmWbxc/fMvj9r7bXWvPHhp+9/dPXs7OyrK2dn
F3H/eeVJ4+37j27df7QMfu8Cb10Z/PPjh88eP/znHN85nf9z8PPT578P/vXE
z87ne9YNf79/fhf/uP/+4Df3vz/4p/3+we/u3+/efH4Z/OLfi58b9+qFG/li
vpgv5ov5zvetG+aL+WK+mC/mO59fBvNt3uqFG/livpgv5jvft26YL+aL+WK+
mO98fhnMt3XZvNULN/LFfDHf+b51w3wxX8wX88V85/PLYL59d63L5q1euJEv
5jvft26YL+aL+WK+mO98fhnMt32l76512bzVCzfyne9bN8wX88V8MV/Mdz6/
DObbvtm+0nfXumze6oUb+WK+mC/mi/livvP5ZTDfzoX2zfaVvrvWZfNWr/m+
yzjPo3Wb59G6zfNo3eZ5tG7zPHJ+Gcy3c69zoX2zfaXvrnXZvNULN/LFfDFf
zHc+vwzm27neude50L7ZvtJ317ps3uqFG/livpjvfH4ZzLd7S+d6517nQvtm
+0rfXeuyeasXbuSL+c7nlsF8u5d1b+lc79zrXGjfbF/pu2tdNm/1wo185/PL
YL7dO7uXdW/pXO/c61xo32xf6btrXTZv9cKNfPFcz5d7dffO7mXdWzrXO/c6
F9o321f67lqXzVu95vOXke88l47/R3TP7h7aPa17TOd852DnRPto+0zfYeu0
eaznx09/ePuLBzefiN+8vn73zpfXB9/55PMPfvvl6uCbn/21XnvrxTn+9nT+
78Gvnj7/Y/BrJ34+mCe+tn9+F1/ff3/w1/vfH3xjv3/w7f37DY+n+/ev10s9
G/livpgv5ov5Yr6YL+aL+WK+mC/mm7yVD164kS/mi/livnjsY/8zX8wX88V8
MV/MN3VZPuStXriRL+aL+WK+mC/mi/livpgv5pt3Vz7UZfNWL9zIF/PFfDFf
zBfzxXwxX8w3faV8eHety+atXriRL+aL+WK+mC/mi/livumb5UNf6btrXTZv
9cKNfDFfzBfzxXwxX8w3c6F86JvtK313rcvmrV64kS/mi/livpgv5pu5Vz7M
hfbN9pW+u9Zl81Yv3MgX88V8MV/MN3O9fJh7nQvtm+0rfXety+atXriRL+aL
+WK+2VvKh7neude50L7ZvtJ317ps3uqFG/livphv9rLyYW/pXO/c61xo32xf
6btrXTZv9cKNfDHf7J3lw17WvaVzvXOvc6F9s32l76512bzVCzfyzV5dPuyd
3cu6t3Sud+51LrRvtq/03bUum7d64Ua+L/s/ont299Duad1jOuc7Bzsn2kfb
Z/oOW6fNYz0b/wMqt2mE
     "], {
      {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
       EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNlvm7jlUUhs+mWVKmkDFjlHmOZCikCMmQwolkHkKInIpEyRgSosxDOZUx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         "]]]}, {}, {}, {}, {}},
     VertexColors->CompressedData["
1:eJztWGtQVGUYXnZxcJaiYhTBBW0F5aICyUxCZS8i1pokIKMEDkEsGONtJZSQ
WKkZMwEtL5jLqEEYjDMoA3JHMS9gKkioXKYcGMFl2T3nQAmbXOISP76lmW/m
HTrm5I/O8/s97zzfM8/7vN935NGq9bFikUh0zUwkkogECBAgQIAAAQIECBAg
QIAAAQIECBAg4P+Hg0+S5A7z+uB41r2RTeJeKMuz6k8uYqBd3eFvtrQXRBXx
FcZiDoyVOrNUexbCQ+YOOq7nQCq/oxqK4+DrxoLejL0sdItc/HKPsjCqSC6Q
uXLwzon0VaHNLDTu3FAVaGSgLl56N9DIguqr+fX+Mg7y0674rFEzMBidXfFd
AwulsxsTTwRxkHMkXeLqxcAbt8VndSUsfOKTfakhnoMZ0eNFf9gxcF9tCEwt
YGHD2ls9Nmq8HuuP8dES/n9S/LHzYvrw1dOm9gvrMy4c9BRvCZZv4iDzt41t
jkdYGFthXrXah4UdbluM6ywn+UyYd0SOsrAqLqK/KYYBg4vix921LJgfVbce
mvzOaZ37evUFAwTkqheOH2Bh/9nfNfEFHEjykoacFhhAo6o9/OpjBsZuF398
tY6D5fZp62R1eljp8cvdvkQG3vQwN1bd4aAwNrHZL08Pa6qtUmTvMzAQLInb
1YTXY/0xPn6Ev57iP0rOu506L6YPX39iemL+2TUrZ1OUrwEcpE/CW2xZ8La+
Eep2nYOUkeVtr8fo4ZbF8IzzgwYYvB5uadHKQdo++5bCyh4o8wstVNoYQBqg
XFSl5SA6T+Kb+V4P9DHV7T99qYfOXP2Ecx8HzMYIZbJTD7ifnhlQE6KHJZFv
5299jNeb+pdS/T8jfG5SfDD+2Hkx/fnOO+ZPjM9hsUWCj1wPA2VuiuJsA9jV
G9fWPsD1cVRFqiLCdODyaV7QsKIH0lfLt92bnLMlmtLYl+93Q5hrdcNxjQ6C
S5XDIVa9sEjh3198phusPxfbR4brIGbbHm209d/1H1D1WH+Mj4l/P+FvS/hj
58X04Zuf2Hxh/sT4e62ukb9kpoPIjLmHxpt18IMo2FMp7YWPKkrGGctumDOx
JsfiWDfESC7VKOf3wo6inVWeG7WwuEvWfe6gFlh3z6g+IwflmnzHTKkW9sw8
eUn1ohZOL3o3a6Ccm6p3o+pN/W2o/ssInw8pPib+Syj+mP8xffjuIyzfsHnH
/IPpOa9Q05Rb/QhSPfwb9PsfQWa938jW3RwMXQ5v/j6/CySqjKyE8k7wqfO9
sfQYC222F1POeHeB28q3tOFjD8H2nMTBfHJuTfViUu9N6k3991L9oxD9FyD8
sfwRE32+JfqME3347ndsv2B5iM075k9Mz1PKy6kXnDvhha5rE3YxHRB0NfIb
RRgDQ5qfWy5sfgiVA9VzDv76AI6+diVn1kXDVL2U1Aea6kl/M6r/dsr/DOGz
mMqfIMIfO69JH19KH773JWy/Y/mA5Sc276g/ET29lt2M2OfaDrLYsc3R1S1g
WZHitHCFfqq+nNQfIfWtVP85pH8Z4ZNE+JwifJwJ/1co/lienCf6KCh9+N4/
n9bP9D7C8hObd9SfiJ4nkfpBys/elJ9dKT60n4OfsZ+fNp/pvJoun+k8xPIT
m3fMn5ieDqS/mvQ/RuXz7H+YzwfIeUv+ZT7zvW9g+xfLE2y/Y/sIy09s3jF/
Yno+r/sG9t7E3kfT3Z/p+yfGH/MPto+w/MTmHeuP8cH4J5Dz2lPnxfTh+37H
3jt834OYH7D8me49SOuD1WPzjvHB9HxW70G+/zew/nz/b2D5hu0XbL9j9Vj/
5/V/Q/hf99/8r/sLmzLKfQ==
      "]], 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.045873685240266346`, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -3.2142857142857144`}, \
{-3.2142857142857144`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.042722834164836215`, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -2.7551020408163267`}, \
{-3.2142857142857144`, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.03986267624374094, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -2.295918367346939}, \
{-3.2142857142857144`, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.037360034692631945`, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -1.8367346938775515`}, \
{-3.2142857142857144`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.03529105076134969, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -1.3775510204081636`}, \
{-3.2142857142857144`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.033735606888416904`, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -0.9183673469387759}, \
{-3.2142857142857144`, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.03276691802876167, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -0.4591836734693881}, \
{-3.2142857142857144`, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.03243759391140957, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, -3.5685740077237176`*^-16}, \
{-3.2142857142857144`, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.03276691802876167, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       0.4591836734693874}, {-3.2142857142857144`, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.0337356068884169, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       0.9183673469387751}, {-3.2142857142857144`, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.03529105076134969, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       1.377551020408163}, {-3.2142857142857144`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.03736003469263194, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       1.8367346938775506`}, {-3.2142857142857144`, 1.5918367346938773`}}]}, 
     {Arrowheads[{{0.03986267624374092, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       2.295918367346938}, {-3.2142857142857144`, 1.9897959183673466`}}]}, 
     {Arrowheads[{{0.04272283416483619, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       2.755102040816326}, {-3.214285714285714, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.04587368524026632, 1.}}], 
      ArrowBox[{{-2.7857142857142856`, 
       3.2142857142857135`}, {-3.2142857142857144`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.042722834164836215`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -3.2142857142857144`}, \
{-2.7551020408163267`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.03932030163451398, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -2.7551020408163267`}, \
{-2.7551020408163267`, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.036192243904825436`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -2.295918367346939}, \
{-2.7551020408163267`, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.03341583088579017, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -1.8367346938775513`}, \
{-2.7551020408163267`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.031085427862476447`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -1.3775510204081636`}, \
{-2.7551020408163267`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.029307622450189818`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -0.9183673469387759}, \
{-2.755102040816327, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.028187168688193095`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -0.4591836734693881}, \
{-2.7551020408163267`, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.027803651924065326`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, -3.5685740077237176`*^-16}, \
{-2.7551020408163267`, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.02818716868819309, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       0.4591836734693874}, {-2.7551020408163267`, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.029307622450189818`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       0.9183673469387751}, {-2.755102040816327, 0.7959183673469383}}]}, 
     {Arrowheads[{{0.031085427862476447`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       1.377551020408163}, {-2.7551020408163267`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.033415830885790185`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       1.8367346938775506`}, {-2.7551020408163267`, 1.591836734693877}}]}, 
     {Arrowheads[{{0.036192243904825436`, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       2.295918367346938}, {-2.7551020408163267`, 1.9897959183673464`}}]}, 
     {Arrowheads[{{0.03932030163451398, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       2.755102040816326}, {-2.7551020408163267`, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.04272283416483619, 1.}}], 
      ArrowBox[{{-2.3877551020408165`, 
       3.2142857142857135`}, {-2.7551020408163267`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.03986267624374095, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -3.2142857142857144`}, \
{-2.2959183673469394`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.036192243904825436`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -2.7551020408163267`}, \
{-2.295918367346939, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.032766918028761645`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -2.295918367346939}, \
{-2.295918367346939, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.029671706254021542`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -1.8367346938775513`}, \
{-2.2959183673469394`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.027020292811708004`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -1.3775510204081636`}, \
{-2.2959183673469394`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.024954541308549048`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -0.9183673469387759}, \
{-2.2959183673469394`, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.023628560618325106`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -0.4591836734693881}, \
{-2.295918367346939, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.0231697099367211, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, -3.5685740077237176`*^-16}, \
{-2.295918367346939, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.023628560618325106`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       0.4591836734693874}, {-2.295918367346939, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.024954541308549013`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       0.9183673469387751}, {-2.295918367346939, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.027020292811708004`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       1.377551020408163}, {-2.2959183673469394`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.02967170625402155, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       1.8367346938775506`}, {-2.2959183673469394`, 1.591836734693877}}]}, 
     {Arrowheads[{{0.03276691802876163, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       2.295918367346938}, {-2.295918367346939, 1.9897959183673466`}}]}, 
     {Arrowheads[{{0.036192243904825436`, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       2.755102040816326}, {-2.295918367346939, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03986267624374092, 1.}}], 
      ArrowBox[{{-1.9897959183673473`, 
       3.2142857142857135`}, {-2.2959183673469394`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.037360034692631945`, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, -3.2142857142857144`}, \
{-1.8367346938775513`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.03341583088579017, 1.}}], 
      ArrowBox[{{-1.591836734693878, -2.7551020408163267`}, \
{-1.8367346938775513`, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.02967170625402151, 1.}}], 
      ArrowBox[{{-1.591836734693878, -2.295918367346939}, \
{-1.8367346938775513`, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.02621353442300933, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, -1.8367346938775515`}, \
{-1.8367346938775513`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, -1.3775510204081636`}, \
{-1.8367346938775513`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.020723618574984302`, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, -0.9183673469387759}, \
{-1.8367346938775513`, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.019106232276804847`, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, -0.4591836734693881}, \
{-1.8367346938775513`, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.018535767949376888`, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, -3.5685740077237176`*^-16}, \
{-1.8367346938775513`, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.01910623227680484, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       0.4591836734693874}, {-1.8367346938775513`, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.0207236185749843, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       0.9183673469387751}, {-1.8367346938775513`, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       1.377551020408163}, {-1.8367346938775513`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.02621353442300933, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       1.8367346938775506`}, {-1.8367346938775513`, 1.591836734693877}}]}, 
     {Arrowheads[{{0.02967170625402151, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       2.295918367346938}, {-1.8367346938775513`, 1.9897959183673466`}}]}, 
     {Arrowheads[{{0.033415830885790185`, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       2.755102040816326}, {-1.8367346938775513`, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03736003469263192, 1.}}], 
      ArrowBox[{{-1.5918367346938778`, 
       3.2142857142857135`}, {-1.8367346938775513`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.03529105076134969, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -3.2142857142857144`}, \
{-1.3775510204081636`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.031085427862476447`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -2.7551020408163267`}, \
{-1.3775510204081636`, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.027020292811707976`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -2.295918367346939}, \
{-1.3775510204081636`, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -1.8367346938775515`}, \
{-1.3775510204081636`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.01966015081725699, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -1.3775510204081636`}, \
{-1.3775510204081636`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.016707915442895092`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -0.9183673469387759}, \
{-1.3775510204081636`, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.014653811225094895`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -0.4591836734693881}, \
{-1.3775510204081636`, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.013901825962032663`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, -3.5685740077237176`*^-16}, \
{-1.3775510204081636`, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.014653811225094892`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       0.4591836734693874}, {-1.3775510204081636`, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.016707915442895085`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       0.9183673469387751}, {-1.3775510204081636`, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.01966015081725699, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       1.377551020408163}, {-1.3775510204081636`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       1.8367346938775506`}, {-1.3775510204081636`, 1.591836734693877}}]}, 
     {Arrowheads[{{0.027020292811707966`, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       2.295918367346938}, {-1.3775510204081636`, 1.9897959183673466`}}]}, 
     {Arrowheads[{{0.03108542786247645, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       2.755102040816326}, {-1.3775510204081638`, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03529105076134966, 1.}}], 
      ArrowBox[{{-1.1938775510204085`, 
       3.2142857142857135`}, {-1.3775510204081636`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.033735606888416904`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -3.2142857142857144`}, \
{-0.9183673469387758, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.029307622450189818`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -2.7551020408163267`}, \
{-0.9183673469387758, -2.387755102040816}}]}, 
     {Arrowheads[{{0.024954541308549016`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -2.295918367346939}, \
{-0.9183673469387758, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.020723618574984302`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -1.8367346938775515`}, \
{-0.9183673469387758, -1.591836734693878}}]}, 
     {Arrowheads[{{0.016707915442895092`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -1.3775510204081636`}, \
{-0.9183673469387758, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.013106767211504665`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -0.9183673469387759}, \
{-0.9183673469387758, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.010361809287492153`, 1.}}], 
      ArrowBox[{{-0.795918367346939, -0.4591836734693881}, \
{-0.9183673469387758, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.009267883974688444, 1.}}], 
      ArrowBox[{{-0.795918367346939, -3.5685740077237176`*^-16}, \
{-0.9183673469387758, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.01036180928749215, 1.}}], 
      ArrowBox[{{-0.795918367346939, 
       0.4591836734693874}, {-0.9183673469387758, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.01310676721150466, 1.}}], 
      ArrowBox[{{-0.795918367346939, 
       0.9183673469387751}, {-0.9183673469387758, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.016707915442895092`, 1.}}], 
      ArrowBox[{{-0.795918367346939, 1.377551020408163}, {-0.9183673469387758,
        1.1938775510204078`}}]}, 
     {Arrowheads[{{0.020723618574984302`, 1.}}], 
      ArrowBox[{{-0.795918367346939, 
       1.8367346938775506`}, {-0.9183673469387758, 1.591836734693877}}]}, 
     {Arrowheads[{{0.024954541308549016`, 1.}}], 
      ArrowBox[{{-0.795918367346939, 2.295918367346938}, {-0.9183673469387758,
        1.9897959183673464`}}]}, 
     {Arrowheads[{{0.029307622450189787`, 1.}}], 
      ArrowBox[{{-0.795918367346939, 2.755102040816326}, {-0.9183673469387758,
        2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03373560688841687, 1.}}], 
      ArrowBox[{{-0.795918367346939, 
       3.2142857142857135`}, {-0.9183673469387758, 2.785714285714285}}]}, 
     {Arrowheads[{{0.03276691802876167, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -3.2142857142857144`}, \
{-0.4591836734693881, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.028187168688193095`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -2.7551020408163267`}, \
{-0.4591836734693881, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.02362856061832514, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -2.2959183673469394`}, \
{-0.4591836734693881, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.019106232276804847`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -1.8367346938775515`}, \
{-0.4591836734693881, -1.591836734693878}}]}, 
     {Arrowheads[{{0.014653811225094895`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -1.3775510204081636`}, \
{-0.4591836734693881, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.010361809287492153`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -0.9183673469387759}, \
{-0.4591836734693881, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.0065533836057523375`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -0.4591836734693881}, \
{-0.4591836734693881, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.004633941987344226, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, -3.5685740077237176`*^-16}, \
{-0.4591836734693881, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.006553383605752332, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       0.4591836734693874}, {-0.4591836734693881, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.010361809287492144`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       0.9183673469387751}, {-0.4591836734693881, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.014653811225094895`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       1.377551020408163}, {-0.4591836734693881, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.019106232276804847`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       1.8367346938775506`}, {-0.4591836734693881, 1.591836734693877}}]}, 
     {Arrowheads[{{0.023628560618325106`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       2.295918367346938}, {-0.4591836734693881, 1.9897959183673464`}}]}, 
     {Arrowheads[{{0.028187168688193095`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       2.755102040816326}, {-0.4591836734693881, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.032766918028761645`, 1.}}], 
      ArrowBox[{{-0.39795918367346966`, 
       3.2142857142857135`}, {-0.4591836734693881, 2.785714285714285}}]}, 
     {Arrowheads[{{0.03243759391140957, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -3.2142857142857144`}, \
{-3.5685740077237176`*^-16, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.027803651924065326`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -2.7551020408163267`}, \
{-3.5685740077237176`*^-16, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.0231697099367211, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -2.295918367346939}, \
{-3.5685740077237176`*^-16, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.018535767949376888`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -1.8367346938775515`}, \
{-3.5685740077237176`*^-16, -1.591836734693878}}]}, 
     {Arrowheads[{{0.013901825962032663`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -1.3775510204081636`}, \
{-3.5685740077237176`*^-16, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.009267883974688444, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -0.9183673469387759}, \
{-3.5685740077237176`*^-16, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.004633941987344226, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, -0.4591836734693881}, \
{-3.5685740077237176`*^-16, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.0046339419873442185`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       0.4591836734693874}, {-3.5685740077237176`*^-16, 
       0.39795918367346905`}}]}, 
     {Arrowheads[{{0.009267883974688437, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       0.9183673469387751}, {-3.5685740077237176`*^-16, 
       0.7959183673469384}}]}, 
     {Arrowheads[{{0.013901825962032663`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       1.377551020408163}, {-3.5685740077237176`*^-16, 
       1.1938775510204078`}}]}, 
     {Arrowheads[{{0.018535767949376888`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       1.8367346938775506`}, {-3.5685740077237176`*^-16, 
       1.591836734693877}}]}, 
     {Arrowheads[{{0.023169709936721083`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       2.295918367346938}, {-3.5685740077237176`*^-16, 
       1.9897959183673466`}}]}, 
     {Arrowheads[{{0.027803651924065326`, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       2.755102040816326}, {-3.5685740077237176`*^-16, 
       2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03243759391140954, 1.}}], 
      ArrowBox[{{-3.0927641400272217`*^-16, 
       3.2142857142857135`}, {-3.5685740077237176`*^-16, 
       2.785714285714285}}]}, 
     {Arrowheads[{{0.03276691802876167, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -3.2142857142857144`}, {
       0.4591836734693874, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.02818716868819309, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -2.7551020408163267`}, {
       0.4591836734693874, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.02362856061832514, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -2.2959183673469394`}, {
       0.4591836734693874, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.01910623227680484, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -1.8367346938775515`}, {
       0.4591836734693874, -1.591836734693878}}]}, 
     {Arrowheads[{{0.014653811225094892`, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -1.3775510204081636`}, {
       0.4591836734693874, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.01036180928749215, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -0.9183673469387759}, {
       0.4591836734693874, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.006553383605752332, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -0.4591836734693881}, {
       0.4591836734693874, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.0046339419873442185`, 1.}}], 
      ArrowBox[{{0.39795918367346905`, -3.5685740077237176`*^-16}, {
       0.4591836734693874, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.006553383605752326, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 0.4591836734693874}, {
       0.4591836734693874, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.010361809287492143`, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 0.9183673469387751}, {
       0.4591836734693874, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.014653811225094892`, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 1.377551020408163}, {
       0.4591836734693874, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.01910623227680484, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 1.8367346938775506`}, {
       0.4591836734693874, 1.591836734693877}}]}, 
     {Arrowheads[{{0.023628560618325106`, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 2.295918367346938}, {
       0.4591836734693874, 1.9897959183673464`}}]}, 
     {Arrowheads[{{0.02818716868819309, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 2.755102040816326}, {
       0.4591836734693874, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03276691802876164, 1.}}], 
      ArrowBox[{{0.39795918367346905`, 3.2142857142857135`}, {
       0.4591836734693874, 2.785714285714285}}]}, 
     {Arrowheads[{{0.0337356068884169, 1.}}], 
      ArrowBox[{{0.7959183673469384, -3.2142857142857144`}, {
       0.9183673469387751, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.029307622450189818`, 1.}}], 
      ArrowBox[{{0.7959183673469384, -2.7551020408163267`}, {
       0.9183673469387752, -2.387755102040816}}]}, 
     {Arrowheads[{{0.024954541308549013`, 1.}}], 
      ArrowBox[{{0.7959183673469384, -2.295918367346939}, {
       0.9183673469387751, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.0207236185749843, 1.}}], 
      ArrowBox[{{0.7959183673469384, -1.8367346938775515`}, {
       0.9183673469387751, -1.591836734693878}}]}, 
     {Arrowheads[{{0.016707915442895085`, 1.}}], 
      ArrowBox[{{0.7959183673469384, -1.3775510204081636`}, {
       0.9183673469387751, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.01310676721150466, 1.}}], 
      ArrowBox[{{0.7959183673469384, -0.9183673469387759}, {
       0.9183673469387751, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.010361809287492144`, 1.}}], 
      ArrowBox[{{0.7959183673469384, -0.4591836734693881}, {
       0.9183673469387751, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.009267883974688437, 1.}}], 
      ArrowBox[{{0.7959183673469384, -3.5685740077237176`*^-16}, {
       0.9183673469387751, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.010361809287492143`, 1.}}], 
      ArrowBox[{{0.7959183673469384, 0.4591836734693874}, {0.9183673469387751,
        0.39795918367346905`}}]}, 
     {Arrowheads[{{0.013106767211504652`, 1.}}], 
      ArrowBox[{{0.7959183673469384, 0.9183673469387751}, {0.9183673469387751,
        0.7959183673469384}}]}, 
     {Arrowheads[{{0.016707915442895085`, 1.}}], 
      ArrowBox[{{0.7959183673469384, 1.377551020408163}, {0.9183673469387751, 
       1.1938775510204078`}}]}, 
     {Arrowheads[{{0.0207236185749843, 1.}}], 
      ArrowBox[{{0.7959183673469384, 1.8367346938775506`}, {
       0.9183673469387751, 1.591836734693877}}]}, 
     {Arrowheads[{{0.024954541308549013`, 1.}}], 
      ArrowBox[{{0.7959183673469384, 2.295918367346938}, {0.9183673469387751, 
       1.9897959183673464`}}]}, 
     {Arrowheads[{{0.029307622450189783`, 1.}}], 
      ArrowBox[{{0.7959183673469384, 2.755102040816326}, {0.9183673469387751, 
       2.3877551020408156`}}]}, 
     {Arrowheads[{{0.033735606888416904`, 1.}}], 
      ArrowBox[{{0.7959183673469384, 3.2142857142857135`}, {
       0.9183673469387752, 2.7857142857142847`}}]}, 
     {Arrowheads[{{0.03529105076134969, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -3.2142857142857144`}, {
       1.377551020408163, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.031085427862476447`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -2.7551020408163267`}, {
       1.377551020408163, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.027020292811707976`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -2.295918367346939}, {
       1.377551020408163, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -1.8367346938775515`}, {
       1.377551020408163, -1.591836734693878}}]}, 
     {Arrowheads[{{0.01966015081725699, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -1.3775510204081636`}, {
       1.377551020408163, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.016707915442895092`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -0.9183673469387759}, {
       1.377551020408163, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.014653811225094895`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -0.4591836734693881}, {
       1.377551020408163, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.013901825962032663`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, -3.5685740077237176`*^-16}, {
       1.377551020408163, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.014653811225094892`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 0.4591836734693874}, {1.377551020408163,
        0.39795918367346905`}}]}, 
     {Arrowheads[{{0.016707915442895085`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 0.9183673469387751}, {1.377551020408163,
        0.7959183673469384}}]}, 
     {Arrowheads[{{0.01966015081725699, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 1.377551020408163}, {1.377551020408163, 
       1.1938775510204078`}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 1.8367346938775506`}, {
       1.377551020408163, 1.591836734693877}}]}, 
     {Arrowheads[{{0.027020292811707976`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 2.295918367346938}, {1.377551020408163, 
       1.9897959183673464`}}]}, 
     {Arrowheads[{{0.031085427862476447`, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 2.755102040816326}, {1.377551020408163, 
       2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03529105076134966, 1.}}], 
      ArrowBox[{{1.1938775510204078`, 3.2142857142857135`}, {
       1.377551020408163, 2.785714285714285}}]}, 
     {Arrowheads[{{0.03736003469263194, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -3.2142857142857144`}, {
       1.8367346938775506`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.033415830885790185`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -2.7551020408163267`}, {
       1.8367346938775508`, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.029671706254021525`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -2.295918367346939}, {
       1.8367346938775508`, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.02621353442300933, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -1.8367346938775515`}, {
       1.8367346938775508`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -1.3775510204081636`}, {
       1.8367346938775508`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.020723618574984302`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -0.9183673469387759}, {
       1.8367346938775508`, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.019106232276804847`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -0.4591836734693881}, {
       1.8367346938775508`, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.018535767949376888`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, -3.5685740077237176`*^-16}, {
       1.8367346938775508`, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.01910623227680484, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 0.4591836734693874}, {
       1.8367346938775508`, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.0207236185749843, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 0.9183673469387751}, {
       1.8367346938775508`, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.02316970993672111, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 1.377551020408163}, {
       1.8367346938775508`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.02621353442300933, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 1.8367346938775506`}, {
       1.8367346938775508`, 1.591836734693877}}]}, 
     {Arrowheads[{{0.029671706254021525`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 2.295918367346938}, {
       1.8367346938775508`, 1.9897959183673464`}}]}, 
     {Arrowheads[{{0.033415830885790185`, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 2.755102040816326}, {
       1.8367346938775508`, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03736003469263192, 1.}}], 
      ArrowBox[{{1.5918367346938773`, 3.2142857142857135`}, {
       1.8367346938775508`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.03986267624374095, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -3.2142857142857144`}, {
       2.2959183673469385`, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.03619224390482546, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -2.7551020408163267`}, {
       2.2959183673469385`, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.03276691802876169, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -2.2959183673469394`}, {
       2.2959183673469385`, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.02967170625402155, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -1.8367346938775515`}, {
       2.2959183673469385`, -1.591836734693878}}]}, 
     {Arrowheads[{{0.027020292811708004`, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -1.3775510204081636`}, {
       2.2959183673469385`, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.024954541308549048`, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -0.9183673469387759}, {
       2.2959183673469385`, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.02362856061832514, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -0.4591836734693881}, {
       2.2959183673469385`, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.02316970993672113, 1.}}], 
      ArrowBox[{{1.9897959183673464`, -3.5685740077237176`*^-16}, {
       2.2959183673469385`, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.02362856061832514, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 0.4591836734693874}, {
       2.2959183673469385`, 0.39795918367346905`}}]}, 
     {Arrowheads[{{0.024954541308549048`, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 0.9183673469387751}, {
       2.2959183673469385`, 0.7959183673469384}}]}, 
     {Arrowheads[{{0.027020292811708004`, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 1.377551020408163}, {
       2.2959183673469385`, 1.1938775510204078`}}]}, 
     {Arrowheads[{{0.02967170625402155, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 1.8367346938775506`}, {
       2.2959183673469385`, 1.591836734693877}}]}, 
     {Arrowheads[{{0.03276691802876165, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 2.295918367346938}, {
       2.2959183673469385`, 1.9897959183673466`}}]}, 
     {Arrowheads[{{0.03619224390482546, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 2.755102040816326}, {
       2.2959183673469385`, 2.3877551020408156`}}]}, 
     {Arrowheads[{{0.03986267624374092, 1.}}], 
      ArrowBox[{{1.9897959183673464`, 3.2142857142857135`}, {
       2.2959183673469385`, 2.785714285714285}}]}, 
     {Arrowheads[{{0.04272283416483619, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -3.2142857142857144`}, {
       2.755102040816326, -2.785714285714286}}]}, 
     {Arrowheads[{{0.03932030163451398, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -2.7551020408163267`}, {
       2.755102040816326, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.036192243904825436`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -2.295918367346939}, {
       2.755102040816326, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.033415830885790185`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -1.8367346938775515`}, {
       2.755102040816326, -1.591836734693878}}]}, 
     {Arrowheads[{{0.03108542786247645, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -1.3775510204081636`}, {
       2.755102040816326, -1.1938775510204083`}}]}, 
     {Arrowheads[{{0.029307622450189787`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -0.9183673469387759}, {
       2.755102040816326, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.028187168688193095`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -0.4591836734693881}, {
       2.755102040816326, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.027803651924065326`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, -3.5685740077237176`*^-16}, {
       2.755102040816326, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.02818716868819309, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 0.4591836734693874}, {2.755102040816326,
        0.39795918367346905`}}]}, 
     {Arrowheads[{{0.029307622450189783`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 0.9183673469387751}, {2.755102040816326,
        0.7959183673469384}}]}, 
     {Arrowheads[{{0.031085427862476447`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 1.377551020408163}, {2.755102040816326, 
       1.1938775510204078`}}]}, 
     {Arrowheads[{{0.033415830885790185`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 1.8367346938775506`}, {
       2.755102040816326, 1.591836734693877}}]}, 
     {Arrowheads[{{0.036192243904825436`, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 2.295918367346938}, {2.755102040816326, 
       1.9897959183673464`}}]}, 
     {Arrowheads[{{0.03932030163451398, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 2.755102040816326}, {2.755102040816326, 
       2.3877551020408156`}}]}, 
     {Arrowheads[{{0.04272283416483619, 1.}}], 
      ArrowBox[{{2.3877551020408156`, 3.2142857142857135`}, {
       2.755102040816326, 2.785714285714285}}]}, 
     {Arrowheads[{{0.04587368524026632, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -3.2142857142857144`}, {
       3.214285714285713, -2.7857142857142856`}}]}, 
     {Arrowheads[{{0.04272283416483619, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -2.7551020408163267`}, {
       3.214285714285713, -2.3877551020408165`}}]}, 
     {Arrowheads[{{0.0398626762437409, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -2.295918367346939}, {
       3.214285714285713, -1.9897959183673473`}}]}, 
     {Arrowheads[{{0.03736003469263192, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -1.8367346938775515`}, {
       3.214285714285713, -1.591836734693878}}]}, 
     {Arrowheads[{{0.03529105076134966, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -1.3775510204081636`}, {
       3.214285714285713, -1.1938775510204085`}}]}, 
     {Arrowheads[{{0.03373560688841687, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -0.9183673469387759}, {
       3.214285714285713, -0.7959183673469391}}]}, 
     {Arrowheads[{{0.032766918028761645`, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -0.4591836734693881}, {
       3.214285714285713, -0.39795918367346966`}}]}, 
     {Arrowheads[{{0.03243759391140954, 1.}}], 
      ArrowBox[{{2.7857142857142847`, -3.5685740077237176`*^-16}, {
       3.214285714285713, -3.0927641400272217`*^-16}}]}, 
     {Arrowheads[{{0.03276691802876164, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 0.4591836734693874}, {3.214285714285713,
        0.39795918367346905`}}]}, 
     {Arrowheads[{{0.033735606888416904`, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 0.9183673469387751}, {
       3.2142857142857135`, 0.7959183673469383}}]}, 
     {Arrowheads[{{0.03529105076134966, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 1.377551020408163}, {3.214285714285713, 
       1.1938775510204078`}}]}, 
     {Arrowheads[{{0.03736003469263192, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 1.8367346938775506`}, {
       3.214285714285713, 1.591836734693877}}]}, 
     {Arrowheads[{{0.0398626762437409, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 2.295918367346938}, {3.214285714285713, 
       1.9897959183673464`}}]}, 
     {Arrowheads[{{0.04272283416483619, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 2.755102040816326}, {3.214285714285713, 
       2.3877551020408156`}}]}, 
     {Arrowheads[{{0.0458736852402663, 1.}}], 
      ArrowBox[{{2.7857142857142847`, 3.2142857142857135`}, {
       3.214285714285713, 2.785714285714285}}]}}}},
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-3.303045763365663, 3.303045763365663}, {-3.303045763365663, 
   3.303045763365663}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.584729819995315*^9, {3.584729861585373*^9, 3.584729889925413*^9}, 
   3.58472993814548*^9, 3.5847299874655495`*^9, {3.5847301255757427`*^9, 
   3.584730156365786*^9}, 3.584968774229274*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {GraphicsComplexBox[CompressedData["
1:eJzkuHlUje3f/72n2pUMpRCiUqJJCiXDcVYkUUhIoVklSpShKBUVRdEgIUXR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     "], {
      {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
       EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxd3Qe0LUXxNvw5eZ9z9r4S7wUko0gUASUoKCBJcs5JJSqKSjahSM45gyhI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         "]]]}, {}, {}, {}, {}},
     VertexColors->CompressedData["
1:eJzs3Xk0lX3fP3wRohQqTUJKUspcKD7SpEiFCCVlSEKFhGRKk8yphMhQpElS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      "]], 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5617883099689684, -3.}, {-0.572141638137904, \
-2.9454665907076145`}, {-0.5852957064711305, -2.879221678119484}, \
{-0.5987318806015481, -2.814495382850121}, {-0.626505362891108, \
-2.6894327284735167`}, {-0.6555717182808862, -2.5699467959894426`}, \
{-0.6712022149456082, -2.5113412516609173`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.6744291586167087, -2.4992420334198764`}, \
{-0.6860405800451855, -2.4557057538095384`}, {-0.7201366614904333, \
-2.3394544311745578`}, {-0.7561067286060372, -2.2282142858446914`}, \
{-0.7940469018164575, -2.1217534409459535`}, {-0.83227675975252, \
-2.024229815626094}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8371810279066367, -2.0127091076309105`}, \
{-0.8744117802255876, -1.9266091594059802`}, {-0.9179578903763331, \
-1.835220492568249}, {-0.9636663474708154, -1.7481473724136758`}, \
{-1.0115371515090343`, -1.6653897989422606`}, {-1.061802469783616, \
-1.5865673239083846`}, {-1.0723905657785957`, -1.571499961023267}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0795902197972351`, -1.5612545118133647`}, \
{-1.1146944695871859`, -1.5112994990664292`}, {-1.1702131509197442`, \
-1.439586324416394}, {-1.228358513781291, -1.3714277999582793`}, \
{-1.2621838633447076`, -1.3336643248750397`}, {-1.2969406620957524`, \
-1.2969406998787654`}, {-1.373872117506242, -1.2281452141789984`}, \
{-1.4168962285697457`, -1.1937520782237439`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.426677284753226, -1.1859331788487424`}, \
{-1.4553669250410584`, -1.162998906076195}, {-1.5261478538302173`, \
-1.1090567131913556`}, {-1.6005407681735069`, -1.0575061771152632`}, \
{-1.678545668070927, -1.0083472978479175`}, {-1.7601625535224776`, \
-0.961580075389319}, {-1.845767826934882, -0.916996109059492}, \
{-1.847454768451089, -0.9161971868947857}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.8587719127662257`, -0.9108374768232276}, \
{-1.9357378907148632`, -0.8743869981784615}, {-2.0300727448624207`, \
-0.8337527427462277}, {-2.128772389377555, -0.7950933427627901}, \
{-2.231264015062557, -0.7586240721827407}, {-2.324702296003788, \
-0.7283402922522471}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.3366144188186024`, -0.7244795180364227}, \
{-2.3407935407044453`, -0.7231250452633933}, {-2.4551461040720777`, \
-0.6894286546291689}, {-2.5745508288445382`, -0.6574487906982308}, \
{-2.67734242277192, -0.6322385629359747}, {-2.784186817946674, \
-0.6080572620681518}, {-2.8216591329992746`, -0.6002287850013404}}]}, 
     {Arrowheads[{{0.006761603408077678, 1.}}], 
      ArrowBox[{{-2.833916650822735, -0.5976680225546569}, \
{-2.895276637796795, -0.5848490854227505}, {-3., -0.5646429366096184}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.5617754710915119, -3.}, {
       0.5721583260647862, -2.9453154817055225`}, {
       0.585312621220109, -2.8790747404566517`}, {
       0.598749023579015, -2.8143525038582946`}, {
       0.6265229665407167, -2.68929764185221}, {
       0.6555897882161705, -2.5698190901654425`}, {
       0.6711875349758989, -2.511340826253784}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.6744147097907797, -2.499241669662724}, {
       0.6860591218716563, -2.455585043276166}, {
       0.7201563949884748, -2.3393385576310606`}, {
       0.7561277356405716, -2.228103075106258}, {
       0.7940692692457028, -2.121646725178346}, {
       0.8322606198210585, -2.024229006913242}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.837161730858041, -2.0127070025049045`}, {
       0.8744370549516807, -1.9265108358771372`}, {
       0.9179847702596868, -1.8351261403973682`}, {
       0.9636949293562407, -1.748056836467666}, {
       1.0115675322413422`, -1.665302924088031}, {
       1.0618347585885495`, -1.586483966017762}, {
       1.0723680651309828`, -1.5714958201614984`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.0795681207793655`, -1.5612506531955095`}, {
       1.1147287880714205`, -1.5112195250161586`}, {
       1.170249620689955, -1.4395096010832207`}, {
       1.2283972564441537`, -1.3713541942189487`}, {
       1.2622235613068038`, -1.333592870455516}, {
       1.2969813385911952`, -1.2968713341118188`}, {
       1.373914095646152, -1.22808041701737}, {
       1.4168703087981769`, -1.193744366832797}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.426651676902146, -1.1859258576708498`}, {
       1.4554102161257687`, -1.1629383880230326`}, {
       1.5261929698070729`, -1.1089992064786416`}, {
       1.60058778707889, -1.0574515394934254`}, {
       1.6785946679412203`, -1.008295387067384}, {
       1.7602136123940633`, -0.9615307492005176}, {
       1.8458210294239055`, -0.9169492383835437}, {
       1.8474283899824375`, -0.9161880658365849}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.8587456996319849`, -0.9108287048861489}, {
       1.9357933280172324`, -0.8743424671071799}, {
       2.030130508174044, -0.8337104353714263}, {
       2.1288325698943407`, -0.795053143176283}, {
       2.2313266944607397`, -0.758585851067017}, {
       2.324676697851564, -0.7283330507282687}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.3365889093061636`, -0.7244725500144104}, {
       2.3408588546050755`, -0.7230887492871138}, {
       2.4552141512868015`, -0.6893941786116067}, {
       2.574621711992872, -0.6574160348223891}, {
       2.6774159041795897`, -0.6322071174610802}, {
       2.784262990964967, -0.608027070986261}, {
       2.821633229831507, -0.6002205192201671}}]}, 
     {Arrowheads[{{0.0067626485660118646`, 1.}}], 
      ArrowBox[{{2.8338907870615166`, -0.5976599454067735}, {
       2.895355599767332, -0.5848200959240121}, {3., -0.5646307312014643}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-0.5617788193522668, 3.}, {-0.5721131419915989, 
       2.9455622086201343`}, {-0.5852666636801886, 
       2.8793146107803085`}, {-0.5987022818210032, 
       2.8145857036323267`}, {-0.6264746224903959, 
       2.6895180370774527`}, {-0.6555397940619574, 
       2.5700273602866237`}, {-0.671190653995717, 2.511340789378207}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.6744173576345218, 
       2.499241507121473}, {-0.6860074265978684, 
       2.4557818245909497`}, {-0.7201016928812759, 
       2.3395274447097543`}, {-0.756069834925006, 
       2.2282843526450056`}, {-0.7940079670236758, 
       2.1218206674687066`}, {-0.8322617433279251, 2.0242281302407474`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8371679455586912, 
       2.0127082144046446`}, {-0.8743685060156805, 
       1.926671084880087}, {-0.9179122463462152, 
       1.8352799099744614`}, {-0.9636182053209238, 
       1.7482043801012896`}, {-1.0114863829398064`, 
       1.6654444952605718`}, {-1.0617489314882753`, 
       1.5866198001898713`}, {-1.0723745835640643`, 1.5714977270274053`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0795738340094907`, 
       1.561251994231513}, {-1.1146380032517431`, 
       1.5113498396267515`}, {-1.1701535982302098`, 
       1.4396346135712121`}, {-1.228295716423675, 
       1.3714741220232534`}, {-1.2621192157694907`, 
       1.3337095064635933`}, {-1.2968741100224783`, 
       1.2969847686764147`}, {-1.3738004128457828`, 
       1.2281879096385966`}, {-1.41687847795242, 1.1937485919515627`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.42665919623922, 
       1.1859292699032613`}, {-1.4552896906904775`, 
       1.1630402498996264`}, {-1.5260674308650808`, 
       1.1090957278593268`}, {-1.6004570239576545`, 
       1.0575429832248648`}, {-1.6784584699681993`, 
       1.0083820159962402`}, {-1.7600717688967147`, 
       0.9616128261734533}, {-1.845673312653778, 
       0.9170270011499547}, {-1.847435639883611, 0.9161923063672883}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.8587526089663595`, 
       0.9108322263043688}, {-1.9356394931499659`, 
       0.8744161283191951}, {-2.029970310385278, 
       0.8337802076811746}, {-2.128665764359715, 
       0.795119239235893}, {-2.231153061087912, 
       0.7586485090421747}, {-2.324682097861766, 0.7283328423721355}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.3365941283191844`, 
       0.7244717832062678}, {-2.340678033153599, 
       0.7231480627666825}, {-2.455025877146701, 
       0.68945033983687}, {-2.574425710661365, 
       0.6574692258292074}, {-2.6772127679124593`, 
       0.6322581068791231}, {-2.7840524655211554`, 
       0.608075956203028}, {-2.8216393794066956`, 0.6002229195555874}}]}, 
     {Arrowheads[{{0.006762413570216554, 1.}}], 
      ArrowBox[{{-2.833896856864644, 
       0.5976619639002343}, {-2.8951374201577353`, 0.5848669685644888}, {-3., 
       0.564632372101296}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.5617661425023475, 3.}, {0.57212991700239, 
       2.945411476484711}, {0.5852836533069736, 2.8791681116752623`}, {
       0.5987194869169028, 2.8144433218924707`}, {0.6264922609189559, 
       2.689383556535263}, {0.6555578687408645, 2.569900358669898}, {
       0.671176164220796, 2.511340370463793}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{0.6744030980433215, 2.4992411495960747`}, {0.686025940114944,
        2.4556619065531833`}, {0.7201213904792843, 2.33941234611836}, {
       0.7560907976767901, 2.228173899289825}, {0.7940302809366161, 
       2.1217146915303227`}, {0.8322458227943943, 2.024227337233586}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.837148890655321, 2.0127061345110304`}, {0.8743937070774358,
        1.9265734655210385`}, {0.9179390409652326, 1.83518624433661}, {
       0.9636466893736587, 1.7481145131467033`}, {1.0115166523027141`, 
       1.6653582719513185`}, {1.0617810942739583`, 1.5865370765493296`}, {
       1.0723523685779084`, 1.5714936377346713`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.0795520181131546`, 1.5612481853742128`}, {
       1.114672179808951, 1.5112704827396115`}, {1.1701899089076917`, 
       1.4395584905221634`}, {1.228334281570181, 1.371401099896986}, {
       1.2621590335785418`, 1.3336382821869746`}, {1.296915220239752, 
       1.2969152986058818`}, {1.37384586105033, 1.2281206044993986`}, {
       1.4168529910767553`, 1.193741107544334}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.4266340544139176`, 1.185922217118243}, {
       1.4553398468633183`, 1.1629750754814843`}, {1.5261196342082066`, 
       1.1090338600442158`}, {1.600511358297131, 1.0574842635422885`}, {
       1.6785150191300915`, 1.0083262859757025`}, {1.7601306167070883`, 
       0.9615599273444577}, {1.8457345493194524`, 0.9169767897835842}, {
       1.8474097517195676`, 0.9161834296761721}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.8587269025803081`, 0.9108237334258205}, {
       1.9357032152585156`, 0.8743684754281124}, {2.030036614524278, 
       0.833734984278042}, {2.1287347471167393`, 0.7950763163333734}, {
       2.231224809792383, 0.7586077425184183}, {2.324657070642554, 
       0.7283260370705226}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.3365691980696153`, 0.7244652770854622}, {2.340752687597803,
        0.7231093942620754}, {2.455103541324734, 0.6894136524716846}, {
       2.5745064922705847`, 0.6574344087775209}, {2.677296461024194, 
       0.632224698492617}, {2.7841391726356037`, 0.6080438955617071}, {
       2.82161400254007, 0.6002149318744636}}]}, 
     {Arrowheads[{{0.0067634367390248295`, 1.}}], 
      ArrowBox[{{2.8338715229017617`, 0.5976541815774785}, {
       2.8952272480369414`, 0.5848361982720878}, {3., 0.564620622216954}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.3995255712406327`, -3.}, {
       1.427942747238401, -2.9401390137208683`}, {
       1.4611581245718224`, -2.8733120517760735`}, {
       1.4951624675187745`, -2.8079645981423}, {
       1.529955776079257, -2.7440966528195476`}, {
       1.56553805025327, -2.6817082158078165`}, {
       1.6019092900408136`, -2.620799287107107}, {
       1.639069495441888, -2.5613698667174187`}, {
       1.639477792309308, -2.5607463559340236`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.6463377882994297`, -2.550270445352298}, {
       1.6770984064025571`, -2.5032958574442294`}, {
       1.7160757628688856`, -2.4464531620930163`}, {
       1.756001564840873, -2.39084178066378}, {
       1.79687581231852, -2.3364617131565195`}, {
       1.838698505301826, -2.283312959571236}, {
       1.8814696437907912`, -2.2313955199079283`}, {
       1.9251892277854157`, -2.180709394166597}, {
       1.9503189798104075`, -2.152886649994389}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.9587123188805546`, -2.1435938513441255`}, {
       1.9698572572856994`, -2.131254582347242}, {
       2.0214953145030345`, -2.075387651763408}, {
       2.074487016786276, -2.020985169694306}, {
       2.12548396604, -1.9757424711642335`}, {
       2.176480915293724, -1.9304997726341608`}, {
       2.230611985671612, -1.8877891200843258`}, {
       2.2834894075998347`, -1.8440656491423955`}, {
       2.3292648229677355`, -1.8079210644690857`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.3391530625576737`, -1.8002392921813826`}, {
       2.3888763474706214`, -1.7627153549706425`}, {
       2.443478492337382, -1.7233290489639093`}, {
       2.4993530871583873`, -1.684801970343272}, {
       2.556500131933637, -1.6471341191087305`}, {
       2.614919626663131, -1.6103254952602846`}, {
       2.6746115713468703`, -1.5743760987979345`}, {
       2.735575965984854, -1.53928592972168}, {
       2.758253297639201, -1.5268123300373313`}}]}, 
     {Arrowheads[{{0.0103346421986724, 1.}}], 
      ArrowBox[{{2.7692251868663114`, -1.5207772745869799`}, {
       2.7979383479405766`, -1.5049836846544555`}, {
       2.861824254577531, -1.4713980602191947`}, {
       2.927233685895718, -1.4385290564158977`}, {
       2.994166641895138, -1.4063766732445642`}, {
       3., -1.4036979486246557`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.001413183632558425, 3.}, {0.0014289740731431762`, 
       2.9664809715971194`}, {0.0014932592790717631`, 2.8387138145373205`}, {
       0.001560435031175757, 2.71645696431703}, {0.001630637337258238, 
       2.5994871599866904`}, {0.001696351505779328, 2.499114069939533}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.001704610797136801, 2.4865919223903594`}, {
       0.00178026206604944, 2.380642806710649}, {0.0018600826220273006`, 
       2.2782819978930156`}, {0.001943625104391543, 2.1802675055997223`}, {
       0.0020421417495262214`, 2.075103917104008}, {0.0021346489686494487`, 
       1.9857060991461257`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.0021477540913004065`, 1.9731839557361819`}, {
       0.0022560651675202423`, 1.878392022988401}, {0.0023689611184236057`, 
       1.7887269067277896`}, {0.002488983948067921, 1.70247754751288}, {
       0.0026154093808889644`, 1.620187173043465}, {0.002748237416886735, 
       1.5418557833195448`}, {0.0028784538058307277`, 1.472298492835277}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.002903404638914545, 1.4597763674751378`}, {
       0.003033803512775355, 1.396714822411974}, {0.0031879460013919964`, 
       1.3291949798358962`}, {0.0035196520743328388`, 1.203901434742942}, {
       0.0036179077453089327`, 1.1702944218273832`}, {0.0037189063494301, 
       1.137625551081971}, {0.003953794252720365, 1.073805876116667}, {
       0.004203517624613164, 1.0135663721011605`}, {0.0044557981012716495`, 
       0.958892938006487}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.004513578638773167, 0.9463709210399484}, {
       0.004676986140390028, 0.9109577595121191}, {0.0052036133470733095`, 
       0.81873354338059}, {0.005789692295164446, 0.7358893284984357}, {
       0.006441516035164875, 0.6614207196575184}, {0.007973776560126995, 
       0.5343602674730957}, {0.009463315655718877, 0.4506949142718438}, {
       0.00959330408745704, 0.44551584453136145`}}]}, 
     {Arrowheads[{{0.014358405510616108`, 1.}}], 
      ArrowBox[{{0.009907496076429252, 0.43299763655678053`}, {
       0.011231827422758463`, 0.38023290733870974`}, {0.015832074411820538`, 
       0.2699008450190179}, {0.02231783353068145, 0.19140415526675875`}, {
       0.03145895141364626, 0.13586955353270191`}, {0.05438346904996427, 
       0.07897341967167558}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{0.0014506808604136897`, -3.}, {
       0.0014669862196169542`, -2.9662870091693017`}, {
       0.0015329802673627665`, -2.838530450302336}, {
       0.0016019416439587435`, -2.716283644253285}, {
       0.0016740099670288497`, -2.5993233562876146`}, {
       0.0017413661344743035`, -2.499114074293667}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.001749836208361428, -2.4865919268851404`}, {
       0.0018276116264677993`, -2.3804965514850407`}, {
       0.0019095536657781703`, -2.2781438289863267`}, {
       0.0019953164832908475`, -2.1801370022015645`}, {
       0.002096454255291154, -2.0749786765202245`}, {
       0.0021912944969975554`, -1.9857061137447898`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.002204735675971489, -1.973183970690857}, {
       0.002316069505228263, -1.8782767455995895`}, {
       0.002431969301341217, -1.788616270254199}, {
       0.0025551856943664517`, -1.702371399927098}, {
       0.002684975122239395, -1.6200853451646051`}, {
       0.002821337584960047, -1.5417581059667205`}, {
       0.0029548383037517646`, -1.4722985372846928`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.0029804356140404084`, -1.459776413232865}, {
       0.0031145025296807787`, -1.3966249505120096`}, {
       0.0032727468411534624`, -1.3291087867496516`}, {
       0.0036132800570597666`, -1.2038221634021635`}, {
       0.003714150165035092, -1.170217133529017}, {
       0.0038178362107799753`, -1.1375501968848285`}, {
       0.004058980511332016, -1.073732881324576}, {
       0.004315355934648945, -1.0134957091377577`}, {
       0.004574031319970625, -0.9588931226303054}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.00463335333943046, -0.9463711128715325}, {
       0.004801427893859499, -0.9108930352550615}, {
       0.005342074311669638, -0.8186742804311504}, {
       0.005943755928185174, -0.7358350839746552}, {
       0.00661293348351192, -0.6613710851942066}, {
       0.008185991314850611, -0.5343187491326246}, {
       0.009715190489377596, -0.4506591114921388}, {
       0.009847679246724736, -0.4455176959595787}}]}, 
     {Arrowheads[{{0.014370472064246268`, 1.}}], 
      ArrowBox[{{0.01017025452955741, -0.432999701204519}, {
       0.011530793449891249`, -0.3802020444242633}, {
       0.01625354713590691, -0.26987796926195734`}, {
       0.022912048993671493`, -0.19138723337544106`}, {
       0.03229666658327931, -0.1358570545493721}, {
       0.055832291701803496`, -0.07896525430240652}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.028584450713532255`, -0.00021542396120896075`}, \
{-0.049465626783557905`, -0.00012400946917222284`}, {-0.07367827910690312, \
-0.00008322305552054503}, {-0.10988763124407565`, -0.00005584812438180424}, \
{-0.16358417493866811`, -0.00003747805321181209}, {-0.24296332660950895`, \
-0.00002516479891465413}, {-0.2794126967613109, -0.000021881926582132757`}, \
{-0.3213308876404582, -0.000019027303142062263`}, {-0.36954269535522066`, \
-0.000016545055337758896`}, {-0.396427104823636, -0.00001543568952870007}, \
{-0.4252662251348387, -0.000014400677005008053`}, {-0.4998971795823707, \
-0.000012237426647623363`}, {-0.5294702124151979, \
-0.000011618849823179678`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.5419923626871037, -0.00001135692498124044}, \
{-0.5877538146867772, -0.000010399736253932485`}, {-0.6519074579837622, \
-9.376660681670591*^-6}, {-0.7227446589928286, -8.456806457131928*^-6}, \
{-0.8014763443985705, -7.626112114619354*^-6}, {-0.8887752512479848, \
-6.876765728745569*^-6}, {-0.9856277365627452, -6.201176061298868*^-6}, \
{-1.0428783736378922`, -5.876293516445959*^-6}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.0554005239123356`, -5.805233555264186*^-6}, \
{-1.093020157364525, -5.591751874067549*^-6}, {-1.1234859931473649`, \
-5.435899294429987*^-6}, {-1.1548010049663697`, -5.284390615243242*^-6}, \
{-1.2271997973687037`, -4.98989047255966*^-6}, {-1.290033182454261, \
-4.7580855533505325`*^-6}, {-1.3560836879056273`, -4.537049163777828*^-6}, \
{-1.4238270154142598`, -4.321153274077013*^-6}, {-1.4949559870374247`, \
-4.115538384119976*^-6}, {-1.556286534894522, -3.954737084502355*^-6}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.568808685169124, -3.9219055167352625`*^-6}, \
{-1.5696420500030843`, -3.919720534649848*^-6}, {-1.6480566515392003`, \
-3.7332157664097597`*^-6}, {-1.7303590302143694`, -3.5556630127541047`*^-6}, \
{-1.8168358154520647`, -3.38641235372079*^-6}, {-1.8891019340475974`, \
-3.256952360308189*^-6}, {-1.9642355221553194`, -3.1326179832342054`*^-6}, \
{-2.0423613199190624`, -3.0131729116037226`*^-6}, {-2.0696946961540106`, \
-2.974552171589728*^-6}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.082216846428643, -2.956858978256575*^-6}, \
{-2.1236040674826566`, -2.8983808345216247`*^-6}, {-2.208088504989934, \
-2.788005441092796*^-6}, {-2.295939372584726, -2.6818104204221193`*^-6}, \
{-2.3872814104108637`, -2.579559461614479*^-6}, {-2.482239358612178, \
-2.481016253774759*^-6}, {-2.580991719906321, -2.3861337465064217`*^-6}, \
{-2.5831028574141164`, -2.384259551864144*^-6}}]}, 
     {Arrowheads[{{0.016146387938266046`, 1.}}], 
      ArrowBox[{{-2.5956250076887564`, -2.373142821254287*^-6}, \
{-2.6837335393413486`, -2.2949231234124915`*^-6}, {-2.7906143705567015`, \
-2.2072354245971967`*^-6}, {-2.9017837671918207`, -2.1229216901647646`*^-6}, \
{-3., -2.054031449503515*^-6}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.10459930504647336`, -0.5660621674699594}, {
       0.1266655842056956, -0.4674266275073147}, {
       0.15335614446529225`, -0.3860040935358827}, {
       0.20282166954844374`, -0.29179974943764886`}, {
       0.2683315272942499, -0.22055578106829588`}, {
       0.2766156974093194, -0.21374698745049336`}, {
       0.28515562354676666`, -0.20714838842907013`}, {
       0.30794025121295415`, -0.1928665345193871}, {
       0.332545379136014, -0.17956930953227385`}, {
       0.3638796967874691, -0.16497544566677697`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.3752310556101891, -0.15968858455845825`}, {
       0.38569762007449526`, -0.1548138137518746}, {
       0.4473539064904953, -0.13347732202550586`}, {
       0.518864798472866, -0.11508221529003962`}, {
       0.6256769744342741, -0.09552760779077471}, {
       0.7545099710918328, -0.07932264454287381}, {
       0.8285922751956282, -0.07224144258258096}, {
       0.8658776657034465, -0.06929354036473835}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.8783608606017811, -0.06830657905293862}, {
       0.9100767815664818, -0.06579901690917732}, {
       0.999595822568734, -0.059929155930678955`}, {
       1.0977817305667252`, -0.054565648055101924`}, {
       1.2055917530281246`, -0.04967007059242792}, {
       1.3241688031939323`, -0.045219880225190405`}, {
       1.378588437163043, -0.04352898875571499}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.3911045471888848`, -0.043140096326087035`}, {
       1.4544237120884844`, -0.04117268442023313}, {
       1.5242149982541453`, -0.03928696181199824}, {
       1.5972673107361182`, -0.03748609064439982}, {
       1.6744619709391115`, -0.03578408347379312}, {
       1.7544517293171316`, -0.03413887579720137}, {
       1.8384761677639045`, -0.032573495003867574`}, {
       1.8918544544905327`, -0.03167137643732323}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.9043748168213295`, -0.03145977632778206}, {
       1.9266654866436637`, -0.03108305335032078}, {
       2.019156424915119, -0.029662827622359465`}, {
       2.116092260131455, -0.028308259135051556`}, {
       2.2176228084403347`, -0.02701495373273441}, {
       2.3239044245838976`, -0.025778681789014792`}, {
       2.4052173338875216`, -0.02492160690510994}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.4177387886075037`, -0.02478962510243731}, {
       2.45276999650173, -0.02442038030851561}, {
       2.5198660978884666`, -0.023767811570291293`}, {
       2.5888009875329656`, -0.023132288795539156`}, {
       2.6596239569776023`, -0.02251334306489327}, {
       2.7323857842151225`, -0.021910535546221754`}, {
       2.8071387336886415`, -0.02132345749462679}, {
       2.883936556291647, -0.020751730252444617`}, {
       2.9186062528502137`, -0.02050709156325612}}]}, 
     {Arrowheads[{{0.0027500679777753773`, 1.}}], 
      ArrowBox[{{2.9311280913917725`, -0.020418734107866737`}, {
       2.9628344893679954`, -0.020195005249245526`}, {
       3., -0.019946466632655757`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.405817273719032, 3.}, {1.4378540840702727`, 
       2.933139255962535}, {1.4712378251160247`, 2.8665836729897247`}, {
       1.5053943290280412`, 2.8015315379203054`}, {1.540323595806322, 
       2.7379828507542765`}, {1.576025625450867, 2.675937611491639}, {
       1.6125004179616766`, 2.6153958201323917`}, {1.646666774668382, 
       2.561239097365261}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{1.6534643489128371`, 2.5507233903282565`}, {
       1.6880799110223672`, 2.498319220421062}, {1.7272625164323177`, 
       2.4416585718932273`}, {1.7673736944286718`, 2.3862496909172792`}, {
       1.8084134450114293`, 2.332092577493218}, {1.8503817681805905`, 
       2.2791872316210435`}, {1.8932786639361552`, 2.227533653300756}, {
       1.937104132278123, 2.1771318425323556`}, {1.957959516405905, 
       2.153693101760471}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{1.9662834497425234`, 2.144338082716753}, {
       1.9879087181012076`, 2.120034092146451}, {2.0400457591822696`, 
       2.0644337943486324`}, {2.090279363195889, 2.018148493240721}, {
       2.1405129672095087`, 1.97186319213281}, {2.193838908527717, 
       1.9281722073288161`}, {2.2459279149240903`, 1.8834434960032551`}, {
       2.2972179428006765`, 1.8413895714387571`}, {2.3378319085446013`, 
       1.8095657351915255`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.3476885697478855`, 1.8018423630378306`}, {
       2.349764002040152, 1.8002161190549664`}, {2.4035660926425173`, 
       1.7599231388518828`}, {2.4586242146077715`, 1.7205106308295066`}, {
       2.5149383679359154`, 1.6819785949878376`}, {2.5725085526269487`, 
       1.6443270313268759`}, {2.6313347686808717`, 1.6075559398466213`}, {
       2.691417016097684, 1.571665320547074}, {2.7528794454704246`, 
       1.5365819913470191`}, {2.767072392794541, 1.5288395464129192`}}]}, 
     {Arrowheads[{{0.009940411550774094, 1.}}], 
      ArrowBox[{{2.7780652604479488`, 1.5228427882674327`}, {
       2.8158462073921333`, 1.502232770165241}, {2.880317301862809, 
       1.46861765700174}, {2.9462927288824527`, 1.435736651856516}, {3., 
       1.410150874274879}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-1.4057128569372739`, -3.}, {-1.4377945246479569`, \
-2.9330450112705404`}, {-1.471177001887756, -2.866491334830187}, \
{-1.505332215482433, -2.801441068417384}, {-1.5402601654319878`, \
-2.737894212032131}, {-1.5759608517364208`, -2.675850765674428}, \
{-1.6124342743957314`, -2.6153107293442757`}, {-1.6465507094711742`, \
-2.561232682346363}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-1.6533466434117563`, -2.550715916282504}, \
{-1.6880109387324056`, -2.4982375371344423`}, {-1.7271920828981238`, \
-2.441578543846717}, {-1.7673017683954293`, -2.3861712857704527`}, \
{-1.8083399952243222`, -2.332015762905649}, {-1.8503067633848025`, \
-2.2791119752523064`}, {-1.8932020728768701`, -2.227459922810424}, \
{-1.9370259237005252`, -2.1770596055800033`}, {-1.957830939101731, \
-2.1536773044978736`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.9661548390164898`, -2.1443222557160726`}, \
{-1.987828631011575, -2.119963555650359}, {-2.0399637488413913`, \
-2.064364918801344}, {-2.0901959071150706`, -2.018080680429213}, \
{-2.14042806538875, -1.9717964420570815`}, {-2.1937525072825563`, \
-1.9281064874086735`}, {-2.245840035728312, -1.883378819270776}, \
{-2.2971282600335114`, -1.8413261756428305`}, {-2.3376939725700945`, \
-1.8095400052697426`}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-2.3475506168062075`, -1.801816611462387}, \
{-2.349672476880775, -1.8001539805945765`}, {-2.403472686270103, \
-1.7598622341260146`}, {-2.458528888201495, -1.7204509362371443`}, \
{-2.514841082674952, -1.6819200869279656`}, {-2.5724092696904735`, \
-1.644269686198479}, {-2.6312334492480596`, -1.6074997340486838`}, \
{-2.6913136213477102`, -1.5716102304785804`}, {-2.752773933270341, \
-1.5365279950987114`}, {-2.7669292836303097`, -1.5288060359229985`}}]}, 
     {Arrowheads[{{0.009946789049411292, 1.}}], 
      ArrowBox[{{-2.777922143482539, -1.5228092634769201`}, \
{-2.8157385322968667`, -1.5021798475196195`}, {-2.8802074184272883`, \
-1.4685657877413048`}, {-2.946180591661605, -1.435685815763767}, {-3., \
-1.4100465510635793`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.4056919811329753`, 3.}, {-1.4377676755378177`, 
       2.9330559778885688`}, {-1.47114951554856, 
       2.8665020795978604`}, {-1.5053040768444337`, 
       2.8014515957420594`}, {-1.5402313594254387`, 
       2.7379045263211643`}, {-1.575931363291575, 
       2.6758608713351757`}, {-1.6124040884428426`, 
       2.615320630784094}, {-1.6465269895075354`, 2.5612311166494}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.653323050517027, 
       2.550714432540114}, {-1.6879793063371404`, 
       2.4982470420662333`}, {-1.7271597000142627`, 
       2.441587856169351}, {-1.7672686168447005`, 
       2.3861804092471672`}, {-1.808306056828454, 
       2.332024701299682}, {-1.8502720199655227`, 
       2.2791207323268954`}, {-1.893166506255907, 
       2.2274685023288074`}, {-1.9369895156996069`, 
       2.1770680113054186`}, {-1.957804679205127, 2.1536737749520025`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.9661284738590705`, 
       2.1443186325126926`}, {-1.9877912480393178`, 
       2.119971763504962}, {-2.039925364800102, 
       2.0643729333823604`}, {-2.090156511149383, 
       2.0180885713468393`}, {-2.140387657498664, 
       1.9718042093113182`}, {-2.193711021064872, 
       1.9281141347906308`}, {-2.245797497744309, 
       1.8833863452640098`}, {-2.2970848565652404`, 
       1.841333448722102}, {-2.337665970221393, 1.8095344855728184`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.347522528979793, 
       1.8018109826795063`}, {-2.3496281895033757`, 
       1.8001610077191925`}, {-2.4034274965587143`, 
       1.7598690222552813`}, {-2.458482777731257, 
       1.7204574923303684`}, {-2.5147940330210026`, 
       1.6819264179444537`}, {-2.572361262427952, 
       1.6442757990975374`}, {-2.631184465952105, 
       1.6075056357896194`}, {-2.691263643593462, 
       1.5716159280206996`}, {-2.7527229410919922`, 
       1.5365334946878235`}, {-2.766900453983875, 1.528799274938827}}]}, 
     {Arrowheads[{{0.009948081023176285, 1.}}], 
      ArrowBox[{{-2.7778932582332567`, 
       1.5228024005666585`}, {-2.8156865041876666`, 
       1.5021851546880365`}, {-2.880154332880485, 
       1.4685709080213383`}, {-2.9461264271704475`, 
       1.4356907546877296`}, {-3., 1.4100251273847946`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{0.2150295046140975, -3.}, {
       0.21774906947443803`, -2.96215485648214}, {
       0.22280139775466587`, -2.8949898059008365`}, {
       0.23325673884227746`, -2.7652072800884717`}, {
       0.24417965929943025`, -2.6414881880764307`}, {
       0.25538947722480143`, -2.5263907752416612`}, {
       0.25809462941659445`, -2.5009912883904963`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.2594207908823431, -2.4885395598652047`}, {
       0.26711380018743086`, -2.416307583681658}, {
       0.27819796550453507`, -2.3197762787258553`}, {
       0.28969484117654126`, -2.2271131294958066`}, {
       0.301640527874956, -2.1381701286687163`}, {
       0.3140711262712857, -2.0527992689217895`}, {
       0.32370219545100176`, -1.991862092741071}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.3256570456882032, -1.9794934708270941`}, {
       0.3270227370370369, -1.9708525429322314`}, {
       0.340531460843716, -1.8921819433772473`}, {
       0.35463339836282953`, -1.8166394629340425`}, {
       0.3693646502658841, -1.744077094279822}, {
       0.38887936698640746`, -1.6565694522986283`}, {
       0.4095416691817139, -1.573037770574281}, {
       0.43141430427661576`, -1.4932873293082813`}, {
       0.4322921691208329, -1.4903937046374771`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4359275116461846, -1.4784108613928977`}, {
       0.4538907138312609, -1.419200419886115}, {
       0.47785981969715674`, -1.3480185118290529`}, {
       0.5031647533122725, -1.2802284046333412`}, {
       0.5298055146766082, -1.2158300982989803`}, {
       0.5577821037901639, -1.1548235928259696`}, {
       0.6183557482779889, -1.0417236833559314`}, {
       0.6328855654581587, -1.0196383466253889`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6397679427040706, -1.0091771262880789`}, {
       0.685498669788801, -0.939666375115158}, {
       0.7051179779514812, -0.912773924463563}, {
       0.7252987999152175, -0.8866511123657989}, {
       0.7680225618760588, -0.8399121602898345}, {
       0.8132629476510909, -0.7956369803696767}, {
       0.9090812811347115, -0.7117620959623197}, {
       0.9611488878145096, -0.6732061345803627}, {
       0.988348404784238, -0.6551865101218829}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.9987875050778041, -0.6482706274911796}, {
       1.0161958124367263`, -0.6367376594088902}, {
       1.0743684796052522`, -0.6022647872193195}, {
       1.1359304536070902`, -0.5696221282002023}, {
       1.23348919820328, -0.5246414440694781}, {
       1.3394349695007073`, -0.48332887125470453`}, {
       1.4545081605459917`, -0.44530278162865256`}, {
       1.4548600441896156`, -0.4452038662397303}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.466914967092693, -0.44181519669230407`}, {
       1.579449164385753, -0.41018154706409293`}, {
       1.6458943733040319`, -0.39363136289782075`}, {
       1.7151831929058754`, -0.3777574463900732}, {
       1.787427974340604, -0.3625307269131191}, {
       1.8627410687575376`, -0.3479221338392273}, {
       1.9412348273059963`, -0.3339025965406668}, {
       1.955193256023887, -0.3316054745186388}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{1.9675492066248748`, -0.3295720704154793}, {
       2.0230216011353, -0.32044304438970633`}, {
       2.1082137413947692`, -0.3075144067586147}, {
       2.196923599233724, -0.29508761301966085`}, {
       2.2893560258983996`, -0.28315315798056856`}, {
       2.3857443342033156`, -0.27170755658304757`}, {
       2.463937985518718, -0.2631670422101225}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.476386105519059, -0.2618074261033112}, {
       2.486243567650215, -0.26073076840034604`}, {
       2.591008769740839, -0.25020275300571193`}, {
       2.7001949839769326`, -0.24010346997239332`}, {
       2.813957253860238, -0.23041287887363818`}, {
       2.9324506228924974`, -0.22111093928269465`}, {
       2.9753309648690496`, -0.21800617596934121`}}]}, 
     {Arrowheads[{{0.00048759454553421746`, 1.}}], 
      ArrowBox[{{2.98782041979896, -0.21710187344555604`}, {
       3., -0.21622000748933506`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.1889731961765649, 3.}, {0.18998529672442657`, 
       2.98372811615178}, {0.1944944734579826, 2.914563581231549}, {
       0.19911578801791094`, 2.84692719753276}, {0.2038492404042116, 
       2.7808189650554125`}, {0.2136525586559297, 2.653186953765043}, {
       0.22390442821313694`, 2.5316675473604415`}, {0.22678814842977446`, 
       2.500560199618828}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.22794402357025545`, 2.488091510828084}, {
       0.23465142385291546`, 2.4157372540485578`}, {0.24594012035234722`, 
       2.3048725820363454`}, {0.2577705177114322, 2.1990735313238043`}, {
       0.2701426159301705, 2.098340101910934}, {0.2835440609887327, 
       1.999942885996188}, {0.28495747429934265`, 1.9905191192860587`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.28681482078754655`, 1.978135480421672}, {
       0.29761015943348795`, 1.9061588319830851`}, {0.3088886913109324, 
       1.8363981302971486`}, {0.3205518485776399, 1.769209795821721}, {
       0.34515708824433206`, 1.642173651033449}, {0.37167597636453964`, 
       1.5242972426803836`}, {0.381567182774507, 1.4865465732669376`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.3847410261805963, 1.474433317489302}, {0.4003586108692378, 
       1.414827415824639}, {0.4224800906579758, 1.3407564125338622`}, {
       0.4459688973431361, 1.2701821477231452`}, {0.47090339551710797`, 
       1.2029261268156761`}, {0.4965260607867951, 1.1407137973873045`}, {
       0.5529704763088862, 1.0242804298953723`}, {0.5628495051165687, 
       1.0078418628482968`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5692997245808226, 0.9971087870373395}, {0.615824574525338, 
       0.9196920814019347}, {0.6858603928883815, 0.8258025458453622}, {
       0.7638499688502479, 0.7414656171640253}, {0.7859020350170809, 
       0.7200608098284036}, {0.8085907356849018, 0.6992739212248308}, {
       0.8546170515008422, 0.6635277531496393}, {0.9028344774500164, 
       0.6299078339554438}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.9134347128772066, 0.6232427158428236}, {
       1.0061012618857437`, 0.5652442203335075}, {1.1206543394958899`, 
       0.5074654131897034}, {1.1827044297987932`, 0.48084414729229136`}, {
       1.248249399047353, 0.45559326981417736`}, {1.3540855202245483`, 
       0.4200377854902142}, {1.3674127012104522`, 0.416243044638998}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.3794561528487828`, 0.41281382896540897`}, {
       1.468903966477511, 0.3873447314279835}, {1.593487368939937, 
       0.3572213824088004}, {1.6596855009789784`, 0.3430318706595128}, {
       1.7286183587455213`, 0.3293750132139803}, {1.8004284250151628`, 
       0.31624477907613857`}, {1.8682088698454535`, 0.30483363680648706`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.880568343111682, 0.3028233608428794}, {1.953267288736852, 
       0.29155181045321943`}, {2.0345329629420643`, 0.27994410357695193`}, {
       2.1191873832122967`, 0.2687989333966857}, {2.2073489879241324`, 
       0.25809381371682566`}, {2.2991362154541513`, 0.24780625834177675`}, {
       2.3773897062566194`, 0.23970293545072238`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.3898452537923873`, 0.2384131358209272}, {2.394667504178937,
        0.23791378107594388`}, {2.494157450712763, 0.22840881966525148`}, {
       2.597850238819965, 0.21928840383763}, {2.705908687602213, 
       0.21053693537049345`}, {2.8184956161611785`, 0.20213881604125564`}, {
       2.8890191934961353`, 0.1972918292849855}}]}, 
     {Arrowheads[{{0.003940926082654584, 1.}}], 
      ArrowBox[{{2.901511873192809, 0.19643322489581072`}, {2.935773843598532,
        0.19407844762733056`}, {3., 0.19000912552040305`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.19311829515739398`, 3.}, {-0.19313843602000397`, 
       2.9996798092451304`}, {-0.19768936634902112`, 
       2.930611418153908}, {-0.2023447228923569, 
       2.8631632423427864`}, {-0.2119687146219843, 
       2.733127536560844}, {-0.22205336416625512`, 
       2.609022019594581}, {-0.23172092552367335`, 2.500619802437396}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.23285173922399974`, 
       2.4881488821071236`}, {-0.24373349557083374`, 
       2.3769495351949264`}, {-0.2553289774311415, 
       2.268982567761535}, {-0.26764792709320323`, 
       2.1653474472322385`}, {-0.2805610850536803, 
       2.066444887912879}, {-0.2912172167809138, 1.9907301537531348`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.2930681672594597, 
       1.9783456623030318`}, {-0.3029069158810802, 
       1.91337960180903}, {-0.3146915538019493, 
       1.841181110382752}, {-0.32692694110564685`, 
       1.7717252133800239`}, {-0.3396452785757098, 
       1.704901780805684}, {-0.35287876699567483`, 
       1.6406006826645723`}, {-0.3810199998194586, 
       1.5191249697013882`}, {-0.3894927494402298, 1.4870911276082175`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3926946740896826, 
       1.4749852643164063`}, {-0.4017389219089074, 
       1.4407906970908753`}, {-0.4237158726490183, 
       1.3661043618039956`}, {-0.44702174999473904`, 
       1.2948824819457585`}, {-0.4709712070482399, 
       1.2288987158344142`}, {-0.49656863150461644`, 
       1.1655537366242503`}, {-0.5236367784764988, 
       1.1053062490527457`}, {-0.574025455653756, 1.009601823306668}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5798592276815392, 
       0.9985215998689999}, {-0.582185239966781, 
       0.9941037488257132}, {-0.647312954182084, 
       0.8941089450802016}, {-0.7197162837854054, 
       0.8041395677430951}, {-0.740606225553815, 
       0.7808003617599544}, {-0.762102502526373, 
       0.7581385483764908}, {-0.8061978917812762, 
       0.7188100080213874}, {-0.8528446278464211, 
       0.6815216207314784}, {-0.917645853245643, 0.6351019852732773}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.9278256512691907, 
       0.6278098004360307}, {-0.9515437097082982, 
       0.6108196336646953}, {-1.061671958331609, 
       0.5474591447495744}, {-1.121399139586664, 
       0.5183038573353587}, {-1.1845451890354834`, 
       0.4906717126207053}, {-1.2856838547400793`, 
       0.4521328725302277}, {-1.3818378544031438`, 0.42111470014516533`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3937552654589247`, 
       0.4172702806534418}, {-1.3954665257417724`, 
       0.41671824780368955`}, {-1.5146515808675642`, 
       0.3841054804352579}, {-1.578006995860435, 
       0.3687490563835092}, {-1.6439973989444563`, 
       0.3539722124190998}, {-1.7127612649055042`, 
       0.33976852515843603`}, {-1.7844505077394541`, 
       0.32614199317704307`}, {-1.859180083614682, 
       0.31306795466286963`}, {-1.8825330310738835`, 0.3093061081311807}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.8948958084545084`, 
       0.3073146305546309}, {-1.9370649486995632`, 
       0.3005217478038646}, {-2.0182200591624735`, 
       0.28847871078797677`}, {-2.102760371171788, 
       0.276914181803155}, {-2.1908008408958826`, 
       0.26580349903734807`}, {-2.282456424503133, 
       0.2551220006785048}, {-2.3779361269666546`, 
       0.244861515147912}, {-2.3916270813752294`, 0.2435077699844145}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.404088462255657, 
       0.24227560357775307`}, {-2.477477891353331, 
       0.23501894478480623`}, {-2.581240080972188, 
       0.2255772386540616}, {-2.6893810591322493`, 
       0.21651934582055204`}, {-2.8020591891425406`, 
       0.20782821534915163`}, {-2.9032193946573037`, 0.20063904044026032`}}]}, 
     {Arrowheads[{{0.0033729075985257143`, 1.}}], 
      ArrowBox[{{-2.915710042336521, 
       0.1997513647931589}, {-2.9194328343120874`, 0.1994867963047343}, {-3., 
       0.19420776456086508`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.19312533015584002`, -3.}, {-0.19314268016175237`, \
-2.9997241790742346`}, {-0.19769370293009494`, -2.93065487863155}, \
{-0.20234915386527186`, -2.8632058121295016`}, {-0.21197334023612835`, \
-2.73316838094732}, {-0.2220581929557946, -2.6090612077043875`}, \
{-0.23172930437108658`, -2.500619904759534}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.23286044782521795`, -2.4881490152470658`}, \
{-0.2437387584859742, -2.3769856015663717`}, {-0.25533447129648756`, \
-2.2690171686712883`}, {-0.2676536210585573, -2.1653809850975136`}, \
{-0.2805669856389719, -2.066477387662757}, {-0.2912277018247644, \
-1.990730497725208}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.29307898178097974`, -1.9783460544465605`}, \
{-0.30291343236150925`, -1.913408761498198}, {-0.31469839899459306`, \
-1.8412087203182677`}, {-0.32693413052322656`, -1.7717513491963652`}, \
{-0.33965282898316435`, -1.7049265147248387`}, {-0.352886696410161, \
-1.6406240834960346`}, {-0.3810287463083495, -1.5191458971359824`}, \
{-0.38950682774064055`, -1.4870921857941084`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.3927087794002668, -1.4749863296463503`}, \
{-0.4017480820313556, -1.4408107676889959`}, {-0.4237254673331598, \
-1.366123606156316}, {-0.44703180112525726`, -1.2949009296116254`}, \
{-0.47098172726319437`, -1.2289164063426594`}, {-0.4965796469931532, \
-1.165570694893254}, {-0.5236483130363958, -1.105322502579203}, \
{-0.5740443631927905, -1.009604744856536}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5798781672737041, -0.9985245382949997}, \
{-0.5821978840627321, -0.9941186753571636}, {-0.6473268120039377, \
-0.8941226472038575}, {-0.7197314685217471, -0.8041521406466005}, \
{-0.7406218118114993, -0.780812613560707}, {-0.7621185008213017, \
-0.7581504871225584}, {-0.8062145569325005, -0.7188215345309679}, \
{-0.8528619834640314, -0.6815327456471119}, {-0.9176694304407638, \
-0.6351088122104387}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.9278492402715122, -0.6278166438559234}, \
{-0.9515624944636265, -0.6108299766511983}, {-1.061692270554986, \
-0.5474687482709267}, {-1.1214202534929776`, -0.518313106965945}, \
{-1.184567130681072, -0.4906806187892446}, {-1.285707416242807, \
-0.4521411676548677}, {-1.3818621253038064`, -0.4211227584548435}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.3937795360709193`, -0.4172783380682707}, \
{-1.3954918238026632`, -0.4167259736333919}, {-1.5146787405450044`, \
-0.3841126754441526}, {-1.5780351358547207`, -0.368755999386414}, \
{-1.6440265536541943`, -0.35397891180648533`}, {-1.7127914701081701`, \
-0.3397749891770418}, {-1.7844818006942242`, -0.32614823001160725`}, \
{-1.8592125027796478`, -0.3130739722113717}, {-1.882557150657204, \
-0.30931345547664063`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.8949199274429487`, -0.3073219742071701}, \
{-1.937098533731732, -0.30052755367752504`}, {-2.018254850917768, \
-0.2884843123112574}, {-2.1027964117050475`, -0.27691958601375855`}, \
{-2.190838173460862, -0.26580871268621864`}, {-2.282495093552502, \
-0.2551270302298275}, {-2.377976178874124, -0.24486636692670505`}, \
{-2.3916510848928967`, -0.2435142044862756}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-2.4041124654054675`, -0.24228203435933895`}, \
{-2.477519374635842, -0.2350236250223339}, {-2.5812830456788842`, \
-0.2255817533629486}, {-2.68942555684448, -0.21652370079478367`}, \
{-2.802105272973858, -0.20783241616407355`}, {-2.903243340207423, \
-0.20064478681749265`}}]}, 
     {Arrowheads[{{0.0033719498476351716`, 1.}}], 
      ArrowBox[{{-2.915733987644359, -0.19975710776121616`}, \
{-2.9194805589082464`, -0.19949084831705274`}, {-3., \
-0.19421492225603554`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.0755273347464116`, -3.}, {
       2.1226814337947637`, -2.933367570222977}, {
       2.1710617552438656`, -2.868005977994069}, {
       2.2205414301899884`, -2.8040944989963927`}, {
       2.271120458633132, -2.741633133229948}, {
       2.3227988405732973`, -2.680621880694735}, {
       2.3755765760104834`, -2.6210607413907536`}, {
       2.3871290424023677`, -2.6083149163070125`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.3955385340015383`, -2.5990367322958887`}, {
       2.436708581415474, -2.5536138584932866`}, {
       2.499413729235073, -2.4879025630789537`}, {
       2.557302534802047, -2.4351573097426105`}, {
       2.6151913403690212`, -2.3824120564062667`}, {
       2.6764320340274526`, -2.332462380893991}, {
       2.736331972449301, -2.281394474252088}, {
       2.7629769743255927`, -2.2596658643612844`}}]}, 
     {Arrowheads[{{0.01135474454269145, 1.}}], 
      ArrowBox[{{2.772681395787182, -2.251752050388449}, {
       2.7976743363105605`, -2.2313706724032687`}, {
       2.860489321001257, -2.182376450918708}, {
       2.9247769265213908`, -2.1344118097984057`}, {
       2.9905371528709623`, -2.0874767490423616`}, {
       3., -2.0810156729231855`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.0803098799982087`, 3.}, {2.11501360557678, 
       2.9504963421414097`}, {2.1631921899348314`, 2.8847890412971697`}, {
       2.2124649343739424`, 2.820538733672729}, {2.2628318388941135`, 
       2.7577454192680873`}, {2.3142929034953443`, 2.6964090980832447`}, {
       2.366848128177635, 2.6365297701182016`}, {2.3920661489167028`, 
       2.6084393341261447`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.400431405215582, 2.5991212477048427`}, {
       2.4277480261763755`, 2.5686931740444185`}, {2.490214900836101, 
       2.5026019790663416`}, {2.547868688828089, 2.4495635898799395`}, {
       2.6055224768200773`, 2.3965252006935374`}, {2.666513273614514, 
       2.3462969457020795`}, {2.726169266887971, 2.2949446370326436`}, {
       2.7683592599938334`, 2.2602062292357425`}}]}, 
     {Arrowheads[{{0.011083553444625688`, 1.}}], 
      ArrowBox[{{2.7780261938756374`, 2.252246666633085}, {2.787305571315818, 
       2.2446062103568893`}, {2.849910106921519, 2.1953041774894793`}, {
       2.9139828737050744`, 2.1470385384304125`}, {2.9795238716664834`, 
       2.09980929317969}, {3., 2.0856940620932454`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.080149945886127, -3.}, {-2.1149270290579567`, \
-2.9503914297298053`}, {-2.1631038037625503`, -2.884686248644372}, \
{-2.2123747011220534`, -2.8204380185353974`}, {-2.262739721136466, \
-2.7576467394028823`}, {-2.3141988638057875`, -2.696312411246826}, \
{-2.366752129130019, -2.6364350340672287`}, {-2.3918938119037603`, \
-2.6084295015872816`}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-2.4002590467673195`, -2.5991113959225935`}, \
{-2.427649769274879, -2.5686006391153424`}, {-2.4901143334462863`, \
-2.5025115947076086`}, {-2.5477664149428616`, -2.4494745972093703`}, \
{-2.6054184964394365`, -2.3964375997111316`}, {-2.666407523959203, \
-2.3462106904271636`}, {-2.726061773069693, -2.294859745857487}, \
{-2.7681752604858967`, -2.260184249239874}}]}, 
     {Arrowheads[{{0.011092714946505138`, 1.}}], 
      ArrowBox[{{-2.777842185120526, -2.2522246754064836`}, \
{-2.787195878776075, -2.2445230103909575`}, {-2.8497981683133413`, \
-2.195222637228368}, {-2.9138686416814914`, -2.146958626369719}, \
{-2.979407298880525, -2.0997309778150095`}, {-3., -2.085535362300744}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-2.0801227279112156`, 3.}, {-2.114897637162412, 
       2.9503938015772806`}, {-2.1630737386633, 
       2.8846885725685767`}, {-2.2123439474472315`, 
       2.8204402954913643`}, {-2.262708263514206, 
       2.757648970345644}, {-2.314166686864223, 
       2.6963145971314155`}, {-2.366719217497283, 
       2.636437175848678}, {-2.3918641791941724`, 2.6084275786978566`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.400229345881275, 
       2.5991094118288967`}, {-2.427616006012123, 
       2.5686027311340354`}, {-2.4900796965172183`, 
       2.502513638106411}, {-2.5477309620272224`, 
       2.4494766091450475`}, {-2.605382227537226, 
       2.3964395801836837`}, {-2.666370391026761, 
       2.3462126404761108`}, {-2.7260237953244832`, 
       2.2948616650670215`}, {-2.7681437775026585`, 2.2601803096338116`}}]}, 
     {Arrowheads[{{0.011094276148210735`, 1.}}], 
      ArrowBox[{{-2.777810644571674, 
       2.2522206658873376`}, {-2.787157129439001, 
       2.244524823036225}, {-2.8497586309067326`, 
       2.195224346748745}, {-2.9138282997276788`, 
       2.1469602362045808`}, {-2.9793661359018397`, 2.099732491403732}, {-3., 
       2.085508293752691}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.9378337400683995, 3.}, {0.9408427694825034, 
       2.990209576079927}, {0.9632413425550989, 2.9206983923978864`}, {
       0.9862263959382359, 2.852659889538626}, {1.0098124734807736`, 
       2.7860610040339147`}, {1.034014119031571, 2.7208686724155218`}, {
       1.058845876439487, 2.6570498312152164`}, {1.0843222895533808`, 
       2.594571416964768}, {1.1092168271194753`, 2.5362217821516553`}, {
       1.1118063868561194`, 2.5305729363396776`}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{1.117024641385473, 2.5191898758036144`}, {
       1.1625736283914267`, 2.419829663777053}, {1.218625403278161, 
       2.3085347454560283`}, {1.277372151779678, 2.2023370271885816`}, {
       1.3388138738959778`, 2.101236508974713}, {1.353977231926727, 
       2.0785348354758013`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.360932448556883, 2.0681219007728275`}, {
       1.4032300236076378`, 2.004796499060967}, {1.4709000548952353`, 
       1.9125803056938875`}, {1.5418239677587702`, 1.8245879288734748`}, {
       1.6160017621982423`, 1.7408193685997284`}, {1.6592374985672467`, 
       1.6942459524658595`}, {1.6745582544946107`, 1.6786025412108592`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.6833200098440786`, 1.66965626317489}, {1.703629995948953, 
       1.6489185484871687`}, {1.7936322186286793`, 1.570112354907939}, {
       1.8883892024609974`, 1.4950724921266132`}, {1.9773270483420244`, 
       1.4278256021671156`}, {2.0706526426945127`, 1.3634733434877169`}, {
       2.0761541788811697`, 1.360013106110591}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.086754040478645, 1.3533462341592806`}, {2.168365985518462, 
       1.3020157160884176`}, {2.270467076813873, 1.2434527199692176`}, {
       2.377398092746845, 1.1875395815322738`}, {2.489601209483479, 
       1.1340315271797436`}, {2.527925968393787, 1.1173598490493803`}}]}, 
     {Arrowheads[{{0.019630728919230712`, 1.}}], 
      ArrowBox[{{2.539408699762647, 1.112364738659069}, {2.607076427023774, 
       1.0829285569116271`}, {2.6677910735952945`, 1.058278978309224}, {
       2.7298237453677303`, 1.0342306707279243`}, {2.791397733532416, 
       1.011460538198619}, {2.8571748101045653`, 0.9881925033737977}, {
       2.924336747318708, 0.9655002760955637}, {2.9929169628953836`, 
       0.9433711246266586}, {3., 0.9411886411010376}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-0.9378050588409109, -3.}, {-0.9408220688239282, \
-2.990183479271457}, {-0.9632201747480125, -2.920672824471555}, \
{-0.9862047494871452, -2.8526348407849613`}, {-1.0097903366226213`, \
-2.786036464925771}, {-1.0339914797357357`, -2.7208446336080794`}, \
{-1.0588227224077833`, -2.6570262835459815`}, {-1.0842986082200587`, \
-2.594548351453574}, {-1.10919262848336, -2.536199174442135}, \
{-1.1117726612188648`, -2.5305710384405704`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.1169908603414245`, -2.5191879525049328`}, \
{-1.1625483273961057`, -2.4198079652117217`}, {-1.2185989475201224`, \
-2.3085139215728314`}, {-1.2773444888554106`, -2.2023170435254644`}, \
{-1.33878495140197, -2.1012173310696203`}, {-1.3539384329015351`, \
-2.0785301622907544`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3608935897852577`, -2.06811718768099}, \
{-1.4031997840555814`, -2.004778094956332}, {-1.4708684357120259`, \
-1.9125626459366316`}, {-1.5417909063713031`, -1.8245709840105195`}, \
{-1.6159671960334132`, -1.7408031091779952`}, {-1.659202104286083, \
-1.6942300238975927`}, {-1.6745150858652238`, -1.6785943641861825`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.6832767878615231`, -1.6696480338977993`}, \
{-1.7035937539824124`, -1.6489029447071217`}, {-1.7935948073380836`, \
-1.5700969061811167`}, {-1.8883505994463567`, -1.4950572192726062`}, \
{-1.9772868337089413`, -1.427810866924544}, {-2.0706107476323066`, \
-1.3634591289045859`}, {-2.076108172979153, -1.3600014435150123`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.0867080054142293`, -1.353334525197746}, \
{-2.1683223412164523`, -1.3020020052127321`}, {-2.2704216144613785`, \
-1.2434394958489827`}, {-2.3773507376723133`, -1.1875268281206466`}, \
{-2.4895518811544837`, -1.1340192293350322`}, {-2.527878972209686, \
-1.1173463889018662`}}]}, 
     {Arrowheads[{{0.01963270132692835, 1.}}], 
      ArrowBox[{{-2.539361687381627, -1.1123512412783347`}, \
{-2.6070250449078904`, -1.0829166994921402`}, {-2.6677386343863074`, \
-1.058267335424215}, {-2.729770228932533, -1.0342192385919702`}, \
{-2.7913431424403186`, -1.0114493101928943`}, {-2.8571190873577224`, \
-0.9881814803138282}, {-2.924279871930004, -0.9654894543025121}, \
{-2.992858913450698, -0.9433605004749804}, {-3., -0.941160112492236}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.9377905483430548, 3.}, {-0.9407998237121488, 
       2.9902083329428724`}, {-0.9631973741135809, 
       2.9206971789602063`}, {-0.9861813780405233, 
       2.8526587051556964`}, {-1.0097663786774302`, 
       2.7860598480759555`}, {-1.0339669192087557`, 
       2.720867544267596}, {-1.0587975428189542`, 
       2.657048730277232}, {-1.08427279269248, 
       2.5945703426514752`}, {-1.1091661936070274`, 
       2.5362207326259716`}, {-1.1117563278166522`, 2.5305703780707165`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.1169743872884732`, 
       2.519187228117855}, {-1.162520558613127, 
       2.4198286637383033`}, {-1.218569774148169, 
       2.3085337926819687`}, {-1.277313840212153, 
       2.2023361194569677`}, {-1.3387527568050799`, 
       2.101235644063301}, {-1.3539193595169892`, 2.0785280855532187`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3608743585657674`, 
       2.0681150055222055`}, {-1.403165965143518, 
       2.0047956749449263`}, {-1.4708329064440373`, 
       1.9125795205458036`}, {-1.5417535807066374`, 
       1.8245871808659322`}, {-1.6159279879313186`, 
       1.7408186559053125`}, {-1.659161956856792, 
       1.6942450365539248`}, {-1.6744932829471553`, 1.6785901282632691`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.6832548371012757`, 
       1.669643653186167}, {-1.7035526450288365`, 
       1.648917440741502}, {-1.7935523720309434`, 
       1.5701100393527188`}, {-1.8883068123784028`, 
       1.4950690867392584`}, {-1.977241218594792, 
       1.4278220311927545`}, {-2.0705632264205374`, 
       1.3634696272644053`}, {-2.076085567175464, 1.3599961649074177`}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-2.08668530786276, 1.35332910072122}, {-2.1682728358556385`, 
       1.3020118749542111`}, {-2.270370046900095, 
       1.243448774262172}, {-2.377297023211198, 
       1.1875355487429862`}, {-2.489495928446237, 
       1.134027421951352}, {-2.527855636875126, 1.1173398988703578`}}]}, 
     {Arrowheads[{{0.019633681907951065`, 1.}}], 
      ArrowBox[{{-2.5393382979967707`, 
       1.1123446269992512`}, {-2.6069667626052118`, 
       1.0829243938872695`}, {-2.6676791530311754`, 
       1.05827479187806}, {-2.729709525688123, 
       1.0342264645507384`}, {-2.7912812202209514`, 
       1.0114563231057236`}, {-2.857055881511232, 
       0.988188271383923}, {-2.9242153586508706`, 
       0.9654960305997939}, {-2.992793068449054, 0.9433668688812281}, {-3., 
       0.9411461283109409}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{0.9344717721339638, -3.}, {
       0.9440657111943058, -2.9691195741901506`}, {
       0.966542963943408, -2.9001035598263263`}, {
       0.9896065375022371, -2.832544981400912}, {
       1.013270587659029, -2.766410437736659}, {
       1.0375492702020201`, -2.701666527656318}, {
       1.0624567409194463`, -2.638279849982641}, {
       1.0867991950034017`, -2.5790672373302757`}, {
       1.1082379481044005`, -2.5305249293866994`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.1132969399029577`, -2.519070198945396}, {
       1.1389606345731322`, -2.460961643667921}, {
       1.1937504731464914`, -2.3480177702142297`}, {
       1.2511687107234788`, -2.240235616969202}, {
       1.3112153473040944`, -2.1376151839328377`}, {
       1.3495118630627356`, -2.078053410133497}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.3562841622333222`, -2.0675205942020916`}, {
       1.3741622776881726`, -2.0397151333765846`}, {
       1.4402813966755468`, -1.9460941275718906`}, {
       1.5095727042662175`, -1.8567521665187552`}, {
       1.5820362004601842`, -1.7716892502171782`}, {
       1.624430721658629, -1.7242143410636646`}, {
       1.6679613068719301`, -1.6780115883881024`}, {
       1.6689074686652559`, -1.677150965921059}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.6781707925416507`, -1.6687251082043746`}, {
       1.7566030131826254`, -1.5973836825624965`}, {
       1.8499554439538006`, -1.5206298934098013`}, {
       1.93729300382436, -1.4520760069223444`}, {
       2.0289502385116673`, -1.3864795369009342`}, {
       2.0710443704747004`, -1.3590069229146755`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.081530785140148, -1.3521629945862168`}, {
       2.124927148015723, -1.32384048334557}, {
       2.2252237323365263`, -1.2641588462562523`}, {
       2.3302764138630594`, -1.2071839911301474`}, {
       2.440521614984303, -1.152665283464422}, {
       2.5224339583667015`, -1.1157227114657904`}}]}, 
     {Arrowheads[{{0.01986134631897381, 1.}}], 
      ArrowBox[{{2.5338488953528215`, -1.110574560234163}, {
       2.555959335700258, -1.100602723259076}, {
       2.6765895760109233`, -1.0509963105141096`}, {
       2.7370974674925073`, -1.02780694664603}, {
       2.8017523646855413`, -1.0041066548370818`}, {
       2.8677713889003296`, -0.9809943389324723}, {
       2.935187538698409, -0.9584569684518239}, {3., -0.9377690897909978}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.12898704966256305`, 1.3575106226003681`}, {
       0.1358741372341734, 1.2887039461588028`}, {0.14312872543856406`, 
       1.223382381173836}, {0.15882145737525116`, 1.1025070405418356`}, {
       0.16729607542045735`, 1.0466618223095456`}, {0.17622272010687615`, 
       0.9936444893623808}, {0.19730959560578532`, 0.8874406365456858}, {
       0.20348812029792473`, 0.8626000790622964}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.20651062963960598`, 0.8504481786026874}, {
       0.22090978763135358`, 0.7925568324272045}, {0.24733940719239347`, 
       0.7078494706178549}, {0.27691456529771746`, 0.6321749447285551}, {
       0.31310743106067734`, 0.5590963122263537}, {0.3540269556307283, 
       0.4944290170083286}, {0.40033366484001764`, 0.4372579642951574}, {
       0.42881028220090395`, 0.40974110181356715`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.4378152271611766, 0.40103965286737114`}, {
       0.4526880845206931, 0.3866680593075177}, {0.4663048587867071, 
       0.37503778884796446`}, {0.4803312227390508, 0.36375733547237243`}, {
       0.5123194466022364, 0.3423700055847059}, {0.546437935433545, 
       0.32224013495438003`}, {0.6192275396908933, 0.2843523960521926}, {
       0.7017205241990625, 0.2509248715443508}, {0.795202074253127, 
       0.22142757674693778`}, {0.8673120092902934, 0.20305331870145937`}, {
       0.8895078884804011, 0.19831471411327767`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.9017540694159245, 0.19570027344743382`}, {
       0.945969004882377, 0.1862608142454362}, {1.0317825528449263`, 
       0.1708736796170104}, {1.1253621449934887`, 0.15671553105432406`}, {
       1.227481410552495, 0.14369434480760435`}, {1.3390077715514497`, 
       0.1317663028482697}, {1.3975113180361292`, 0.12650701967683814`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.4099831744419877`, 0.1253858393646494}, {
       1.4606914090135146`, 0.12082732999624943`}, {1.5255766379879507`, 
       0.11569622099171006`}, {1.5932825039618503`, 0.11077335107147272`}, {
       1.6639847592523913`, 0.10605499554252476`}, {1.7378843806965318`, 
       0.10154028654400615`}, {1.8151129777018369`, 0.09722049992663706}, {
       1.8958021596758707`, 0.09308691154113757}, {1.9097464712844596`, 
       0.09243237440627083}}]}, 
     {Arrowheads[{{0.009499613665317047, 1.}}], 
      ArrowBox[{{1.9222548492614298`, 0.09184523908452191}, {
       1.980083536026198, 0.08913079723822791}, {2.0680887161603825`, 
       0.0853434328686282}, {2.1599493094859894`, 0.08171609428305858}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.11061034851189723`, -1.82043079718138}, \
{-0.11619859743646871`, -1.732848688438964}, {-0.12207125467860848`, \
-1.6494997262747968`}, {-0.1282564888719951, -1.5699669682233468`}, \
{-0.13475430001662853`, -1.4942504142846142`}, {-0.14156468811250875`, \
-1.4223500644586002`}, {-0.14983641968229347`, -1.3445497152277572`}, \
{-0.15259549198067487`, -1.32137192132476}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.15407567163680688`, -1.3089375610401948`}, \
{-0.1585912955212307, -1.2710037237145013`}, {-0.16833753012440228`, \
-1.197221039964553}, {-0.1786467908213002, -1.127781883610831}, \
{-0.20124497469981018`, -1.0007491485969016`}, {-0.22632635843254717`, \
-0.8898890999374754}, {-0.247013389141993, -0.8174121629929917}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.2504503140331081, -0.8053709091216696}, \
{-0.25436627194988337`, -0.7916513647850442}, {-0.2859874807286024, \
-0.7041189846878039}, {-0.32153596558913977`, -0.6262269827280854}, \
{-0.3615319497379358, -0.5569694544582708}, {-0.40649565638143087`, \
-0.4953404954307418}, {-0.41874661104993505`, -0.480412755468255}, \
{-0.43136678430299324`, -0.46593488233432473`}, {-0.46121972108346565`, \
-0.43759566106846537`}, {-0.4931386123217114, -0.41098006150311617`}, \
{-0.5176864896886356, -0.39300496831372245`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5277896488491463, -0.3856069670648589}, \
{-0.5614029728958485, -0.3609937337855178}, {-0.6391245845260566, \
-0.31709526785725717`}, {-0.727604940862633, -0.27853597062198965`}, \
{-0.7946009517251087, -0.2550996690009205}, {-0.8677736663500659, \
-0.23371217293197916`}, {-0.9477069117271817, -0.2141402802882091}, \
{-0.9907417644526401, -0.20527001938511413`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0030061014303386`, -0.20274211788421492`}, \
{-1.0349845148461336`, -0.1961507889426538}, {-1.1303507096671725`, \
-0.17962368790147273`}, {-1.2346413912765926`, -0.16450364681832017`}, \
{-1.3485778783531344`, -0.15065448453748187`}, {-1.4728814895755387`, \
-0.13794001990324356`}, {-1.4991151629029804`, -0.13558260144513357`}}]}, 
     {Arrowheads[{{0.009830394043594762, 1.}}], 
      ArrowBox[{{-1.5115870576918333`, -0.13446184818210913`}, \
{-1.539226542081995, -0.13197810029592}, {-1.608618862252788, \
-0.12627730494411815`}, {-1.6811856133474299`, -0.1208263147588266}, \
{-1.7570539586254315`, -0.11561381065103402`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.11063678864131643`, 
       1.8207702242762742`}, {-0.11622621128641873`, 
       1.7331742071428455`}, {-0.12210009358917936`, 
       1.6498118907002066`}, {-0.12828660844855408`, 
       1.5702662896979789`}, {-0.1347857558645429, 
       1.4945374041361628`}, {-0.1415975358371457, 
       1.4226252340147583`}, {-0.14987042015098268`, 
       1.3448165818771793`}, {-0.1526209311999921, 1.3217112275381624`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.15410114371222614`, 
       1.3092768711648144`}, {-0.15862647132833244`, 
       1.271262372692637}, {-0.16837623313354444`, 
       1.197454892094739}, {-0.17868930430460028`, 
       1.127992958053367}, {-0.20129613056332174`, 
       1.0009200988814158`}, {-0.22638266496700776`, 
       0.8900459263751687}, {-0.24702012209654733`, 0.8177475485338028}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.25045726141861585`, 
       0.805706355869391}, {-0.2544282023377162, 
       0.7917951174279104}, {-0.28605557295148715`, 
       0.7042506298871438}, {-0.3216107936283429, 
       0.6263474403348149}, {-0.36161413664539677`, 
       0.5570795892562387}, {-0.4065858742797619, 
       0.49544111713673006`}, {-0.41883939151437943`, 
       0.48051053536649535`}, {-0.4314621998499749, 
       0.4660299003236931}, {-0.4613194761323647, 
       0.4376867905540926}, {-0.4932428505425468, 
       0.41106742401084195`}, {-0.5175726101958917, 0.3932518621108758}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5276757328154271, 
       0.38585381095969906`}, {-0.5615164623669937, 
       0.36107380406049155`}, {-0.6392478886539084, 
       0.3171685267743514}, {-0.7277386022454162, 
       0.2786028906066506}, {-0.7947447709191292, 
       0.25516164105739036`}, {-0.8679283808052244, 
       0.23376956359061696`}, {-0.9478733102371446, 
       0.21419342420507537`}, {-0.9905738058252196, 0.20539141384552462`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.0028381049520767`, 
       0.20286332871488336`}, {-1.0351634375483327`, 
       0.19619998889951057`}, {-1.1305430550693647`, 
       0.17966922695741036`}, {-1.2348481202720345`, 
       0.16454579525354415`}, {-1.3488000092016137`, 
       0.15069349117357933`}, {-1.4731200979033727`, 
       0.13797611210318325`}, {-1.4989401743053576`, 0.1356556274768865}}]}, 
     {Arrowheads[{{0.009848442911552928, 1.}}], 
      ArrowBox[{{-1.5114120590635327`, 
       0.13453476259671654`}, {-1.5394738139646083`, 
       0.13201281534059423`}, {-1.6088750962511917`, 
       0.1263106951061757}, {-1.6814511168218471`, 
       0.12085843032436674`}, {-1.7573290477352985`, 
       0.11564469991960638`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.10518711689710517`, -2.644634908263605}, {
       0.11045118732609964`, -2.5185964872688826`}, {
       0.11585988866645493`, -2.4008423741184655`}, {
       0.12160067796546058`, -2.287505367790029}, {
       0.12764047456771258`, -2.1792679155228063`}, {
       0.12978574567942358`, -2.144362473290713}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.13055390140610984`, -2.1318639060016054`}, {
       0.1339792784732109, -2.076130017316798}, {
       0.14061708968195555`, -1.9780916731720033`}, {
       0.1475860719274582, -1.8847035184305823`}, {
       0.1549183889432304, -1.7955161884346948`}, {
       0.16261404072927216`, -1.710529683184341}, {
       0.1703878628099496, -1.6326025762804215`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.1717417113708987, -1.6201539762255084`}, {
       0.18004295646472096`, -1.5456612789495714`}, {
       0.189927125923149, -1.4659155073800416`}, {
       0.20270557492349095`, -1.3732208836741229`}, {
       0.21629264342656054`, -1.2864553252579682`}, {
       0.23079892437129632`, -1.20519712649202}, {
       0.24633501069663682`, -1.1290245817367197`}, {
       0.247261159704616, -1.125237837093967}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.2502360994494, -1.1130742035490226`}, {
       0.2760283570354561, -1.0076174224079366`}, {
       0.309117013535584, -0.8996213277958441}, {
       0.34628898937532027`, -0.80305400807151}, {
       0.38792651187594246`, -0.7168141911077492}, {
       0.4294782996769648, -0.648299912870777}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.43620147314723356`, -0.6377493359831804}, {
       0.4868820512092298, -0.5711251596744318}, {
       0.50141639304208, -0.5540769109459313}, {
       0.51638461183408, -0.5375375569410143}, {
       0.5500148012088251, -0.5065507664946526}, {
       0.5858351714283937, -0.4773502067057233}, {
       0.6621497921269068, -0.4223223511540585}, {
       0.7484128235417791, -0.37364548679262277`}, {
       0.828350850774919, -0.33833704346001586`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.8398053829864903, -0.3332776028471743}, {
       0.8459129188601231, -0.3305799182562462}, {
       0.9218483804995126, -0.30339987873144764`}, {
       1.004608386380943, -0.27853612378345644`}, {
       1.0948220567433098`, -0.25573367242051614`}, {
       1.193118511825509, -0.23473754365087035`}, {
       1.3002938614417814`, -0.21541364107490904`}, {
       1.3246890501450108`, -0.21171789291161294`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.3370699312904397`, -0.20984225180426833`}, {
       1.4172396380208516`, -0.19769694520282005`}, {
       1.5447280957233405`, -0.1814360904075439}, {
       1.6126671594210602`, -0.1738043016552546}, {
       1.6835314887098674`, -0.16647971106202117`}, {
       1.757501064441184, -0.15945675367561696`}, {
       1.8345797668570725`, -0.15275152700225497`}}]}, 
     {Arrowheads[{{0.0061169662891484905`, 1.}}], 
      ArrowBox[{{1.847062195256873, -0.15175498370479515`}, {
       1.9155079744375505`, -0.14629861554175677`}, {
       1.9998154021639964`, -0.14013792177321818`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{0.3502828481850063, 3.}, {0.3541531895917016, 
       2.9664069556057804`}, {0.3696794346762615, 2.8426875928936886`}, {
       0.38590324502241724`, 2.723163423962928}, {0.4028357055639982, 
       2.6086517166267527`}, {0.41969923213246846`, 2.5039977579978743`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.4217944419533712, 2.4916524421179127`}, {
       0.4389622861941258, 2.3939020852640103`}, {0.45819188308259834`, 
       2.2933197539582966`}, {0.47822698591068336`, 2.197031154922533}, {
       0.49914037513505594`, 2.1048005156386704`}, {0.5210048312123912, 
       2.01639206358866}, {0.5250009226935921, 2.0016846678945077`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.528284233106264, 1.989600623859714}, {0.547780592330849, 
       1.9178453422150763`}, {0.5760834452169159, 1.8236711070341676`}, {
       0.6059945056485827, 1.733660638441483}, {0.6367296544386032, 
       1.649831559280044}, {0.6694380317751832, 1.5692270084868019`}, {
       0.6927969331336956, 1.5171566695139962`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.6979223030255794, 1.5057314854466752`}, {
       0.7039168482133453, 1.4923687850728828`}, {0.7401661037530893, 
       1.419256889038287}, {0.7781857983944154, 1.3498913203830145`}, {
       0.8181730356678764, 1.283931896593479}, {0.860324919104025, 
       1.2210384351560948`}, {0.9046414487028615, 1.1612109360708616`}, {
       0.9511226244643858, 1.1044493993377793`}, {0.9673517206486009, 
       1.08560491644532}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.9755232634745227, 1.0761164953256122`}, {
       0.9779110433043909, 1.0733439147922195`}, {1.0054539588422053`, 
       1.0431144781908295`}, {1.0595644344066413`, 0.9924194937964036}, {
       1.1165869534253248`, 0.9441882486947196}, {1.1751457603905935`, 
       0.8971306212715257}, {1.2367771432490322`, 0.852420229205312}, {
       1.3016445689530032`, 0.8099413997659997}, {1.3693855593810438`, 
       0.7698894261261295}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.380419559434751, 0.7639698650669774}, {1.4417305679323464`,
        0.7312455763227687}, {1.5173764721053296`, 0.6947882464046482}, {
       1.5789221620683933`, 0.6677247635813552}, {1.6429579096660991`, 
       0.641755043383492}, {1.709594333339686, 0.6168274085877802}, {
       1.778942051530391, 0.5928901819709417}, {1.8423710645177043`, 
       0.5726770832373113}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.8543238052433886`, 0.568945979034025}, {1.926213845228108, 
       0.547780244380772}, {2.004359157617595, 0.5265041789608842}, {
       2.0856582382891515`, 0.506011812826757}, {2.1702705847035437`, 
       0.48629367734889994`}, {2.2583707340198553`, 0.4673532911574495}, {
       2.340883323638182, 0.4509851674238404}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{2.353174786701699, 0.4485939763895516}, {2.4455671533130845`,
        0.43167698129841814`}, {2.5449297792674273`, 0.41487666496316183`}, {
       2.648312920078539, 0.39872531257896143`}, {2.755849753735132, 
       0.38319072781197944`}, {2.8479250032407086`, 0.37088093868558053`}}]}, 
     {Arrowheads[{{0.00561871910150952, 1.}}], 
      ArrowBox[{{2.86033672286202, 0.3692215823215766}, {2.867673458225919, 
       0.368240714328378}, {2.9840225100590616`, 0.35386390456817907`}, {3., 
       0.35204273404486214`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.35324816266776554`, 3.}, {-0.36485788565979366`, 
       2.904219928932221}, {-0.3809458998653263, 
       2.7824282434427894`}, {-0.3975591224039349, 
       2.6661423475793398`}, {-0.4148935184406367, 
       2.5547038787911442`}, {-0.42346435584361264`, 2.50411478801917}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.42555605978134375`, 
       2.4917685731280512`}, {-0.4329833459767961, 
       2.447929256400294}, {-0.45186286301377737`, 
       2.345634899728881}, {-0.47153338837214887`, 
       2.2476740401490085`}, {-0.49202259221711564`, 
       2.1538704593927704`}, {-0.5134042595669972, 
       2.0639964023222452`}, {-0.5294921248716554, 2.0019625116176707`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5326356270453414, 
       1.989841346591782}, {-0.5357521754401131, 
       1.9778241137995103`}, {-0.5633837894195606, 
       1.8808352975540403`}, {-0.5925975099251563, 
       1.7881630085978717`}, {-0.6234776876976688, 
       1.6996005183142286`}, {-0.6552089322430008, 
       1.6171462033319441`}, {-0.6889862123887088, 
       1.5378714082466938`}, {-0.6984248570150852, 1.5178402565612301`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7037624084953833, 
       1.5065126446462693`}, {-0.724598651282871, 
       1.4622929546004169`}, {-0.7620462489254876, 
       1.3904108423931139`}, {-0.8013290053165584, 
       1.3222250716247845`}, {-0.8426520162681155, 
       1.2573989460675241`}, {-0.8862203775921909, 
       1.195595769493428}, {-0.9320340892887847, 
       1.1368155419024961`}, {-0.9746288976653626, 1.0873977943301034`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.982882437823361, 
       1.077981774018966}, {-1.0077163179864677`, 
       1.0505908384003675`}, {-1.036118021630134, 
       1.0209820753272976`}, {-1.0914382694376288`, 
       0.9717171368389838}, {-1.1497121494932918`, 
       0.9248293375143634}, {-1.2095436013679466`, 
       0.8790742924889974}, {-1.272490196880584, 
       0.8355847560621406}, {-1.338716371065403, 
       0.7942498929173445}, {-1.377142297834858, 0.7725793032156222}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3880494981046547`, 
       0.7664281057894831}, {-1.4083865589566034`, 
       0.7549588677381612}, {-1.4816541532034115`, 
       0.717629363646777}, {-1.5587952605744368`, 
       0.6821132102631274}, {-1.6218271226359737`, 
       0.6556215028187162}, {-1.6874013913061614`, 
       0.6301969883087303}, {-1.7556306380162021`, 
       0.6057894399043902}, {-1.8266274341973, 
       0.5823486307769166}, {-1.8500156187758516`, 0.5752178187582566}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.8619934241529734`, 
       0.5715659116060154}, {-1.9005043512806572`, 
       0.5598243340975302}, {-1.9773739606974772`, 
       0.5381663230374517}, {-2.0573488338789634`, 
       0.5173243707679017}, {-2.1405415422563188`, 
       0.49724825046010085`}, {-2.227114206159287, 
       0.4779286318076574}, {-2.3172441917325486`, 
       0.45936876804952964`}, {-2.34849712511771, 0.4534289990840418}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.3607990681682036`, 
       0.4510909561667259}, {-2.41106693912971, 
       0.44153730767496324`}, {-2.508717888504377, 
       0.42440289917320395`}, {-2.6103324800101575`, 
       0.4079341910334974}, {-2.716046153800658, 
       0.3920998317450893}, {-2.8259943500294846`, 
       0.37686846979722527`}, {-2.855496635561843, 0.3730852114312744}}]}, 
     {Arrowheads[{{0.005314331398221248, 1.}}], 
      ArrowBox[{{-2.8679170782776375`, 
       0.3714924621589577}, {-2.940312508850244, 0.3622087536791512}, {-3., 
       0.35513279069464065`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-0.35325639330543024`, -3.}, {-0.36486273866159674`, \
-2.904248146547346}, {-0.3809509239812161, -2.7824555863984046`}, \
{-0.3975644163278068, -2.6661682075576163`}, {-0.41489909605089986`, \
-2.5547283317268406`}, {-0.42347407416084487`, -2.5041150027510217`}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-0.425565786221165, -2.4917687892360405`}, \
{-0.4329892219404852, -2.4479523748527723`}, {-0.45186905278655265`, \
-2.345656752882106}, {-0.4715399075560256, -2.247694694079724}, \
{-0.4920294570742806, -2.1538899768559583`}, {-0.5134114879189875, \
-2.064014842375678}, {-0.5295040431217668, -2.0019631948220735`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.5326475608233349, -1.9898420338231955`}, \
{-0.5357597866678162, -1.9778415318037508`}, {-0.5633917485720267, \
-1.8808520103799073`}, {-0.5926058340962427, -1.7881790416345968`}, \
{-0.6234863947500908, -1.699615896044913}, {-0.6552180326071816, \
-1.6171609589989513`}, {-0.6889957273872237, -1.5378855622555367`}, \
{-0.698440189423471, -1.517842155314769}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7037777606764711, -1.5065145527166928`}, \
{-0.724608600316151, -1.4623065296219355`}, {-0.7620566513939634, \
-1.3904238610981476`}, {-0.8013398806206611, -1.3222375566841726`}, \
{-0.8426633856172895, -1.2574109185660394`}, {-0.8862322640048945, \
-1.1956072489297758`}, {-0.932046515783476, -1.136826547775382}, \
{-0.9746475169454891, -1.0874017920476156`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-0.9829012360814705, -1.077985929834204}, \
{-1.0077296369010207`, -1.0506011333912861`}, {-1.0361316781090346`, \
-1.020992119595662}, {-1.0914524775479333`, -0.9717268393864252}, \
{-1.1497269292099832`, -0.9248387079327178}, {-1.2095589629599797`, \
-0.8790833355059472}, {-1.2725061608858697`, -0.8355934811330499}, \
{-1.3387329585833927`, -0.7942583093615846}, {-1.3771628126508118`, \
-0.7725855403572179}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.388070017234926, -0.7664343505811607}, \
{-1.4084037916482892`, -0.75496698473911}, {-1.4816720532014818`, \
-0.7176371902576927}, {-1.558813850860631, -0.682120755303053}, \
{-1.6218463801021654`, -0.6556287888849591}, {-1.687421339462081, \
-0.6302040243317919}, {-1.7556513012526525`, -0.6057962344772918}, \
{-1.8266488377861552`, -0.582355192155199}, {-1.850036382756855, \
-0.5752245778127011}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.8620141885149228`, -0.5715726719099167}, \
{-1.9005265213748634`, -0.5598306701992543}, {-1.9773969243310523`, \
-0.5381724414431978}, {-2.0573726189669967`, -0.5173302787207698}, \
{-2.140566177594972, -0.4972539548657108}, {-2.227139721723959, \
-0.4779341394567229}, {-2.317270618769621, -0.45937408568634264`}, \
{-2.348517808273559, -0.4534354069937659}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-2.36081975122446, -0.4510973635524316}, \
{-2.4110943099042506`, -0.4415424418090619}, {-2.5087462363001416`, \
-0.4244078560793726}, {-2.6103618391295877`, -0.4079389767517667}, \
{-2.7160765595648826`, -0.39210445208073624`}, {-2.82602583877832, \
-0.37687293032077307`}, {-2.8555172324031797`, -0.3730910659025299}}]}, 
     {Arrowheads[{{0.005313503860402716, 1.}}], 
      ArrowBox[{{-2.86793767497083, -0.3714983154749667}, \
{-2.940345117942194, -0.36221305972636914`}, {-3., -0.35514095663173145`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.5331656034926517`, -3.}, {-2.571852006705064, \
-2.954543897460381}, {-2.62977596230664, -2.8894598591662786`}, \
{-2.696803209660106, -2.8158162765110704`}, {-2.7655388344022156`, \
-2.7440496450739134`}, {-2.8277511774627166`, -2.6874080057871645`}, \
{-2.8802377718175167`, -2.6396212387473295`}}]}, 
     {Arrowheads[{{0.005740993690233648, 1.}}], 
      ArrowBox[{{-2.8894971158624996`, -2.6311910077091287`}, \
{-2.889963520523218, -2.6307663665004157`}, {-2.9556746062130976`, \
-2.5770476547485526`}, {-3., -2.539217349678437}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.532861495470149, 3.}, {-2.571687981185244, 
       2.9543789345647005`}, {-2.6296085246035132`, 
       2.8892982201284636`}, {-2.6966318996341654`, 
       2.8156583228837007`}, {-2.765363563431789, 
       2.743895293995578}, {-2.8275730576163567`, 
       2.6872559265640508`}, {-2.879913585604816, 2.63960187576108}}]}, 
     {Arrowheads[{{0.005758241097854871, 1.}}], 
      ArrowBox[{{-2.88917290579715, 2.631171618524398}, {-2.889782551800924, 
       2.6306165591325237`}, {-2.955490689920019, 2.5769000491757184`}, {-3., 
       2.5389126029206768`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.532965061089912, 3.}, {2.571763429585407, 
       2.9544127883250955`}, {2.6296856155808404`, 2.8893313904536466`}, {
       2.6967107734920375`, 2.8156908477491562`}, {2.7654442609731005`, 
       2.7439271847559206`}, {2.827655066825237, 2.6872875799687876`}, {
       2.8800240020785925`, 2.6396084709258503`}}]}, 
     {Arrowheads[{{0.005752360816370903, 1.}}], 
      ArrowBox[{{2.8892833931680397`, 2.6311782915592254`}, {
       2.889865872677373, 2.630647975181655}, {2.955575367904424, 
       2.5769312183963424`}, {3., 2.539016663926572}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.521085645788188, -3.}, {
       2.536888414845255, -2.9810077469924297`}, {
       2.5939799956618796`, -2.9153912555275614`}, {
       2.6600878743885605`, -2.841094634936459}, {
       2.727880519226961, -2.768691408832552}, {
       2.789226331141314, -2.7115576960262633`}, {
       2.8505721430556674`, -2.654423983219975}, {
       2.8681422508403753`, -2.6397305324424933`}}]}, 
     {Arrowheads[{{0.006423619691044697, 1.}}], 
      ArrowBox[{{2.8777481192830896`, -2.631697379950348}, {
       2.915366875093286, -2.600237735901476}, {
       2.978782039081598, -2.5448725023878613`}, {
       3., -2.5271396702348694`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.36848017144141354`, -3.}, {
       0.38337435109258405`, -2.8838695833761663`}, {
       0.40031155169545907`, -2.7627086884274608`}, {
       0.4177442149192133, -2.647406128847191}, {
       0.435932553494026, -2.5369034091605935`}, {
       0.44173082294754, -2.504556125684905}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{0.44394021164234965`, -2.4922304269584212`}, {
       0.45491239820840995`, -2.4310189858472477`}, {
       0.474719579850878, -2.3295713153867323`}, {
       0.49535539836898335`, -2.232415480455359}, {
       0.5168487783830469, -2.1393772627720535`}, {
       0.5392769876907328, -2.0502311673803164`}, {
       0.5521296119935483, -2.003361665342365}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.5554411998218564, -1.9912853400090447`}, {
       0.5627172940897058, -1.9647516993236482`}, {
       0.5917775458527578, -1.868284276587938}, {
       0.6225041085582248, -1.7761149969937242`}, {
       0.6549859436755698, -1.6880377629165917`}, {
       0.6883630903333179, -1.606044851392558}, {
       0.7238958360155272, -1.5272165460757348`}, {
       0.726840064549909, -1.5213110698066679`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.7324272179899769, -1.5101044662204812`}, {
       0.7613617770485405, -1.452068091027161}, {
       0.8007609134323578, -1.380599486246837}, {
       0.842093245166979, -1.3128107317347624`}, {
       0.8855751275563348, -1.2483662455590352`}, {
       0.9314229159043558, -1.1869304457877532`}, {
       0.9796366102110419, -1.1285033324209168`}, {
       1.0098921566800902`, -1.0953533117919318`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.0183336536536922`, -1.0861042374411947`}, {
       1.030216210476393, -1.0730849054585254`}, {
       1.0591059935301976`, -1.0429943074153178`}, {
       1.088805916222644, -1.0137474856532858`}, {
       1.1462499776064372`, -0.9653566679966963}, {
       1.206724699777072, -0.9192757499698735}, {
       1.2687966107883168`, -0.8742961097730402}, {
       1.3340628994807826`, -0.8315190252361859}, {
       1.4026902030430486`, -0.7908379152658248}, {
       1.4152502442383585`, -0.7841028331229016}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.4262858948818185`, -0.7781851762913254}, {
       1.4748451586636941`, -0.7521461987684707}, {
       1.5506830180139513`, -0.7153646148695101}, {
       1.630483234102037, -0.6803504939946388}, {
       1.696086026444643, -0.6540532239469177}, {
       1.7643218003037662`, -0.6288097891972361}, {
       1.83530652362482, -0.6045708944776841}, {
       1.8886322945568486`, -0.5877581033545342}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{1.900574930337372, -0.5839927749339899}, {
       1.909156164353218, -0.5812872445203521}, {
       1.9859866904343737`, -0.55890954405733}, {
       2.065914069813701, -0.5373884978207082}, {
       2.1490542704366122`, -0.5166748105425768}, {
       2.235523260248522, -0.4967191869550261}, {
       2.3254877094091286`, -0.4775122796485514}, {
       2.386980713941969, -0.465393076719382}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.3992665369074193`, -0.46297175444376243`}, {
       2.4191298887594486`, -0.45905703286238847`}, {
       2.5165891672668734`, -0.4413225888017375}, {
       2.618004913898795, -0.4242780896717989}, {
       2.7235164976226036`, -0.40789267767777304`}, {
       2.8332632874056904`, -0.3921354950248602}, {
       2.8938255913850552`, -0.3840904362399592}}]}, 
     {Arrowheads[{{0.0037740853838461566`, 1.}}], 
      ArrowBox[{{2.906238697907899, -0.3824414868916394}, {
       2.9473846522154465`, -0.37697568391826075`}, {
       3., -0.3705034841709581}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.723548685370543, -3.}, {
       1.7531449416634817`, -2.949052978733901}, {
       1.793460829267874, -2.8827380637414834`}, {
       1.8346429442874097`, -2.8180169130405748`}, {
       1.8767778685396892`, -2.754757069655163}, {
       1.9199521838423135`, -2.692826076609237}, {
       1.9641658901952825`, -2.6322239339027953`}, {
       2.001259247646258, -2.5836384105414116`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.008858035008245, -2.573685386974269}, {
       2.009418987598596, -2.572950641535839}, {
       2.0557114760522546`, -2.5150061995083686`}, {
       2.1030433555562573`, -2.4583906078203825`}, {
       2.151414626110605, -2.4031038664718816`}, {
       2.2008252877152974`, -2.349145975462866}, {
       2.257882724280911, -2.2882453786860952`}, {
       2.3164194011372063`, -2.228923602986495}, {
       2.3453990135420106`, -2.2034494669715303`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.3548040539031896`, -2.1951820935491315`}, {
       2.371338140168314, -2.1806480288239904`}, {
       2.4262568791994217`, -2.1323724546614855`}, {
       2.4844307027183263`, -2.086710833217058}, {
       2.541302492442112, -2.0400036306854}, {
       2.5986501422411745`, -1.994982598630386}, {
       2.6573843043471657`, -1.9508938484942164`}, {
       2.7175049787600845`, -1.9077373802768913`}, {
       2.748708670669997, -1.8863162981128554`}}]}, 
     {Arrowheads[{{0.01135675814349512, 1.}}], 
      ArrowBox[{{2.759032303552028, -1.879229207622545}, {
       2.7790121654799322`, -1.8655131939784104`}, {
       2.841905864506708, -1.824221289598774}, {
       2.906186075840412, -1.7838616671379819`}, {
       2.9718527994810446`, -1.7444343265960343`}, {
       3., -1.7282751044683982`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.7289018617009007`, 3.}, {1.729369919100465, 
       2.9991693998928137`}, {1.7689183591756577`, 2.932102947936166}, {
       1.8093780179360055`, 2.8665446486791275`}, {1.8508313638500853`, 
       2.802358349130026}, {1.8932783969178972`, 2.7395440492888623`}, {
       1.9367191171394411`, 2.678101749155635}, {1.981153524514717, 
       2.6180314487303455`}, {2.0073789732596206`, 2.5841451655208902`}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{2.0150430363798004`, 2.5742423182540333`}, {
       2.026581619043725, 2.5593331480129926`}, {2.0730034007264653`, 
       2.502006847003577}, {2.120418869562937, 2.446052545702098}, {
       2.175381245403334, 2.382651782866599}, {2.2317682743115297`, 
       2.320894343311974}, {2.2846478540346835`, 2.2706547707541}, {
       2.3375274337578373`, 2.220415198196226}, {2.353930226401763, 
       2.2064989812403764`}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{2.3634788548776138`, 2.1983978738018237`}, {
       2.3935393271012737`, 2.172894408487053}, {2.4482982949965972`, 
       2.1242861056384}, {2.50375403895247, 2.0772334870226588`}, {
       2.5605559146430403`, 2.0311585631603415`}, {2.618703922068309, 
       1.9860613340514477`}, {2.6781980612282754`, 1.9419417996959778`}, {
       2.73903833212294, 1.8987999600939316`}, {2.755706547055576, 
       1.8874984375894641`}}]}, 
     {Arrowheads[{{0.011030375198783611`, 1.}}], 
      ArrowBox[{{2.7660709375123593`, 1.8804710868823957`}, {
       2.8012247347523034`, 1.856635815245309}, {2.8647572691163647`, 
       1.8154493651501102`}, {2.929635935215124, 1.775240609808335}, {
       2.995992645985971, 1.7359289143258019`}, {3., 1.7336592109475797`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.7287732139847225`, -3.}, {-1.7292989604938946`, \
-2.9990670200838454`}, {-1.7688459133977075`, -2.9320026326138753`}, \
{-1.809304053895727, -2.8664463565304614`}, {-1.8507558479227297`, \
-2.802262042111718}, {-1.8932012954787159`, -2.739449689357645}, \
{-1.936640396563685, -2.6780092982682437`}, {-1.9810731511776372`, \
-2.6179408688435126`}, {-2.007235787317423, -2.5841355474131857`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.014899822179336, -2.574232678276608}, \
{-2.0264995593205724`, -2.559244401083452}, {-2.0729196209924914`, \
-2.5019198949880623`}, {-2.120333336193393, -2.445967350557343}, \
{-2.1752936851322193`, -2.3825685766046085`}, {-2.231678639529785, \
-2.3208130800669804`}, {-2.284556679243636, -2.2705747596693175`}, \
{-2.3374347189574864`, -2.220336439271655}, {-2.3537723584272494`, \
-2.2064754569705225`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.363320974895461, -2.198374335378805}, \
{-2.3934450156505838`, -2.172816861392545}, {-2.4482024095519823`, \
-2.1242097865060137`}, {-2.5036561885115463`, -2.0771586865176523`}, \
{-2.560456056895625, -2.031085253090823}, {-2.618602014704219, \
-1.9859894862255258`}, {-2.678094061937327, -1.941871385921761}, \
{-2.738932198594951, -1.8987309521795281`}, {-2.7555434247507287`, \
-1.887468043478744}}]}, 
     {Arrowheads[{{0.011037989029930431`, 1.}}], 
      ArrowBox[{{-2.765907807613375, -1.880440681571366}, \
{-2.801116424677089, -1.8565681849988276`}, {-2.8646467401837423`, \
-1.8153830843796592`}, {-2.929523145114911, -1.775175650322023}, \
{-2.995877548786901, -1.735865249977205}, {-3., -1.733530353458444}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.7287490578461155`, 3.}, {-1.7292717582480945`, 
       2.9990724093945613`}, {-1.7688180819337915`, 
       2.93200791324923}, {-1.809275578548999, 
       2.86645153066519}, {-1.8507267126865408`, 
       2.802267111748433}, {-1.8931714843464176`, 
       2.739454656498958}, {-1.936609893528629, 
       2.6780141649167657`}, {-1.9810419402331751`, 
       2.617945637001856}, {-2.0072091158236267`, 2.5841338556414994`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-2.0148730664218153`, 
       2.574230921292059}, {-2.026467624460056, 
       2.5592490727542287`}, {-2.0728869462092714`, 
       2.501924472173884}, {-2.1202999054808216`, 
       2.4459718352608215`}, {-2.1752593778643297`, 
       2.382572956612458}, {-2.231643432726253, 
       2.320817357793597}, {-2.2845206075079316`, 
       2.2705789714817564`}, {-2.3373977822896106`, 
       2.220340585169916}, {-2.3537438816449163`, 2.2064721795203748`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.3632924272471723`, 
       2.1983709744012314`}, {-2.393407160995452, 
       2.1728209434996084`}, {-2.448163658131628, 
       2.124213803972688}, {-2.503616648852403, 
       2.0771625407736223`}, {-2.5604157121835853`, 
       2.031088948973266}, {-2.618560848125176, 
       1.9859930285716196`}, {-2.678052056677174, 
       1.9418747795686826`}, {-2.7388893378395807`, 
       1.898734201964455}, {-2.7555131500078525`, 1.8874625642880802`}}]}, 
     {Arrowheads[{{0.011039400099265283`, 1.}}], 
      ArrowBox[{{-2.7658774763177396`, 
       1.8804351189739583`}, {-2.801072691612395, 
       1.856571295758937}, {-2.8646021179956174`, 
       1.8153860609521286`}, {-2.9294776169892476`, 
       1.7751784975440297`}, {-2.9958310964938226`, 
       1.7358679721701051`}, {-3., 1.7335067255207406`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.11695229088443294`, 0.36168972148706957`}, {
       0.125692953765025, 0.33654015971735557`}, {0.15422289720316057`, 
       0.2742647881668822}, {0.18920059287523025`, 0.22352436550151394`}, {
       0.24700570654308124`, 0.1711867227921814}, {0.3225545487648939, 
       0.1310894349528779}, {0.3324381763866607, 0.1270728599185133}, {
       0.3426246551019576, 0.12317935248647466`}, {0.36824181470046524`, 
       0.11516253866814644`}, {0.3957742641818598, 0.10766746473171082`}, {
       0.4549654918591686, 0.09365544057256363}, {0.49714143559588564`, 
       0.08610325943709546}}]}, 
     {Arrowheads[{{0.014287641295646808`, 1.}}], 
      ArrowBox[{{0.5094675341485145, 0.08389610244864269}, {0.523017215415598,
        0.08146984619470642}, {0.6012464602890557, 0.07087007520854192}, {
       0.7213386090678608, 0.05912083678227094}, {0.7901257761316525, 
       0.05401527950360868}, {0.8654532473356322, 0.04933403373440712}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.741643022515231, 3.}, {0.7474371604516284, 
       2.976329726828526}, {0.7649357561851314, 2.908071811631261}, {
       0.7828458118388114, 2.841385270285049}, {0.801184932392691, 
       2.776222925045366}, {0.8199707228267927, 2.712537598167689}, {
       0.8392207881211395, 2.6502821119074946`}, {0.8595622886206605, 
       2.5875633149732375`}, {0.8804489186120107, 2.5261986642291414`}, {
       0.8828506298754358, 2.519634936355409}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.8871535583794349, 2.50787529972028}, {0.9239142526800161, 
       2.407410602938046}, {0.9697301615447905, 2.2936755312874344`}, {
       1.0168007234165337`, 2.187336617829457}, {1.0667320305734007`, 
       2.08495990865148}, {1.0861702559529314`, 2.0487520677050495`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.0920932280014601`, 2.0377192688936354`}, {
       1.1192406549663056`, 1.9871513956204374`}, {1.174326596595248, 
       1.8939110787363307`}, {1.2319898554602284`, 1.805238957999159}, {
       1.2925037015891507`, 1.720736421773697}, {1.356141405009919, 
       1.6400048584247184`}, {1.3710093119715097`, 1.622865611129711}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.3792148282330243`, 1.6134065546026142`}, {
       1.4229029657225332`, 1.5630442679522234`}, {1.4927883837269935`, 
       1.489854650356212}, {1.533061214743009, 1.4496625458276493`}, {
       1.5744205359676389`, 1.410554711163279}, {1.660258105508434, 
       1.3411940071236124`}, {1.748227257501961, 1.277100562476204}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.7584678337672157`, 1.2698949755618596`}, {
       1.833961305963204, 1.2173996276768468`}, {1.9212892052899238`, 
       1.1620655005928002`}, {2.012759216055103, 1.1092415440475032`}, {
       2.1083713382587415`, 1.0589277580409564`}, {2.1912267184995535`, 
       1.0192122785102695`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.2025186537145407`, 1.0137996593105356`}, {
       2.2085468526837904`, 1.0109101328600587`}, {2.3137070401132, 
       0.9649746587917098}, {2.42385190054697, 0.9211213358359096}, {
       2.538981433985101, 0.879350163992658}, {2.6584577085449, 
       0.8398833585221054}, {2.670490911109501, 0.8361703314870538}}]}, 
     {Arrowheads[{{0.013160972572716895`, 1.}}], 
      ArrowBox[{{2.682456380059041, 0.832478204685548}, {2.7215057610365165`, 
       0.8204289263248621}, {2.785895671561627, 0.8014616996167334}, {
       2.8516593367143663`, 0.7829705676347118}, {2.9188286530888696`, 
       0.7649444196157899}, {2.987435517279271, 0.74737214479696}, {3., 
       0.7443008719711877}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.7416305443024191, 3.}, {-0.747409948984283, 
       2.976388586359822}, {-0.7649079769309356, 
       2.9081290565416915`}, {-0.7828174531032785, 
       2.8414409438144403`}, {-0.8011559820048733, 
       2.7762770690630703`}, {-0.8199411681392806, 
       2.712590253172583}, {-0.839190616010062, 
       2.650333317027981}, {-0.8595313252632822, 
       2.587613488784916}, {-0.8804171410305113, 
       2.5262478254488143`}, {-0.8828368353105208, 2.519634582769007}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.8871395524510959, 
       2.507874868796763}, {-0.9238807751463411, 
       2.4074577937787027`}, {-0.9696948844362412, 
       2.2937208225800494`}, {-1.0167635968062105`, 
       2.187380106416287}, {-1.066692931704354, 
       2.0850016532547992`}, {-1.0861533435301505`, 2.048750425735451}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{-1.092076054351471, 
       2.0377174866878622`}, {-1.1191994739339477`, 
       1.9871914616895772`}, {-1.174283223494991, 
       1.8939495317206207`}, {-1.2319441803874844`, 
       1.80527586334793}, {-1.2924556021083307`, 
       1.7207718402837322`}, {-1.3560907461544331`, 
       1.6400388462402542`}, {-1.3709899873948377`, 1.622862477833531}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.3791952310660451`, 
       1.6134031848474295`}, {-1.4228496125257915`, 
       1.563076881217496}, {-1.492732201222406, 
       1.4898859452154578`}, {-1.5330036759152397`, 
       1.4496928373852283`}, {-1.5743616085253505`, 
       1.4105840307762854`}, {-1.6601972808097312`, 
       1.3412209257236176`}, {-1.7482058543824084`, 1.2770952185418638`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.7584468974261436`, 
       1.2698902842958348`}, {-1.8338959259316843`, 
       1.2174229545857007`}, {-1.921221086723267, 
       1.1620875403064956`}, {-2.0126882467753275`, 
       1.1092623652817595`}, {-2.108297406087865, 
       1.058947429511493}, {-2.1912043096854825`, 1.0192051290457382`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.202496132140965, 1.013792274610723}, {-2.20846983591408, 
       1.0109287165722176`}, {-2.313626807507174, 
       0.964992210040456}, {-2.4237683208671466`, 
       0.9211379099162078}, {-2.5388943759939977`, 
       0.8793658161994732}, {-2.658367054867578, 
       0.8398981509140016}, {-2.6704687613064637`, 0.8361637932441435}}]}, 
     {Arrowheads[{{0.013161883255769013`, 1.}}], 
      ArrowBox[{{-2.6824341765676056`, 
       0.8324714924534132}, {-2.7214132289957846`, 
       0.8204432942704489}, {-2.785801226268733, 
       0.8014756559252123}, {-2.8515629425874307`, 
       0.782984124777104}, {-2.9187302738528853`, 
       0.7649575897249369}, {-2.987335115966104, 0.7473849396675232}, {-3., 
       0.7442889679139422}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.7416438680744515, -3.}, {-0.747431245881284, \
-2.9763569389425593`}, {-0.7649297371672076, -2.908098269630343}, \
{-0.7828396867306171, -2.8414109945119006`}, {-0.8011786994938703, \
-2.7762479351952116`}, {-0.8199643803793245, -2.712561913288256}, \
{-0.8392143343093377, -2.6503057503990135`}, {-0.8595556509843127, \
-2.587586476560174}, {-0.8804420914141001, -2.526221357585316}, \
{-0.8828520026028444, -2.5196351091519356`}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{-0.887154867339693, -2.507875449184182}, \
{-0.9239070284685573, -2.4074323852285953`}, {-0.9697225153336002, \
-2.293696435330952}, {-1.0167926433539511`, -2.1873566885387428`}, \
{-1.066723485558896, -2.084979173215066}, {-1.086171611287762, \
-2.0487522635104067`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.0920945037272691`, -2.037719421961158}, \
{-1.1192316172962082`, -1.9871698843546688`}, {-1.1743170385658874`, \
-1.8939288219575519`}, {-1.2319797493679336`, -1.8052559860237152`}, \
{-1.2924930163909392`, -1.7207527627560548`}, {-1.3561301063234965`, \
-1.6400205383574684`}, {-1.371010962709869, -1.6228660553573264`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3792163948989082`, -1.6134069258999253`}, \
{-1.4228910191656052`, -1.5630593128279555`}, {-1.4927757549172653`, \
-1.4898690861675166`}, {-1.5330482810568327`, -1.4496765564497445`}, \
{-1.5744072901465276`, -1.4105683090310455`}, {-1.6602444332182849`, \
-1.3412067207257818`}, {-1.7482288998543647`, -1.2771010039508472`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.7584696662250698`, -1.2698956831395556`}, \
{-1.83394660971666, -1.2174109189552036`}, {-1.921273893470581, \
-1.162076227645229}, {-2.012743263447397, -1.1092517347899415`}, \
{-2.1083547196471084`, -1.0589374403893417`}, {-2.1912282958399874`, \
-1.0192125643293197`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.2025201952287317`, -1.0137998703886586`}, \
{-2.20852954071055, -1.0109193321588195`}, {-2.3136890052785577`, \
-0.9649833978137647}, {-2.4238331133511313`, -0.9211296373541777}, \
{-2.538961864928271, -0.8793580507800585}, {-2.658437331243333, \
-0.8398908559757946}, {-2.670492628275716, -0.8361709497240981}}]}, 
     {Arrowheads[{{0.013160902383430711`, 1.}}], 
      ArrowBox[{{-2.682458079989853, -0.8324787670664476}, \
{-2.7214849615130796`, -0.8204362317251374}, {-2.785874441973964, \
-0.8014688182631889}, {-2.851637669064319, -0.7829775046957299}, \
{-2.9188065392224756`, -0.7649511801285409}, {-2.9874129488867673`, \
-0.7473787336674024}, {-3., -0.7443018939034115}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.1597565612413943`, 3.}, {1.1728779053500151`, 
       2.966040368425432}, {1.200731976925323, 2.897225404032765}, {
       1.2293006587652304`, 2.8298420718483963`}, {1.257238502558395, 
       2.766834862011252}, {1.286771081894922, 2.7033331455761123`}, {
       1.3170501793611396`, 2.641193231543604}, {1.3480757949570474`, 
       2.5804151199137286`}, {1.3672829331351433`, 2.5444963090709845`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.3731877787270617`, 2.533453798213557}, {
       1.3798479286826457`, 2.5209988106864847`}, {1.4123665805379346`, 
       2.462944303861873}, {1.4456317505229137`, 2.406251599439893}, {
       1.514401644881943, 2.296951597803829}, {1.5864635774436093`, 
       2.1926366954391323`}, {1.6460151396108897`, 2.114090973415731}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.6535805477423047`, 2.104112554337244}, {
       1.6621235138917874`, 2.0928447820066425`}, {1.7413814542264774`, 
       1.9975758575063596`}, {1.8242373984476792`, 1.9068299219382834`}, {
       1.8724344306405765`, 1.8564526238643189`}, {1.9219048457045906`, 
       1.807406263081133}, {1.998357425388274, 1.7420899742882825`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.007878136622958, 1.7339560757711776`}, {2.018959379005625, 
       1.724488957321487}, {2.1209150586065957`, 1.6453755773292014`}, {
       2.219543664639502, 1.5722619980941648`}, {2.3229736808042754`, 
       1.5022589829142778`}, {2.416200726818659, 1.4446399915325263`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.4268526270022344`, 1.4380565828424983`}, {
       2.4312051071009155`, 1.4353665317895403`}, {2.5442379435294225`, 
       1.3715846447199527`}, {2.602674259135902, 1.3407951751304592`}, {
       2.6625496644609, 1.3106533714039925`}, {2.723864159504417, 
       1.281159233540552}, {2.7866177442664526`, 1.2523127615401377`}, {
       2.8508104187470065`, 1.2241139554027498`}, {2.874487039612408, 
       1.2141748975296909`}}]}, 
     {Arrowheads[{{0.004907360792830676, 1.}}], 
      ArrowBox[{{2.8860331298113047`, 1.2093280378639144`}, {
       2.916442182946079, 1.1965628151283885`}, {2.9835130368636706`, 
       1.1696593407170532`}, {3., 1.163340863067302}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.159693329998634, -3.}, {-1.1728402749480225`, \
-2.9659737803740356`}, {-1.2006935311884759`, -2.897160171723827}, \
{-1.229261378907189, -2.8297781705253655`}, {-1.2571984016066797`, \
-2.7667722244185597`}, {-1.2867301202521504`, -2.7032717747579493`}, \
{-1.3170083374864927`, -2.6411331037513026`}, {-1.348033053309707, \
-2.580356211398619}, {-1.3672107161128095`, -2.544492205662389}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.3731155212342563`, -2.533449673163975}, \
{-1.3798042677217928`, -2.5209410976998994`}, {-1.4123219807227503`, \
-2.462887762655143}, {-1.4455861923125797`, -2.4061962062643496`}, \
{-1.5143541112588537`, -2.2968984294446533`}, {-1.5864139831557653`, \
-2.1925856638138153`}, {-1.6459338802557986`, -2.1140810896415267`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-1.6534992506375945`, -2.104102641942258}, \
{-1.6620717665984652`, -2.0927958059448395`}, {-1.7413274615869534`, \
-1.9975288558377258`}, {-1.82418106812123, -1.9067848134924745`}, \
{-1.8723767650572025`, -1.8564085472400411`}, {-1.9218458136289425`, \
-1.807363195243195}, {-1.998268016532817, -1.742072474497505}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.0077887041434113`, -1.7339385483285337`}, \
{-2.0188984372973975`, -1.724447033332186}, {-2.1208521649374266`, \
-1.645334782879211}, {-2.2194781539539643`, -1.5722227980963814`}, \
{-2.3229054414160513`, -1.5022213184728346`}, {-2.416107624665108, \
-1.4446174533992693`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-2.426759512575303, -1.4380340248510561`}, \
{-2.4311340273236883`, -1.4353303440085705`}, {-2.5441639116768746`, \
-1.3715498747035892`}, {-2.602598706976729, -1.3407610929529719`}, \
{-2.6624725593003324`, -1.3106199644264598`}, {-2.7237854686476837`, \
-1.281126489124053}, {-2.7865374350187837`, -1.2522806670457516`}, \
{-2.850728458413632, -1.2240824981915552`}, {-2.8743921053982042`, \
-1.2141488569106789`}}]}, 
     {Arrowheads[{{0.004911428168937861, 1.}}], 
      ArrowBox[{{-2.8859381904373125`, -1.2093019849533777`}, \
{-2.916358538832229, -1.1965319825614644`}, {-2.9834276762745735`, \
-1.169629120155479}, {-3., -1.163277911669664}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.1596758080344378`, 3.}, {-1.1728163262949682`, 
       2.9659895389603834`}, {-1.200668994106421, 
       2.897175612230238}, {-1.2292362377640433`, 
       2.829793298702666}, {-1.2571726710955575`, 
       2.7667870557297753`}, {-1.286703764903723, 
       2.7032863086006698`}, {-1.3169813409494948`, 
       2.6411473456460257`}, {-1.3480053992328738`, 
       2.5803701668658423`}, {-1.3671906505515472`, 2.5444910392521343`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.373095336567002, 
       2.533448443064657}, {-1.3797759397538594`, 
       2.5209547722601204`}, {-1.4122929625124516`, 
       2.462901161828859}, {-1.4455564675086505`, 
       2.4062093355720595`}, {-1.5143229242138685`, 
       2.296911035581844}, {-1.586381261533639, 
       2.1925977672788437`}, {-1.6459110438137665`, 2.1140780993891055`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-1.6534762884337046`, 
       2.1040995563420823`}, {-1.6620374311320871`, 
       2.0928074256524316`}, {-1.7412914330092129`, 
       1.9975400107026067`}, {-1.8241432671650162`, 
       1.9067955224293696`}, {-1.872338068063292, 
       1.8564188659349083`}, {-1.9218061996364957`, 
       1.807373136841294}, {-1.9982434753815645`, 1.7420678775114318`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-2.007764060804351, 
       1.7339338317340702`}, {-2.018857541829879, 
       1.7244559605229195`}, {-2.1208099595907504`, 
       1.6453427678133967`}, {-2.21943419243442, 
       1.5722302817255382`}, {-2.322859648775504, 
       1.502228328123541}, {-2.416081655077681, 1.4446108119052172`}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{-2.4267334714743716`, 
       1.4380272676506392`}, {-2.4310863286140023`, 
       1.435336907007405}, {-2.5441142319499144`, 
       1.37155601837713}, {-2.6025480070340348`, 
       1.3407670365142699`}, {-2.6624208172017787`, 
       1.3106257133130337`}, {-2.723732662453145, 
       1.2811320487734215`}, {-2.786483542788134, 
       1.2522860428954332`}, {-2.8506734582067463`, 
       1.224087695679069}, {-2.874365907238895, 1.214141730074125}}]}, 
     {Arrowheads[{{0.004912549732528795, 1.}}], 
      ArrowBox[{{-2.8859119516383256`, 
       1.209294761307238}, {-2.916302408708981, 
       1.1965370071243286`}, {-2.9833703942948384`, 
       1.1696339772312123`}, {-3., 1.163260667357924}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{0.7402057572851665, -3.}, {
       0.7470292626156192, -2.9721413593479635`}, {
       0.7645996921473988, -2.9036817222317235`}, {
       0.7825929814418107, -2.836793832858899}, {
       0.8010265083621817, -2.771428950882827}, {
       0.8199176507718381, -2.7075383359568463`}, {
       0.8397275740041751, -2.643665174569829}, {
       0.860066502564302, -2.5811671480170246`}, {
       0.8815667437072121, -2.51969726516021}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.8857010057008013, -2.507877276781656}, {
       0.9023861934140537, -2.4601737869761107`}, {
       0.9469863588133508, -2.3443128279582193`}, {
       0.9928071890037057, -2.2359567114302465`}, {
       1.041401853458764, -2.13162858498381}, {
       1.084032982239575, -2.048454101076758}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{1.0897446659285632`, -2.0373104519016567`}, {
       1.092496263447882, -2.031942010808624}, {
       1.1460904189710601`, -1.9368969889046894`}, {
       1.202184320028298, -1.8464935192720051`}, {
       1.2610420846194914`, -1.7603277591127244`}, {
       1.3229278307445358`, -1.6779958656289997`}, {
       1.3688121664486441`, -1.6225094539857985`}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.3767922250829019`, -1.6128594326544956`}, {
       1.3878415584034312`, -1.5994978388208307`}, {
       1.4557832675961777`, -1.5248336786882177`}, {
       1.4951616218715176`, -1.4835891721763141`}, {
       1.5356051442226122`, -1.4434602683200488`}, {
       1.6201934513830443`, -1.3718188955216637`}, {
       1.709441246655634, -1.3037331758846329`}, {
       1.7462235640338113`, -1.27695580447714}}]}, 
     {Arrowheads[{{0.02000000000000001, 1.}}], 
      ArrowBox[{{1.7563471958299526`, -1.2695858433675442`}, {
       1.7908964041919524`, -1.2444341658744615`}, {
       1.876419749103971, -1.1877152617560913`}, {
       1.9660112813916895`, -1.1335764635295222`}, {
       2.059671001055108, -1.0820177711947543`}, {
       2.1578139115993538`, -1.032818623525654}, {
       2.1888802258584317`, -1.0186302483909946`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{2.200270654581178, -1.0134280968156528`}, {
       2.2608550165295567`, -0.9857584592960879}, {
       2.3687943158457156`, -0.9408372785060558}, {
       2.4816318095478307`, -0.8980550811555578}, {
       2.5987386943884294`, -0.8576407434888148}, {
       2.6605490070373374`, -0.8377188145937364}, {
       2.668068159452041, -0.8354055685887939}}]}, 
     {Arrowheads[{{0.01326004533677195, 1.}}], 
      ArrowBox[{{2.680036719648186, -0.8317234748458199}, {
       2.7236781887698553`, -0.8182973001219085}, {
       2.788157679748357, -0.7993647562611198}, {
       2.8540189201352155`, -0.7809097391991595}, {
       2.921293350092805, -0.7629208051238164}, {
       2.990012409783499, -0.7453865102228796}, {3., -0.7429940336665711}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{1.155400141491579, -3.}, {
       1.1726088990715435`, -2.955616291482867}, {
       1.1999096925219197`, -2.8883796238463946`}, {
       1.2278761163769174`, -2.8226019690975}, {
       1.2565081706365369`, -2.7582833272361844`}, {
       1.2858058553007778`, -2.695423698262447}, {
       1.3157691703696406`, -2.6340230821762876`}, {
       1.3463981158431249`, -2.5740814789777064`}, {
       1.3623679029277989`, -2.5442375047674557`}}]}, 
     {Arrowheads[{{0.01999999999999999, 1.}}], 
      ArrowBox[{{1.3682759394184552`, -2.5331967007964638`}, {
       1.3776926917212309`, -2.515598888666704}, {
       1.4425484132957094`, -2.40252036496453}, {
       1.5106060136974775`, -2.2942971293268615`}, {
       1.5818654929265354`, -2.190929181753698}, {
       1.6404609661685334`, -2.1134071481121754`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{1.6480116414515524`, -2.103417576035695}, {
       1.656326850982883, -2.0924165222450397`}, {
       1.6999452114015257`, -2.037316019429776}, {
       1.7447122342048373`, -1.9836665011894923`}, {
       1.831833273802684, -1.8935890069358239`}, {
       1.9233046240956564`, -1.8076018723275948`}, {
       1.9948128265923943`, -1.743417213922987}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{2.004131651638293, -1.7350527804535452`}, {
       2.01379605817632, -1.7263781583728854`}, {
       2.1087467341619925`, -1.6486470705674217`}, {
       2.208156652052674, -1.574408608911203}, {
       2.3120258118483643`, -1.5036627734042298`}, {
       2.4100998880572524`, -1.4427612325524395`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{2.420737849984476, -1.436155325079901}, {
       2.4208033104287154`, -1.4361146757862941`}, {
       2.4772010980930084`, -1.4034291955881377`}, {
       2.5349382446733797`, -1.371469427797189}, {
       2.594014750169829, -1.340235372413448}, {
       2.6544306145823566`, -1.3097270294369143`}, {
       2.716185837910963, -1.2799443988675883`}, {
       2.779280420155647, -1.2508874807054697`}, {
       2.8419108540102136`, -1.223372502929041}, {
       2.868361156055611, -1.2122565122413793`}}]}, 
     {Arrowheads[{{0.005169469591716028, 1.}}], 
      ArrowBox[{{2.8799052847260183`, -1.207404982509236}, {
       2.9088092260429574`, -1.195257826610435}, {
       2.9771148005268087`, -1.1678381581982789`}, {
       3., -1.1590642586844226`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.10800898832738297`, 
       0.6476148200893467}, {-0.1194306411719552, 
       0.5856461172469307}, {-0.1460064581151666, 
       0.47896728769027086`}, {-0.19122268682510235`, 
       0.3656477825927888}, {-0.25051045323282334`, 
       0.2791063660220182}, {-0.25826300176285877`, 
       0.27046937203843746`}, {-0.2662554682111769, 
       0.26209965108700295`}, {-0.28807541079198207`, 
       0.24363010314450181`}, {-0.31168347242302236`, 
       0.22646201133187857`}, {-0.3287049287437282, 0.215832182169413}}]}, 
     {Arrowheads[{{0.01084248842670218, 1.}}], 
      ArrowBox[{{-0.3393260967383045, 
       0.20919930662921296`}, {-0.3627792695555442, 
       0.19455289708188342`}, {-0.422260143580802, 
       0.16714848180428904`}, {-0.49149179250576813`, 
       0.14360531906039595`}, {-0.5938459209691261, 0.11897390214100557`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.1079901981383321, -0.6475288874455648}, \
{-0.11940927237223554`, -0.5855713156019177}, {-0.14597888126806358`, \
-0.47891087257970255`}, {-0.1911884382453889, -0.36560112782353377`}, \
{-0.25046804715596627`, -0.2790680099921605}, {-0.25821932713504037`, \
-0.2704321541636474}, {-0.26621048712975826`, -0.2620635376563777}, \
{-0.2880281107714217, -0.24359553759896665`}, {-0.3116337754744068, \
-0.22642895484125006`}, {-0.3287084262506289, -0.2157658556628293}}]}, 
     {Arrowheads[{{0.010838829010862841`, 1.}}], 
      ArrowBox[{{-0.33932958018830783`, -0.2091329576134905}, \
{-0.3627246291168662, -0.19452277727781864`}, {-0.42220027498772134`, \
-0.16712112822554376`}, {-0.4914264500437661, -0.14358055019567084`}, \
{-0.5937699057247815, -0.11895280906600696`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.1961772553846451, 1.7623058049274596`}, {
       0.2063833928891175, 1.6758696827809358`}, {0.22131978264183982`, 
       1.562376636931315}, {0.23727308628412966`, 1.4566418190277868`}, {
       0.25438943333750025`, 1.358093837586171}, {0.2725520108089256, 
       1.2674732300298133`}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.2752981758293431, 1.2552563303832247`}, {
       0.2882842587792169, 1.1982284747447574`}, {0.30473773960225536`, 
       1.133573893049937}, {0.34021079575800967`, 1.0152420147346968`}, {
       0.37992969865665416`, 0.909109074329283}, {0.4242808798903703, 
       0.8140325208074268}, {0.4413456493433451, 0.7847239166222234}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{0.44764640350493523`, 0.7739024220629678}, {
       0.47383829788714366`, 0.7289180542738688}, {0.52917591107496, 
       0.6526713748333497}, {0.5448154916011725, 0.6333829323943202}, {
       0.5609172932230069, 0.6146645222476919}, {0.5965462151559697, 
       0.5800085456970973}, {0.6344382261317658, 0.547306512310619}, {
       0.7150440481153747, 0.48559702920377484`}, {0.8039740592397334, 
       0.43201244453665777`}}]}, 
     {Arrowheads[{{0.019999999999999997`, 1.}}], 
      ArrowBox[{{0.815182383216492, 0.4264491759631295}, {0.908294909991284, 
       0.38228169999054784`}, {0.9889153641138584, 0.3511723911525166}, {
       1.0766997076290212`, 0.32268457738310646`}, {1.1723011425411598`, 
       0.2965337924897733}, {1.27637287085466, 0.2724355702799727}, {
       1.2893120077906026`, 0.26990213849113454`}}]}, 
     {Arrowheads[{{0.0035861030570620606`, 1.}}], 
      ArrowBox[{{1.3016008208232979`, 0.2674960375480618}, {
       1.3897387207917227`, 0.25023898565295544`}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.2683450866566504, -1.364929100038152}, \
{-0.28783680208510365`, -1.2722878472665897`}, {-0.30413882996910485`, \
-1.204101771982024}, {-0.32147665863050434`, -1.1392029047846903`}, \
{-0.35885351726216624`, -1.0204112372197802`}, {-0.40069853982208725`, \
-0.9138528479493504}, {-0.41385028558138964`, -0.8869776819242066}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4193544558176167, -0.8757300885144398}, \
{-0.4474179273335996, -0.8183832944053404}, {-0.49961486286256823`, \
-0.732906181071668}, {-0.5578925294748581, -0.656325112432251}, \
{-0.5743735547424698, -0.6369372339108358}, {-0.5913414550749646, \
-0.6181220739591203}, {-0.6282453064844127, -0.5838142416711327}, \
{-0.667452192553192, -0.5514105828326714}, {-0.7388711867379314, \
-0.4989459239399337}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.7489629940098455, -0.4915324447643146}, \
{-0.7507674801753432, -0.4902068625122793}, {-0.8444896784731991, \
-0.43580378883010723`}, {-0.9499107337756423, -0.3874391167927427}, \
{-1.0336390811073555`, -0.3561100054147596}, {-1.1247556548596884`, \
-0.32740251226006084`}, {-1.2111190418300743`, -0.30444073250116155`}}]}, 
     {Arrowheads[{{0.00922058608105704, 1.}}], 
      ArrowBox[{{-1.2232207658160605`, -0.3012231986524197}, \
{-1.2239294212838003`, -0.30103478558357194`}, {-1.3318293466308515`, \
-0.2767249736402187}, {-1.4492975826617915`, -0.2543226391915591}}]}}, 
    {Hue[0.67, 0.6, 0.6], 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.26836280819894354`, 
       1.365021878844073}, {-0.28785655947891087`, 
       1.272371004007716}, {-0.30415944884261187`, 
       1.2041814918544937`}, {-0.3214981754338887, 
       1.1392793094464235`}, {-0.35887693175156377`, 
       1.0204814021329236`}, {-0.40072400381762724`, 
       0.9139172391862839}, {-0.4138627103409518, 0.88706848793838}}]}, 
     {Arrowheads[{{0.02, 1.}}], 
      ArrowBox[{{-0.4193668424564648, 
       0.8758208758737783}, {-0.4474456001796855, 
       0.8184423523393203}, {-0.49964491320552784`, 
       0.7329603176178944}, {-0.5579251352629438, 
       0.6563747110478678}, {-0.5744070252576046, 
       0.6369854832370198}, {-0.5913758129527312, 
       0.6181690104315564}, {-0.6282811634761541, 
       0.5838591067990825}, {-0.6674896019596542, 
       0.5514534619567926}, {-0.7388645299215512, 0.4990199345571661}}]}, 
     {Arrowheads[{{0.020000000000000004`, 1.}}], 
      ArrowBox[{{-0.7489562535601787, 
       0.4916063415347267}, {-0.7508081025615864, 
       0.4902459342022371}, {-0.8445337330210282, 
       0.43583937010855645`}, {-0.9499584443718334, 
       0.387471501160981}, {-1.033690355711812, 
       0.35613999014883774`}, {-1.1248107511251515`, 
       0.3274302781495881}, {-1.2110998478239954`, 0.3044874104098241}}]}, 
     {Arrowheads[{{0.009224211762819188, 1.}}], 
      ArrowBox[{{-1.2232015425615084`, 
       0.3012697665543231}, {-1.2239886151721195`, 
       0.3010604967450694}, {-1.3318929324129833`, 
       0.27674877751711885`}, {-1.4493658758197272`, 0.2543446734243567}}]}}}},
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-3.130537568661286, 3.130537568661286}, {-3.130537568661286, 
   3.130537568661286}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.584729819995315*^9, {3.584729861585373*^9, 3.584729889925413*^9}, 
   3.58472993814548*^9, 3.5847299874655495`*^9, {3.5847301255757427`*^9, 
   3.584730156365786*^9}, 3.584968774525674*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{763, 669},
WindowMargins->{{Automatic, 144}, {34, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 418, 11, 106, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1716, 51, 4275, 124, 352, "Input"],
Cell[5994, 177, 36838, 688, 375, "Output"],
Cell[42835, 867, 18192, 293, 375, "Output"],
Cell[61030, 1162, 43285, 792, 375, "Output"],
Cell[104318, 1956, 413570, 6970, 375, 255356, 4374, "CachedBoxData", \
"BoxData", "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
