(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      6539,        176]
NotebookOptionsPosition[      6067,        155]
NotebookOutlinePosition[      6410,        170]
CellTagsIndexPosition[      6367,        167]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Vector length",
  FontWeight->"Bold"],
 "\nCircles of radius 1 and 2 displayed. Vector moves with locator and \
displays the length."
}], "Subsubtitle",
 CellChangeTimes->{{3.584732286102293*^9, 3.5847323404123693`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"lgth", "[", "p_", "]"}], " ", ":=", " ", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thin", ",", "Red", ",", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", " ", 
         "Blue", ",", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], ",", "Black", 
         ",", "Thick", ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "2.5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "Locator", ",", 
       RowBox[{"Appearance", "\[Rule]", 
        RowBox[{"lgth", "[", "p", "]"}]}]}], "}"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Red circle: radius 1    Blue circle: radius 2 \>\"", ",", 
        "\"\< \>\"", ",", "\"\<Vector length\>\"", ",", "\"\< \>\""}], 
       "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.584730352796061*^9, 3.584730379246098*^9}, {
  3.5847305601863513`*^9, 3.5847305767563744`*^9}, {3.5847306134064255`*^9, 
  3.5847306602664914`*^9}, {3.584730705066554*^9, 3.5847307171565714`*^9}, {
  3.5847307689166436`*^9, 3.584730782986663*^9}, {3.584730821596717*^9, 
  3.584730886746808*^9}, {3.5847309185968533`*^9, 3.5847309363968782`*^9}, {
  3.584731282283366*^9, 3.5847313171534147`*^9}, {3.584731438981107*^9, 
  3.5847314661211452`*^9}, {3.5847317106814876`*^9, 3.584731713851492*^9}, {
  3.584731974341857*^9, 3.5847322122021894`*^9}, {3.584732249732242*^9, 
  3.5847322669022665`*^9}, {3.5847323680724077`*^9, 3.584732368212408*^9}, {
  3.584968695823536*^9, 3.5849687227959833`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {0.9750000000000001, 
    0.9500000000000002}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {1, 1}}, Automatic}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {1, 1}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{Thin, Red, 
         Circle[{0, 0}, 1], Blue, 
         Circle[{0, 0}, 2], Black, Thick, 
         Arrow[{{0, 0}, $CellContext`p$$}]}, PlotRange -> 2.5], 
      "Specifications" :> {{{$CellContext`p$$, {1, 1}}, Automatic, 
         ControlType -> Locator, Appearance -> Dynamic[
           $CellContext`lgth[$CellContext`p$$]]}}, 
      "Options" :> {
       FrameLabel -> {
         "Red circle: radius 1    Blue circle: radius 2 ", " ", 
          "Vector length", " "}}, "DefaultOptions" :> {}],
     ImageSizeCache->{439., {228., 233.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.584732267312267*^9, 3.5847323692324095`*^9, 
  3.5849686683362875`*^9, 3.5849687252295876`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.584731496281187*^9, 3.5847314996111917`*^9}}]
}, Open  ]]
},
WindowSize->{987, 630},
WindowMargins->{{Automatic, 65}, {19, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 247, 6, 48, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1545, 46, 2483, 61, 132, "Input"],
Cell[4031, 109, 1911, 39, 478, "Output"]
}, Open  ]],
Cell[5957, 151, 94, 1, 31, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
