(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     37624,        800]
NotebookOptionsPosition[     36545,        760]
NotebookOutlinePosition[     36988,        777]
CellTagsIndexPosition[     36945,        774]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell["\<\

Matrix Stretch
\
\>", "Subsubtitle",
 CellChangeTimes->{{3.5843822465150247`*^9, 3.5843822700350575`*^9}}],

Cell[CellGroupData[{

Cell["\<\

Initialize matrix : choose a mat* and load into mat\
\>", "Section",
 CellChangeTimes->{{3.58438227863507*^9, 3.584382319615127*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"2", "x2", " ", "symmetric", " ", 
    RowBox[{"matrix", " ", "--"}], " ", "enter", " ", "diagonal", " ", "and", 
    " ", "off", " ", "diagonal", " ", "elements"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"d11", " ", "=", " ", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d22", " ", "=", " ", "1.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"val", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"d11", ",", "val"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"val", ",", "d22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Matrix = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, 3.519156811457747*^9, {3.5192153918123827`*^9, 
   3.5192153974751925`*^9}, {3.5192154318576527`*^9, 3.519215691223708*^9}, {
   3.5192158081927137`*^9, 3.519215848627985*^9}, {3.519215887877654*^9, 
   3.519216004737459*^9}, {3.519216076466385*^9, 3.519216133858886*^9}, {
   3.519216519366763*^9, 3.519216550052017*^9}, {3.519216635914568*^9, 
   3.5192166381453714`*^9}, {3.519217165987899*^9, 3.519217215673986*^9}, 
   3.519217553164979*^9, {3.519217675890394*^9, 3.519217728431287*^9}, {
   3.5192178033270183`*^9, 3.519217836055876*^9}, {3.5192354757312593`*^9, 
   3.5192355017365055`*^9}, {3.5192355615782104`*^9, 3.519235579377842*^9}, {
   3.5192360996699553`*^9, 3.5192361066119676`*^9}, {3.519236155798854*^9, 
   3.5192361622104654`*^9}, {3.519250527129697*^9, 3.519250592228611*^9}, {
   3.5192506335374837`*^9, 3.519250686265576*^9}, {3.5192507781913376`*^9, 
   3.519250787083353*^9}, 3.5193003676408386`*^9, {3.5193004238789372`*^9, 
   3.5193004762014294`*^9}, {3.5193036080161295`*^9, 
   3.5193036918350773`*^9}, {3.519303722567131*^9, 3.519303742410366*^9}, 
   3.519303837040132*^9, {3.519304166660311*^9, 3.519304192228756*^9}, 
   3.5193120073460827`*^9, {3.5193120766102047`*^9, 3.519312082351014*^9}, {
   3.5193170104228706`*^9, 3.519317036521717*^9}, {3.5193211526529474`*^9, 
   3.5193211598133593`*^9}, {3.519321193025818*^9, 3.5193211987666283`*^9}, {
   3.519321513497181*^9, 3.519321592074519*^9}, {3.5193216490770187`*^9, 
   3.5193216896058903`*^9}, {3.519343007985736*^9, 3.519343043319798*^9}, {
   3.5193431211171346`*^9, 3.519343127232345*^9}, {3.519352043128805*^9, 
   3.519352043596806*^9}, 3.5193924460265155`*^9, {3.519393453853305*^9, 
   3.5193934546489515`*^9}, {3.5194077013054934`*^9, 3.5194077049715*^9}, 
   3.5194196552368903`*^9, 3.5195785836619773`*^9, {3.5212492789260855`*^9, 
   3.5212492863828983`*^9}, 3.5219253694127026`*^9, 3.521925458473259*^9, {
   3.5225460706154685`*^9, 3.522546077527864*^9}, {3.550005130514476*^9, 
   3.550005237561864*^9}, {3.5500052961087666`*^9, 3.550005301475176*^9}, {
   3.55000534364205*^9, 3.55000538924093*^9}, 3.5500054248245926`*^9, 
   3.5500055199067593`*^9, {3.550005610449319*^9, 3.5500056120873213`*^9}, {
   3.5500059477063107`*^9, 3.5500059751311593`*^9}, {3.5500060789961414`*^9, 
   3.550006082740148*^9}, {3.550006161707487*^9, 3.5500061716759043`*^9}, {
   3.550006211799175*^9, 3.550006215215581*^9}, 3.550006266602071*^9, {
   3.5500064095607224`*^9, 3.550006423195146*^9}, {3.550006490306464*^9, 
   3.550006503909688*^9}, {3.550066414869915*^9, 3.55006641778712*^9}, {
   3.5500664625591984`*^9, 3.5500664687056093`*^9}, 3.550066519516899*^9, 
   3.5500677396458426`*^9, {3.5500681282913275`*^9, 3.5500681442501554`*^9}, 
   3.5500682849000025`*^9, {3.5500683240716715`*^9, 3.5500683325580864`*^9}, {
   3.5500683723849564`*^9, 3.550068373102557*^9}, {3.550090428919712*^9, 
   3.550090440838133*^9}, {3.550091836194154*^9, 3.55009184566337*^9}, {
   3.5500919789500046`*^9, 3.5500920097132587`*^9}, {3.5500920562637405`*^9, 
   3.550092161875926*^9}, 3.5500922046668015`*^9, 3.5500923745822997`*^9, {
   3.550092411289164*^9, 3.5500924176383753`*^9}, {3.5500926347751565`*^9, 
   3.550092698688469*^9}, {3.5500927406681423`*^9, 3.550092767203789*^9}, {
   3.550176384290493*^9, 3.5501764452086*^9}, {3.5501764806674623`*^9, 
   3.5501764952378883`*^9}, {3.550176601583275*^9, 3.5501766229241123`*^9}, {
   3.5501766694901943`*^9, 3.550176721703486*^9}, {3.550176757037548*^9, 
   3.550176759003152*^9}, {3.550176870948948*^9, 3.550176901603002*^9}, {
   3.5501769367966633`*^9, 3.550176937280265*^9}, {3.5501784283740873`*^9, 
   3.550178457093738*^9}, {3.5502508434269114`*^9, 3.5502508901645937`*^9}, {
   3.5502510114392066`*^9, 3.5502511123713837`*^9}, {3.550251152666255*^9, 
   3.550251154444658*^9}, {3.5502511848647113`*^9, 3.5502511971575327`*^9}, {
   3.550251233599197*^9, 3.5502512356428003`*^9}, {3.5502513565430126`*^9, 
   3.550251408257104*^9}, 3.5502515021536684`*^9, {3.5601085466569166`*^9, 
   3.5601085819735208`*^9}, {3.5601086127487497`*^9, 
   3.5601086389045734`*^9}, {3.5601092671839256`*^9, 
   3.5601092834396467`*^9}, {3.56010931381382*^9, 3.5601093181507587`*^9}, {
   3.560109457289342*^9, 3.560109483903453*^9}, {3.5601095443546157`*^9, 
   3.560109550407532*^9}, {3.560109604072564*^9, 3.560109715146431*^9}, {
   3.560109765909482*^9, 3.5601097669234953`*^9}, {3.5601097991691084`*^9, 
   3.5601098003859243`*^9}, {3.560109896778364*^9, 3.5601099795530252`*^9}, {
   3.5601102210033107`*^9, 3.560110228054782*^9}, {3.5843821142448397`*^9, 
   3.584382160394904*^9}, {3.5843822243449936`*^9, 3.5843822281949987`*^9}, {
   3.5843822932950897`*^9, 3.584382392675229*^9}, {3.584382423105272*^9, 
   3.584382433955287*^9}, {3.5843830399461355`*^9, 3.5843830549361563`*^9}, {
   3.5843832528064337`*^9, 3.5843833150465207`*^9}, {3.584383572356881*^9, 
   3.5843835877969027`*^9}, {3.5843836314469633`*^9, 
   3.5843836316969643`*^9}, {3.58438370748707*^9, 3.584383730427102*^9}, {
   3.584383763007148*^9, 3.5843837789071703`*^9}, {3.584383990947467*^9, 
   3.584384068197575*^9}},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0.5`"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Matrix = ", 
   MatrixForm[{{1, 0.5}, {0, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.584383153206294*^9, {3.5843832373864117`*^9, 3.5843832562264385`*^9}, 
   3.5843833181565247`*^9, 3.5843835914769077`*^9, 3.5843836344669676`*^9, {
   3.584383716247082*^9, 3.584383733767107*^9}, 3.584383782397175*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create action ellipse and scaled dominant eigenvector\
\>", "Section",
 CellChangeTimes->{{3.5843824430153*^9, 3.584382452835314*^9}, {
  3.584382994496072*^9, 3.584383025836116*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "create", " ", "a", " ", "local", " ", "coord", " ", "system", " ", 
    "based", " ", "on", " ", "origin", " ", "and", " ", "eigenvectors"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"orig", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eigen1", ",", " ", "eigen2"}], "}"}], "=", 
     RowBox[{"Eigenvectors", "[", "mat", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Matrix = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Eigenvectors: \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"{", 
        RowBox[{"eigen1", ",", "eigen2"}], "}"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Eigenvalues: \>\"", ",", 
      RowBox[{"Eigenvalues", "[", "mat", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vv", ",", "ss", ",", "uu"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "mat", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<vv =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<singular values =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "ss", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "plot", " ", "an", " ", "arrow", " ", "in", " ", "dominant", " ", 
      "eigenvector", " ", "direction"}], ",", " ", 
     RowBox[{
     "the", " ", "length", " ", "of", " ", "the", " ", "dominant", " ", 
      "singular", " ", "value"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eigenplot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Black", ",", " ", "Thick", ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"orig", ",", 
            RowBox[{
             RowBox[{"ss", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", "eigen1"}]}], 
           "}"}], ",", "0.02"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"delta", " ", 
     RowBox[{"radians", " ", "--"}], " ", "number", " ", "of", " ", "circles",
      " ", "to", " ", "create"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"del", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "a", " ", "circle", " ", "made", " ", "up", " ", "of", " ",
      "circles"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"circpoints", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", " ", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"construct", " ", "action", " ", "ellipse"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellpoints", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mat", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "a", " ", "plot", " ", "of", " ", "circle", " ", "and", 
     " ", "action", " ", "ellipse"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", "circpoints", "]"}], ",", " ", "Gray", ",", 
        RowBox[{"Point", "[", "ellpoints", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Not", " ", "using"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"line", "[", "t_", "]"}], ":=", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Line", "[", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"mat", ".", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "t", "]"}], ",", 
             RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"lineplot", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"line", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Display", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plot", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"pplot", ",", "eigenplot"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "eps", " ", "fig", " ", "if", " ", "wanted"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "to", " ", "enable", " ", "file", " ", "export", " ", "to", " ", "home", 
     " ", "folder"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<matrix-stretch.eps\>\"", ",", "plot"}], "]"}], " ", "*)"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, 3.519156811457747*^9, {3.5192153918123827`*^9, 
   3.5192153974751925`*^9}, {3.5192154318576527`*^9, 3.519215691223708*^9}, {
   3.5192158081927137`*^9, 3.519215848627985*^9}, {3.519215887877654*^9, 
   3.519216004737459*^9}, {3.519216076466385*^9, 3.519216133858886*^9}, {
   3.519216519366763*^9, 3.519216550052017*^9}, {3.519216635914568*^9, 
   3.5192166381453714`*^9}, {3.519217165987899*^9, 3.519217215673986*^9}, 
   3.519217553164979*^9, {3.519217675890394*^9, 3.519217728431287*^9}, {
   3.5192178033270183`*^9, 3.519217836055876*^9}, {3.5192354757312593`*^9, 
   3.5192355017365055`*^9}, {3.5192355615782104`*^9, 3.519235579377842*^9}, {
   3.5192360996699553`*^9, 3.5192361066119676`*^9}, {3.519236155798854*^9, 
   3.5192361622104654`*^9}, {3.519250527129697*^9, 3.519250592228611*^9}, {
   3.5192506335374837`*^9, 3.519250686265576*^9}, {3.5192507781913376`*^9, 
   3.519250787083353*^9}, 3.5193003676408386`*^9, {3.5193004238789372`*^9, 
   3.5193004762014294`*^9}, {3.5193036080161295`*^9, 
   3.5193036918350773`*^9}, {3.519303722567131*^9, 3.519303742410366*^9}, 
   3.519303837040132*^9, {3.519304166660311*^9, 3.519304192228756*^9}, 
   3.5193120073460827`*^9, {3.5193120766102047`*^9, 3.519312082351014*^9}, {
   3.5193170104228706`*^9, 3.519317036521717*^9}, {3.5193211526529474`*^9, 
   3.5193211598133593`*^9}, {3.519321193025818*^9, 3.5193211987666283`*^9}, {
   3.519321513497181*^9, 3.519321592074519*^9}, {3.5193216490770187`*^9, 
   3.5193216896058903`*^9}, {3.519343007985736*^9, 3.519343043319798*^9}, {
   3.5193431211171346`*^9, 3.519343127232345*^9}, {3.519352043128805*^9, 
   3.519352043596806*^9}, 3.5193924460265155`*^9, {3.519393453853305*^9, 
   3.5193934546489515`*^9}, {3.5194077013054934`*^9, 3.5194077049715*^9}, 
   3.5194196552368903`*^9, 3.5195785836619773`*^9, {3.5212492789260855`*^9, 
   3.5212492863828983`*^9}, 3.5219253694127026`*^9, 3.521925458473259*^9, {
   3.5225460706154685`*^9, 3.522546077527864*^9}, {3.550005130514476*^9, 
   3.550005237561864*^9}, {3.5500052961087666`*^9, 3.550005301475176*^9}, {
   3.55000534364205*^9, 3.55000538924093*^9}, 3.5500054248245926`*^9, 
   3.5500055199067593`*^9, {3.550005610449319*^9, 3.5500056120873213`*^9}, {
   3.5500059477063107`*^9, 3.5500059751311593`*^9}, {3.5500060789961414`*^9, 
   3.550006082740148*^9}, {3.550006161707487*^9, 3.5500061716759043`*^9}, {
   3.550006211799175*^9, 3.550006215215581*^9}, 3.550006266602071*^9, {
   3.5500064095607224`*^9, 3.550006423195146*^9}, {3.550006490306464*^9, 
   3.550006503909688*^9}, {3.550066414869915*^9, 3.55006641778712*^9}, {
   3.5500664625591984`*^9, 3.5500664687056093`*^9}, 3.550066519516899*^9, 
   3.5500677396458426`*^9, {3.5500681282913275`*^9, 3.5500681442501554`*^9}, 
   3.5500682849000025`*^9, {3.5500683240716715`*^9, 3.5500683325580864`*^9}, {
   3.5500683723849564`*^9, 3.550068373102557*^9}, {3.550090428919712*^9, 
   3.550090440838133*^9}, {3.550091836194154*^9, 3.55009184566337*^9}, {
   3.5500919789500046`*^9, 3.5500920097132587`*^9}, {3.5500920562637405`*^9, 
   3.550092161875926*^9}, 3.5500922046668015`*^9, 3.5500923745822997`*^9, {
   3.550092411289164*^9, 3.5500924176383753`*^9}, {3.5500926347751565`*^9, 
   3.550092698688469*^9}, {3.5500927406681423`*^9, 3.550092767203789*^9}, {
   3.550176384290493*^9, 3.5501764452086*^9}, {3.5501764806674623`*^9, 
   3.5501764952378883`*^9}, {3.550176601583275*^9, 3.5501766229241123`*^9}, {
   3.5501766694901943`*^9, 3.550176721703486*^9}, {3.550176757037548*^9, 
   3.550176759003152*^9}, {3.550176870948948*^9, 3.550176901603002*^9}, {
   3.5501769367966633`*^9, 3.550176937280265*^9}, {3.5501784283740873`*^9, 
   3.550178457093738*^9}, {3.5502508434269114`*^9, 3.5502508901645937`*^9}, {
   3.5502510114392066`*^9, 3.5502511123713837`*^9}, {3.550251152666255*^9, 
   3.550251154444658*^9}, {3.5502511848647113`*^9, 3.5502511971575327`*^9}, {
   3.550251233599197*^9, 3.5502512356428003`*^9}, {3.5502513565430126`*^9, 
   3.550251408257104*^9}, 3.5502515021536684`*^9, {3.5601085466569166`*^9, 
   3.5601085819735208`*^9}, {3.5601086127487497`*^9, 
   3.5601086389045734`*^9}, {3.5601092671839256`*^9, 
   3.5601092834396467`*^9}, {3.56010931381382*^9, 3.5601093181507587`*^9}, {
   3.560109457289342*^9, 3.560109483903453*^9}, {3.5601095443546157`*^9, 
   3.560109550407532*^9}, {3.560109604072564*^9, 3.560109715146431*^9}, {
   3.560109765909482*^9, 3.5601097669234953`*^9}, {3.5601097991691084`*^9, 
   3.5601098003859243`*^9}, {3.560109896778364*^9, 3.5601099795530252`*^9}, {
   3.5601102210033107`*^9, 3.560110228054782*^9}, {3.5843821142448397`*^9, 
   3.584382160394904*^9}, {3.5843822243449936`*^9, 3.5843822281949987`*^9}, {
   3.5843822932950897`*^9, 3.584382392675229*^9}, {3.584382423105272*^9, 
   3.5843824821953545`*^9}, {3.584382703795665*^9, 3.5843827785357695`*^9}, {
   3.584382810295814*^9, 3.5843829521960125`*^9}, {3.584383105936228*^9, 
   3.5843831656563115`*^9}, {3.584383218306385*^9, 3.5843832311664033`*^9}, 
   3.5843838359172497`*^9},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0.5`"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Matrix = ", 
   MatrixForm[{{1, 0.5}, {0, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5502511168797917`*^9, 3.5502511557862597`*^9, 3.5502511982495346`*^9, 
   3.55025124088441*^9, 3.550251409052705*^9, 3.5502515034952707`*^9, {
   3.560108549996622*^9, 3.5601085680684857`*^9}, {3.5601086159948187`*^9, 
   3.56010864240034*^9}, 3.560109285951327*^9, 3.5601094855258846`*^9, 
   3.560109551967562*^9, {3.560109701948662*^9, 3.560109718110469*^9}, 
   3.5601097690607224`*^9, 3.5601098445656905`*^9, {3.560109955138712*^9, 
   3.5601099814562497`*^9}, 3.560110230316869*^9, 3.5843822147849803`*^9, 
   3.584383153236294*^9, {3.5843832374164124`*^9, 3.5843832563164387`*^9}, 
   3.584383318216525*^9, 3.5843835915069075`*^9, 3.5843836345069675`*^9, {
   3.584383716267082*^9, 3.5843837337871065`*^9}, 3.584383782457175*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvectors: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Eigenvectors: ", 
   MatrixForm[{{1., 0.}, {0., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5502511168797917`*^9, 3.5502511557862597`*^9, 3.5502511982495346`*^9, 
   3.55025124088441*^9, 3.550251409052705*^9, 3.5502515034952707`*^9, {
   3.560108549996622*^9, 3.5601085680684857`*^9}, {3.5601086159948187`*^9, 
   3.56010864240034*^9}, 3.560109285951327*^9, 3.5601094855258846`*^9, 
   3.560109551967562*^9, {3.560109701948662*^9, 3.560109718110469*^9}, 
   3.5601097690607224`*^9, 3.5601098445656905`*^9, {3.560109955138712*^9, 
   3.5601099814562497`*^9}, 3.560110230316869*^9, 3.5843822147849803`*^9, 
   3.584383153236294*^9, {3.5843832374164124`*^9, 3.5843832563164387`*^9}, 
   3.584383318216525*^9, 3.5843835915069075`*^9, 3.5843836345069675`*^9, {
   3.584383716267082*^9, 3.5843837337871065`*^9}, 3.5843837824671745`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvalues: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`"}], "}"}]}],
  SequenceForm["Eigenvalues: ", {1., 1.}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5502511168797917`*^9, 3.5502511557862597`*^9, 3.5502511982495346`*^9, 
   3.55025124088441*^9, 3.550251409052705*^9, 3.5502515034952707`*^9, {
   3.560108549996622*^9, 3.5601085680684857`*^9}, {3.5601086159948187`*^9, 
   3.56010864240034*^9}, 3.560109285951327*^9, 3.5601094855258846`*^9, 
   3.560109551967562*^9, {3.560109701948662*^9, 3.560109718110469*^9}, 
   3.5601097690607224`*^9, 3.5601098445656905`*^9, {3.560109955138712*^9, 
   3.5601099814562497`*^9}, 3.560110230316869*^9, 3.5843822147849803`*^9, 
   3.584383153236294*^9, {3.5843832374164124`*^9, 3.5843832563164387`*^9}, 
   3.584383318216525*^9, 3.5843835915069075`*^9, 3.5843836345069675`*^9, {
   3.584383716267082*^9, 3.5843837337871065`*^9}, 3.5843837824671745`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.6154122094026357`"}], 
        RowBox[{"-", "0.788205438016109`"}]},
       {
        RowBox[{"-", "0.788205438016109`"}], "0.6154122094026357`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[{{-0.6154122094026357, -0.788205438016109}, {-0.788205438016109,
     0.6154122094026357}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5502511168797917`*^9, 3.5502511557862597`*^9, 3.5502511982495346`*^9, 
   3.55025124088441*^9, 3.550251409052705*^9, 3.5502515034952707`*^9, {
   3.560108549996622*^9, 3.5601085680684857`*^9}, {3.5601086159948187`*^9, 
   3.56010864240034*^9}, 3.560109285951327*^9, 3.5601094855258846`*^9, 
   3.560109551967562*^9, {3.560109701948662*^9, 3.560109718110469*^9}, 
   3.5601097690607224`*^9, 3.5601098445656905`*^9, {3.560109955138712*^9, 
   3.5601099814562497`*^9}, 3.560110230316869*^9, 3.5843822147849803`*^9, 
   3.584383153236294*^9, {3.5843832374164124`*^9, 3.5843832563164387`*^9}, 
   3.584383318216525*^9, 3.5843835915069075`*^9, 3.5843836345069675`*^9, {
   3.584383716267082*^9, 3.5843837337871065`*^9}, 3.5843837824771748`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.7882054380161092`"}], 
        RowBox[{"-", "0.6154122094026356`"}]},
       {
        RowBox[{"-", "0.6154122094026356`"}], "0.7882054380161092`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[{{-0.7882054380161092, -0.6154122094026356}, \
{-0.6154122094026356, 0.7882054380161092}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5502511168797917`*^9, 3.5502511557862597`*^9, 3.5502511982495346`*^9, 
   3.55025124088441*^9, 3.550251409052705*^9, 3.5502515034952707`*^9, {
   3.560108549996622*^9, 3.5601085680684857`*^9}, {3.5601086159948187`*^9, 
   3.56010864240034*^9}, 3.560109285951327*^9, 3.5601094855258846`*^9, 
   3.560109551967562*^9, {3.560109701948662*^9, 3.560109718110469*^9}, 
   3.5601097690607224`*^9, 3.5601098445656905`*^9, {3.560109955138712*^9, 
   3.5601099814562497`*^9}, 3.560110230316869*^9, 3.5843822147849803`*^9, 
   3.584383153236294*^9, {3.5843832374164124`*^9, 3.5843832563164387`*^9}, 
   3.584383318216525*^9, 3.5843835915069075`*^9, 3.5843836345069675`*^9, {
   3.584383716267082*^9, 3.5843837337871065`*^9}, 3.5843837824771748`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigular values =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.2807764064044151`", "0.`"},
       {"0.`", "0.7807764064044151`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigular values =", 
   MatrixForm[{{1.2807764064044151`, 0.}, {0., 0.7807764064044151}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5502511168797917`*^9, 3.5502511557862597`*^9, 3.5502511982495346`*^9, 
   3.55025124088441*^9, 3.550251409052705*^9, 3.5502515034952707`*^9, {
   3.560108549996622*^9, 3.5601085680684857`*^9}, {3.5601086159948187`*^9, 
   3.56010864240034*^9}, 3.560109285951327*^9, 3.5601094855258846`*^9, 
   3.560109551967562*^9, {3.560109701948662*^9, 3.560109718110469*^9}, 
   3.5601097690607224`*^9, 3.5601098445656905`*^9, {3.560109955138712*^9, 
   3.5601099814562497`*^9}, 3.560110230316869*^9, 3.5843822147849803`*^9, 
   3.584383153236294*^9, {3.5843832374164124`*^9, 3.5843832563164387`*^9}, 
   3.584383318216525*^9, 3.5843835915069075`*^9, 3.5843836345069675`*^9, {
   3.584383716267082*^9, 3.5843837337871065`*^9}, 3.584383782487175*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{
   {PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {GrayLevel[0.5], PointBox[CompressedData["
1:eJw1j31Q0wUchxH1IsAGeB4CyU4YZsQ7XIMZfB0IUnoeEG+HUjanBMiLzKuO
yATM81AnGeZ4C0SE9E4YyIsM6EsQTTYHDJLXAWODAXv77YcyBQmy6/rcPfc8
/372sjKiTpuamJjAG/71fzPA/8VI8Xq+0WoAN/FVcR23DZK5xEeMUBI6hgKd
N9P6gCbrLwuvIcFPILglWRqC5KCdUu8JElKTPlhiaMfgDLXV+pycBMP2I+cX
66ZB/t0OtvExCQnMe7bXrRVAj7nTs49NQptdWHJ6+RyoxIvUSYUBJBvYXfRC
BY6TJ70/+9AAzF8TeVutl8D0ekDcUJce9JZv34jWqYHGyr4f9KcW/E+5H+29
pAXRgquDdZ4aemPsq0KGdRDT/JK/a20Bjjj2rn79TA/BYbXTvX7zsHX20Izk
CgFrK9yX9AAFXE1zK83WEMCKLHCwd5yG3mC5MHedgAzWtEyQMwotPM/R1nYC
HnFdJw5XDIJhV2du9/sERMyLxZUePRDnb0+1DdeDmc1y6aWWuxDWJFUbd+uA
7Wrr8hwb8XWWBpIrNMB/S5JdfEuIZqMPxn1nlqDGy2wLRziETp7x7lLZAnwj
TeRYFY0jT9qzwi6fB1pN+ZeVFDk2iAZ21O9Tws0GPs/ZTYntP1S2r1+Qg3L8
REqZrQota2k074RJkBm/198ULWLXfKJzVuYz4DMmuqhBGhz2Ch95XNEP71kM
8P9O1eHxZy1p/lbdcHeeKS4+RqCHFS+P8sk9KLx8qL8w04A+7osBdOVDrDZu
dAspJN62bBWZev+BheED+Qn5JJ4/umnVlzCInPHWc3tFJFJZggsHOCOY6rWQ
l6QkkZQaQphRMjzLEVlr+0lkOnhoU17IsWxbcp7yGomVXdrN2CIlJkWyOox7
SOx/RHX3MH3zo2Qum5lvwDpH2VQbfRG7f5zU/ZJDYOcTRfannmpcO+uu8qrS
4ZjN4MyyUoMdCoszxm816FKwhXEgUoeSleGRdMoSGvaHel/m6LGkfpUjYanw
4kFhoO4wge/st89YylGiQJu4M/IpgUP0+5lup+UYpaVTPt8kcObhq5DNsAnc
DLQsKZITmCVnK9IvDmO1xumrg5kENpWpzVcpfehbLF/Jrdej/+4B+nJnM7Y5
jb0bVqnDzC/+SnqQXgqjNEFjcKgWTWvjo6cbfge6TUc0cUeNEa0+3OonA5C5
3ed2jmARA15tc6UIRyCOb36s7ycVRlMzVq9kTEHTys+2sb5zmFASQR5XzUKl
MPtjesUs+gl6ol0X5kA0wxWad0yh4qTRJbdxARw6Ldg83SiGrolrGEw1dFXx
C8hZKYbbnaI9vaaFE699R+0ihbje0dkYe0MPeyS/TcaHNuM/i8ItcA==
      "]]}}, 
   {GrayLevel[0], Thickness[Large], 
    ArrowBox[{{0, 0}, {1.2807764064044151`, 0.}}, 0.02]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}]], "Output",
 CellChangeTimes->{
  3.5500052387162657`*^9, 3.5500053052659826`*^9, {3.5500053498976607`*^9, 
   3.5500053907073326`*^9}, 3.550005426103795*^9, 3.550005523479166*^9, 
   3.550005613491324*^9, {3.550005950171115*^9, 3.550005976722362*^9}, 
   3.55000608375415*^9, 3.550006172908306*^9, 3.550006216307583*^9, 
   3.550006268380474*^9, {3.550006411292325*^9, 3.5500064241467476`*^9}, {
   3.5500064929584684`*^9, 3.5500065049860897`*^9}, 3.5500664192223225`*^9, 
   3.550066469704011*^9, 3.5500665213733025`*^9, 3.550067741408646*^9, {
   3.550068129008929*^9, 3.5500681469957604`*^9}, 3.550068286928006*^9, 
   3.5500683377684956`*^9, 3.5500683744441595`*^9, {3.550091995142833*^9, 
   3.550092012209263*^9}, {3.550092100411818*^9, 3.5500921632331285`*^9}, 
   3.550092205571603*^9, 3.550092418574377*^9, {3.550092660156401*^9, 
   3.550092700076871*^9}, {3.550092741760144*^9, 3.5500927716341968`*^9}, {
   3.550176421059758*^9, 3.550176446316202*^9}, {3.5501764816970644`*^9, 
   3.5501764965794907`*^9}, {3.5501766046876802`*^9, 3.550176624374915*^9}, {
   3.550176680301013*^9, 3.5501767237626896`*^9}, 3.550176768300768*^9, 
   3.550176903818206*^9, 3.5501784301524906`*^9, 3.550251116942192*^9, 
   3.55025115581746*^9, 3.5502511982963347`*^9, 3.5502512409312096`*^9, 
   3.5502514090995054`*^9, 3.550251503526471*^9, {3.5601085500590467`*^9, 
   3.560108568099698*^9}, {3.5601086160416374`*^9, 3.560108642618826*^9}, 
   3.5601092859981284`*^9, 3.560109485557085*^9, 3.5601095519831624`*^9, {
   3.560109701964262*^9, 3.560109718126069*^9}, 3.5601097690607224`*^9, 
   3.5601098445812902`*^9, {3.560109955138712*^9, 3.56010998147185*^9}, 
   3.5601102303324695`*^9, 3.5843822148949804`*^9, 3.584383153246294*^9, {
   3.584383237426412*^9, 3.5843832563264384`*^9}, 3.5843833182265253`*^9, 
   3.5843835915169077`*^9, 3.584383634516968*^9, {3.5843837162770824`*^9, 
   3.5843837337971067`*^9}, 3.584383782497175*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1006, 703},
WindowMargins->{{Automatic, 57}, {Automatic, 11}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 291, "Subtitle"],
Cell[1255, 37, 117, 5, 99, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1397, 46, 144, 4, 143, "Section"],
Cell[CellGroupData[{
Cell[1566, 54, 6677, 105, 260, "Input"],
Cell[8246, 161, 1024, 26, 49, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9319, 193, 193, 4, 105, "Section"],
Cell[CellGroupData[{
Cell[9537, 201, 12664, 266, 1340, "Input"],
Cell[CellGroupData[{
Cell[22226, 471, 1542, 33, 49, "Print"],
Cell[23771, 506, 1561, 33, 49, "Print"],
Cell[25335, 541, 985, 17, 32, "Print"],
Cell[26323, 560, 1749, 37, 49, "Print"],
Cell[28075, 599, 1750, 37, 49, "Print"],
Cell[29828, 638, 1628, 33, 49, "Print"]
}, Open  ]],
Cell[31471, 674, 5034, 81, 475, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
