(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27115,        532]
NotebookOptionsPosition[     26647,        513]
NotebookOutlinePosition[     27088,        530]
CellTagsIndexPosition[     27045,        527]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "\n",
 "Mathematical Principles for Scientific Computing and Visualization  \n\
http://www.farinhansford.com/books/scv\nby Gerald Farin and Dianne Hansford",
 "\n\n",
 StyleBox["Comparison of Typical Algorithm Complexity Functions",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],
 "\n\n",
 StyleBox["This notebook demonstrates the growth of the polynomials, \
logarithmic, and exponential functions that are typical big-O categories of \
computing time.\n\nChange the last value in the \"{n,1,10}\" expression in \
the Plot command below to larger and larger numbers to see how the \
exponential function dominates.",
  FontSize->14]
}], "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4124631817744017`*^9, 3.4124632180265293`*^9}, {
   3.4125111855484333`*^9, 3.412511368541565*^9}, {3.413132449204488*^9, 
   3.413132501249325*^9}, {3.4131325417776017`*^9, 3.413132544571619*^9}, 
   3.427042062883616*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Log", "[", "n", "]"}], ",", "n", ",", " ", 
       RowBox[{"n", "*", 
        RowBox[{"Log", "[", "n", "]"}]}], ",", " ", 
       RowBox[{"n", "*", "n"}], ",", " ", 
       RowBox[{"n", "^", "3"}], ",", " ", 
       RowBox[{"2", "^", "n"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "50"}], "}"}], ",", "  ", 
     RowBox[{"ImageSize", "\[Rule]", "800"}], ",", "\[IndentingNewLine]", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", " ", 
        "20"}], "]"}]}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{"Red", ",", "Thick"}], "]"}], ",", " ", 
        RowBox[{"Directive", "[", 
         RowBox[{"Green", ",", "Thick"}], "]"}], ",", " ", 
        RowBox[{"Directive", "[", 
         RowBox[{"Blue", ",", "Thick"}], "]"}], ",", " ", 
        RowBox[{"Directive", "[", 
         RowBox[{"Yellow", ",", "Thick"}], "]"}], ",", " ", 
        RowBox[{"Directive", "[", 
         RowBox[{"Cyan", ",", "Thick"}], "]"}], ",", " ", 
        RowBox[{"Directive", "[", 
         RowBox[{"Magenta", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"PlotLegend", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<logn\>\"", ",", " ", "20", ",", "  ", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<n\>\"", ",", " ", "20", ",", "  ", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<nlogn\>\"", ",", " ", "20", ",", "  ", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<n^2\>\"", ",", " ", "20", ",", "  ", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<n^3\>\"", ",", " ", "20", ",", "  ", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<2^n\>\"", ",", " ", "20", ",", "  ", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}], 
        ","}], " ", "}"}]}], ",", " ", 
     RowBox[{"LegendPosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.95", ",", " ", 
        RowBox[{"-", "0.3"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.412462343819482*^9, 3.4124623788999248`*^9}, {
   3.4124624367631283`*^9, 3.4124624904002542`*^9}, {3.4124625286252193`*^9, 
   3.412462585677256*^9}, {3.4124630762426543`*^9, 3.412463140424944*^9}, 
   3.412463174924552*^9, {3.4124632860243053`*^9, 3.412463292443536*^9}, {
   3.412463427517763*^9, 3.412463453575232*^9}, {3.4124634907386703`*^9, 
   3.412463492130672*^9}, {3.412463578304584*^9, 3.4124636383809695`*^9}, {
   3.4124637545780525`*^9, 3.412463806332472*^9}, {3.4125099495811996`*^9, 
   3.4125100116304226`*^9}, {3.412510126435504*^9, 3.4125102082932096`*^9}, {
   3.4125104852214127`*^9, 3.4125105311274223`*^9}, {3.4125106910774193`*^9, 
   3.4125106958643026`*^9}, {3.4125107515343523`*^9, 
   3.4125107913015347`*^9}, {3.412510906637379*^9, 3.412511179890298*^9}, {
   3.4125113890610704`*^9, 3.4125114262144947`*^9}, 3.412531487559765*^9, {
   3.412531519355485*^9, 3.4125315407562575`*^9}, {3.4125321403985004`*^9, 
   3.4125321420909348`*^9}}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {RGBColor[1, 0, 0], Thickness[Large], LineBox[CompressedData["
1:eJwV0nk8FHgfB/AZDWaMYxwZiZzrXEKOGZl+X+dQSMjj6Fo2bE9PWSa1o1nT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        "]]}, 
      {RGBColor[0, 1, 0], Thickness[Large], LineBox[CompressedData["
1:eJxNxVtIU2EcAPCzNbNp1NpsI828xURscy5v063NqWcaZmoRhNmDogwzZ6Kr
XMuTmho5L4lGYLchUktxkUJU0ihEItJyPZRKGi2DUMx0LnV6qgf/3/fw4xeU
p8suYBIEkfHP/70rddsZxC/l5sWZGnmzAj0iDCj2N6Bv2EfeypbRviLx9bLZ
BThsepbt+LQIa8giz+HHLriGW8A05dOwtuE8KWdvU21O1tvNYvtOOEh/YoPx
nAf7qLUtyVMC+JvJo2TohR8cujgs2TcXAA9e3S9bYgXDHz9Yqv7Mh8DdltdP
tSwhXJhkFlxwhsK90dPRtskwuK/fSpbPhcN3F0nj8LgITnup665biIAVvw0a
JS2B3znMI15LkfAzf97RxnUpfCemMC/XeRCeamfqHIxo2HE/Y6KeHQNPm4zj
lTRaZnOOhXjFwdfGMk/v3SKDb7fmpEW60Dtu9oncdDysvzTTxXclwPIHhbt/
MBXwENXx3c4+BKfIHqZyaPSuzursKywVbPAOPmym0JqsW+eyVtHq+IH2nMuJ
cFybusa0gs5tLj/rW6WGjWuCoNE1NK1oY3H1SbA15ImjbxV96mJyU4U+GY4t
q4zqcKPLExu8UqgUuIfytPitoXn54eQRioQrBmyPut1o2RdRYpNeAx+wKO3v
V9G+M6/ECfpUOHboZx3hRksbe2s52OJjpdWB2MKvTqMKm79OVFDYy1GCfGId
3d+VpCQ20NYzWxUc7B7pm/hA7C5bRowKu23ypIjCLvMp9SNodMmEdA8Hu8js
5Adi50kMXBV2Vnodm8JO56V5tmCnjnt73MNWaVsJG7Y84vjGKHbcMt89hR01
+HllHltS2+misf8CDWgprg==
        "]]}, 
      {RGBColor[0, 0, 1], Thickness[Large], LineBox[CompressedData["
1:eJwVyXk4FHgcx/ExuVWukCtEShn3NY5+X4M5loQppdRmXFOJiKkc24hIriLa
3ZJSSdKyG8+2pcc8laN6UpmsmhEyjtYRwpiJzP764/O8n9fzMWMlhEQTCQRC
GN6PqqUmrJQjTCNxRxxJ0tawNS6I5lnsNY2cxwvV84jFqNPSJM44bRqpp+SH
/+5ZiUr4nS/J4mnEofQRE+vrkQHJJj9pYga9cim2SKTxkNXAhMrQ+1lkHJY4
42H4FtGoh5Ta/1xA5eO7bFMvD6IaI4rrzqkFxPJIHi6giZDqrH6syFqCTu5m
uPfOiVBn5fM22W0Jin+wxdWCOYxCpZty3K5KkULY3DqFdZ9RdN2ofO25RTQd
IRgsG5tEWVrRxMJIGXIk9NT1W86jdPfiBnq1DFWo3LIVlM8jDuuf/fL/ydCv
ffzYCCUxcvqQ89HLlQA3qEpRmmNiZGklJDc1E+Bhd/Tp900SpPY86+uNdjko
Gch20Y9ZQt3K3ZGZH1dAFKONFadJBPbZ41RPFWUgVWyw90lUBWouv8qGrw4n
/rAK/CDRATNO6LLcI20gJ8XoPkk3gTUU9nnffj3QCuGk3gjZAKJChfjWZkNw
aNOMpwo3w8bZdrt1kyawo5lB33zRDh6fsSDPya+HEsfJHGanI7x7W3tKMmUO
6opTAVYTLlBd+/QBW94ShMCRiGPdIcanSu/E/EbgugqfMVq84J7zgDOv1wpc
PDnK9QUA9Y0N1OTJLVAapreayaZA5Sw1o11AgvQi5gWptS8wWhKqc2ZsoaBY
ZFJhSgWvr2k0JLMDtOec2XVtOrwaqupUnbMH87xnSpsnGPDQWHt7wXcHeLi6
hKE65w9XXWJY++YdoZlyaW13/zboLyMmDMk5g25v6jvu4nYYuh4ozFVxgb5V
DdIplWAYKMwQpMpcwKbp/shnxRAg8+a7zFXdgJUtPaNjxIS8rqD9RivIML5q
ITfNbAdUXNjLsF8gQ9BGgrW+xU5YfametCRzh/CaSzV2KBQ46SM3dRc8oCZh
z4o7jF3gWROjM0r0AsoQkd8XtxtaueXDfJWtMMvsJBkXhoEf+Q5dQ7YV3Cob
jZcv7wHNK6dDMuUBCu/SaKKneyFNbf1PVVyA62X+V1YKwoEW/Fti8DcAi3/N
ergT+4Di3lS29xdvYCYb+Hit/RncSilZhVJv6OIaPeOvPQD7ipOPGJyiwGe1
i8r+fx2AjEU9s9eLFFhjrOGdRIkAmVepvBbHB2by42YK3kRAg/n9ofpvPnD7
rKEg7zALwk/6FqVwfIHSI/ZbWGKBa1KqU/mSL7Qc6GtgXY6EZO+zqn5cPzB5
PZ3+yDUK6rhKtYaLftDYj/oYL6JAO3ILdRuXCnWj+uNzB6MhpYl3t3qJCrbr
ux/8LYsGch/Ju4hDA8vQRH3r0hiwrkX8N99ooJxJ1hE4xoLByBMbDw4dhBXT
I0dexIJr61gOYYkOvwz69zPj2eBQcC9bA/vUYFdmLLYN8+hpU+yixHCLNGzL
T/MZgN3hefxgFbbud0IKFzsr9+XsNLbYSS+S8J0Otya+KBclsKHxpg8iLNPB
dMzUueMoGxoOK3ppYB/rkPYIsescnrubYl917k6dwr7JC3SBH39zKU83kQ2l
vWEkLvaXNNuAaOykNUcNCTI6tPA+RRKT2BAvdNDXwG7LFynqYh+qmtc1xc4f
Hr1jhc2yS9MCbF8/yVQQdnBAjgoXe3uTa3oldoA2Q+k8tqZ4m8l9bLpATeEa
9pnWmCdt2MC+QOBhczSuKX/B9rTdsfwaeyafd1fuGBvcxLpL/dg65aJAHWyn
xx+kU9iDNipfN2HbZV9ZkGHvDLUv88T+H2mXg04=
        "]]}, 
      {RGBColor[1, 1, 0], Thickness[Large], LineBox[CompressedData["
1:eJwV1Gs41IkCBvAxRmaoDCO5JZdSHmGSy8ww/q9LM9MmSeimnCirK1kpZJvI
kFAhu20MIbUk2ji7Opx0ddQTa2wXYqks1Srjbhjm/PfD+7zP79P77bUIiwrY
T6VQKLFk/mnthKiFahQ5cVuj15BK9mF/ofsFvpyYlTRs0T4lJ1qtlx9elign
Qppla74q5EROR+tz7qScCEz9uQWzI4Sxnf35mKERwmBSVWikP07Y9A0x+t+M
EX9X+N+5Ip0mMv79mBtjME5sXXZvEZ+jIIYyCw5QAseJNr+Qhfc6FEQN17fF
tG2cUH79Rg7mLMHJrUwPejJB2K5oD0gumiOEgoOazXemiL9r8ODAeTXcNPVy
DRqeIm6FuZ2hD6pBa8zo2w9rponp7wL08rypaC1qeaq6MU3Y1L28cUxFRbBi
tYQjVRCTd9jFgmQa9t8apFVkkDuXOU+31WoiRW8/NStcReyiXhw0eLYYp3gX
akTlKqLkyPuPmZt0EBdWv4f2SUU4r7MljGQ6cOqU9PBdKSgc2HycF8WEtc1b
bl0DBeHSDDPTZF1ot6SMljarQXHWMHLqAQsv6S/Dz/SoQ2Sf/3pRhSFkpp95
vfPqKKRfX2U/Z4hWtkqXb06DPtOhpNPfCP/bbtM0HUZDfHmtgUxhhHs3k0yj
P9JAGUmdEwWYQCqyfrlnTAMGc3jot8wMkeknBO4MOmpPLtTvWWSJfdMfdfat
piPRzIPV4m6J0MidneeFdDzaqGoYOWSJYBH/8NtUOnrd2UzFM0v40NVzEqgM
8ON963rPW8E8Pbvnt1kGLuw8OrPQaCVep12Pdf6qjaz726IH/7UagrSOEvsO
HSj1HmgVlDugc4g3XT+iA6uPQX4JHxzgYtNebklnYodDXvQGJhvPsjnKKmsm
GIbeCfWb2BjdoXnjcTgT7+7oHZhqYcNLXqYc6WEiSjO+9nPzWrw37bvhK9MF
gxdGre5cB4u44Hm1/7Bg11iecDuQA/9GKT33OQvaQ/dCriZxIKYN6q3oZkH2
Oz+ropyDvpwTqwRzLOg2XOh0UHBQXP2jfwahj21G+5a/KuLC7FNXid5jfagN
t4ZeGuPBOCRUaPViCboXVN19WMuHvlfkRZ/epQiJfbKV3uaJD1kaR580mKDd
ifPfAS0RVo01s82+LEdRrCxV2LUZjakruOM0S8iyPRirNgbij/aK09PDVvBw
c/Cbe70d5RWPfoukWSP8ndU6C989iPAuWXpyYhV6Xl3/yVW+F1XOfc5N3TaQ
Xr9s2zuwD9W1NYLYL7aIfy50yw+NRNGYIKm5yw6B5lNBe7sOYcP9qHLJiAMM
tbvesD5EgT+aKCRUbHz367Q4YnEMXvSXtGqNr4X92/uwWBmLe8tYmzPnHPF4
9fxVu4w4SF0iwnZPrIOnoD4t+q+T6L1MjepXc0Y6/ZfuqbxE9F/ze5vGcIGL
JFrktvN79GUldSWoXPA50aMAaWJwmyZkVlocvMpTjnJ0knFO5r/HVJ0LT7OW
4u7MFBRe2rVh7RQXR2OaU37RTcXiH6rtlCoeGh8ZZimaJYg7NVBmMOUGV+mA
ycHodLjfjFgySOXjWcJaY+9NGXgizv+rg+EB3knrrdGOmVjP/VnEVHmgpvB5
rsOCbOgWJAecoQF5jY8+qTMuIlHb8psSMeAaHHjfT+MShFuuHNsyA+jaDi8Z
Vs+BF6/u8q7vPZHuUZocaZ4LTq5XSpbCEzeyIyhn1uZh94XYI8anvVCYMmvz
Ze9lJM0utWib9ULP7ULNRZJ8qPi5NL04b+yOr9OXVf6AGqu7/dUz3jg2s/d0
/eiPCIn3yT4e54P54LmhHNuf4BqT4JSv9IGb0IamnXYVsZ7pWuvF6/HU+GRW
fX8Bbok1K0xm10PXMSEny1EKVritYJNYADe3tuDOsiIcr2uqLFcK4GQvlTuk
FIP7p51ndpwQdbSN9VZO17Cmguj4fUYIpuYHFm/6GowHHtq7xYngVql1ddHd
Erg++SyhKEWoMqkKeHCmFI6ZVWeZpE9LXDZ2kbbfGp1sTvr1UJv3GGnrdxNJ
IG18y9F5ZXIp+SuU42LSg+O/Gp4jPem0NJwyJ8KV6gfv/VNKUVvmTVDmRQhr
aU/uO1uKmkML+EzS8rKdSQrStxxbeOakNU6NndBLLUVZk58LSN83DTriQzq3
e4edmHT86jfbb5KO0Y82oahEoB/ocYyWlOLoW0cjJukJ5X77c6QPlkwYmJP+
NnPepoR0GDtRD6T/LAy1+IP0Fl8JQ0xa5/w7JietFL6sDZoXSdvMflq4hbSo
S1ujmPSzCCrjIGlEXqI0kZayw9UKSLs7BM63kW7PrpyrJc2ZNFD2ks74qD7z
grRTY6dimHQL//DkAGn22YIpFems7P5RFen/A+WoSLY=
        "]]}, 
      {RGBColor[0, 1, 1], Thickness[Large], LineBox[CompressedData["
1:eJwVlvc71Q0Dh42Tcey9R2aeJGQd4ftBHHkq8paS1bBKZTwiKycKeTgkMgol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        "]]}, 
      {RGBColor[1, 0, 1], Thickness[Large], LineBox[CompressedData["
1:eJwVlmc8FQ4Dha+Rvfdel8s1bzaVe5JVUVKESkZGqGwKJTspM+IvRFEqKyJZ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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     AxesStyle->Directive[FontFamily -> "Helvetica", 20],
     DisplayFunction:>$DisplayFunction,
     FormatType->TraditionalForm,
     ImageSize->800,
     PlotRange->{{1, 50}, {0., 85522.8298566549}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], {
    {GrayLevel[0], 
     RectangleBox[{1., -0.35}, {1.3754189944134079`, 0.4499999999999999}]}, 
    {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.001]}], 
     RectangleBox[{0.95, -0.3}, {1.3254189944134078`, 0.49999999999999994`}], 
     InsetBox[
      GraphicsBox[{{{InsetBox[
           GraphicsBox[
            {RGBColor[1, 0, 1], Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 0.08}, {
           Left, Bottom}, {1, 1}], InsetBox[
           StyleBox["\<\"2^n\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->20], {1.21, 0.58}, {-1, 0}, Automatic, {1, 0}]}, {
          InsetBox[
           GraphicsBox[
            {RGBColor[0, 1, 1], Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 1.24}, {
           Left, Bottom}, {1, 1}], InsetBox[
           StyleBox["\<\"n^3\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->20], {1.21, 1.74}, {-1, 0}, Automatic, {1, 0}]}, {
          InsetBox[
           GraphicsBox[
            {RGBColor[1, 1, 0], Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 2.4}, {
           Left, Bottom}, {1, 1}], InsetBox[
           StyleBox["\<\"n^2\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->20], {1.21, 2.9}, {-1, 0}, Automatic, {1, 0}]}, {
          InsetBox[
           GraphicsBox[
            {RGBColor[0, 0, 1], Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 3.56}, {
           Left, Bottom}, {1, 1}], InsetBox[
           StyleBox["\<\"nlogn\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->20], {1.21, 4.0600000000000005`}, {-1, 0}, Automatic, {
           1, 0}]}, {InsetBox[
           GraphicsBox[
            {RGBColor[0, 1, 0], Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 4.72}, {
           Left, Bottom}, {1, 1}], InsetBox[
           StyleBox["\<\"n\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->20], {1.21, 5.22}, {-1, 0}, Automatic, {1, 0}]}, {
          InsetBox[
           GraphicsBox[
            {RGBColor[1, 0, 0], Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 5.88}, {
           Left, Bottom}, {1, 1}], InsetBox[
           StyleBox["\<\"logn\"\>",
            StripOnInput->False,
            FontFamily->"Helvetica",
            FontSize->20], {1.21, 6.38}, {-1, 0}, Automatic, {1, 0}]}}, {}},
       AspectRatio->2.1309523809523805`,
       FormatType->TraditionalForm,
       PlotRange->{{-0.1, 3.26}, {-0.1, 7.059999999999999}}], {0.95, -0.3}, {
      Left, Bottom}, {0.37541899441340787`, 0.7999999999999999}]}}},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->800.,
  PlotRange->All]], "Output",
 CellChangeTimes->{3.427041823960061*^9}]
}, Open  ]]
},
WindowSize->{1218, 643},
WindowMargins->{{Automatic, 16}, {Automatic, 13}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 936, 20, 275, "Input"],
Cell[CellGroupData[{
Cell[1529, 45, 4002, 84, 379, "Input"],
Cell[5534, 131, 21097, 379, 550, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
