(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6440,        163]
NotebookOptionsPosition[      6069,        148]
NotebookOutlinePosition[      6489,        164]
CellTagsIndexPosition[      6446,        161]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "\n",
 "Mathematical Principles for Scientific Computing and Visualization  \n\
http://www.farinhansford.com/books/scv\nby Gerald Farin and Dianne Hansford\n\
",
 "\n\n",
 StyleBox["Demonstration of Subtractive Cancellation Error",
  FontSize->16,
  FontColor->RGBColor[1, 0.5, 0]],
 StyleBox["\n\n",
  FontSize->16,
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 StyleBox["Cancellation error is a by-product of floating point calculations. \
It is the result of having very few significant digits, and the number of \
significant digits might vary. ",
  FontColor->GrayLevel[0]],
 "\n\nLet's look at the function f(x) = (1-cos(x))/x^2\nNotice that \
evaluation around x=0 might be tricky because x is a divisor. Near x=0, 1 and \
cosx are nearly equal. Taking a difference of two nearly equal quantities \
results in fewer significant digits than we had with the original quantities. \
In fact, the number of significant digits will vary for different x-values \
close to the origin. This results in the oscillations in the plots below.\n\n\
In the first plot below, we let x vary between -10 and 10.\nIn the second \
plot, we let x vary between -1E-05 to 1E05.\nIn the third plot, we let the \
range of x vary near x=0.\n\n",
 StyleBox["Try varying the ranges in the Manipulation plot.",
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 "\n\nNotice that sometimes (1-cosx) is evaluated to be a negative number!\n\
cosx is approximated in a computer too -- so there is truncation error \
already present in its representation.\n\nWhat you can't see won't hurt you?!\
\n\nFor more information, see Chapter 2 in Scientific Computing and \
Visualization by G. Farin and D. Hansford, AKPeters 2008."
}], "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4129499812931747`*^9, 3.4129500136002574`*^9}, {
   3.4129500503952694`*^9, 3.412950116992939*^9}, {3.412950211975204*^9, 
   3.4129502851980124`*^9}, {3.4129507782449417`*^9, 3.412950802355379*^9}, 
   3.4131158403247423`*^9, {3.4131182598738832`*^9, 3.4131182653417454`*^9}, {
   3.413118332678571*^9, 3.41311833461135*^9}, {3.413118422507739*^9, 
   3.4131184749130945`*^9}, {3.413118552134133*^9, 3.4131185731143007`*^9}, {
   3.413118673668891*^9, 3.4131187992194242`*^9}, {3.413118837624648*^9, 
   3.413118909748357*^9}, {3.413118994610382*^9, 3.4131190490486608`*^9}, {
   3.413119813427784*^9, 3.413119817193198*^9}, {3.4131199117992353`*^9, 
   3.4131199424332848`*^9}, {3.413120293538149*^9, 3.413120316180707*^9}, {
   3.413120346494296*^9, 3.4131203493484*^9}, 3.4270421919592175`*^9},
 Magnification->1.5],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "/", 
         RowBox[{"x", "^", "2"}]}], ",", " ", "300"}], "]"}]}], ";"}],
    FontFamily->"Courier New"], 
   StyleBox["\[IndentingNewLine]",
    FontFamily->"Courier New"], 
   StyleBox["\[IndentingNewLine]",
    FontFamily->"Courier New"], 
   StyleBox[
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", "400"}], ",", " ", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}],
    FontFamily->"Courier New"], 
   StyleBox["\[IndentingNewLine]",
    FontFamily->"Courier New"], 
   StyleBox[
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", 
        RowBox[{
         RowBox[{"-", "1.0"}], "*", 
         RowBox[{"10", "^", 
          RowBox[{"-", "5"}]}]}], ",", " ", 
        RowBox[{"1.0", "*", 
         RowBox[{"10", "^", 
          RowBox[{"-", "5"}]}]}]}], "}"}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}],
    FontFamily->"Courier New"], 
   StyleBox["\[IndentingNewLine]",
    FontFamily->"Courier New"], 
   StyleBox[
    RowBox[{"Manipulate", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", " ", 
          RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", " ", 
        RowBox[{"ImageSize", "\[Rule]", "400"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"range", ",", "0.05"}], "}"}], ",", "  ", 
        RowBox[{"1.0", "*", 
         RowBox[{"10", "^", 
          RowBox[{"-", "5"}]}]}], ",", "0.05", ",", " ", 
        RowBox[{"1.0", "*", 
         RowBox[{"10", "^", 
          RowBox[{"-", "4"}]}]}]}], " ", "}"}]}], "]"}],
    FontFamily->"Courier New"], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4125270177429075`*^9, 3.4125271537484736`*^9}, {
  3.4125271919534097`*^9, 3.412527196089357*^9}, {3.412527242456029*^9, 
  3.412527302071752*^9}, {3.412950309879407*^9, 3.412950490732731*^9}, {
  3.4129505536182013`*^9, 3.4129505762161026`*^9}, {3.4129506235855494`*^9, 
  3.4129506570015945`*^9}, {3.412950733289543*^9, 3.41295073508255*^9}, {
  3.4129507651229334`*^9, 3.4129507681379905`*^9}, {3.4129521804064236`*^9, 
  3.412952183922075*^9}, {3.4131157851153555`*^9, 3.4131157901125407`*^9}, {
  3.41313904661108*^9, 3.413139078777333*^9}},
 FontFamily->"Comic Sans MS",
 Magnification->1.5]
},
WindowSize->{960, 730},
WindowMargins->{{Automatic, 202}, {Automatic, 63}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 2577, 45, 809, "Input"],
Cell[3148, 68, 2917, 78, 287, "Input"]
}
]
*)

(* End of internal cache information *)
