(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24602,        638]
NotebookOptionsPosition[     23828,        613]
NotebookOutlinePosition[     24245,        629]
CellTagsIndexPosition[     24202,        626]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the convex hull, Voronoi diagram, and Delaunay \
tessellation of a point set.

Figures 13.12 and 13.13 were created with this notebook.

See Chapter 13: Facets for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4202890472489843`*^9, 3.4202890558813972`*^9}, 
   3.420289087566959*^9, {3.42028913195078*^9, 3.4202891748925266`*^9}, {
   3.420291756234314*^9, 3.4202917613316436`*^9}, {3.426884567521262*^9, 
   3.4268845780564113`*^9}, {3.42688517518504*^9, 3.4268851797516065`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", " ", "Execute"}]}]}]}], " ", "this", " ", "cell", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"first", " ", "--"}], "--"}], "--"}]}], "-"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "All", " ", "subsequent", " ", "cells", " ", "below", " ", "must", " ", 
    "be", " ", "executed", " ", "in", " ", "the", " ", "order", " ", "they", 
    " ", "appear"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "the", " ", "necessary", " ", 
    RowBox[{"packages", " ", "--"}], " ", "This", " ", "was", " ", 
    "necessary", " ", "in", " ", "version", " ", "5.2"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"<<", "\"\<ComputationalGeometry`\>\""}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Here", " ", "are", " ", "some", " ", "drawing", " ", "primitive", " ", 
     "settings"}], " ", "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Set", " ", "radius", " ", "for", " ", "drawing", " ", "data", " ", 
     "points"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"radius", "=", "0.15"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"triwidth", "=", " ", "0.005"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tesswidth", " ", "=", " ", "0.008"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.420289451780672*^9, 3.4202895317156134`*^9}, {
  3.420289737110957*^9, 3.4202897398448887`*^9}, {3.4202898800965605`*^9, 
  3.420289887617375*^9}, {3.4202900159218674`*^9, 3.4202900449836564`*^9}, {
  3.420291869757552*^9, 3.420291873853442*^9}, {3.420291936513543*^9, 
  3.4202919605681314`*^9}, {3.4202929823373632`*^9, 3.4202929961672497`*^9}, {
  3.4202940377449656`*^9, 3.4202940434131155`*^9}, {3.420294816865285*^9, 
  3.42029482880245*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Create", " ", "a", " ", "data", " ", "set", " ", "of", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Print", "[", "\"\<Input data points:\>\"", "]"}], "\n", 
   RowBox[{"points", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4.4", ",", "14"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6.7", ",", "15.25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6.9`", ",", "12.8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.1`", ",", "11.1`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9.5`", ",", "14.9`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13.2`", ",", "11.9`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10.3`", ",", "12.3`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6.8`", ",", "9.5`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3.3`", ",", "7.7`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6`", ",", "5.1`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5.3`", ",", "2.4`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8.45`", ",", "4.7`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11.5`", ",", "9.6`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"13.8`", ",", "7.3`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12.9`", ",", "3.1`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "1.1`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"11", ",", "11"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Find", " ", "number", " ", "of", " ", "points", " ", "in", " ", "list"}],
     " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"pointnum", "=", 
     RowBox[{"Length", "[", "points", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Number of input data points = \>\"", ",", "pointnum"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Load", " ", "the", " ", "point", " ", "set", " ", "into", " ", "a", " ", 
     "table", " ", "of", " ", "disks", " ", "for", " ", "drawing"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "disk", " ", "radius", " ", "can", " ", "be", " ", "set", 
     " ", "in", " ", "the", " ", "previous", " ", "cell"}], " ", "*)"}], "\n",
    
   RowBox[{
    RowBox[{"graphpts", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{
          "points", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          ",", "radius"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "pointnum"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "data", " ", "points"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pointplot", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"graphpts", ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "point", " ", "set", " ", "to", " ", "postscript", " ", 
     "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<points.eps\>\"", ",", "pointplot"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.420289178527754*^9, 3.420289249710109*^9}, {
   3.420289298880813*^9, 3.4202893961807237`*^9}, 3.4202895167240562`*^9, {
   3.420289565664429*^9, 3.4202895834500036`*^9}, {3.4202896760731893`*^9, 
   3.4202896966027093`*^9}, {3.4202899118922806`*^9, 3.420289912032482*^9}, {
   3.4202899498969283`*^9, 3.420289952761047*^9}, {3.420290037963562*^9, 
   3.4202900724130983`*^9}, {3.4202901189199715`*^9, 3.4202901224049826`*^9}, 
   3.4202911820086184`*^9, 3.420291217169176*^9, {3.4268847511953726`*^9, 
   3.4268848852281027`*^9}}],

Cell["\<\

Play with the convex hull of the point set.

Imagine pegs are sticking out of the points above. If we put a rubber band \
around the outside of the pegs, then the polygon formed by the band forms the \
convex hull.\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4202919884782643`*^9, 3.420292095642359*^9}, {
  3.4268849287807283`*^9, 3.4268849299724417`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "ComputationalGeometry`"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Define", " ", "the", " ", "convex", " ", "hull", " ", "of", " ", "the", 
    " ", "point", " ", "set"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", "\"\<The points on the convex hull include \>\"", 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"convexhull", "=", 
   RowBox[{"ConvexHull", "[", "points", "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "number", " ", "of", " ", "points", " ", "on", " ", "convex", 
    " ", "hull"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"numch", "=", 
    RowBox[{"Length", "[", "convexhull", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Number of points on the convex hull = \>\"", ",", "numch"}], 
   "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Notice", " ", "--"}], " ", "to", " ", "access", " ", "a", " ", 
     "list", " ", "element"}], ",", " ", 
    RowBox[{"double", " ", "brackets", " ", "are", " ", "needed"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"chpolygon", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"points", "\[LeftDoubleBracket]", 
        RowBox[{
         RowBox[{"convexhull", "[", 
          RowBox[{"[", "k", "]"}], "]"}], ",", "1"}], 
        "\[RightDoubleBracket]"}], ",", " ", 
       RowBox[{"points", "\[LeftDoubleBracket]", 
        RowBox[{
         RowBox[{"convexhull", "[", 
          RowBox[{"[", "k", "]"}], "]"}], ",", "2"}], 
        "\[RightDoubleBracket]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "numch"}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Draw", " ", "the", " ", "convex", " ", "hull"}], " ", 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Yellow", ",", " ", 
       RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
       RowBox[{"Polygon", "[", "chpolygon", "]"}]}], "}"}], ",", " ", 
     "graphpts"}], "}"}], "]"}], " "}]}], "Input",
 CellChangeTimes->{{3.420290146119082*^9, 3.4202901559031506`*^9}, {
   3.4202902065159283`*^9, 3.4202902182127476`*^9}, 3.4202902578397284`*^9, {
   3.420290291387968*^9, 3.420290312608482*^9}, {3.4202904546026597`*^9, 
   3.42029051844446*^9}, {3.420291020225986*^9, 3.4202910316323876`*^9}, {
   3.420291101773245*^9, 3.4202911275703397`*^9}, {3.4202912363567667`*^9, 
   3.4202912581781445`*^9}, {3.42029136090586*^9, 3.4202914137618628`*^9}, {
   3.4202914959700727`*^9, 3.4202915232392836`*^9}, {3.420291622872549*^9, 
   3.4202917016458197`*^9}, {3.420291821127626*^9, 3.4202918256240916`*^9}, {
   3.42688466160655*^9, 3.4268847088745184`*^9}, {3.4268850632540913`*^9, 
   3.4268850638349266`*^9}}],

Cell["\<\

Delaunay Triangulation\
\>", "Input",
 CellChangeTimes->{{3.4202921023419924`*^9, 3.4202921324853363`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "There", " ", "are", " ", "several", " ", "ways", " ", "to", " ", 
    "generate", " ", "the", " ", "triangulation", " ", "and", " ", 
    "tessellation"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Additional", " ", "ones", " ", "are", " ", "commented", " ", "out", " ", 
    RowBox[{"below", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Load", " ", "the", " ", "Voronoi", " ", "diagram", " ", "vertices", " ", 
    "into", " ", "vorvert", " ", "and", " ", "the", " ", "vertex", " ", 
    "adjacency", " ", "list", " ", "into", " ", "vorval"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vorvert", ",", "vorval"}], "}"}], "=", 
     RowBox[{"VoronoiDiagram", "[", "points", "]"}]}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Load", " ", "the", " ", "Delaunay", " ", "triangulation", " ", "into", 
    " ", "delval"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"VoronoiDiagram", "[", 
     RowBox[{"points", ",", "delval"}], "]"}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Create", " ", "the", " ", "Delaunay", " ", "triangulation", " ", "of", 
    " ", "points"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "you", " ", "want", " ", "to", " ", "see", " ", "the", " ", 
     "point", " ", "labels", " ", 
     RowBox[{"(", "numbers", ")"}]}], ",", " ", 
    RowBox[{"set", " ", "flag", " ", "to", " ", "ture"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Delaunay", "=", 
     RowBox[{"PlanarGraphPlot", "[", 
      RowBox[{"points", ",", " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "30"}], "}"}]}], ",", " ", 
       RowBox[{"LabelPoints", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"picdel", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"Delaunay", ",", "pointplot"}], "}"}], "]"}]}], "\n", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<Delaunay.eps\>\"", ",", "picdel"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.42029197294593*^9, 3.4202919812178245`*^9}, {
   3.420292294858818*^9, 3.420292324681701*^9}, {3.420292502607546*^9, 
   3.4202925282043524`*^9}, 3.420292582552501*^9, {3.420292638052306*^9, 
   3.4202926511611557`*^9}, {3.4202927385768533`*^9, 3.420292746287941*^9}, {
   3.4202928142757025`*^9, 3.4202928714979844`*^9}, {3.4202929170835333`*^9, 
   3.4202929632298884`*^9}, {3.4202930333707457`*^9, 
   3.4202930405410566`*^9}, {3.4202931665121937`*^9, 3.420293186621109*^9}, {
   3.4202932239648066`*^9, 3.4202932285614166`*^9}, {3.420293295928285*^9, 
   3.420293356204959*^9}, {3.420293412956564*^9, 3.420293418254181*^9}, {
   3.4202934811345987`*^9, 3.420293523004805*^9}, 3.420293568610383*^9, {
   3.4202936615540295`*^9, 3.4202936966044292`*^9}, {3.420293750552002*^9, 
   3.4202938248187923`*^9}}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.4202934912190995`*^9}],

Cell["\<\

Voronoi Diagram\
\>", "Input",
 CellChangeTimes->{{3.4202930763124933`*^9, 3.4202930891409397`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<FontSize\>\"", "\[Rule]", "1"}], "}"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"voronoi", "=", 
     RowBox[{"DiagramPlot", "[", 
      RowBox[{"points", ",", " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "10"}], "}"}]}], ",", " ", 
       RowBox[{"LabelPoints", "\[Rule]", "False"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"picvor", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"voronoi", ",", "pointplot"}], "}"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<voronoi.eps\>\"", ",", "picvor"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.4202930949492917`*^9, 3.420293142357461*^9}, {
  3.420293252355631*^9, 3.4202932816177073`*^9}, {3.420293718926527*^9, 
  3.420293729541791*^9}}],

Cell["\<\

Let's try a larger data set -- created using the random number generator

Question: What if two points are identical? What will Mathematica do? Give \
this a try.
\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.420294057092786*^9, 3.420294072194501*^9}, {
  3.420294202021183*^9, 3.4202942442218647`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pts2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"numpts2", "=", 
     RowBox[{"Length", "[", "pts2", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Print", " ", "out", " ", "the", " ", "point", " ", "set"}], " ", 
    "*)"}], "\n", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<Point set with \>\"", ",", "numpts2", ",", "\"\< pts2\>\""}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Point \>\"", ",", "i", ",", "\"\< \>\"", ",", 
         RowBox[{"pts2", "\[LeftDoubleBracket]", 
          RowBox[{"i", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
         "\"\< \>\"", ",", 
         RowBox[{"pts2", "\[LeftDoubleBracket]", 
          RowBox[{"i", ",", "2"}], "\[RightDoubleBracket]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpts2"}], "}"}]}], "]"}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "points", " ", "as", " ", "disks"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"diskpts2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{
          "pts2", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], ",",
           "0.01"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpts2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "disk", " ", "points"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpts2", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"diskpts2", ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "the", " ", "convex", " ", "hull", " ", "of", " ", "the", 
     " ", "point", " ", "set"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"convexhull2", "=", 
     RowBox[{"ConvexHull", "[", "pts2", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Find", " ", "number", " ", "of", " ", "points", " ", "on", " ", "convex",
      " ", "hull"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numch2", "=", 
     RowBox[{"Length", "[", "convexhull2", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Notice", " ", "--"}], " ", "to", " ", "access", " ", "a", " ", 
      "list", " ", "element"}], ",", " ", 
     RowBox[{"double", " ", "brackets", " ", "are", " ", "needed"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"chpolygon2", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"pts2", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"convexhull2", "[", 
           RowBox[{"[", "k", "]"}], "]"}], ",", "1"}], 
         "\[RightDoubleBracket]"}], ",", " ", 
        RowBox[{"pts2", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"convexhull2", "[", 
           RowBox[{"[", "k", "]"}], "]"}], ",", "2"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "numch2"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Draw", " ", "the", " ", "convex", " ", "hull"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Yellow", ",", " ", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Polygon", "[", "chpolygon2", "]"}]}], "}"}], ",", " ", 
      "diskpts2"}], "}"}], "]"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Delaunay", " ", "triangulation"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Delaunay", "=", 
     RowBox[{"PlanarGraphPlot", "[", 
      RowBox[{"pts2", ",", " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "30"}], "}"}]}], ",", " ", 
       RowBox[{"LabelPoints", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"picdel2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"Delaunay", ",", "plotpts2"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Voronoi", " ", "Diagram"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"PlotRange", " ", "Automatic", " ", "clips", " ", "outliers"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"voronoi2", "=", 
     RowBox[{"DiagramPlot", "[", 
      RowBox[{"pts2", ",", " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "10"}], "}"}]}], ",", " ", 
       RowBox[{"LabelPoints", "\[Rule]", "False"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{"picvor2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"voronoi2", ",", "plotpts2"}], "}"}], ",", " ", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4202940753390226`*^9, 3.420294198856632*^9}, {
   3.4202942533650117`*^9, 3.420294400306303*^9}, {3.420294434455407*^9, 
   3.420294484507378*^9}, {3.4202945558900213`*^9, 3.4202945691591015`*^9}, 
   3.420294613142346*^9, {3.4202946519080887`*^9, 3.4202946853561845`*^9}, {
   3.4202947780094132`*^9, 3.4202947791410403`*^9}, {3.4202948511746197`*^9, 
   3.4202948752792807`*^9}, {3.4202949251309633`*^9, 3.420294926012231*^9}, {
   3.4202949627851076`*^9, 3.4202949677422357`*^9}, {3.4202950838792324`*^9, 
   3.4202951409112406`*^9}, {3.420295172306384*^9, 3.420295286290285*^9}, 
   3.4202953323364964`*^9, {3.420295367607213*^9, 3.4202953968692904`*^9}, {
   3.4202954344132757`*^9, 3.42029548073989*^9}, 3.42029554833709*^9, {
   3.4202956413408227`*^9, 3.420295701517352*^9}}]
},
WindowSize->{810, 888},
WindowMargins->{{2, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 707, 19, 267, "Input"],
Cell[1278, 42, 2805, 66, 489, "Input"],
Cell[4086, 110, 4373, 112, 599, "Input"],
Cell[8462, 224, 386, 10, 140, "Input"],
Cell[8851, 236, 3136, 75, 445, "Input"],
Cell[11990, 313, 143, 5, 67, "Input"],
Cell[12136, 320, 3307, 73, 467, "Input"],
Cell[15446, 395, 89, 1, 71, "Input"],
Cell[15538, 398, 136, 5, 67, "Input"],
Cell[15677, 405, 992, 26, 159, "Input"],
Cell[16672, 433, 331, 10, 140, "Input"],
Cell[17006, 445, 6818, 166, 1061, "Input"]
}
]
*)

(* End of internal cache information *)
