(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23917,        479]
NotebookOptionsPosition[     23391,        459]
NotebookOutlinePosition[     23810,        475]
CellTagsIndexPosition[     23767,        472]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "\nMathematical Principles for Scientific Computing and Visualization  \n\
http://www.farinhansford.com/books/scv\nby Gerald Farin and Dianne Hansford\n\
\n\n\n",
 StyleBox["Demonstrate the derivative as the slope of the tangent to the \
function",
  FontColor->RGBColor[1, 0.5, 0]],
 "\n\n",
 StyleBox["Step 1:",
  FontColor->RGBColor[0, 1, 0]],
 " View the plot of f alone. (The range of x-values was selected to help with \
the visualization in the next step.)\n\n",
 StyleBox["Step 2:",
  FontColor->RGBColor[0, 1, 0]],
 " Add the linear functions t1, t2, t3 to the plot.\n\nIn the successive \
tangent lines below, we use a smaller h, thus coming closer the true tangent. \
Try decreasing h in t3.\n\n",
 StyleBox["Step 3:",
  FontColor->RGBColor[0, 1, 0]],
 " Plot the true tangent at x=2.\n\nDefine fderiv -- the derivative (slope) \
of f \nDefine ftangent as the tangent line at x=2. It is defined by the \
function at x=2 and the derivative at x=2\n\n"
}], "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4153687367785344`*^9, 3.4153688641116304`*^9}, {
   3.415368901775789*^9, 3.4153689603600287`*^9}, {3.4153690048640223`*^9, 
   3.415369030631074*^9}, {3.4153692732098846`*^9, 3.415369325565168*^9}, {
   3.4153695554056625`*^9, 3.4153697215245295`*^9}, {3.4154803827324514`*^9, 
   3.415480383523589*^9}, 3.427042338349717*^9},
 Magnification->1.5],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
    RowBox[{"x", "^", "4"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t1", "[", "x_", "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{"f", "[", "2", "]"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", "3", "]"}], "-", 
          RowBox[{"f", "[", "2", "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"3", "-", "2"}], ")"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", " ", "-", " ", "2"}], ")"}]}]}]}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"t2", "[", "x_", "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{"f", "[", "2", "]"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", "2.5", "]"}], "-", 
          RowBox[{"f", "[", "2", "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2.5", "-", "2"}], ")"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", " ", "-", " ", "2"}], ")"}]}]}]}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"t3", "[", "x_", "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{"f", "[", "2", "]"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"f", "[", "2.01", "]"}], "-", 
          RowBox[{"f", "[", "2", "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2.01", "-", "2"}], ")"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", " ", "-", " ", "2"}], ")"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fderiv", "[", "x_", "]"}], " ", ":=", " ", 
    RowBox[{"4", 
     RowBox[{"x", "^", "3"}]}]}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"tangent", " ", "line", " ", "at", " ", "x"}], "=", "2"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ftangent", "[", "x_", "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{"f", "[", "2", "]"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"fderiv", "[", "2", "]"}], 
      RowBox[{"(", 
       RowBox[{"x", " ", "-", " ", "2"}], ")"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"t1", "[", "x", "]"}], ",", " ", 
       RowBox[{"t2", "[", "x", "]"}], ",", " ", 
       RowBox[{"t3", "[", "x", "]"}], ",", " ", 
       RowBox[{"ftangent", "[", "x", "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "3.5"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4153682279468703`*^9, 3.415368523862376*^9}, {
  3.4153685805238514`*^9, 3.4153687203048463`*^9}, {3.41536896584792*^9, 
  3.4153689819110174`*^9}, {3.415369050509658*^9, 3.415369076246666*^9}, {
  3.4153692594200563`*^9, 3.4153692671511726`*^9}, {3.4153693393850403`*^9, 
  3.415369341808525*^9}, {3.41536938169588*^9, 3.4153695379906206`*^9}, {
  3.415369709286933*^9, 3.415369711680374*^9}, {3.415382411234707*^9, 
  3.415382423892909*^9}, {3.415382473434146*^9, 3.415382486142419*^9}, {
  3.415382560809786*^9, 3.4153825633234*^9}, {3.415382622398346*^9, 
  3.415382624361168*^9}, {3.4153827320159683`*^9, 3.4153827583638544`*^9}},
 Magnification->1.5],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns01HkYBvDfuMwM06Ia2lVWc3bKuA2SS7P4vuVSImpaS6TMREq5rJDY
ktBJQ6xqOMhQ0lG0GZUxGyWXUIqyrpWd2hyOrX4ZQ8llv/3xnud8nvP+8bCE
0fwwNYIgfPB9y7Tvpd8RBIn4wnb7b2mYPq7NVifRgIw1cn4JiaQfV9O3UElk
0swiuT+Q6J+2HLVc3FOq6vyT15HIJT5yxhj3aR1t5yLDSPS5h6NAuJcN3TKT
PyHRYZHkdkooiR5ViivpZZ+Q30JW0GI7iRge2SyWQIm+Fsq6Ri9/QkWv7aZL
S2bQexPe+eCoSRTm59l1ymIO3XQKK+6zU6KWrGjpsIQAV7qiw0FnCpkjxcbW
++rAbpFu5QxMIZo8+EAQgwaD9n9/JGpVyP30QPB2PQYE25QNDGdOI+102SPK
SV2wXNXM9ODPIFEIvWy5zjLoabCLLzD/jFIuNwfc6WVCk+8CJ2n6M+JRkZF7
7Qo4eTBm9Z6GL4hbnGpX0GkIy3m2TmYXZ1GM6PFdTtKPMDnrdSNjz1dEpAhO
1Biz4GrsHZcOxznERulX5oJ+ApPYdn1d3XkkGdfaUPhwDagENvBv3zx6LLbw
lNlwIJ8+ca7szwVk4Mz/ukbXHDIks9Yfji2iiADd0MYpSyhPqE7+w4wAr+M9
FpNV1hApkBKWYgKGoiXj2UnrYLeb0Cp3lgDWLWY7det6uHOKFxMeTgHC2r2a
vd8e1tc3BFK7KJCo2R+SkOYIhbX64RXWahA1mKU6IedBhJY4Q16sBhc5/Sxb
b2cI8W/aJqaow17l/iHpMIIHhD5nNEodEu9GX+w/sBHoUc5shyF1yLCPK6JN
b4KEF3qdvi4aUFlvEP8mxQ18Liw59fK6BgxyHLXF7h7gva32rbWeJgTaiiaW
07aATSc3/PQRTfBoPZqoPugJJy8/n/Md0YQbbVRLKukFqliWk8KVCmNllflD
i9ugt6Qge/QWFfLys4wQdzsMPpSfqTWggb42X8M/YAe0Xa+5mppEg2cNVw5/
EPHB6EN3b/MoDcp5LW8DJ3ZCoWlRdZcXHWx3XHMpdvOD1AfZBV71dHjVO42c
nv4Kviv9rnaytWBgNHorMywAXKMeBS3N1IK6ZwfZkcpdULZKyH6i0oKKFGfH
PFkQrG2+JvYJ0oZu7oZsq7hgyLN8aPa8URvWCPQvTfH2wgGlRk+HGQMiEr44
V0hCILRmcnVmDgOMLVo2VhQJoLOTnnZvjgELxrE3N9ULIcpVkduBPS6NuBSG
vexefUkfdpXJhawz2LuqI+QkdnTdsUNPscdynnxizzNAFZdjHigXAs0vNyQb
uz/n3e3f/hKC28gKlz0LDDBNd/6vtAH/+5Neh7CPX+crmrGzutt3JWIHywr6
RrFfNB2Lz8M+IqprsmgUgrB8uKoNm8aEQhl26kHJSqtFvKfv91+67wuB/eao
qRP2KlGptxK7PXC7gye20lTlZvBACHrelJ37sM+a2Njvxi7l7jubj73DZMpw
DNvt2s8F5djvbSVMRhPeZ8ysqMHebZGsw8W2Wtra9Bg7VNGqFof9PPPSswHs
wJL182LsBLWEV++whzf3ztRjGyb7TExiL3tdPvkSu1G59ssiNldQ8X4R+38V
JDzc
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzn8803kcB/Cv+TVNReXkR6Gb/MpQQmHfdykttImcZqMiCVk91qOVPLqG
6k6XtnTJSRyHTlp+tTsq+krnNqVIyY9KK1k/NfN7xe5zf7wer8fz8Xj98bKL
3R8WT8IwjInyf2curp2LYSrci04b1B5nEJYn3s+h6qrwa5VP5YWpDKL2iy2Z
YaDCl1ocq/I/yCBetYpIYmMVTh67fzRtD4OgH0qZtLFQ4X0ViaaTIQxiqtNR
ga9U4UKzMvqwBYPY90vRjeO7VXj7J6vfntdtIiJmz3C0MhUed8mI2aAMJL7m
17cPlYzgK/XtaFauG4nPDmvPR/PUuPLlyKdOUQBx3S++oHv1KH6HG7agVLOO
CCAr5N7zxnAf5bBkaQAQ1Hu1QY49YzitJSv0+VZ/otfr6ResbhyndUo8HvSs
IaI9inv6syZwgcPIgHq/F+Fq3bIoMGwSPx19Jbhl3Sqis3H1oTyXKbyJXblJ
ftmNaGbNOh6dmMKx+s/8Ha5OhDDxgG1M4zTeUc7ziXuxjFi4dpWf8wUNHiK+
IzElLybUmuDKkzFfcUZpH2EoNCDK+FK63Ocb3uFN7fHoHsQd+DKz+fNncA19
2k7qaQLjuzxgsHsGf3h42cKZN9ZwkfzxbHHVLH6/bHUFFm4PJ4s07sOpWnxx
6NiWqiYXKBVI0s45YzAWpzB+yfaAlF21mGsuBrmRFWWu9zyBuyHWTazBYF/y
rLBr1BukGWsPJCTowGx8/37Hvb7g2dAYZdCuA63CjcVdxXTIrzNLKHcnQYmT
jFT6FiDJKPfkzQIS0E/VNEkL1sPOyOYtuTq6MMFXXOJ7bQACM3Mc4umCcfhT
0k/qjUDm+VO9+3QBE63RFZZvAkGXSRuLrgfzOYNUqv9mYP5qnPH8qh4cswzv
sJkIgpAtdW/cTfRBP4l8ufVcCHi00RJOHdSHBDOabpg9E4Qlj7+xBvTB8Yb5
qGc/C8b5dn6KAAPIGPk+Q9EQCk8K87KHqg2gkFTI2nZxK/Tevflz3XeGIOfc
kljvCYPWqzVl6UcN4fVr8fZn7uGwZLjjScuQIVTGMWSNxtsg3+mSpD2YDOkr
/pBN926DdCI7L7iBDAZfBrJ31UcAyyqirI1qBEcGnhTdyvkBAnj/ckyzjGDK
PGV9ckwkFFvHUh+MG4FDkLIi0Hc7LG+5ksvkzIH4e3olh43YkON61/lx0xw4
t69vKL+LDXtH9TrlzhRInpejen89CnbXqG2zRBQIn/p0+mwaB9rayJm3v1Hg
Q7/Thxg2F3gBCrEceVK8mZeKvOB2Q2E3sn5govo8MluSdFOFvKT6T40M+Z3o
wQh1hgKsEw6UVVFcMIwQ78xG/muF/QpDDhc2DJjTY2YpkHHMllfFRftIVXAy
smglqOXIZzpk7CPIBcodgkHkrubUQznI0q1FP1pEcyG2tP9aK7LSfqkoEzk9
scjKTUsB5kOr6sgYLlBfH3byQ2Zn+nrykWVRod6bkff4cOrPIJuE6ITHIQtL
8olm5N9pcacvIksFFp0uO9C/K755pch3XdZEBCK/s1lUXoP86NX23p3Ibqb/
NN9HVgblKS4gP866/KgHeVT7d3w1soAkePEWGZM+e9+GbJnG/KhGnps0mfIW
uWl0+bQW2dLGXK1F/g/y30V1
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyns01HkcxvFxHyT3UhTVlGlyGSRWY76fXTaXwWQym8uyGVolJllj6bJR
aiN2pE1WSm5lrS5IyZb9SWUom1FpUFnSHFuHfsgkl5n97h/PeZ/XOc8qwV7e
TnUKhRKE93+PWtQbUCgk+uZMlkxlzSaWZ/2rR9MgkYM0x2JyCZuo/2BD9dUm
EcXgVOiIAZv456FYPX8Ria5mnZdJ5jwJtijxk/UyEmmm3JSdeuFJzEjpQ8iZ
RDd4o7I1Yk8i4WTpjcOxJDIxCujzUbIIvjI3QiUh0d85pv3il5uJueKmLnn5
BHKXTpQLdn1BjNl6nI4UTiJ5aIFn7wo34iprZ0mv6xQysaUFP3q9kfCiDnW4
Lf6IHLZo2WnsdSZo9+v96bKPKP9StWyAziT6Nj3/QGmYRvevbfptPGYDEelU
JhvIVqDYUmUyPW8dYW/VZraF9wnlGnPICt3VhPSuq6howwyy4yTM+PktJ1q5
Svp+xQwKTeNsf7LWmMjYnWQTdfczGv1p0KVxB4Uw9XBhMc7MIiL8vYDMkKHJ
Wc4fx6LmUALnRMs7Fy2oSm5kd7jPI2Ww1bluoRnYJkvMDQ0XEC/WcarKfCVM
RzvBSO8CkjRZqc/nrIGz1Pe/lF1TouMrNA6WJtDhWOksczxdhf5UxfLU5uyg
MvXKgVMMCujZmHUJp5mQGF1PsS+kQFO6ZtpAtAt86y1wzJ+lwOoC5+DLla7Q
eMQjKS5ODUrCjGOYFu6w8fbdcO0uNegetK+wEHhAcYN53CWmOmRZh8UfvsiC
eN3CY80l6uCz2DW+whDBju2tgYVqGvAm0jbgdA0AQTGny4UawMjNPdzw9kug
Cj1pbv0a4LI0XWFi6QWpT406uWxNKM7M0izf7A1Bvy468rJGE7K9Rq+KU76G
gMCGN0wjLXg+Ek/WFm0Bp06HuOM/aMHwcIpI95YPZJT3zHMHtUDk/qLw/pgv
TCevYg15acP3iaHca4b+8OxCUZ78ujYMfnaqnPHjQN+95hMNS3Tg5k5G/r69
AfCwpq4qc78OcB1q/lovDoQV493P2uQ6kBR05CS0B0Hx+nNXujhUGA9MHz/+
jguZRF4R5zYV9vNGFOantwLXkl/VSdOFyFquBdUhGLyE7RHG2bowLvLXKmgJ
hjIrAe3xtC5479kHnAgerGu7XBgUoQf+3bY+JWM8KLC/x+hp0YPrb8o+LDq0
DXZNaUo7GPrQt9pXXmsRArF1kzbZYn2okx6qHvk9BDo7qUfvzOtDYO1gE8eH
D0KvofwObOf6Z9lR2CZ3bl/oxV7S1BG+DzvsSnwzif2qrWG+EHtU/HiCtqAP
iQM/wzC2Dj9/Rx62WI8pSfPlg/fgUnaUUh+kuzJeVPnh/3aSswe7USiqbsLO
7ZaEpWEXp8SnP8J+2pouKsCOzgixnMAWVA7UPsSeOEv/juXPh8zdpZaOKn0w
be+W92DThn9cz8JWPH5w6y22JHyrmx92f0/ziRlsowC1bTHYFa8rGSs5fLjo
EJNzFttVkSbcje19eXNRJfay+UR0EHvU2uxSHfaCWoyRGNvR+EHrI+wHBoH1
N7B7ss8/kWFXm351tB07VT311Vvs3GVuIf3Yyw8EvZ/ETrK2WzuG3TK17rMK
m792lUKF/R8MCDyq
     "]]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwVyns0lHkcx/HHGGPMRGQk5KSadZlNHolphd+3qGTGkKU2ypEuNtWEZFfO
niVRwiZJc2w1q+PSKncV1uVxyWVyyXXZtlpjs91WExFjmP3tH5/zPq9zPmtD
T/sdpREEIcL7v4mrKnQJQoGq5TJGvitJmV54w+JqKpC8tW7Kl09SFR8smJ4M
BWIWlrxQkST1V9sVWsYyBQo8kfnQn0tSbmdPfV5jokCq6f3H6GySmuuzHkOb
FCie1Z/aXmZHnUyVVv14RIGyfPRYOyY2UgFLaUHqDgV6OJrMgD221EJOdffE
nY/odsZ6K8NxG+pfK+drB8VTaK+hFK0qtaRKXI7eHHacRj1LmSyH1PWUO3Os
k6/3Cb1O27TIW29BcVsrvKxHPqG73Yd6f31rQo06DX0gKmcQ1fZg+hHDkDpo
nzvyLGUWVa+bmZcnMSnb1S2cnX6fUUjP9O9bez439tU7npV8OYeIWxscrRO7
UJPPkvW52Tm06oanZYz5Ioo/HmERXD+PPHic0fccNhg6O7jwriuRSyOPGArg
wJRScC8peAFV9enm9d43hfyoB26dW1Qouleo0m6zAKuoDqPlyxeRyNs0OvML
Lswcsoe/hxfRPjXz01svK7jBfPdTbukSatATCo9V8SBJqiQnY9XI36/sfum4
LeTFFMdd5RFQEFs1lX6PhFOHKgjbbAKarw86fnVwExzwCLXLUBIwK9D64clH
B3hw3jkiLEwDRsgQ8vRdR9hcUx/I6NaA/tIn/8xv40NOpVFYAUmDcKXycezA
FgjXyU6qvUmD8jP++uyLzhCyr8k7W0MT9C82BCeauwBFGFlPiDXBvNPPRHfY
FZhiVy7/D03oHi5SpiYjiBnQl/m40cGrUUcxlwYgylp2/s8iOiTxBiRVYdtA
6F05TuprQZc8r2XcYTvYyzaGJZ/RAnn8SIKuajvE3+lX+bzUApHT2lk05A4z
UWtdxtwZ0LEl6v0rqQcM3pakT5QxQOI3IsmK2wGjzbWXKldqQ3TNzvaHnjuh
rag8P+GcNqxjGKcMGOwC88mngy0T2mAZriLm3+2CHJufi7sFTOCbvVVefeQJ
CVS6RFDDBOn4+yKHrN3gYxaQL+PqwPDVPZO9J73AXdweZJCiAybpDZUvnQSQ
uzqU2zWjA5VSsJszEIJlS2G2KIgFQWrZhgsvhJBp28zrb2BBv8ejelahN3w7
Te/r5LEhN7eanhMvgiPlUxYpV9gQJ2juvinwAZmMmVinYsPe5AjLQUNfELuP
ZXRiL2sSe49hr6iruT2M3bxwMnoSe39xeK0Ce0Pk8WYmxxdeX+n6yF1kA+1A
aLArtnZARkg6drG9f3YBtsdLY7fgJTbQn/MZsUb4v08hOIFdY+xkm4yd9rRj
//fYYr/N/tewB5piz2Zij7aTd4qxQ/Oe3W/DLqmwcZNjJxyXmtmp2RB4ySxG
sNIXuPLvbFyw9VpMbn2D3RHoy9+N3bpo3HoUW1+o8fVhbPIMZ0U89i8bD1++
gc0I1i2pwvYo3CrJw/5Nwh5qwn69hlNQjh05oKPqwbYzeNz0BPuZJ8PrDXZ/
yq3eEeyMRHrkLHYMLeb5K+wdDTSJprEvmMaJ3k1hL8wRjfrYDdOW82rsMgf1
K3Ps/wDxRTgu
     "]]}, 
   {Hue[0.6142719099991583, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns01HkYBvCfwRh0I11Qx7CzNWmnoWishu/ruhhMWzsVYhm1g7apo0hl
d0lEG43cJo2kg8pmC9mw0c8lGVGTsF1sUpGdbCaMEGa/+8d7nvM55znPeS2F
B7btpRAE4Y/v/0xaWbmQIFRoooAj12jYpNnJfwwY2iokHQ3oPjDOJitH6TQv
qgo5uMT39w+xyVetZymSBSqU8JZU3+1kk84x+z9ZmKoQbb2PVcIFNjn1mDmA
NqoQvWb3cYLDJn/8tfDWL3tUaGtXIktLvIEUzJ8J0rSp0HVqRyal7yvyc35N
59Dlj8gke7V8z+F15L9rHbOCxWPIN3RFVZrnGvJ37l5Zr/048lq4L6OE+QXp
RhuQcxZNoOH6TzddMixIRkulD/PpBHr1MrKs3tmUfLa5Z5SoUiMH7x2JUyJj
Mti26OmLtElkoxyJcRXqkaxVzSae2z6h0GMykdNt9d3H9fYx0vVTKGH4Zb5j
Rw9q5M8zj01OIfqU3MLj0TxKiDxID6mfRoSUqve6xxCWOm7iWufMIKni/MC3
10xgbIb3W3LIZyT56/tA1oQZlERXO8sdZlF2e88M4w0d1ka3LVu8eA7J2ix3
crkMUIfZwtveOdR96h6RGbQW8mjvM4puzKPdVte3pDRYQ3LhjM2Hoxpk8rOy
ueYdC4pjy49nWhMgeV79waPMBvaHVRKsXAJuJcspt3ZthN3uQrZkhoCDRmn1
oNwE1SccD4pEWtBtoCQLCuzBrrY+kNqpBYq3k1GmdhzIr1omKrWhQMTDHbLz
TQ4QpZ+bXCejwNUvdy1XRjtC6M5Gv1wtbUgI1uUEULlAEsuYQ2JtILS/uyT9
0wloYicG57k20GvUkr4IBLFPlrTznXVgpNQyuzAewD97wYm+Mh2QMU11agUu
4OtX9cZmiS5I83+4H0Z3Bdv2DaKUQ7ogzA5+uOCdKyRc7prl9+sC4VEyXdjg
BupoS+6AGxWUg65xTafcofuiNH3oJhWuOtmad4Z5wLOmutSq5XpQmRxjJGJ5
QmtZRUniMT04Iwjnaas9YfUHRXfzkB449hVdO9X5DeSvu1DeyaOB3fbNQRfy
vCCRTJfyamlASTS3zYv2Br65oKSdoQ8XN5f55Hj7gJv4fpBRmj6k9GXctjLm
QdEqIaNDrQ+uX7d4Sd/zYE3zlVz/IAPwTeGzCv7whXOsJuuuBgNgBJ0UFP/k
BxHjOo/l1oagGNK/nCXwhz0VY/S0s4bQJhx0MbbgQ3s7LenOrCFk5xhRj07z
Qew2IJFj96U0WWZhG9+pvdiLzYg75FSOHVAeVafCrgzsOTyAPXy24yNjDu9b
nH/jPcMHPYEkNB17URm90ewzH9z7VziHzBtCagM7/s4s7u9U8fZhK268yuvF
PqNoC4jDXlmUWaXCftJ4NOYcdmnSuJIxxwdh8YvrrdgtXrcD0rETIwvN2RpD
oDxx5oTM84Hx+sg6LrZXy+i2OOy2wK0cb2xJ9SXxOewlvlrbw7HpUkppK/al
DeGn87AhuNWErcH/XdkiLcZO9T9i4409bGFSWoGtQEzfcGy20b3GB9ghVqeT
8rC70goePcUuXrqlsAI7lhL79yD2iM5I3QNss+P+78ew7SZlvYPYDeNrpjXY
8e/8xjTY/wFQgEp/
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1, 3.5}, {-48.99999668367347, 150.06249125000016`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.4153689831127453`*^9, {3.4153690570390463`*^9, 3.415369076877573*^9}, {
   3.4153695062650013`*^9, 3.4153695384012113`*^9}, 3.4153697138935566`*^9, {
   3.415382414088811*^9, 3.4153824254952126`*^9}, 3.4153824869535856`*^9, 
   3.4153825643849263`*^9, 3.415382625272478*^9, {3.4153827455754657`*^9, 
   3.4153827598860435`*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.4154804764772496`*^9}]
},
WindowSize->{818, 700},
WindowMargins->{{30, Automatic}, {Automatic, 16}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1387, 29, 666, "Input"],
Cell[CellGroupData[{
Cell[1980, 54, 3429, 91, 379, "Input"],
Cell[5412, 147, 17871, 306, 250, 8993, 159, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]],
Cell[23298, 456, 89, 1, 71, "Input"]
}
]
*)

(* End of internal cache information *)
