(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19572,        470]
NotebookOptionsPosition[     18742,        441]
NotebookOutlinePosition[     19420,        465]
CellTagsIndexPosition[     19377,        462]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook demonstrates Euler's method for solving an initial value ODE \
problem.  
Problem: Find values of y over [0,2] for y' = y given initial value y(0) = 1.
The exact solution is e^x.

We compare the solution using 10 steps and 30 steps.
Compare solution with the solution using Huen's method in Huen.nb.

See Chapter 9: Computing Dynamic Processes for details.

Updated May 2008
\
\>", "Input",
 CellChangeTimes->{{3.4196163449282866`*^9, 3.41961648557052*^9}, {
  3.419616521291885*^9, 3.4196165475296125`*^9}, {3.4196167155812593`*^9, 
  3.419616787384507*^9}, {3.419616826420638*^9, 3.4196169765364943`*^9}, {
  3.4196185767675133`*^9, 3.4196186033457313`*^9}, {3.4196188419788685`*^9, 
  3.4196188796830845`*^9}, {3.4196189485721426`*^9, 3.419618998103365*^9}, {
  3.419619075895224*^9, 3.4196191444638205`*^9}, {3.4196192123314095`*^9, 
  3.4196192158064065`*^9}, {3.420289070442335*^9, 3.420289070943055*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Euler", "'"}], "s", " ", "method"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"euler", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xold", "=", "x0"}], ",", 
        RowBox[{"yold", "=", "y0"}], ",", 
        RowBox[{"sollist", "=", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",",
         "h"}], "}"}], ",", 
      RowBox[{
       RowBox[{"h", "=", 
        RowBox[{"N", "[", 
         FractionBox[
          RowBox[{"xn", "-", "x0"}], "steps"], "]"}]}], ";", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"xnew", "=", 
           RowBox[{"xold", "+", "h"}]}], ";", 
          RowBox[{"ynew", "=", 
           RowBox[{"yold", "+", 
            RowBox[{"h", " ", 
             RowBox[{"(", 
              RowBox[{"f", "/.", "\[InvisibleSpace]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"x", "\[Rule]", "xold"}], ",", 
                 RowBox[{"y", "\[Rule]", "yold"}]}], "}"}]}], ")"}]}]}]}], 
          ";", 
          RowBox[{"sollist", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"sollist", ",", 
             RowBox[{"{", 
              RowBox[{"xnew", ",", "ynew"}], "}"}]}], "]"}]}], ";", 
          RowBox[{"xold", "=", "xnew"}], ";", 
          RowBox[{"yold", "=", "ynew"}]}], ",", 
         RowBox[{"{", "steps", "}"}]}], "]"}], ";", 
       RowBox[{"Return", "[", "sollist", "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "the", " ", "plot", " ", "of", " ", "the", " ", "exact", 
     " ", "solution"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exactplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.03`", "]"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", "  ",
        
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Euler", "'"}], "s", " ", "method", " ", "with", " ", "10", " ", 
     "steps"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulsol10", "=", 
     RowBox[{"euler", "[", 
      RowBox[{"y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1.`"}], "}"}], ",", "10"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "the", " ", "plot", " ", "of", " ", "the", " ", "solution",
      " ", "with", " ", "10", " ", "steps"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulplot10", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"eulsol10", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.03`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
       
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Store", " ", "the", " ", "plot", " ", "the", " ", "exact", " ", 
     "solution", " ", "and", " ", 
     RowBox[{"Euler", "'"}], "s", " ", "with", " ", "10", " ", "steps"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plt10", " ", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"exactplot", ",", "eulplot10"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<euler10.eps\>\"", ",", "plt10"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Euler", "'"}], "s", " ", "method", " ", "with", " ", "30", " ", 
     "steps"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulsol", "=", 
     RowBox[{"euler", "[", 
      RowBox[{"y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1.`"}], "}"}], ",", "30"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Store", " ", "the", " ", "plot", " ", "of", " ", "the", " ", "solution", 
     " ", "with", " ", "30", " ", "steps"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eulplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"eulsol", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.03`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
       
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "the", " ", "exact", " ", "solution", " ", "and", " ", 
     RowBox[{"Euler", "'"}], "s", " ", "with", " ", "30", " ", "steps"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plt", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"exactplot", ",", "eulplot"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], " ", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<euler30.eps\>\"", ",", "plt"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.4196163408824687`*^9, {3.4196169821545725`*^9, 3.4196170562711473`*^9}, {
   3.4196170877764497`*^9, 3.4196171677814913`*^9}, {3.4196172000078306`*^9, 
   3.419617212836277*^9}, {3.419617373917901*^9, 3.4196173765617027`*^9}, {
   3.4196175556992893`*^9, 3.4196176113192673`*^9}, {3.4196176644656878`*^9, 
   3.419617719044168*^9}, {3.419617759031667*^9, 3.419617870742299*^9}, {
   3.419617955884728*^9, 3.4196179560149155`*^9}, {3.419619408293189*^9, 
   3.4196194243863297`*^9}, {3.419643903545632*^9, 3.419643920369824*^9}, {
   3.426095148487728*^9, 3.4260951906383376`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.7], Thickness[0.03], LineBox[CompressedData["
1:eJwVx38803kcwPFtkZ9hQ9p2X7VSGTqV6Ify/pQex6S6hTseJ0V+hFJ57HGV
O6HmHDN35yEphXCOpFV+dD3kVJbKRXWRfoyV3NJI37RNM/a9z/3xerweT17M
gR1xDBqNtg33/4PiRh7ffBfnt/+VxpJGI8HEn3NQyd4M9hGpKScYJHiVl5xt
ZIdCbAXlY2ZKwpbu/qvn2LFAJ3InbS1J+DZ2sq2QLYLutw5rljiQMOCZ4y9l
i6FFTrsT50pCheP2n/LYRaDa431shZCELPPGpbnsaij+5YbOWEVCeMR5Gfmx
CaT0YKHPzo9gRWVFBji3wwVJjSqJOQGLheMjHRI5dN/KKlp2fwIO96yFEs19
6IqJcLhb8gmcmpiDdPpDcEwJzz8do4GWIf8HD9f/A76Bax0yvtLC7aRz3Iix
XuhLqzmq9tSBdskG24b9/RCy6SmvljUJDH29HXfxC3C3uEd1sD6DD7W7JeSS
AiSSzuuDVnp4IF7V0+mmhOvkuehnFlMw/9dRfd34K6gW1Hl2uxpgdFI52Ld8
CAw/tF2WwTRUq1u7bAregKpGp6hMmwEb4o8Pw8PDcI3TfMytzQj5ic3xFS4q
GOh9/yJKR4EO1Q/vzXgLAt/8LU4XaUi0Ut40t2MEoiXJPG44HSkvySWPeWpw
yFj5PJTDQIak3lJ+2igIanbXB75mIPeNZsb41jGYaPpUU1Q5CwVU8hKuOI3D
wcuCOaofTdBhYtfC15Ef4KXza2eB0BR5jIVZ9W8lYZQvW/6cPxvZ25Lm8ikS
1qsbvcXOZsikvVS26OxHKNmaagi3NkfJq1qfW2yZALew9N/V8yxQvSCm4i/d
BFTe0hNT7pZIO8qxUxV/grPp1O2Fq61Qc0jArKLNGvCHjZx3sdYoIzC7vEml
AYbrSG9c3hzEGwh6VpWthcJ76qozzTZo3WpxEXulDrgJKVb9s+xQpPNDPf2J
DuoSEs9zau2Qtks6dDBrEnK8s4PKopmoxCRKtMPlM6gZN/YtmMtC9oPNlQz5
ZygLeu+4qoeFTNOzQtce0oNJ7rqqpWX2iFYXJRtiTcFwAcSG7XVAqWdkUtbt
KRD592VUBDuiNvefzZkpBvhynt+G733mImZQqsdxm2nQ3Ht2oJzthBTLHj05
emMarKvGzb0489DlMnAZjpqB3Paank57Ntop82ESxhnoK04+7sfioMzs81mK
C0bgb+Zcb1/BRQ0jRKlNMAVemq+VnoIvkJBps+buFAU7ZyeN3BQTKM+UwVVg
e+fwD73Fluu1MyT2tTDu1JxsAvkMDXRwDBQ0KU5af4fNaWzYnoLdc1rlpcUe
Ct2a4DhNgdFiUsLPIZCoJL94zwwFREFfdGEugRryM48eweb5K8k/sVWZokgp
NmMbN1OJHZ4YufAa9p54t3KPPAJtWOdxydJIwZPaamUn9mzF33euYCsaLJIM
EgLBo/baTuwTyjXTvHwCHZE3Sl5iL0o+UxCIrb5YKjSlKAj5TdN4ErsnPXkg
HPvCAlP6cimBzFJ33dyPHcC/W/QNNooPqTqOPSZtdU3HvrrNN/Ei9vZ9vsIu
7NFNnsG3sAtVnf+S2C6rF3k+xX7TJk5zKiBQlLsTaxQ7e0Jk64d9ar6VlsJu
EZ+qjsX+D7xaXB8=
      "]]}}, {{}, 
    {GrayLevel[0], PointSize[0.03], 
     PointBox[{{0., 1.}, {0.2, 1.2}, {0.4, 1.44}, {0.6000000000000001, 
      1.728}, {0.8, 2.0736}, {1., 2.48832}, {1.2, 2.9859839999999997`}, {1.4, 
      3.5831807999999996`}, {1.5999999999999999`, 4.299816959999999}, {
      1.7999999999999998`, 5.159780351999999}, {1.9999999999999998`, 
      6.191736422399999}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  PlotRange->{{0, 2}, {1.0000000408163274`, 7.38905579733653}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{
  3.4196171719474816`*^9, 3.4196176172878494`*^9, {3.4196176850252514`*^9, 
   3.4196177193546143`*^9}, 3.419617873616432*^9, 3.4196179573167872`*^9, 
   3.4196439299936624`*^9, 3.4260951933722687`*^9}],

Cell[BoxData["\<\"euler10.eps\"\>"], "Output",
 CellChangeTimes->{
  3.4196171719474816`*^9, 3.4196176172878494`*^9, {3.4196176850252514`*^9, 
   3.4196177193546143`*^9}, 3.419617873616432*^9, 3.4196179573167872`*^9, 
   3.4196439299936624`*^9, 3.426095193482427*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.7], Thickness[0.03], LineBox[CompressedData["
1:eJwVx38803kcwPFtkZ9hQ9p2X7VSGTqV6Ify/pQex6S6hTseJ0V+hFJ57HGV
O6HmHDN35yEphXCOpFV+dD3kVJbKRXWRfoyV3NJI37RNM/a9z/3xerweT17M
gR1xDBqNtg33/4PiRh7ffBfnt/+VxpJGI8HEn3NQyd4M9hGpKScYJHiVl5xt
ZIdCbAXlY2ZKwpbu/qvn2LFAJ3InbS1J+DZ2sq2QLYLutw5rljiQMOCZ4y9l
i6FFTrsT50pCheP2n/LYRaDa431shZCELPPGpbnsaij+5YbOWEVCeMR5Gfmx
CaT0YKHPzo9gRWVFBji3wwVJjSqJOQGLheMjHRI5dN/KKlp2fwIO96yFEs19
6IqJcLhb8gmcmpiDdPpDcEwJzz8do4GWIf8HD9f/A76Bax0yvtLC7aRz3Iix
XuhLqzmq9tSBdskG24b9/RCy6SmvljUJDH29HXfxC3C3uEd1sD6DD7W7JeSS
AiSSzuuDVnp4IF7V0+mmhOvkuehnFlMw/9dRfd34K6gW1Hl2uxpgdFI52Ld8
CAw/tF2WwTRUq1u7bAregKpGp6hMmwEb4o8Pw8PDcI3TfMytzQj5ic3xFS4q
GOh9/yJKR4EO1Q/vzXgLAt/8LU4XaUi0Ut40t2MEoiXJPG44HSkvySWPeWpw
yFj5PJTDQIak3lJ+2igIanbXB75mIPeNZsb41jGYaPpUU1Q5CwVU8hKuOI3D
wcuCOaofTdBhYtfC15Ef4KXza2eB0BR5jIVZ9W8lYZQvW/6cPxvZ25Lm8ikS
1qsbvcXOZsikvVS26OxHKNmaagi3NkfJq1qfW2yZALew9N/V8yxQvSCm4i/d
BFTe0hNT7pZIO8qxUxV/grPp1O2Fq61Qc0jArKLNGvCHjZx3sdYoIzC7vEml
AYbrSG9c3hzEGwh6VpWthcJ76qozzTZo3WpxEXulDrgJKVb9s+xQpPNDPf2J
DuoSEs9zau2Qtks6dDBrEnK8s4PKopmoxCRKtMPlM6gZN/YtmMtC9oPNlQz5
ZygLeu+4qoeFTNOzQtce0oNJ7rqqpWX2iFYXJRtiTcFwAcSG7XVAqWdkUtbt
KRD592VUBDuiNvefzZkpBvhynt+G733mImZQqsdxm2nQ3Ht2oJzthBTLHj05
emMarKvGzb0489DlMnAZjpqB3Paank57Ntop82ESxhnoK04+7sfioMzs81mK
C0bgb+Zcb1/BRQ0jRKlNMAVemq+VnoIvkJBps+buFAU7ZyeN3BQTKM+UwVVg
e+fwD73Fluu1MyT2tTDu1JxsAvkMDXRwDBQ0KU5af4fNaWzYnoLdc1rlpcUe
Ct2a4DhNgdFiUsLPIZCoJL94zwwFREFfdGEugRryM48eweb5K8k/sVWZokgp
NmMbN1OJHZ4YufAa9p54t3KPPAJtWOdxydJIwZPaamUn9mzF33euYCsaLJIM
EgLBo/baTuwTyjXTvHwCHZE3Sl5iL0o+UxCIrb5YKjSlKAj5TdN4ErsnPXkg
HPvCAlP6cimBzFJ33dyPHcC/W/QNNooPqTqOPSZtdU3HvrrNN/Ei9vZ9vsIu
7NFNnsG3sAtVnf+S2C6rF3k+xX7TJk5zKiBQlLsTaxQ7e0Jk64d9ar6VlsJu
EZ+qjsX+D7xaXB8=
      "]]}}, {{}, 
    {GrayLevel[0], PointSize[0.03], 
     PointBox[{{0., 1.}, {0.06666666666666667, 1.0666666666666667`}, {
      0.13333333333333333`, 1.1377777777777778`}, {0.2, 
      1.2136296296296296`}, {0.26666666666666666`, 1.2945382716049383`}, {
      0.3333333333333333, 1.3808408230452676`}, {0.39999999999999997`, 
      1.472896877914952}, {0.4666666666666666, 1.5710900031092823`}, {
      0.5333333333333333, 1.675829336649901}, {0.6, 1.787551292426561}, {
      0.6666666666666666, 1.906721378588332}, {0.7333333333333333, 
      2.0338361371608875`}, {0.7999999999999999, 2.169425212971613}, {
      0.8666666666666666, 2.314053560503054}, {0.9333333333333332, 
      2.468323797869924}, {0.9999999999999999, 2.632878717727919}, {
      1.0666666666666667`, 2.808403965576447}, {1.1333333333333333`, 
      2.995630896614877}, {1.2, 3.1953396230558684`}, {1.2666666666666666`, 
      3.408362264592926}, {1.3333333333333333`, 3.635586415565788}, {1.4, 
      3.8779588432701737`}, {1.4666666666666666`, 4.136489432821518}, {
      1.5333333333333332`, 4.41225539500962}, {1.5999999999999999`, 
      4.706405754676927}, {1.6666666666666665`, 5.020166138322056}, {
      1.7333333333333332`, 5.354843880876859}, {1.7999999999999998`, 
      5.711833472935316}, {1.8666666666666665`, 6.092622371131004}, {
      1.9333333333333331`, 6.49879719587307}, {1.9999999999999998`, 
      6.932050342264608}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  PlotRange->{{0, 2}, {1.0000000408163274`, 7.38905579733653}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{
  3.4196171719474816`*^9, 3.4196176172878494`*^9, {3.4196176850252514`*^9, 
   3.4196177193546143`*^9}, 3.419617873616432*^9, 3.4196179573167872`*^9, 
   3.4196439299936624`*^9, 3.4260951935124702`*^9}],

Cell[BoxData["\<\"euler30.eps\"\>"], "Output",
 CellChangeTimes->{
  3.4196171719474816`*^9, 3.4196176172878494`*^9, {3.4196176850252514`*^9, 
   3.4196177193546143`*^9}, 3.419617873616432*^9, 3.4196179573167872`*^9, 
   3.4196439299936624`*^9, 3.426095193582571*^9}]
}, Open  ]]
},
WindowSize->{975, 903},
WindowMargins->{{31, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> 
     FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", CharacterEncoding -> 
       "WindowsANSI"]]], 
   Cell[
    StyleData["Text"]]}, Visible -> False, FrontEndVersion -> 
  "6.0 for Microsoft Windows (32-bit) (April 20, 2007)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1083, 27, 359, "Input"],
Cell[CellGroupData[{
Cell[1676, 52, 9745, 241, 1156, "Input"],
Cell[11424, 295, 2857, 57, 322, "Output"],
Cell[14284, 354, 267, 4, 48, "Output"],
Cell[14554, 360, 3902, 72, 322, "Output"],
Cell[18459, 434, 267, 4, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
