(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12461,        321]
NotebookOptionsPosition[     11975,        302]
NotebookOutlinePosition[     12395,        318]
CellTagsIndexPosition[     12352,        315]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates Heun' s method for solving an initial value ODE \
problem.
Problem: Find values of y over [0,2] for y' = y given initial value y(0) = 1.
The exact solution is e^x.

Heun's method is allowed 10 steps. Compare this to the solution using Euler's \
method in Euler.nb

The figure generated here and the method are described in detail in Chapter 9 \
: Computing Dynamic Processes

Updated May 2008
\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4196187682528563`*^9, 3.4196188224507885`*^9}, {
  3.419618909325709*^9, 3.419618936725107*^9}, {3.4196191681178336`*^9, 
  3.419619225179885*^9}, {3.426094939316955*^9, 3.426094939887776*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "foleder", " ", "to", " ", "be", " ", "folder", 
    " ", "this", " ", "files", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Huen", "'"}], "s", " ", "method"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"heun", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xold", "=", "x0"}], ",", 
        RowBox[{"yold", "=", "y0"}], ",", 
        RowBox[{"sollist", "=", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",",
         "h"}], "}"}], ",", 
      RowBox[{
       RowBox[{"h", "=", 
        RowBox[{"N", "[", 
         FractionBox[
          RowBox[{"xn", "-", "x0"}], "steps"], "]"}]}], ";", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"xnew", "=", 
           RowBox[{"xold", "+", "h"}]}], ";", 
          RowBox[{"ynew1", "=", 
           RowBox[{"yold", "+", 
            RowBox[{"h", " ", 
             RowBox[{"(", 
              RowBox[{"f", "/.", "\[InvisibleSpace]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"x", "\[Rule]", "xold"}], ",", 
                 RowBox[{"y", "\[Rule]", "yold"}]}], "}"}]}], ")"}]}]}]}], 
          ";", 
          RowBox[{"oldslope", "=", 
           RowBox[{"f", "/.", "\[InvisibleSpace]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "\[Rule]", "xold"}], ",", 
              RowBox[{"y", "\[Rule]", "yold"}]}], "}"}]}]}], ";", 
          RowBox[{"newslope", "=", 
           RowBox[{"f", "/.", "\[InvisibleSpace]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "\[Rule]", "xnew"}], ",", 
              RowBox[{"y", "\[Rule]", "ynew1"}]}], "}"}]}]}], ";", 
          RowBox[{"ynew", "=", 
           RowBox[{"yold", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", "h", " ", 
             RowBox[{"(", 
              RowBox[{"oldslope", "+", "newslope"}], ")"}]}]}]}], ";", 
          RowBox[{"sollist", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"sollist", ",", 
             RowBox[{"{", 
              RowBox[{"xnew", ",", "ynew"}], "}"}]}], "]"}]}], ";", 
          RowBox[{"xold", "=", "xnew"}], ";", 
          RowBox[{"yold", "=", "ynew"}]}], ",", 
         RowBox[{"{", "steps", "}"}]}], "]"}], ";", 
       RowBox[{"Return", "[", "sollist", "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Store", " ", "the", " ", "plot", " ", "the", " ", "exact", " ", 
     "solution", " ", 
     RowBox[{"e", "^", "x"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exactplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.03`", "]"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
       
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Solve", " ", "with", " ", 
     RowBox[{"Huen", "'"}], "s", " ", "for", " ", "10", " ", "steps"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"heunsol", "=", 
     RowBox[{"heun", "[", 
      RowBox[{"y", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1.`"}], "}"}], ",", "10"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Store", " ", "the", " ", "plot", " ", 
     RowBox[{"Huen", "'"}], "s", " ", "solution"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"heunplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"heunsol", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.03`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
       
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
       RowBox[{"TicksStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "exact", " ", "and", " ", 
     RowBox[{"Huen", "'"}], "s", " ", "together"}], " ", "*)"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"plt", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"exactplot", ",", "heunplot"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Send", " ", "to", " ", "postscript", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<heun10.eps\>\"", ",", "plt"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4196192319896765`*^9, 3.419619341036478*^9}, {
  3.4196193953645983`*^9, 3.4196194021543617`*^9}, {3.4196194344708304`*^9, 
  3.4196194389072094`*^9}, {3.4196195715679665`*^9, 3.419619636871869*^9}, {
  3.419644004761173*^9, 3.419644012131771*^9}, {3.426095027403618*^9, 
  3.4260950565655503`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.7], Thickness[0.03], LineBox[CompressedData["
1:eJwVx38803kcwPFtkZ9hQ9p2X7VSGTqV6Ify/pQex6S6hTseJ0V+hFJ57HGV
O6HmHDN35yEphXCOpFV+dD3kVJbKRXWRfoyV3NJI37RNM/a9z/3xerweT17M
gR1xDBqNtg33/4PiRh7ffBfnt/+VxpJGI8HEn3NQyd4M9hGpKScYJHiVl5xt
ZIdCbAXlY2ZKwpbu/qvn2LFAJ3InbS1J+DZ2sq2QLYLutw5rljiQMOCZ4y9l
i6FFTrsT50pCheP2n/LYRaDa431shZCELPPGpbnsaij+5YbOWEVCeMR5Gfmx
CaT0YKHPzo9gRWVFBji3wwVJjSqJOQGLheMjHRI5dN/KKlp2fwIO96yFEs19
6IqJcLhb8gmcmpiDdPpDcEwJzz8do4GWIf8HD9f/A76Bax0yvtLC7aRz3Iix
XuhLqzmq9tSBdskG24b9/RCy6SmvljUJDH29HXfxC3C3uEd1sD6DD7W7JeSS
AiSSzuuDVnp4IF7V0+mmhOvkuehnFlMw/9dRfd34K6gW1Hl2uxpgdFI52Ld8
CAw/tF2WwTRUq1u7bAregKpGp6hMmwEb4o8Pw8PDcI3TfMytzQj5ic3xFS4q
GOh9/yJKR4EO1Q/vzXgLAt/8LU4XaUi0Ut40t2MEoiXJPG44HSkvySWPeWpw
yFj5PJTDQIak3lJ+2igIanbXB75mIPeNZsb41jGYaPpUU1Q5CwVU8hKuOI3D
wcuCOaofTdBhYtfC15Ef4KXza2eB0BR5jIVZ9W8lYZQvW/6cPxvZ25Lm8ikS
1qsbvcXOZsikvVS26OxHKNmaagi3NkfJq1qfW2yZALew9N/V8yxQvSCm4i/d
BFTe0hNT7pZIO8qxUxV/grPp1O2Fq61Qc0jArKLNGvCHjZx3sdYoIzC7vEml
AYbrSG9c3hzEGwh6VpWthcJ76qozzTZo3WpxEXulDrgJKVb9s+xQpPNDPf2J
DuoSEs9zau2Qtks6dDBrEnK8s4PKopmoxCRKtMPlM6gZN/YtmMtC9oPNlQz5
ZygLeu+4qoeFTNOzQtce0oNJ7rqqpWX2iFYXJRtiTcFwAcSG7XVAqWdkUtbt
KRD592VUBDuiNvefzZkpBvhynt+G733mImZQqsdxm2nQ3Ht2oJzthBTLHj05
emMarKvGzb0489DlMnAZjpqB3Paank57Ntop82ESxhnoK04+7sfioMzs81mK
C0bgb+Zcb1/BRQ0jRKlNMAVemq+VnoIvkJBps+buFAU7ZyeN3BQTKM+UwVVg
e+fwD73Fluu1MyT2tTDu1JxsAvkMDXRwDBQ0KU5af4fNaWzYnoLdc1rlpcUe
Ct2a4DhNgdFiUsLPIZCoJL94zwwFREFfdGEugRryM48eweb5K8k/sVWZokgp
NmMbN1OJHZ4YufAa9p54t3KPPAJtWOdxydJIwZPaamUn9mzF33euYCsaLJIM
EgLBo/baTuwTyjXTvHwCHZE3Sl5iL0o+UxCIrb5YKjSlKAj5TdN4ErsnPXkg
HPvCAlP6cimBzFJ33dyPHcC/W/QNNooPqTqOPSZtdU3HvrrNN/Ei9vZ9vsIu
7NFNnsG3sAtVnf+S2C6rF3k+xX7TJk5zKiBQlLsTaxQ7e0Jk64d9ar6VlsJu
EZ+qjsX+D7xaXB8=
      "]]}}, {{}, 
    {GrayLevel[0], PointSize[0.03], 
     PointBox[{{0., 1.}, {0.2, 1.22}, {0.4, 1.4884}, {0.6000000000000001, 
      1.815848}, {0.8, 2.21533456}, {1., 2.7027081632}, {1.2, 
      3.297303959104}, {1.4, 4.02271083010688}, {1.5999999999999999`, 
      4.907707212730394}, {1.7999999999999998`, 5.98740279953108}, {
      1.9999999999999998`, 7.3046314154279175`}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  PlotRange->{{0, 2}, {1.0000000408163274`, 7.38905579733653}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{3.4196193794016447`*^9, 3.4196196612068605`*^9, 
  3.419644015426509*^9, 3.4260950604511375`*^9}],

Cell[BoxData["\<\"heun10.eps\"\>"], "Output",
 CellChangeTimes->{3.4196193794016447`*^9, 3.4196196612068605`*^9, 
  3.419644015426509*^9, 3.4260950609819007`*^9}]
}, Open  ]]
},
WindowSize->{894, 929},
WindowMargins->{{170, Automatic}, {23, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 833, 23, 359, "Input"],
Cell[CellGroupData[{
Cell[1426, 48, 7606, 190, 940, "Input"],
Cell[9035, 240, 2759, 55, 322, "Output"],
Cell[11797, 297, 162, 2, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
