(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28787,        829]
NotebookOptionsPosition[     27867,        798]
NotebookOutlinePosition[     28286,        814]
CellTagsIndexPosition[     28243,        811]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook finds the eigenvalues of a symmetric matrix using Jacobi \
iteration as described in Section 6.4.

Given: a symmetric matrix a.
First we find the eigenvalues using Mathematica's Eigenvalue function.
We run  Jacobi iteration and compare the results to the Mathematica results.

See Chapter 6: Eigen-Problems for details.

Updated July 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{
  3.42584638938948*^9, {3.425846463305766*^9, 3.425846620521832*^9}, 
   3.4258629454859776`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3.0", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "4", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", 
         RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
    
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Matrix A = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Eigenvalues (from Mathematica's function) = \>\"", ",", 
     RowBox[{"Eigenvalues", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Compute", " ", "eigenvalues", " ", "with", " ", "Jacobi", " ", 
     "method"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Largest", " ", "off"}], "-", 
     RowBox[{
     "diagonal", " ", "element", " ", "in", " ", "matrix", " ", "a", " ", 
      "is", " ", "a_", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}]}], " ", "*)"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"i", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Compute", " ", "angle"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tan2al", "=", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}], ")"}]}]}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", "=", 
     RowBox[{
      RowBox[{"ArcTan", "[", "tan2al", "]"}], "/", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"Cos", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"Sin", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
     RowBox[{"-", "s"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", "s"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "j"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "new", " ", "matrix", " ", 
     RowBox[{"a", "^", 
      RowBox[{
       RowBox[{"(", "1", ")"}], " ", "--"}]}], " ", "first", " ", 
     "iteration"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "u", "]"}], ".", "a", ".", "u"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Jacobi eigenvalue approximations are on the diagonal of the \
resulting matrix\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Stop when off-diagonal elements are smaller than a given tolerance\>\
\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<1st iteration = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"ITERATION", " ", "2"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"largest", " ", "off"}], "-", 
     RowBox[{
     "diagonal", " ", "element", " ", "from", " ", "iteratioin", " ", "1", 
      " ", "is", " ", 
      RowBox[{"(", 
       RowBox[{"1", ",", "3"}], ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"i", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tan2al", "=", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}], ")"}]}]}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", "=", 
     RowBox[{
      RowBox[{"ArcTan", "[", "tan2al", "]"}], "/", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"Cos", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"Sin", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
     RowBox[{"-", "s"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", "s"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "j"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "u", "]"}], ".", "a", ".", "u"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<2nd iteration = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"ITERATION", " ", "3"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"largest", " ", "off"}], "-", 
     RowBox[{
     "diagonal", " ", "element", " ", "from", " ", "iteration", " ", "2", " ",
       "is", " ", 
      RowBox[{"(", 
       RowBox[{"1", ",", "2"}], ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"i", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tan2al", "=", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}], ")"}]}]}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", "=", 
     RowBox[{
      RowBox[{"ArcTan", "[", "tan2al", "]"}], "/", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"Cos", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"Sin", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
     RowBox[{"-", "s"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", "s"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "j"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "u", "]"}], ".", "a", ".", "u"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<3rd iteration = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"ITERATION", " ", "4"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tan2al", "=", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}], ")"}]}]}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", "=", 
     RowBox[{
      RowBox[{"ArcTan", "[", "tan2al", "]"}], "/", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"Cos", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"Sin", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
     RowBox[{"-", "s"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", "s"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "j"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "u", "]"}], ".", "a", ".", "u"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<4th iteration = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"ITERATION", " ", "5"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"j", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tan2al", "=", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}], "-", 
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}], ")"}]}]}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", "=", 
     RowBox[{
      RowBox[{"ArcTan", "[", "tan2al", "]"}], "/", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"Cos", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"Sin", "[", "alpha", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
     RowBox[{"-", "s"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "i"}], "]"}], "]"}], "=", "s"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "i"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", 
       RowBox[{"j", ",", "j"}], "]"}], "]"}], "=", "c"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "u", "]"}], ".", "a", ".", "u"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<5th iteration = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Let's say we met stopping criterion of all off-diagonal elements < \
tol\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Eigenvalue estimates: \>\"", ",", 
     RowBox[{"a", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "\"\<  \>\"", ",", 
     RowBox[{"a", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "\"\<  \>\"", ",", 
     RowBox[{"a", "[", 
      RowBox[{"[", 
       RowBox[{"3", ",", "3"}], "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   
   RowBox[{
   "Print", "[", 
    "\"\<These match the Mathematica eigenvalues exactly to 6 digits\>\"", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4258458133912354`*^9, 3.425845947774469*^9}, {
  3.4258459917977715`*^9, 3.425846027749467*^9}, {3.4258460679472685`*^9, 
  3.4258462045136414`*^9}, {3.4258463466880784`*^9, 3.425846375850011*^9}, {
  3.4258470794917984`*^9, 3.4258471162146034`*^9}, {3.4258471573537583`*^9, 
  3.425847231800808*^9}, {3.425847289403637*^9, 3.425847539463205*^9}, {
  3.4258629871659107`*^9, 3.4258629941259184`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Matrix A = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.`", 
        RowBox[{"-", "1"}], "1"},
       {
        RowBox[{"-", "1"}], "4", "2"},
       {"1", "2", 
        RowBox[{"-", "3"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Matrix A = ", 
   MatrixForm[{{3., -1, 1}, {-1, 4, 2}, {1, 2, -3}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475398337374`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvalues (from Mathematica's function) = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4.835304901985483`", ",", 
     RowBox[{"-", "3.7546390680766843`"}], ",", "2.9193341660912027`"}], 
    "}"}]}],
  SequenceForm[
  "Eigenvalues (from Mathematica's function) = ", {
   4.835304901985483, -3.7546390680766843`, 2.9193341660912027`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.425847539843752*^9}],

Cell[BoxData["\<\"Jacobi eigenvalue approximations are on the diagonal of the \
resulting matrix\"\>"], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.425847539863781*^9}],

Cell[BoxData["\<\"Stop when off-diagonal elements are smaller than a given \
tolerance\"\>"], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475398737955`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"1st iteration = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.`", 
        RowBox[{"-", "0.7098317136076453`"}], "1.2231675839216938`"},
       {
        RowBox[{"-", "0.7098317136076453`"}], "4.531128874149275`", "0.`"},
       {"1.2231675839216938`", "0.`", 
        RowBox[{"-", "3.531128874149275`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["1st iteration = ", 
   MatrixForm[{{3., -0.7098317136076453, 
    1.2231675839216938`}, {-0.7098317136076453, 4.531128874149275, 0.}, {
    1.2231675839216938`, 0., -3.531128874149275}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475398838096`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"2nd iteration = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.2215618914433626`", 
        RowBox[{"-", "0.6984655514167485`"}], 
        RowBox[{"-", "3.3306690738754696`*^-16"}]},
       {
        RowBox[{"-", "0.6984655514167485`"}], "4.531128874149275`", 
        "0.12651851693433477`"},
       {
        RowBox[{"-", "2.220446049250313`*^-16"}], "0.12651851693433477`", 
        RowBox[{"-", "3.752690765592638`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["2nd iteration = ", 
   MatrixForm[{{
    3.2215618914433626`, -0.6984655514167485, -3.3306690738754696`*^-16}, \
{-0.6984655514167485, 4.531128874149275, 
    0.12651851693433477`}, {-2.220446049250313*^-16, 
    0.12651851693433477`, -3.752690765592638}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.425847539893824*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"3rd iteration = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.9189554167614387`", 
        RowBox[{"-", "2.220446049250313`*^-16"}], "0.05029603700608229`"},
       {"0.`", "4.833735348831199`", "0.11609153194245633`"},
       {"0.05029603700608239`", "0.11609153194245628`", 
        RowBox[{"-", "3.752690765592638`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["3rd iteration = ", 
   MatrixForm[{{2.9189554167614387`, -2.220446049250313*^-16, 
    0.05029603700608229}, {0., 4.833735348831199, 0.11609153194245633`}, {
    0.05029603700608239, 0.11609153194245628`, -3.752690765592638}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.425847539903838*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"4th iteration = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.9189554167614387`", "0.0006798339176296494`", 
        "0.05029144225772054`"},
       {"0.0006798339176298728`", "4.835304660774168`", 
        RowBox[{"-", "2.7755575615628914`*^-17"}]},
       {"0.05029144225772064`", 
        RowBox[{"-", "6.245004513516506`*^-17"}], 
        RowBox[{"-", "3.7542600775356054`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["4th iteration = ", 
   MatrixForm[{{2.9189554167614387`, 0.0006798339176296494, 
    0.05029144225772054}, {0.0006798339176298728, 
    4.835304660774168, -2.7755575615628914`*^-17}, {
    0.05029144225772064, -6.245004513516506*^-17, -3.7542600775356054`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475399138527`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"5th iteration = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.9193344072994627`", "0.0006798146147150492`", 
        "3.469446951953614`*^-18"},
       {"0.0006798146147152729`", "4.835304660774168`", 
        RowBox[{"-", "5.1230049293200144`*^-6"}]},
       {"1.0755285551056204`*^-16", 
        RowBox[{"-", "5.123004929353024`*^-6"}], 
        RowBox[{"-", "3.7546390680736295`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["5th iteration = ", 
   MatrixForm[{{2.9193344072994627`, 0.0006798146147150492, 
    3.469446951953614*^-18}, {0.0006798146147152729, 
    4.835304660774168, -5.1230049293200144`*^-6}, {
    1.0755285551056204`*^-16, -5.123004929353024*^-6, \
-3.7546390680736295`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475399338818`*^9}],

Cell[BoxData["\<\"Let's say we met stopping criterion of all off-diagonal \
elements < tol\"\>"], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475399438963`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvalue estimates: \"\>", "\[InvisibleSpace]", 
   "2.9193344072994627`", "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", "4.835304660774168`", 
   "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3.7546390680736295`"}]}],
  SequenceForm[
  "Eigenvalue estimates: ", 2.9193344072994627`, "  ", 4.835304660774168, 
   "  ", -3.7546390680736295`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.4258475399539104`*^9}],

Cell[BoxData["\<\"These match the Mathematica eigenvalues exactly to 6 digits\
\"\>"], "Print",
 CellChangeTimes->{
  3.4258459509690623`*^9, 3.4258460284805183`*^9, 3.4258462048841743`*^9, {
   3.425847450875822*^9, 3.4258474826515136`*^9}, 3.425847539963925*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{713, 789},
WindowMargins->{{41, Automatic}, {Automatic, 16}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 667, 21, 296, "Input"],
Cell[CellGroupData[{
Cell[1260, 46, 16005, 486, 1982, "Input"],
Cell[CellGroupData[{
Cell[17290, 536, 1078, 29, 51, "Print"],
Cell[18371, 567, 603, 14, 23, "Print"],
Cell[18977, 583, 281, 4, 23, "Print"],
Cell[19261, 589, 273, 4, 23, "Print"],
Cell[19537, 595, 1312, 31, 51, "Print"],
Cell[20852, 628, 1496, 36, 57, "Print"],
Cell[22351, 666, 1366, 30, 53, "Print"],
Cell[23720, 698, 1459, 33, 57, "Print"],
Cell[25182, 733, 1472, 34, 59, "Print"],
Cell[26657, 769, 277, 4, 23, "Print"],
Cell[26937, 775, 635, 13, 23, "Print"],
Cell[27575, 790, 264, 4, 23, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
