(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5786,        166]
NotebookOptionsPosition[      5417,        151]
NotebookOutlinePosition[      5835,        167]
CellTagsIndexPosition[      5792,        164]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the Lorenz attractor, a system of three ODEs.

Figures 9.10 was created with this notebook.

See Chapter 9 : Computing Dynamic Processes for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.426278700270344*^9, 3.426278758373893*^9}, {
  3.426279430049715*^9, 3.426279437079824*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"SOlve", " ", "the", " ", "three", " ", "ODEs"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "The", " ", "left", " ", "of", " ", "Figure", " ", "9.10", " ", "is", 
      " ", "generated", " ", "with", " ", "y"}], "=", 
     RowBox[{
      RowBox[{
      "1", " ", "and", "  ", "the", " ", "right", " ", "of", " ", "the", " ", 
       "Figure", " ", "is", " ", "generated", " ", "with", " ", "y"}], "=", 
      "1.00001"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", "10"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "[", "t", "]"}], "-", 
           RowBox[{"y", "[", "t", "]"}]}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"x", "[", "t", "]"}]}], " ", 
          RowBox[{"z", "[", "t", "]"}]}], "+", 
         RowBox[{"28", " ", 
          RowBox[{"x", "[", "t", "]"}]}], "-", 
         RowBox[{"y", "[", "t", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"z", "'"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], " ", 
          RowBox[{"y", "[", "t", "]"}]}], "-", 
         RowBox[{"2.6666666667", 
          RowBox[{"z", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
        RowBox[{"z", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1.00001"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "Infinity"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "the", " ", "three", " ", "functions", " ", "x", 
      RowBox[{"(", "t", ")"}]}], ",", " ", 
     RowBox[{"Y", 
      RowBox[{"(", "t", ")"}]}], ",", " ", 
     RowBox[{"z", 
      RowBox[{"(", "t", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "[", "t", "]"}], ",", 
          RowBox[{"y", "[", "t", "]"}], ",", 
          RowBox[{"z", "[", "t", "]"}]}], "}"}], "/.", "%"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "60"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "10000"}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "postscript", " ", "plot"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Lorenz.eps\>\"", ",", "pic"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.42627880215685*^9, 3.426278809978096*^9}, {
  3.426278885416571*^9, 3.4262789159504766`*^9}, {3.426279009284685*^9, 
  3.4262790096552176`*^9}, {3.4262790780335407`*^9, 3.426279222781678*^9}, {
  3.4262792940040913`*^9, 3.426279385004944*^9}}]
},
WindowSize->{760, 825},
WindowMargins->{{63, Automatic}, {Automatic, 6}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 507, 16, 249, "Input"],
Cell[1078, 39, 4335, 110, 599, "Input"]
}
]
*)

(* End of internal cache information *)
