(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65081,       1172]
NotebookOptionsPosition[     64635,       1154]
NotebookOutlinePosition[     65053,       1170]
CellTagsIndexPosition[     65010,       1167]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the tangent plane of a bivariate function at a \
given point.
The given function is f(x,y) = x^2 + y^2.
We take find the tangent plane at (1,1).  Following equation (11.3), we get \
l(x,y) = -2 + 2x + 2y.

Figure 11.4 was created with this notebook.

See Chapter 11: Computing with Multivariate Functionsfor details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.426366039055131*^9, 3.426366109055787*^9}, {
  3.426367147318736*^9, 3.4263672082463455`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "bivariate", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f1", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]}], ";"}], ")"}], " ", "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "the", " ", "tangent", " ", "plane", " ", "to", " ", "f1", 
     " ", "at", " ", 
     RowBox[{"(", 
      RowBox[{"1", ",", "1"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f2", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"2", " ", "y"}]}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "f1", " ", "over", " ", "some", " ", "domain"}], " ",
     "*)"}], 
   RowBox[{
    RowBox[{"plot1", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f1", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1`"}], ",", 
          RowBox[{"-", "1"}], ",", "0.4`"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Yellow", ",", 
          RowBox[{"Specularity", "[", 
           RowBox[{"White", ",", "20"}], "]"}], ",", 
          RowBox[{"Opacity", "[", "0.8", "]"}]}], "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
       
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot2", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f2", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.1`"}], ",", 
          RowBox[{"-", "1"}], ",", "0.4`"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
       
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpoint", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{"\"\<o\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "3"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "Red"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Picture", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plot1", ",", "plotpoint", ",", "plot2"}], "}"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2.3`"}], ",", "1.5`"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript", " ", "files"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<function1.eps\>\"", ",", "plot1"}], "]"}], ";"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<function2.eps\>\"", ",", "plot2"}], "]"}], ";"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<function_combo.eps\>\"", ",", "Picture"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.426366113412051*^9, 3.426366288634008*^9}, {
  3.426366320249469*^9, 3.4263663348805075`*^9}, {3.4263663775718946`*^9, 
  3.4263664548430047`*^9}, {3.4263665012497344`*^9, 3.4263665202770944`*^9}, {
  3.4263665619670415`*^9, 3.4263665902477074`*^9}, {3.4263666635230722`*^9, 
  3.426366677042512*^9}, {3.4263667189127183`*^9, 3.426366721776837*^9}, {
  3.426366765129174*^9, 3.426366778448326*^9}, {3.4263668300525293`*^9, 
  3.4263668304230623`*^9}, {3.4263672139845967`*^9, 3.4263672219961166`*^9}}],\


Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nAtwVdX1hyMJjwoiASQ8hIgKLTVSLQki+OdckCTQAoIlMfKICoKgYCmx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    "], {{
      {RGBColor[1, 1, 0], Opacity[0.8], EdgeForm[None], Specularity[
        GrayLevel[1], 20], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnAf8jlUbx5/7vtvzTXtTIiSESGSFyMjKzIhQ2USUiFRGQimyy0ho0NBU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         "]]]}, {}, {}, {}}, 
     Line3DBox[{938, 1, 934, 902, 31, 61, 91, 121, 151, 181, 211, 241, 271, 
      301, 331, 361, 391, 421, 923, 451, 481, 511, 541, 571, 601, 631, 661, 
      691, 721, 751, 781, 811, 841, 915, 940, 871, 936, 927, 872, 873, 874, 
      875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 928, 886, 887, 
      888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 918, 941, 
      900, 937, 929, 870, 840, 810, 780, 750, 720, 690, 660, 630, 600, 570, 
      540, 510, 480, 926, 450, 420, 390, 360, 330, 300, 270, 240, 210, 180, 
      150, 120, 90, 60, 905, 939, 30, 935, 921, 29, 28, 27, 26, 25, 24, 23, 
      22, 21, 20, 19, 18, 17, 16, 920, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 
      4, 3, 2, 919, 938}]},
    VertexNormals->CompressedData["
1:eJx1fAlUzl33dkWkUkqmiiSZI1NIOsg8z1PIrIikMj2mIqmUWYYUMkvmZKhT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     "]], {Point3DBox[{1, 1, 2}], Text3DBox[
     FormBox["\<\"o\"\>", TraditionalForm], {1, 1, 3}]}, 
   GraphicsComplex3DBox[CompressedData["
1:eJxd3H+oX3Udx/HZdE380a7TbV0vzTn/CYdaaWlm36G51JYLDZmENn/ljxJx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    "], {{
      {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnHf8j9X7x9/3fbf33koobaRERBSSZCRRiIRkFtIgIskomRmVpkppT1Ha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         "]]]}, {}, {}, {}}, 
     Line3DBox[{921, 1, 917, 902, 31, 61, 91, 121, 151, 181, 211, 241, 271, 
      301, 331, 361, 391, 421, 451, 481, 511, 541, 571, 601, 631, 661, 691, 
      721, 751, 781, 811, 841, 906, 923, 871, 919, 911, 872, 873, 874, 875, 
      876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 
      890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 908, 924, 900, 920, 
      912, 870, 840, 810, 780, 750, 720, 690, 660, 630, 600, 570, 540, 510, 
      480, 450, 420, 390, 360, 330, 300, 270, 240, 210, 180, 150, 120, 90, 60,
       904, 922, 30, 918, 910, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18,
       17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 909, 921}]},
    VertexNormals->CompressedData["
1:eJztXAlwldUVDtuwJQqVasCAgDAsAlWJAhUMuIyALAmQhSUdq0MJEBGkIIgG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     "]]},
  Axes->True,
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 270.29673156741507`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{-0.700470462316267, 1.482310657310598, 2.20274743142419},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.4263663818881006`*^9, 3.4263664554638977`*^9}, 
   3.4263665209280305`*^9, {3.4263665691774096`*^9, 3.4263665910789022`*^9}, {
   3.4263666990441484`*^9, 3.4263667245408115`*^9}, {3.426366770366706*^9, 
   3.426366779740184*^9}}]
}, Open  ]]
},
WindowSize->{795, 835},
WindowMargins->{{54, Automatic}, {Automatic, 7}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 674, 20, 300, "Input"],
Cell[CellGroupData[{
Cell[1267, 45, 6427, 166, 865, "Input"],
Cell[7699, 214, 56920, 937, 369, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
