(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10404,        301]
NotebookOptionsPosition[      9811,        278]
NotebookOutlinePosition[     10230,        294]
CellTagsIndexPosition[     10187,        291]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook looks at the singular value decomposition as described in \
Section 6.6.


See Chapter 6: Eigen-Problems for details.

Updated July 2008
\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4258497233234415`*^9, 3.4258497319858975`*^9}, {
  3.425863016077483*^9, 3.4258630411234975`*^9}, {3.4258631008493795`*^9, 
  3.425863134838253*^9}, {3.425863539359926*^9, 3.425863540020877*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "the", " ", "matrix", " ", "a"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "0"},
        {"0", "2"},
        {"0", "1"}
       }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Use", " ", 
     RowBox[{"Mathematica", "'"}], "s", " ", "SVD", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"It", " ", "creates", " ", "three", " ", "matrices"}], ",", " ", 
     "v", ",", " ", "sigma", ",", " ", 
     RowBox[{"u", "^", "T"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", ",", " ", "sigma", ",", " ", "ut"}], "}"}], " ", "=", " ", 
     
     RowBox[{"SingularValueDecomposition", "[", "a", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<SVD: v = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "v", "]"}], ",", "\"\<  sigma=\>\"", ",", 
     RowBox[{"MatrixForm", "[", "sigma", "]"}], ",", "\"\<  ut=\>\"", ",", 
     RowBox[{"MatrixForm", "[", "ut", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Check a = v*sigma*ut =? \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"v", ".", "sigma", ".", "ut"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "the", " ", "matrix", " ", 
     RowBox[{"a", "^", "T"}], " ", "*", " ", "a"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ata", " ", "=", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "a", "]"}], ".", "a"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "the", " ", "matrix", " ", 
     RowBox[{"sigma", "^", "T"}], " ", "*", " ", "sigma"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambda", " ", "=", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "sigma", "]"}], ".", "sigma"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Check a^Ta = u*lambda*u^t \>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "ata", "]"}], ",", "\"\< =? \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", "ut", "]"}], ".", "lambda", ".", "ut"}], 
      "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.425849734629699*^9, 3.4258498083156548`*^9}, {
  3.425849842284499*^9, 3.4258499313726015`*^9}, {3.4258500532178063`*^9, 
  3.4258501560556803`*^9}, {3.425850188001616*^9, 3.4258502329362288`*^9}, {
  3.4258502860125484`*^9, 3.4258502899582224`*^9}, {3.425850338217616*^9, 
  3.42585037862572*^9}, {3.4258631414978285`*^9, 3.425863286546398*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SVD: v = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {
        FractionBox["2", 
         SqrtBox["5"]], "0", 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["5"]]}]},
       {
        FractionBox["1", 
         SqrtBox["5"]], "0", 
        FractionBox["2", 
         SqrtBox["5"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  sigma=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SqrtBox["5"], "0"},
       {"0", "1"},
       {"0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  ut=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {"1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["SVD: v = ", 
   MatrixForm[{{0, 1, 0}, {2 5^Rational[-1, 2], 0, -5^Rational[-1, 2]}, {
     5^Rational[-1, 2], 0, 2 5^Rational[-1, 2]}}], "  sigma=", 
   MatrixForm[{{5^Rational[1, 2], 0}, {0, 1}, {0, 0}}], "  ut=", 
   MatrixForm[{{0, 1}, {1, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.4258499072078543`*^9, 3.425849928398325*^9}, 
   3.425850156696602*^9, 3.4258502346086335`*^9, {3.4258503667987137`*^9, 
   3.4258503796672173`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check a = v*sigma*ut =? \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "2"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check a = v*sigma*ut =? ", 
   MatrixForm[{{1, 0}, {0, 2}, {0, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.4258499072078543`*^9, 3.425849928398325*^9}, 
   3.425850156696602*^9, 3.4258502346086335`*^9, {3.4258503667987137`*^9, 
   3.4258503796872463`*^9}}],

Cell[BoxData["\<\"Check a^Ta = u*lambda*u^t \"\>"], "Print",
 CellChangeTimes->{{3.4258499072078543`*^9, 3.425849928398325*^9}, 
   3.425850156696602*^9, 3.4258502346086335`*^9, {3.4258503667987137`*^9, 
   3.425850379727304*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "5"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" =? \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", "5"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{1, 0}, {0, 5}}], " =? ", 
   MatrixForm[{{1, 0}, {0, 5}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.4258499072078543`*^9, 3.425849928398325*^9}, 
   3.425850156696602*^9, 3.4258502346086335`*^9, {3.4258503667987137`*^9, 
   3.4258503797373185`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{726, 750},
WindowMargins->{{47, Automatic}, {Automatic, 59}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 566, 19, 245, "Input"],
Cell[CellGroupData[{
Cell[1159, 44, 3020, 71, 453, "Input"],
Cell[CellGroupData[{
Cell[4204, 119, 2748, 76, 83, "Print"],
Cell[6955, 197, 1003, 26, 51, "Print"],
Cell[7961, 225, 230, 3, 23, "Print"],
Cell[8194, 230, 1589, 44, 36, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
