(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12953,        336]
NotebookOptionsPosition[     12581,        321]
NotebookOutlinePosition[     13000,        337]
CellTagsIndexPosition[     12957,        334]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook demonstrates Taylor approximations.
Taylor's Theorm states that a function f can be approximated by a polynomial.
Here we approximate sin(x) with a degree 10 and a degree 20 polynomial.

We compare the solution using 10 steps and 30 steps.
Compare solution with the solution using Huen's method in Huen.nb.

See Chapter 8: Data Fitting for details.

Updated May 2008
\
\>", "Input",
 CellChangeTimes->{{3.420057264325054*^9, 3.4200572958704147`*^9}, {
  3.420057327295602*^9, 3.4200573337148323`*^9}, {3.4200573720799985`*^9, 
  3.420057443172224*^9}, {3.4259323002523346`*^9, 3.4259323062509604`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "files", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Load", " ", "20", "  ", "sine", " ", "Taylor", " ", "series", " ", 
     "values", " ", "and", " ", "print", " ", 
     RowBox[{"out", " ", "--"}], " ", "just", " ", "to", " ", "see", " ", 
     "values"}], " ", "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"N", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "the", " ", "Taylor", " ", "approximation", " ", "to", " ",
      
     RowBox[{"Sine", ".", " ", "The"}], " ", "approximation", " ", "degree", 
     " ", "is", " ", "the", " ", "variable", " ", "imax"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"imax", "=", 
      RowBox[{"1", " ", "is", " ", "degree", " ", "1"}]}], ",", " ", 
     RowBox[{"imax", "=", 
      RowBox[{"2", " ", "is", " ", "degree", " ", "3"}]}], ",", " ", "etc"}], 
    " ", "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"taylorSine", "[", 
      RowBox[{"x_", ",", " ", "imax_"}], "]"}], " ", ":=", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "i"}], "-", "1"}], ")"}], "!"}]}], ")"}], 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "i"}], "-", "1"}], ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "imax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "manipulate", " ", "plot", " ", "to", " ", "see",
      " ", "the", " ", "different", " ", "approximations"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"taylorSine", "[", 
          RowBox[{"x", ",", "imax"}], "]"}], ",", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "4"}], "*", "Pi"}], ",", " ", 
         RowBox[{"4", "*", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", " ", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Taylor Approximation of degree \>\"", ",", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "imax"}], "-", "1"}], ")"}]}], "}"}]}]}], "]"}],
      ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"imax", ",", "2"}], "}"}], ",", "2", ",", "15", ",", "1"}], 
      "}"}]}], "]"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Create", " ", "the", " ", "degree", " ", "9", " ", "approximation", 
       " ", "to", " ", "sine", " ", "at", " ", "x"}], "=", 
      RowBox[{
       RowBox[{"0", " ", "\[IndentingNewLine]", 
        RowBox[{"pol10", "[", "x_", "]"}]}], ":=", 
       RowBox[{
        RowBox[{"2.7557319223985893`*^-6", " ", 
         SuperscriptBox["x", "9"]}], "-", 
        RowBox[{"0.0001984126984126984`", " ", 
         SuperscriptBox["x", "7"]}], "+", 
        RowBox[{"0.008333333333333333`", " ", 
         SuperscriptBox["x", "5"]}], "-", 
        RowBox[{"0.16666666666666666`", " ", 
         SuperscriptBox["x", "3"]}], "+", "x"}]}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Create", " ", "the", " ", "degree", " ", "19", " ", "approximation", 
       " ", "to", " ", "sine", " ", "at", " ", "x"}], "=", 
      RowBox[{
       RowBox[{"0", " ", "\[IndentingNewLine]", 
        RowBox[{"pol20", "[", "x_", "]"}]}], ":=", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "8.22063524662433`*^-18"}], " ", 
         SuperscriptBox["x", "19"]}], "+", 
        RowBox[{"2.8114572543455206`*^-15", " ", 
         SuperscriptBox["x", "17"]}], "-", 
        RowBox[{"7.647163731819816`*^-13", " ", 
         SuperscriptBox["x", "15"]}], "+", 
        RowBox[{"1.6059043836821613`*^-10", " ", 
         SuperscriptBox["x", "13"]}], "-", 
        RowBox[{"2.505210838544172`*^-8", " ", 
         SuperscriptBox["x", "11"]}], "+", 
        RowBox[{"2.7557319223985893`*^-6", " ", 
         SuperscriptBox["x", "9"]}], "-", 
        RowBox[{"0.0001984126984126984`", " ", 
         SuperscriptBox["x", "7"]}], "+", 
        RowBox[{"0.008333333333333333`", " ", 
         SuperscriptBox["x", "5"]}], "-", 
        RowBox[{"0.16666666666666666`", " ", 
         SuperscriptBox["x", "3"]}], "+", "x"}]}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\n", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", 
     RowBox[{"Mathematica", "'"}], "s", " ", "Sine", " ", "Taylor", " ", 
     "approximation"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"splot", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.015", "]"}], ",", " ", 
         RowBox[{"GrayLevel", "[", "0.0", "]"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "the", " ", "degree", " ", "9", " ", 
      RowBox[{"approximation", "  ", "--"}], " ", "imax"}], " ", "=", " ", 
     "5"}], " ", "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Since", " ", "it", " ", "starts", " ", "to", " ", "go", " ", "off", 
       " ", "at", " ", "x"}], "=", "5"}], ",", " ", 
     RowBox[{
      RowBox[{"let", "'"}], "s", " ", "stop", " ", "plotting", " ", "it", " ",
       "there"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pplot10", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"taylorSine", "[", 
       RowBox[{"x", ",", " ", "5"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "5.2"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.015", "]"}], ",", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "the", " ", "degree", " ", "19", " ", 
      RowBox[{"approximation", " ", "--"}], " ", "imax"}], "=", "10"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Since", " ", "it", " ", "starts", " ", "to", " ", "go", " ", "off", 
       " ", "at", " ", "x"}], "=", "8.7"}], ",", " ", 
     RowBox[{
      RowBox[{"let", "'"}], "s", " ", "stop", " ", "plotting", " ", "it", " ",
       "there"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pplot20", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"taylorSine", "[", 
       RowBox[{"x", ",", " ", "10"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "8.7"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.015", "]"}], ",", 
         RowBox[{"GrayLevel", "[", "0.5", "]"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "combined", " ", "graphics", " ", "to", " ", 
     "postscript", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "splot", ",", " ", "pplot10", ",", "pplot20", ",", " ", "splot"}], 
     "]"}]}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "combined", " ", "graphics", " ", "to", " ", "postscript", 
     " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Taylor.eps\>\"", ",", "pic"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.420057450602909*^9, 3.420057490770667*^9}, {
  3.42005759945695*^9, 3.4200576368106623`*^9}, {3.420057674675109*^9, 
  3.420057771944976*^9}, {3.420058124201496*^9, 3.4200581256736126`*^9}, {
  3.4200583165681057`*^9, 3.4200583789878607`*^9}, {3.4200588155556145`*^9, 
  3.420058931812784*^9}, {3.4200590307951136`*^9, 3.4200590333487854`*^9}, {
  3.42005906456367*^9, 3.4200591536718016`*^9}, {3.4200591942301216`*^9, 
  3.420059221309059*^9}, {3.420059252353699*^9, 3.420059390241973*^9}, {
  3.4200594431580625`*^9, 3.4200595566212144`*^9}, {3.420059738062114*^9, 
  3.4200597638992653`*^9}, {3.4200598078624816`*^9, 3.4200598511246896`*^9}, {
  3.420059982343373*^9, 3.420060000900056*^9}, {3.4200603005409184`*^9, 
  3.4200603743470464`*^9}, {3.420060415275899*^9, 3.420060447442152*^9}, {
  3.4200604810504785`*^9, 3.4200605000778384`*^9}, {3.420060547305749*^9, 
  3.4200605486076207`*^9}, {3.420060605739773*^9, 3.420060607742653*^9}, {
  3.4200607320614147`*^9, 3.4200607607025986`*^9}}]
},
WindowSize->{801, 847},
WindowMargins->{{34, Automatic}, {Automatic, 19}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 774, 22, 359, "Input"],
Cell[1345, 45, 11232, 274, 1501, "Input"]
}
]
*)

(* End of internal cache information *)
