(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15785,        387]
NotebookOptionsPosition[     14954,        356]
NotebookOutlinePosition[     15373,        372]
CellTagsIndexPosition[     15330,        369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Mathematical Principles for Scientific Computing and Visualization  \n\
http://www.farinhansford.com/books/scv\nby Gerald Farin and Dianne Hansford\n\
",
 StyleBox["\n\n",
  FontFamily->"Courier New"],
 StyleBox["Demonstration of Truncation Error:",
  FontFamily->"Courier New",
  FontSize->16,
  FontColor->RGBColor[1, 0, 0]],
 StyleBox["\n\nThis notebook illustrates that error exists in the calculation \
of trigonometric functions, such as sin(x), because they are approximated by \
polynomials.\n\nA Taylor series (or approximation) is a representation of a \
function as an infinite sum of values of its derivatives at a single \
point.(See the Wikipedia article for more information.)\n\nTypically, we look \
at derivatives at the origin (x=0).\n\nsin(x) =approx. x - x^3/3! + x^5/5! - \
x^7/7! + ....\n\nor more compactly: \nsin(x) =approx. ((-1)^{i-1}/(2i-1)!) * \
x^{2i-1} for i=1,2,3,....\n\nBelow you will find a Plot of this approximation \
along with the \"exact\" sinx function. The variable imax is the max value \
for i above: i=1,2,...,imax\n\n",
  FontFamily->"Courier New"],
 StyleBox["Try varying imax to see the variation in approximation quality.",
  FontFamily->"Courier New",
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 StyleBox["\n\nThe polynomial approximates best at the origin.\nSee the error \
at Pi in the printout below the plot.\n\n",
  FontFamily->"Courier New"],
 StyleBox["Try varying the x-value range to see how well the polynomial \
approximates farther from the origin.",
  FontFamily->"Courier New",
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 StyleBox["\n\n",
  FontFamily->"Courier New"],
 StyleBox["Another interesting artifact ",
  FontFamily->"Courier New",
  FontSlant->"Italic"],
 StyleBox["-- if you are new to plotting. Notice that when we approximate \
sinx by a cubic function (imax=2), that the true sinx function looks flat \
because of the range of y-values being plotted. See the second Plot command \
for use of \"PlotRange\" which keeps the y-range between -1 and 1 -- This \
makes the plot easier to understand.\n\n",
  FontFamily->"Courier New"],
 StyleBox["Try this: Create a new cell below, and create a plot of the Taylor \
approximation to your favorite function. See the Wikipedia page ",
  FontFamily->"Courier New",
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 "http://en.wikipedia.org/wiki/Taylor_series",
 StyleBox[" for the Taylor approximation to a number of functions.",
  FontFamily->"Courier New",
  FontColor->RGBColor[0.6, 0.4, 0.2]],
 StyleBox["\n\n",
  FontFamily->"Courier New"],
 "For more information, see Chapter 2 in Scientific Computing and \
Visualization by G. Farin and D. Hansford, AKPeters 2008.",
 StyleBox["\n\n\n",
  FontFamily->"Courier New"],
 StyleBox["DCH To Do:",
  FontFamily->"Courier New",
  FontSlant->"Italic"],
 StyleBox[" Get the print statement in the manipulate environment.",
  FontFamily->"Courier New"]
}], "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.412947732798645*^9, 3.4129477584355087`*^9}, {
   3.412948214985306*^9, 3.4129483256963606`*^9}, {3.4129485301761723`*^9, 
   3.412948549663322*^9}, {3.412948601251668*^9, 3.412948603846615*^9}, {
   3.412948676114383*^9, 3.412948710850603*^9}, {3.412949691631379*^9, 
   3.4129496921222467`*^9}, {3.4129498464549327`*^9, 
   3.4129498774296613`*^9}, {3.4131160488946514`*^9, 3.413116156218976*^9}, {
   3.4131168334427757`*^9, 3.413116891065634*^9}, {3.4131175123089375`*^9, 
   3.413117558815811*^9}, {3.4131175924341516`*^9, 3.4131176362271233`*^9}, {
   3.4131177161520495`*^9, 3.413117781125477*^9}, {3.4131178638344064`*^9, 
   3.4131179981375246`*^9}, {3.4131180371936846`*^9, 
   3.4131181156965666`*^9}, {3.4131188270694704`*^9, 3.413118828191083*^9}, {
   3.4131199573947983`*^9, 3.413119999945984*^9}, {3.413120069816453*^9, 
   3.413120147177693*^9}, {3.413208293627715*^9, 3.4132082942986803`*^9}, 
   3.4270425596178846`*^9},
 Magnification->1.5],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x_", ",", " ", "imax_"}], "]"}], " ", ":=", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "i"}], "-", "1"}], ")"}], "!"}]}], ")"}], 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "i"}], "-", "1"}], ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "imax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "imax"}], "]"}], ",", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "4"}], "Pi"}], ",", " ", 
         RowBox[{"4", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"imax", ",", "2"}], "}"}], ",", "2", ",", "15", ",", "1"}], 
      "}"}]}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"imaxx", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Compare values at PI for imax=\>\"", ",", "imaxx"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<  Sin[Pi]=\>\"", ",", 
     RowBox[{"Sin", "[", "Pi", "]"}], ",", "\"\<  Approximation=\>\"", ",", 
     RowBox[{"N", "[", 
      RowBox[{"f", "[", 
       RowBox[{"Pi", ",", " ", "imaxx"}], "]"}], "]"}]}], "]"}]}]}]], "Input",\

 CellChangeTimes->{{3.4129469654252157`*^9, 3.4129470339537554`*^9}, {
   3.412947152173747*^9, 3.412947370427581*^9}, {3.412947547912792*^9, 
   3.412947591094885*^9}, {3.4129476322440543`*^9, 3.412947668416067*^9}, {
   3.412947715754136*^9, 3.412947719629709*^9}, {3.412948336717371*^9, 
   3.412948455363553*^9}, {3.412948500770114*^9, 3.4129485261184373`*^9}, {
   3.412948724376388*^9, 3.4129487707347636`*^9}, {3.412948838674281*^9, 
   3.4129488968652134`*^9}, {3.41294931901301*^9, 3.412949355707845*^9}, {
   3.412949394396203*^9, 3.4129494293179045`*^9}, {3.4129495038095217`*^9, 
   3.412949536537348*^9}, {3.4129495733123245`*^9, 3.412949607102027*^9}, {
   3.412949675352617*^9, 3.4129496791493254`*^9}, {3.4131166793311744`*^9, 
   3.413116690266899*^9}, 3.4131167713434815`*^9, {3.41311814693148*^9, 
   3.413118152369299*^9}, {3.4131365478856497`*^9, 3.4131365780990944`*^9}},
 Magnification->1.5],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`imax$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`imax$$], 2}, 2, 15, 1}}, Typeset`size$$ = {
    540., {164., 174.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`imax$573$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`imax$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`imax$$, $CellContext`imax$573$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         $CellContext`f[$CellContext`x, $CellContext`imax$$], 
         Sin[$CellContext`x]}, {$CellContext`x, (-4) Pi, 4 Pi}, PlotStyle -> 
        Thick], "Specifications" :> {{{$CellContext`imax$$, 2}, 2, 15, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{591., {221.5, 228.5}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.412949430550082*^9, 3.4129494677357845`*^9}, {
   3.412949506424142*^9, 3.412949607602912*^9}, {3.4131160123220625`*^9, 
   3.413116017519536*^9}, {3.413116690897806*^9, 3.4131166968563747`*^9}, 
   3.413116773276261*^9, 3.4131181536811857`*^9, {3.413118196172285*^9, 
   3.4131182335860834`*^9}, {3.4131361992843857`*^9, 3.4131362102301245`*^9}, 
   3.413136311696026*^9, {3.413136358132798*^9, 3.413136372193016*^9}, {
   3.4131364118099823`*^9, 3.413136426921712*^9}, {3.4131364791668367`*^9, 
   3.413136495400179*^9}, {3.413136550669653*^9, 3.4131365791606207`*^9}, 
   3.413136609364051*^9, 3.413136665855282*^9},
 Magnification->1.5],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Compare values at PI for imax=\"\>", "\[InvisibleSpace]", 
   "10"}],
  SequenceForm["Compare values at PI for imax=", 10],
  Editable->False]], "Print",
 CellChangeTimes->{{3.412949588899866*^9, 3.412949607713106*^9}, 
   3.4131160176397085`*^9, {3.413116690917835*^9, 3.413116696876403*^9}, 
   3.413116773376405*^9, 3.4131181541919203`*^9, {3.413136199344472*^9, 
   3.4131362102701826`*^9}, {3.4131365508098545`*^9, 3.4131365793008223`*^9}},
 
 Magnification->1.5],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Sin[Pi]=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"  Approximation=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "5.289182659559688`*^-10"}]}],
  SequenceForm["  Sin[Pi]=", 0, "  Approximation=", -5.289182659559688*^-10],
  Editable->False]], "Print",
 CellChangeTimes->{{3.412949588899866*^9, 3.412949607713106*^9}, 
   3.4131160176397085`*^9, {3.413116690917835*^9, 3.413116696876403*^9}, 
   3.413116773376405*^9, 3.4131181541919203`*^9, {3.413136199344472*^9, 
   3.4131362102701826`*^9}, {3.4131365508098545`*^9, 3.413136579310837*^9}},
 Magnification->1.5]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Here", " ", "is", " ", "an", " ", "example", " ", "of", " ", "the", " ", 
    "plot", " ", "with", " ", "PlotRange", " ", "set"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "imax"}], "]"}], ",", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ",", " ", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"imax", ",", "2"}], "}"}], ",", "2", ",", "15", ",", "1"}], 
      "}"}]}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.413116729943952*^9, 3.41311676244068*^9}, {
  3.4131181682521377`*^9, 3.413118171166328*^9}},
 Magnification->1.5],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`imax$$ = 8, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`imax$$], 2}, 2, 15, 1}}, Typeset`size$$ = {
    540., {171., 180.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`imax$559$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`imax$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`imax$$, $CellContext`imax$559$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         $CellContext`f[$CellContext`x, $CellContext`imax$$], 
         Sin[$CellContext`x]}, {$CellContext`x, (-2) Pi, 2 Pi}, 
        PlotRange -> {-1, 1}, PlotStyle -> Thick], 
      "Specifications" :> {{{$CellContext`imax$$, 2}, 2, 15, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{591., {227.5, 234.5}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.413116780867176*^9, {3.4131168143252864`*^9, 3.41311682002348*^9}, {
   3.4131181723380127`*^9, 3.413118187409685*^9}, {3.413136688798272*^9, 
   3.413136737989005*^9}},
 Magnification->1.5]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", "12"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.413135828771614*^9, 3.4131358373138976`*^9}, {
  3.4131359241187167`*^9, 3.413135965728549*^9}, {3.4131360575205393`*^9, 
  3.4131360591829295`*^9}}],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellChangeTimes->{
  3.4131358382652655`*^9, {3.4131359289456577`*^9, 3.413135966409528*^9}, 
   3.4131360610656366`*^9}],

Cell[BoxData["1.41421356237309504880168872421`12."], "Output",
 CellChangeTimes->{
  3.4131358382652655`*^9, {3.4131359289456577`*^9, 3.413135966409528*^9}, 
   3.41313606109568*^9}]
}, Open  ]]
},
WindowSize->{950, 730},
WindowMargins->{{Automatic, 94}, {77, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 3937, 77, 1189, "Input"],
Cell[CellGroupData[{
Cell[4530, 102, 2976, 73, 298, "Input"],
Cell[7509, 177, 2273, 42, 490, "Output"],
Cell[CellGroupData[{
Cell[9807, 223, 517, 11, 32, "Print"],
Cell[10327, 236, 632, 11, 35, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11008, 253, 1258, 34, 190, "Input"],
Cell[12269, 289, 1854, 38, 502, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14160, 332, 428, 10, 102, "Input"],
Cell[14591, 344, 162, 4, 42, "Output"],
Cell[14756, 350, 182, 3, 40, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
