(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8057,        203]
NotebookOptionsPosition[      7687,        188]
NotebookOutlinePosition[      8106,        204]
CellTagsIndexPosition[      8063,        201]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates the idea behind UTM coordinates.

A sphere and cylinder are illustrated. The sphere has been subdivided into 60 \
longitudinal wedges and 20 latitudinal slices. A UTM coordinate section is \
created with one 3 degree LONG wedge, and this is displayed as a white strip \
in the plot. This wedge can be mapped to the cylinder fairly accurately. The \
cylinder can be unfolded to a flat sheet without distortion -- and there we \
have our map!

See Chapter 3: Coordinate Systems for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.420376829463723*^9, 3.4203768518759503`*^9}, {
  3.4203768912726*^9, 3.420376915577549*^9}, {3.42037964798656*^9, 
  3.420379782610139*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SetDirectory", "[", 
       RowBox[{"ToFileName", "[", 
        RowBox[{"Extract", "[", 
         RowBox[{
          RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
           RowBox[{"NotebookInformation", "[", 
            RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
          RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
       "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\n", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Create", " ", "a", " ", "sphere", " ", "with", " ", "60", " ", "LONG", 
      " ", "section", " ", "and", " ", "20", " ", "LAT", " ", "sections"}], 
     " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"sppic", " ", "=", " ", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "\[Phi]", "]"}], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
         RowBox[{
          RowBox[{"Sin", "[", "\[Phi]", "]"}], 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
       RowBox[{"Mesh", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"60", ",", "20"}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]",
     "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Create", " ", "a", " ", "cylinder", " ", "the", " ", "touches", " ", 
      "the", " ", "sphere"}], " ", "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"cpic", " ", "=", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
         RowBox[{"Cylinder", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", "1"}], 
          "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Contact", " ", "area", " ", "is", " ", "a", " ", "wedge"}], " ",
      "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Plot", " ", "thick", " ", "line", " ", "segments", " ", "along", " ", 
      "this", " ", "wedge"}], " ", "*)"}], "\n", 
    RowBox[{
     RowBox[{"n", "=", "60"}], ";"}], "\n", 
    RowBox[{
     RowBox[{"contact", "=", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "*", 
               RowBox[{"Sin", "[", 
                FractionBox["i", "n"], "]"}]}], ",", "0", ",", 
              RowBox[{"1", "*", " ", 
               RowBox[{"Cos", "[", 
                FractionBox["i", "n"], "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", 
              RowBox[{"2", " ", "n", " ", "\[Pi]"}]}], "}"}]}], "]"}], 
          "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", "\n", 
    RowBox[{"(*", " ", 
     RowBox[{"Combine", " ", "graphics", " ", "and", " ", "display"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"sppic", ",", "cpic", ",", "contact", ",", " ", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
    "\[IndentingNewLine]", "\n", 
    RowBox[{"(*", " ", 
     RowBox[{"Output", " ", "to", " ", "postscript", " ", "file"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<UTM_coords.eps\>\"", ",", "pic"}], "]"}], " ", "*)"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.420376928976816*^9, 3.4203769375791855`*^9}, {
   3.420376993599739*^9, 3.4203770722728653`*^9}, {3.420377332677309*^9, 
   3.420377356411437*^9}, 3.4203775134172*^9, {3.4203775465348206`*^9, 
   3.4203775478767505`*^9}, {3.420377604237794*^9, 3.4203776480708227`*^9}, {
   3.4203778572816525`*^9, 3.4203779456086607`*^9}, {3.4203781044670877`*^9, 
   3.4203781070708323`*^9}, {3.4203782067141123`*^9, 3.420378207855754*^9}, {
   3.420378266570181*^9, 3.4203783013101344`*^9}, {3.4203783368211966`*^9, 
   3.4203784379365935`*^9}, {3.4203784770928974`*^9, 
   3.4203784817696223`*^9}, {3.4203785422565985`*^9, 
   3.4203786008107953`*^9}, {3.4203786990120015`*^9, 
   3.4203787156058626`*^9}, {3.4203788707088895`*^9, 3.420378877728984*^9}, {
   3.4203789891291695`*^9, 3.420379050357211*^9}, {3.4203791856517553`*^9, 
   3.4203792056505117`*^9}, {3.420379287097627*^9, 3.4203793164999056`*^9}, {
   3.420379348225525*^9, 3.420379361775008*^9}, {3.420379415722581*^9, 
   3.4203794665156174`*^9}, {3.420379584625451*^9, 3.4203796298004093`*^9}, {
   3.4203797887990384`*^9, 3.420379850557843*^9}, {3.4204033094500737`*^9, 
   3.420403339703576*^9}, {3.4204033821946754`*^9, 3.4204034261979485`*^9}, {
   3.420403488717848*^9, 3.4204034968495407`*^9}, {3.420403689526597*^9, 
   3.4204037215927057`*^9}, {3.420403811291686*^9, 3.420403829387707*^9}, {
   3.420403904595851*^9, 3.420403938935229*^9}, 3.420403970480589*^9, {
   3.420404005541003*^9, 3.4204040083650637`*^9}}]
},
WindowSize->{787, 881},
WindowMargins->{{117, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 892, 23, 267, "Input"],
Cell[1463, 46, 6220, 140, 735, "Input"]
}
]
*)

(* End of internal cache information *)
