(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94546,       1615]
NotebookOptionsPosition[     94056,       1596]
NotebookOutlinePosition[     94475,       1612]
CellTagsIndexPosition[     94432,       1609]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the plotting of a bilinear function.
Here we define the bilinear function by specifying z-values at (0,0), (0,1), \
(1,0), (1,1).

Because the given four points do not lie in a plane, the resulting bilinear \
surface is not a plane. Examine the curve on the function that follows one of \
the corner-to-corner diagonals. Obviously it is not linear; what degree is \
it?

Figure 11.6 was created with this notebook.

See Chapter 11: Computing with Multivariate Functionsfor details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{
  3.4263617945818787`*^9, {3.4263618325765123`*^9, 3.426361865714162*^9}, {
   3.426362115964003*^9, 3.426362163532403*^9}, {3.4263623634298415`*^9, 
   3.426362382306986*^9}, {3.426362534085232*^9, 3.426362541646104*^9}, {
   3.4263626504125023`*^9, 3.426362728965456*^9}, {3.426362804403931*^9, 
   3.4263629149028206`*^9}, {3.4263629588460083`*^9, 3.4263629792853985`*^9}},
 
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "files", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Choose", " ", "the", " ", "z"}], "-", 
     RowBox[{
     "values", " ", "at", " ", "the", " ", "four", " ", "corners", " ", "of", 
      " ", "the", " ", "rectangular", " ", "region", " ", "of", " ", "this", 
      " ", "bilinear", " ", "function"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"z00", " ", "corresponds", " ", "to", " ", "x"}], "=", "0"}], 
     ",", " ", 
     RowBox[{"y", "=", 
      RowBox[{"0.", " ", "Others", " ", "follow", " ", "similarly"}]}]}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z00", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z01", "=", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z10", "=", 
     RowBox[{"-", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z11", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "the", " ", "bilinear", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"See", " ", "equation", " ", "11.6", " ", "for", " ", "details"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
      "z00_", ",", "z01_", ",", "z10_", ",", "z11_", ",", "x_", ",", "y_"}], 
      "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "y"}], ")"}], "*", "z00"}], " ", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "*", "y", "*", "z01"}], "+", " ", 
      RowBox[{"x", "*", 
       RowBox[{"(", 
        RowBox[{"1", "-", "y"}], ")"}], "*", "z10"}], "+", " ", 
      RowBox[{"x", "*", "y", "*", "z11"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "function"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
       "z00", ",", "z01", ",", "z10", ",", "z11", ",", "x", ",", "y"}], "]"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", " ", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0.7", ",", 
         RowBox[{"-", "1"}], ",", "0.7"}], "}"}]}], ",", " ", 
      RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "the", " ", "plot", " ", "to", " ", "a", " ", "postscript",
      " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<bilinex.eps\>\"", ",", "pic"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4263619132625327`*^9, 3.4263619794176593`*^9}, {
  3.426362028908824*^9, 3.426362084849262*^9}, {3.4263623369417534`*^9, 
  3.4263623377729487`*^9}, {3.4263625584803104`*^9, 3.426362636662731*^9}, {
  3.4263627503862576`*^9, 3.4263627839645405`*^9}, {3.4263629921038303`*^9, 
  3.4263629944171567`*^9}, {3.426363032982611*^9, 3.426363043938365*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nXl4TGf7x1NrqVZVSsQSan5K7ZW2oWReRSWUtpZKiV0rllENtWstLd5a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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mgf8V9P/x++553OkpJJEQ2SEaO+StCSUpDLS0jAyU1llj7ISlVFaGjSs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         "]], Polygon3DBox[CompressedData["
1:eJwtmgPYHVcXRueee25t27bd1LaNpFbqNnVqpUiT2rbtpnZqm3+t1PrX6jvP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         "]], Polygon3DBox[CompressedData["
1:eJwt13fAjWUbAPDzHu+bpBDyRUM+UVTUJ6vsmV0ZUSizFGkYKRkfGakQaYhU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         "]], 
        Polygon3DBox[{{900, 1058, 613, 716, 1278, 899}, {1280, 902, 901, 1279,
          717, 718}, {910, 1062, 615, 724, 1284, 909}, {1282, 904, 903, 1281, 
         719, 720}, {1149, 1148, 765, 473, 474, 766}}]}]}, {}, {}, {}}, {
     Line3DBox[{312, 1, 308, 267, 805, 16, 819, 31, 834, 46, 849, 61, 864, 76,
       879, 91, 895, 896, 106, 924, 121, 935, 136, 945, 151, 956, 166, 971, 
      181, 986, 196, 1187, 297, 314, 211, 310, 302, 512, 212, 513, 213, 514, 
      214, 515, 215, 516, 216, 517, 217, 518, 519, 218, 520, 219, 521, 220, 
      522, 221, 523, 222, 524, 223, 525, 224, 802, 299, 315, 225, 311, 303, 
      1013, 210, 999, 195, 984, 180, 969, 165, 954, 150, 943, 135, 933, 120, 
      922, 921, 105, 892, 90, 877, 75, 862, 60, 847, 45, 832, 30, 1156, 269, 
      313, 15, 309, 301, 343, 14, 341, 13, 339, 12, 337, 11, 335, 10, 333, 9, 
      331, 8, 328, 327, 7, 325, 6, 323, 5, 321, 4, 319, 3, 317, 2, 803, 300, 
      312}], {Line3DBox[{805, 1154, 526, 804, 1289, 1014, 806, 1290, 1015, 
       807, 1291, 1016, 808, 1292, 1017, 809, 1293, 1018, 810, 1294, 1189, 
       1382, 811, 1295, 1019, 812, 1296, 1020, 813, 1297, 1021, 814, 1298, 
       1022, 815, 1299, 1023, 816, 1300, 1024, 817, 1490, 1155, 1025, 1156}], 
      Line3DBox[{819, 1190, 1383, 818, 541, 820, 1301, 1026, 821, 1302, 1027, 
       822, 1303, 1028, 823, 1304, 1029, 824, 1305, 1191, 1384, 825, 1192, 
       1385, 826, 1306, 1030, 827, 1307, 1031, 828, 1308, 1032, 829, 1309, 
       1033, 830, 1310, 1034, 831, 1311, 1035, 832}], 
      Line3DBox[{834, 1193, 1386, 833, 1194, 1387, 835, 557, 836, 1312, 1036, 
       837, 1313, 1037, 838, 1314, 1038, 839, 1315, 1195, 1388, 840, 1196, 
       1389, 841, 1197, 1390, 842, 1316, 1039, 843, 1317, 1040, 844, 1318, 
       1041, 845, 1319, 1042, 846, 1320, 1043, 847}], 
      Line3DBox[{849, 1198, 1391, 848, 1199, 1392, 850, 1200, 1393, 851, 573, 
       852, 1321, 1044, 853, 1322, 1045, 854, 1323, 1201, 1394, 855, 1202, 
       1395, 856, 1203, 1396, 857, 1204, 1397, 858, 1324, 1046, 859, 1325, 
       1047, 860, 1326, 1048, 861, 1327, 1049, 862}], 
      Line3DBox[{864, 1205, 1398, 863, 1206, 1399, 865, 1207, 1400, 866, 1208,
        1401, 867, 709, 1103, 868, 1328, 1050, 869, 1329, 1209, 1402, 870, 
       1210, 1403, 871, 1211, 1404, 872, 1212, 1405, 873, 1213, 1406, 874, 
       1330, 1051, 875, 1331, 1052, 876, 1332, 1053, 877}], 
      Line3DBox[{879, 1214, 1407, 878, 1215, 1408, 880, 1104, 1409, 1276, 881,
        1105, 1410, 1106, 882, 1277, 1411, 1107, 883, 714, 1108, 884, 1333, 
       1216, 1412, 885, 1217, 1413, 886, 1218, 1414, 887, 1219, 1415, 888, 
       1220, 1416, 889, 1221, 1417, 890, 1334, 1054, 891, 1335, 1055, 892}], 
      Line3DBox[{896, 1336, 1056, 894, 1337, 1057, 898, 1110, 1338, 1058, 900,
        1113, 1339, 1059, 902, 1280, 1340, 1158, 1060, 904, 1282, 1341, 1159, 
       1061, 906, 1283, 1342, 1160, 614, 908, 1118, 1343, 1062, 910, 1344, 
       1063, 912, 1345, 1064, 914, 1346, 1065, 916, 1347, 1066, 918, 1348, 
       1067, 920, 1350, 1069, 922}], 
      Line3DBox[{921, 1068, 1349, 919, 1428, 1228, 917, 1427, 1227, 915, 1426,
        1226, 913, 1425, 1225, 911, 1424, 1224, 909, 1284, 1423, 1117, 907, 
       1472, 1116, 721, 905, 1115, 1157, 1491, 1281, 903, 1114, 1422, 1279, 
       901, 1112, 1421, 1111, 899, 1278, 1420, 1109, 897, 1419, 1223, 893, 
       1418, 1222, 895}], 
      Line3DBox[{924, 1229, 1429, 923, 1351, 1070, 925, 1119, 1352, 1071, 926,
        1120, 1353, 1072, 1161, 1285, 1354, 1163, 1073, 1162, 1286, 1355, 
       1165, 1074, 1164, 1492, 1121, 1167, 1230, 1473, 1166, 1122, 626, 927, 
       1356, 1075, 928, 1357, 1076, 929, 1358, 1077, 930, 1359, 1078, 931, 
       1360, 1079, 932, 1361, 1080, 933}], 
      Line3DBox[{935, 1231, 1430, 934, 634, 936, 1123, 1362, 1081, 937, 1124, 
       1363, 1082, 1168, 1287, 1364, 1170, 1083, 1169, 1493, 1125, 1172, 1084,
        1171, 1494, 1126, 1174, 1232, 1474, 1173, 1127, 1233, 1475, 1175, 
       1128, 638, 938, 1365, 1085, 939, 1366, 1086, 940, 1367, 1087, 941, 
       1368, 1088, 942, 1369, 1089, 943}], 
      Line3DBox[{945, 1234, 1431, 944, 1235, 1432, 946, 1236, 1433, 947, 1129,
        1370, 1090, 1176, 1495, 1130, 1178, 1091, 1177, 1496, 1131, 1181, 
       1092, 1180, 1497, 1132, 1184, 1237, 1476, 1183, 1133, 1238, 1477, 948, 
       1134, 1239, 1478, 949, 1135, 650, 950, 1371, 1093, 951, 1372, 1094, 
       952, 1373, 1095, 953, 1374, 1096, 954}], 
      Line3DBox[{956, 1240, 1434, 955, 1241, 1435, 957, 1242, 1436, 958, 1243,
        1437, 959, 1479, 1136, 1179, 1137, 960, 1480, 1138, 1182, 1139, 961, 
       1482, 1140, 1185, 1141, 1481, 962, 1142, 1143, 1483, 963, 1144, 1145, 
       1484, 964, 1244, 1438, 965, 663, 966, 1375, 1097, 967, 1376, 1098, 968,
        1377, 1099, 969}], 
      Line3DBox[{971, 1245, 1439, 970, 1246, 1440, 972, 1247, 1441, 973, 1248,
        1442, 974, 1249, 1443, 975, 1485, 1146, 1147, 976, 1487, 1148, 1149, 
       1486, 977, 1150, 1151, 1488, 978, 1152, 1153, 1489, 979, 1250, 1444, 
       980, 1251, 1445, 981, 677, 982, 1378, 1100, 983, 1379, 1101, 984}], 
      Line3DBox[{986, 1252, 1446, 985, 1253, 1447, 987, 1254, 1448, 988, 1255,
        1449, 989, 1256, 1450, 990, 1257, 1451, 991, 1380, 1258, 1452, 992, 
       1259, 1453, 993, 1260, 1454, 994, 1261, 1455, 995, 1262, 1456, 996, 
       1263, 1457, 997, 693, 998, 1381, 1102, 999}], 
      Line3DBox[{1013, 1188, 800, 1012, 1471, 1275, 1011, 1470, 1274, 1010, 
       1469, 1273, 1009, 1468, 1272, 1008, 1467, 1271, 1007, 1466, 1270, 1006,
        1465, 1464, 1269, 1005, 1463, 1268, 1004, 1462, 1267, 1003, 1461, 
       1266, 1002, 1460, 1265, 1001, 1459, 1264, 1000, 1288, 1458, 1186, 
       1187}]}, {
      Line3DBox[{317, 527, 1289, 318, 541, 346, 1387, 556, 361, 1392, 571, 
       376, 1399, 586, 391, 1408, 600, 406, 1419, 612, 1337, 420, 623, 1351, 
       432, 634, 444, 1432, 645, 456, 1435, 656, 468, 1440, 668, 483, 1447, 
       681, 498, 1459, 696, 513}], 
      Line3DBox[{319, 528, 1290, 320, 542, 1301, 347, 557, 362, 1393, 572, 
       377, 1400, 587, 392, 1409, 711, 601, 407, 1420, 716, 613, 1338, 421, 
       725, 624, 1352, 433, 734, 635, 1362, 445, 1433, 646, 457, 1436, 657, 
       469, 1441, 669, 484, 1448, 682, 499, 1460, 697, 514}], 
      Line3DBox[{321, 529, 1291, 322, 543, 1302, 348, 558, 1312, 363, 573, 
       378, 1401, 588, 393, 1410, 228, 408, 1421, 232, 1339, 422, 238, 1353, 
       434, 244, 1363, 446, 250, 1370, 458, 1437, 658, 470, 1442, 670, 485, 
       1449, 683, 500, 1461, 698, 515}], 
      Line3DBox[{323, 530, 1292, 324, 544, 1303, 349, 559, 1313, 364, 574, 
       1321, 379, 709, 710, 394, 1411, 712, 713, 409, 1422, 717, 718, 1340, 
       774, 726, 777, 727, 1354, 779, 735, 784, 736, 1364, 786, 744, 792, 
       1495, 745, 794, 754, 1479, 755, 471, 1443, 671, 486, 1450, 684, 501, 
       1462, 699, 516}], 
      Line3DBox[{325, 531, 1293, 326, 545, 1304, 350, 560, 1314, 365, 575, 
       1322, 380, 589, 1328, 395, 714, 715, 773, 1491, 719, 720, 1341, 775, 
       728, 778, 729, 1355, 781, 737, 785, 1493, 738, 788, 746, 793, 1496, 
       747, 796, 756, 1480, 757, 472, 763, 1485, 764, 487, 1451, 685, 502, 
       1463, 700, 517}], 
      Line3DBox[{327, 532, 1294, 329, 546, 1305, 351, 561, 1315, 366, 576, 
       1323, 381, 590, 1329, 396, 602, 1333, 410, 721, 723, 1342, 776, 730, 
       780, 1492, 732, 783, 739, 787, 1494, 741, 790, 748, 795, 1497, 750, 
       798, 758, 1482, 760, 473, 765, 1487, 767, 488, 686, 1380, 503, 1464, 
       701, 518}], 
      Line3DBox[{331, 534, 1295, 332, 1385, 548, 353, 1389, 563, 368, 1395, 
       578, 383, 1403, 592, 398, 1413, 604, 412, 1423, 724, 615, 1343, 424, 
       733, 626, 436, 742, 791, 1475, 637, 448, 751, 1477, 648, 460, 761, 
       1483, 660, 475, 768, 1488, 673, 490, 1453, 688, 505, 1466, 703, 520}], 
      Line3DBox[{333, 535, 1296, 334, 549, 1306, 354, 1390, 564, 369, 1396, 
       579, 384, 1404, 593, 399, 1414, 605, 413, 1424, 616, 1344, 425, 627, 
       1356, 437, 743, 638, 449, 752, 1478, 649, 461, 762, 1484, 661, 476, 
       769, 1489, 674, 491, 1454, 689, 506, 1467, 704, 521}], 
      Line3DBox[{335, 536, 1297, 336, 550, 1307, 355, 565, 1316, 370, 1397, 
       580, 385, 1405, 594, 400, 1415, 606, 414, 1425, 617, 1345, 426, 628, 
       1357, 438, 639, 1365, 450, 753, 650, 462, 1438, 662, 477, 1444, 675, 
       492, 1455, 690, 507, 1468, 705, 522}], 
      Line3DBox[{337, 537, 1298, 338, 551, 1308, 356, 566, 1317, 371, 581, 
       1324, 386, 1406, 595, 401, 1416, 607, 415, 1426, 618, 1346, 427, 629, 
       1358, 439, 640, 1366, 451, 651, 1371, 463, 663, 478, 1445, 676, 493, 
       1456, 691, 508, 1469, 706, 523}], 
      Line3DBox[{339, 538, 1299, 340, 552, 1309, 357, 567, 1318, 372, 582, 
       1325, 387, 596, 1330, 402, 1417, 608, 416, 1427, 619, 1347, 428, 630, 
       1359, 440, 641, 1367, 452, 652, 1372, 464, 664, 1375, 479, 677, 494, 
       1457, 692, 509, 1470, 707, 524}], 
      Line3DBox[{341, 539, 1300, 342, 553, 1310, 358, 568, 1319, 373, 583, 
       1326, 388, 597, 1331, 403, 609, 1334, 417, 1428, 620, 1348, 429, 631, 
       1360, 441, 642, 1368, 453, 653, 1373, 465, 665, 1376, 480, 678, 1378, 
       495, 693, 510, 1471, 708, 525}], 
      Line3DBox[{343, 771, 1490, 772, 344, 554, 1311, 359, 569, 1320, 374, 
       584, 1327, 389, 598, 1332, 404, 610, 1335, 418, 621, 1349, 1350, 430, 
       632, 1361, 442, 643, 1369, 454, 654, 1374, 466, 666, 1377, 481, 679, 
       1379, 496, 694, 1381, 511, 800, 801, 802}], 
      Line3DBox[{512, 695, 799, 1458, 497, 680, 1446, 482, 667, 1439, 467, 
       655, 1434, 455, 644, 1431, 443, 633, 1430, 431, 622, 1429, 419, 1336, 
       611, 1418, 405, 599, 1407, 390, 585, 1398, 375, 570, 1391, 360, 555, 
       1386, 345, 540, 1383, 316, 526, 770, 803}], 
      Line3DBox[{519, 702, 1465, 504, 687, 1452, 489, 672, 1486, 766, 474, 
       659, 1481, 759, 459, 647, 1476, 797, 749, 447, 636, 1474, 789, 740, 
       435, 625, 1473, 782, 731, 423, 614, 1472, 722, 411, 603, 1412, 397, 
       591, 1402, 382, 577, 1394, 367, 562, 1388, 352, 547, 1384, 330, 533, 
       1382, 328}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJxke3dcjv/3fwslO1HJyk4aGiKcNBUqJaQkEQqJRFKSJkJJGZVCVIpSSVRO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    "]],
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 284.8975008626987},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 1}, {0, 1}, {-1.999999571428597, 0.9999996428571686}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{0.7, -1, 0.7},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.426362768171832*^9, 3.4263627850761395`*^9}, 
   3.4263630091883965`*^9, 3.4263630459712877`*^9}],

Cell[BoxData["\<\"bilinex.eps\"\>"], "Output",
 CellChangeTimes->{{3.426362768171832*^9, 3.4263627850761395`*^9}, 
   3.4263630091883965`*^9, 3.4263630465320945`*^9}]
}, Open  ]]
},
WindowSize->{819, 743},
WindowMargins->{{56, Automatic}, {Automatic, 14}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1121, 28, 357, "Input"],
Cell[CellGroupData[{
Cell[1714, 53, 4082, 103, 621, "Input"],
Cell[5799, 158, 88072, 1431, 387, "Output"],
Cell[93874, 1591, 166, 2, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
