(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8691,        247]
NotebookOptionsPosition[      8162,        228]
NotebookOutlinePosition[      8581,        244]
CellTagsIndexPosition[      8538,        241]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates plotting of bivariate functions: z = f(x,y).
One must choose the domain over which to evaluate -- min and max x and y \
values.

Also in this notebook is a contour of a bivariate function. This is a plot of \
the point set where f(x,y) = constant. 

Figure 11.1 was created with this notebook.

See Chapter 11: Computing with Multivariate Functionsfor details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4204843565290513`*^9, 3.420484371270248*^9}, {
  3.420490289730576*^9, 3.4204903019882016`*^9}, {3.4205619570943747`*^9, 
  3.4205620692356253`*^9}, {3.426361740834594*^9, 3.4263617615944448`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "files", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"Sin", "[", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], "]"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "it", " ", "over", " ", "a", " ", "particular", " ", 
     "domain"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "a", " ", "postscript", " ", "file"}], " ", "*)"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<funct_example.eps\>\"", ",", "%"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4204903061642065`*^9, 3.420490372319333*^9}, {
  3.4204904037845774`*^9, 3.4204904098332753`*^9}, {3.420490739016618*^9, 
  3.420490741630376*^9}}],

Cell["\<\

Now change the domain -- here it is a small piece of what was plotted above.
The function looks fairly diferent!\
\>", "Input",
 CellChangeTimes->{{3.420490424724688*^9, 3.4204904589839506`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
     RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}], "\n", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<funct_exampe2.eps\>\"", ",", "%"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4204904130378833`*^9, 3.4204904224313903`*^9}, {
  3.4204907164241314`*^9, 3.420490733488669*^9}}],

Cell["\<\

Let's look at the contour plot of the function -- over the domain in the \
first plot.
In this plot, we plot the contours at 15 different z-levels.

(This plot differs from what is in the book because the implementation in 6.0 \
differs from 5.2.

Mathematica's default setting for the number of subdivisions to allow in the \
calculation of the contour is\
\>", "Input",
 CellChangeTimes->{{3.420490498560859*^9, 3.4204905893013377`*^9}, {
  3.4204907826493587`*^9, 3.420490808676784*^9}, {3.42049092499404*^9, 
  3.420490951241782*^9}},
 FormatType->"TextForm"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"contplot", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "15"}], ",", 
     RowBox[{"ContourShading", "\[Rule]", "True"}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Here", " ", "is", " ", "an", " ", "effort", " ", "to", " ", "make", " ", 
    "the", " ", "contour", " ", "less", " ", "smooth", " ", "as", " ", "in", 
    " ", "the", " ", 
    RowBox[{"text", " ", "--"}], " ", "no", " ", 
    RowBox[{"luck", "!"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"contplot2", "=", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], ",", 
       FractionBox["\[Pi]", "2"]}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "15"}], ",", 
     RowBox[{"ContourShading", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<contoursshaded.eps\>\"", ",", "contplot"}], "]"}], ";"}], 
   " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.420490653073037*^9, 3.420490710836096*^9}, {
  3.4204908194923363`*^9, 3.42049082585148*^9}, {3.420490873820456*^9, 
  3.420490920127042*^9}, {3.420552324633576*^9, 3.4205523299211793`*^9}, {
  3.4205523865926685`*^9, 3.420552386602683*^9}, {3.4205524573343906`*^9, 
  3.420552521666896*^9}, {3.4205619292042704`*^9, 3.420561937726525*^9}}]
},
WindowSize->{722, 867},
WindowMargins->{{40, Automatic}, {Automatic, 27}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 821, 22, 395, "Input"],
Cell[1392, 45, 2576, 66, 491, "Input"],
Cell[3971, 113, 231, 6, 85, "Input"],
Cell[4205, 121, 1145, 28, 247, "Input"],
Cell[5353, 151, 574, 15, 158, "Input"],
Cell[5930, 168, 2228, 58, 292, "Input"]
}
]
*)

(* End of internal cache information *)
