(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28235,        724]
NotebookOptionsPosition[     27451,        696]
NotebookOutlinePosition[     27890,        713]
CellTagsIndexPosition[     27847,        710]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the box and whiskers plot or boxplot. Suppose we \
are given k data values m_1, ...m_k. This is a tool to visualize these data \
with five numbers:
-- the median
-- the upper and lower quartile 
-- the upper and lower whiskers (smallest and largest non-outlier \
observation)
These elements are described in the notebook below.

Points outside of the whiskers are considered to be outliers. The whiskers \
are formed by offsetting the upper and lower quartile by a fraction of their \
difference.

Figures 12.17 and 12.14 were created with this notebook.

See Chapter 12 : Visualization of Empirical Data for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.426878510752056*^9, 3.4268785349768896`*^9}, {
  3.426879506984568*^9, 3.42687953282172*^9}, {3.4268795712970448`*^9, 
  3.4268796338369727`*^9}, {3.426879755321659*^9, 3.426879877417224*^9}, {
  3.4268799157223043`*^9, 3.4268799664352255`*^9}, {3.4268808159868207`*^9, 
  3.426880834623619*^9}, {3.426881301985653*^9, 3.426881308955675*^9}, {
  3.4268813682008657`*^9, 3.4268813856459503`*^9}, {3.426881509514064*^9, 
  3.426881530173771*^9}, {3.426881624028728*^9, 3.4268816882110176`*^9}, {
  3.426882304877741*^9, 3.4268823328279314`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", " ", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"set", " ", "folder", " ", "for", " ", "output"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", " ", "dense"}]}]}]}]}]}]}]}], " ", "data", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"set", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}]}], "-"}], "  ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"datadense", "=", 
      RowBox[{"{", 
       RowBox[{
       "0.4`", ",", "0.41`", ",", "0.43`", ",", "0.44`", ",", "0.48`", ",", 
        "0.49`", ",", "0.5`", ",", "0.55`", ",", "0.51`", ",", "0.52`", ",", 
        "0.525`", ",", "0.53`", ",", "0.6`", ",", "0.63`", ",", "0.64`", ",", 
        "0.65`", ",", "0.66`", ",", "0.68`", ",", "0.7`", ",", "0.71`", ",", 
        "0.72`", ",", "0.73`"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Number of points in first (rather uniformly dense) data set = \>\"", 
     ",", 
     RowBox[{"Length", "[", "datadense", "]"}]}], " ", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "bring", " ", "the", " ", "data", " ", "set", " ", "into", " ", "a", " ", 
     "form", " ", "for", " ", "plotting"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"joindatadense", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
          "datadense", "\[LeftDoubleBracket]", "k", 
           "\[RightDoubleBracket]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", 
          RowBox[{"Length", "[", "datadense", "]"}]}], "}"}]}], "]"}]}], 
     ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "data", " ", 
     "values"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g1dense", "=", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"joindatadense", ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"PointSize", "[", "0.02", "]"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Axes", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"False", ",", "True"}], "}"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], 
           ",", 
           RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
        RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "the", " ", "corresponding", " ", "box", " ", "and", " ", 
     "whiskers", " ", "plot"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g2dense", "=", 
      RowBox[{"BoxWhiskerPlot", "[", 
       RowBox[{"datadense", ",", 
        RowBox[{"BoxOutliers", "\[Rule]", "All"}], ",", 
        RowBox[{"BoxFillingStyle", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], 
           ",", 
           RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
        RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "the", " ", "plots", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"gdense", "=", 
      RowBox[{"GraphicsRow", "[", 
       RowBox[{"{", 
        RowBox[{"g1dense", ",", "g2dense"}], "}"}], "]"}]}], ";"}], ")"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Now", " ", "display", " ", "it"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"gdense", ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], "]"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", " ", "biased"}]}]}]}]}]}]}]}], " ", "data", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"set", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}]}], "-"}], "  ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"databiased", "=", 
      RowBox[{"{", 
       RowBox[{
       "0.4`", ",", "0.405`", ",", "0.41`", ",", "0.415`", ",", "0.42`", ",", 
        "0.425`", ",", "0.43`", ",", "0.435`", ",", "0.44`", ",", "0.45`", 
        ",", "0.46`", ",", "0.47`", ",", "0.48`", ",", "0.485`", ",", "0.49`",
         ",", "0.5`", ",", "0.51`", ",", "0.6`", ",", "0.61`", ",", "0.62`", 
        ",", "0.63`", ",", "0.7`"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Number of points in second (biased) data set = \>\"", ",", 
     RowBox[{"Length", "[", "databiased", "]"}]}], " ", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Demonstrates an outlier\>\"", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"joindatabiased", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
          "databiased", "\[LeftDoubleBracket]", "k", 
           "\[RightDoubleBracket]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", 
          RowBox[{"Length", "[", "databiased", "]"}]}], "}"}]}], "]"}]}], 
     ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g1biased", "=", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"joindatabiased", ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"PointSize", "[", "0.02", "]"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"Axes", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"False", ",", "True"}], "}"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], 
           ",", 
           RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
        RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"g2biased", "=", 
      RowBox[{"BoxWhiskerPlot", "[", 
       RowBox[{"databiased", ",", 
        RowBox[{"BoxOutliers", "\[Rule]", "All"}], ",", 
        RowBox[{"BoxFillingStyle", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], 
           ",", 
           RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
        RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
        RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"gbiased", "=", 
      RowBox[{"GraphicsRow", "[", 
       RowBox[{"{", 
        RowBox[{"g1biased", ",", "g2biased"}], "}"}], "]"}]}], ";"}], ")"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"gbiased", ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], "]"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"gall", "=", 
      RowBox[{"(", 
       TagBox[
        RowBox[{
        "\[SkeletonIndicator]", "GraphicsArray", "\[SkeletonIndicator]"}],
        False,
        Editable->False], ")"}]}], ";"}], " ", "*)"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"-", " ", "show"}]}]}], " ", "three", " ", 
     RowBox[{
      RowBox[{"experiments", " ", "--"}], "--"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datam", " ", "=", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "3"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Three data sets with 20 values from a random number generator\>\"", 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"exper", " ", "=", " ", 
     RowBox[{"BoxWhiskerPlot", "[", 
      RowBox[{"datam", ",", " ", 
       RowBox[{"BoxFillingStyle", "\[Rule]", 
        RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
       RowBox[{"BoxLabels", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<data set 1\>\"", ",", " ", "\"\<data set 2\>\"", ",", " ", 
          "\"\<data set 3\>\""}], "}"}]}], ",", " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"exper", ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], "]"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", " ", "output"}]}]}]}]}]}]}]}], " ", "to", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"files", " ", "--"}], "--"}], "--"}], "--"}], "--"}], 
       "--"}]}], "-"}], "  ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{"\"\<bwplot_biasdata.eps\>\"", ",", "g1biased"}], "]"}], ";"}],
      ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{"\"\<bwplot_bias.eps\>\"", ",", "g2biased"}], "]"}], ";"}], 
     ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{"\"\<bwplot_densedata.eps\>\"", ",", "g1dense"}], "]"}], ";"}],
      ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{"\"\<bwplot_dense.eps\>\"", ",", "g2dense"}], "]"}], ";"}], 
     ")"}]}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<bwplot_exper.eps\>\"", ",", "exper"}], "]"}], ";"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.4083729628903522`*^9, 3.4083729688088627`*^9}, {
   3.408373116931853*^9, 3.408373155186861*^9}, {3.408377513934432*^9, 
   3.408377516958781*^9}, {3.408377860462715*^9, 3.4083778608532767`*^9}, {
   3.4083779472875633`*^9, 3.4083779650731373`*^9}, {3.408378029245413*^9, 
   3.4083780364758096`*^9}, {3.408378119585315*^9, 3.408378156738739*^9}, {
   3.4083782475292892`*^9, 3.4083782639328766`*^9}, {3.408378394690898*^9, 
   3.4083783962231007`*^9}, 3.4083784626185727`*^9, 3.408378576542387*^9, 
   3.408378691117138*^9, {3.4083787504023857`*^9, 3.408378782087947*^9}, {
   3.408378868311931*^9, 3.408378870915675*^9}, {3.408378907267947*^9, 
   3.408378983617733*^9}, {3.408379202542531*^9, 3.4083792936335135`*^9}, 
   3.4083797632087297`*^9, {3.408379830615656*^9, 3.4083799175005903`*^9}, {
   3.408380258110363*^9, 3.4083802979576607`*^9}, {3.4083803431626625`*^9, 
   3.4083804481736608`*^9}, {3.4083805499600224`*^9, 3.408380621272565*^9}, {
   3.408380659106968*^9, 3.40838066090956*^9}, {3.4083807098098755`*^9, 
   3.408380793770605*^9}, {3.4083808984411135`*^9, 3.408380943666144*^9}, {
   3.4083810244823523`*^9, 3.4083810372306833`*^9}, {3.4083811881476912`*^9, 
   3.4083812157674065`*^9}, {3.426881713787795*^9, 3.4268818410808334`*^9}, {
   3.42688187903541*^9, 3.426881882750752*^9}, {3.426881954684187*^9, 
   3.4268820415691214`*^9}, {3.4268820720329266`*^9, 3.426882196321645*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of points in first (rather uniformly dense) data set = \
\"\>", "\[InvisibleSpace]", "22"}],
  SequenceForm[
  "Number of points in first (rather uniformly dense) data set = ", 22],
  Editable->False]], "Print",
 CellChangeTimes->{3.4268821622125983`*^9, 3.426882197002624*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, 
       {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
        PointBox[{{0., 0.4}, {0., 0.41}, {0., 0.43}, {0., 0.44}, {0., 0.48}, {
         0., 0.49}, {0., 0.5}, {0., 0.55}, {0., 0.51}, {0., 0.52}, {0., 
         0.525}, {0., 0.53}, {0., 0.6}, {0., 0.63}, {0., 0.64}, {0., 0.65}, {
         0., 0.66}, {0., 0.68}, {0., 0.7}, {0., 0.71}, {0., 0.72}, {0., 
         0.73}}]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{False, True},
      AxesOrigin->{0, 0.4},
      BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
      ColorOutput->GrayLevel,
      DisplayFunction:>Identity,
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {192., -152.90421193686507`},
      ImageScaled[{0.5, 0.5}], {360., 291.2461179749811}], InsetBox[
     GraphicsBox[{
       {GrayLevel[0.7], 
        PolygonBox[{{0.75, 0.49}, {1.25, 0.49}, {1.25, 0.66}, {0.75, 0.66}, {
         0.75, 0.49}}]}, 
       {GrayLevel[0], 
        LineBox[{{0.75, 0.49}, {1.25, 0.49}, {1.25, 0.66}, {0.75, 0.66}, {
         0.75, 0.49}}], LineBox[{{0.88, 0.4}, {1.12, 0.4}}], 
        LineBox[{{1, 0.4}, {1, 0.49}}], LineBox[{{1, 0.66}, {1, 0.73}}], 
        LineBox[{{0.88, 0.73}, {1.12, 0.73}}], 
        LineBox[{{0.75, 0.54}, {1.25, 0.54}}]}},
      AlignmentPoint->Center,
      AspectRatio->1,
      Axes->False,
      AxesLabel->None,
      AxesOrigin->Automatic,
      AxesStyle->{},
      Background->None,
      BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
      BaselinePosition->Automatic,
      ColorOutput->GrayLevel,
      ContentSelectable->Automatic,
      DisplayFunction->Identity,
      Epilog->{},
      FormatType:>TraditionalForm,
      Frame->True,
      FrameLabel->None,
      FrameStyle->{},
      FrameTicks->{None, Automatic, None, None},
      FrameTicksStyle->{},
      GridLines->None,
      GridLinesStyle->{},
      ImageMargins->0.,
      ImagePadding->All,
      ImageSize->Automatic,
      LabelStyle->{},
      Method->Automatic,
      PlotLabel->None,
      PlotRange->{{0.5, 1.5}, All},
      PlotRangeClipping->False,
      PlotRangePadding->Automatic,
      PlotRegion->Automatic,
      PreserveImageOptions->Automatic,
      Prolog->{},
      RotateLabel->True,
      Ticks->Automatic,
      TicksStyle->{}], {576., -152.90421193686507`}, 
     ImageScaled[{0.5, 0.5}], {360., 291.2461179749811}]}, {}},
  ContentSelectable->True,
  DisplayFunction->Identity,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.4083806221738605`*^9, 3.4083806619210143`*^9, {3.408380784116723*^9, 
   3.408380794782059*^9}, 3.4083810406856513`*^9, 3.4083812316101875`*^9, 
   3.4268818878681107`*^9, 3.4268819560962176`*^9, 3.426882162252656*^9, 
   3.4268821970426817`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of points in second (biased) data set = \"\>", 
   "\[InvisibleSpace]", "22"}],
  SequenceForm["Number of points in second (biased) data set = ", 22],
  Editable->False]], "Print",
 CellChangeTimes->{3.4268821622125983`*^9, 3.426882197082739*^9}],

Cell[BoxData["\<\"Demonstrates an outlier\"\>"], "Print",
 CellChangeTimes->{3.4268821622125983`*^9, 3.426882197102768*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, 
       {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
        PointBox[{{0., 0.4}, {0., 0.405}, {0., 0.41}, {0., 0.415}, {0., 
         0.42}, {0., 0.425}, {0., 0.43}, {0., 0.435}, {0., 0.44}, {0., 
         0.45}, {0., 0.46}, {0., 0.47}, {0., 0.48}, {0., 0.485}, {0., 0.49}, {
         0., 0.5}, {0., 0.51}, {0., 0.6}, {0., 0.61}, {0., 0.62}, {0., 
         0.63}, {0., 0.7}}]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{False, True},
      AxesOrigin->{0, 0.4},
      BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
      ColorOutput->GrayLevel,
      DisplayFunction:>Identity,
      PlotRange->{All, All},
      PlotRangeClipping->True,
      PlotRangePadding->{Automatic, Automatic}], {192., -152.90421193686507`},
      ImageScaled[{0.5, 0.5}], {360., 291.2461179749811}], InsetBox[
     GraphicsBox[{
       {GrayLevel[0.7], 
        PolygonBox[{{0.75, 0.425}, {1.25, 0.425}, {1.25, 0.51}, {0.75, 
         0.51}, {0.75, 0.425}}]}, 
       {GrayLevel[0], 
        LineBox[{{0.75, 0.425}, {1.25, 0.425}, {1.25, 0.51}, {0.75, 0.51}, {
         0.75, 0.425}}], LineBox[{{0.88, 0.4}, {1.12, 0.4}}], 
        LineBox[{{1, 0.4}, {1, 0.425}}], LineBox[{{1, 0.51}, {1, 0.63}}], 
        LineBox[{{0.88, 0.63}, {1.12, 0.63}}], 
        GraphicsComplexBox[{{1., 0.7}, {1., 0.7}}, {
          {Hue[0.67, 0.6, 0.6], InsetBox[
            StyleBox["\<\"\[FilledCircle]\"\>",
             StripOnInput->False,
             FontSize->8.96], 1], InsetBox[
            StyleBox["\<\"\[FilledCircle]\"\>",
             StripOnInput->False,
             FontSize->8.96], 2]}, {}}], 
        LineBox[{{0.75, 0.46499999999999997`}, {1.25, 
         0.46499999999999997`}}]}},
      AlignmentPoint->Center,
      AspectRatio->1,
      Axes->False,
      AxesLabel->None,
      AxesOrigin->Automatic,
      AxesStyle->{},
      Background->None,
      BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
      BaselinePosition->Automatic,
      ColorOutput->GrayLevel,
      ContentSelectable->Automatic,
      DisplayFunction->Identity,
      Epilog->{},
      FormatType:>TraditionalForm,
      Frame->True,
      FrameLabel->None,
      FrameStyle->{},
      FrameTicks->{None, Automatic, None, None},
      FrameTicksStyle->{},
      GridLines->None,
      GridLinesStyle->{},
      ImageMargins->0.,
      ImagePadding->All,
      ImageSize->Automatic,
      LabelStyle->{},
      Method->Automatic,
      PlotLabel->None,
      PlotRange->{{0.5, 1.5}, All},
      PlotRangeClipping->False,
      PlotRangePadding->Automatic,
      PlotRegion->Automatic,
      PreserveImageOptions->Automatic,
      Prolog->{},
      RotateLabel->True,
      Ticks->Automatic,
      TicksStyle->{}], {576., -152.90421193686507`}, 
     ImageScaled[{0.5, 0.5}], {360., 291.2461179749811}]}, {}},
  ContentSelectable->True,
  DisplayFunction->Identity,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.4083806221738605`*^9, 3.4083806619210143`*^9, {3.408380784116723*^9, 
   3.408380794782059*^9}, 3.4083810406856513`*^9, 3.4083812316101875`*^9, 
   3.4268818878681107`*^9, 3.4268819560962176`*^9, 3.426882162252656*^9, 
   3.4268821971828833`*^9}],

Cell[BoxData["\<\"Three data sets with 20 values from a random number \
generator\"\>"], "Print",
 CellChangeTimes->{3.4268821622125983`*^9, 3.426882197232955*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0.7], 
     PolygonBox[{{0.75, 0.38052617168455893`}, {1.25, 0.38052617168455893`}, {
      1.25, 0.8446909984127033}, {0.75, 0.8446909984127033}, {0.75, 
      0.38052617168455893`}}]}, 
    {GrayLevel[0], 
     LineBox[{{0.75, 0.38052617168455893`}, {1.25, 0.38052617168455893`}, {
      1.25, 0.8446909984127033}, {0.75, 0.8446909984127033}, {0.75, 
      0.38052617168455893`}}], 
     LineBox[{{0.88, 0.059291224336858406`}, {1.12, 0.059291224336858406`}}], 
     LineBox[{{1, 0.059291224336858406`}, {1, 0.38052617168455893`}}], 
     LineBox[{{1, 0.8446909984127033}, {1, 0.990009403110476}}], 
     LineBox[{{0.88, 0.990009403110476}, {1.12, 0.990009403110476}}], 
     LineBox[{{0.75, 0.5024890124001351}, {1.25, 0.5024890124001351}}]}}, {
    {GrayLevel[0.7], 
     PolygonBox[{{1.75, 0.330888988890478}, {2.25, 0.330888988890478}, {2.25, 
      0.6643926170964061}, {1.75, 0.6643926170964061}, {1.75, 
      0.330888988890478}}]}, 
    {GrayLevel[0], 
     LineBox[{{1.75, 0.330888988890478}, {2.25, 0.330888988890478}, {2.25, 
      0.6643926170964061}, {1.75, 0.6643926170964061}, {1.75, 
      0.330888988890478}}], 
     LineBox[{{1.88, 0.007894057505799301}, {2.12, 0.007894057505799301}}], 
     LineBox[{{2, 0.007894057505799301}, {2, 0.330888988890478}}], 
     LineBox[{{2, 0.6643926170964061}, {2, 0.9968217030580098}}], 
     LineBox[{{1.88, 0.9968217030580098}, {2.12, 0.9968217030580098}}], 
     LineBox[{{1.75, 0.46958650674982927`}, {2.25, 
      0.46958650674982927`}}]}}, {
    {GrayLevel[0.7], 
     PolygonBox[{{2.75, 0.15653990586871802`}, {3.25, 0.15653990586871802`}, {
      3.25, 0.5962011749874108}, {2.75, 0.5962011749874108}, {2.75, 
      0.15653990586871802`}}]}, 
    {GrayLevel[0], 
     LineBox[{{2.75, 0.15653990586871802`}, {3.25, 0.15653990586871802`}, {
      3.25, 0.5962011749874108}, {2.75, 0.5962011749874108}, {2.75, 
      0.15653990586871802`}}], 
     LineBox[{{2.88, 0.02775612055466614}, {3.12, 0.02775612055466614}}], 
     LineBox[{{3, 0.02775612055466614}, {3, 0.15653990586871802`}}], 
     LineBox[{{3, 0.5962011749874108}, {3, 0.8149093671076526}}], 
     LineBox[{{2.88, 0.8149093671076526}, {3.12, 0.8149093671076526}}], 
     LineBox[{{2.75, 0.3929725930598258}, {3.25, 0.3929725930598258}}]}}},
  AlignmentPoint->Center,
  AspectRatio->0.5555555555555556,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  BaselinePosition->Automatic,
  ColorOutput->GrayLevel,
  ContentSelectable->Automatic,
  DisplayFunction->Identity,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->True,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["\"data set 1\"", TraditionalForm]}, {2, 
      FormBox["\"data set 2\"", TraditionalForm]}, {3, 
      FormBox["\"data set 3\"", TraditionalForm]}}, Automatic, None, None},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.5, 3.5}, All},
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{
  3.4083806221738605`*^9, 3.4083806619210143`*^9, {3.408380784116723*^9, 
   3.408380794782059*^9}, 3.4083810406856513`*^9, 3.4083812316101875`*^9, 
   3.4268818878681107`*^9, 3.4268819560962176`*^9, 3.426882162252656*^9, 
   3.426882197283027*^9}],

Cell[BoxData[
 SuperscriptBox["Null", "4"]], "Output",
 CellChangeTimes->{
  3.4083806221738605`*^9, 3.4083806619210143`*^9, {3.408380784116723*^9, 
   3.408380794782059*^9}, 3.4083810406856513`*^9, 3.4083812316101875`*^9, 
   3.4268818878681107`*^9, 3.4268819560962176`*^9, 3.426882162252656*^9, 
   3.4268821974933295`*^9}]
}, Open  ]]
},
WindowSize->{793, 900},
WindowMargins->{{6, Automatic}, {Automatic, 12}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1425, 33, 415, "Input"],
Cell[CellGroupData[{
Cell[2018, 58, 14360, 354, 2117, "Input"],
Cell[16381, 414, 333, 7, 27, "Print"],
Cell[16717, 423, 2856, 73, 223, "Output"],
Cell[CellGroupData[{
Cell[19598, 500, 302, 6, 27, "Print"],
Cell[19903, 508, 123, 1, 27, "Print"]
}, Open  ]],
Cell[20041, 512, 3254, 82, 223, "Output"],
Cell[23298, 596, 163, 2, 27, "Print"],
Cell[23464, 600, 3643, 85, 292, "Output"],
Cell[27110, 687, 325, 6, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
