(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19886,        517]
NotebookOptionsPosition[     19515,        502]
NotebookOutlinePosition[     19933,        518]
CellTagsIndexPosition[     19890,        515]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates B-spline basis functions as illustrated in Figures \
8.8 and 8.9.
A recursive definition of B-spline basis function is used. This is defined in \
Eqn (8.10-11).

Input: 
The degree n (set to 3 here)
The knot vector u -- see how it is set below.

Output:
Plots of the 6 basis function for the knot vector we have selected.

The plots are hard-coded for the five functions we wanted to illustrate here. \
You can improve the code by making this more flexible for an arbitrary  input \
knot vector.

See Chapter 8: Data Fitting for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4259280528548765`*^9, 3.4259281278727474`*^9}, {
   3.4259291598166094`*^9, 3.425929354837035*^9}, {3.4259318492538304`*^9, 
   3.425931898114088*^9}, 3.425932387097211*^9},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "zero", " ", "tolerance"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eps", "=", 
     RowBox[{"5.0", "^", 
      RowBox[{"-", "9"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "functions", " ", "building", " ", "the", " ", "piecewise",
      " ", "polynomials"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "If", " ", "a", " ", "knot", " ", "interval", " ", "is", " ", "not", 
       " ", "zero"}], "-", "length"}], ",", " ", 
     RowBox[{
     "then", " ", "calculate", " ", "the", " ", "relative", " ", "position", 
      " ", "of", " ", "the", " ", "insertion", " ", "point", " ", "within", 
      " ", "the", " ", "given", " ", "interval"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"spanleft", "[", 
      RowBox[{"n_", ",", "knots_", ",", "i_", ",", "x_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"knots", "\[LeftDoubleBracket]", 
           RowBox[{"i", "+", "n", "+", "1"}], "\[RightDoubleBracket]"}], "-", 
          
          RowBox[{"knots", "\[LeftDoubleBracket]", 
           RowBox[{"i", "+", "1"}], "\[RightDoubleBracket]"}]}], "]"}], "<", 
        "eps"}], ",", "0", ",", 
       FractionBox[
        RowBox[{"x", "-", 
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "1"}], "\[RightDoubleBracket]"}]}], 
        RowBox[{
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "n", "+", "1"}], "\[RightDoubleBracket]"}], "-", 
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "1"}], "\[RightDoubleBracket]"}]}]]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"spanright", "[", 
      RowBox[{"n_", ",", "knots_", ",", "i_", ",", "x_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"knots", "\[LeftDoubleBracket]", 
           RowBox[{"i", "+", "n", "+", "2"}], "\[RightDoubleBracket]"}], "-", 
          
          RowBox[{"knots", "\[LeftDoubleBracket]", 
           RowBox[{"i", "+", "2"}], "\[RightDoubleBracket]"}]}], "]"}], "<", 
        "eps"}], ",", "0", ",", 
       FractionBox[
        RowBox[{
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "n", "+", "2"}], "\[RightDoubleBracket]"}], "-", 
         "x"}], 
        RowBox[{
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "n", "+", "2"}], "\[RightDoubleBracket]"}], "-", 
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "2"}], "\[RightDoubleBracket]"}]}]]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Recursive", " ", "definition", " ", "of", " ", "a", " ", "B"}], 
     "-", "spline"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"bspline", "[", 
      RowBox[{"n_", ",", "knots_", ",", "i_", ",", "x_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "\[GreaterEqual]", 
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "1"}], "\[RightDoubleBracket]"}]}], "&&", 
        RowBox[{"x", "<", 
         RowBox[{"knots", "\[LeftDoubleBracket]", 
          RowBox[{"i", "+", "2"}], "\[RightDoubleBracket]"}]}]}], ",", "1", 
       ",", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"bspline", "[", 
      RowBox[{"n_", ",", "knots_", ",", "i_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"spanleft", "[", 
         RowBox[{"n", ",", "knots", ",", "i", ",", "x"}], "]"}], " ", 
        RowBox[{"bspline", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", "knots", ",", "i", ",", "x"}], 
         "]"}]}], "+", 
       RowBox[{
        RowBox[{"spanright", "[", 
         RowBox[{"n", ",", "knots", ",", "i", ",", "x"}], "]"}], " ", 
        RowBox[{"bspline", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", "knots", ",", 
          RowBox[{"i", "+", "1"}], ",", "x"}], "]"}]}]}], "/;", 
      RowBox[{"n", ">", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Here", " ", "are", " ", "two", " ", "know", " ", 
     RowBox[{"vectors", " ", "--"}], " ", "from", " ", "Figures", " ", "8.8", 
     " ", "and", " ", "8.9"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", "=", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "1.333`", ",", "1.7`", ",", 
         "2.`", ",", "2.`", ",", "2.`", ",", "2.1`"}], "}"}]}], ";"}], ")"}], 
    " ", "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"u", "=", 
      RowBox[{"{", 
       RowBox[{
       "0", ",", "0", ",", "0", ",", "0", ",", "0.6666`", ",", "1.3333`", ",",
         "2.`", ",", "2.`", ",", "2.`", ",", "2.1`"}], "}"}]}], ";"}], ")"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Establish", " ", "some", " ", "relationships", " ", "between", " ", 
      "the", " ", "degree", " ", "of", " ", "the", " ", "polynomials"}], ",", 
     " ", 
     RowBox[{
     "the", " ", "number", " ", "of", " ", "knot", " ", "intervals", " ", 
      "and", " ", "the", " ", "number", " ", "of", " ", "polynomials"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "k", " ", "is", " ", "really", " ", "a", " ", "function", " ", "of", " ", 
     "the", " ", 
     RowBox[{"degree", " ", "--"}], " ", "hard", " ", "coded", " ", "to", " ",
      "three", " ", "here"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k", "=", 
     RowBox[{
      RowBox[{"Length", "[", "u", "]"}], "-", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Compute", " ", "number", " ", "of", " ", "basis", " ", 
      RowBox[{"functions", " ", "--"}], " ", "there", " ", "are", " ", "l"}], 
     "+", 
     RowBox[{"1", " ", "of", " ", "them"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l", "=", 
     RowBox[{"k", "-", "n", "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Input  \>\"", "]"}], " ", "\[IndentingNewLine]",
    
   RowBox[{"Print", "[", 
    RowBox[{"\"\<knot vector = \>\"", ",", "u"}], "]"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<degree n=\>\"", ",", "n"}], "]"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<knots u_0, ... ,u_k  where k=\>\"", ",", "k"}], "]"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<basis fcts N_0, ... N_l where l=\>\"", ",", "l"}], "]"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "each", " ", "of", " ", "the", " ", "B"}], "-", 
     RowBox[{"spline", " ", "functions"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"For", " ", "our", " ", "example", " ", "above"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
       "we", " ", "know", " ", "that", " ", "there", " ", "are", " ", "0"}], 
       " ", "..."}], "5", " ", "of", " ", "them"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fct0", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"bspline", "[", 
       RowBox[{"n", ",", "u", ",", "0", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"u", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
            "\[RightDoubleBracket]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fct1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"bspline", "[", 
       RowBox[{"n", ",", "u", ",", "1", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"u", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
            "\[RightDoubleBracket]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fct2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"bspline", "[", 
       RowBox[{"n", ",", "u", ",", "2", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"u", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
            "\[RightDoubleBracket]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fct3", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"bspline", "[", 
       RowBox[{"n", ",", "u", ",", "3", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"u", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
            "\[RightDoubleBracket]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fct4", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"bspline", "[", 
       RowBox[{"n", ",", "u", ",", "4", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"u", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
            "\[RightDoubleBracket]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fct5", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"bspline", "[", 
       RowBox[{"n", ",", "u", ",", "5", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"u", "\[LeftDoubleBracket]", 
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
         "\[RightDoubleBracket]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"u", "\[LeftDoubleBracket]", 
            RowBox[{
             RowBox[{"Length", "[", "u", "]"}], "-", "1"}], 
            "\[RightDoubleBracket]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "them", " ", "all", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plt", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
      "fct0", ",", "fct1", ",", "fct2", ",", "fct3", ",", "fct4", ",", 
       "fct5"}], "}"}], "]"}]}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<bspls_uniform.eps\>\"", ",", "plt"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.4259281442563057`*^9, 3.4259282402944016`*^9}, {
  3.4259282865108576`*^9, 3.425928325206499*^9}, {3.425928366315611*^9, 
  3.4259283702312417`*^9}, {3.4259284199427233`*^9, 3.425928519876421*^9}, {
  3.4259285799728355`*^9, 3.4259286445456867`*^9}, {3.425928720895472*^9, 
  3.425928750878586*^9}, {3.425928814109507*^9, 3.425928817754749*^9}, {
  3.4259288627594624`*^9, 3.425928941132157*^9}, {3.4259289890110035`*^9, 
  3.425929005524749*^9}, {3.425929062406541*^9, 3.4259291409194365`*^9}, {
  3.426013617403681*^9, 3.4260138285973625`*^9}}]
},
WindowSize->{842, 800},
WindowMargins->{{82, Automatic}, {Automatic, 2}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 974, 30, 413, "Input"],
Cell[1545, 53, 17966, 447, 2109, "Input"]
}
]
*)

(* End of internal cache information *)
