(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45215,        856]
NotebookOptionsPosition[     44723,        837]
NotebookOutlinePosition[     45142,        853]
CellTagsIndexPosition[     45099,        850]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates cancellation errors with the function \
(1-cosx)/x^2.
This function is plotted over [-10,10] and over a small interval around x=0.


See Chapter 2: Computational Basics for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.419642634120288*^9, 3.419642795872877*^9}, {
  3.4204043838449774`*^9, 3.420404384986619*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "our", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1.0", "-", 
          RowBox[{"Cos", "[", "x", "]"}]}], ")"}], "/", 
        RowBox[{"x", "^", "2"}]}], ",", "300"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "function", " ", 
     RowBox[{"over", " ", "[", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "10"}], "]"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fplot1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], ",", " ", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{" ", 
     RowBox[{
      RowBox[{
      "Plot", " ", "the", " ", "function", " ", "over", " ", "a", " ", 
       "small", " ", 
       RowBox[{"interval", " ", "--"}]}], " ", "+", 
      RowBox[{
       RowBox[{"/", 
        RowBox[{"-", " ", "5"}]}], "*", 
       RowBox[{"10", "^", 
        RowBox[{"{", 
         RowBox[{"-", "8"}]}]}]}]}], ")"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"fplot2", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"N", "[", 
        RowBox[{"x", ",", "30"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"-", "5"}], "*", 
         RowBox[{"10", "^", 
          RowBox[{"-", "8"}]}]}], ",", 
        RowBox[{"5", "*", 
         RowBox[{"10", "^", 
          RowBox[{"-", "8"}]}]}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], ",", " ", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", "  ", 
      
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<cancellation1.eps\>\"", ",", "fplot1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<cancellation2.eps\>\"", ",", "fplot2"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4087968148316927`*^9, 3.408796815322398*^9}, {
   3.408796882128461*^9, 3.4087968862243505`*^9}, {3.4087969189313807`*^9, 
   3.4087969244893727`*^9}, {3.4087969667000685`*^9, 
   3.4087969728689394`*^9}, {3.419642809342245*^9, 3.4196430049635344`*^9}, 
   3.4196430395232286`*^9, {3.419643095203293*^9, 3.4196431065395937`*^9}, {
   3.419643432748659*^9, 3.4196434440949745`*^9}, {3.419643582183536*^9, 
   3.4196436115157137`*^9}, {3.4196436819670177`*^9, 3.419643699301944*^9}, {
   3.419643730486786*^9, 3.419643731418125*^9}, {3.419643774710376*^9, 
   3.4196437918950863`*^9}, 3.4196438532833586`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.], Thickness[0.01], 
    StyleBox[LineBox[CompressedData["
1:eJw1m3c41f///4WUyB7nmGdEVshqGI9nUVEqkdUyMkqKiBR5JyokMs8xKlsp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      "]],
     FontColor->GrayLevel[0.]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  PlotRange->{{-10, 10}, {0., 0.4999999012783211}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{3.40879692737352*^9, 3.40879697669444*^9, 
  3.4196430479553537`*^9, 3.4196431073107023`*^9, 3.4196434339403725`*^9, 
  3.4196436218305454`*^9, 3.4196437004135427`*^9, 3.4196437320590467`*^9, 
  3.4196437946991186`*^9, 3.4196438551159935`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.], Thickness[0.01], 
    StyleBox[LineBox[CompressedData["
1:eJxFm3k0lO///xGhkHZtUkmbSpIWXC/7ln3flzGrZK+UQkIlRWUtpSRpoxAt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      "]],
     FontColor->GrayLevel[0.]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  PlotRange->NCache[{{
      Rational[-1, 20000000], 
      Rational[1, 20000000]}, {0., 0.9993829641977678}}, {{-5.*^-8, 5.*^-8}, {
    0., 0.9993829641977678}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{3.40879692737352*^9, 3.40879697669444*^9, 
  3.4196430479553537`*^9, 3.4196431073107023`*^9, 3.4196434339403725`*^9, 
  3.4196436218305454`*^9, 3.4196437004135427`*^9, 3.4196437320590467`*^9, 
  3.4196437946991186`*^9, 3.4196438551660657`*^9}]
}, Open  ]]
},
WindowSize->{828, 770},
WindowMargins->{{52, Automatic}, {Automatic, 23}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 515, 17, 245, "Input"],
Cell[CellGroupData[{
Cell[1108, 42, 5763, 145, 622, "Input"],
Cell[6874, 189, 17964, 305, 261, "Output"],
Cell[24841, 496, 19866, 338, 264, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
