(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33158,        620]
NotebookOptionsPosition[     32672,        601]
NotebookOutlinePosition[     33091,        617]
CellTagsIndexPosition[     33048,        614]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook demonstrates function spaces
Two cubic curves are combined linearly to form another cubic curve.


See Chapter 7: Background: Numerical Calculus for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.419970801272045*^9, 3.419970823614171*^9}, {
  3.419970960050357*^9, 3.4199709984956384`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"fctplot", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["x", "3"]}], "-", 
         RowBox[{"2", " ", "x"}], "+", "2"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["x", "3"]}], "+", 
         RowBox[{"2", " ", "x"}], "-", "2"}], ",", " ", 
        SuperscriptBox["x", "3"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", " ", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<comb_cubic.eps\>\"", ",", "fctplot"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4199710360796814`*^9, 3.4199710960158653`*^9}, {
   3.419971134030528*^9, 3.419971148651552*^9}, {3.419971182480195*^9, 
   3.4199712154876575`*^9}, {3.4200569932853184`*^9, 3.420056995528544*^9}, 
   3.4200570491456413`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.7], Thickness[0.01], LineBox[CompressedData["
1:eJwt2Xk4VN8fB3DMqKiMFkXoW0K+SFRSUp9bSaXIni3J0p6oSCUkUVkqqVD2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     "]]}, 
   {GrayLevel[0.7], Thickness[0.01], LineBox[CompressedData["
1:eJwt2Xk0lN8bAHDbDCGyZClFoiKJshcXJSkpCllDpahQUZIQ0mpplyTRomiR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     "]]}, 
   {GrayLevel[0.], Thickness[0.01], 
    StyleBox[LineBox[CompressedData["
1:eJwt2Xc4Ft4XAPAihJKkUMjeK5Go3pOUNGQkGZERSqQksmdmZGVkJ2TvzN4j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      "]],
     FontColor->GrayLevel[0.]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.0025]],
  ColorOutput->CMYKColor,
  PlotRange->{{-1, 1}, {-2.7698003204583284`, 3.9999995918367546`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{3.419971101794174*^9, 3.4199711502538557`*^9, 
  3.419971186485955*^9, 3.420057060511986*^9}],

Cell[BoxData["\<\"comb_cubic.eps\"\>"], "Output",
 CellChangeTimes->{3.419971101794174*^9, 3.4199711502538557`*^9, 
  3.419971186485955*^9, 3.4200570605620575`*^9}]
}, Open  ]]
},
WindowSize->{654, 837},
WindowMargins->{{52, Automatic}, {Automatic, 16}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 503, 17, 245, "Input"],
Cell[CellGroupData[{
Cell[1096, 42, 2650, 67, 328, "Input"],
Cell[3749, 111, 28740, 483, 248, "Output"],
Cell[32492, 596, 164, 2, 40, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
