(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18584,        493]
NotebookOptionsPosition[     18212,        478]
NotebookOutlinePosition[     18631,        494]
CellTagsIndexPosition[     18588,        491]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook compares Euler's and Huen's methods for solving an initial \
value ODE problem.  
Problem: Slope field  y' = f(x,y) = y - 0.4x^2 with initial value (-2, 0.76) \
using 50 sampled points


We compare the solution using 10 steps and 30 steps.
Compare solution with the solution using Huen's method in Huen.nb.

See Chapter 9: Computing Dynamic Processes for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4196224217663507`*^9, 3.4196224895938816`*^9}, {
   3.419622564842083*^9, 3.4196226610704527`*^9}, {3.4196244125289264`*^9, 
   3.419624422152765*^9}, 3.4196244869859905`*^9, {3.4201155059171696`*^9, 
   3.4201155064379187`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Input", " ", "a", " ", "package", " ", "for", " ", "vector", " ", 
    "fields"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Set", " ", "the", " ", "output", " ", "folder", " ", "to", " ", "be", 
     " ", "the", " ", "one", " ", "this", " ", "files", " ", "lives", " ", 
     "in"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Create", " ", "a", " ", "vector", " ", "field", " ", 
      RowBox[{"(", 
       RowBox[{"f_x", ",", " ", "f_y"}], ")"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", ",", " ", 
        RowBox[{"y", " ", "-", " ", 
         RowBox[{"0.4", 
          RowBox[{"x", "^", "2"}]}]}]}], ")"}], " ", 
      RowBox[{"over", " ", "[", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "]"}], 
      RowBox[{"x", "[", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "]"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vecfield", "=", 
     RowBox[{"(", 
      RowBox[{"VectorFieldPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"y", "-", 
           RowBox[{"0.4`", " ", 
            SuperscriptBox["x", "2"]}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"BaseStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], 
           ",", 
           RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
        RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}], ")"}]}], 
    ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"VectorFieldPlots`", "  ", "HeadLength"}], "\[Rule]", "0"}], 
     ","}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Get", " ", "\"\<exact\>\"", " ", "solution", " ", "for", " ", 
      RowBox[{"y", "'"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"y", " ", "-", " ", 
       RowBox[{"0.4", 
        RowBox[{"x", "^", "2"}], " ", "for", " ", 
        RowBox[{"y", "[", 
         RowBox[{"-", "2"}], "]"}]}]}], " ", "=", " ", 
      RowBox[{"0.76", " ", "over", " ", "x", " ", 
       RowBox[{"in", " ", "[", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "]"}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol2", "=", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "-", 
           RowBox[{"0.4`", " ", 
            SuperscriptBox["x", "2"]}]}]}], ",", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"-", "2"}], "]"}], "\[Equal]", "0.76`"}]}], "}"}], ",", 
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Load", " ", "function", " ", "for", " ", "plotting"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol2", "=", 
     RowBox[{"sol2", "\[LeftDoubleBracket]", 
      RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}]}], " ", 
    ";"}], "\n", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Euler", "'"}], "s", " ", "method"}], " ", "*)"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"euler", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xold", "=", "x0"}], ",", 
        RowBox[{"yold", "=", "y0"}], ",", 
        RowBox[{"sollist", "=", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",",
         "h"}], "}"}], ",", 
      RowBox[{
       RowBox[{"h", "=", 
        RowBox[{"N", "[", 
         FractionBox[
          RowBox[{"xn", "-", "x0"}], "steps"], "]"}]}], ";", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"xnew", "=", 
           RowBox[{"xold", "+", "h"}]}], ";", 
          RowBox[{"ynew", "=", 
           RowBox[{"yold", "+", 
            RowBox[{"h", " ", 
             RowBox[{"(", 
              RowBox[{"f", "/.", "\[InvisibleSpace]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"x", "\[Rule]", "xold"}], ",", 
                 RowBox[{"y", "\[Rule]", "yold"}]}], "}"}]}], ")"}]}]}]}], 
          ";", 
          RowBox[{"sollist", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"sollist", ",", 
             RowBox[{"{", 
              RowBox[{"xnew", ",", "ynew"}], "}"}]}], "]"}]}], ";", 
          RowBox[{"xold", "=", "xnew"}], ";", 
          RowBox[{"yold", "=", "ynew"}]}], ",", 
         RowBox[{"{", "steps", "}"}]}], "]"}], ";", 
       RowBox[{"Return", "[", "sollist", "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Huen", "'"}], "s", " ", "method"}], " ", "*)"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"heun", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"x_", ",", "x0_", ",", "xn_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y_", ",", "y0_"}], "}"}], ",", "steps_"}], "]"}], ":=", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xold", "=", "x0"}], ",", 
        RowBox[{"yold", "=", "y0"}], ",", 
        RowBox[{"sollist", "=", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"x0", ",", "y0"}], "}"}], "}"}]}], ",", "x", ",", "y", ",",
         "h"}], "}"}], ",", 
      RowBox[{
       RowBox[{"h", "=", 
        RowBox[{"N", "[", 
         FractionBox[
          RowBox[{"xn", "-", "x0"}], "steps"], "]"}]}], ";", 
       RowBox[{"Do", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"xnew", "=", 
           RowBox[{"xold", "+", "h"}]}], ";", 
          RowBox[{"ynew1", "=", 
           RowBox[{"yold", "+", 
            RowBox[{"h", " ", 
             RowBox[{"(", 
              RowBox[{"f", "/.", "\[InvisibleSpace]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"x", "\[Rule]", "xold"}], ",", 
                 RowBox[{"y", "\[Rule]", "yold"}]}], "}"}]}], ")"}]}]}]}], 
          ";", 
          RowBox[{"oldslope", "=", 
           RowBox[{"f", "/.", "\[InvisibleSpace]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "\[Rule]", "xold"}], ",", 
              RowBox[{"y", "\[Rule]", "yold"}]}], "}"}]}]}], ";", 
          RowBox[{"newslope", "=", 
           RowBox[{"f", "/.", "\[InvisibleSpace]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "\[Rule]", "xnew"}], ",", 
              RowBox[{"y", "\[Rule]", "ynew1"}]}], "}"}]}]}], ";", 
          RowBox[{"ynew", "=", 
           RowBox[{"yold", "+", 
            RowBox[{
             FractionBox["1", "2"], " ", "h", " ", 
             RowBox[{"(", 
              RowBox[{"oldslope", "+", "newslope"}], ")"}]}]}]}], ";", 
          RowBox[{"sollist", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"sollist", ",", 
             RowBox[{"{", 
              RowBox[{"xnew", ",", "ynew"}], "}"}]}], "]"}]}], ";", 
          RowBox[{"xold", "=", "xnew"}], ";", 
          RowBox[{"yold", "=", "ynew"}]}], ",", 
         RowBox[{"{", "steps", "}"}]}], "]"}], ";", 
       RowBox[{"Return", "[", "sollist", "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "Euler", " ", "for", " ", 
       RowBox[{"y", "'"}]}], " ", "=", " ", 
      RowBox[{"y", " ", "-", " ", 
       RowBox[{"0.4", 
        RowBox[{"x", "^", "2"}], " ", "over", " ", "x", " ", 
        RowBox[{"in", " ", "[", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "]"}]}]}]}], ",", " ", 
     RowBox[{
      RowBox[{"initial", " ", "value", " ", "y"}], " ", "=", " ", 
      RowBox[{"-", "0.76"}]}], ",", " ", 
     RowBox[{"and", " ", "50", " ", "steps"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"eulsol", "=", 
     RowBox[{"euler", "[", 
      RowBox[{
       RowBox[{"y", "-", 
        RowBox[{"0.4`", " ", 
         SuperscriptBox["x", "2"]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0.76`"}], "}"}], ",", "50"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Store", " ", "plot", " ", "of", " ", "Euler", " ", "solution"}], 
    " ", "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"eulplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"eulsol", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", " ", 
          RowBox[{"PointSize", "[", "0.02`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Solve", " ", 
     RowBox[{"Huen", "'"}], "s", " ", "method", " ", "for", " ", "the", " ", 
     "same", " ", "problem"}], " ", "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"heunsol", "=", 
     RowBox[{"heun", "[", 
      RowBox[{
       RowBox[{"y", "-", 
        RowBox[{"0.4`", " ", 
         SuperscriptBox["x", "2"]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0.76`"}], "}"}], ",", "50"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Store", " ", "plot", " ", "of", " ", 
     RowBox[{"Huen", "'"}], "s", " ", "method"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"heunplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"heunsol", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", " ", 
          RowBox[{"PointSize", "[", "0.02`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Store", " ", "plot", " ", "of", " ", "exact", " ", "solution"}], 
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"splot2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"sol2", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.05", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Store", " ", "initial", " ", "value", " ", "point"}], " ", 
    "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0.76`"}], "}"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
          RowBox[{"PointSize", "[", "0.05`", "]"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plot", " ", "Vector", " ", "field"}], ",", " ", 
     RowBox[{"initial", " ", "value", " ", "point"}], ",", " ", 
     RowBox[{"Huen", " ", "solution"}], ",", " ", 
     RowBox[{"Eurler", " ", "solution"}], ",", " ", 
     RowBox[{"and", " ", "exact"}]}], " ", "*)"}], "\n", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "vecfield", ",", "splot2", ",", " ", "points", ",", "heunplot", ",", 
        "eulplot"}], "}"}], ",", " ", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", " ", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "postscript", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<compare_ODE.eps\>\"", ",", "pic"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.419622677604227*^9, 3.419622821821602*^9}, {
   3.4196229064833393`*^9, 3.4196229457197585`*^9}, {3.419623011324093*^9, 
   3.4196230159807887`*^9}, {3.4196235821649218`*^9, 
   3.4196238977286797`*^9}, {3.4196244982121325`*^9, 3.419624531059365*^9}, {
   3.4196246627387104`*^9, 3.419624727642037*^9}, {3.419624829718816*^9, 
   3.4196250395305104`*^9}, {3.4196250905138206`*^9, 3.419625111904579*^9}, 
   3.419625177639101*^9, {3.419627233875824*^9, 3.419627240104781*^9}, 
   3.4196290336838207`*^9, {3.419629113248229*^9, 3.41962914311117*^9}, {
   3.4196292962714033`*^9, 3.4196293021698847`*^9}, {3.419641935716032*^9, 
   3.4196419384599776`*^9}, 3.419641993579235*^9, {3.419642082927712*^9, 
   3.419642097869197*^9}, {3.4196421944280415`*^9, 3.419642242737507*^9}, {
   3.419644052559904*^9, 3.4196440536014013`*^9}}]
},
WindowSize->{868, 891},
WindowMargins->{{14, Automatic}, {14, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 820, 24, 340, "Input"],
Cell[1391, 47, 16817, 429, 2057, "Input"]
}
]
*)

(* End of internal cache information *)
