(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8648,        239]
NotebookOptionsPosition[      8277,        224]
NotebookOutlinePosition[      8696,        240]
CellTagsIndexPosition[      8653,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates contouring of 3d functions.

For the function w = xyz, we can see a polygonal looking contour. This can be \
improved by increasing the number of evaluations -- delta0 should be made \
smaller.

Figures  15.5 and 15.7 were created with this notebook.

See Chapter 15 : Volume Visualization for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4269616426304927`*^9, 3.4269616560097313`*^9}, {
  3.426961747991995*^9, 3.4269617539105053`*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta0", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Create", " ", "a", " ", "trilinear", " ", "function", " ", "w"}], " ", 
     "=", " ", "xyz"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Evaluated", " ", 
     RowBox[{"over", " ", "[", 
      RowBox[{"0", ",", "1"}], "]"}], " ", "in", " ", "each", " ", "axis", 
     " ", "at", " ", "a", " ", "refinement", " ", "of", " ", "delta0"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lsttrilinear", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"x", " ", "y", " ", "z"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "1", ",", "delta0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", "1", ",", "delta0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1", ",", "delta0"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "trilinear", 
     " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g1", "=", 
     RowBox[{"ListContourPlot3D", "[", 
      RowBox[{"lsttrilinear", ",", 
       RowBox[{"DataRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Contours", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "0.001`", ",", "0.01`", ",", "0.1`", ",", "0.5`", ",", "0.8`"}], 
         "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Create", " ", "a", " ", "point", " ", "at", " ", "the", " ", "x"}], 
      "=", "1"}], ",", " ", 
     RowBox[{"y", "=", "1"}], ",", 
     RowBox[{"z", "=", 
      RowBox[{"1", " ", "corner"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"corner111", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.1`", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "the", " ", "trivariate", " ", "and", " ", "corner", " ", 
     "point", " ", "together"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"g1", ",", "corner111"}], "]"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "postscript", " ", "output"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<mcubes_xyz.eps\>\"", ",", "%"}], "]"}], "  ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Let", "'"}], "s", " ", "play", " ", "with", " ", "a", " ", 
      "different", " ", 
      RowBox[{"function", " ", "--"}], " ", "z"}], "=", " ", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "+", " ", 
      RowBox[{"y", "^", "2"}], " ", "+", " ", 
      RowBox[{"z", "^", "2"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Evaluate", " ", "the", " ", "function", " ", 
     RowBox[{"over", " ", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "]"}], " ", "in", " ", "each", " ", 
     "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lst", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"], "+", 
        SuperscriptBox["z", "2"]}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{"-", "1"}], ",", "1", ",", "delta"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1", ",", "delta"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1", ",", "delta"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "it"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ListContourPlot3D", "[", 
    RowBox[{"lst", ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Contours", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.5`", ",", "1.5`"}], "}"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<mcubes_sphere.eps\>\"", ",", "%"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4269575373173423`*^9, 3.4269578943307023`*^9}, 
   3.4269580081043005`*^9, {3.426958086627211*^9, 3.426958132413048*^9}, 
   3.4269581860702033`*^9, {3.4269583957817535`*^9, 3.426958407979293*^9}, {
   3.426961693764019*^9, 3.4269616949056606`*^9}}]
},
WindowSize->{810, 740},
WindowMargins->{{42, Automatic}, {91, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 665, 20, 286, "Input"],
Cell[1236, 43, 7037, 179, 1021, "Input"]
}
]
*)

(* End of internal cache information *)
