(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4406,        125]
NotebookOptionsPosition[      4037,        110]
NotebookOutlinePosition[      4456,        126]
CellTagsIndexPosition[      4413,        123]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates plotting of trivariate functions: w = f(x,y,z).
One must choose the domain over which to evaluate -- min and max x and y \
values.
An effective way to visualize a trivariate function is with a contour plot.

Play with the number of contour levels computed: Contours.

Figure 11.14 was created with this notebook.

See Chapter 11: Computing with Multivariate Functionsfor details.


Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4205629124080477`*^9, 3.4205629392165966`*^9}, {
   3.4205629994832563`*^9, 3.4205630110699167`*^9}, 3.4205631222197423`*^9, {
   3.4205632310462275`*^9, 3.4205632747190256`*^9}, {3.4205679472377777`*^9, 
   3.4205679764497824`*^9}, {3.4206546099991617`*^9, 
   3.4206546301281056`*^9}, {3.426365944769555*^9, 3.4263659698355985`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "the", " ", "output", " ", "folder", " ", "to", " ", "be", " ",
     "the", " ", "one", " ", "in", " ", "which", " ", "this", " ", "files", 
    " ", "lives"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]",
   
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Use", " ", "a", " ", "contour", " ", "plot", " ", "to", " ", 
     "visualize"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]",
    
   RowBox[{"pic", "=", 
    RowBox[{"ContourPlot3D", "[", 
     RowBox[{
      RowBox[{"0.3", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{"8", "x"}], "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"8", "y"}], "]"}], 
       RowBox[{"Sin", "[", 
        RowBox[{"8", "z"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", ".8"}], ",", ".8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", ".8"}], ",", ".8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", ".8"}], ",", ".8"}], "}"}], ",", 
      RowBox[{"Contours", "\[Rule]", "5"}], ",", "  ", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0.7", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "the", " ", "plot", " ", "to", " ", "a", " ", "postscript",
      " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<contours3D.eps\>\"", ",", "pic"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4205632880081344`*^9, 3.4205632882584944`*^9}, {
   3.4205633975356274`*^9, 3.4205634572815375`*^9}, {3.4205680048005486`*^9, 
   3.42056800653304*^9}, {3.4205680432458305`*^9, 3.420568045058437*^9}, 
   3.4205680848556623`*^9, {3.420569910060178*^9, 3.420569914396413*^9}, {
   3.4206545041870112`*^9, 3.420654506770726*^9}, 3.420655105020968*^9}]
},
WindowSize->{685, 750},
WindowMargins->{{23, Automatic}, {Automatic, 66}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 954, 24, 340, "Input"],
Cell[1525, 47, 2508, 61, 423, "Input"]
}
]
*)

(* End of internal cache information *)
