(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14429,        382]
NotebookOptionsPosition[     13994,        365]
NotebookOutlinePosition[     14434,        382]
CellTagsIndexPosition[     14391,        379]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates contour and density plotting.

Figures  14.12, 14.13, and  14.14were created with this notebook.

See Chapter 14 : Visualizing Scalar Values over 2D for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{
  3.4269483685933647`*^9, {3.4269485079337263`*^9, 3.426948510317154*^9}, {
   3.4269485638140783`*^9, 3.4269485825109634`*^9}, {3.4269561796350913`*^9, 
   3.426956182058576*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", 
    RowBox[{"folder", " ", "--"}], " ", "folder", " ", "this", " ", "file", 
    " ", "lives", " ", "in"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "the", " ", "function", " ", "to", " ", "contour"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"Sin", "[", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Create", " ", "a", " ", "plane", " ", "z"}], "=", 
     RowBox[{
      RowBox[{"0.9", ".", " ", "We"}], " ", "will", " ", "intersect", " ", 
      "the", " ", "surface", " ", "with", " ", "this", " ", "plane", " ", 
      "to", " ", "highlight", " ", "one", " ", "contour"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f0", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", "0.9"}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "function", 
     " ", "over", " ", "a", " ", "square", " ", "domain", " ", "with", " ", 
     RowBox[{"extentets", " ", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "pi"}], "/", "2"}], ",", 
       RowBox[{"pi", "/", "2"}]}], "]"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plot1", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", 
         FractionBox["\[Pi]", "2"]}], ",", 
        FractionBox["\[Pi]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", 
         FractionBox["\[Pi]", "2"]}], ",", 
        FractionBox["\[Pi]", "2"]}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "the", " ", "last", " ", "plot", " ", "to", " ", "a", " ", 
     "postscript", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<funct_example.eps\>\"", ",", "%"}], "]"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "contour", " ", "plot", " ", "of", " ", "the", 
     " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Play", " ", "with", " ", "the", " ", "number", " ", "of", " ", 
     "contours", " ", "displayed"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "You", " ", "can", " ", "try", " ", "changing", " ", "the", " ", 
       RowBox[{"settings", " ", "--"}], " ", "PlotPoints"}], "\[Rule]", 
      "Automatic"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", 
      RowBox[{
       RowBox[{"Automatic", " ", "--"}], " ", "to", " ", "small", " ", 
       "numbers"}]}], ",", " ", 
     RowBox[{
     "say", " ", "5", " ", "and", " ", "1", " ", "resepectively", " ", "and", 
      " ", "see", " ", "the", " ", "contours", " ", "looking", " ", "less", 
      " ", 
      RowBox[{"smooth", ".", " ", "Without"}], " ", "adequate", " ", 
      "evaluation"}], ",", " ", 
     RowBox[{
     "contouring", " ", "methods", " ", "cannot", " ", "produce", " ", 
      "accurate", " ", 
      RowBox[{"results", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numcontours", " ", "=", " ", "15"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Contour plot of the function -- \>\"", ",", "numcontours", ",", 
     "\"\< z=constant contours\>\""}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"contplot", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", 
         FractionBox["\[Pi]", "2"]}], ",", 
        FractionBox["\[Pi]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", 
         FractionBox["\[Pi]", "2"]}], ",", 
        FractionBox["\[Pi]", "2"]}], "}"}], ",", 
      RowBox[{"Contours", "\[Rule]", "numcontours"}], ",", 
      RowBox[{"ContourShading", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "Automatic"}], ",", " ", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "the", " ", "contour", " ", "plot", " ", "to", " ", "a", 
     " ", "postscript", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<contour.eps\>\"", ",", "contplot"}], "]"}], ";"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "density", " ", "plot", " ", "of", " ", "the", 
     " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Try", " ", "modifying", " ", "PlotPoints", " ", "and", " ", 
     "MaxRecusion", " ", "to", " ", "get", " ", "a", " ", "feel", " ", "for", 
     " ", "how", " ", "the", " ", "visualization", " ", "technique", " ", 
     RowBox[{"works", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Density plot of the function \>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"density", "=", 
    RowBox[{"DensityPlot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", 
         FractionBox["\[Pi]", "2"]}], ",", 
        FractionBox["\[Pi]", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", 
         FractionBox["\[Pi]", "2"]}], ",", 
        FractionBox["\[Pi]", "2"]}], "}"}], ",", " ", 
      RowBox[{"PlotPoints", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "Automatic"}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<density.eps\>\"", ",", "density"}], "]"}], ";"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Create", " ", "the", " ", "surface", " ", "z"}], "=", "0.9"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot2", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f0", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", 
          FractionBox["\[Pi]", "2"]}], ",", 
         FractionBox["\[Pi]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", 
          FractionBox["\[Pi]", "2"]}], ",", 
         FractionBox["\[Pi]", "2"]}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "5"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Combine", " ", "the", " ", "sine", " ", "function", " ", "to", " ", 
     "contour", " ", "and", " ", "the", " ", "plane", " ", "plots"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Sine function intersected with a plane producing a contour\>\"", 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\< -- 2 views -- \>\"", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Picturetop", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plot1", ",", "plot2", ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "3.384`"}], "}"}]}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Picture", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"plot1", ",", "plot2", ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.902`"}], ",", 
         RowBox[{"-", "1.902`"}], ",", "2.053`"}], "}"}]}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript", " ", "files"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<sinx2y2_plane_top.eps\>\"", ",", "Picturetop"}], "]"}], 
     ";"}], " ", "*)"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<sinx2y2_plane.eps\>\"", ",", "Picture"}], "]"}], ";"}], 
    "*)"}], " ", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4269485854752254`*^9, 3.4269489282581234`*^9}, {
  3.4269559451979876`*^9, 3.426956047384925*^9}, {3.4269560889947567`*^9, 
  3.426956101062109*^9}, {3.426956201987232*^9, 3.4269562222063055`*^9}, {
  3.4269562904043694`*^9, 3.426956325264496*^9}, {3.4269563588027215`*^9, 
  3.426956376267835*^9}, {3.426956420831915*^9, 3.426956427561592*^9}, {
  3.42695648994129*^9, 3.4269569886483955`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Let", "'"}], "s", " ", "play", " ", "with", " ", "another", " ", 
    "function"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f1", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]}], ";", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f1", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "3"}]}], "]"}]}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"DensityPlot", "[", 
    RowBox[{
     RowBox[{"f1", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "5"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4269485854752254`*^9, 3.4269489282581234`*^9}, {
  3.4269559451979876`*^9, 3.426956047384925*^9}, {3.4269560889947567`*^9, 
  3.426956101062109*^9}, {3.426956201987232*^9, 3.4269562222063055`*^9}, {
  3.4269562904043694`*^9, 3.426956325264496*^9}}]
},
WindowSize->{778, 740},
WindowMargins->{{22, Automatic}, {Automatic, 20}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 604, 18, 249, "Input"],
Cell[1175, 41, 11278, 279, 1767, "Input"],
Cell[12456, 322, 1534, 41, 159, "Input"]
}
]
*)

(* End of internal cache information *)
