(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37100,        841]
NotebookOptionsPosition[     36198,        809]
NotebookOutlinePosition[     36638,        826]
CellTagsIndexPosition[     36595,        823]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook demonstrates that decibels (log plots) are more useful than \
power for illustrating a range of noises due to their wide variation in \
value.

Figures 12.15 and 12.16 were created with this notebook.

See Chapter 12: Visualizing Empirical Data for details.

Updated May 2008
\
\>", "Input",
 CellChangeTimes->{{3.4268834229053855`*^9, 3.4268834337009087`*^9}, {
  3.42688377000449*^9, 3.4268837862077885`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "one", " ", "that", 
    " ", "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "noise", " ", "power", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"noisepower", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0.00002`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0.00006`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "0.0002`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "0.02`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0.2`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "0.6`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "6"}], "}"}]}], "}"}]}], "\n", "\[IndentingNewLine]",
    
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "noise", " ", "data", " ", "as", " ", "decibles"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"noisedb", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "60"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "80"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "90"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "110"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "plot", " ", "of", " ", "noise", " ", "data", " ", "in", 
     " ", "power", " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Noise plotted as power (Pa)\>\"", "]"}], "\n", 
   RowBox[{
   "Print", "[", "\"\<The first four values are indistinguishable\>\"", "]"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"noisepower", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.03`", "]"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Sources\>\"", ",", " ", "\"\<Pa\>\""}], "}"}]}], ",", 
      " ", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
           ",", "7", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
          "}"}]}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", " ", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", "  ", 
      
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"GridLinesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "plot", " ", "in", " ", "a", " ", "Log", " ", "plot", " ", 
     "of", " ", "noise", " ", "data", " ", "in", " ", "power", " ", "form"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Notice", ",", " ", 
     RowBox[{
     "this", " ", "is", " ", "the", " ", "same", " ", "as", " ", "the", " ", 
      "plot", " ", "in", " ", "db", " ", "form", " ", 
      RowBox[{"below", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<Plot of the power values with a log plot\>\"", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic2", "=", 
    RowBox[{"ListLogPlot", "[", 
     RowBox[{"noisepower", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "0.03`", "]"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Sources\>\"", ",", " ", "\"\<Pa\>\""}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
           ",", "7", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "0", ",", "0.0001", ",", " ", "0.001", ",", " ", "0.01", ",", " ", 
           "0.1", ",", " ", "1"}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"GridLinesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "plot", "  ", "of", " ", "noise", " ", "data", " ", "in", 
     " ", "db", " ", "form"}], " ", "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<Plot of the power values converted to decibles\>\"", 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<This is identical to the previous log plot!\>\"", "]"}],
    "\[IndentingNewLine]", "\n", 
   RowBox[{"pic3", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"noisedb", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.03`", "]"}]}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Sources\>\"", ",", " ", "\"\<dB\>\""}], "}"}]}], ",", 
      RowBox[{"GridLines", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", 
      RowBox[{"TicksStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"GridLinesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.0025", "]"}]}], "]"}]}], ",", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<noise_power.eps\>\"", ",", "pic1"}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<noise_log.eps\>\"", ",", "pic2"}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<noise_db.eps\>\"", ",", "pic3"}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.4083833067440834`*^9, 3.408383333362358*^9}, {
   3.408383467395088*^9, 3.408383483287941*^9}, {3.408383633584056*^9, 
   3.4083836506786366`*^9}, {3.408383684967942*^9, 3.4083837031440783`*^9}, {
   3.408384049231728*^9, 3.4083841379392834`*^9}, {3.4083854254005613`*^9, 
   3.4083854273333406`*^9}, {3.4083858191968126`*^9, 
   3.4083858714118943`*^9}, {3.4083859641452384`*^9, 
   3.4083859835030737`*^9}, {3.408386022088557*^9, 3.408386144364381*^9}, {
   3.408386225701338*^9, 3.408386261933437*^9}, 3.4083863973481536`*^9, {
   3.4083865818534594`*^9, 3.408386684561146*^9}, 3.4083867159562893`*^9, {
   3.4083868944829984`*^9, 3.408386911978155*^9}, {3.4083870556647663`*^9, 
   3.4083870653386765`*^9}, {3.4083871152304173`*^9, 3.408387178130864*^9}, {
   3.408387247240238*^9, 3.4083872574849696`*^9}, {3.40838729870424*^9, 
   3.408387304041915*^9}, {3.41964502135296*^9, 3.4196450948185987`*^9}, {
   3.4196454840282545`*^9, 3.419645516444867*^9}, {3.4201455610042624`*^9, 
   3.420145570477885*^9}, {3.4201456154325266`*^9, 3.4201457684926157`*^9}, {
   3.420145815580325*^9, 3.4201458315933504`*^9}, {3.420145891749851*^9, 
   3.4201459155640945`*^9}, {3.420145965205475*^9, 3.420145970833568*^9}, {
   3.4268834802077827`*^9, 3.426883668418416*^9}, 3.426883705491725*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0.00002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0.00006`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.0002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0.02`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.6`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.408383652010552*^9, 3.408383954916109*^9, 3.4083853305742083`*^9, 
   3.4083854287553854`*^9, {3.4083858505018272`*^9, 3.408385874456272*^9}, {
   3.408386084578413*^9, 3.40838611149712*^9}, 3.4083861457063103`*^9, 
   3.408386181147272*^9, 3.4083862647675123`*^9, 3.408386400402546*^9, 
   3.408386462571941*^9, 3.408386596664757*^9, {3.4083866664050384`*^9, 
   3.408386685943133*^9}, 3.40838671770881*^9, {3.4083870406732097`*^9, 
   3.408387067631974*^9}, 3.40838711719324*^9, {3.4083871533552384`*^9, 
   3.4083871800436144`*^9}, 3.408387269301962*^9, 3.4083873046427794`*^9, 
   3.4196450984838686`*^9, {3.4196454957751455`*^9, 3.4196455178068256`*^9}, 
   3.420145842649248*^9, 3.4201459173266287`*^9, 3.4201459744988384`*^9, 
   3.4201460454809055`*^9, 3.4268834933066177`*^9, 3.426883670741757*^9, 
   3.4268837065532513`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "60"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "80"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "90"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "100"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "110"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.408383652010552*^9, 3.408383954916109*^9, 3.4083853305742083`*^9, 
   3.4083854287553854`*^9, {3.4083858505018272`*^9, 3.408385874456272*^9}, {
   3.408386084578413*^9, 3.40838611149712*^9}, 3.4083861457063103`*^9, 
   3.408386181147272*^9, 3.4083862647675123`*^9, 3.408386400402546*^9, 
   3.408386462571941*^9, 3.408386596664757*^9, {3.4083866664050384`*^9, 
   3.408386685943133*^9}, 3.40838671770881*^9, {3.4083870406732097`*^9, 
   3.408387067631974*^9}, 3.40838711719324*^9, {3.4083871533552384`*^9, 
   3.4083871800436144`*^9}, 3.408387269301962*^9, 3.4083873046427794`*^9, 
   3.4196450984838686`*^9, {3.4196454957751455`*^9, 3.4196455178068256`*^9}, 
   3.420145842649248*^9, 3.4201459173266287`*^9, 3.4201459744988384`*^9, 
   3.4201460454809055`*^9, 3.4268834933066177`*^9, 3.426883670741757*^9, 
   3.4268837065732803`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Noise plotted as power (Pa)\"\>"], "Print",
 CellChangeTimes->{3.4268836707617855`*^9, 3.4268837065832944`*^9}],

Cell[BoxData["\<\"The first four values are indistinguishable\"\>"], "Print",
 CellChangeTimes->{3.4268836707617855`*^9, 3.4268837065933084`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, 
   {GrayLevel[0.], PointSize[0.03], 
    StyleBox[
     PointBox[{{1., 0.00002}, {2., 0.00006}, {3., 0.0002}, {4., 0.02}, {5., 
      0.2}, {6., 0.6}, {7., 2.}, {8., 6.}}],
     FontColor->GrayLevel[0.]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Sources\"", TraditionalForm], 
    FormBox["\"Pa\"", TraditionalForm]},
  AxesOrigin->{1., 0},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.0025]],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}}},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{
  3.408383652010552*^9, 3.408383954916109*^9, 3.4083853305742083`*^9, 
   3.4083854287553854`*^9, {3.4083858505018272`*^9, 3.408385874456272*^9}, {
   3.408386084578413*^9, 3.40838611149712*^9}, 3.4083861457063103`*^9, 
   3.408386181147272*^9, 3.4083862647675123`*^9, 3.408386400402546*^9, 
   3.408386462571941*^9, 3.408386596664757*^9, {3.4083866664050384`*^9, 
   3.408386685943133*^9}, 3.40838671770881*^9, {3.4083870406732097`*^9, 
   3.408387067631974*^9}, 3.40838711719324*^9, {3.4083871533552384`*^9, 
   3.4083871800436144`*^9}, 3.408387269301962*^9, 3.4083873046427794`*^9, 
   3.4196450984838686`*^9, {3.4196454957751455`*^9, 3.4196455178068256`*^9}, 
   3.420145842649248*^9, 3.4201459173266287`*^9, 3.4201459744988384`*^9, 
   3.4201460454809055`*^9, 3.4268834933066177`*^9, 3.426883670741757*^9, 
   3.426883706643381*^9}],

Cell[BoxData["\<\"Plot of the power values with a log plot\"\>"], "Print",
 CellChangeTimes->{3.4268836707617855`*^9, 3.4268837066834383`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {GrayLevel[0.], PointSize[0.03], 
    StyleBox[
     PointBox[{{1., -10.819778284410283`}, {2., -9.721165995742174}, {
      3., -8.517193191416238}, {4., -3.912023005428146}, {
      5., -1.6094379124341003`}, {6., -0.5108256237659907}, {7., 
      0.6931471805599453}, {8., 1.791759469228055}}],
     FontColor->GrayLevel[0.]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Sources\"", TraditionalForm], 
    FormBox["\"Pa\"", TraditionalForm]},
  AxesOrigin->{1., -10.819778284410283`},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  FrameTicks->{{{{-11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "5"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox[
           RowBox[{"-", "4"}], Power, Editable -> True, Selectable -> True]], 
         
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {0, 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {-10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3566749439387323, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-11.512925464970229`, 
       FormBox["\" \"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\" \"", TraditionalForm]}, {-6.907755278982137, 
       FormBox["\" \"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\" \"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\" \"", TraditionalForm]}, {0, 
       FormBox["\" \"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\" \"", TraditionalForm]}, {-10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.414313176302118`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.126631103850338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.721165995742174, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.567015315914915, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.433483923290392, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.315700887634009, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.111728083308073, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.824046010856292, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.418580902748127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.264430222920869, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.1308988302963465`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.013115794639964, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.809142990314028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.521460917862246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.115995809754082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.961845129926823, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.8283137373023015`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.710530701645918, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.506557897319982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.659260036932778, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.203972804325936, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659905, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.3566749439387323, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{
   Automatic, {-11.512925464970229`, -9.210340371976182, -6.907755278982137, \
-4.605170185988091, -2.3025850929940455`, 0, 
     2.302585092994046, -10.819778284410283`, -10.414313176302118`, \
-10.126631103850338`, -9.903487552536127, -9.721165995742174, \
-9.567015315914915, -9.433483923290392, -9.315700887634009, \
-8.517193191416238, -8.111728083308073, -7.824046010856292, \
-7.600902459542082, -7.418580902748127, -7.264430222920869, \
-7.1308988302963465`, -7.013115794639964, -6.214608098422191, \
-5.809142990314028, -5.521460917862246, -5.298317366548036, \
-5.115995809754082, -4.961845129926823, -4.8283137373023015`, \
-4.710530701645918, -3.912023005428146, -3.506557897319982, \
-3.2188758248682006`, -2.995732273553991, -2.8134107167600364`, \
-2.659260036932778, -2.5257286443082556`, -2.4079456086518722`, \
-1.6094379124341003`, -1.203972804325936, -0.916290731874155, \
-0.6931471805599453, -0.5108256237659905, -0.3566749439387323, \
-0.2231435513142097, -0.10536051565782628`, 0.6931471805599453, 
     1.0986122886681098`, 1.3862943611198906`, 1.6094379124341003`, 
     1.791759469228055, 1.9459101490553132`, 2.0794415416798357`, 
     2.1972245773362196`}},
  GridLinesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.0025]],
  Method->{},
  PlotRange->{{1., 8.}, {-10.819778284410283`, 1.791759469228055}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}, {7, 
      FormBox["7", TraditionalForm]}, {8, 
      FormBox["8", TraditionalForm]}}, {{-9.210340371976182, 
      FormBox["0.0001`", TraditionalForm]}, {-6.907755278982137, 
      FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}}},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{
  3.408383652010552*^9, 3.408383954916109*^9, 3.4083853305742083`*^9, 
   3.4083854287553854`*^9, {3.4083858505018272`*^9, 3.408385874456272*^9}, {
   3.408386084578413*^9, 3.40838611149712*^9}, 3.4083861457063103`*^9, 
   3.408386181147272*^9, 3.4083862647675123`*^9, 3.408386400402546*^9, 
   3.408386462571941*^9, 3.408386596664757*^9, {3.4083866664050384`*^9, 
   3.408386685943133*^9}, 3.40838671770881*^9, {3.4083870406732097`*^9, 
   3.408387067631974*^9}, 3.40838711719324*^9, {3.4083871533552384`*^9, 
   3.4083871800436144`*^9}, 3.408387269301962*^9, 3.4083873046427794`*^9, 
   3.4196450984838686`*^9, {3.4196454957751455`*^9, 3.4196455178068256`*^9}, 
   3.420145842649248*^9, 3.4201459173266287`*^9, 3.4201459744988384`*^9, 
   3.4201460454809055`*^9, 3.4268834933066177`*^9, 3.426883670741757*^9, 
   3.4268837067435246`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Plot of the power values converted to decibles\"\>"], \
"Print",
 CellChangeTimes->{3.4268836707617855`*^9, 3.4268837067635536`*^9}],

Cell[BoxData["\<\"This is identical to the previous log plot!\"\>"], "Print",
 CellChangeTimes->{3.4268836707617855`*^9, 3.426883706773568*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, 
   {GrayLevel[0.], PointSize[0.03], 
    StyleBox[
     PointBox[{{1., 0.}, {2., 10.}, {3., 20.}, {4., 60.}, {5., 80.}, {6., 
      90.}, {7., 100.}, {8., 110.}}],
     FontColor->GrayLevel[0.]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Sources\"", TraditionalForm], 
    FormBox["\"dB\"", TraditionalForm]},
  AxesOrigin->{1., 0},
  AxesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]],
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  ColorOutput->CMYKColor,
  GridLines->{Automatic, Automatic},
  GridLinesStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.0025]],
  PlotRange->{{1., 8.}, {0., 110.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  TicksStyle->Directive[
    GrayLevel[0.], 
    Thickness[0.005]]]], "Output",
 CellChangeTimes->{
  3.408383652010552*^9, 3.408383954916109*^9, 3.4083853305742083`*^9, 
   3.4083854287553854`*^9, {3.4083858505018272`*^9, 3.408385874456272*^9}, {
   3.408386084578413*^9, 3.40838611149712*^9}, 3.4083861457063103`*^9, 
   3.408386181147272*^9, 3.4083862647675123`*^9, 3.408386400402546*^9, 
   3.408386462571941*^9, 3.408386596664757*^9, {3.4083866664050384`*^9, 
   3.408386685943133*^9}, 3.40838671770881*^9, {3.4083870406732097`*^9, 
   3.408387067631974*^9}, 3.40838711719324*^9, {3.4083871533552384`*^9, 
   3.4083871800436144`*^9}, 3.408387269301962*^9, 3.4083873046427794`*^9, 
   3.4196450984838686`*^9, {3.4196454957751455`*^9, 3.4196455178068256`*^9}, 
   3.420145842649248*^9, 3.4201459173266287`*^9, 3.4201459744988384`*^9, 
   3.4201460454809055`*^9, 3.4268834933066177`*^9, 3.426883670741757*^9, 
   3.42688370682364*^9}]
}, Open  ]]
},
WindowSize->{736, 740},
WindowMargins->{{31, Automatic}, {Automatic, 16}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 606, 19, 300, "Input"],
Cell[CellGroupData[{
Cell[1199, 44, 11257, 267, 1567, "Input"],
Cell[12459, 313, 1415, 31, 71, "Output"],
Cell[13877, 346, 1394, 31, 71, "Output"],
Cell[CellGroupData[{
Cell[15296, 381, 129, 1, 27, "Print"],
Cell[15428, 384, 145, 1, 27, "Print"]
}, Open  ]],
Cell[15588, 388, 2445, 57, 305, "Output"],
Cell[18036, 447, 142, 1, 27, "Print"],
Cell[18181, 450, 15905, 302, 285, "Output"],
Cell[CellGroupData[{
Cell[34111, 756, 150, 2, 27, "Print"],
Cell[34264, 760, 143, 1, 27, "Print"]
}, Open  ]],
Cell[34422, 764, 1760, 42, 297, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
