(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9693,        265]
NotebookOptionsPosition[      9321,        250]
NotebookOutlinePosition[      9741,        266]
CellTagsIndexPosition[      9698,        263]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates derivatives of a function.
1) The derivative function reveals local minima and maxima
2)  Taking the derivative of a curve is a roughing process. 
In general, the derivative is rougher than the original curve.


See Chapter 7: Background: Numerical Calculus for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4199686805526*^9, 3.4199687805163407`*^9}, {
  3.4199690068017235`*^9, 3.4199690118089232`*^9}, {3.419969387018448*^9, 
  3.4199694158398914`*^9}, {3.420056516589864*^9, 3.4200565418161373`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", 
    RowBox[{"Define", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"g", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"6", "x"}], "]"}], "+", " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"2", "x"}]}], ")"}]}], ")"}], "+", "4.5"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "it"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"gplot", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"g", "[", "x", "]"}], ",", 
        RowBox[{
         SuperscriptBox["g", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", " ", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "plot", " ", "to", " ", "postscript"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<derivex.eps\>\"", ",", "gplot"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"===", "===", "===", "===", "===", 
      RowBox[{"\[Equal]", "  ", 
       RowBox[{"EXAMPLE", " ", "2"}]}], " ", "===", "===", "===", "===", 
      "==="}], "=", 
     RowBox[{"===", "===", "===", "===", "===", "===", "===", "==="}]}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      RowBox[{
       FractionBox["1", "15"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"10", " ", "x"}], "]"}]}], "+", "3"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "the", " ", "function", " ", "and", " ", "its", " ", 
     "derivative"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotfct", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{
         SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", " ", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "plot", " ", "to", " ", "postscript", " ", "file"}], " ", 
    "*)"}], "\n", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<roughderiv.eps\>\"", ",", "plotfct"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"===", "===", "===", "===", "===", 
      RowBox[{"\[Equal]", " ", 
       RowBox[{"EXAMPLE", " ", "3"}]}], " ", "===", "===", "===", "===", 
      "==="}], "=", 
     RowBox[{"===", "===", "===", "===", "===", "===", "===", "==="}]}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"x", "^", "11"}], "+", 
      RowBox[{
       FractionBox["1", "55"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"8", " ", "x"}], "]"}], "+", 
         RowBox[{"Cos", "[", 
          RowBox[{"8", "x"}], "]"}]}], ")"}]}], " ", "+", "x", " ", "+", 
      "2.3"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", "Plot", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"hplot", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"h", "[", "x", "]"}], ",", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "0.7"}], ",", "0.7"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.7", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Thickness", "[", "0.005", "]"}]}], "]"}]}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", " ", 
      RowBox[{"ColorOutput", "\[Rule]", "CMYKColor"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.419968786274621*^9, 3.4199688644069695`*^9}, {
   3.4199694519117603`*^9, 3.4199694524725666`*^9}, {3.419969514902336*^9, 
   3.4199695154230847`*^9}, {3.4199695489312673`*^9, 3.419969565094509*^9}, 
   3.4199696060333757`*^9, {3.4199703110871935`*^9, 3.419970311848288*^9}, {
   3.4199703985229197`*^9, 3.419970460592171*^9}, {3.419970495392211*^9, 
   3.41997049641368*^9}, {3.420055912641429*^9, 3.4200559140835023`*^9}, {
   3.4200559956307616`*^9, 3.4200560857002754`*^9}, {3.4200561450956817`*^9, 
   3.4200562052621965`*^9}, {3.4200564405505247`*^9, 3.42005648118896*^9}, {
   3.420056595453264*^9, 3.4200566351002736`*^9}}]
},
WindowSize->{752, 701},
WindowMargins->{{15, Automatic}, {101, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 705, 20, 322, "Input"],
Cell[1276, 43, 8041, 205, 1203, "Input"]
}
]
*)

(* End of internal cache information *)
