(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36207,        661]
NotebookOptionsPosition[     35722,        642]
NotebookOutlinePosition[     36141,        658]
CellTagsIndexPosition[     36098,        655]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook plots a function used in Exercise 4 in Chapter 10.
Figures 10.8 was generated with this notebook.

See Chapter 10: Finding Roots for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.4263594376728096`*^9, 3.426359460355426*^9}, {
  3.426359556022989*^9, 3.426359598133541*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Specify", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      RowBox[{
       FractionBox["1", "40"], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"40", " ", "x"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "it"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "0.7`"}], ",", "0.7`"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<find_zeroes.eps\>\"", ",", "pic"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4263594636601777`*^9, 3.426359536084318*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwUWnc8lf8XF1GhMkoqEZVVlIpEOlQ0SJGyVRRCtoyUkZ09rnttQsi+9hfH
uPbee4/KKpqi/O7vr/t6v84+n/N8nvd5XpdX30L1KS0NDc0WPQ3N/38TQveq
GxrOYzP7E4sd71ug/bHSxJT+PO789rfwQ2QLbJzxNdJ9OI8yTf9Uwn1a4EEH
rYOaxjw6D/wnKWbaAruZfxKv3JrHh4I8QUHnWkBq5CxvpcI8hufYmCvxt4Bx
hkX6xavzOM2xN/DWwRag3PhceubSPDYuEfN20rSAk+foMLfoPDYE+BJfdzZD
mtpBgyjheeQqS0+9UNcMfcceLO4XmMcrLwidImXNcKamY4P56DzWOrAc7Ehu
ho//arg2WOcxy91ud69zM+xr30p+sWceN5wGU5/YNMOV2Esia4zzOKFWKy1i
0gxx0kUyn+nmsVr3sbuBRjOoOaTrDfyYQymP7E93LjSD+/X5edW1OVx9Ez72
9nQz5HAcs2hfmcNj5Vea1wWagbEwxqXu4xxef05QND7YDNWrQQnkISqOXfdz
+NcEK1Wtgqf759D64+XVU7+bgCt4V15G9xwO6X/wYF5rAgfRN9WJLXNoIeJM
ujnfBKKmL6aDKubQtP5kZWJnE+hIkU2YyuZQ5ETkTERLE/ju+rrmVTSH249v
q8uqb4LZ98/oXufMoSrl4dC1iiaImtU5bpY4h0xqrpnfPzRBI5mU+TF2DmUW
No4vvm+CH+795w2i5jDy59Wnf981wV3eu/JaYXPoNKR73CqmCXboXTW84TmH
gb2VKQ6BTcAxaHbGwW0OyV/7Mxb8moBflfDn/as5fPFbxM7GuwmuKXwO3PFi
Dj+Zi3+vdW0CV9Gg4nrDORypF34nZdsEv/8N75S/MYcP9Thv3Nal+nfc3mN7
jZp/B7ujjxbV/zeR2GTZOZS7mp1CUW+C8x9dxbZfnEM1td1eUqpNYNnBr1Ur
NIfGWXQZPxWa4FO89Qc5pjlsFyVc9hZtgl8HY+ysdsxhlfJjybMnm4AhvA4S
6eaw0+qzQJNAExz34eyl2ZzFnlOSXwqPNsEjy8pNXJrFc07lK8asTWCx8LH+
y6dZfGVGUVPZ3QSvn7CG8MzN4pPAl0xcu5ogRuPJCZexWTQ/+q/vHk0TDMoy
Kl9un8UFhTSSyHIjfCw7x2nePIsOlXMCuz41ws/zutOx9bOYJbkTKqcbYZ9Q
7ou/lbPYgjlfcwca4S7rg/jynFlsirAvjMFGePjW5dnSh1mcYSurFixtBHP6
9HNcabOo1OEb65XfCP7rGw0vE2bRtYRDriC5ERqnEr9KhczixEWZKvRqhO8P
50w/BMziKVXXXkWXRuAdF/x42G8WJ63b6TLsG8FpOGds030WW7n+0xs2aoST
PRXNlbazyMqxmbgh3wgaKtsUTlvN4iPi5O5dMo3g0XGtOv75LF5RH9CaPdcI
oy0txa6Gs6jGGNlOy9sIgZSh5CsaszhaKxPV87sByq4cOUpWm0U6soHZtZUG
+Fj1KPqYyiy27Vulc51pANmKjyHbb81i9LfPtx+0NcBa4Y/X9dKzeOvC42n7
uAa4/55V8xbPLDaeFXI3kGgA9xP3e8sOz6Jk6CEtQ8EGyH5HvHOScxaHo7ar
iB1qAIYEHgVmVup5dA7E8PythxKiyLl22lnkZX9fr1dVD1x+N3erzs/gSOMl
addL9XBjZ4BPzfQMNv99Krf3ZD3YeXXSnZuYwU9ZpxKMD9ZDu7v6H/bBGRR7
JRr38kcduLx8+rGvaQbdO+Z5Tn2og2kzt2rNrBnc3GH/kG13HdTwn+AeTZ/B
C367+0Z/U+DdZKOTXuoMehf81HaapcATNZbzBvEzWMh4p/3MfxSYl45PNQuZ
wTMJsmbRhhRYYKx462I3g1qq17O/F9bCatrv+ykyM8gZ91uvXboGuvVj8gWk
ZlDFnW9Q8VgN5HPJ7s2QmEEbs2mJAsYasA72bsw+PYPhHZVqN4eq4bs9h3QJ
7wzWh3Tfirerht8K54+20M+gvO+ifdeHKqCZs1j42jZNrafTKEK4Empu0vgK
NE/j7/TSkZZvFeCRHSygVz+NYQO5Y4crKmCnQ96TlsppZN/fSMd+twL2Mn0b
T8mZxmnfp92p9uXALfaiRytkGgX47BVTOspgMoLBOiRgGpOe3kzJiC6DpD8E
lkbfaWQ0+P10zagM+CnFt8Xdp1F/JnFQdVsZiKivN+y1mcY0246IqAulcOmV
czlFbRp3By16KBYUw78pZu2Nu9O4wFzGHuxZDFUKsetit6eRhoX/kbR6MVxj
qZSIl59GQm6KRvtGESi+28p1lJjGUZoC1iO3ikCryT1FlHMalXh8vDc2C4BL
lP3a033TODZqPBDYVwDjoe+mo1mmcaedlG9KdgHo61B4du2axtsJ8kv6+gXw
7At91Mz6FDJUP1W71kkGh/2+gcSRKaTzlvydX58P6q/Pje8dnMKk66GjhzPy
QeLjmIh37xSaGLKf2RGYDz9KzrbZtU1hO2F/gpF6PljrjDLdwynM2F+x/eHX
PFCp89Ju/m8Kdwbvo10cyIMzomIf5EqmMOFu0ou/mAdftjxvncmbQon6Ds7i
kDwwe3fad/e7KTzStc3JQzoPFJmHBz3ip1BknuuDokAeCNt5CG5GT+Fxl+7t
0ex58FlhqGEhfApPHAh70L2cC405bw7oh0zhvtEDN8tGciGNU9RoKGAKf5gI
awo354LhgjtDo9cUPtO6qZeUlgvy90QewJspjCFWbMsg5sLx8oGUIpcpPDAT
znPRNxdmAk7JpzhM4Zmgf5VLprnwSKz/jbvJFD72bjiVcCEXIMq1Z91wCoXy
pzyHT+YCN93JY1YG1HhXTyqTjubCWK9LzUOdKYzbmf4jkSkXymWE2QY0ptDc
KDRpYVsuxKT2Pla+P4WndDUKTFZzQMtBaJuM8hR+8veSi+nIgYtTPXcLbk3h
DueBZ+JVOcB563XCyetTyChlXt6alwO/8wW/Jl2dwuCTGyGPknNg4HAPHJKd
widu0WJfInOgyONVUMilKXxw4k/nC/8cICwLTOy8OIX+G1bhP9xywO5Bt6ir
+BS22okFPXPIATV0fv1LbAr3vHhY22mRA+cEBdrNRan6r+T4hIxzgC2k68i8
8BRePWHgb/k4B9bWXz7XFZjCpdHKrmTtHOjS56/oPTaFIcsf82of5EBuSyez
0tEpPFcuPtqsmgPB51/q1HJNof7Nr1+K7+SAReyJTKmDU3h74ZWzz+0cUGbo
3MjbP4XbJEO3SSnlgKiFk6IQ2xT+O6P3pUkxB3YPHo9O2EOdH9/qVHGqfEm2
Y+EA0xS+Enjl6ES1b013lAraMYVnKYYZEVT/H9iO+zFsn8JD5NjnHtT4fi/b
h17RTKFPfdWnq9T8TGYdhH5sTuLwnRPnurRy4ObtY45m65NYJ7H3gdCjHGB8
XMZI/DGJ1y5/9eszzIFmW5WY2tVJpFBcvIzNc+CtzyeRL8uTKOH8RWn8RQ4o
xbjgoYVJPJWs3XnWNQeYczlUFOYnMeEb/+pjvxxoq82atpqexJCDGq+NIqj1
Lo7QNw1Pop7mi7rZrBzYu2Ud+b2fmk8lXfO9/3Kgk41R6GjPJO4Q/Nvp3ZQD
KlKSSvYtk7ic2dV+6hP1PJQ7xpIaJlHWuD48/HcOdD82tGivncQYr/2vB7bn
gppveOiJ8kn8elRZ8ztHLuyLPXlcpWQS43X5xFyo89mXW1PoXDCJnFhcpimc
Cw8Gvw72ZE7ioOj7rW+Xc0FT4DaPe+wkdn1uHntBnX+9OvrM8deT+Fwn84Z1
Ry7wDMXIML6cxLBXAgfrRnNhculch7j9JGapOX+UWciFx/v01/wtJjHcR5NA
oM+DJwaVktKPJvHksUXXSJk8eLbNvi5SbhKvmLIcMs+lPt/796jXykxirnjo
roHKPFgQTPm0cnESLwSGLF9so94Pd3uYFM5OopHEl9jpz3lgHn9a9TvfJJa6
sj604csHW5lP43e3T2LR4nPiRer99Nl/QiWQZhLVPlRo1Eblw38lWb6R6xMY
tyqqy/0+HwJ/+t0PWJjA7Xcsci9jPpy3ll92aJ3A9ixJ7o9L+cDNer7nG2UC
r0fudy79lQ87cvlKzSsmMGib/IdbtGQYXt7yeJI9gemKmiUJHGRwfVbGdTd4
Av3VeT5MSJPBZGc6bYvPBN7hGPIwu0aGe+8jP8m7TeDjo8p675XIwD9nWyBt
PYHaGYMXeHTIwOJhEFVkMoF/tQUeaRiQYZ1P1VXMYAKt6n8NXjAhQ+uj00oC
ahPIKHPHZPoFGYq2jpxNUprA4gnGr+nOZIiPY+Y8Ij+Bpi5bCSzuZPCR2fgb
KTOBdaSQ5n3eZLAe/TzDJjGBtTNetQVvyaD9crApQHQCaYKEl1aCyHDtUEPO
ToEJnC63zK4OI4NoaWHEG54JfMB18PXJSDIc0Eh++e/ABHrkdA4KR5GB5lfo
Y0eWCWQqUlWojCHDQoTb9e87J9C11EdjNo4MPectRSy2TeCXkvQP0QlkKO/R
Y19YH0cmK4356UQypFrfXn+yNo4nK6tKS5LIEMR6aWJiYRzJ+wumDr+jvo9y
heu0ZsbRbF/dcSYq1r9z8EPfyDia8OireVL1lVZ2hNztHccT+78o+VL9iQf8
fNHSOo4ZzOM/9lPjcZ+a01GoG0fS0QY5YWo+O1t6rlRXjCPvNRfRumgyrD2r
EbxUNI65PKJ1c0QyjOzM21OcPY7l3/QPvY0gA+V9/Hex9+NY4SKoXBBChmyF
wOHM+HF8tXjA/1EAGYhzzlUCxHG0zDNhCvIhg5uHaWpS8Djy+zDthTfU8z+m
5X/EdxwLb6bOWbwig1rNDWui2zi6DhR9PmpPhsuPL2iwO43jxXWCm4olGQRo
+C8HWo/jkPhbnm3PyPBHho7Rw2AcB8pirUc0yDA7uvrln/Y4Xt8ue4P+Lhna
Xk72OaqNI900y9NMBTIklFYkWsiPo/KatJTVWTL4aWR6L8iM453uLzaBAmSw
+RX1/KnEOBIqg34JcJFBQdzhorbAOJ63lHzaQUfNdzTKTf3oOLovC7JXUec9
8E1F072D49g5EfJNZjEfBrpotZSYxvGBe77HVGc+GJsHOMl8GcPhxTWnFkI+
+O/Prbn4aQx3KMbtEfLOh9zybkaJqTEkK/8R32+fD+uMnNGiPWNIeekZF3U/
H/zeJ/3HUzyG/nR/nj3dnQ/ZynV0XLljmJHEtnLlTx50//ioyJk+hkMXuLLz
5/Pg8DWRUZboMXQ4QHmoSL0fMieLN7e5jCFD49UZW+M8aD/YJjOrMIYm3zVU
HqbnwlrVF89JGMN3bb95KoJygcOYrX1Ucgz3+3P9LbPLhYdF6np9wmPYLz1s
Gy2bC19Vp1/X7xlDdTZzOj7q+5TN/xem9Y9iZWN24MemLLj/j/fKc8NRVOwT
PHA5Ix0ubRzZ0603iqzdEpm+eulw/PfBYQn1URRvk6s3YkuHtVVWa5obo6gp
Qju44pAGgXPbksKERlFtanQ4T+491LdObStbGsFtu/nGbOqT4UJ0YjWDzQiG
Jyek9bvHAzcxNsDUdAT/aBxJGpmJA4YIkmanwQjyLHzeoyofB72BIasktRG8
LP3ZomJXLFi6u/GKSIzgvrb8UDIpCtKePXa7tz6MSc98dh6diIAgQ93bJavD
2HjI5wSHUgS8MNA8eGRhGAWXLpYeLQuHa7oqefPDw0j+HJtMIoXB5F25Kcfy
YeRF4T18RiFwUJJXLsFlGGfzuYc/+viBlIyKhZfDMPILfmd9G+cLOlfcYs2s
hpFicucTfbEPJChNrUsaDKMqf/vNwq9eIPg4Mb9LYRiZ94Zsv+fzBm4Zdk0W
wzB6VNWUMRe5g5nptr1xksMo8dj35L95N8ixe2xqIjyMMVkEhgJVV5Dw4z1O
t2cYR7nvhvCmOIFGkIrqZ4ZhJM77COpJOIJTuJtrx9YQ3j36pzqz3R4q46ZG
o1eHUOeVZkXDPjuQJydGnO8bwhvMPr7RqxZgWNJVe6h9CI0H44aWfZ6DT8W2
NZqGIWxExndGp02hteGxclvJEFKpccnlDENQG+XdYRgzhJPpAvctCnTgxZSK
uFIEFb9reL5vRAOI824GZwOH8BHp65Yb730Y+UrlLi5UzJB6NYhLCTZ/sK7M
OgxhVcqhcsozeeDekONqsaLiKtm4k19kQJ8+ySHSYAhpjsS2MuVwgAdjd+or
HSrWLJs81syBqXtp+wzuD6Gr3K9VnsAzuHBQX+zM9SFM2K+jslvvCjLzhD7k
kB1C2UvEgww7rqPo8ZqATUkqvn/u+llzRbQS5VtoFB7CM2bpczb/qWDoOVXO
nGNDGFx+Xee0/z0skHRXiOCi4vBjR9ak72O/TL7ty/1D+DU2Maai+QH+vjKd
9HgPtR/LPv9FSGrgoRtsXdd3UPMZqK939dTES7evbInQUPuxnc7eO08L9VSt
RfatD+LkMN3XgnJtdFVP0v6zOohfJWeQ470OJul0+04uDKJsAvt4uaUuUh7T
ltTPDGLuoHhG6UE9nDc8O585Ooh3BXCBN0kPd5jp7wvro+Lzli3MjA9R0Cr0
imP7IFaVx4yEqTzEWy9qLB82UOOJXWPucXiIZi/X4uSrqHKzjaxPLg8x0JWv
7WQpNV7se/Mfhg+R8y9bpXj+ICZY4THf0w8xyZGOShoH0bK39A5xSA9P/fwW
fzN5EF0LTyrdeKqHRdazwfdiB7HTtSmyqlsXZb/0uukSqPG++/YI8+lis2md
tVEQVR6SgPn3dFDtU6GBlQ/VfvCOpJeRNo4/SVV76UbNPzLsbJ+uFhpPEeQ9
najY411Jl4Qmrul6SwTZUPMzVJ7PWVNH52F7AZLZIJ5hEZ1LCXmADOrGnO+e
DuIjh4JPi+z3MbhHY1eW3iDSXGATLne8h4fu3vxTpE61L/k5o1qrgiI3hUeb
b1Ll4wxnY+mVsKjuUFvvlUE8yvOsy3TtOspeYaocl6bW7/sloTPtKqpJL8Wv
iVDt877v5P18HseLR4M3+an5H0p2lz7Fj8bn29wYjlL9lUxvOWotVjqLZBsc
YqPq096qK+w4DwwZcWrHmaj5CSrxSXHLQjB/kLzodmo8ifh0aQYFSOaxFLjy
cwCDPxl+vnxeBVpZzy4+Gx7Au1Gsgffz9OBBIN+oTc8AOrSddyg5/hgmGdnb
XrUOoOVAjELdhj58p/ueHVI5gCz7up9yNhsC189C69KkAezMuON9dNoczIYv
/tlpOoALOW5u6cYO8POB8CLbkwFcWcVuuyhHcO05NMqlS40/ahvC1ukE4a0b
FWfuDGBBXg7XdYVXUF5Z4aZxbgCfKQjHp4u4AdM7uV1pG/3oz8bO8crLCzTs
mF4f+t6PHDXtnnXy3pB8vW/Nf6mfus/w2fMz+MDlJeNRq7F+1H0pOjbu6wvW
4sE50tiPR2k5fk9G+cNgw/j9Dvd+XDn9YvWhcQiciEprlnvZj+8a7wiNt4SA
tZk1FNj0Y+G9Xm3Z06HAxMogRHrSj83nJKK9foTCZS2RTX2FfmTRkr3y43U4
JC+9TPq5qx8Z/ostUHaOhNVK+QPPaPuxhV1V7vRQJFwO2es/8qcPEwuf1N8R
J8KA+Du7qsU+pHE7niW0SARGl+Ybfm19+G/17dY5pShQVwmv2KzrQ5eekTmG
pChIPqZ31qKyD+v/rXe2/YwCmcbVw2o5fdgktdeePTYaLFkPfjkS0oeRp5t4
vEZioGJm2iDYtw+Xr2vH0wjGAmNR5iCtex8eMyyyErKJhXdasjUfrfuw6pGL
4VP6OOh/ZxSRp9aHjIzqbOmc8XDshRjj8dt9+Etoo7dYMx4sb2y8Jsj3YYoe
94YEKR52LQcav5Tow/OVAoyFuxLgkkSRtDxnHy6IK4WvOSYAhaWA7SJrH4oZ
KTIIhCaA4mLe51OMffhSMyibkJ4AWglZkfs2e/FAxA027v4EmHb6YL7zRy8q
tz0REVtMgGf30+U3l3sxLtzs8outBHBgTPk2M9GL7pSx/IATiUAzl9Q8MNiL
O3OKf2lfSARvTEhs6erFletZP+7dSIQ9UXEO2NyLConXG2w0EoFgG3OHXNuL
7C7MxFKjROC+E8X/vrwXMywTk4+9SIRUIeLfqMJeXIpdlsp9kwiF42Ef3N/3
osmSSphwTCJcKg1xf5HQi1Pn4m7sf58IlLAgTRNSLw4+vmbOlZcISuYBZ/RC
e1HurWzG5bJE6L3xdofq2178buhS4FSTCDrHfMflPXrxNOXng46mRJj561V4
8VUvPnlX/ly6MxFMBj38RV70ovUXro8VfYmwlu9uwGvRi5V9WbX3hxPBKcBV
ar9xLxL/0+egHU+EbcavWXc97kXbjtjtNZOJ4HPF+dOmZi8WnpetD59OBJYj
TvhVtReLGktSHGcSgfjLnjCr2Iusrqw0llTM0233fPAatX/aG9fsqfqpmTbX
WmV68ezXwZ+BVH+i3laHqySo/fFvyCgaS4SixxZr5NPU/nxK3bkylAgyl543
vRfsxT9WPC3nqflSOEwTonl7UZT/Pfp1UPuxamwfdKgXDek96780UvvRYqj8
hr0XJff1dBtUJ4J26pMT9sxU/bXXC/MliTDtqr9pQt+LHbQ3+R1zqP3QftSj
968HU4Vq8g6lUPshrpeh+qsHHx280dJCSgRHFh03ha89qCFBQ/EPoM7DoqaG
1OceXGHu2tJ1pfajTv206HQP8ulo/QBraj8S7jPwjfTg7sJFkXMGiRDpdG9s
f28Pbst1lJe8R63/9J23f+t6sOW50rjTGWr9jLf1Vyt7MDfp8vfSI9R5mL11
ca64B7OXjdn2MFLrJSl8bE3vwfQiDu31iQRQsr1WWZXUg4W/9mSFNiVAj/KV
iILoHjRW+HdfPp8633SXr8YE9CDDFdeaDdcEMBmXPhTs1YOuWqkytEYJsFpy
cfWNSw+eHS94LaCUADTm4vGmVj1oaLTPo5c9AXgGT21I3afqP9H37BCLp+6z
2x9E3u7BUTDwCVqIgwLJkdxv8j1o3VE/8zAxDm6QfA0zJXpw1ldjUWFXHFhr
zXcd4ezBmPza7601MUAZjU+jGenG/tYBS+lpEuzZbU+n29ONX96/2xp8TQJN
GWW90pZuZHQ+cP3LQRKsxG6yW5d3Y/FAn32KIhEOPNR0mYntRn/LmatccQQw
mWJ7UP+oG7m/Bq6VM4RBAetCLp9mNx4mdakNB4bCllw1k4tKN9JdNaje3B8K
4UkW1ReudCN/7skIe94QqDBoPZV+rBsnTVM+knUCgWXek85/vgvZuHX7zVS8
oGjhd66KWRdecEvxfH3bCIxDg9u7nnRhlfTJv2kKBnBYSnBJRbcLN39JCrV4
6IGrr7qAqnIXpu3fnmrMdBtuCRbFqp7pQkkLiYE1bhUcf2rjd+97Jx4UPNpV
HmuDwbuZ0nqWOrEwvS5w1NEOrxYm1d2b68TYrbP8Mqr2mLa9m0atvxM/fpoe
OfnLCa3fnbFXK+nECPcRrQkGN2SYWja479yJrWI7HOzee2OJj6dbn20nHj7f
ceSMhQ+anjkSf/95J3JXPP3585wvdrooDd/X68Rrzr4jpgV+GMX94e4D2U5k
eeDBfC8oAJXqr5j3S3bi8HLU6XaZQNx6Pvz2gVgn/tN+7Tf1KRCfVOxqeMBH
zT+NlVX5UDCK6hjLqG/vxD71kVWXuyFYvYOmKHu9A61MFZbMSCHIr356NXuh
A6UUtbjtJkPw648Ao5zWDrwsX/C+2jgU78tXJOVUdODKbZOUjfRQLAtfGsvJ
7sBnrIGClz6H4ptzimq5wR3IyH9itOJxGH5ydwrKdetAB6Mihp9RYajUnd6c
a92B106VfuDrDkMOq51yeWodOPtzl/RNqXB8WXXBOU++A8cOJLpIm4bj5F6j
4jyJDjSIm/vGFhWOGdl1IvmcHZjVXMPyZDUcPfboihQydiAfJ2lR9EAEPjT/
fqpksx0J+lwvDklHoFT721P/rbRjLufjN8d1I3Cf6LFTlZPtWC9C2aX4KgJX
AspOVne3Y0Qs2zH/6AhsWlY5SaG0Y+qtbOb54gh8neUq3JzWjix0O9fHFiJQ
YzencFtUO4rMEYUctxHw3PMcoU7/dszCe14CHATc06Yg1PO6He0/KNN8EiTg
p1Pjgv2WVP9VQ5mlFwlY428nOKTfjmWnQuqibxAwdolZcFStHTnCzdIC7hPQ
QSlZYEKhHTn/axkIfERA1UxpgWnJdpRzcP0T94yAp5h7+OeE21F1uW+kwpJA
5dcm/J+42vHmjgjTRTsCTrds41/c047N1xgqBRwJWH6SdGKFph0na74y2TgR
kPD2zInVtTY8EkzIb6PKrRYbjn+fbUMrhexzkvYEVFJ8ePxXfxseWNIUJ1sT
kP/Dz2N/GtvwIddh6rJHQBqmwGN/y9pQzJGyc9yAgCMmJ47RZLWhmqHxaJAm
AYuay/no4tuwea/8+Qe3CRgsrMbHENKGbeVZpmeBgCZ+i7y73rThNqvVbfyn
CSi/4M7LbNeG42OXo84eIeDRW4d49xq14a1Uzw3NXQT8k553lE2zDbt/qrHE
fYvA3l03j+5XbMMl2+J5mtEIzHk2ycMp04ZfvJlzPWoi0K/Jnufw6TZ892+8
6uT7CHwitJeHm7cNo/eVBv/2jcDLvqncvOxtGDj8o3TZJAIPfpbhPk7fhmz0
weu7b0Vge5rZEeHPrXhWJVN7hDYC03ZuPyIy0oq/Lxq8CxwNxzfG0Vxn2lpx
o8JM0bEgHCUFmw9L5LWiWpqoI+3DcEx6L3DoimMr2gfwZCrGh6HzDjwob9qK
0TXaJkdNw1Dd6MHBG7qtSOnsuKcoHobMAp6cynKtGLuSalpICcUXqdMcWrta
8elWYKFuZwjeZXDi0N1oQQXuqp9Pg0LwpCErx6PlFiQdql9fUArByROy+w27
WtB84WeZa20wKqbEsluTWlDz23zXyuUgzMz9eEjBrwUPfU7IXyMGInO5GN+h
ly24795t4d4vAdjaXXemRqcFzRROi1mE+6MSzcpttqMtmHnaQaejzBeVtS/7
5Kc2Y8mi/+G7b9/gXdaJzTVyEw6e1+/v+WOIuVxC2xuSm/AFu5kgra4Bsgja
MEVHNOFiuP4dKeo+13l5x6Gr9k3Y+tfs/MDsXVQxO30hTKoJuequtwqM3QDV
Bherc9WNeE3eojK11Qruvzo6b9PegHK1A6ExrN4gTOrOu1XVgGrZ4j1Phr2B
ptDjFW9+A46sS4yHJfpA5tKnfR0RDVhUPRrwUdgPaHXyrgrrNqDssIBtoUAA
DNob7N12pwEbWU6p0E0HQHbY/pEB2QZM2ObNcjkqEDRbHK09jzcgDY8g+1Ha
YMiVupI4uViP/TkZs7Z6IeD14LtZ8Vg9fiNV6vjkh4COdapkYEc9ykqIvdKi
D4UdGYyd0uR6rHXpjzz6PhT0Dvb8IzjVI7vlIP2b4TA4L+7Z/NysHgWadnwc
OhYOjCoXCNf06lFrYXa6wjQcCn2iRdbk6lG+/bgNx69wYP5toHN7Vz1uRr02
sdqIgGl2DsHjG3V448DDjkhJApScbvz2Z6kOcyfSl4/aEsDA6NTbtM46zH5t
andjngCSb8YfuNTU4aNETxzjioQ98cF8DwrqMMCc1rNWJRLK+r+X0hHrMMVv
PceiKBKC11I9h33rcKB5kkZ0PhKe7tFUyXtZh2d+Jyaf2kcEFoWKT3oP63Cm
7pP4qAkR5h9bFIir1OEIk9MxrzAilL/idWW+WodOtR5P9MuIYFToeaCMvw7f
1jgapdCS4FLXhZlgzjpMFQhRYDhOArblz9lGjHUYlLJCDrhKgk87Y5wub1LQ
cpbz4MXHJKg8rqywf4WCUQP3tjO8IkG4LA3b0gQFj53pFFwjkOCZTv5YTRcF
SzYH9DaySXDZ4Uk6qZaCkja/3/HUkWBfOIedZSEFVyYFD+sOkWAhp1H2+nsK
qlauMOcvkqCqxYmZm0S1n3n9kWuTBISPpwa/+1Hw3OjI5RjGKDClm3jX4kzB
YLXVVtEDUSDLE2KRZE7BA8mZVj28UcAhfVXa8REFnz1nO+crHAVLD34w3FWl
YPp9FZk7YlFQY/2+m/8aBUM6u6aPS0QBtxRzavt5CkKUF43YxShw3Gbl+OIE
BQWqP4r9oOLexj4lbg4K3teyPmslGQVngqWO1jNQ0F7Kcy35fBS8VY//9vxX
LV6mPI4MFo2Cee7tDfs/1aLUL4GX5/mj4Mq8cVTFYC1GYNupkMNREJvV9vxp
Uy0+8ma1fL8nCn7bnpXbXVaLFEZjGYctEqhditxXmFGLyZZz1dtXSJBDt/lR
J7oWK9N5HyoPk4Cx5dF/2/1rsYeT88MDCgkMQ+sCM51rscaL1pInkwTVmsL6
as9rsfTp6cyMEBI4fPq2M1m5FuVN+71YH5CgJ0djVBFqcaUu+vjaeRKI2lfk
fDtdi5NLdRfiWUkwR+/94CprLX6bevPFhEIE2bZFocVttSi5InkyOIoIMeF3
/4au1WAgcXNXkDkRVI8dSp7uqcFFp9/bhViIkL3w2t6PUoNnn8YptI5Fwq78
mVtnC2vw+JyVnWZ6JFTJZq26EWoweaJ946pUJIjoyQKvZg3qTMUWzV4lgM+J
FLammzV4gn7PgcfbCDC7tGveUqoGW6paFr+WR0DUyx7/qsM1GFGmdNBANAJ2
kgyHH45XI6X3M+e1jTAweNSStaOjGl8qtNnszgiDSoEzbjlYjQzKBxa41cPA
rmhdYCuhGr/XtPpdyAyF6R5/uziDagzZJ1S0/2oIXI5evaGgVo0Yl/r5+2ww
kPQfcK1cq0bNW1adWp7BcHeVp1aGvxprjhxVL30TBBV7yCxjn6rQzu9pq9Z9
fyDeHPpw2LwKexmunOf09gTKVuV2podV+LHXWOZ6mgd8KUzW/XOnCmutnYUq
G96AAp/l3iGxKoznPVzUuc0dFn7snj+1iHhz/2419SZneKfxzJbvTyVq/U7l
aR02BQ7uoyG7OStQsyS6KOCGJT73W7yytF6OnLuNuBn4rZHys+h780g5ln3I
yOzdZos2Hbc1fOLL0bKzbKyTbI+dri956ATK8cPAd6OBzdfoO9Of9Vv8P0z+
Pf9F1NULJ+8kPRw48B86CxWdBA1vlCx/zlq0Xka9z9fdZEV9cD58u51NRRky
eUseaOvxxSsKZy+tXCvD3nSFLA66ANxMC2ieuVeKCish+rlWIXhZQoi+8UIp
lgoPcmrUhqBrLQUyD5fit9An0ynsoUg/vlFgO1OChhzRtYdzQ3EPu0k8vU0J
0r6xONkxEIZ3E+iHPz8oQV62AxL03OEYKpK4r12qBGXDb14t0A/HAzcGfQm0
JRhvX7hu/DEcj75SsBUILcaph7Yvk8ciUJ9xOpvpRTHa6J6yPXiAgMmRrz5/
0SxG+u1TeVPKBBTKL9Ar4S3GBTZlG+1SAprBXVIMfTHGivJtp18iYHbrYo/r
5yIM4qZ8X+WKxLMf+W7ezCtC1bF/zt6OkWhrW/lGJKIIT+7sOiWUEonF27Qq
WR2L8P7jZ89pOiLxElfIuWHZIsz+aH/r6hEivk4/ZV55vAiHLOLY0uWIWCXR
mJa0swgrynRqJZ8QUV5l64hpZyGq9e0vbXlHRJ/xKI07BYW475L8teYqIjab
SoSdIxZiAH/Xtc8jRGRe72o74FyIJOHIYv4fRFT2er5z82Eh7vJNqXBlJmEw
+66rk1cLMcPhYcwPXhL2JCS/oggU4pWCuIo34iTkEJUtSWMqxIUb3TlC10mo
8d/Imv+XAvRNOsQ//4CEUTfsRax6CvByr/7v4ickHO1jM75fXICzh+yPxVmS
kNsgO+lidAEuR3I2RTqR8PHXm2NHXAqQ/+qeM8nuJEx+NXeA1qAA97Kdo9T4
kHCe0U11XqEAG+65cXzzJ6EgkSugWbgAY2QPj50PIqHJiZKG7D0FmFV+95s3
FWfm36MNWyOj8O0kzaUAEq7Al0v2/WRchGpxfT8Snmnzs9cuI6M5fUD3Zw8S
2mjx50McGU0rdie8eUXCoo/VS8fcyXj3p+m5M7Yk/G2rK7DTkIz2CXMKX41J
KEW7/njpJhmzxKtKKdokdA4Kj+kUIaM8h2RwthIJK7nODBSwknGS6/m3bGkS
0mS0sJJ+5ONzEyWxBkESXrlgpPRqKB+3TO3Lf7OT0JNC6/24Ih8tuARPyf8l
YqNKXLV8Yj7WvGG7lD1LRMaJi5tCnvnY9uJqq3gzEQPXLa3WlPJxW2pAUloQ
EUfHrP5zEM3HsEjBwA4zIgrVWNNv7c3HQPYisZbrRKT42ZKYevLwme1JRuVf
kchmYTcTUpCHGd9dn4+2ROLDey9EOAl5aDq3be52XCT+OexQfVwzDweDCl4t
XIrEGzSOTB+k8lDPuUaRe1ckRsw63hfjysNspq9eCj0EPJP18rPMRC5eK7gT
5/2YgEaXXVjVn+ZitHszWdcwAgv4XLXHFHLxn9U0fR1fBNLucEsxEMzF6/0s
O5TGwlGK+vRO9udgZ7D0ty6lcHxfzVzLNpON99rXPW05wtCV4bCB/UYmKt1q
D1XWCsbDHVy/3lRmYoEnr8PwryAsiuR+G+yWiTf5zhvISQbhkiAfOX1HJm67
NnitMzcANRWF6EbZP+Bfo3WDMXc/PBt84Z3sqXSU9/0bWV/2BmcPqs3s0k1B
ten5qu17n+D94z99eI+noMZcqI2JxyOsFyWKXlxMRmv5b9f2rGpi+tVRR2PH
ZFS6J03+bX8dzZ8/YWmIeIeUFofmoYK7sF5lK+PRnohifvUyxNvWYNLCMRMd
kYj/dbPElDLbwmhfiQ9ZJxFfvON7c6fZDioXNnumFxJwuChP/Y6sI7zZ52ki
tyMBmXxofq7ucoXDncKn/7rEYMzFUk3mOC/4N2vudGpPDCZnxJvqPvOGyfX8
Ou2YaJTQlNyaOOsDqcekdcpKopD2VNtb6SpfOGOv6Gu/SkTuab+CxBp/YPMP
6k11IaLvwgftnlcB8COhh6d/NxGVJDuuV0oEQlmzdtF54UicXRpa90oMAnlu
s5lV/QjMeyaRn3MqBATP5YryUvf095IvOkxcQ4DxxnfHuy7h+FSnaG9rdwh0
Wjmz5ESHoX81JBjZhIJWnb+MWW8IbstyT1R/FwaXhjt9ovVD8KJTf2XkYhjw
fNnX2/w1GGNVrpxUPhsOs5yxJkK7g9FcZN+Fnf+Fw9ig1um2t/7o9vrEIE9p
BKR+WT2SnPkWl4e+0mp9iwBLBl/ml21+GDAmLPHtJAFozxd/Ftzri6VZ8Qxn
iQRouaU8uHXaB0vcs6M6WggQ/niuvv+uN75JNztR/pcA/EHsyR6hnrh387KZ
jU4kfEnJCNUme+D5jFtHL/hGQkm5nNvZ3jc4dN7pP+mCSLi1YKE3ud8dfz4I
pt3YTgT2bTtuF0u4Idebzzk5wkQYPRAnHajuihTfiuskZSKM+xHFHM6+wkCe
Ezk0IUSwLKnfw2/7Er/+rAl2zCEC7fz3xZ5CRwztu+12pJUI4ezHmtx+2SN/
+8tHC/NEEJBTST198QVmPto4M75FhFJzlzdjTraocIXE+YuDBIoxWY/ellvj
aT+DR+dOkWCsaUTm4j9LPCvXbBsCJJhYYZdodzFHKZWKub0qJNh+y/KrEJ0p
VnU3GGY9IoFgSmuGp5cRHioS7DA2J4ESjdDTqV1PsKb+00E5JxJYanvyyAQ8
QsYdK0/FPUgg9LyWLMarhdX6zD+v+ZPA+piz4GeBe+hZzC5mEUqCF+RnUnK6
N7BNbCSRTOX3LLJF1x/1nceKvzd/sZJIcD46OmIHcMFJRd3tflTcx3Bll7WT
HOgmn6w6TCTBtahOHrrnd0Axck6+IZwEQ4TTh5tzHoBCXk+vfxAJgidfpLKl
64JUm0qnmQ8Jju+fIIqo6MNcQQMauZCApsx9vKvtKbzeH6/82pYEI3r8x1/c
egbxjRJKeUYkKKJrfnaowQweWPd82KZJgpu9ReoTvJbgYxfgYXmDBMWpPk5i
k1bwCy6xbomT4ISjVuybOBtw+aKXm81LglDFU1V9OnZwQZV21pWJGo/737TA
YXt4fjVZxf4b9fxrEgVbI52g+6Yq72AFEW5F2ChyP3AG01Hj1woJRCgxkje3
3Pcadjy+zjTlSpV7fdf0a3SF1OOhQsmXiOBmoWtKfu8Gl5+3t3QdoOpr1DuP
ernDRx82FF+NhBMnifGi8h6wf+2FWGZcJOjs25anftwTbK4Id1GsIyH077Ma
VzovmGGJpD0qHwk0ndJz3dXe4OAs2vRhlgCjthPC9pffwu0H55td9hKgNOVI
ddAZf7hh5mp4tCsCCP3a6ml8ARD47pP8UHAE3JEcfDPEEARxY1/MMxgjYOqV
8UqsUQj8aPVYsPoUBncJ3hczJkNgpyvdmlM0lT9np3oUaYZS+2qb1qYUBlET
s4c6FMPg0Ue2BtOMUFCTe3yd5kwE/PssYKKmGgI1mq6hzOkR8MNEyd7mdzCc
sY4f4+QjwCoZRA/EBsPud2M2YvsiIS854u5BShDUb9dK0P9NhNv9aoqixf5w
sVF1nVIVAywxr3/4CXlB2qTVta6LscBaYlikq+wJHOvBQWP5sdCxvcpMzcoD
1oQ6TvxMjgNbB8PjG3nu0F93Ij3sWgJs8fLvTZN9DUECSX0UwSRwEhPKvsZk
AbSLUaICqykgQj8//P7yczQQ97uSJJQKol9kKR26lkhxcXxwRD8V2Bp/vWU6
bI1e+zRes/ekQr7oWRvpEDtkvLy/favgPYhqPc1pN3ZGtpCg54MO6bCZVXn8
Y48H2oy8druXlw7yNrf4Nak7fu8J84j2z+kg3veP5sRzLySUKVVQtDKgSm5N
yX/LGw/N7tqdd+kDpBUts3zZ/RZ5L3hk+tJkga49nyKnfjC6u9lUbb+YBZ9I
e4VPlATjdIt+r4tVFjBjW/sicwgmP5LbtJvOgucLBhn++SEo6PdPUZ+SDTxy
lnvNl0PRt3f54dhmNmTRCw2SJMNwgXvMRkM8B3Tcdocpu4dhJvm/aOXUHKja
x+J6iTUciebldkeu5ULkXTX6cK4IbGQv2NJ6lAvxvIeeWWpH4HrJB1+icy7Y
l4UxZBIjUIsuOpa9MBd8yja0RfcQ0C8tVEClKxdaLi8cMlMg4H+3/fICl3Oh
+Lg03y9nAnIRHet28eeBT0a+6+wsAZVkrO5cv5IHthuN85c5IvHVtPGQh14e
lGr9R+6Xj8TxUxrLW4Q82LFyiyM3PhL3dN+xlyHnwW4B09aFpkgE++vbXnbk
gfLamvD9tUhMqJbY/3NHPtgdkEzOlCFi3d6moBAqJczfd1PZ1ICIC7rajCLy
+fDpQmnxHy8ismQuezQa5INnhFSmehoRxf+4bBm45wOfd4qQSwMRtW6wOW0l
5MN/52UemVP5mysh+XsU5sPtmC/5fFtETJmVsJAYz4eLbCHFpAMkbD7b9Llr
k2ovzn6hS4SEX1y1nzw/TIard4tFGuRIuK9jeXynFBlGBC61ON4j4cUjrprJ
GmTwOrnD5qM+CfVM2XrBngzNjDfL91D59ZvSZOWRCDJUph2xXqHy67QdF5pe
FJAh1/R9mOcbErbfb7rK1kOGxPkTaj2+JPz2Trsyi/qwqQ7vODxA5cuca8uS
N1kKwMj/95tgKp++LOtKnhUtgJc2n/S2AkloEMgm6nq7AEQvsOYeo/Jxn9Hk
tMNmBbB7+4+cv14kzBK+cKzYjyo/p9kS4ELCboemWNX0AhBUuPSu146Ev+q1
OVcaCkBAsoG55xkJufavhPrOF4D3CSlWPyqfljNw3X2CvhBIir3Lf26R0DCP
zafqWCG06xezC0iS0H8rmVbnSiE03q8XYDlGwrzbF179elQIihoutCVMJOyP
bvoV6lIITo+7co6uEXHzs7a1aFwhCOxeNlfqJ6KCl6vR05FCWBdR4f4VSUTT
XrZpmj+F8PmX1tuXdkQM5kvRieEsgiOLZ+na7xJxpLJJped+EdDwm4sv0BCR
ZrdOq7ltEQwn0P8t64tEfu0VBcawInhYKfbZKC0SLX+xXZLrLAL1C1NPDK9T
+bJ8StHoShF8/7nsXcUeiWVhF8QcdhfDjMrYjx3jBKQ/o8Ofc6sYquMuzFqZ
ETDKOIXlSF0x+A57BVyxikAsuvC2ZKYYdP61ShNEInB2ezO9Gm0JZJ2OlKX9
FI6nE1f++EEJHKDX4b2kHo6UoQtzv0tLQHPn3psrPGG4fKu5tDe7FPgnRSZ8
HgWj9X9aQlOtpaDzbIlXjy4Yf55cJC4vlAL5ZntpzM0gan3MDgwCZeBf+l1P
tiEA2TpuS0jGl0FVBOH93Ds/lLzXlR8d9B9sHjelXV19gx7agx/0LSsgJtSG
8DDkKe5qNT5sEVgB2bF8Pfs6HmPgpXW/l5kVwBTyuIibQwcjjxwyCf9UAcmz
v5TsN29ixoS2YP2jSmjaPSuWe1kFOg0mkoVUEFgvBkcLq9vAHolvyr+JVaAh
s/vO+k9vGNG9V7ORWgV3LNWi3qAPpHmSxbcKquBAU5LvVS9fkOuz4WLoqgLO
aaVkoT1vwdb2+2f2XdXU+yFt9yZ9IMjFqOkeOFANv/8c6IqvDIQ9lILOQyeq
YbtrX8kOuyBIY7cr5pWrBp5/V47aPw+GkfwfHqcdq4HELsfeSwmBtOH7v896
V8PWnpWl1wdCwZa2yFQioho0n+91GTQOhT2qL1Rl8qphKWT0q8uOMLiy+pNH
8XM10N4dbf13Lhz2HlQPU/5VDcNzPc6vXobDqGwxgyp9DTA5i3x6VR0OdsH2
yxq8NdDlL+/15UYEpJ3+XWaoWQNySS0Wu+UJYKeuIWpiVAOOnMM1LK4EuOJS
kvjcjiqPG99pWUp9v7c7+NiG1ICFqEi/mEAkpP8c3LCPr4FDWvT6/tqR8IL7
osXLrBqgifNdOBsYCXvN1++7N9VA0b8M/fsrkTAaodnkOVADL1/u1ms+TIS0
itJLvnM1MDx5yvzVdSJc2e10LHhbLUgwfVUPIRFhr/gwIWxvLWhkf1VaQir/
0ZFijDxSC1m5QwGOs0R4kfnna+zFWuDpWnl/VJAEV3u1niRer4WrCsJk8etU
frhZNpB8vxZ8k5vMbZ6QYPTYYcU0g1pYvGTaOkDlc+mKLys/WNXC0lGjqUdU
vvjCZkQsx6UWzOW+zzPnkeBKtHRKfkAtrI3dkhquJ8He2mjOouhayJej6DQM
U/0tbLwtTa+FPy2/vnUvUf2x6WyVF9fCulxf08Ym1Z9UuXVVXS0kGZW3yjJF
wVV9rvnanlo4Mx6yN/FAFLD4OWs2TNWCt0JX02G+KBjLG21t/lIL0qkx6rnC
UZAxdEm2/S81391NF/XEouDFtlhyFxMFxF0/7T8hQfUn9Je/7yAFlDlVirZf
jAI/6n6xQ4gCX9/W5G9QcTevxr+LkhQoCRMqKpSMgoNx9CZm1ylw37puzznx
KHh0iNwX94ACL3fmyNiejoL3hEdyXU8pcGxn+09HgShYYduTRWdHgXvZTUfl
j0SBeNB/nBIeFBjd/qO3nyUKnJmeeRiHUYCcJfHwDG0U1HpzfI1KosAJqSWZ
e6skYNxO0W7Lo8B1liZeuXESqLpaNWxVUSBjKnd5o5EEpE3uc2c7KZBQFFDk
Se33pENr3JMJCmSF8NZORlL3hx+OjJErFLiZ0/N2rzOVXy/3Tm0w1wF/ziHh
bzIk+PvM/bYoVx2MqebPZx2m8vv506WPTtZBRfvnUzd+EaFn3C+47mYdiLCF
SAmlEeGQtuTmL406UHzKZWb/igj6A3NGwsZ1kP5u8A/5LhG+dshCkFcd+OxM
ZN5F5cMXlFYyqiPqQPaZu7VwZSS8bozm+J5cB59/2/9RpO5vzNU/lzVq66Bj
4oTou4ORIJSfGcNHUw/zjYGcEscIYCmqtfP+3nqwr4iSXZyMgJKMHbbe3PUw
yrTs2hoTAQrv9BWXLtXDA/do61N7I0A/nPNPoWM9jOVOsR+eCIOYFx7qN7/V
Q6Lh2s91sRCYWROrfUnbADp4WrmgLxiELSZEs1kb4PcQcy6LQzCUGkkxsJ9p
AL3sP7HvrIKgX+NrwahZA5Dq2GHggT/sldZhs5xvgDRfwSKWMk+YTE0sjf/e
AI10WQ2LSx6Qz/bxUQdtI7zb3RpkxO0BDxasckR5GiHRUrnT/ZU7xJC8lZbV
G4Hj9sjMGZ3XIPw738ukqRGmVS96s3ZYwrXCXRtPMptAxEsj5KLoU+TgvZMU
XtYEqtxjmVaBxvjRP/wmpbEJ9M2AELRoin5PeIjH5ppAmMtPu/C2FXaxi4tP
H2kGZX15rgNz9qhn/cjiYVAzRC79iXt4yx3PjKdwBMU2g6BPojf/nje47dZi
ReWHZphank7n7nyDybwvmLkbmyHpQpTNE2VPXOx8mz5K0wLX7w9yRJ/1QYfT
xTOa1i0wfpHsNOUfgE6ZL+mvuLbAbAjzjxShQHwpJCsgHNgC9+g0fnfWBuLr
Y00mf9JbYEjwpKPw1yB8c2BkNWqqBZhN9pG72UPQIzye/c2XFtiEWouT6iHo
xfpE3PRvC+z17JrdRQpBH6ZlB+mDrXBAEoWucoZi4Na/rZG7rfBfWmjS4e1h
GOxcy0vRa4Uv5sRP+6XDMGTd+2qmWSuU+HWdsbAMw/BvLN7OPq2Q0348VqQ/
DCMs+9KeEFqp+9tbBz+GcCQsk5qVklvhR4lmnbh4OJI+8u05UtUKxn0+jsYB
4Rj15ONp+vZW0DibHvapKBxjpj6oLI+0wuCZi55p4+EYN3I+ouJXKyg1LBcP
C0ZggsZ6UQp9GwT+7MpRUIzAxL6KwQD2NjBKPLQ8ZxqByR0KXHqn28Dsugs7
+X0EpioxXVaQaYNvXwoqR2oi8H1Tx0NRxTbY0Js9JzIagWkK4W4cmlT74xeF
Ur5FYEatxrt/hm1QbidlL7eLgB9kj9TN27bBmto3TpojBMysmJpvd28D/pOc
pyZECZgtlbqzOLgNLHuFVkcvEzCn2EQ4Pq4NhA8RWn4pETD3/Gkl78w28CD1
yYlqEjA/79tzi7I2GGL3/vvagIBk0ZIg9cY22C/g0/LJlIAFH5zzoJ/q34wp
xsSagEWCcj0Cs20wuf7Bnc6egMUp9D/2rrXB/K3XRfmOBCzha+b4vUWN78kd
au9EwLL4QMnJ3e2Qeaw8TOX//5fguqfVeLgd9m3y6cq+IGAF6YBzrlA7zKdV
k69aEbCSYzSWeKEdzJSzXLVNCFgVloCu8u1AwqTO/3/PrGF5OmV8rx34ttH3
Nj4gYG2AEJ3K43b4LTw0zn2LgBTGleMXLdqBkIbGftIErPfOV+B91Q7BgwvM
zCcJ2Ljd3njX23YQYGb3S+YkYJObtN8qsR2iPxrVqG0nYPO/rQ9Dqe3gc9zl
vyMrEdj6ktJWXdAOT4tl/1fDmYfF+EZ9vA0RSZKURKhUlhCFfIuk0qZFe0ol
knYlWlC0rypEy4hQMVOjEmpIqqm0zbQvszQTQuSnZKv3ea/rff/8XOd8z33O
ee7nvs79z50n0JNFezcT9/VRXRsa7DsqZ19k0drOmS7L6GjD6wvBwasKsmid
fj3WJz63QW9O5kjJiSyaid4H37A/bdimK39fcz9xH5P8HZe2qB2VX2MDUldm
0V5VyNfUqrTD1GPJuZdvMmn7Yrf2du9uR75eSmlWdiatyk5v8rNBO55lPT9m
7JVJe/LHY6OcZzti7VeIWgtl0lTfhWB7cDta3VOuUlqv04ry4uyNotvBDCpw
+5l5nZarV5ocSmrHjxI3GRti/kyK/W+KMdwOoQmXCx1yGTRR+3kSnz63I47p
en+2m/g/VVeqCv0l/DVlAnVS0mm1J+W3yizpwMu7OvrCv9JoFQv13A3UOrB6
x7f1xf6ptHvmcS13vTqwpl/sWlhjPO2EVrrdFr8OLIj64NIsHE9buy6HXx3S
gcsDc2ckdeJod76XzHVc7cDymYunG4uu0a5nte+YK+yAlsHyG8l20bQrg9J3
HNkdEJkKa1gdf57m6nXfR8q+E39JGQPJf+0xevjCjTWundg2ff/Xx9euOKli
Xqfi1QneapHef7Ee8Pk4s1LnXCeGZV4Uecv6IOyMyRvP9E5wuU47Lzw8hwy/
/1ZV0Tux626Ju0vgFaywaNJ/3dEJ1xtJM6s9o3FzW65fS28nIJqx7bRtDPIm
Dd6y+J24K5oU5rXnGkqCcvxFhbpQ+Ty7U2UmHvWheo32e7qgQuZWbLubhsN2
0t/d9bqg2/ShUkEqHc1an1b7GnYhYO9GX6ur6ej4lRl45VgX0q+ZKXp7ZmD4
4gf5ksAuOB3au/GSXCamo1KD/xZ3IUstY8GY3Q2EuXrkzy/vwoZ+M7EHL27g
r652s0R1Fx4ECT3Slr8JIaFRhY2NXdiRqtZdPXQT4jG7WkxHuyDD0rcMMcmB
ctzwunw5BpKWndCt/ngHHyT7m3TXMxCjeTZwk04uHuYy/biqDPzdWuDUnJIL
FWpLzcY9DHxf+8L+mnoePug0ejTqMbCtYXl/1vk8PGqqEzttxMDa7VHjtXV5
UB2pti+1Y2DXh+UxhkfzMX6qQsDMlQEKvXk4Lysfxf9RHnz1YoB84dbZ3735
UFv4cGp7KAPXPpzwslUrgPrO7PTqLAa+LlXf2JJbgM+16VqOuQwEzx470V5V
gFKjZNbfewwsjlpp0NBRgM3HYzbrPmVA/+Le7qtzBZj4GMXkvGBAQv7lwyMr
SHgSfPFi9BsGLP3MgmY3kbAlIZDe0MVA/dAaSyULEiakfP1PDTCwAxO2t9wI
//zTKxdxGch8t05rKoAEX1XP2pKPDNz9CTXtyyRsrXD1NJ1kIPRyQLRHKgnf
4LT46wwDyfHppSF3SKA021LTBJg4Z7BX3e8hCf42Vg7bRZkQuthNMqWSsI1t
JshcysSb/NsNy2oIvbfxw3MrmVB7fe/si7eEfuqQ+UoFJoqXfYg2fkfoL+lN
P1Ni4vhWSNAYJGiI6eQ6bGFCRf7kjlX9JHzP0tL/q8nEiq8zyvbDJJSv3fkp
V4eJ06p+B6LYJASWbM3AISaK+qUmE7kkbN+lps0xYULdRvBl1Cihf6XEvmLN
hPFrsUOOBJcfUYzd4MRE3YGawwqEf2CP/JYGdyZmxnVvtbJI2OG2qtvrDBO6
zkdVPIZI+PFJKnxhEBPftmz4N9ZLwtMQifUlF5j4ImylfayLhGDBxc0mV5j4
fLpuJbWFhJ1JCwIm4pmIDL72efYNoZcWlklLZ8Jt9dsNe18QetJsrcYtJl56
ZBucLiP06r89GQVMyBlxvyUUkaBZNbX43EMmFEP3DZJySJjWm6RKU5g40lvT
TU4mobL1s8OzKiaWfhhsqowiYRd39OGfBibuCKdRq1wJfx+WeW4bE2EzVj8q
zEmo+jkwvb+HicKNFFqFDglaS7r0r/CZsNjdkvhGmoSZG+8+rf/ChMB+zfQe
QRKeKdIz3v5gIurdatWpTwXQ1nrFFhXphtHeyFWuNQWofR67cZNYN1jlSzoc
iwqgr2PubSTZjUFVWc2klAJYHBj5L35tN1atH5HOcirASZO/88V0ukH/OCGv
yMrH57Y3R9T0u7H09m/Nn/fyEXA0Me3IkW5ILvm41O10PsKPycom2Xdj18LY
f4sm8pDhqrV5SUg3DJ9YFXu+z4XM6FzA5ohunM3UGE++m4tcz8ZK05huNG6/
UhLhRPzf3sd0UzK6EXg6aXF76x3UBgdbLSV3o3fPXdnZ/NsYj6OELfvQDQtT
fsas9C34i52v1fjaDSWkewjX3cRUMoQtp7sxW7JN77DPTQhcb0vKEOlB27uQ
/FJivpfO/Zy/fF0P1MoeDTAdiftvmUrDCocejJmxzvyLvI6c/gJJ2dYeWMcu
1VI/kohnvAeZ0oweSEfPc6ZmJaD76xPp5QM9WPvjXcIQOx4S82tkF3/ogYx5
zxHbsDhc3d6vOCvcCymvJPaLp1fhn7hsB3dvLzhGivMvuF9CSrZMxciBXjwx
cj2cFhWFEpLC7kGjXrTZRKwO3huJsarNe5m2vUjQi9ZLrrkIR57RwYagXuwK
+NdsORECA50rVsUlvWidrH/jvdsHHobx3UXlvUibyDc4uNkbl63SbAureyG6
Iddab/MpvDyd53insRcfFF4nRph4QCP7uXvKaC/Y4/sbvss6wIz0mp8w3ott
d5ZpLH56DD6lTV6xk714VTxrG+thhaK6njOX5gjWVl61VtYYq79+DwqU64NA
qeCaa64y2PP715SvIsHpXN8LdctotvMEz5/ZRHBTZ/JBxc20DLml4R67+7DW
OnGrebMujaIkPeu6vw+XHrumFuw5RHunIX/J+VAfdA2+DYYHG9FEDdVijln1
oSNz4YA1yYKmZLV9vpVDH1zX3eNOe1vSDrpox5m79WHbwrWTR2Wsaa6ndReZ
nOrDt5ZwjvIjG1pk8OEkQ78+pGV8y9onb0u7HWUmfiikDwWdVn9sgu1ozxJs
0vQiCP2s55J9T+xpPVlOkvtjCP43PvCs2YH2X4F75p7EPkgIk+Jv0h1pZsfS
M9oyiHpaxY7bv3SiPRSjpZ3I6YNFo6hZS6IzTfj155RpUh/Y5Rvyn+52obmE
yCYnPCLqcRbJHKG50J6pGSauKevDq4eyPis2HKct55yLL39G1HdG7rSKx3Ga
b3ZhrMErIr9mVcbHqOO0piOdVwcaiXrITX+3hB6nKQrORfu2E/UsOm/QYXSc
FlGpfkWol7CHr1N89NOF1nfG4VL2CLH+Tg3pm5dcaNvXxUWqjhH2Qr9XkTxn
WlJPRXjtFyL+QGaf3npn2vvE0QuWU0Q/DbO30/c50Q7oLQsb+0sw9cmruW2O
tDvT+0MviPTj1Y61WYw5e9p0ic858cX9uCROGdV8ZEc76pYTdHc5wWZDQnKb
bWml0k0Bu+T6ISDY4nMh0YY2v3XKr1mxH/7/vtPM6q1orpfX+7qo9uPb5kha
Vu9R2otdR32+a/SDfau5qCDBnOZPKj0lq9cP12/98l6uBrTmYwMnnxgS6zua
hQ466NE2Lhb1PGBBxN86LvVbSos2EOLu5n2cYLuD9x33TNZqqqcfnz1JsFnk
+tSbSkjj1Dpn+PZD97ePxDVdLRwykXV4HtGPAvuU9sXfjVAgaGhndpWwx3y1
vnnPAr8rzx3jJhF6fcX3VcHWoKzrtFx0h8g/jlX487ITZH/GHnF43g9R76Cf
ORu9EFxaYTTxmuDxXReFE0+j3W308BV6P+IuaYWOCvogpnW/fnEfYVdsXvYm
3R8TpKl9v6f7ob7NcsOuVSEwtF2/N2W2H3aijV59qaEoXHxUW3H+AER3epsU
iIfBLrRU03jFADzuTXQYbghHnYn7lpwdA5Bde8qt6thl3PjZobDHfwDH0k5e
PpQWh8p7zS9MQgdgdrDl8YmQePQcrbc9HjkA/9J1H62OJ0C6tCo1JmkAD29r
6ERpJyHbNW+u7eEADPM2lL+Zn4ZM+hmWO2cAcT0BUXJSmUi7PT8/2XIQMdp/
vnqz7oBiKLC3wH4QYqRTG2oCctEx9aun3HUQvvdCaq6J5GGpxRfxPt9BiFjY
mrio5SNFhBmpmDiIBulPgTdrC5B8luRS9WYQm1wmtX9IFSIB+9Zwdg4hrlDZ
a6LiAd5nO+1K3DeEN9H1s/YiD6E/EW6mqT+ER3ILm30sH2L2Tk1kvNUQHGU0
a4K+PETg7/0sjcAh5MgpPLq4phgOFXoFV8hDUHK/Px+nSlG1+MQz9aohnHx5
2abnSSmkPK509NQO4eG3u/b0H6Vok3wjoNY2hIaUGzfLIh/jgL++G+PzEGR6
95nJJDzBJrXDihtUh+F6auvj7zoUXLvitadNYxhpS3w+b3OkgNsfa3leexjl
SeZuc6EU3IlrutJqOIyfYk48AwoFEmNGo8Few7g3czjOTq4MZ3W8/6zxG8bn
T7Ynvu0sQ3NmwnJ6yDBCD0XHLjErQ8zBloPy1wh74zJZRmQZZgpM7r29R8T3
aO06O1AGmxmfl36lwwhZoKwk+a0M5ebJzFVPh1GQ49i2Y145fGbfifi+GUaT
YtqSz5vLQbeZWC3TMgwvYbt9l/XKofRYXLOuaxjGPcVf06zLwXY095TmDuOF
+qYC+bBy6FD9Il59HEZkKvn2rYRy5CxKy/KeHMbLOykyKbfLYV3d8bZWYAQD
yrx1rBflaJK2VPJSGEFH2vK1stPlqJkuu/hFaQRjLJqwtDAV5T3LOoO2jEDB
71Nj8lIq7mR3XrykM4KQ+zryk0pUpIdodM4/NALdrErukAYV146lKyWbjKCd
ZD6pv48KP+mjnbccRzBoNNSXYE6FxzRFaa37CPQsaYdP21Fh1yMRXuQ9Aq8t
WWpvXakwrfTvVA8cwcir4i95p6g4kN2hRA0bQeBJV+GfflTsDtkWrn15BCp7
1068C6FC/VhaJy1uBJI2Vns3RFCxbtc3JYO0EXyeson5fYUKaWmL8NYbI4h6
6u17NI4KsWlyp2X+CGbzSos3JVMh0LNUub9oBL62AtPR6VT8qPALP/6E8FcT
WeWWRcXHrPZOfsUI1m+ae//6JhUj57Yq+9SMwFuj/cCD21R02aSGf68fgYxY
j5RkHhWNml87z7eOgBLCtxb+3/c1VpgrzzFGUHhIdV44iYqyqSfhVwdHcDZE
ekfEXSqKusW7xEZHEGNr/HNBIRW3K3yVM8ZHsJoafk6e4LSstnCZ7yNomXdi
qJbwv3puS1ferxGo12V4fiHiXbBJUd4oyMLLQn+bYmI9X82J8BJRFgyXi/2Z
JvJxX2HWpSFBcL4QhXmH6PfUY+VnK1lISjjTp59DhUn3koj9Cix8DiJzDW9Q
oVdxtqteiYW4Vb6Hudep2JX1TvnIFha27XGOl0yjQu3c5ohOTRa+3FDWHEyk
Yq1NcpetDgvOa45wdGKpWLTCNMLDhIX81bz63nAq5n6Udo1bEes3aNlLhhL9
ZS5WCXBkYWGw44Mv/lQMZ7Z2RXizUGMtlZbsTvQzWF1FJJCFcQ//DhsnKhqs
kyISwligHe9Z0WBNBUXKROVGHAvRBR32RfpU3P9REiGfxoLDC6kDssR+y2GK
MQpvsJBd7SO0fwcVMZktEZQiFpTFf2jmrqXCVuoIg17PQlnYj51TP8th8qNY
xaKVhQcL7QIVv5RDl7kosofBglpH2y0JbjlUM5tVRrksrEyMoGi1lGNu4UZE
CrCBFX+TZ3LKMTT1/JmACBtzn/KzDVLL8ZxjsT16ARv3hcW6zkaXI7g6fGOc
OBtD6rp15mfK8eEUUyxjNRs7i71P39IuR0djdN99LTbejT3durirDI+pqyxV
9rHx+yy4rPoyJOSTW4rBxkrlyfjHVWXQDx2sJRuwEbz6qTpyy/BMacf9ams2
XNhr5EJPlaHgKjfgnT8bqiFKuSsEyxARcP6TeTAbEYwUjdgfFDg4i3t2hbLR
EsZ6IPWBAinNPXa9kWysvn69ILGdgjhe+n5OEht7hDdpbCigwLND+Zl7Ghsr
hDaYkDMpOPCyRmPsOhsLdAr4J+Mp+Hv944ZPOWxkZDhXuQdREHBQT2zqIRuX
11iothpRYLa1Nya0lI3oHHbef6BAXe7s7C8yG4N/rsfZ7qJg7PvNydlKNo7Y
1wcPrafgzciWM5efs3FzdMZIUI5CzFH1POFaNoQiQ7S9JYn8737rFX3LRuZ/
zcNLhSjYnXLtaGITG1ZOczEFP8iQurC6ZUkrGx+a+XrP+GS0HTWslWSwYWmS
/ek5nYwSnZHdWT1stBvlfyx9SUbcpuCylQNscO1W/ztIIeOAYMG91Rw2Lj7Y
t8zvFhn7DxgNjfPYsB+0SdNIIUM7+vvy6g9s3JGsM26IJmNn/e0jsZ/ZqI3V
dNe4QMa2eYeibb6xQTG49SkkgAx1g4nn63+wwRKj8HJOk6ESe+P75E82Gh+8
1CGdIGNDk67qqz9s3J3YxEx2IkNh4bhbyhwb8vt2BnnYkiFrfP2WkzAHjzMy
GSpWZEgn7utUXcBBl/Pm2yPmZEi28kV/LeLAkfXMKd6UDPElqbqN4hwkmobd
UDchY5GZ1vksSQ6+FY9XthwhY14qh+wuzcGMU4ikN2EX6Eh4ryHLASVe5csi
MzL+SuxUEFjDgcwBr3NlFmTMHB0+1raOA9FLJfWu1mT8l3Et5c5GDhj/9rLk
7MmYYGxt8N7EQd2Xj1S+CxnjUv3/tDZz4HCjXe61JxljNlc0F2hwIMKWGKCc
JYObrXa2eycHTm9zb1eFkDHSy7xXqMWB27vp6d5LZPTLRA4F7OPgRNB/Z6SS
yGDaK0vp6nIgkZXg7neTjI6cjiPi+hxIj93Z+uk+Ga2DYdFDhzngnn29KOEp
GU2r178oPsJBh5SUjFk9GfXOrd/Pm3PQqj/fXbubDFreOdXDVhw8IWmwTN+T
Ubm26daoAwfFNmXs8AUUlLsFdJa5cNB2ZsrYmNhvj+/KLrx0gujX6+0vyfIU
3Ntw9vxqb6IfWYdvHyL2b4GnNGX8LAedrf+cQw/+7/txtPfPAjgovGHaefAo
BddVJG1twoj+vhEef+JLQcrpFynrIziIcZO6ZBZJQUKxR8PkJQ6WvZ19kJBC
wRX1Ks2UOA5O5nsIDxDzh/82J6nGGxzsnrc3bPAvBT4B80yybhP2pyWxJ5eV
wav8SbR7PgdCPlZxqUplcNkp+N9cEQd7z2fJv7Asg6lWUadWJdE/WeqvoPIy
GIaZL1zwnPhek0E24y3EefJ8Rre7hgNdhUtdf/ll2LfvCCXgLQck9iLbH3LE
+af7LaWYycHfQw4D8sT5JhoRtUKrj4OE4Iwgl5JyjFWL33k7yMFlv4sDik3l
KNyx+RGby0HTikLLncT8sFrZ+430JAd7LF5UeERRIS7O+3llCRfEZdpgZ+pT
fDYOipRYxoXNQGWrCfUpmmOF5uVJcSGcM6Ew0PsUsYLrJKvluHCrPnnITLEC
AlPO6l83ceG+KTX0/MsKfB/sdXU04KLc9NaK2yJV6JDxev/BiIs1FhannbdW
4YnN9NkQUy5y3SyvRThU4Uy71MV0ay56lE+f6SirAq/uaFbjCS70S9kv0jye
oedRC31HFBcuKuvn3vdV43kobfviZ1y8WrZM0PXrS/DOT/TGvuCikyfoqLOu
BuIX5COEaVwEXu0f1LKqgXv4xcbfb7nY90d695WqGiy+vNvpI4MLv+Rbzhsv
18I5gXy14SsX9IMyIoFiryCQm993SXkUYl/+rV+Q/xqqeW0Rf1VHIVyYEcyp
eg3r/H+K57eMIu+gRktxx2s8Ijme9dMcxd2LBS3zhepgWbRSyOXgKDRstxs3
u9ehkJyqtvf4KAKLxB9VKb6BQV1U5FT2KDLSV0QHxtUjVaaO8zJnFNuv9O47
ml+PPl+RQzF5o3joeldjtqIep+XixZYXjeLc30MdNG49koIzbm6rGIWlzuya
Nu236FK6X36GQeQj+CMmYfgt5CLer9jROwoBUvbJ2W9v4cHYFPZ7YBQqQedF
dos0YCrqCeK5BCfkDP7Y1ACZ/qrWoslRSJZpLb8V2ACXxOYxzlIemJP9LoYz
DXjAWWz8aDkPias8onkLGvFtt/lj/5U8FAusrdFb2YjLPEbQ3BoeLJL+OUOz
Efd0hgXkt/CQWZm43dC3EV+uK3jwNHgY8DxY/uViI3aNuzWWaPJQezeu3jq+
EY3ZY8l7dHjQNje1OVXYiPGvX2XtTHiIaQjxL2E2YofB9kgFCx5G4pgkd3Yj
wu8Ec8aseJgRt/dlfWrEEqNfD8458tD24orFeqEmbLsrpHndm4eykkut79Wa
EDajf9PBl4df/HY0aTahziz2z7pAHraF2/X6oQnWf8TqKGE8HKiYuS9t2YRQ
6xXmbXE86GqluzKCm3C3SEfQJokHMumKYVB4E9pmPKmDqTyIdfyd4kc3YUNu
5cqP2TwUrDD+eSijCV18W7bwfR5EVyU2Cj5uwuzuSxkJD4n+fUz8z5DahE0J
D/WXlfIQeMx2yqu6CZe2/Hq4hspDiXGu0ba3TdgSmhOg/ZoHbt/k/dmBJjjQ
69a/quchJd+/V4bdhKtyn7oNmngwjEjtleA3YYi2d491Ow+y79ZG5U40IV50
WMhvmIcNbHKVrgAdTx3mVUyxifp1Iq+7itDBLt3sFc7j4bFpo5CnKB27jka2
xH/iYf+qDzsUJOjg3VLIvPeLB1bJvJuBa+iQ+HzYQO0fDx6Ss9SOdXTs3e8/
UybAx58sPkN2Ix0Z3FdOtAV8vJ5aJhyqRgfUTmwcWMGHSeKLBu/ddOS8vFe5
dDsfexJy+xRN6WgQf3cqW5OPYtndN6rN6Zh0nZKV1+aDwtxdamJJh+E8gyhV
XT7advbJ+tjSMWX6/vAhMz7OrP/z77EbHRasTf0XvPmoLFy9ZGsoEf+ap5Gp
Lx/koPkrjS8Q+W8mVSsE8vFVatWmcxF0nA+XyakP40Og9CZbIIaOglULHMXj
+fA1qGuVyqBj/NWBFnYSH51tz4x7sujYeSpyLzWND7xzf1J+i46myik5u5t8
7OruiHhNouObFW+I9IAPpd/K+5yodOz5o2AaXMJHVd6Db6ue0RFz17HGgMzH
1X/TC/69pENmsiv3UyWR//fZIK1GOk7cFBevfc6HQ3+1yfVWOkphHJlWy4ex
lUSaTBcduimvXTQb+GC2kfFgmI4EzX9tC5r52JgxJUMdpYM5pIWBd3wMU27t
mvhIxyk1ikJUNx88u2NT09N0pDblsZt4fOx76fYscHkz+vwGLG5/4EP4TafQ
KrlmKK6Ufn32Mx9ZVX/zfyo2o9IzmST5g48K78qlJ3Y0Y0Qo/IST8Bjqt/68
JGrbDJXiqq4tC8awPztPO8W1GYFH/zsgKDYGZ7q2qbV3M+YXeK8vkhxDnvhV
jfuRzdiiY8/7um4M4m41yYHFzTjPy7Su2ziGuNsRI8srm1GX2FGfuWkM0TJq
x/++bsaxgcP3tTXGUPn2x/T9gWZEhu46Ga07hkOdhef9lragrWz5B+njY9ig
Wv78VGwLjpLaN+4keLtyyCSPYGZaovtRgsOVsva4xbVg0E+YlUjwfPX3wg7x
Lfiw+b9uAdcxnD/wLdAksQVCxV1vxgnevFDnzc7UFuy+m55fe2IMFMtRjeU3
WvA83XR4kGDvzHMV6QTvv7xQ7hfBY3svHJG42QJ918vZO9zHUJ0x/GTJrRZY
rglIfkiwivpaq4W3W+CTY3Exw2MM95y3S4rkt+Br/OJqMsH551ATTXBgWNN0
K8ESKs0XhAtaEGanG7jAcwzSaxw3C5NacE162+lwgq/GRfoLF7Zg4fzPRbcI
dqckkqMJTpp6wKsk+OkXOUGRey24zlRwnSR47njToMj9FkjXD+aKnxxD41e+
x1WCc6g3BtUIJhvHC8wvaoF8odUqI4IPyFOfXCP4/973x/+/7/8/srhOGA==

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{{-0.7, 0.7}, {-0.024961717657913243`, 0.2160348218823443}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4263595376866226`*^9}],

Cell[BoxData["\<\"find_zeroes.eps\"\>"], "Output",
 CellChangeTimes->{3.426359537896925*^9}]
}, Open  ]]
},
WindowSize->{788, 793},
WindowMargins->{{26, Automatic}, {Automatic, 36}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 488, 16, 261, "Input"],
Cell[CellGroupData[{
Cell[1081, 41, 2313, 59, 461, "Input"],
Cell[3397, 102, 32214, 534, 310, "Output"],
Cell[35614, 638, 92, 1, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

