(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12408,        320]
NotebookOptionsPosition[     12037,        305]
NotebookOutlinePosition[     12455,        321]
CellTagsIndexPosition[     12412,        318]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the predator-prey model where two ODEs describe \
two populations. This particular example is called the fox and rabbit model.

Figures 9.8 and  9.9 were created with this notebook.
(Errata: The figure was generated, as you will find in this notebook,  with \
equation (9.12) omitting the 0.5 factor.)

See Chapter 9 : Computing Dynamic Processes for details.

Updated July 2008
\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4260972432298193`*^9, 3.426097277408966*^9}, {
  3.42627509765003*^9, 3.4262751845349646`*^9}, {3.426275601013832*^9, 
  3.426275654721059*^9}, {3.4262760033723955`*^9, 3.4262760107930655`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "the", " ", "vectorfield", " ", "package"}], " ", 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Specify", " ", "the", " ", "output", " ", "folder"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "vectorfield"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "The", " ", "first", " ", "equation", " ", "describes", " ", "rabbit", 
      " ", "growth"}], ",", " ", 
     RowBox[{
      RowBox[{"so", " ", "the", " ", "x"}], "-", 
      RowBox[{
      "axis", " ", "will", " ", "represent", " ", "the", " ", "number", " ", 
       "of", " ", 
       RowBox[{"rabbits", ".", " ", "The"}], " ", "y"}], "-", 
      RowBox[{
      "axis", " ", "represents", " ", "the", " ", "number", " ", "of", " ", 
       "foxes"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vecfield", "=", 
     RowBox[{"VectorFieldPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"2", " ", "r"}], "-", 
          RowBox[{"r", " ", "f"}]}], ",", 
         RowBox[{
          RowBox[{"-", "f"}], "+", 
          RowBox[{"0.9`", " ", "r", " ", "f"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"f", ",", "0", ",", "7"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "you", " ", "want", " ", "the", " ", "vectorfield", " ", 
      "plotted", " ", "on", " ", "its", " ", "own"}], " ", ".."}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"This", " ", "is", " ", "Figure", " ", "9.8"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<rabfoxfield.eps\>\"", ",", "vecfield"}], "]"}], ";"}], " ",
     "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Solve", " ", "the", " ", "dynamical", " ", "system"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Given", ":", " ", 
      RowBox[{"two", " ", "governing", " ", "ODEs"}]}], ",", " ", 
     RowBox[{"starting", " ", "values"}], ",", " ", 
     RowBox[{"and", " ", "a", " ", "domain", " ", "for", " ", "t"}]}], " ", 
    "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "We", " ", "want", " ", "the", " ", "solution", " ", "over", " ", 
      "time"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"0", " ", "to", " ", "time"}], "=", "10"}]}], " ", "*)"}], "\n",
    
   RowBox[{"(*", " ", 
    RowBox[{"Solution", ":", " ", 
     RowBox[{"comes", " ", "in", " ", "definitions", " ", "for", " ", "r", 
      RowBox[{"(", "t", ")"}], " ", "and", " ", "f", 
      RowBox[{"(", "t", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"rabfox1", "=", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"r", "[", "t", "]"}]}], "-", 
          RowBox[{
           RowBox[{"r", "[", "t", "]"}], " ", 
           RowBox[{"f", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
        "                                ", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"f", "[", "t", "]"}]}], "+", 
          RowBox[{"0.9`", " ", 
           RowBox[{"r", "[", "t", "]"}], " ", 
           RowBox[{"f", "[", "t", "]"}]}]}]}], ",", "\[IndentingNewLine]", 
        "                                ", 
        RowBox[{
         RowBox[{"r", "[", "0", "]"}], "\[Equal]", "5"}], ",", 
        RowBox[{
         RowBox[{"f", "[", "0", "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", "                                 ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"r", "[", "t", "]"}], ",", 
        RowBox[{"f", "[", "t", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "code", " ", "loads", " ", "the", " ", 
     "InterpolationFunction", " ", "objects", " ", "into", "  ", "rab1", " ", 
     "and", " ", 
     RowBox[{"fox1", ".", " ", "A"}], " ", "shorter", " ", "way", " ", "to", 
     " ", "do", " ", "this", " ", "is", " ", "below"}], " ", "*)"}], "\n", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"rab1", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"rabfox1", "\[LeftDoubleBracket]", 
         RowBox[{"1", ",", "1", ",", "2"}], "\[RightDoubleBracket]"}], "\n", 
        "fox1"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"rabfox1", "\[LeftDoubleBracket]", 
          RowBox[{"1", ",", "2", ",", "2"}], "\[RightDoubleBracket]"}], "\n", 
         "rabfoxplot1"}], "=", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"rab1", ",", "fox1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Thickness", "[", "0.02`", "]"}], ",", 
             RowBox[{"GrayLevel", "[", "0.4`", "]"}]}], "}"}]}], ",", 
          RowBox[{"BaseStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], 
             ",", 
             RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], 
         "]"}]}]}]}], ";"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"r", 
     RowBox[{"(", "t", ")"}], " ", "and", " ", "f", 
     RowBox[{"(", "t", ")"}], " ", "are", " ", "defined", " ", "in", " ", 
     RowBox[{"rabfox1", ".", " ", "Use"}], " ", "the", " ", "ReplaceAll", " ",
      "command", " ", "to", " ", "get", " ", "them", " ", "for", " ", 
     "plotting"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rabfoxplot1", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"r", "[", "t", "]"}], ",", 
           RowBox[{"f", "[", "t", "]"}]}], "}"}], "/.", " ", "rabfox1"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.015", "]"}], ",", " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0.3", ",", " ", "0.3", ",", " ", "0.8"}], "]"}]}], 
         "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "parametric",
      " ", "plot"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Graphics", "[", "rabfoxplot1", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "start", " ", 
     RowBox[{"point", " ", "--"}], " ", "five", " ", "rabbits", " ", "and", 
     " ", "2", " ", "foxes"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startpoint", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"5", ",", "2"}], "}"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.05`", "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "it", " ", "all", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"vecfield", ",", "points", ",", "startpoint"}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<foxrab.eps\>\"", ",", "pic"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4262751907138495`*^9, 3.426275398692909*^9}, {
  3.4262754585189342`*^9, 3.426275468242917*^9}, {3.426275505957147*^9, 
  3.4262755070987887`*^9}, {3.42627568274135*^9, 3.426275805798298*^9}, {
  3.4262758422306848`*^9, 3.42627588020529*^9}, {3.4262760138674865`*^9, 
  3.4262760200563855`*^9}, {3.4262760661726975`*^9, 3.426276078800856*^9}, {
  3.426276112028635*^9, 3.4262761602880287`*^9}, {3.4262766972801857`*^9, 
  3.4262767945500526`*^9}, {3.426276832504629*^9, 3.4262768363802013`*^9}, {
  3.4262770222174225`*^9, 3.4262771804749856`*^9}, {3.4262772138730097`*^9, 
  3.4262772588877373`*^9}, {3.4263400258900366`*^9, 3.426340026190469*^9}}]
},
WindowSize->{819, 863},
WindowMargins->{{28, Automatic}, {Automatic, 3}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 820, 21, 340, "Input"],
Cell[1391, 44, 10642, 259, 1347, "Input"]
}
]
*)

(* End of internal cache information *)
