(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72749,       1297]
NotebookOptionsPosition[     72131,       1275]
NotebookOutlinePosition[     72549,       1291]
CellTagsIndexPosition[     72506,       1288]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates a graph that is a function and one that is not.
This example corresponds to Figure 7.1 in the text.


See Chapter 7: Background: Numerical Calculus for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{
  3.4258642522049475`*^9, {3.4258642909506607`*^9, 3.4258643470813727`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Define", " ", "plot1"}], ",", " ", 
     RowBox[{"which", " ", "is", " ", "a", " ", "function"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plot1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"5", " ", "x"}], "]"}], "-", "0.5`"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "0.7`"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.5`", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Define", " ", "plot2"}], ",", " ", 
     RowBox[{
      RowBox[{
      "which", " ", "is", " ", "not", " ", "a", " ", "function", " ", 
       "because", " ", "for", " ", "a", " ", "given", " ", "x"}], "-", 
      "values"}], ",", " ", 
     RowBox[{
      RowBox[{
      "there", " ", "are", " ", "instances", " ", "where", " ", "there", " ", 
       "are", " ", "two", " ", "associated", " ", "y"}], "-", 
      RowBox[{"values", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plot2", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", "x", "]"}], "+", "2"}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "4"}], ",", "0.5`"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "two", " ", "curves", " ", "together"}], 
    " ", "*)"}], "\n", 
   RowBox[{"final", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plot1", ",", "plot2"}], "}"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "postscript", " ", "plot"}], " ", "*)"}],
    "\n", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<funcnofunc.eps\>\"", ",", "final"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.425864352068544*^9, 3.4258644027414083`*^9}, {
  3.4258644454728527`*^9, 3.425864526739709*^9}, {3.425864764621766*^9, 
  3.4258647783815517`*^9}, {3.425864963127203*^9, 3.425864966201624*^9}, {
  3.425865018306547*^9, 3.425865019978952*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.5], Thickness[0.01], LineBox[CompressedData["
1:eJwV13c8Vf8fB3BlZJQGIQlJqDQ0JKk3MhqS/S3ZysxqGFmVWTJKWS2EjJKs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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-0.7, 1}, {-1.2615830951376683`, 1.5410754679669085`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.4258645315366063`*^9, {3.425864765843523*^9, 3.425864778902301*^9}, 
   3.425865020730032*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV2nk4VF0YAHDbzESWNikRSZYsbZKI95ZIpU2IUggpoZL0SaVUlCgkZEmF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     "]]}},
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1.0000000927441954`, 2.99999974288115}, {-0.999999961816061, 
   0.9999993875785476}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.4258645315366063`*^9, {3.425864765843523*^9, 3.425864778902301*^9}, 
   3.4258650207700896`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], Thickness[0.01], LineBox[CompressedData["
1:eJwV13c8Vf8fB3BlZJQGIQlJqDQ0JKk3MhqS/S3ZysxqGFmVWTJKWS2EjJKs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      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV2nk4VF0YAHDbzESWNikRSZYsbZKI95ZIpU2IUggpoZL0SaVUlCgkZEmF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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.4258645315366063`*^9, {3.425864765843523*^9, 3.425864778902301*^9}, 
   3.4258650208001328`*^9}],

Cell[BoxData["\<\"funcnofunc.eps\"\>"], "Output",
 CellChangeTimes->{
  3.4258645315366063`*^9, {3.425864765843523*^9, 3.425864778902301*^9}, 
   3.4258650208702335`*^9}]
}, Open  ]]
},
WindowSize->{851, 854},
WindowMargins->{{50, Automatic}, {9, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 498, 17, 245, "Input"],
Cell[CellGroupData[{
Cell[1091, 42, 3736, 95, 407, "Input"],
Cell[4830, 139, 18140, 306, 248, 12582, 212, "CachedBoxData", "BoxData", \
"Output"],
Cell[22973, 447, 18352, 308, 385, "Output"],
Cell[41328, 757, 30614, 510, 248, "Output"],
Cell[71945, 1269, 170, 3, 40, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
