(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9446,        263]
NotebookOptionsPosition[      9034,        247]
NotebookOutlinePosition[      9454,        263]
CellTagsIndexPosition[      9411,        260]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates contouring. Two functions are given, f(x,y) and \
g(x,y). We then look at the zero contour of the difference of the two \
functions, f(x,y) - g(xy).

Figure 11.9 was created with this notebook.

See Chapter 11: Computing with Multivariate Functionsfor details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4263637293639584`*^9, 3.4263637439248962`*^9}, {
   3.4263648829427233`*^9, 3.426364918013152*^9}, {3.4263650271701117`*^9, 
   3.426365063942989*^9}, 3.4263660514830017`*^9},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Create", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "first", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f1", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{"2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}]}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "second", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f2", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"0.7`", " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"0.4`", " ", 
        SuperscriptBox["y", "3"]}], "-", "0.4`"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "zero", " ", "function"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f0", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", "0"}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "first", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "90", " ", "plot", " ", "points", " ", "makes", " ", "it", " ", "a", " ", 
     "very", " ", "smooth", " ", "surface"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"plot1", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f1", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5`"}], ",", 
          RowBox[{"-", "1"}], ",", "0.8`"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", "\"\<RustTones\>\""}], ",", " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "second", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"plot2", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f2", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0.5`", ",", 
          RowBox[{"-", "1"}], ",", "0.8`"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", "\"\<ValentineTones\>\""}], ",", 
       " ", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "plots", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"Picture", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"plot1", ",", "plot2", ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5`"}], ",", 
          RowBox[{"-", "1"}], ",", "0.8`"}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Uncomment", " ", "when", " ", "wanted"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<function1.eps\>\"", ",", "plot1"}], "]"}], ";"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<function2.eps\>\"", ",", "plot2"}], "]"}], ";"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<two_functs.eps\>\"", ",", "Picture"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4263650675581875`*^9, 3.426365252424011*^9}, {
  3.426365372536725*^9, 3.4263653969418173`*^9}, {3.426365453853653*^9, 
  3.4263654914477105`*^9}, {3.426365537393778*^9, 3.4263655603067245`*^9}, {
  3.426365642474877*^9, 3.4263656441472816`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Now", " ", "create", " ", "the", " ", "contour", " ", "of", " ", "the", 
    " ", "difference", " ", "of", " ", "the", " ", "two", " ", "functions"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Plot", " ", "f2"}], " ", "-", " ", "f1"}], " ", "=", " ", "0"}],
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"pic", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f2", "[", 
        RowBox[{"x", ",", "y"}], "]"}], "-", 
       RowBox[{"f1", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"Contours", "\[Rule]", 
       RowBox[{"{", "0", "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<contour_intersect.eps\>\"", ",", "pic"}], "]"}], ";"}], 
    " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4263656789172783`*^9, 3.426365742749064*^9}}]
},
WindowSize->{829, 807},
WindowMargins->{{114, Automatic}, {Automatic, 10}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 699, 19, 249, "Input"],
Cell[1270, 42, 6110, 157, 953, "Input"],
Cell[7383, 201, 1647, 44, 225, "Input"]
}
]
*)

(* End of internal cache information *)
