(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38469,        817]
NotebookOptionsPosition[     37874,        795]
NotebookOutlinePosition[     38313,        812]
CellTagsIndexPosition[     38270,        809]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates histograms, bar charts, and pie charts.

Figures  12.10, 12.11, and 12.12 were created with this notebook.

See Chapter 12: Visualization of Empirical Data for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4268766033193026`*^9, 3.4268767004389534`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "packages"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "the", " ", "folder", " ", "for", " ", "output"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", 
     RowBox[{"data", ":", " ", 
      RowBox[{
      "men", " ", "and", " ", "women", " ", "population", " ", "in", " ", 
       "millions"}]}]}], " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"men", "=", 
      RowBox[{"{", 
       RowBox[{
       "3.8`", ",", "3.9`", ",", "3.7`", ",", "4.2`", ",", "3.9`", ",", 
        "3.8`", ",", "2.5`", ",", "2.1`", ",", "0.5`", ",", "0.4`"}], "}"}]}],
      ";"}], ")"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"women", "=", 
      RowBox[{"{", 
       RowBox[{
       "3.2`", ",", "3.3`", ",", "3.35`", ",", "5.`", ",", "3.5`", ",", 
        "3.8`", ",", "3.2`", ",", "3.`", ",", "2.`", ",", "1.1`"}], "}"}]}], 
     ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "bar", " ", 
     RowBox[{"chart", " ", "--"}], " ", "histogram", " ", "of", " ", 
     RowBox[{"men", "/", "women"}], " ", "in", " ", "age", " ", 
     "categories"}], " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"BarChart", "[", 
      RowBox[{"men", ",", "women", ",", 
       RowBox[{"BarLabels", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<0-9\>\"", ",", "\"\<10-19\>\"", ",", "\"\<20-29\>\"", ",", 
          "\"\<30-39\>\"", ",", "\"\<40-49\>\"", ",", "\"\<50-59\>\"", ",", 
          "\"\<60-69\>\"", ",", "\"\<70-79\>\"", ",", "\"\<80-89\>\"", ",", 
          "\"\<90+\>\""}], "}"}]}], ",", 
       RowBox[{"BarOrientation", "\[Rule]", "Horizontal"}], ",", 
       RowBox[{"BarSpacing", "\[Rule]", "0.1`"}], ",", 
       RowBox[{"BarGroupSpacing", "\[Rule]", "0.5`"}], ",", 
       RowBox[{"BarStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.7`", "]"}]}], "}"}]}], ",", 
       RowBox[{
       "PlotLabel", "\[Rule]", "\"\<2001 UK Population in Millions\>\""}], 
       ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "postscript", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<population_histogram.eps\>\"", ",", "pic"}], "]"}], ";"}], 
    ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "barchart", " ", "in", " ", "another", " ", 
     "style"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"bcpic", "=", 
     RowBox[{"BarChart", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "2", ",", "2.5`", ",", "5", ",", "5.5`", ",", "5", ",", "3.5`"}], 
        "}"}], ",", 
       RowBox[{"BarSpacing", "\[Rule]", "0.1`"}], ",", 
       RowBox[{"BarGroupSpacing", "\[Rule]", "0.5`"}], ",", 
       RowBox[{"BarLabels", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Apr\>\"", ",", "\"\<May\>\"", ",", "\"\<Jun\>\"", ",", 
          "\"\<Jul\>\"", ",", "\"\<Aug\>\"", ",", "\"\<Sep\>\""}], "}"}]}], 
       ",", 
       RowBox[{"BarStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"GrayLevel", "[", "0.7`", "]"}], "}"}]}], ",", 
       RowBox[{
       "PlotLabel", "\[Rule]", 
        "\"\<2008 Tourist Season Projected Profits in Millions\>\""}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<barchart.eps\>\"", ",", "bcpic"}], "]"}], ";"}], ")"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "pie", " ", "chart", " ", "of", " ", "ethnice", 
     " ", "groups"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"ppic", "=", 
     RowBox[{"PieChart", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "45.4`", ",", "35.7`", ",", "9.3`", ",", "8.9`", ",", "0.7`"}], "}"}],
        ",", 
       RowBox[{"PieLabels", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Hispanic 45.4%\>\"", ",", "\"\<White 35.7%\>\"", ",", 
          "\"\<African American 9.3%\>\"", ",", "\"\<Asian/Pacific 8.9%\>\"", 
          ",", "\"\<Other 0.7%\>\""}], "}"}]}], ",", 
       RowBox[{
       "PlotLabel", "\[Rule]", 
        "\"\<2005 Population in Southern California\>\""}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"PieStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.85`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.9`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "0.95`", "]"}], ",", 
          RowBox[{"GrayLevel", "[", "1.`", "]"}]}], "}"}]}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "poscript", " ", "file"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<piechart.eps\>\"", ",", "ppic"}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.426876706067046*^9, 3.426876721298949*^9}, {
   3.4268767860019875`*^9, 3.4268770348898706`*^9}, {3.426877097549971*^9, 
   3.426877131168312*^9}, 3.4268772533540063`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 0.925}, {3.8, 1.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 1.925}, {3.9, 2.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 2.925}, {3.7, 3.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 3.925}, {4.2, 4.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 4.925}, {3.9, 5.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 5.925}, {3.8, 6.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 6.925}, {2.5, 7.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 7.925}, {2.1, 8.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 8.925}, {0.5, 9.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], EdgeForm[Opacity[0.5]], 
    StyleBox[RectangleBox[{0, 9.925}, {0.4, 10.075}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 1.175}, {3.2, 1.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 2.175}, {3.3, 2.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 3.175}, {3.35, 3.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 4.175}, {5., 4.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 5.175}, {3.5, 5.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 6.175}, {3.8, 6.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 7.175}, {3.2, 7.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 8.175}, {3., 8.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 9.175}, {2., 9.325}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0, 10.175}, {1.1, 10.325}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0, 0.375},
  AxesStyle->{},
  Background->None,
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  BaselinePosition->Automatic,
  ColorOutput->GrayLevel,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{Automatic, {{1.125, 
      FormBox["\"0-9\"", TraditionalForm], 0}, {2.125, 
      FormBox["\"10-19\"", TraditionalForm], 0}, {3.125, 
      FormBox["\"20-29\"", TraditionalForm], 0}, {4.125, 
      FormBox["\"30-39\"", TraditionalForm], 0}, {5.125, 
      FormBox["\"40-49\"", TraditionalForm], 0}, {6.125, 
      FormBox["\"50-59\"", TraditionalForm], 0}, {7.125, 
      FormBox["\"60-69\"", TraditionalForm], 0}, {8.125, 
      FormBox["\"70-79\"", TraditionalForm], 0}, {9.125, 
      FormBox["\"80-89\"", TraditionalForm], 0}, {10.125, 
      FormBox["\"90+\"", TraditionalForm], 0}}},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->FormBox["\"2001 UK Population in Millions\"", TraditionalForm],
  PlotRange->{All, {0.375, 10.875}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{Automatic, {{1.125, 
      FormBox["\"0-9\"", TraditionalForm], 0}, {2.125, 
      FormBox["\"10-19\"", TraditionalForm], 0}, {3.125, 
      FormBox["\"20-29\"", TraditionalForm], 0}, {4.125, 
      FormBox["\"30-39\"", TraditionalForm], 0}, {5.125, 
      FormBox["\"40-49\"", TraditionalForm], 0}, {6.125, 
      FormBox["\"50-59\"", TraditionalForm], 0}, {7.125, 
      FormBox["\"60-69\"", TraditionalForm], 0}, {8.125, 
      FormBox["\"70-79\"", TraditionalForm], 0}, {9.125, 
      FormBox["\"80-89\"", TraditionalForm], 0}, {10.125, 
      FormBox["\"90+\"", TraditionalForm], 0}}},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.4268770364721456`*^9, 3.4268771344530354`*^9, 
  3.4268772020302067`*^9, 3.426877255947736*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0.8, 0}, {1.2, 2}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{1.8, 0}, {2.2, 2.5}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{2.8, 0}, {3.2, 5}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{3.8, 0}, {4.2, 5.5}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{4.8, 0}, {5.2, 5}]}, 
   {GrayLevel[0.7], EdgeForm[Opacity[0.5]], 
    RectangleBox[{5.8, 0}, {6.2, 3.5}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0.25, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  BaselinePosition->Automatic,
  ColorOutput->GrayLevel,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["\"Apr\"", TraditionalForm], 0}, {2, 
      FormBox["\"May\"", TraditionalForm], 0}, {3, 
      FormBox["\"Jun\"", TraditionalForm], 0}, {4, 
      FormBox["\"Jul\"", TraditionalForm], 0}, {5, 
      FormBox["\"Aug\"", TraditionalForm], 0}, {6, 
      FormBox["\"Sep\"", TraditionalForm], 0}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->FormBox[
   "\"2008 Tourist Season Projected Profits in Millions\"", TraditionalForm],
  PlotRange->{{0.25, 6.75}, All},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["\"Apr\"", TraditionalForm], 0}, {2, 
      FormBox["\"May\"", TraditionalForm], 0}, {3, 
      FormBox["\"Jun\"", TraditionalForm], 0}, {4, 
      FormBox["\"Jul\"", TraditionalForm], 0}, {5, 
      FormBox["\"Aug\"", TraditionalForm], 0}, {6, 
      FormBox["\"Sep\"", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.4268770364721456`*^9, 3.4268771344530354`*^9, 
  3.4268772020302067`*^9, 3.4268772561380095`*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {GrayLevel[0.7], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 9.135751436639119}]}, 
    {GrayLevel[0.85], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.135751436639119, 11.37884859130223}]}, 
    {GrayLevel[0.9], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {11.37884859130223, 11.963184824869934`}]}, 
    {GrayLevel[0.95], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {11.963184824869934`, 12.522388317208916`}]}, 
    {GrayLevel[1.], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {12.522388317208916`, 12.566370614359174`}]}}, {
    InsetBox["\<\"Hispanic 45.4%\"\>", \
{0.08640646953135141, 0.5937456711615905}], 
    InsetBox["\<\"White 35.7%\"\>", \
{-0.4038075081058643, -0.4437786569871655}], 
    InsetBox["\<\"African American 9.3%\"\>", \
{0.37514559380142315`, -0.46825824440299774`}], 
    InsetBox["\<\"Asian/Pacific 8.9%\"\>", \
{0.5688611422104192, -0.1907799802994465}], 
    InsetBox["\<\"Other 0.7%\"\>", \
{0.5998549226621904, -0.013193625655502538`}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  BaselinePosition->Automatic,
  ColorOutput->GrayLevel,
  ContentSelectable->Automatic,
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->FormBox[
   "\"2005 Population in Southern California\"", TraditionalForm],
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  PreserveImageOptions->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellChangeTimes->{3.4268770364721456`*^9, 3.4268771344530354`*^9, 
  3.4268772020302067`*^9, 3.4268772562581825`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
},
WindowSize->{766, 869},
WindowMargins->{{-6, Automatic}, {Automatic, 4}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 479, 15, 261, "Input"],
Cell[CellGroupData[{
Cell[1072, 40, 7475, 177, 1281, "Input"],
Cell[8550, 219, 4508, 109, 330, "Output"],
Cell[13061, 330, 2294, 64, 340, "Output"],
Cell[15358, 396, 22500, 396, 503, 1989, 58, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
