(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58758,       1130]
NotebookOptionsPosition[     58189,       1109]
NotebookOutlinePosition[     58608,       1125]
CellTagsIndexPosition[     58565,       1122]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates the advantages of using a lin-log plot -- the \
x-axis is scaled linearly (normal method) and the y-axis is scaled \
logarithmically.

Mathematica also has log-lin plots (x-axis given logarithmic scale) and \
log-log plot where both axes are scaled logarithmically.

Figures 12.17 was created with this notebook.

See Chapter 12 : Visualization of Empirical Data for details.

Updated May 2008
\
\>", "Input",
 CellChangeTimes->{{3.426882267453928*^9, 3.4268822849891424`*^9}, {
  3.4268823559411664`*^9, 3.4268824036097107`*^9}, {3.4268826429438562`*^9, 
  3.426882760412768*^9}, {3.4268831732564077`*^9, 3.4268832088475857`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Needs", "[", "\"\<PlotLegends`\>\"", "]"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "output", " ", "folder"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Plot", " ", "some", " ", "functions", " ", "that", " ", "vary", " ", 
      "greatly", " ", "in", " ", "growth", " ", "using", " ", "standard", " ",
       "Plot", " ", 
      RowBox[{"technique", " ", "--"}], " ", "linear", " ", "in", " ", "x"}], 
     "-", " ", 
     RowBox[{"and", " ", "y"}], "-", "axies"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Because of the growth of the exponential function 10^x, the linear \
and quadratic functions are not visible\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         SuperscriptBox["10", "x"], ",", 
         SuperscriptBox["x", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "10"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.015`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"PlotLegend", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<x\>\"", ",", " ", "\"\<10^x\>\"", ",", " ", "\"\<x^2\>\""}], 
         "}"}]}], ",", " ", 
       RowBox[{"LegendPosition", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1.1", ",", 
          RowBox[{"-", "0.4"}]}], "}"}]}]}], "]"}]}], " ", ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Plot", " ", "the", " ", "same", " ", "functions", " ", "using", " ", 
      "a", " ", "log", " ", 
      RowBox[{"plot", " ", "--"}], " ", "linear", " ", "in", " ", "x"}], "-", 
     
     RowBox[{
     "axis", " ", "and", " ", "logarithmic", " ", "scale", " ", "in", " ", 
      "the", " ", "y"}], "-", "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<The lin-log plot produces a better result -- we can compare the \
growth of the three functions\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic2", "=", 
     RowBox[{"LogPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         SuperscriptBox["10", "x"], ",", 
         SuperscriptBox["x", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "10"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.005`", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.015`", "]"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postcript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<nonlogplot.eps\>\"", ",", "pic1"}], "]"}], ";"}], ")"}], 
   " ", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<logplot.eps\>\"", ",", "pic2"}], "]"}], ";"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.4268824112907553`*^9, 3.426882418621296*^9}, {
  3.426882466389984*^9, 3.4268825401360254`*^9}, {3.4268825966372705`*^9, 
  3.4268826378965983`*^9}, {3.426882794722102*^9, 3.426883025874483*^9}, {
  3.426883071560176*^9, 3.426883075155346*^9}, {3.4268831108466673`*^9, 
  3.4268831647141247`*^9}}],

Cell[BoxData["\<\"Because of the growth of the exponential function 10^x, the \
linear and quadratic functions are not visible\"\>"], "Print",
 CellChangeTimes->{{3.4268829464202337`*^9, 3.4268830268659086`*^9}, 
   3.426883075936469*^9, 3.4268831120083375`*^9, 3.426883227173938*^9}],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJxNz28w03EcwPGfGUebbTHyr2nzL7TrpGg9MI3u8iDrQim7I7VzrotTy4Pq
CJOdMGRi5yimlMzfOxVpt0aSbuLOlTTlUCMdu0SJpQc+3++D970ev9lJaSfE
JIIgojb77/ulY4EEscjfsp/WUhRFQXYEMOaqnZDF4pE6HhcZ/uEk8/IZpFqT
sDLTicyTpz9/k7IE7uMqIu+MmkD2WXEbZXoZ7JaT7aWaVVBlZx1UU7wGcqQl
9YqqDfD+H8nNo0+IsC3z9s5O7ReQQGqhzMOkswSN4rK4Nq4VyOhJ5E12WoNF
8gonOscGbC9YH6XLbEE2yY+XRaWAs7+6lYsZVHA52UE1bLYDHxPVRdnZdFBE
6ecpJQxQFnOXaArZDiaI1H09C8j4uhqDVYc9GHD9QXKXxAFsYE7/SPFjgkfm
SYPRC8iSG7H1oSpHUP1Q8730lBNoYtAK3F13gF+C5d6NeuSy0sS8UO4MfipL
lVTEuoBpkawRra0r6BvamuvzFlmwdCXoVq4bqDkYEx0X7A669zJfiVaRniRb
XlLzTlAondyoSWeBPn1G7cRuD3C4irqSM4E8Pibjtwp3gTR+Q07tI6Shvz3N
344NVlYOlRsvIhsjCZ7fAHLQxTuf7M8BBa/PxSTmIVVa9elFA9L545zN5gU4
NRIWMqBE9hrz6Yx1JMszUO+GmSkaL/bFDNXvofExX3S+o6ZiarLctg1hah1b
yLINJEcYp7uNmSOzkNZiCtaiLbswX35etZjF1DUJzOFmpNfMfK8QU8pSZMZj
RpR+Xb+Eqcso/HsP06v1QE8zptRouPYUM0IUuDaMqVKMP5vAJOtzr37DPG/D
PfQTs+/w2G8z5j8ZpTXE
        "]]}, 
      {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
       LineBox[CompressedData["
1:eJwV1nc4Fl4bB3Aee++9nmEkIuQnGc99nmwlsqVIZFRWRpQtiaySvYmMIqPM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        "]]}, 
      {Hue[0.14213595499957954`, 0.6, 0.6], Thickness[0.015], 
       LineBox[CompressedData["
1:eJwV0ms01Hkcx/ExLqsdl1GTBrOGGZTLJCSmbf0/xMZuixhMZVcp2bYt1ORU
9rAYjVQ0ShdbzGZcupDK6SpZt6I6uuyxhYhQo3QGkdxmfz34nvd5Pfg8+1pH
x4XE0Gk0WiC5L30+/JMLjaam/Pv+iv7SJqNLhwMZair3ZC+72FRNXXVkDp4m
3ddf0rxWoKayY56eFZI6BpSZj65TUytfhLN2kRp4Zu/rv6amKmqjPvVXqakn
VwdcmhOGqYychDsPtg5T6/ktyYdGRyhXQV7AiWcj1LbedXL6wnHKemPMZUbf
GNWza2Q2eHSGup2jM1daO0Hp8mmBq221oTTUcyvInqLe2Qjy7G5/BZ70SFHe
qVnK9mF41QsfQ5RMSvb736BBvGxVbsceE2Q4D/Qu9aHj52LpqH4bCwaHMrkj
Ddqwee7p57GdDVVMrviyQBe5K2p1JfocMKs3CLur9DB2nvK9zLHC4ZzjpsY8
faR9nOhZ7sbDlayZZ8aZc8B4+8i74xcbWNPthSkGDOx+9UJu8dIOA+O389WJ
BqAWB9l0r7HHWOw85WONISb3DrqVcp1wkXb6cGqqMagktdUnHWdEMpqE+RIm
QmIV7vvfL0GmSEG74GGCgEIO01DmiqjIisbqIRM00ezyZkyXYv3Zgi7dq3Mx
6bLCX9HuDsc/SmOvS+bB1qxeS1bmgWJW34et9iy86enW+xgrhN87ekvoEAtJ
F2erTaK+xZE/w4q8lPOhoLck3PL7DhXnat/LI0xRGu12tNKVwgjTKItjvgA2
2h9EBeVAz7Ic27LWBfAL/w+N170xlj/C2naMjXKaSBPc44OXuTskx8PMYH5t
UlNo5Iu4AMundXPMkZB6Lqfb2Q8LvSrT7R6ZY1pL+SB15/fIGt7tdjDdAiV9
KuWCslWo9RSFipdxcOO3V52J3f7g1LDuRU5wUMdImbJf/gP49DnC6PJvoJ1+
PHEo40cESbtnCxIssYfbc/DM+GrYNarqOhdxwXZLeRMVEYjHpww+pXVyQQvP
CBDcDEJwWyZVGWSFoizzTUOKYBhRxWmF560Q8YF9YF3kGnQ1XYlzMLSGfPwf
uq5TCE6efHhMtd0aJo7MX9OnQ1AWQBPa37dG0XMLBbc+FC1mtjIdBx7afNtl
EwUi+DRvEm3I4MElsVAeHx8GZV3FWnUXD9PbTtve9Q4Hu2OQfBUf271Kdq+0
j0DvU3jcz+fj/qRDh0RXjBqVzJg5w0caq6uybEIMS75LqwUxN+kOo4k4ObI9
eyFxNa9iy2tir1YnI4p4amk9x/KzGHernhjsIJbFVB84SlybYvH1Q+J/xwe3
JE+KUTf/kk7mLB/e7Z6LRdNi8ILEDUeJtTbiYAJxWqaWtJC4btHat9nEPlOh
2teJ/ZNqzjYT17+a0Bog3uQkZlMzYjRc8NGs1PDxoOaensOsGDb972qCiM+E
vd68ilhqmZe8njhewKzfTOwrfzOzk9hMcSalkLgh8dD038R75LLPLA3ZV7pX
lxOHLhGIXYmlqq6km8TOzL5rQcS+kS5Tj4lVuRmSLGJlXvutTuJm9/hnpcQ6
ren73hKfM/vdtZF4s75g+UfiLK+98l7iRu+2zxriOOUJtYb4f0JdOvI=
        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     AxesOrigin->{2., 0},
     BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
     DisplayFunction:>$DisplayFunction,
     FormatType->TraditionalForm,
     Frame->True,
     PlotRange->{All, All},
     PlotRangeClipping->True,
     PlotRangePadding->{Automatic, Automatic}], {-1, -0.6180339887498948}, {
    Left, Bottom}, {2, 1.2360679774997896`}], {
    {GrayLevel[0], 
     RectangleBox[{1.1500000000000001`, -0.45}, \
{1.8804347826086958`, 0.3500000000000001}]}, 
    {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.001]}], 
     RectangleBox[{1.1, -0.4}, {1.830434782608696, 0.40000000000000013`}], 
     InsetBox[
      GraphicsBox[{{{InsetBox[
           GraphicsBox[
            {Hue[0.1421359549995791, 0.6, 0.6], Thickness[0.015], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 0.08}, {
           Left, Bottom}, {1, 1}], 
          InsetBox["\<\"x^2\"\>", {1.21, 0.58}, {-1, 0}, Automatic, {1, 
           0}]}, {InsetBox[
           GraphicsBox[
            {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 1.24}, {
           Left, Bottom}, {1, 1}], 
          InsetBox["\<\"10^x\"\>", {1.21, 1.74}, {-1, 0}, Automatic, {1, 
           0}]}, {InsetBox[
           GraphicsBox[
            {Hue[0.67, 0.6, 0.6], Thickness[0.005], 
             LineBox[{{0, 0}, {1, 0}}]}], {0.08, 2.4}, {
           Left, Bottom}, {1, 1}], 
          InsetBox["\<\"x\"\>", {1.21, 2.9}, {-1, 0}, Automatic, {1, 
           0}]}}, {}},
       AspectRatio->1.0952380952380953`,
       FormatType->TraditionalForm,
       PlotRange->{{-0.1, 3.26}, {-0.1, 3.5799999999999996`}}], {1.1, -0.4}, {
      Left, Bottom}, {0.7304347826086958, 0.8000000000000002}]}}},
  AspectRatio->Automatic,
  Background->None,
  ColorOutput->Automatic,
  ImageSize->Automatic,
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.4268830154695215`*^9, 3.426883027316557*^9}, 
   3.4268830772783985`*^9, 3.4268831124589853`*^9, 3.4268832276345997`*^9}],

Cell[BoxData["\<\"The lin-log plot produces a better result -- we can compare \
the growth of the three functions\"\>"], "Print",
 CellChangeTimes->{{3.4268829464202337`*^9, 3.4268830268659086`*^9}, 
   3.426883075936469*^9, 3.4268831120083375`*^9, 3.4268832276546288`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.005], LineBox[CompressedData["
1:eJwV0n8803kcwPHvZhxhJvK7sUlL0p30w3rI+00/dR1Xy51qJTo6Sbuc9Ki7
FEZLIi5EpUJOaiKurJakRdcPlnr06Ifm8ogialtkku0+/ng/3o/n4/14/ffm
RInWRNMpigohM7GfaX7woSg1MJczWnQVkoAW5qUjIeZq8I0UnODkx0CdF6v/
pJ0aVDnh3+uzkiA7uqOU760GCW9zt/2+DFj8/Cfb39erIaDxQ1vrxgKobooY
6alXA7tyRkyOWwWk5+y8cT9WA2Y9Xj6+F/6BOd75wYWPtRBm3PBbWYcCOJHR
teZvhmGOoyzPmPUErucwJoubdCC5xmCXDbyEcksT35LsMVjSvk51K/o1cMVH
y/KL9GDeFdetuPkGKr4kZqxooJDNjZraWvAW0r/t7Z4bRMeIKWUq6td+sMiS
uGoVRpgekte84NMA9EXnhdd6G6NzFR5axvsILPlmfle9CSodz9roa9RwJKfA
zopriqWnHHg5VRq4nDn+2EpihntTCnkrc7XAoXvy91uYo1HVRutb+z5B7+fr
xeokC+x2unJCFjIEw1ttypUGS1SdSvRRegzDRerkkZQUK9R6s3anfxgGoXkL
vziRhYEPX/n7n/0MkrVnqAsLrJFvt9CrfP0IRAir78gHrXH6BuMEEaWDDaUl
KuO6yRhrtqbu0UUdeP3599ariTaY90SWGhw6Cuds33yI9bRFRfWx6MDXo7D0
Pf2eYNAWhWrP5ud7vsDRA2FlAeVTcC4z1GaT0RhUn28ayP3ZDuXbt8c/Sx8D
LYuZ6eJkj3sSHDueMb/C6/k5HpXt9mgI4rbWZH6F4WKtbdwxB5zZtmpQaTEO
r/J2JBaEOWKvesnlKsk4iILZHc1mTnj40buEt7px4AXUpE1/6ITW80Sdi0R6
yNTs8j2c5ox+boNF9S/00OS3VhA+3wVv8/cdjwo0gEujbatQ54K1N2avGpEa
wJ1uxo+STkWvq4ovm0wpDBV36Ut2srFEeu67In8Kp9/pa+6c4Yr++51jfbZT
qCyyGEntdMVs9nvLtiIKf3wqgZpQN7y/5cq2GfcoZMK51NNVbugaURux/DOF
qpbLopmWHKQ08rpJHjQ8fvzBsb54Dtosi239uJqGlcEU3/MuB+M/aUTavTS8
5+hxkDGTi4WLYpJTKmgY9O+WtZvTuaitkC9e30bD8ubqdWoVFzPjw3ZLh2jo
8LLf1AXd8cAlza6kqXTs7sAFd4vdMXJXy5yH5C8b+w5ascbdceUJky7xNjqy
3X3anYljD7TkHSJOFr7I5hEzStOWZRMHtM9iAvGV4mFpIfHN+kcWO4h3RDX8
WUXctN950gNiWojMUUncPOUSQ6In94uVq53j6MgNDVf8RezHYxm7EadKaOLT
xD2qxIZpxEFjAqOrxEOM+a6ziW//p6P1Ei+dVTiAxIoLQYbFBncU9z/JiCGe
1vO+MZSYPo+1MI5YzM5P3kBcKF8xKCJekvt2PIF4clqtYM9En5T19Szx+cFI
t6yJvmaeXErsxzn4+OhE36f6Q0Y8mns+I3+iF/qMKYkdvHoHSojL819c6yRO
FlBnyogZ7Wl73xFzZfaCSuJfTL0XDhF/I5xlIiW+E/h01EDs4x8gqyX+H7cr
MTY=
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
    LineBox[CompressedData["
1:eJwVy3881HcAx/Fzfoy543QcIdfd+REi53So+L5R2+yhtNRIiiuKeqSxox61
R4qTy/xsXZMaKq1WyI8epbR43JDSpmitELoH2tG145GUC/v0x/vxfjz/ePG2
79uQQKfRaOvIPv2zibVCGk1L2akOvK3bQ0e72bX8daZayiD5M/GNA3Q0uLPG
znK0lOaDYv/tbDoKErrP+3toqWaLhhllOR0hz7+1/D5aS+0I0tCe9NBR0xI7
PXJdS1VVSJjvVuojuzDl986kCSow9mvnFQwDeHsoQn/umaQk/XZRyipD8CQJ
dabDU1SOQ6RkRGSCpkKDBbKW91Shj0LnmcFAJdNIVFagowRrtj7T3DIHX1Z0
QXF6jur8a1t17C8W+HVGeuyrRhrexbNu9lFsZC8bVfkE08HiFrAlhlZg5Mm5
k636SHm63uKckgN1womoOg9DtE6fjHwrsQHrTpz/4HUjGAZc1K53tEV+4SmO
Od8Yfq/F3S0ddqjPne0xl5ugvoS5aTx+EXh0V/8MhinskmrduI5cjL5rKtWm
M9D0zW7Hhu2LMbWLXflononBI6qYvtU8VNHO5h89ao5LnrMjQ3w+Ykzb/Uul
LCQWR7G1E3zIN1bQrvpagGdkO5bVLUBsTE3bHY0FupfZJ/AqHbHlfNmAYcMC
HNojOx6S4wT3Hy7tuillo8OpcC54pzMuWg6/SXK1BEPRax0mdsGacfqDCI0l
Qjl5vc+tl6DoyKYLgZVWyAg7HJQytgQ1v7W8Lo7kIFKP/WGk0RWTLLNce1tr
uHQwowdL3PBSXOh0ucsaEyGhsaokd0yVTlruOWmDusdjzN1hS/HiRLL01KaF
4Ax4MrvcPLAv1KFbaWKL1PKG2oAZD7gE1mY5/2mL9tSyWa8+T+ROpIl+zLID
W3f/jUf1MrT4bYyIEttDTy/MRhbgBfu7lvdi3tsjnTmaL6r2goBu4r+9ehF2
Siv+3mUlRLhscK4sxQEbhpmp244J4dymVvYv4aKp5szQ8/+EeHSaMZ3Zz0Va
48HpkEhvrH8qp2rDF8O9k7Hju3veMKMuZpZfWYxtfs0VPC8RBtrr97kxecir
cRQpzolQUvLwpHovD4z4vr3TLB9cDqX5u3bwYCKtPzhwwAcPFjrlGLjxoZe/
qj9H7YPg+zs2xmXzkU57ZX5jw3JUKms2awf4WNWgGu++tRw2fWPG9hBgLrnY
vt5VDFU3fDtKBQjIjuNyTohxV51jzpoVYH+lKn2Vvi8cBMIuO+KOYMVsKPHh
mN4CF+KFL7+URRIHdi01o4ibFlUXpxI3X3/MSCaeP7W/6jJxS4bd5w+J5ccZ
KksDXyitrhnI5wQ4nSxeqyHmh0e1/kQ8xlD3zBBnyvVk5cQrr56JNjb0RbAu
Qv8m8YtXtEQB8R9D7/VGifmSzszNxK1Xg+dD5gW4EhHX2EbsODJ+N5xYN7GA
6iGWOSgObyEOK2prGyJeXfxqNpX4zUO3Ht2nPj3v4zli7y+mNEIj0tcuv1NN
nDV8SUoRy9QDh24RP8mM1oURr44R6h4RpzU3GycSVyp6b/cTt29NLUwjNujK
OvgvsfVHR04Wcbyxx4q3xIml/5wtIm4Levphnvi2X66gjPh/PE8aVA==
     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], Thickness[0.015], 
    LineBox[CompressedData["
1:eJwVy3tUzHkYx/Ff00xmzKXfTOlumplkJLHDRuOk71OuWVvLYMOQsrFJzWqT
ZZFqykj31RWh0iYmpU4akqSLbVUjjoPNtDqKVHZmlHKr/fbHc57zOp/zFgYr
NoRQCILwwzf1nxq+lxCEHrWn0FvGS3K9WjjXUvyYehQRJDsjzIpGVa7k27NW
esRND/huIjkRpYZ0FUrd9Og38c5e66PZaPmzzZa/btWjBfXvOlq3l6DyhsCx
vmo9EpTO2Z0mqEEJaftv/x1qQIw+V8miK81ooVuWb84jI9pMq/2lqOsxEgaF
VDJfjaKFtppMGvkK3Uqj8pQN40h1k8ovGhpExWyzRQWpn9GKzi26uyEGJFKm
F2XlTSBmT1hv050RVPIpKnFNLQF8UfDM1uwxlLCgv/dbHwoEzijSET9/Qqxk
laOxyRQS/DIbl7z/ggZCMgMq3WhgXwYnV4knEVm3U9pTbQZa24sWExUEpKRl
W5mL6FB4zkacVmYC15O+PjJXMeBwbI54bQYFhBQXaQyLCdSy7dy7R02h/8Ot
fH00C3rtas5o/KgwuseiWDvJBt25KInWmQZXibMpsbHmYHQjDya8o4Gc2SLN
jyLBu/2Fp+dFM1BtvEBcWcIFqdVS1+Kt0yBQXt5cN8wF5220SAVBh22FBTpa
FQ9CGRuqHl6lg+uRP/fciLKAzMeaOF9/BlyyfPUu1MUSmspPh3i/ZMDKQUqb
bNgS5HqXxmeHpkP68U1FXsUzwJ3jb7HDlAnllxuGMn60grp9+8KfJjDBSHKS
HOys4VCkbddTDgteLk5zLu20hgkfUWtFEgtG842WYadtYG7HumEtiw0vMiOi
sjfZQr9+xfUyFRsUvvyuRoYdnHr4JvL1OBvEXhXxs9vtgOuu6F6m4ECS4cCi
U/H24CEYzqt+zoEGj42ygMUOcE96NDfY2xwc6i1b5eMOUHl7/roxtTk4URjS
YPVMcL3R9GkHnQR/Zc9EwX4+FKgvfZPnScLs5oHG7jmO4BljHyrZR4I2jzUW
1+0IqfxBdkceCT88UaEKfwG07arZO6eNBA66FHe+TACOgZWBqz+QoGu5rpjL
FgJhqKua7syF3NwHpwfChWCxKrT1v/VcKPUlpC73hRD+3qAwHuZCm63zCepc
EeQs230stoQLPn/t2rgzQQTGkrrlWzu4UNxYvkWvE0FS+KaD6hEu2Pzzlu4A
TnD8muFA9Ewe9HbBkvv5ThB0oGVhuw8P6gdOmJNfnWDtGbMe5V4e8J0knfbY
ocdbMk9iH5M/TxVjUwvjV6Vie3XO4yDsmvxRdQ72neqHrAjsiODaI2XYDTH2
0x9gm/hpbLXYjTOuUVUTeL9aut4+jAci/4CmP7A9xCRNgB2nMlGex+7TRdXO
wvb5LDO9gT1CXew4H/vev+Mm/dgr5+UMAXbTFZ/J5ZNOoHz7OHE39qy+wXp/
bIo7uTQMW8nPOrYNO6duzbACe0XG66+R2Lz4StmhqT46+ctF7MvDQYLkqb7C
vU6N7SE88Sh9qh/Q/a7B/phxOTFrqpdLPmuxbVz7hwqwi7Oe3+zGjpERF4qw
qZ3xh99gizTWslLsn+huS0ewp8nnmamxm72ffJzElnh6aSqx/wfadB2L
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{1, 0.},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  Frame->True,
  FrameTicks->FrontEndValueCache[{{{{0., 
        FormBox["1", TraditionalForm]}, {4.605170185988092, 
        FormBox["100", TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["4", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["6", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["8", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {23.025850929940457`, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["10", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {2.4849066497880004`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.1354942159291497`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.5263605246161616`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.8066624897703196`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.02535169073515, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.204692619390966, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.356708826689592, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.48863636973214, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.090076835776092, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.7406644019172415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.131530710604252, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.411832675758411, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.630521876723241, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.809862805379057, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.961879012677683, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {9.093806555720231, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {11.695247021764184`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.345834587905333`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.736700896592344`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.017002861746503`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.235692062711331`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.415032991367148`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.567049198665774`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.698976741708323`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.300417207752275`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.951004773893423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.341871082580436`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.622173047734595`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.840862248699423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.02020317735524, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.172219384653864`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.304146927696415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {20.905587393740365`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.556174959881517`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.947041268568526`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.227343233722685`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.446032434687513`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.625373363343332`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.777389570641958`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.909317113684505`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}}, {{0., 
        FormBox["\" \"", TraditionalForm]}, {4.605170185988092, 
        FormBox["\" \"", TraditionalForm]}, {9.210340371976184, 
        FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
        FormBox["\" \"", TraditionalForm]}, {18.420680743952367`, 
        FormBox["\" \"", TraditionalForm]}, {23.025850929940457`, 
        FormBox["\" \"", TraditionalForm]}, {2.4849066497880004`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.1354942159291497`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.5263605246161616`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.8066624897703196`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.02535169073515, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.204692619390966, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.356708826689592, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.48863636973214, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.090076835776092, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.7406644019172415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.131530710604252, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.411832675758411, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.630521876723241, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.809862805379057, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.961879012677683, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {9.093806555720231, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {11.695247021764184`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.345834587905333`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.736700896592344`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.017002861746503`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.235692062711331`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.415032991367148`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.567049198665774`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.698976741708323`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.300417207752275`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.951004773893423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.341871082580436`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.622173047734595`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.840862248699423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.02020317735524, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.172219384653864`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.304146927696415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {20.905587393740365`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.556174959881517`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.947041268568526`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.227343233722685`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.446032434687513`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.625373363343332`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.777389570641958`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.909317113684505`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}}}, {Automatic, Automatic}}, {{{{0., 
        FormBox["1", TraditionalForm]}, {4.605170185988092, 
        FormBox["100", TraditionalForm]}, {9.210340371976184, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["4", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["6", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["8", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {23.025850929940457`, 
        FormBox[
         TagBox[
          SuperscriptBox[
           TagBox["10", Power, Editable -> True, Selectable -> True], 
           TagBox["10", Power, Editable -> True, Selectable -> True]], 
          InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
          Selectable -> False], TraditionalForm]}, {2.4849066497880004`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.1354942159291497`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.5263605246161616`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.8066624897703196`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.02535169073515, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.204692619390966, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.356708826689592, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.48863636973214, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.090076835776092, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.7406644019172415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.131530710604252, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.411832675758411, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.630521876723241, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.809862805379057, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.961879012677683, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {9.093806555720231, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {11.695247021764184`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.345834587905333`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.736700896592344`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.017002861746503`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.235692062711331`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.415032991367148`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.567049198665774`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.698976741708323`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.300417207752275`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.951004773893423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.341871082580436`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.622173047734595`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.840862248699423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.02020317735524, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.172219384653864`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.304146927696415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {20.905587393740365`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.556174959881517`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.947041268568526`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.227343233722685`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.446032434687513`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.625373363343332`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.777389570641958`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.909317113684505`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}}, {{0., 
        FormBox["\" \"", TraditionalForm]}, {4.605170185988092, 
        FormBox["\" \"", TraditionalForm]}, {9.210340371976184, 
        FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
        FormBox["\" \"", TraditionalForm]}, {18.420680743952367`, 
        FormBox["\" \"", TraditionalForm]}, {23.025850929940457`, 
        FormBox["\" \"", TraditionalForm]}, {2.4849066497880004`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.1354942159291497`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.5263605246161616`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {3.8066624897703196`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.02535169073515, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.204692619390966, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.356708826689592, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {4.48863636973214, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.090076835776092, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {7.7406644019172415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.131530710604252, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.411832675758411, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.630521876723241, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.809862805379057, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {8.961879012677683, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {9.093806555720231, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {11.695247021764184`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.345834587905333`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {12.736700896592344`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.017002861746503`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.235692062711331`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.415032991367148`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.567049198665774`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {13.698976741708323`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.300417207752275`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {16.951004773893423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.341871082580436`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.622173047734595`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {17.840862248699423`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.02020317735524, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.172219384653864`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {18.304146927696415`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {20.905587393740365`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.556174959881517`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {21.947041268568526`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.227343233722685`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.446032434687513`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.625373363343332`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.777389570641958`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}, {22.909317113684505`, 
        FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
         Thickness[0.001]}}}}, {Automatic, Automatic}}],
  GridLines->{None, None},
  ImageSize->Automatic,
  Method->{},
  PlotRange->{{1, 10}, {0., 23.025850507016663`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{0, 
      FormBox["1", TraditionalForm]}, {4.605170185988092, 
      FormBox["100", TraditionalForm]}, {9.210340371976184, 
      FormBox[
       TagBox[
        SuperscriptBox[
         TagBox["10", Power, Editable -> True, Selectable -> True], 
         TagBox["4", Power, Editable -> True, Selectable -> True]], 
        InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
        Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
      FormBox[
       TagBox[
        SuperscriptBox[
         TagBox["10", Power, Editable -> True, Selectable -> True], 
         TagBox["6", Power, Editable -> True, Selectable -> True]], 
        InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
        Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
      FormBox[
       TagBox[
        SuperscriptBox[
         TagBox["10", Power, Editable -> True, Selectable -> True], 
         TagBox["8", Power, Editable -> True, Selectable -> True]], 
        InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
        Selectable -> False], TraditionalForm]}, {23.025850929940457`, 
      FormBox[
       TagBox[
        SuperscriptBox[
         TagBox["10", Power, Editable -> True, Selectable -> True], 
         TagBox["10", Power, Editable -> True, Selectable -> True]], 
        InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
        Selectable -> False], TraditionalForm]}, {2.4849066497880004`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.1354942159291497`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.5263605246161616`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.8066624897703196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.02535169073515, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.204692619390966, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.356708826689592, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {4.48863636973214, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.090076835776092, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {7.7406644019172415`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.131530710604252, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.411832675758411, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.630521876723241, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.809862805379057, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {8.961879012677683, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {9.093806555720231, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {11.695247021764184`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {12.345834587905333`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {12.736700896592344`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.017002861746503`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.235692062711331`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.415032991367148`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.567049198665774`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {13.698976741708323`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {16.300417207752275`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {16.951004773893423`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {17.341871082580436`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {17.622173047734595`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {17.840862248699423`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {18.02020317735524, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {18.172219384653864`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {18.304146927696415`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {20.905587393740365`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {21.556174959881517`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {21.947041268568526`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {22.227343233722685`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {22.446032434687513`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {22.625373363343332`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {22.777389570641958`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {22.909317113684505`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{{3.4268830154695215`*^9, 3.426883027316557*^9}, 
   3.4268830772783985`*^9, 3.4268831124589853`*^9, 3.4268832277247295`*^9}]
}, Open  ]]
},
WindowSize->{832, 740},
WindowMargins->{{70, Automatic}, {Automatic, 45}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 840, 23, 357, "Input"],
Cell[CellGroupData[{
Cell[1433, 48, 5263, 127, 827, "Input"],
Cell[6699, 177, 284, 3, 50, "Print"],
Cell[6986, 182, 17708, 308, 226, "Output"],
Cell[24697, 492, 273, 3, 50, "Print"],
Cell[24973, 497, 33200, 609, 309, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
