(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53736,       1066]
NotebookOptionsPosition[     53287,       1048]
NotebookOutlinePosition[     53707,       1064]
CellTagsIndexPosition[     53664,       1061]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook illustrates the Malthus initial value, first-order ordinary \
differential equation (ODE) and vectorfields.
Figure 9.1 was created with this notebook.

p(t) is population at a given time
p'(t) = c * p(t) describes population growth.
c is constant the depends on the particular population.
If we know the population at some time t_0, an initial value of p_0, then \
what is the population at some time t? 

Below we have plotted the slope p'(t) for pairs (t,p). The circles represent \
initial values. These initial values determine functions that follow the \
vectorfield.


See Chapter 9 : Computing Dynamic Processes for details.

Updated July 2008
\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.426019077154417*^9, 3.4260191176826935`*^9}, {
  3.4260199234813757`*^9, 3.426019944000881*^9}, {3.42602006760862*^9, 
  3.42602007111366*^9}, {3.4260201279553947`*^9, 3.4260202950857162`*^9}, {
  3.4260203420632668`*^9, 3.4260203684011383`*^9}, {3.426020536002137*^9, 
  3.426020650146268*^9}, {3.4260972869627037`*^9, 3.426097288134389*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Load", " ", "the", " ", "vectorfield", " ", "package"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "the", " ", "output", " ", "directory"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "vectorfield"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vecfield", "=", 
     RowBox[{"VectorFieldPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "y"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "20"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "is", " ", "the", " ", "solution", " ", "to", " ", "the", 
     " ", "given", " ", "ODE", " ", "with", " ", "initial", " ", "value", " ",
      
     RowBox[{"(", 
      RowBox[{"0", ",", "1"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fct1", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "0.8`"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.013`", "]"}], ",", " ", "Red"}], 
         "}"}]}]}], "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "is", " ", "the", " ", "solution", " ", "to", " ", "the", 
     " ", "given", " ", "ODE", " ", "with", " ", "initial", " ", "value", " ",
      
     RowBox[{"(", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "e"}]}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"fct2", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"x", "-", "1"}]], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "1.8`"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.013`", "]"}], ",", " ", "Blue"}], 
         "}"}]}]}], "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Initial", " ", "value", " ", 
     RowBox[{"(", 
      RowBox[{"0", ",", "1"}], ")"}], " ", "is", " ", "on", " ", "the", " ", 
     "red", " ", "curve"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"start", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1.0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["1", "\[ExponentialE]"]}], "}"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "0.03`", "]"}], ",", " ", "Black"}], 
          "}"}], "}"}]}]}], "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"vecfield", ",", "fct1", ",", "fct2", ",", "start"}], "}"}], 
     "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<vecfield3.eps\>\"", ",", "pic"}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.4260191320433435`*^9, 3.426019202294359*^9}, {
   3.426019245776884*^9, 3.4260192486610317`*^9}, 3.426019320904913*^9, {
   3.426019393258953*^9, 3.426019418795673*^9}, {3.426019458422654*^9, 
   3.4260194905889063`*^9}, {3.4260195901721*^9, 3.4260196054841175`*^9}, {
   3.426019669005457*^9, 3.4260197196182346`*^9}, {3.426019813763609*^9, 
   3.4260198159267197`*^9}, {3.426019853991454*^9, 3.4260198549027643`*^9}, {
   3.42602069009371*^9, 3.4260207140781975`*^9}, {3.4260207969073*^9, 
   3.4260208316672826`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[Small], Arrowheads[0.02], 
    ArrowBox[{{-2., -2.}, {-1.90584976936843, -2.18830046126314}}], 
    ArrowBox[{{-2., -1.7894736842105263`}, {-1.90584976936843, \
-1.9579530442880728`}}], 
    ArrowBox[{{-2., -1.5789473684210527`}, {-1.90584976936843, \
-1.7276056273130054`}}], 
    ArrowBox[{{-2., -1.368421052631579}, {-1.90584976936843, \
-1.4972582103379382`}}], 
    ArrowBox[{{-2., -1.1578947368421053`}, {-1.90584976936843, \
-1.2669107933628707`}}], 
    ArrowBox[{{-2., -0.9473684210526315}, {-1.90584976936843, \
-1.0365633763878033`}}], 
    ArrowBox[{{-2., -0.7368421052631579}, {-1.90584976936843, \
-0.8062159594127358}}], 
    ArrowBox[{{-2., -0.5263157894736842}, {-1.90584976936843, \
-0.5758685424376684}}], 
    ArrowBox[{{-2., -0.3157894736842105}, {-1.90584976936843, \
-0.34552112546260105`}}], 
    ArrowBox[{{-2., -0.10526315789473684`}, {-1.90584976936843, \
-0.1151737084875337}}], 
    ArrowBox[{{-2., 0.10526315789473684`}, {-1.90584976936843, 
     0.1151737084875337}}], 
    ArrowBox[{{-2., 0.3157894736842105}, {-1.90584976936843, 
     0.34552112546260105`}}], 
    ArrowBox[{{-2., 0.5263157894736842}, {-1.90584976936843, 
     0.5758685424376684}}], 
    ArrowBox[{{-2., 0.7368421052631579}, {-1.90584976936843, 
     0.8062159594127358}}], 
    ArrowBox[{{-2., 0.9473684210526315}, {-1.90584976936843, 
     1.0365633763878033`}}], 
    ArrowBox[{{-2., 1.1578947368421053`}, {-1.90584976936843, 
     1.2669107933628707`}}], 
    ArrowBox[{{-2., 1.368421052631579}, {-1.90584976936843, 
     1.4972582103379382`}}], 
    ArrowBox[{{-2., 1.5789473684210527`}, {-1.90584976936843, 
     1.7276056273130054`}}], 
    ArrowBox[{{-2., 1.7894736842105263`}, {-1.90584976936843, 
     1.9579530442880728`}}], 
    ArrowBox[{{-2., 2.}, {-1.90584976936843, 2.18830046126314}}], 
    ArrowBox[{{-1.7894736842105263`, -2.}, {-1.6953234535789563`, \
-2.18830046126314}}], 
    ArrowBox[{{-1.7894736842105263`, -1.7894736842105263`}, \
{-1.6953234535789563`, -1.9579530442880728`}}], 
    ArrowBox[{{-1.7894736842105263`, -1.5789473684210527`}, \
{-1.6953234535789563`, -1.7276056273130054`}}], 
    ArrowBox[{{-1.7894736842105263`, -1.368421052631579}, \
{-1.6953234535789563`, -1.4972582103379382`}}], 
    ArrowBox[{{-1.7894736842105263`, -1.1578947368421053`}, \
{-1.6953234535789563`, -1.2669107933628707`}}], 
    ArrowBox[{{-1.7894736842105263`, -0.9473684210526315}, \
{-1.6953234535789563`, -1.0365633763878033`}}], 
    ArrowBox[{{-1.7894736842105263`, -0.7368421052631579}, \
{-1.6953234535789563`, -0.8062159594127358}}], 
    ArrowBox[{{-1.7894736842105263`, -0.5263157894736842}, \
{-1.6953234535789563`, -0.5758685424376684}}], 
    ArrowBox[{{-1.7894736842105263`, -0.3157894736842105}, \
{-1.6953234535789563`, -0.34552112546260105`}}], 
    ArrowBox[{{-1.7894736842105263`, -0.10526315789473684`}, \
{-1.6953234535789563`, -0.1151737084875337}}], 
    ArrowBox[{{-1.7894736842105263`, 
     0.10526315789473684`}, {-1.6953234535789563`, 0.1151737084875337}}], 
    ArrowBox[{{-1.7894736842105263`, 
     0.3157894736842105}, {-1.6953234535789563`, 0.34552112546260105`}}], 
    ArrowBox[{{-1.7894736842105263`, 
     0.5263157894736842}, {-1.6953234535789563`, 0.5758685424376684}}], 
    ArrowBox[{{-1.7894736842105263`, 
     0.7368421052631579}, {-1.6953234535789563`, 0.8062159594127358}}], 
    ArrowBox[{{-1.7894736842105263`, 
     0.9473684210526315}, {-1.6953234535789563`, 1.0365633763878033`}}], 
    ArrowBox[{{-1.7894736842105263`, 
     1.1578947368421053`}, {-1.6953234535789563`, 1.2669107933628707`}}], 
    ArrowBox[{{-1.7894736842105263`, 
     1.368421052631579}, {-1.6953234535789563`, 1.4972582103379382`}}], 
    ArrowBox[{{-1.7894736842105263`, 
     1.5789473684210527`}, {-1.6953234535789563`, 1.7276056273130054`}}], 
    ArrowBox[{{-1.7894736842105263`, 
     1.7894736842105263`}, {-1.6953234535789563`, 1.9579530442880728`}}], 
    ArrowBox[{{-1.7894736842105263`, 2.}, {-1.6953234535789563`, 
     2.18830046126314}}], 
    ArrowBox[{{-1.5789473684210527`, -2.}, {-1.4847971377894826`, \
-2.18830046126314}}], 
    ArrowBox[{{-1.5789473684210527`, -1.7894736842105263`}, \
{-1.4847971377894826`, -1.9579530442880728`}}], 
    ArrowBox[{{-1.5789473684210527`, -1.5789473684210527`}, \
{-1.4847971377894826`, -1.7276056273130054`}}], 
    ArrowBox[{{-1.5789473684210527`, -1.368421052631579}, \
{-1.4847971377894826`, -1.4972582103379382`}}], 
    ArrowBox[{{-1.5789473684210527`, -1.1578947368421053`}, \
{-1.4847971377894826`, -1.2669107933628707`}}], 
    ArrowBox[{{-1.5789473684210527`, -0.9473684210526315}, \
{-1.4847971377894826`, -1.0365633763878033`}}], 
    ArrowBox[{{-1.5789473684210527`, -0.7368421052631579}, \
{-1.4847971377894826`, -0.8062159594127358}}], 
    ArrowBox[{{-1.5789473684210527`, -0.5263157894736842}, \
{-1.4847971377894826`, -0.5758685424376684}}], 
    ArrowBox[{{-1.5789473684210527`, -0.3157894736842105}, \
{-1.4847971377894826`, -0.34552112546260105`}}], 
    ArrowBox[{{-1.5789473684210527`, -0.10526315789473684`}, \
{-1.4847971377894826`, -0.1151737084875337}}], 
    ArrowBox[{{-1.5789473684210527`, 
     0.10526315789473684`}, {-1.4847971377894826`, 0.1151737084875337}}], 
    ArrowBox[{{-1.5789473684210527`, 
     0.3157894736842105}, {-1.4847971377894826`, 0.34552112546260105`}}], 
    ArrowBox[{{-1.5789473684210527`, 
     0.5263157894736842}, {-1.4847971377894826`, 0.5758685424376684}}], 
    ArrowBox[{{-1.5789473684210527`, 
     0.7368421052631579}, {-1.4847971377894826`, 0.8062159594127358}}], 
    ArrowBox[{{-1.5789473684210527`, 
     0.9473684210526315}, {-1.4847971377894826`, 1.0365633763878033`}}], 
    ArrowBox[{{-1.5789473684210527`, 
     1.1578947368421053`}, {-1.4847971377894826`, 1.2669107933628707`}}], 
    ArrowBox[{{-1.5789473684210527`, 
     1.368421052631579}, {-1.4847971377894826`, 1.4972582103379382`}}], 
    ArrowBox[{{-1.5789473684210527`, 
     1.5789473684210527`}, {-1.4847971377894826`, 1.7276056273130054`}}], 
    ArrowBox[{{-1.5789473684210527`, 
     1.7894736842105263`}, {-1.4847971377894826`, 1.9579530442880728`}}], 
    ArrowBox[{{-1.5789473684210527`, 2.}, {-1.4847971377894826`, 
     2.18830046126314}}], 
    ArrowBox[{{-1.368421052631579, -2.}, {-1.274270822000009, \
-2.18830046126314}}], 
    ArrowBox[{{-1.368421052631579, -1.7894736842105263`}, \
{-1.274270822000009, -1.9579530442880728`}}], 
    ArrowBox[{{-1.368421052631579, -1.5789473684210527`}, \
{-1.274270822000009, -1.7276056273130054`}}], 
    ArrowBox[{{-1.368421052631579, -1.368421052631579}, {-1.274270822000009, \
-1.4972582103379382`}}], 
    ArrowBox[{{-1.368421052631579, -1.1578947368421053`}, \
{-1.274270822000009, -1.2669107933628707`}}], 
    ArrowBox[{{-1.368421052631579, -0.9473684210526315}, {-1.274270822000009, \
-1.0365633763878033`}}], 
    ArrowBox[{{-1.368421052631579, -0.7368421052631579}, {-1.274270822000009, \
-0.8062159594127358}}], 
    ArrowBox[{{-1.368421052631579, -0.5263157894736842}, {-1.274270822000009, \
-0.5758685424376684}}], 
    ArrowBox[{{-1.368421052631579, -0.3157894736842105}, {-1.274270822000009, \
-0.34552112546260105`}}], 
    ArrowBox[{{-1.368421052631579, -0.10526315789473684`}, \
{-1.274270822000009, -0.1151737084875337}}], 
    ArrowBox[{{-1.368421052631579, 0.10526315789473684`}, {-1.274270822000009,
      0.1151737084875337}}], 
    ArrowBox[{{-1.368421052631579, 0.3157894736842105}, {-1.274270822000009, 
     0.34552112546260105`}}], 
    ArrowBox[{{-1.368421052631579, 0.5263157894736842}, {-1.274270822000009, 
     0.5758685424376684}}], 
    ArrowBox[{{-1.368421052631579, 0.7368421052631579}, {-1.274270822000009, 
     0.8062159594127358}}], 
    ArrowBox[{{-1.368421052631579, 0.9473684210526315}, {-1.274270822000009, 
     1.0365633763878033`}}], 
    ArrowBox[{{-1.368421052631579, 1.1578947368421053`}, {-1.274270822000009, 
     1.2669107933628707`}}], 
    ArrowBox[{{-1.368421052631579, 1.368421052631579}, {-1.274270822000009, 
     1.4972582103379382`}}], 
    ArrowBox[{{-1.368421052631579, 1.5789473684210527`}, {-1.274270822000009, 
     1.7276056273130054`}}], 
    ArrowBox[{{-1.368421052631579, 1.7894736842105263`}, {-1.274270822000009, 
     1.9579530442880728`}}], 
    ArrowBox[{{-1.368421052631579, 2.}, {-1.274270822000009, 
     2.18830046126314}}], 
    ArrowBox[{{-1.1578947368421053`, -2.}, {-1.0637445062105353`, \
-2.18830046126314}}], 
    ArrowBox[{{-1.1578947368421053`, -1.7894736842105263`}, \
{-1.0637445062105353`, -1.9579530442880728`}}], 
    ArrowBox[{{-1.1578947368421053`, -1.5789473684210527`}, \
{-1.0637445062105353`, -1.7276056273130054`}}], 
    ArrowBox[{{-1.1578947368421053`, -1.368421052631579}, \
{-1.0637445062105353`, -1.4972582103379382`}}], 
    ArrowBox[{{-1.1578947368421053`, -1.1578947368421053`}, \
{-1.0637445062105353`, -1.2669107933628707`}}], 
    ArrowBox[{{-1.1578947368421053`, -0.9473684210526315}, \
{-1.0637445062105353`, -1.0365633763878033`}}], 
    ArrowBox[{{-1.1578947368421053`, -0.7368421052631579}, \
{-1.0637445062105353`, -0.8062159594127358}}], 
    ArrowBox[{{-1.1578947368421053`, -0.5263157894736842}, \
{-1.0637445062105353`, -0.5758685424376684}}], 
    ArrowBox[{{-1.1578947368421053`, -0.3157894736842105}, \
{-1.0637445062105353`, -0.34552112546260105`}}], 
    ArrowBox[{{-1.1578947368421053`, -0.10526315789473684`}, \
{-1.0637445062105353`, -0.1151737084875337}}], 
    ArrowBox[{{-1.1578947368421053`, 
     0.10526315789473684`}, {-1.0637445062105353`, 0.1151737084875337}}], 
    ArrowBox[{{-1.1578947368421053`, 
     0.3157894736842105}, {-1.0637445062105353`, 0.34552112546260105`}}], 
    ArrowBox[{{-1.1578947368421053`, 
     0.5263157894736842}, {-1.0637445062105353`, 0.5758685424376684}}], 
    ArrowBox[{{-1.1578947368421053`, 
     0.7368421052631579}, {-1.0637445062105353`, 0.8062159594127358}}], 
    ArrowBox[{{-1.1578947368421053`, 
     0.9473684210526315}, {-1.0637445062105353`, 1.0365633763878033`}}], 
    ArrowBox[{{-1.1578947368421053`, 
     1.1578947368421053`}, {-1.0637445062105353`, 1.2669107933628707`}}], 
    ArrowBox[{{-1.1578947368421053`, 
     1.368421052631579}, {-1.0637445062105353`, 1.4972582103379382`}}], 
    ArrowBox[{{-1.1578947368421053`, 
     1.5789473684210527`}, {-1.0637445062105353`, 1.7276056273130054`}}], 
    ArrowBox[{{-1.1578947368421053`, 
     1.7894736842105263`}, {-1.0637445062105353`, 1.9579530442880728`}}], 
    ArrowBox[{{-1.1578947368421053`, 2.}, {-1.0637445062105353`, 
     2.18830046126314}}], 
    ArrowBox[{{-0.9473684210526315, -2.}, {-0.8532181904210614, \
-2.18830046126314}}], 
    ArrowBox[{{-0.9473684210526315, -1.7894736842105263`}, \
{-0.8532181904210614, -1.9579530442880728`}}], 
    ArrowBox[{{-0.9473684210526315, -1.5789473684210527`}, \
{-0.8532181904210614, -1.7276056273130054`}}], 
    ArrowBox[{{-0.9473684210526315, -1.368421052631579}, \
{-0.8532181904210614, -1.4972582103379382`}}], 
    ArrowBox[{{-0.9473684210526315, -1.1578947368421053`}, \
{-0.8532181904210614, -1.2669107933628707`}}], 
    ArrowBox[{{-0.9473684210526315, -0.9473684210526315}, \
{-0.8532181904210614, -1.0365633763878033`}}], 
    ArrowBox[{{-0.9473684210526315, -0.7368421052631579}, \
{-0.8532181904210614, -0.8062159594127358}}], 
    ArrowBox[{{-0.9473684210526315, -0.5263157894736842}, \
{-0.8532181904210614, -0.5758685424376684}}], 
    ArrowBox[{{-0.9473684210526315, -0.3157894736842105}, \
{-0.8532181904210614, -0.34552112546260105`}}], 
    ArrowBox[{{-0.9473684210526315, -0.10526315789473684`}, \
{-0.8532181904210614, -0.1151737084875337}}], 
    ArrowBox[{{-0.9473684210526315, 
     0.10526315789473684`}, {-0.8532181904210614, 0.1151737084875337}}], 
    ArrowBox[{{-0.9473684210526315, 0.3157894736842105}, {-0.8532181904210614,
      0.34552112546260105`}}], 
    ArrowBox[{{-0.9473684210526315, 0.5263157894736842}, {-0.8532181904210614,
      0.5758685424376684}}], 
    ArrowBox[{{-0.9473684210526315, 0.7368421052631579}, {-0.8532181904210614,
      0.8062159594127358}}], 
    ArrowBox[{{-0.9473684210526315, 0.9473684210526315}, {-0.8532181904210614,
      1.0365633763878033`}}], 
    ArrowBox[{{-0.9473684210526315, 
     1.1578947368421053`}, {-0.8532181904210614, 1.2669107933628707`}}], 
    ArrowBox[{{-0.9473684210526315, 1.368421052631579}, {-0.8532181904210614, 
     1.4972582103379382`}}], 
    ArrowBox[{{-0.9473684210526315, 
     1.5789473684210527`}, {-0.8532181904210614, 1.7276056273130054`}}], 
    ArrowBox[{{-0.9473684210526315, 
     1.7894736842105263`}, {-0.8532181904210614, 1.9579530442880728`}}], 
    ArrowBox[{{-0.9473684210526315, 2.}, {-0.8532181904210614, 
     2.18830046126314}}], 
    ArrowBox[{{-0.7368421052631579, -2.}, {-0.6426918746315877, \
-2.18830046126314}}], 
    ArrowBox[{{-0.7368421052631579, -1.7894736842105263`}, \
{-0.6426918746315877, -1.9579530442880728`}}], 
    ArrowBox[{{-0.7368421052631579, -1.5789473684210527`}, \
{-0.6426918746315877, -1.7276056273130054`}}], 
    ArrowBox[{{-0.7368421052631579, -1.368421052631579}, \
{-0.6426918746315877, -1.4972582103379382`}}], 
    ArrowBox[{{-0.7368421052631579, -1.1578947368421053`}, \
{-0.6426918746315877, -1.2669107933628707`}}], 
    ArrowBox[{{-0.7368421052631579, -0.9473684210526315}, \
{-0.6426918746315877, -1.0365633763878033`}}], 
    ArrowBox[{{-0.7368421052631579, -0.7368421052631579}, \
{-0.6426918746315877, -0.8062159594127358}}], 
    ArrowBox[{{-0.7368421052631579, -0.5263157894736842}, \
{-0.6426918746315877, -0.5758685424376684}}], 
    ArrowBox[{{-0.7368421052631579, -0.3157894736842105}, \
{-0.6426918746315877, -0.34552112546260105`}}], 
    ArrowBox[{{-0.7368421052631579, -0.10526315789473684`}, \
{-0.6426918746315877, -0.1151737084875337}}], 
    ArrowBox[{{-0.7368421052631579, 
     0.10526315789473684`}, {-0.6426918746315877, 0.1151737084875337}}], 
    ArrowBox[{{-0.7368421052631579, 0.3157894736842105}, {-0.6426918746315877,
      0.34552112546260105`}}], 
    ArrowBox[{{-0.7368421052631579, 0.5263157894736842}, {-0.6426918746315877,
      0.5758685424376684}}], 
    ArrowBox[{{-0.7368421052631579, 0.7368421052631579}, {-0.6426918746315877,
      0.8062159594127358}}], 
    ArrowBox[{{-0.7368421052631579, 0.9473684210526315}, {-0.6426918746315877,
      1.0365633763878033`}}], 
    ArrowBox[{{-0.7368421052631579, 
     1.1578947368421053`}, {-0.6426918746315877, 1.2669107933628707`}}], 
    ArrowBox[{{-0.7368421052631579, 1.368421052631579}, {-0.6426918746315877, 
     1.4972582103379382`}}], 
    ArrowBox[{{-0.7368421052631579, 
     1.5789473684210527`}, {-0.6426918746315877, 1.7276056273130054`}}], 
    ArrowBox[{{-0.7368421052631579, 
     1.7894736842105263`}, {-0.6426918746315877, 1.9579530442880728`}}], 
    ArrowBox[{{-0.7368421052631579, 2.}, {-0.6426918746315877, 
     2.18830046126314}}], 
    ArrowBox[{{-0.5263157894736842, -2.}, {-0.4321655588421141, \
-2.18830046126314}}], 
    ArrowBox[{{-0.5263157894736842, -1.7894736842105263`}, \
{-0.4321655588421141, -1.9579530442880728`}}], 
    ArrowBox[{{-0.5263157894736842, -1.5789473684210527`}, \
{-0.4321655588421141, -1.7276056273130054`}}], 
    ArrowBox[{{-0.5263157894736842, -1.368421052631579}, \
{-0.4321655588421141, -1.4972582103379382`}}], 
    ArrowBox[{{-0.5263157894736842, -1.1578947368421053`}, \
{-0.4321655588421141, -1.2669107933628707`}}], 
    ArrowBox[{{-0.5263157894736842, -0.9473684210526315}, \
{-0.4321655588421141, -1.0365633763878033`}}], 
    ArrowBox[{{-0.5263157894736842, -0.7368421052631579}, \
{-0.4321655588421141, -0.8062159594127358}}], 
    ArrowBox[{{-0.5263157894736842, -0.5263157894736842}, \
{-0.4321655588421141, -0.5758685424376684}}], 
    ArrowBox[{{-0.5263157894736842, -0.3157894736842105}, \
{-0.4321655588421141, -0.34552112546260105`}}], 
    ArrowBox[{{-0.5263157894736842, -0.10526315789473684`}, \
{-0.4321655588421141, -0.1151737084875337}}], 
    ArrowBox[{{-0.5263157894736842, 
     0.10526315789473684`}, {-0.4321655588421141, 0.1151737084875337}}], 
    ArrowBox[{{-0.5263157894736842, 0.3157894736842105}, {-0.4321655588421141,
      0.34552112546260105`}}], 
    ArrowBox[{{-0.5263157894736842, 0.5263157894736842}, {-0.4321655588421141,
      0.5758685424376684}}], 
    ArrowBox[{{-0.5263157894736842, 0.7368421052631579}, {-0.4321655588421141,
      0.8062159594127358}}], 
    ArrowBox[{{-0.5263157894736842, 0.9473684210526315}, {-0.4321655588421141,
      1.0365633763878033`}}], 
    ArrowBox[{{-0.5263157894736842, 
     1.1578947368421053`}, {-0.4321655588421141, 1.2669107933628707`}}], 
    ArrowBox[{{-0.5263157894736842, 1.368421052631579}, {-0.4321655588421141, 
     1.4972582103379382`}}], 
    ArrowBox[{{-0.5263157894736842, 
     1.5789473684210527`}, {-0.4321655588421141, 1.7276056273130054`}}], 
    ArrowBox[{{-0.5263157894736842, 
     1.7894736842105263`}, {-0.4321655588421141, 1.9579530442880728`}}], 
    ArrowBox[{{-0.5263157894736842, 2.}, {-0.4321655588421141, 
     2.18830046126314}}], 
    ArrowBox[{{-0.3157894736842105, -2.}, {-0.22163924305264043`, \
-2.18830046126314}}], 
    ArrowBox[{{-0.3157894736842105, -1.7894736842105263`}, \
{-0.22163924305264043`, -1.9579530442880728`}}], 
    ArrowBox[{{-0.3157894736842105, -1.5789473684210527`}, \
{-0.22163924305264043`, -1.7276056273130054`}}], 
    ArrowBox[{{-0.3157894736842105, -1.368421052631579}, \
{-0.22163924305264043`, -1.4972582103379382`}}], 
    ArrowBox[{{-0.3157894736842105, -1.1578947368421053`}, \
{-0.22163924305264043`, -1.2669107933628707`}}], 
    ArrowBox[{{-0.3157894736842105, -0.9473684210526315}, \
{-0.22163924305264043`, -1.0365633763878033`}}], 
    ArrowBox[{{-0.3157894736842105, -0.7368421052631579}, \
{-0.22163924305264043`, -0.8062159594127358}}], 
    ArrowBox[{{-0.3157894736842105, -0.5263157894736842}, \
{-0.22163924305264043`, -0.5758685424376684}}], 
    ArrowBox[{{-0.3157894736842105, -0.3157894736842105}, \
{-0.22163924305264043`, -0.34552112546260105`}}], 
    ArrowBox[{{-0.3157894736842105, -0.10526315789473684`}, \
{-0.22163924305264043`, -0.1151737084875337}}], 
    ArrowBox[{{-0.3157894736842105, 
     0.10526315789473684`}, {-0.22163924305264043`, 0.1151737084875337}}], 
    ArrowBox[{{-0.3157894736842105, 
     0.3157894736842105}, {-0.22163924305264043`, 0.34552112546260105`}}], 
    ArrowBox[{{-0.3157894736842105, 
     0.5263157894736842}, {-0.22163924305264043`, 0.5758685424376684}}], 
    ArrowBox[{{-0.3157894736842105, 
     0.7368421052631579}, {-0.22163924305264043`, 0.8062159594127358}}], 
    ArrowBox[{{-0.3157894736842105, 
     0.9473684210526315}, {-0.22163924305264043`, 1.0365633763878033`}}], 
    ArrowBox[{{-0.3157894736842105, 
     1.1578947368421053`}, {-0.22163924305264043`, 1.2669107933628707`}}], 
    ArrowBox[{{-0.3157894736842105, 
     1.368421052631579}, {-0.22163924305264043`, 1.4972582103379382`}}], 
    ArrowBox[{{-0.3157894736842105, 
     1.5789473684210527`}, {-0.22163924305264043`, 1.7276056273130054`}}], 
    ArrowBox[{{-0.3157894736842105, 
     1.7894736842105263`}, {-0.22163924305264043`, 1.9579530442880728`}}], 
    ArrowBox[{{-0.3157894736842105, 2.}, {-0.22163924305264043`, 
     2.18830046126314}}], 
    ArrowBox[{{-0.10526315789473684`, -2.}, {-0.011112927263166747`, \
-2.18830046126314}}], 
    ArrowBox[{{-0.10526315789473684`, -1.7894736842105263`}, \
{-0.011112927263166747`, -1.9579530442880728`}}], 
    ArrowBox[{{-0.10526315789473684`, -1.5789473684210527`}, \
{-0.011112927263166747`, -1.7276056273130054`}}], 
    ArrowBox[{{-0.10526315789473684`, -1.368421052631579}, \
{-0.011112927263166747`, -1.4972582103379382`}}], 
    ArrowBox[{{-0.10526315789473684`, -1.1578947368421053`}, \
{-0.011112927263166747`, -1.2669107933628707`}}], 
    ArrowBox[{{-0.10526315789473684`, -0.9473684210526315}, \
{-0.011112927263166747`, -1.0365633763878033`}}], 
    ArrowBox[{{-0.10526315789473684`, -0.7368421052631579}, \
{-0.011112927263166747`, -0.8062159594127358}}], 
    ArrowBox[{{-0.10526315789473684`, -0.5263157894736842}, \
{-0.011112927263166747`, -0.5758685424376684}}], 
    ArrowBox[{{-0.10526315789473684`, -0.3157894736842105}, \
{-0.011112927263166747`, -0.34552112546260105`}}], 
    ArrowBox[{{-0.10526315789473684`, -0.10526315789473684`}, \
{-0.011112927263166747`, -0.1151737084875337}}], 
    ArrowBox[{{-0.10526315789473684`, 
     0.10526315789473684`}, {-0.011112927263166747`, 0.1151737084875337}}], 
    ArrowBox[{{-0.10526315789473684`, 
     0.3157894736842105}, {-0.011112927263166747`, 0.34552112546260105`}}], 
    ArrowBox[{{-0.10526315789473684`, 
     0.5263157894736842}, {-0.011112927263166747`, 0.5758685424376684}}], 
    ArrowBox[{{-0.10526315789473684`, 
     0.7368421052631579}, {-0.011112927263166747`, 0.8062159594127358}}], 
    ArrowBox[{{-0.10526315789473684`, 
     0.9473684210526315}, {-0.011112927263166747`, 1.0365633763878033`}}], 
    ArrowBox[{{-0.10526315789473684`, 
     1.1578947368421053`}, {-0.011112927263166747`, 1.2669107933628707`}}], 
    ArrowBox[{{-0.10526315789473684`, 
     1.368421052631579}, {-0.011112927263166747`, 1.4972582103379382`}}], 
    ArrowBox[{{-0.10526315789473684`, 
     1.5789473684210527`}, {-0.011112927263166747`, 1.7276056273130054`}}], 
    ArrowBox[{{-0.10526315789473684`, 
     1.7894736842105263`}, {-0.011112927263166747`, 1.9579530442880728`}}], 
    ArrowBox[{{-0.10526315789473684`, 2.}, {-0.011112927263166747`, 
     2.18830046126314}}], 
    ArrowBox[{{0.10526315789473684`, -2.}, {
     0.1994133885263069, -2.18830046126314}}], 
    ArrowBox[{{0.10526315789473684`, -1.7894736842105263`}, {
     0.1994133885263069, -1.9579530442880728`}}], 
    ArrowBox[{{0.10526315789473684`, -1.5789473684210527`}, {
     0.1994133885263069, -1.7276056273130054`}}], 
    ArrowBox[{{0.10526315789473684`, -1.368421052631579}, {
     0.1994133885263069, -1.4972582103379382`}}], 
    ArrowBox[{{0.10526315789473684`, -1.1578947368421053`}, {
     0.1994133885263069, -1.2669107933628707`}}], 
    ArrowBox[{{0.10526315789473684`, -0.9473684210526315}, {
     0.1994133885263069, -1.0365633763878033`}}], 
    ArrowBox[{{0.10526315789473684`, -0.7368421052631579}, {
     0.1994133885263069, -0.8062159594127358}}], 
    ArrowBox[{{0.10526315789473684`, -0.5263157894736842}, {
     0.1994133885263069, -0.5758685424376684}}], 
    ArrowBox[{{0.10526315789473684`, -0.3157894736842105}, {
     0.1994133885263069, -0.34552112546260105`}}], 
    ArrowBox[{{0.10526315789473684`, -0.10526315789473684`}, {
     0.1994133885263069, -0.1151737084875337}}], 
    ArrowBox[{{0.10526315789473684`, 0.10526315789473684`}, {
     0.1994133885263069, 0.1151737084875337}}], 
    ArrowBox[{{0.10526315789473684`, 0.3157894736842105}, {0.1994133885263069,
      0.34552112546260105`}}], 
    ArrowBox[{{0.10526315789473684`, 0.5263157894736842}, {0.1994133885263069,
      0.5758685424376684}}], 
    ArrowBox[{{0.10526315789473684`, 0.7368421052631579}, {0.1994133885263069,
      0.8062159594127358}}], 
    ArrowBox[{{0.10526315789473684`, 0.9473684210526315}, {0.1994133885263069,
      1.0365633763878033`}}], 
    ArrowBox[{{0.10526315789473684`, 1.1578947368421053`}, {
     0.1994133885263069, 1.2669107933628707`}}], 
    ArrowBox[{{0.10526315789473684`, 1.368421052631579}, {0.1994133885263069, 
     1.4972582103379382`}}], 
    ArrowBox[{{0.10526315789473684`, 1.5789473684210527`}, {
     0.1994133885263069, 1.7276056273130054`}}], 
    ArrowBox[{{0.10526315789473684`, 1.7894736842105263`}, {
     0.1994133885263069, 1.9579530442880728`}}], 
    ArrowBox[{{0.10526315789473684`, 2.}, {0.1994133885263069, 
     2.18830046126314}}], 
    ArrowBox[{{0.3157894736842105, -2.}, {
     0.4099397043157806, -2.18830046126314}}], 
    ArrowBox[{{0.3157894736842105, -1.7894736842105263`}, {
     0.4099397043157806, -1.9579530442880728`}}], 
    ArrowBox[{{0.3157894736842105, -1.5789473684210527`}, {
     0.4099397043157806, -1.7276056273130054`}}], 
    ArrowBox[{{0.3157894736842105, -1.368421052631579}, {
     0.4099397043157806, -1.4972582103379382`}}], 
    ArrowBox[{{0.3157894736842105, -1.1578947368421053`}, {
     0.4099397043157806, -1.2669107933628707`}}], 
    ArrowBox[{{0.3157894736842105, -0.9473684210526315}, {
     0.4099397043157806, -1.0365633763878033`}}], 
    ArrowBox[{{0.3157894736842105, -0.7368421052631579}, {
     0.4099397043157806, -0.8062159594127358}}], 
    ArrowBox[{{0.3157894736842105, -0.5263157894736842}, {
     0.4099397043157806, -0.5758685424376684}}], 
    ArrowBox[{{0.3157894736842105, -0.3157894736842105}, {
     0.4099397043157806, -0.34552112546260105`}}], 
    ArrowBox[{{0.3157894736842105, -0.10526315789473684`}, {
     0.4099397043157806, -0.1151737084875337}}], 
    ArrowBox[{{0.3157894736842105, 0.10526315789473684`}, {0.4099397043157806,
      0.1151737084875337}}], 
    ArrowBox[{{0.3157894736842105, 0.3157894736842105}, {0.4099397043157806, 
     0.34552112546260105`}}], 
    ArrowBox[{{0.3157894736842105, 0.5263157894736842}, {0.4099397043157806, 
     0.5758685424376684}}], 
    ArrowBox[{{0.3157894736842105, 0.7368421052631579}, {0.4099397043157806, 
     0.8062159594127358}}], 
    ArrowBox[{{0.3157894736842105, 0.9473684210526315}, {0.4099397043157806, 
     1.0365633763878033`}}], 
    ArrowBox[{{0.3157894736842105, 1.1578947368421053`}, {0.4099397043157806, 
     1.2669107933628707`}}], 
    ArrowBox[{{0.3157894736842105, 1.368421052631579}, {0.4099397043157806, 
     1.4972582103379382`}}], 
    ArrowBox[{{0.3157894736842105, 1.5789473684210527`}, {0.4099397043157806, 
     1.7276056273130054`}}], 
    ArrowBox[{{0.3157894736842105, 1.7894736842105263`}, {0.4099397043157806, 
     1.9579530442880728`}}], 
    ArrowBox[{{0.3157894736842105, 2.}, {0.4099397043157806, 
     2.18830046126314}}], 
    ArrowBox[{{0.5263157894736842, -2.}, {
     0.6204660201052543, -2.18830046126314}}], 
    ArrowBox[{{0.5263157894736842, -1.7894736842105263`}, {
     0.6204660201052543, -1.9579530442880728`}}], 
    ArrowBox[{{0.5263157894736842, -1.5789473684210527`}, {
     0.6204660201052543, -1.7276056273130054`}}], 
    ArrowBox[{{0.5263157894736842, -1.368421052631579}, {
     0.6204660201052543, -1.4972582103379382`}}], 
    ArrowBox[{{0.5263157894736842, -1.1578947368421053`}, {
     0.6204660201052543, -1.2669107933628707`}}], 
    ArrowBox[{{0.5263157894736842, -0.9473684210526315}, {
     0.6204660201052543, -1.0365633763878033`}}], 
    ArrowBox[{{0.5263157894736842, -0.7368421052631579}, {
     0.6204660201052543, -0.8062159594127358}}], 
    ArrowBox[{{0.5263157894736842, -0.5263157894736842}, {
     0.6204660201052543, -0.5758685424376684}}], 
    ArrowBox[{{0.5263157894736842, -0.3157894736842105}, {
     0.6204660201052543, -0.34552112546260105`}}], 
    ArrowBox[{{0.5263157894736842, -0.10526315789473684`}, {
     0.6204660201052543, -0.1151737084875337}}], 
    ArrowBox[{{0.5263157894736842, 0.10526315789473684`}, {0.6204660201052543,
      0.1151737084875337}}], 
    ArrowBox[{{0.5263157894736842, 0.3157894736842105}, {0.6204660201052543, 
     0.34552112546260105`}}], 
    ArrowBox[{{0.5263157894736842, 0.5263157894736842}, {0.6204660201052543, 
     0.5758685424376684}}], 
    ArrowBox[{{0.5263157894736842, 0.7368421052631579}, {0.6204660201052543, 
     0.8062159594127358}}], 
    ArrowBox[{{0.5263157894736842, 0.9473684210526315}, {0.6204660201052543, 
     1.0365633763878033`}}], 
    ArrowBox[{{0.5263157894736842, 1.1578947368421053`}, {0.6204660201052543, 
     1.2669107933628707`}}], 
    ArrowBox[{{0.5263157894736842, 1.368421052631579}, {0.6204660201052543, 
     1.4972582103379382`}}], 
    ArrowBox[{{0.5263157894736842, 1.5789473684210527`}, {0.6204660201052543, 
     1.7276056273130054`}}], 
    ArrowBox[{{0.5263157894736842, 1.7894736842105263`}, {0.6204660201052543, 
     1.9579530442880728`}}], 
    ArrowBox[{{0.5263157894736842, 2.}, {0.6204660201052543, 
     2.18830046126314}}], 
    ArrowBox[{{0.7368421052631579, -2.}, {
     0.830992335894728, -2.18830046126314}}], 
    ArrowBox[{{0.7368421052631579, -1.7894736842105263`}, {
     0.830992335894728, -1.9579530442880728`}}], 
    ArrowBox[{{0.7368421052631579, -1.5789473684210527`}, {
     0.830992335894728, -1.7276056273130054`}}], 
    ArrowBox[{{0.7368421052631579, -1.368421052631579}, {
     0.830992335894728, -1.4972582103379382`}}], 
    ArrowBox[{{0.7368421052631579, -1.1578947368421053`}, {
     0.830992335894728, -1.2669107933628707`}}], 
    ArrowBox[{{0.7368421052631579, -0.9473684210526315}, {
     0.830992335894728, -1.0365633763878033`}}], 
    ArrowBox[{{0.7368421052631579, -0.7368421052631579}, {
     0.830992335894728, -0.8062159594127358}}], 
    ArrowBox[{{0.7368421052631579, -0.5263157894736842}, {
     0.830992335894728, -0.5758685424376684}}], 
    ArrowBox[{{0.7368421052631579, -0.3157894736842105}, {
     0.830992335894728, -0.34552112546260105`}}], 
    ArrowBox[{{0.7368421052631579, -0.10526315789473684`}, {
     0.830992335894728, -0.1151737084875337}}], 
    ArrowBox[{{0.7368421052631579, 0.10526315789473684`}, {0.830992335894728, 
     0.1151737084875337}}], 
    ArrowBox[{{0.7368421052631579, 0.3157894736842105}, {0.830992335894728, 
     0.34552112546260105`}}], 
    ArrowBox[{{0.7368421052631579, 0.5263157894736842}, {0.830992335894728, 
     0.5758685424376684}}], 
    ArrowBox[{{0.7368421052631579, 0.7368421052631579}, {0.830992335894728, 
     0.8062159594127358}}], 
    ArrowBox[{{0.7368421052631579, 0.9473684210526315}, {0.830992335894728, 
     1.0365633763878033`}}], 
    ArrowBox[{{0.7368421052631579, 1.1578947368421053`}, {0.830992335894728, 
     1.2669107933628707`}}], 
    ArrowBox[{{0.7368421052631579, 1.368421052631579}, {0.830992335894728, 
     1.4972582103379382`}}], 
    ArrowBox[{{0.7368421052631579, 1.5789473684210527`}, {0.830992335894728, 
     1.7276056273130054`}}], 
    ArrowBox[{{0.7368421052631579, 1.7894736842105263`}, {0.830992335894728, 
     1.9579530442880728`}}], 
    ArrowBox[{{0.7368421052631579, 2.}, {0.830992335894728, 
     2.18830046126314}}], 
    ArrowBox[{{0.9473684210526315, -2.}, {
     1.0415186516842017`, -2.18830046126314}}], 
    ArrowBox[{{0.9473684210526315, -1.7894736842105263`}, {
     1.0415186516842017`, -1.9579530442880728`}}], 
    ArrowBox[{{0.9473684210526315, -1.5789473684210527`}, {
     1.0415186516842017`, -1.7276056273130054`}}], 
    ArrowBox[{{0.9473684210526315, -1.368421052631579}, {
     1.0415186516842017`, -1.4972582103379382`}}], 
    ArrowBox[{{0.9473684210526315, -1.1578947368421053`}, {
     1.0415186516842017`, -1.2669107933628707`}}], 
    ArrowBox[{{0.9473684210526315, -0.9473684210526315}, {
     1.0415186516842017`, -1.0365633763878033`}}], 
    ArrowBox[{{0.9473684210526315, -0.7368421052631579}, {
     1.0415186516842017`, -0.8062159594127358}}], 
    ArrowBox[{{0.9473684210526315, -0.5263157894736842}, {
     1.0415186516842017`, -0.5758685424376684}}], 
    ArrowBox[{{0.9473684210526315, -0.3157894736842105}, {
     1.0415186516842017`, -0.34552112546260105`}}], 
    ArrowBox[{{0.9473684210526315, -0.10526315789473684`}, {
     1.0415186516842017`, -0.1151737084875337}}], 
    ArrowBox[{{0.9473684210526315, 0.10526315789473684`}, {
     1.0415186516842017`, 0.1151737084875337}}], 
    ArrowBox[{{0.9473684210526315, 0.3157894736842105}, {1.0415186516842017`, 
     0.34552112546260105`}}], 
    ArrowBox[{{0.9473684210526315, 0.5263157894736842}, {1.0415186516842017`, 
     0.5758685424376684}}], 
    ArrowBox[{{0.9473684210526315, 0.7368421052631579}, {1.0415186516842017`, 
     0.8062159594127358}}], 
    ArrowBox[{{0.9473684210526315, 0.9473684210526315}, {1.0415186516842017`, 
     1.0365633763878033`}}], 
    ArrowBox[{{0.9473684210526315, 1.1578947368421053`}, {1.0415186516842017`,
      1.2669107933628707`}}], 
    ArrowBox[{{0.9473684210526315, 1.368421052631579}, {1.0415186516842017`, 
     1.4972582103379382`}}], 
    ArrowBox[{{0.9473684210526315, 1.5789473684210527`}, {1.0415186516842017`,
      1.7276056273130054`}}], 
    ArrowBox[{{0.9473684210526315, 1.7894736842105263`}, {1.0415186516842017`,
      1.9579530442880728`}}], 
    ArrowBox[{{0.9473684210526315, 2.}, {1.0415186516842017`, 
     2.18830046126314}}], 
    ArrowBox[{{1.1578947368421053`, -2.}, {
     1.2520449674736753`, -2.18830046126314}}], 
    ArrowBox[{{1.1578947368421053`, -1.7894736842105263`}, {
     1.2520449674736753`, -1.9579530442880728`}}], 
    ArrowBox[{{1.1578947368421053`, -1.5789473684210527`}, {
     1.2520449674736753`, -1.7276056273130054`}}], 
    ArrowBox[{{1.1578947368421053`, -1.368421052631579}, {
     1.2520449674736753`, -1.4972582103379382`}}], 
    ArrowBox[{{1.1578947368421053`, -1.1578947368421053`}, {
     1.2520449674736753`, -1.2669107933628707`}}], 
    ArrowBox[{{1.1578947368421053`, -0.9473684210526315}, {
     1.2520449674736753`, -1.0365633763878033`}}], 
    ArrowBox[{{1.1578947368421053`, -0.7368421052631579}, {
     1.2520449674736753`, -0.8062159594127358}}], 
    ArrowBox[{{1.1578947368421053`, -0.5263157894736842}, {
     1.2520449674736753`, -0.5758685424376684}}], 
    ArrowBox[{{1.1578947368421053`, -0.3157894736842105}, {
     1.2520449674736753`, -0.34552112546260105`}}], 
    ArrowBox[{{1.1578947368421053`, -0.10526315789473684`}, {
     1.2520449674736753`, -0.1151737084875337}}], 
    ArrowBox[{{1.1578947368421053`, 0.10526315789473684`}, {
     1.2520449674736753`, 0.1151737084875337}}], 
    ArrowBox[{{1.1578947368421053`, 0.3157894736842105}, {1.2520449674736753`,
      0.34552112546260105`}}], 
    ArrowBox[{{1.1578947368421053`, 0.5263157894736842}, {1.2520449674736753`,
      0.5758685424376684}}], 
    ArrowBox[{{1.1578947368421053`, 0.7368421052631579}, {1.2520449674736753`,
      0.8062159594127358}}], 
    ArrowBox[{{1.1578947368421053`, 0.9473684210526315}, {1.2520449674736753`,
      1.0365633763878033`}}], 
    ArrowBox[{{1.1578947368421053`, 1.1578947368421053`}, {
     1.2520449674736753`, 1.2669107933628707`}}], 
    ArrowBox[{{1.1578947368421053`, 1.368421052631579}, {1.2520449674736753`, 
     1.4972582103379382`}}], 
    ArrowBox[{{1.1578947368421053`, 1.5789473684210527`}, {
     1.2520449674736753`, 1.7276056273130054`}}], 
    ArrowBox[{{1.1578947368421053`, 1.7894736842105263`}, {
     1.2520449674736753`, 1.9579530442880728`}}], 
    ArrowBox[{{1.1578947368421053`, 2.}, {1.2520449674736753`, 
     2.18830046126314}}], 
    ArrowBox[{{1.368421052631579, -2.}, {
     1.462571283263149, -2.18830046126314}}], 
    ArrowBox[{{1.368421052631579, -1.7894736842105263`}, {
     1.462571283263149, -1.9579530442880728`}}], 
    ArrowBox[{{1.368421052631579, -1.5789473684210527`}, {
     1.462571283263149, -1.7276056273130054`}}], 
    ArrowBox[{{1.368421052631579, -1.368421052631579}, {
     1.462571283263149, -1.4972582103379382`}}], 
    ArrowBox[{{1.368421052631579, -1.1578947368421053`}, {
     1.462571283263149, -1.2669107933628707`}}], 
    ArrowBox[{{1.368421052631579, -0.9473684210526315}, {
     1.462571283263149, -1.0365633763878033`}}], 
    ArrowBox[{{1.368421052631579, -0.7368421052631579}, {
     1.462571283263149, -0.8062159594127358}}], 
    ArrowBox[{{1.368421052631579, -0.5263157894736842}, {
     1.462571283263149, -0.5758685424376684}}], 
    ArrowBox[{{1.368421052631579, -0.3157894736842105}, {
     1.462571283263149, -0.34552112546260105`}}], 
    ArrowBox[{{1.368421052631579, -0.10526315789473684`}, {
     1.462571283263149, -0.1151737084875337}}], 
    ArrowBox[{{1.368421052631579, 0.10526315789473684`}, {1.462571283263149, 
     0.1151737084875337}}], 
    ArrowBox[{{1.368421052631579, 0.3157894736842105}, {1.462571283263149, 
     0.34552112546260105`}}], 
    ArrowBox[{{1.368421052631579, 0.5263157894736842}, {1.462571283263149, 
     0.5758685424376684}}], 
    ArrowBox[{{1.368421052631579, 0.7368421052631579}, {1.462571283263149, 
     0.8062159594127358}}], 
    ArrowBox[{{1.368421052631579, 0.9473684210526315}, {1.462571283263149, 
     1.0365633763878033`}}], 
    ArrowBox[{{1.368421052631579, 1.1578947368421053`}, {1.462571283263149, 
     1.2669107933628707`}}], 
    ArrowBox[{{1.368421052631579, 1.368421052631579}, {1.462571283263149, 
     1.4972582103379382`}}], 
    ArrowBox[{{1.368421052631579, 1.5789473684210527`}, {1.462571283263149, 
     1.7276056273130054`}}], 
    ArrowBox[{{1.368421052631579, 1.7894736842105263`}, {1.462571283263149, 
     1.9579530442880728`}}], 
    ArrowBox[{{1.368421052631579, 2.}, {1.462571283263149, 
     2.18830046126314}}], 
    ArrowBox[{{1.5789473684210527`, -2.}, {
     1.6730975990526227`, -2.18830046126314}}], 
    ArrowBox[{{1.5789473684210527`, -1.7894736842105263`}, {
     1.6730975990526227`, -1.9579530442880728`}}], 
    ArrowBox[{{1.5789473684210527`, -1.5789473684210527`}, {
     1.6730975990526227`, -1.7276056273130054`}}], 
    ArrowBox[{{1.5789473684210527`, -1.368421052631579}, {
     1.6730975990526227`, -1.4972582103379382`}}], 
    ArrowBox[{{1.5789473684210527`, -1.1578947368421053`}, {
     1.6730975990526227`, -1.2669107933628707`}}], 
    ArrowBox[{{1.5789473684210527`, -0.9473684210526315}, {
     1.6730975990526227`, -1.0365633763878033`}}], 
    ArrowBox[{{1.5789473684210527`, -0.7368421052631579}, {
     1.6730975990526227`, -0.8062159594127358}}], 
    ArrowBox[{{1.5789473684210527`, -0.5263157894736842}, {
     1.6730975990526227`, -0.5758685424376684}}], 
    ArrowBox[{{1.5789473684210527`, -0.3157894736842105}, {
     1.6730975990526227`, -0.34552112546260105`}}], 
    ArrowBox[{{1.5789473684210527`, -0.10526315789473684`}, {
     1.6730975990526227`, -0.1151737084875337}}], 
    ArrowBox[{{1.5789473684210527`, 0.10526315789473684`}, {
     1.6730975990526227`, 0.1151737084875337}}], 
    ArrowBox[{{1.5789473684210527`, 0.3157894736842105}, {1.6730975990526227`,
      0.34552112546260105`}}], 
    ArrowBox[{{1.5789473684210527`, 0.5263157894736842}, {1.6730975990526227`,
      0.5758685424376684}}], 
    ArrowBox[{{1.5789473684210527`, 0.7368421052631579}, {1.6730975990526227`,
      0.8062159594127358}}], 
    ArrowBox[{{1.5789473684210527`, 0.9473684210526315}, {1.6730975990526227`,
      1.0365633763878033`}}], 
    ArrowBox[{{1.5789473684210527`, 1.1578947368421053`}, {
     1.6730975990526227`, 1.2669107933628707`}}], 
    ArrowBox[{{1.5789473684210527`, 1.368421052631579}, {1.6730975990526227`, 
     1.4972582103379382`}}], 
    ArrowBox[{{1.5789473684210527`, 1.5789473684210527`}, {
     1.6730975990526227`, 1.7276056273130054`}}], 
    ArrowBox[{{1.5789473684210527`, 1.7894736842105263`}, {
     1.6730975990526227`, 1.9579530442880728`}}], 
    ArrowBox[{{1.5789473684210527`, 2.}, {1.6730975990526227`, 
     2.18830046126314}}], 
    ArrowBox[{{1.7894736842105263`, -2.}, {
     1.8836239148420963`, -2.18830046126314}}], 
    ArrowBox[{{1.7894736842105263`, -1.7894736842105263`}, {
     1.8836239148420963`, -1.9579530442880728`}}], 
    ArrowBox[{{1.7894736842105263`, -1.5789473684210527`}, {
     1.8836239148420963`, -1.7276056273130054`}}], 
    ArrowBox[{{1.7894736842105263`, -1.368421052631579}, {
     1.8836239148420963`, -1.4972582103379382`}}], 
    ArrowBox[{{1.7894736842105263`, -1.1578947368421053`}, {
     1.8836239148420963`, -1.2669107933628707`}}], 
    ArrowBox[{{1.7894736842105263`, -0.9473684210526315}, {
     1.8836239148420963`, -1.0365633763878033`}}], 
    ArrowBox[{{1.7894736842105263`, -0.7368421052631579}, {
     1.8836239148420963`, -0.8062159594127358}}], 
    ArrowBox[{{1.7894736842105263`, -0.5263157894736842}, {
     1.8836239148420963`, -0.5758685424376684}}], 
    ArrowBox[{{1.7894736842105263`, -0.3157894736842105}, {
     1.8836239148420963`, -0.34552112546260105`}}], 
    ArrowBox[{{1.7894736842105263`, -0.10526315789473684`}, {
     1.8836239148420963`, -0.1151737084875337}}], 
    ArrowBox[{{1.7894736842105263`, 0.10526315789473684`}, {
     1.8836239148420963`, 0.1151737084875337}}], 
    ArrowBox[{{1.7894736842105263`, 0.3157894736842105}, {1.8836239148420963`,
      0.34552112546260105`}}], 
    ArrowBox[{{1.7894736842105263`, 0.5263157894736842}, {1.8836239148420963`,
      0.5758685424376684}}], 
    ArrowBox[{{1.7894736842105263`, 0.7368421052631579}, {1.8836239148420963`,
      0.8062159594127358}}], 
    ArrowBox[{{1.7894736842105263`, 0.9473684210526315}, {1.8836239148420963`,
      1.0365633763878033`}}], 
    ArrowBox[{{1.7894736842105263`, 1.1578947368421053`}, {
     1.8836239148420963`, 1.2669107933628707`}}], 
    ArrowBox[{{1.7894736842105263`, 1.368421052631579}, {1.8836239148420963`, 
     1.4972582103379382`}}], 
    ArrowBox[{{1.7894736842105263`, 1.5789473684210527`}, {
     1.8836239148420963`, 1.7276056273130054`}}], 
    ArrowBox[{{1.7894736842105263`, 1.7894736842105263`}, {
     1.8836239148420963`, 1.9579530442880728`}}], 
    ArrowBox[{{1.7894736842105263`, 2.}, {1.8836239148420963`, 
     2.18830046126314}}], 
    ArrowBox[{{2., -2.}, {2.0941502306315702`, -2.18830046126314}}], 
    ArrowBox[{{2., -1.7894736842105263`}, {
     2.0941502306315702`, -1.9579530442880728`}}], 
    ArrowBox[{{2., -1.5789473684210527`}, {
     2.0941502306315702`, -1.7276056273130054`}}], 
    ArrowBox[{{2., -1.368421052631579}, {
     2.0941502306315702`, -1.4972582103379382`}}], 
    ArrowBox[{{2., -1.1578947368421053`}, {
     2.0941502306315702`, -1.2669107933628707`}}], 
    ArrowBox[{{2., -0.9473684210526315}, {
     2.0941502306315702`, -1.0365633763878033`}}], 
    ArrowBox[{{2., -0.7368421052631579}, {
     2.0941502306315702`, -0.8062159594127358}}], 
    ArrowBox[{{2., -0.5263157894736842}, {
     2.0941502306315702`, -0.5758685424376684}}], 
    ArrowBox[{{2., -0.3157894736842105}, {
     2.0941502306315702`, -0.34552112546260105`}}], 
    ArrowBox[{{2., -0.10526315789473684`}, {
     2.0941502306315702`, -0.1151737084875337}}], 
    ArrowBox[{{2., 0.10526315789473684`}, {2.0941502306315702`, 
     0.1151737084875337}}], 
    ArrowBox[{{2., 0.3157894736842105}, {2.0941502306315702`, 
     0.34552112546260105`}}], 
    ArrowBox[{{2., 0.5263157894736842}, {2.0941502306315702`, 
     0.5758685424376684}}], 
    ArrowBox[{{2., 0.7368421052631579}, {2.0941502306315702`, 
     0.8062159594127358}}], 
    ArrowBox[{{2., 0.9473684210526315}, {2.0941502306315702`, 
     1.0365633763878033`}}], 
    ArrowBox[{{2., 1.1578947368421053`}, {2.0941502306315702`, 
     1.2669107933628707`}}], 
    ArrowBox[{{2., 1.368421052631579}, {2.0941502306315702`, 
     1.4972582103379382`}}], 
    ArrowBox[{{2., 1.5789473684210527`}, {2.0941502306315702`, 
     1.7276056273130054`}}], 
    ArrowBox[{{2., 1.7894736842105263`}, {2.0941502306315702`, 
     1.9579530442880728`}}], 
    ArrowBox[{{2., 2.}, {2.0941502306315702`, 2.18830046126314}}]}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.013], LineBox[CompressedData["
1:eJwVyn8003scx3HjkkXrksyPm4Z0O3LljHBdu+9FR6X066If+oF7a340WiG3
7g0lFdX6RRLu1dXVnavVzaF1rU/jbrtlMTIRZcbYl2EY82Pa/d4/Xud5Hue8
nGOTdx8xNjIy2o7v/wZ4/KExGAwo0SSqmrNbAHHzyvQzegPyIX1tcTpSAPmv
XQi6GQPasKjIP3S/ADRxxVaj4wYUf6GMPBIjgIoHbGp3nwFl0ieGA1kCsFmZ
lvJMbEDlu+zJptcFMGoVPHOcbUCrzhcK/ZsEUKbrNvQ6GVBKr8rWP6weYs98
k9vm/gm5BPKWfDjWAD+ZOUZNhiwgPrJdd+jyP1B0lpidy9CjanTRx/axEKy5
LmuoqfOoXW+jOGsshr6BOmuzW3OIeNc9cnDnv0B6l5U+VDKLmqNdncXSV0Cr
jvDdVDWD6CNsTWV0IwgLOQFSiQ412HPn04clULHe/Xl85zRyzztn//JxEyg6
3TPXTU+hufebfdP8pUBJDChlkqdQS5wFOY/SArzqFL86Ny2aqdMFWa5tBY6p
F9lv4ySqVwrsdlDfwjTJ9kT9jgnEi15YfCm6DUJMLdxEh8dR0KJf5dvuyWDU
OMtpOkOD+C3HaZMt7dDLCl7NdBhDrk8d9Pd9O6BQnVMcEjGCntc6iD3vdIJJ
x0rihoRhVM3b+6x7bReklbS7eVzCkEnbm64zLd1QxGI3J4sG0blL2pq3rI9w
sqYkue2jEnHt4/9WfSmHBeKj4hvkfrQ8xf1hsE0vsP26f4R9ClTP2oKWExUg
kx0OI6XKkXwv84WPSx8UmTZGJcZ+QHyGcK/Orx8m6VlE/bVOlGB3wbU1TQlR
XifJSW9kSOfseVVbPwCrafFwY1sryjCX8KWLVVATafNQbZAgmqjaB85jMMA8
ZGqvEqKDtFDu97ohSHgPIZ+r+CiGsX5BlK6GSH53nLqsCiUHKUSR3qPwiVQZ
YXWbgTg3txanqMZg3U5px/4lVWB7IWCz65gGHL2Z877iOuD8wN4RPjgOmhpB
9opoIdRSlrxjqSYgy+rUX45aCUTke/Irl2rhdzvr9iiTVpjXXNme5D0FrmLa
AKNDBrNmmGbPuWm4Lviq4Oa9ThAdiFVDjw6KSu09LJ0+QDoVIb7fLDiFVQ05
p8nBMuNlIr1hDmh1W6nKQAVsihlz3BOqh/Bdkle1c33A3DjixuhZgNpUXUL8
RyVMMg/wLj82QFweJaO+bBCkahnL7IUR/YiXtnguF4OYHHatWEigH1t6zG59
Hgb79TyqCveJ0b5bybgdmlc+MhcR6Jl/vs3tx116peTBFtxFa56mN13BoPBk
zJ1G3FLKifD71zAI3mmR0ywm0AOsNBahNzHwDBxiv3tFoNM1jIvZuKkrsqxn
cG9q7jFGuNlx3+XbvSbQw682z3rfwoBA59zbhzuZyB1ccRsDzgKlsgt3OSGp
YTwfA+tl3rKeRvwlV37rUYDBKUlmlJGEQH+CDj4/ivvTNFFBwf3i57AnXbid
y5rGYnB3znr8IryDQXmEM6kft7yj3MGoEIOp30ILPntDoA/UflEQgFtylOvk
hlubanmVi7t+61qvo7jnwrPNh3DzkoJ4ObgJPvrzq+5igC3KD6rAbb4sxXAI
NyK7SsS4SRPDp+/irihVR6hw/wdUaolt
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], Thickness[0.013], LineBox[CompressedData["
1:eJwVzH88E3gcx3FTrqlmklS6k04Kd+VHvx64fJZQV6noh3CuUnLV6ZdfJ03G
uEJHHtF1D3fF1WlKmNr8mPuy5uew/MjPawxnGzY/tmZs2X3vj/fj9Xj+894Q
fNU3RF9PT+8w3v814Gwd1+l0aGzbnKyYygDunLzPWaNDtGOmS72TGBC/q6gp
XKVDD1qqL4+nMUDLtC8QT+hQw026vn0OA5QMh4uCXh06w6rOaKtgwMhDJ/Ef
pToUEr+kka7Gf+E7h3eH6pCPcWjs88gCiPvKrT+2dQGJJH12y6NfQPa1vxd7
Jn5C+UbR5bvqCyFBtdOScFiLnKuso1KNiiH50U3PVgsNoqVMhwYdKAFbE/un
kvdzSNoyKrzBYcITfr/yY54aeVdLC5mOr4EVMBd39OQsqpzfWEIWv4Hhz4ZM
OGQVEkQqZn8sY8OIgvur+YAS9a9lBXncKwc6y/RU3QMF6pDy7+YzK0Fd/r1h
yJkZNO+c6bruQxXQ+8J5pk7TaDvH5kLgymoIylVct+qcRGWipMsxl2oggDzl
tuiaDEmXG9ODeVzIsmmNo/aMIb+uwNNsfx7oYt3b13pLUJd035YhYh2s8Mk3
zJH9i9a2T4lXV9bD2TZZaVnAMEozP/dCzG4E/46N7pWKQSQ+YVboVM4HC0Js
cjHzH5S0+Gj6c5NWkAh6irZmdyPiTGJq0LfvQD9vde5Pbe0ocm5kfCC1DRyy
tk3JD/JRcuVkfaNBB2gm5rbQn9agNKG+wf7ETjAIdIrYG1iM3t71urPPrAum
Ny+5wWZlwJ6KPGaSvBuQqIR0zY8NUakkYUVTLzQeGTtmb1QHbP6Xq6vU/aAJ
9rElW76DKx5htIsHhMD9rXnQRdQJoUaU0p1HB4F0i850NOwDyjLbKw9fiYAY
EMj5rlcI6+tzVBuNh6FDlCDIbRCBYMb1YnLSCJy/rGqZ9xsBRm2GwwrXUfAO
j5GEVY4CqYBrY64Ug1pgnuHlKwX59GvqqFoKmgL+MeeqcaCmsKPL9SdAcHB0
0dLP5VDjcfW5kZ0cmE/SLS39psCODUTyqSlg9G3z3p8yDWsyys2Gfp8GAoRS
rLpnwIukQS/XKcA9WWAr+0IJq7L3nJssUUJRGmzgHf4I9B1ED8+DKqBWuQ14
P1LBJLc3TWanhuhCzxcjLbNw/YfTJSTyPPjH08IuadWwxr2OdslICznUQ6o8
j3mQ/Zl14lnIAixzWX9PEqWBlU9Ys+IzepR+S9rYIFcL4dtrEkVcAuXmUvYj
4lstSIZu3Se9JVDMlRP7HbCb3j977IwdUH8q/zb28ntQdR+7L8zhvAVPC06n
Mz/t4REoPRUDHwJrteB4m5WZV0ugdB13a+uq18KGNXrk8w0ESpRbRPwCtt/Z
C3YZ2GY2BfabGrQgNHbx4mCf1Kz6JRLbIt/2tmkjgfI+V3bAtFELxq22Kh52
pzyH59OkBTfFK7U1n0CJ6GkPj8Gutpww98U25RKtcrFTarN3x2Efz4qgTWHv
iNlO78LucD3kls7XQtZf981+biZQblgnyFjYhi9dvinFNiGX5Qix9zr6BA9g
+w5ZabY0a8Ed1RXtaiFQZvj+BSewNzdZd5/DznyT7k/FJvvPLKRjOz2uJT7D
Ngz7ejMHu/2Oht2MvWlJ5xEJ9n9jo5XG
      "]]}}, {{}, 
    {GrayLevel[0], PointSize[0.03], 
     PointBox[{{0., 1.}, {0., 0.36787944117144233`}}]}, {}}}]], "Output",
 CellChangeTimes->{
  3.426019250804113*^9, 3.426019323728974*^9, {3.4260194076396313`*^9, 
   3.4260194215095754`*^9}, 3.4260196071765513`*^9, 3.426019675234414*^9, 
   3.4260197231433034`*^9, 3.426019817559067*^9, 3.4260198558341036`*^9, 
   3.4260206913455095`*^9, 3.4260207603647547`*^9}]
}, Open  ]]
},
WindowSize->{794, 835},
WindowMargins->{{158, Automatic}, {Automatic, 15}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1227, 30, 450, "Input"],
Cell[CellGroupData[{
Cell[1820, 55, 4845, 123, 695, "Input"],
Cell[6668, 180, 46603, 865, 514, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
