(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11979,        331]
NotebookOptionsPosition[     11585,        315]
NotebookOutlinePosition[     12026,        332]
CellTagsIndexPosition[     11983,        329]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates some elements of contour computation using the \
marching squares method. 

Here we plot a simple function, z=xy, over [-1,1]x[-1,1] and show its \
intersection with three different planes: z=-0.2, z=0, and z=0.2.  At the \
edges of the surface patch, the intersection points with the planes are \
identical, but the connectivity of the intersection points differs. This is \
one the big challenges with the marching squares method. (And also a \
challenge with the marching cubes method in 3D.)

Also demonstrated in this notebook is a contour plot of z=xy. Each of the \
\"contours\" produced by intersecting the surface with a plane is visible in \
the multi-level contour plot.

Figures  14.17 was created with this notebook.

See Chapter 14 : Visualizing Scalar Values over 2D for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4269470583793697`*^9, 3.4269470757243104`*^9}, {
  3.4269471652029743`*^9, 3.426947215725622*^9}, {3.4269479277194195`*^9, 
  3.426948040882139*^9}, {3.4269481685256815`*^9, 3.4269483145656767`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "hyperbolic", " ", "paraboloid"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], "=", 
     RowBox[{"x", " ", "y"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "three", " ", "plane", " ", "equations"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"z", " ", "=", " ", 
      RowBox[{"-", "0.2"}]}], ",", "  ", 
     RowBox[{"z", "=", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"and", " ", "z"}], "=", "0.2"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"planeneg", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], "=", 
     RowBox[{"-", "0.2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"planezero", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], "=", "0.0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"planepos", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], "=", "0.2"}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "hyperbolic",
      " ", "paraboloid", " ", 
     RowBox[{"over", " ", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "]"}]}], " ", "*)"}], 
   RowBox[{"plot1", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "25"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Orange", ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "100"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", 
     RowBox[{"(", "separate", ")"}], " ", "plots", " ", "of", " ", "the", " ",
      "three", " ", "planes"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot2", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"planepos", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "2"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Green", ",", 
          RowBox[{"Specularity", "[", 
           RowBox[{"White", ",", "10"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot3", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"planezero", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "2"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Green", ",", 
          RowBox[{"Specularity", "[", 
           RowBox[{"White", ",", "10"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot4", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"planeneg", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "2"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Green", ",", 
          RowBox[{"Specularity", "[", 
           RowBox[{"White", ",", "10"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Pair", " ", "the", " ", "hyperbolic", " ", "paraboloid", " ", "surface",
       " ", "with", " ", "each", " ", "of", " ", "the", " ", "three", " ", 
      "planes"}], ",", " ", 
     RowBox[{"creating", " ", "three", " ", "plots"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Picture1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plot1", ",", "plot2"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Picture2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plot1", ",", "plot3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Picture3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plot1", ",", "plot4"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<contourxy_posplane.eps\>\"", ",", "Picture1"}], "]"}], ";",
      "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<contourxy_zeroplane.eps\>\"", ",", "Picture2"}], "]"}], 
     ";", " ", "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<contourxy_negplane.eps\>\"", ",", "Picture3"}], "]"}], 
     ";"}], " ", "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "contour", " ", "plot", " ", "of", " ", "the", 
     " ", "hyperbolic", " ", "paraboloid"}], " ", "*)"}], 
   RowBox[{"contplot", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"Contours", "\[Rule]", "15"}], ",", 
      RowBox[{"ContourShading", "\[Rule]", "False"}]}], "]"}]}]}]}]], "Input",\

 CellChangeTimes->{{3.4269472189102015`*^9, 3.426947656679683*^9}, {
  3.426947762021157*^9, 3.4269478324524317`*^9}}]
},
WindowSize->{667, 740},
WindowMargins->{{173, Automatic}, {Automatic, 45}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1258, 29, 559, "Input"],
Cell[1829, 52, 9752, 261, 1501, "Input"]
}
]
*)

(* End of internal cache information *)
