(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22471,        583]
NotebookOptionsPosition[     21856,        561]
NotebookOutlinePosition[     22274,        577]
CellTagsIndexPosition[     22231,        574]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates elements of marching cubes for contouring of 3d \
functions.

Figures  15.6 was created with this notebook.

See Chapter 15 : Volume Visualization for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4269617765630784`*^9, 3.426961795430208*^9}, {
  3.426961830660867*^9, 3.426961850729725*^9}, {3.4269883636133795`*^9, 
  3.4269883907123456`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  " ", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "some", " ", "color", " ", "variables"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"trigray", "=", "0.7"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pntgray", "=", "0.0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cubegray", "=", "0.8"}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", 
     RowBox[{"range", "  ", "--"}], " ", "this", " ", "keeps", " ", 
     "Mathematica", " ", "from", " ", "clipping", " ", "part", " ", "of", " ",
      "the", " ", "picture"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r0", "=", 
     RowBox[{"-", "0.1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r1", "=", "1.1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Here", " ", "is", " ", "our", " ", "cube", " ", "centered", " ", "at", 
      " ", "the", " ", "origin"}], ",", " ", 
     RowBox[{"shown", " ", "with", " ", "edges", " ", "only"}]}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cube", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0", "]"}], ",", " ", 
        RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
        RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "points", " ", "at", " ", "select", " ", "corners"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "will", " ", "mark", " ", "vertices", " ", "that", " ", 
     "are", " ", "on", " ", "or", " ", "above", " ", "the", " ", "contour", 
     " ", "value"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"corner000", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"corner100", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"corner101", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"corner001", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "0.1", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "the", " ", "marching", " ", "cubes", " ", "contour", " ", 
     "results", " ", "that", " ", "correspond", " ", "to", " ", "difference", 
     " ", "sets", " ", "of", " ", "vertices", " ", "on", " ", "or", " ", 
     "above", " ", "the", " ", "contour", " ", "level"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "THis", " ", "is", " ", "a", " ", "triangle", " ", "surrounding", " ", 
     "one", " ", "vertex"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon0", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "trigray", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.5", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.5", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"old", " ", "stuff"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"tpoint0", "=", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0.0", ",", "0.5", ",", "0"}], "}"}], "]"}], ",", 
         RowBox[{"GrayLevel", "[", "trigray", "]"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"tpoint1", "=", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"0.0", ",", "0", ",", "0.5"}], "}"}], "]"}]}], "}"}], 
        "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"tpoint2", "=", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"0.5", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], 
         "]"}]}]}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"cube", ",", "corner000", ",", "polygon0", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", " ", "next"}]}], " ", 
      RowBox[{
       RowBox[{"case", " ", "--"}], "--"}]}], "-"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon1", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0.5`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.5`", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0.5`", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon2", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.7`", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0.5`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0.5`", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0.5`"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic2", "=", 
     RowBox[{"Show", "[", 
      RowBox[{
      "cube", ",", "polygon1", ",", "polygon2", ",", "corner000", ",", 
       "corner100", ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"2.208`", ",", 
          RowBox[{"-", "1.112`"}], ",", "2.671`"}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"r0", ",", "r1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r0", ",", "r1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r0", ",", "r1"}], "}"}]}], "}"}]}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", " ", "next"}]}], " ", 
      RowBox[{
       RowBox[{"case", " ", "--"}], "--"}]}], "-"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon3", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "trigray", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0.5`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0.5`", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.5`", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "cube", ",", "corner000", ",", "polygon0", ",", "corner101", ",", 
      "polygon3", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", " ", "next"}]}], " ", 
      RowBox[{
       RowBox[{"case", " ", "--"}], "--"}]}], "-"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon4", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "trigray", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0.5`", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0.5`", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0.5`"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon5", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "trigray", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0.5`", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0", ",", "0.5`"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.5`", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polygon6", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "trigray", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0.5`", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.5`", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0.5`", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   " ", 
   RowBox[{"pic4", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "cube", ",", "corner000", ",", "corner100", ",", "corner001", ",", 
      "polygon4", ",", "polygon5", ",", "polygon6", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2.208`", ",", 
         RowBox[{"-", "1.112`"}], ",", "2.671`"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"r0", ",", "r1"}], "}"}]}], "}"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "all", " ", "the", " ", "pics", " ", "together"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g", "=", 
     RowBox[{"GraphicsRow", "[", 
      RowBox[{"{", 
       RowBox[{"pic1", ",", "pic2", ",", "pic3", ",", "pic4"}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
   RowBox[{"Show", "[", "g", "]"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "pic", " ", "to", " ", "postscript", " ", "file"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<marchingcubes.eps\>\"", ",", "%"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4269618556467953`*^9, 3.4269625607807283`*^9}, {
  3.4269626501792765`*^9, 3.426962654245123*^9}, {3.426962721782237*^9, 
  3.426962821034955*^9}, {3.426987251033568*^9, 3.4269873020469217`*^9}, {
  3.426987424462947*^9, 3.4269874397649508`*^9}, {3.4269874959457345`*^9, 
  3.4269875258687615`*^9}, {3.426987615457584*^9, 3.4269876359470463`*^9}, {
  3.4269876893137836`*^9, 3.4269876973653617`*^9}, {3.4269877301525073`*^9, 
  3.4269877335674176`*^9}, {3.4269877682172413`*^9, 3.426987940705267*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0], EdgeForm[Thickness[Large]], 
    StyleBox[CuboidBox[{0, 0, 0}],
     Boxed -> False]}, 
   {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0.5, 0, 0}, {0, 0.5, 0}, {0, 0, 0.5}}]}},
  Boxed->False,
  PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}}]], "Output",
 CellChangeTimes->{3.4269622774533234`*^9, 3.426962567410261*^9, 
  3.4269628232180943`*^9, 3.426987444882309*^9, 3.4269875268802156`*^9, 
  3.4269876371888323`*^9, 3.426987698026312*^9, 3.426987947134512*^9, 
  3.426988004897571*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0], EdgeForm[Thickness[Large]], 
    StyleBox[CuboidBox[{0, 0, 0}],
     Boxed -> False]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0, 0, 0.5}, {0, 0.5, 0}, {1, 0.5, 0}}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0, 0, 0.5}, {1, 0.5, 0}, {1, 0, 0.5}}]}, 
   {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
   {PointSize[0.1], Point3DBox[{1, 0, 0}]}},
  Boxed->False,
  PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}},
  ViewPoint->{2.208, -1.112, 2.671}]], "Output",
 CellChangeTimes->{3.4269622774533234`*^9, 3.426962567410261*^9, 
  3.4269628232180943`*^9, 3.426987444882309*^9, 3.4269875268802156`*^9, 
  3.4269876371888323`*^9, 3.426987698026312*^9, 3.426987947134512*^9, 
  3.4269880050578012`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0], EdgeForm[Thickness[Large]], 
    StyleBox[CuboidBox[{0, 0, 0}],
     Boxed -> False]}, 
   {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0.5, 0, 0}, {0, 0.5, 0}, {0, 0, 0.5}}]}, 
   {PointSize[0.1], Point3DBox[{1, 0, 1}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{1, 0, 0.5}, {1, 0.5, 1}, {0.5, 0, 1}}]}},
  Boxed->False,
  PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}}]], "Output",
 CellChangeTimes->{3.4269622774533234`*^9, 3.426962567410261*^9, 
  3.4269628232180943`*^9, 3.426987444882309*^9, 3.4269875268802156`*^9, 
  3.4269876371888323`*^9, 3.426987698026312*^9, 3.426987947134512*^9, 
  3.4269880052080173`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0], EdgeForm[Thickness[Large]], 
    StyleBox[CuboidBox[{0, 0, 0}],
     Boxed -> False]}, 
   {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
   {PointSize[0.1], Point3DBox[{1, 0, 0}]}, 
   {PointSize[0.1], Point3DBox[{0, 0, 1}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0, 0.5, 0}, {1, 0.5, 0}, {1, 0, 0.5}}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0, 0.5, 0}, {1, 0, 0.5}, {0.5, 0, 1}}]}, 
   {GrayLevel[0.7], Polygon3DBox[{{0, 0.5, 0}, {0.5, 0, 1}, {0, 0.5, 1}}]}},
  Boxed->False,
  PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}},
  ViewPoint->{2.208, -1.112, 2.671}]], "Output",
 CellChangeTimes->{3.4269622774533234`*^9, 3.426962567410261*^9, 
  3.4269628232180943`*^9, 3.426987444882309*^9, 3.4269875268802156`*^9, 
  3.4269876371888323`*^9, 3.426987698026312*^9, 3.426987947134512*^9, 
  3.4269880053582335`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{
       {Opacity[0], EdgeForm[Thickness[Large]], 
        StyleBox[CuboidBox[{0, 0, 0}],
         Boxed -> False]}, 
       {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0.5, 0, 0}, {0, 0.5, 0}, {0, 0, 0.5}}]}},
      Boxed->False,
      PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}}], {194.4, -189.}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {Opacity[0], EdgeForm[Thickness[Large]], 
        StyleBox[CuboidBox[{0, 0, 0}],
         Boxed -> False]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0, 0, 0.5}, {0, 0.5, 0}, {1, 0.5, 0}}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0, 0, 0.5}, {1, 0.5, 0}, {1, 0, 0.5}}]}, 
       {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
       {PointSize[0.1], Point3DBox[{1, 0, 0}]}},
      Boxed->False,
      PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}},
      ViewPoint->{2.208, -1.112, 2.671}], {583.2, -189.}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {Opacity[0], EdgeForm[Thickness[Large]], 
        StyleBox[CuboidBox[{0, 0, 0}],
         Boxed -> False]}, 
       {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0.5, 0, 0}, {0, 0.5, 0}, {0, 0, 0.5}}]}, 
       {PointSize[0.1], Point3DBox[{1, 0, 1}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{1, 0, 0.5}, {1, 0.5, 1}, {0.5, 0, 1}}]}},
      Boxed->False,
      PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}}], {972., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {Opacity[0], EdgeForm[Thickness[Large]], 
        StyleBox[CuboidBox[{0, 0, 0}],
         Boxed -> False]}, 
       {PointSize[0.1], Point3DBox[{0, 0, 0}]}, 
       {PointSize[0.1], Point3DBox[{1, 0, 0}]}, 
       {PointSize[0.1], Point3DBox[{0, 0, 1}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0, 0.5, 0}, {1, 0.5, 0}, {1, 0, 0.5}}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0, 0.5, 0}, {1, 0, 0.5}, {0.5, 0, 1}}]}, 
       {GrayLevel[0.7], 
        Polygon3DBox[{{0, 0.5, 0}, {0.5, 0, 1}, {0, 0.5, 1}}]}},
      Boxed->False,
      PlotRange->{{-0.1, 1.1}, {-0.1, 1.1}, {-0.1, 1.1}},
      ViewPoint->{2.208, -1.112, 2.671}], {1360.8000000000002`, -189.}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.4269622774533234`*^9, 3.426962567410261*^9, 
  3.4269628232180943`*^9, 3.426987444882309*^9, 3.4269875268802156`*^9, 
  3.4269876371888323`*^9, 3.426987698026312*^9, 3.426987947134512*^9, 
  3.426988005548507*^9}]
}, Open  ]]
},
WindowSize->{734, 740},
WindowMargins->{{75, Automatic}, {Automatic, 9}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 571, 18, 280, "Input"],
Cell[CellGroupData[{
Cell[1164, 43, 14939, 382, 2535, "Input"],
Cell[16106, 427, 573, 12, 520, "Output"],
Cell[16682, 441, 734, 15, 532, "Output"],
Cell[17419, 458, 697, 14, 520, "Output"],
Cell[18119, 474, 856, 17, 532, "Output"],
Cell[18978, 493, 2862, 65, 146, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
