(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20954,        599]
NotebookOptionsPosition[     20001,        566]
NotebookOutlinePosition[     20419,        582]
CellTagsIndexPosition[     20376,        579]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates discrete Gaussian curvature for triangles meshes.
Discrete Gaussian curvature is measured by 2PI - sum of the angles around a \
vertex divided by the area of the star. (See Eq 13.6). Thus by looking at the \
sum of the angles around a vertex, we can categorize the Gaussian curvature \
as negative, zero, or positive. This point is illustrated in this notebook.

Exercise: Add calculation of Gaussian curvature to this notebook. Plus: \
animate the position of the \"peak\" point using the manipulate command.

Figure 13.9 and 13.10 were created with this notebook.

See Chapter 13: Facets for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{
  3.4203068407848325`*^9, 3.420306885859647*^9, 3.4203084273662243`*^9, {
   3.420308860799471*^9, 3.4203088795664563`*^9}, {3.4203089117427235`*^9, 
   3.42030895527532*^9}, {3.4203090155920515`*^9, 3.4203091573358693`*^9}, {
   3.426884521755454*^9, 3.4268845440675373`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "point", " ", "set", " ", "and", " ", 
     "triangulation", " ", 
     RowBox[{"(", 
      RowBox[{"or", " ", "mesh"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "\"\<peak\>\"", " ", "point", " ", "is", " ", "at", " ", 
     "the", " ", "center", " ", "of", " ", "the", " ", "mesh"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt3", "=", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", 
        RowBox[{"-", "0.5`"}]}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt4", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], ";"}], ")"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt5", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "point", " ", "creates", " ", "negative", " ", "Gaussian", 
     " ", "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"peak", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri1", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt1", ",", "pt2", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri2", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt2", ",", "pt3", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri3", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt3", ",", "pt4", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri4", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt4", ",", "pt5", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri5", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt5", ",", "pt1", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"mesh1", "=", 
      RowBox[{"{", 
       RowBox[{"tri1", ",", "tri2", ",", "tri3", ",", "tri4", ",", "tri5"}], 
       "}"}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "mesh"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<This data set has negative Gaussian curvature at the center vertex\>\
\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"mesh1", ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}], ",", "1.5`"}], "}"}]}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "postscript", " ", "output"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<neg_curv.eps\>\"", ",", "pic"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.420306830429943*^9, {3.4203068710483494`*^9, 3.420306872069818*^9}, {
   3.420308449257703*^9, 3.4203085066001573`*^9}, {3.4203085389967413`*^9, 
   3.4203086786775923`*^9}, {3.4203088838225765`*^9, 3.420308907606776*^9}, {
   3.4203091816908903`*^9, 3.4203091889913874`*^9}, {3.42030947461209*^9, 
   3.4203094826035814`*^9}, {3.4268843823950644`*^9, 3.4268844193882575`*^9}}],\


Cell[BoxData[
 SuperscriptBox["Null", "5"]], "Output",
 CellChangeTimes->{
  3.4203068123539505`*^9, 3.4203085756995173`*^9, {3.4203086791582837`*^9, 
   3.420308704224327*^9}, 3.426884482969683*^9}],

Cell[BoxData["\<\"This data set has negative Gaussian curvature at the center \
vertex\"\>"], "Print",
 CellChangeTimes->{3.4268844829897118`*^9}],

Cell[BoxData[
 Graphics3DBox[{Polygon3DBox[{{0, 0, 0}, {1, 0, 1}, {1, 1, 0}}], 
   Polygon3DBox[{{1, 0, 1}, {3, 1, -0.5}, {1, 1, 0}}], 
   Polygon3DBox[{{3, 1, -0.5}, {2, 3, 1}, {1, 1, 0}}], 
   Polygon3DBox[{{2, 3, 1}, {0, 2, -1}, {1, 1, 0}}], 
   Polygon3DBox[{{0, 2, -1}, {0, 0, 0}, {1, 1, 0}}]},
  Boxed->False,
  ImageSize->{360., 338.58831499574774`},
  ViewPoint->{1, -1, 1.5},
  ViewVertical->{-0.08724313776787594, 0.3321654571831863, 
   1.408766543443262}]], "Output",
 CellChangeTimes->{
  3.4203068123539505`*^9, 3.4203085756995173`*^9, {3.4203086791582837`*^9, 
   3.420308704224327*^9}, 3.4268844833001585`*^9}],

Cell[BoxData["\<\"neg_curv.eps\"\>"], "Output",
 CellChangeTimes->{
  3.4203068123539505`*^9, 3.4203085756995173`*^9, {3.4203086791582837`*^9, 
   3.420308704224327*^9}, 3.426884483470403*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "example", " ", "has", " ", "zero", " ", "discrete", " ", 
    "Gaussian", " ", "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "pt1", ",", " ", "pt2", ",", " ", "pt3", ",", " ", "pt4", ",", " ", 
      "pt5"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "tri1", ",", "tri2", ",", " ", "tri3", ",", " ", "tri4", ",", " ", 
      "tri5", ",", " ", "tri5"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "mesh1", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "pic", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "point", " ", "set", " ", "and", " ", 
     "triangulation", " ", 
     RowBox[{"(", 
      RowBox[{"or", " ", "mesh"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "\"\<peak\>\"", " ", "point", " ", "is", " ", "at", " ", 
     "the", " ", "center", " ", "of", " ", "the", " ", "mesh"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt3", "=", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt4", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "0"}], "}"}]}], ";"}], ")"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt5", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "point", " ", "creates", " ", "negative", " ", "Gaussian", 
     " ", "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"peak", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri1", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt1", ",", "pt2", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri2", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt2", ",", "pt3", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri3", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt3", ",", "pt4", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri4", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt4", ",", "pt5", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri5", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt5", ",", "pt1", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"mesh1", "=", 
      RowBox[{"{", 
       RowBox[{"tri1", ",", "tri2", ",", "tri3", ",", "tri4", ",", "tri5"}], 
       "}"}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "mesh"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<This plot has zero Gaussian curvature at the center vertex\>\"", 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"mesh1", ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ")"}], 
   " "}]}]], "Input",
 CellChangeTimes->{{3.4203095144193296`*^9, 3.420309640300338*^9}, {
  3.4203096771232867`*^9, 3.420309736108103*^9}, {3.4203097763059044`*^9, 
  3.4203098436527443`*^9}, {3.4268844365929966`*^9, 3.4268844531468*^9}}],

Cell[BoxData[
 SuperscriptBox["Null", "5"]], "Output",
 CellChangeTimes->{
  3.4203095808047876`*^9, {3.42030961130865*^9, 3.42030964219306*^9}, 
   3.420309736859183*^9, 3.4203098171446276`*^9, 3.4268844879167967`*^9}],

Cell[BoxData["\<\"This plot has zero Gaussian curvature at the center \
vertex\"\>"], "Print",
 CellChangeTimes->{3.426884487926811*^9}],

Cell[BoxData[
 Graphics3DBox[{Polygon3DBox[{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}}], 
   Polygon3DBox[{{1, 0, 0}, {3, 1, 0}, {1, 1, 0}}], 
   Polygon3DBox[{{3, 1, 0}, {2, 3, 0}, {1, 1, 0}}], 
   Polygon3DBox[{{2, 3, 0}, {0, 2, 0}, {1, 1, 0}}], 
   Polygon3DBox[{{0, 2, 0}, {0, 0, 0}, {1, 1, 0}}]},
  Boxed->False,
  ImageSize->{360., 311.1360783916979},
  ViewPoint->{1.7363505514652182`, -0.24762331911179375`, 1.083406412321108},
  ViewVertical->{0.29603693005160014`, -0.022892823510081015`, 
   1.432353176777313}]], "Output",
 CellChangeTimes->{
  3.4203095808047876`*^9, {3.42030961130865*^9, 3.42030964219306*^9}, 
   3.420309736859183*^9, 3.4203098171446276`*^9, 3.4268844879468403`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "example", " ", "has", " ", "positive", " ", "discrete", " ", 
    "Gaussian", " ", "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "pt1", ",", " ", "pt2", ",", " ", "pt3", ",", " ", "pt4", ",", " ", 
      "pt5"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "tri1", ",", "tri2", ",", " ", "tri3", ",", " ", "tri4", ",", " ", 
      "tri5", ",", " ", "tri5"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "mesh1", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "pic", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "point", " ", "set", " ", "and", " ", 
     "triangulation", " ", 
     RowBox[{"(", 
      RowBox[{"or", " ", "mesh"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "\"\<peak\>\"", " ", "point", " ", "is", " ", "at", " ", 
     "the", " ", "center", " ", "of", " ", "the", " ", "mesh"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1.3"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt3", "=", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", "1.5`"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt4", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "1.2"}], "}"}]}], ";"}], ")"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt5", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "1"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "point", " ", "creates", " ", "negative", " ", "Gaussian", 
     " ", "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"peak", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri1", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt1", ",", "pt2", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri2", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt2", ",", "pt3", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri3", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt3", ",", "pt4", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri4", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt4", ",", "pt5", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri5", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt5", ",", "pt1", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"mesh1", "=", 
      RowBox[{"{", 
       RowBox[{"tri1", ",", "tri2", ",", "tri3", ",", "tri4", ",", "tri5"}], 
       "}"}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "mesh"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<This plot has positive Gaussian curvature at the center vertex\>\"", 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"mesh1", ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ")"}], " ", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.4203097437190466`*^9, 3.420309767052599*^9}, {
  3.420309833918748*^9, 3.420309835440936*^9}, {3.4268844689294944`*^9, 
  3.4268844736462765`*^9}}],

Cell[BoxData[
 SuperscriptBox["Null", "5"]], "Output",
 CellChangeTimes->{3.420309827359316*^9, 3.426884491682211*^9}],

Cell[BoxData["\<\"This plot has positive Gaussian curvature at the center \
vertex\"\>"], "Print",
 CellChangeTimes->{3.4268844916922255`*^9}],

Cell[BoxData[
 Graphics3DBox[{Polygon3DBox[{{0, 0, 1.3}, {1, 0, 1}, {1, 1, 0}}], 
   Polygon3DBox[{{1, 0, 1}, {3, 1, 1.5}, {1, 1, 0}}], 
   Polygon3DBox[{{3, 1, 1.5}, {2, 3, 1.2}, {1, 1, 0}}], 
   Polygon3DBox[{{2, 3, 1.2}, {0, 2, 1}, {1, 1, 0}}], 
   Polygon3DBox[{{0, 2, 1}, {0, 0, 1.3}, {1, 1, 0}}]},
  Boxed->False,
  ImageSize->{360., 309.58954247700945`},
  ViewPoint->{1.339755249776523, -1.6000312905172764`, 2.663635812205164},
  ViewVertical->{-0.24298003252624142`, 0.1436215871115949, 
   1.9186803209592713`}]], "Output",
 CellChangeTimes->{3.420309827359316*^9, 3.4268844917122545`*^9}]
}, Open  ]]
},
WindowSize->{724, 879},
WindowMargins->{{60, Automatic}, {Automatic, 7}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1141, 26, 450, "Input"],
Cell[CellGroupData[{
Cell[1734, 51, 5373, 149, 819, "Input"],
Cell[7112, 203, 199, 4, 48, "Output"],
Cell[7314, 209, 146, 2, 27, "Print"],
Cell[7463, 213, 626, 13, 454, "Output"],
Cell[8092, 228, 192, 3, 48, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8321, 236, 4846, 138, 775, "Input"],
Cell[13170, 376, 219, 4, 48, "Output"],
Cell[13392, 382, 136, 2, 27, "Print"],
Cell[13531, 386, 689, 13, 420, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14257, 404, 4859, 138, 841, "Input"],
Cell[19119, 544, 118, 2, 48, "Output"],
Cell[19240, 548, 142, 2, 27, "Print"],
Cell[19385, 552, 600, 11, 418, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
