(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8183,        244]
NotebookOptionsPosition[      7661,        224]
NotebookOutlinePosition[      8081,        240]
CellTagsIndexPosition[      8038,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook constructs an estimate for a normal to a triangle mesh.
The normal is calculated manually.

Figure 13.6 was created with this notebook.

Exercise: Calculate the normal using one or more methods.

See Chapter 13: Facets for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4203099075446167`*^9, 3.420310002911748*^9}, {
  3.426884290713232*^9, 3.426884304463003*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "point", " ", 
     RowBox[{"set", ".", " ", "The"}], " ", "peak", " ", "point", " ", "is", 
     " ", "at", " ", "the", " ", 
     RowBox[{"center", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt1", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt2", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt3", "=", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1", ",", 
        RowBox[{"-", "0.5`"}]}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt4", "=", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pt5", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"peak", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "a", " ", "triangulation", " ", "based", " ", "on", " ", 
     "the", " ", "point", " ", "set"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"tri1", "=", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"pt1", ",", "pt2", ",", "peak"}], "}"}], "]"}], "]"}]}], 
     ";"}], ")"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri2", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt2", ",", "pt3", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri3", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt3", ",", "pt4", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri4", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt4", ",", "pt5", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"tri5", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"pt5", ",", "pt1", ",", "peak"}], "}"}], "]"}], "]"}]}], 
      ";"}], ")"}]}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Combine", " ", "the", " ", "triangles", " ", "to", " ", "create", " ", 
     "the", " ", "mesh"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"mesh1", "=", 
      RowBox[{"{", 
       RowBox[{"tri1", ",", "tri2", ",", "tri3", ",", "tri4", ",", "tri5"}], 
       "}"}]}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", 
     RowBox[{"normal", " ", "--"}], " ", "hand", " ", "calculated", " ", "as",
      " ", "the", " ", "average", " ", "of", " ", "the", " ", "normals", " ", 
     "of", " ", "the", " ", "faces", " ", "meeting", " ", "at", " ", "the", 
     " ", "peak", " ", "vertex"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"normal", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Thick", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"peak", ",", 
           RowBox[{"peak", "+", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.2`"}], ",", "0", ",", "1.5`"}], "}"}]}]}], 
          "}"}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"mesh1", ",", "normal"}], "}"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}], ",", "1.5`"}], "}"}]}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ")"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "a", " ", "postscript", " ", "file"}], " ", "*)"}],
    "\[IndentingNewLine]", " ", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<mesh_normal.eps\>\"", ",", "pic"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4203100084897685`*^9, 3.4203101442850323`*^9}, {
  3.420310188358407*^9, 3.4203102156075892`*^9}, {3.4203109599879556`*^9, 
  3.4203110081872625`*^9}}],

Cell[BoxData[
 SuperscriptBox["Null", "4"]], "Output",
 CellChangeTimes->{3.4203102079666023`*^9, 3.42031100956925*^9}],

Cell[BoxData[
 Graphics3DBox[{Polygon3DBox[{{0, 0, 0}, {1, 0, 0}, {1, 1, 1}}], 
   Polygon3DBox[{{1, 0, 0}, {3, 1, -0.5}, {1, 1, 1}}], 
   Polygon3DBox[{{3, 1, -0.5}, {2, 3, 0}, {1, 1, 1}}], 
   Polygon3DBox[{{2, 3, 0}, {0, 2, 0}, {1, 1, 1}}], 
   Polygon3DBox[{{0, 2, 0}, {0, 0, 0}, {1, 1, 1}}], 
   {Thickness[Large], Line3DBox[{{1, 1, 1}, {0.8, 1, 2.5}}]}},
  Boxed->False,
  ViewPoint->{1, -1, 1.5}]], "Output",
 CellChangeTimes->{3.4203102079666023`*^9, 3.4203110095892787`*^9}],

Cell[BoxData["\<\"mesh_normal.eps\"\>"], "Output",
 CellChangeTimes->{3.4203102079666023`*^9, 3.420311009679408*^9}]
}, Open  ]]
},
WindowSize->{777, 819},
WindowMargins->{{167, Automatic}, {Automatic, 18}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 551, 18, 304, "Input"],
Cell[CellGroupData[{
Cell[1144, 43, 5774, 160, 797, "Input"],
Cell[6921, 205, 119, 2, 48, "Output"],
Cell[7043, 209, 483, 9, 482, "Output"],
Cell[7529, 220, 116, 1, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
