(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7731,        219]
NotebookOptionsPosition[      7066,        194]
NotebookOutlinePosition[      7485,        210]
CellTagsIndexPosition[      7442,        207]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook solves the 3x3 linear system in  \"Case Study: Mixing Chemicals\
\" in Section 5.1.

Here we demonstrate two ways to solve the 3x3 system of equations mat*sol = \
rhs.
1) Find the inverse of  mat and form sol = mat^{-1} * rhs
2) Use the function LinearSolve in which Mathematica determines the best \
method.

See \"Linear Systems\" or the tutorial \"Solving Linear Systems\" in the \
Mathematica Help for more information.

See Chapter 5: Solving Linear Systems for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.4258434096948895`*^9, 3.425843434861077*^9}, {
  3.425843467908597*^9, 3.425843532771866*^9}, {3.4258439945158205`*^9, 
  3.4258440433760786`*^9}, {3.425844362625136*^9, 3.425844610231176*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Enter", " ", "the", " ", "matrix"}], ",", " ", 
    RowBox[{"row", " ", "by", " ", "row"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mat", "=", "\[IndentingNewLine]", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"40", "40", "70"},
        {"30", "80", "60"},
        {"60", "10", "30"}
       }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Enter", " ", "the", " ", "right"}], "-", 
     RowBox[{"hand", " ", "side"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs", "=", 
     RowBox[{"{", 
      RowBox[{"50", ",", " ", "50", ",", " ", "50"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Solve", " ", "the", " ", "linear", " ", "system", " ", "using", " ", 
     "the", " ", "inverse", " ", "funciton"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"Inverse", "[", "mat", "]"}], ".", "rhs"}], "//", "N"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Or", " ", "solve", " ", "the", " ", "system", " ", "using", " ", "the", 
     " ", "LinearSolve", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"sol2", " ", "=", " ", 
    RowBox[{
     RowBox[{"LinearSolve", "[", 
      RowBox[{"mat", ",", " ", "rhs"}], "]"}], " ", "//", "N"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<sol = \>\"", ",", "sol", ",", "\"\<  sol2 = \>\"", ",", "sol2"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<Solution to chemical mixing problem:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Take \>\"", ",", 
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "*", "100"}], ",", 
     "\"\<% of container 1\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Take \>\"", ",", 
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "*", "100"}], ",", 
     "\"\<% of container 2\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Take \>\"", ",", 
     RowBox[{
      RowBox[{"sol", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "*", "100"}], ",", 
     "\"\<% of container 3\>\""}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4258435373784895`*^9, 3.4258436745056686`*^9}, {
  3.4258437449770017`*^9, 3.4258437696024113`*^9}, {3.4258439036751986`*^9, 
  3.425843904165904*^9}, {3.425843943662698*^9, 3.425843963551296*^9}, {
  3.4258442831809006`*^9, 3.425844305883546*^9}, {3.42584467501433*^9, 
  3.4258449739441695`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7037037037037037`", ",", "0.2222222222222222`", ",", 
   "0.18518518518518517`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.4258436671350703`*^9, 3.4258437717154493`*^9, 3.425843912397741*^9, 
   3.4258439460461245`*^9, {3.4258442980723133`*^9, 3.4258443075960083`*^9}, {
   3.425844786274314*^9, 3.425844803178621*^9}, {3.4258448799289827`*^9, 
   3.4258448913954706`*^9}, 3.4258449772489214`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sol = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.7037037037037037`", ",", "0.2222222222222222`", ",", 
     "0.18518518518518517`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  sol2 = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.7037037037037037`", ",", "0.2222222222222222`", ",", 
     "0.18518518518518517`"}], "}"}]}],
  SequenceForm[
  "sol = ", {0.7037037037037037, 0.2222222222222222, 0.18518518518518517`}, 
   "  sol2 = ", {0.7037037037037037, 0.2222222222222222, 
   0.18518518518518517`}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.425844786274314*^9, 3.4258448031686063`*^9}, {
   3.425844879938997*^9, 3.425844891405485*^9}, 3.425844977258936*^9}],

Cell[BoxData["\<\"Solution to chemical mixing problem:\"\>"], "Print",
 CellChangeTimes->{{3.425844786274314*^9, 3.4258448031686063`*^9}, {
   3.425844879938997*^9, 3.425844891405485*^9}, 3.4258449772689505`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Take \"\>", "\[InvisibleSpace]", "70.37037037037037`", 
   "\[InvisibleSpace]", "\<\"% of container 1\"\>"}],
  SequenceForm["Take ", 70.37037037037037, "% of container 1"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.425844786274314*^9, 3.4258448031686063`*^9}, {
   3.425844879938997*^9, 3.425844891405485*^9}, 3.4258449772889795`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Take \"\>", "\[InvisibleSpace]", "22.22222222222222`", 
   "\[InvisibleSpace]", "\<\"% of container 2\"\>"}],
  SequenceForm["Take ", 22.22222222222222, "% of container 2"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.425844786274314*^9, 3.4258448031686063`*^9}, {
   3.425844879938997*^9, 3.425844891405485*^9}, 3.4258449772989936`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Take \"\>", "\[InvisibleSpace]", "18.51851851851852`", 
   "\[InvisibleSpace]", "\<\"% of container 3\"\>"}],
  SequenceForm["Take ", 18.51851851851852, "% of container 3"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.425844786274314*^9, 3.4258448031686063`*^9}, {
   3.425844879938997*^9, 3.425844891405485*^9}, 3.4258449773090076`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{842, 527},
WindowMargins->{{14, Automatic}, {Automatic, 83}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 921, 26, 296, "Input"],
Cell[CellGroupData[{
Cell[1514, 51, 2887, 75, 413, "Input"],
Cell[4404, 128, 444, 9, 40, "Output"],
Cell[CellGroupData[{
Cell[4873, 141, 759, 18, 23, "Print"],
Cell[5635, 161, 212, 2, 23, "Print"],
Cell[5850, 165, 394, 7, 23, "Print"],
Cell[6247, 174, 394, 7, 23, "Print"],
Cell[6644, 183, 394, 7, 23, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
