(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     96905,       1831]
NotebookOptionsPosition[     96122,       1804]
NotebookOutlinePosition[     96541,       1820]
CellTagsIndexPosition[     96498,       1817]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates how outliers can create poor results in least \
squares approximation problem and how we can manage outliers by using \
weighted least squares approximation.
Figure 8.7 was created with this notebook.

In the first partbelow, we use standard least square approximation to a data \
set with one outlier. The result is a curve with an unwanted wiggle.

In the second part, we use the weighted technique, which weights each data \
point based on its distance from the standard least squares solution \
(previous one).
The result is clearly better. 

See Section 8.4 for details.




See Chapter 8: Data Fitting for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.42602091507722*^9, 3.4260209763052616`*^9}, {
  3.4260226326770077`*^9, 3.4260227657683835`*^9}, {3.4260228690869484`*^9, 
  3.4260229615999756`*^9}, {3.4260230053028173`*^9, 3.4260230094587927`*^9}, {
  3.426023420890403*^9, 3.426023436402708*^9}, {3.4260235803597083`*^9, 
  3.426023596953569*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "directory"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "from", " ", "which", " ", "to", " ", "extract", " ", 
     "values", "  ", "at", " ", "the", " ", "u_i"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"N", "[", 
      RowBox[{
       SqrtBox["x"], "+", 
       FractionBox[
        RowBox[{"Sin", "[", "x", "]"}], "10"]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "to", " ", "evaluate", " ", "a", " ", "degree", " ", "n",
      " ", "polynomial"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"poly", "[", 
      RowBox[{"n_", ",", "A_", ",", "x_"}], "]"}], ":=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"j", "=", "1"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{
       RowBox[{"A", "\[LeftDoubleBracket]", "j", "\[RightDoubleBracket]"}], 
       " ", 
       SuperscriptBox["x", 
        RowBox[{"j", "-", "1"}]]}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Function", " ", "to", " ", "solve", " ", "the", " ", "normal", " ", 
     "equations", " ", "for", " ", "the", " ", "polynomial", " ", 
     "coefficients"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Coeffs", "[", 
      RowBox[{"Vander_", ",", "data_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Inverse", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "Vander", "]"}], ".", "Vander"}], "]"}], 
      ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Transpose", "[", "Vander", "]"}], ".", "data"}], ")"}]}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Degree", " ", "polynomial"}], "*)"}], "\[IndentingNewLine]", " ",
    
   RowBox[{
    RowBox[{"n", "=", "8"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Number", " ", "of", " ", "data", " ", "values"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "knots"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"u", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "our", " ", "outlier"}], " ", "*)"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"data", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}], 
     "=", "6"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
       "Create", " ", "the", " ", "design", " ", "matrix", " ", "or", " ", 
        "Vandermonde", " ", "matrix", " ", "for", " ", "L", " ", "uniformly", 
        " ", "space", " ", "u"}], "-", 
       RowBox[{"values", " ", "u"}]}], "=", "1"}], ",", " ", "2", ",", 
     RowBox[{
     "...", "L", " ", "and", " ", "a", " ", "degree", " ", "n", " ", 
      "polynomial"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vander", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"u", "[", 
         RowBox[{"[", "i", "]"}], "]"}], 
        RowBox[{"j", "-", "1"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "L"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", 
         RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "the", " ", "matrix", " ", "part", " ", "of", " ", "the", 
     " ", "normal", " ", "equations"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Mat", "=", 
     RowBox[{
      RowBox[{"Transpose", "[", "Vander", "]"}], ".", "Vander"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Assign", " ", "the", " ", "polynomial", " ", "coefficients", " ", "to", 
     " ", "A"}], " ", "*)"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"N", "[", 
      RowBox[{"Coeffs", "[", 
       RowBox[{"Vander", ",", "data"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "data", " ", 
     "points"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"data", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"PointSize", "[", "0.02`", "]"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "given", " ",
      "function", " ", "f", " ", "and", " ", "the", " ", "approximating", " ",
      "polynomial"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PLT", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"poly", "[", 
          RowBox[{"n", ",", "A", ",", "x"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         ",", 
         RowBox[{
         "u", "\[LeftDoubleBracket]", "L", "\[RightDoubleBracket]"}]}], "}"}],
        ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "the", " ", "pics", " ", "together"}], " ", "*)"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{"pic1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"PLT", ",", "datplot", ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<outlier1.eps\>\"", ",", "pic1"}], "]"}], " ", "\n", 
   GraphicsBox[{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV13k8VG0bB3BbZkbMGRXZZ5ghMTNmULZyfpUKRZZSoZCUKCqFRNkq8Ygi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        "]]}, 
      {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
       LineBox[CompressedData["
1:eJwV13k4lF0UAHBKM5YxY5lBZZkZJVsI2ZJ7skVJiJJEJT5RUYSQyJp9iYRS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        "]]}}, {{}, 
      {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
       PointBox[{{1., 1.0841470984807897`}, {2., 1.5051433050556633`}, {3., 
        1.746162808374864}, {4., 1.9243197504692071`}, {5., 6.}, {6., 
        2.4215481929632854`}, {7., 2.7114499709364694`}, {8., 
        2.9273629494085283`}, {9., 3.0412118485241755`}, {10., 
        3.1078755490794427`}, {11., 3.2166257697003293`}, {12., 
        3.410444323337711}, {13., 3.647567979146653}, {14., 
        3.8407181223434286`}, {15., 3.938012130223129}, {16., 
        3.9712096683334934`}, {17., 4.0269658764297045`}, {18., 
        4.167541962442118}, {19., 4.373886664506969}, {20., 
        4.563430480072342}}]}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{5., 1.},
    BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
    PlotRange->All,
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
      "===", "===", "\[Equal]"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Now", " ", 
     RowBox[{"let", "'"}], "s", " ", "do", " ", "the", " ", "weighted", " ", 
     "least", " ", "squares"}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
      "===", "===", "\[Equal]"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataold", "=", "data"}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"data", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}], 
      "=", "6"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "recall", " ", "that", " ", "data", " ", "has", " ", "outlier", " ", 
       RowBox[{
       "data", "\[LeftDoubleBracket]", "5", "\[RightDoubleBracket]"}]}], "=", 
      "6"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]",
    
   RowBox[{"(*", " ", 
    RowBox[{
    "Compute", " ", "the", " ", "distance", " ", "of", " ", "the", " ", 
     "data", " ", "value", " ", "to", " ", "the", " ", "least", " ", 
     "squares", " ", "polynomial", " ", "from", " ", "the", " ", "previous", 
     " ", "math", " ", "cell"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dist", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"poly", "[", 
          RowBox[{"n", ",", "A", ",", "i"}], "]"}], "-", 
         RowBox[{
         "data", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Compute", " ", "weights", " ", "for", " ", "each", " ", "data"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Uses", " ", "a", " ", "heuristic", " ", "value", " ", "of", " ", "0.1", 
     " ", "to", " ", "prevent", " ", "zero", " ", "divide"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"weights", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
          "dist", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
          "]"}], "+", "0.1`"}]], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<weights for each data: \>\"", ",", "weights"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<  smallest weight should be \>\"", ",", 
     RowBox[{"weights", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "new", " ", "data", " ", "are", " ", "the", " ", "old", " ", 
     "ones", " ", "multiplied", " ", "by", " ", "the", " ", "weights"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
        "weights", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        " ", 
        RowBox[{
        "data", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}]}], ",",
        
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "L"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Modify", " ", "the", " ", "Vandermonde", " ", "matrix"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vander", "=", 
     RowBox[{"weights", " ", "Vander"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Recompute", " ", "the", " ", "least", " ", "square", " ", 
     RowBox[{"approx", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"N", "[", 
      RowBox[{"Coeffs", "[", 
       RowBox[{"Vander", ",", "data"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "data", " ", 
     "points"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"dataold", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"PointSize", "[", "0.02`", "]"}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "given", " ",
      "function", " ", "and", " ", "new", " ", "approxiamtion"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PLT", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"poly", "[", 
          RowBox[{"n", ",", "A", ",", "x"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         ",", 
         RowBox[{
         "u", "\[LeftDoubleBracket]", "L", "\[RightDoubleBracket]"}]}], "}"}],
        ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Thickness", "[", "0.01`", "]"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
   RowBox[{"pic2", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"PLT", ",", "datplot", ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<outlier2.eps\>\"", ",", "pic2"}], "]"}], "\n", 
   "\n"}]}]], "Input",
 CellChangeTimes->{{3.4260210072998295`*^9, 3.426021052094241*^9}, {
   3.426021544452217*^9, 3.4260217635773034`*^9}, {3.426021810404638*^9, 
   3.426022053894759*^9}, {3.4260220966963053`*^9, 3.426022154920027*^9}, {
   3.426022300489345*^9, 3.426022397098262*^9}, {3.4260224447067194`*^9, 
   3.4260226045065002`*^9}, 3.4260235720777993`*^9, {3.4260236486679306`*^9, 
   3.4260237005124793`*^9}, {3.426023754820571*^9, 3.426023770503121*^9}, {
   3.4260238683838663`*^9, 3.426023901912078*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV13k8VG0bB3BbZkbMGRXZZ5ghMTNmULZyfpUKRZZSoZCUKCqFRNkq8Ygi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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
     LineBox[CompressedData["
1:eJwV13k4lF0UAHBKM5YxY5lBZZkZJVsI2ZJ7skVJiJJEJT5RUYSQyJp9iYRS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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
     PointBox[{{1., 1.0841470984807897`}, {2., 1.5051433050556633`}, {3., 
      1.746162808374864}, {4., 1.9243197504692071`}, {5., 6.}, {6., 
      2.4215481929632854`}, {7., 2.7114499709364694`}, {8., 
      2.9273629494085283`}, {9., 3.0412118485241755`}, {10., 
      3.1078755490794427`}, {11., 3.2166257697003293`}, {12., 
      3.410444323337711}, {13., 3.647567979146653}, {14., 
      3.8407181223434286`}, {15., 3.938012130223129}, {16., 
      3.9712096683334934`}, {17., 4.0269658764297045`}, {18., 
      4.167541962442118}, {19., 4.373886664506969}, {20., 
      4.563430480072342}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{5., 1.},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4260237729866924`*^9, 3.4260239026831865`*^9}],

Cell[BoxData["\<\"outlier1.eps\"\>"], "Output",
 CellChangeTimes->{3.4260237729866924`*^9, 3.426023902763302*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV13k8VG0bB3BbZkbMGRXZZ5ghMTNmULZyfpUKRZZSoZCUKCqFRNkq8Ygi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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
     LineBox[CompressedData["
1:eJwV13k4lF0UAHBKM5YxY5lBZZkZJVsI2ZJ7skVJiJJEJT5RUYSQyJp9iYRS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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
     PointBox[{{1., 1.0841470984807897`}, {2., 1.5051433050556633`}, {3., 
      1.746162808374864}, {4., 1.9243197504692071`}, {5., 6.}, {6., 
      2.4215481929632854`}, {7., 2.7114499709364694`}, {8., 
      2.9273629494085283`}, {9., 3.0412118485241755`}, {10., 
      3.1078755490794427`}, {11., 3.2166257697003293`}, {12., 
      3.410444323337711}, {13., 3.647567979146653}, {14., 
      3.8407181223434286`}, {15., 3.938012130223129}, {16., 
      3.9712096683334934`}, {17., 4.0269658764297045`}, {18., 
      4.167541962442118}, {19., 4.373886664506969}, {20., 
      4.563430480072342}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{5., 1.},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4260237729866924`*^9, 3.426023902793345*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"weights for each data: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4.4336088865394165`", ",", "1.596715173866879`", ",", 
     "1.9958129533066253`", ",", "0.7523895935503238`", ",", 
     "0.3936009371423398`", ",", "0.8709890576983985`", ",", 
     "1.8034405529198627`", ",", "8.063850159464117`", ",", 
     "3.1517377708971885`", ",", "3.8353815753562093`", ",", 
     "8.939713308139137`", ",", "5.468280611880025`", ",", 
     "5.666631360410043`", ",", "8.642387867381647`", ",", 
     "7.6886918797776875`", ",", "7.559091724017233`", ",", 
     "9.161113682529122`", ",", "8.985468293679373`", ",", 
     "8.623595853537454`", ",", "9.235124469036183`"}], "}"}]}],
  SequenceForm[
  "weights for each data: ", {4.4336088865394165`, 1.596715173866879, 
   1.9958129533066253`, 0.7523895935503238, 0.3936009371423398, 
   0.8709890576983985, 1.8034405529198627`, 8.063850159464117, 
   3.1517377708971885`, 3.8353815753562093`, 8.939713308139137, 
   5.468280611880025, 5.666631360410043, 8.642387867381647, 
   7.6886918797776875`, 7.559091724017233, 9.161113682529122, 
   8.985468293679373, 8.623595853537454, 9.235124469036183}],
  Editable->False]], "Print",
 CellChangeTimes->{3.426023773166951*^9, 3.426023902823388*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  smallest weight should be \"\>", "\[InvisibleSpace]", 
   "0.3936009371423398`"}],
  SequenceForm["  smallest weight should be ", 0.3936009371423398],
  Editable->False]], "Print",
 CellChangeTimes->{3.426023773166951*^9, 3.426023902843417*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"luc\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Result for \\!\\(Inverse\\) of badly conditioned matrix \
\\!\\({\\(\\({777.7875403999394`, 11324.538318588206`, \\(\\(\[LeftSkeleton] \
6 \[RightSkeleton]\\)\\), 5.487892852484897`*^12}\\)\\), \
\\(\\(\[LeftSkeleton] 7 \[RightSkeleton]\\)\\), \\(\\({\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)}\\)\\)}\\) may contain significant numerical errors. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/luc\\\", \
ButtonNote -> \\\"Inverse::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.426023773196995*^9, 3.4260239028834743`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV13k8VG0bB3BbZkbMGRXZZ5ghMTNmULZyfpUKRZZSoZCUKCqFRNkq8Ygi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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.01], 
     LineBox[CompressedData["
1:eJwd0nlcjPsXB/ApNTMVPc8MZVq0l2jRQpuYo7K0UqhUKilSlKWSNmlXtFHS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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
     PointBox[{{1., 1.0841470984807897`}, {2., 1.5051433050556633`}, {3., 
      1.746162808374864}, {4., 1.9243197504692071`}, {5., 6.}, {6., 
      2.4215481929632854`}, {7., 2.7114499709364694`}, {8., 
      2.9273629494085283`}, {9., 3.0412118485241755`}, {10., 
      3.1078755490794427`}, {11., 3.2166257697003293`}, {12., 
      3.410444323337711}, {13., 3.647567979146653}, {14., 
      3.8407181223434286`}, {15., 3.938012130223129}, {16., 
      3.9712096683334934`}, {17., 4.0269658764297045`}, {18., 
      4.167541962442118}, {19., 4.373886664506969}, {20., 
      4.563430480072342}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{5., 1.5},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.4260237729866924`*^9, 3.4260239029836187`*^9}],

Cell[BoxData["\<\"outlier2.eps\"\>"], "Output",
 CellChangeTimes->{3.4260237729866924`*^9, 3.426023903063734*^9}]
}, Open  ]]
},
WindowSize->{750, 815},
WindowMargins->{{48, Automatic}, {Automatic, 10}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 1185, 34, 531, "Input"],
Cell[CellGroupData[{
Cell[1778, 59, 35968, 740, 2567, "Input"],
Cell[37749, 801, 20536, 345, 314, "Output"],
Cell[58288, 1148, 113, 1, 48, "Output"],
Cell[58404, 1151, 20534, 345, 314, "Output"],
Cell[CellGroupData[{
Cell[78963, 1500, 1304, 24, 94, "Print"],
Cell[80270, 1526, 295, 6, 27, "Print"]
}, Open  ]],
Cell[80580, 1535, 726, 12, 79, "Message"],
Cell[81309, 1549, 14681, 249, 319, "Output"],
Cell[95993, 1800, 113, 1, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
