(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11717,        270]
NotebookOptionsPosition[     11233,        251]
NotebookOutlinePosition[     11652,        267]
CellTagsIndexPosition[     11609,        264]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook plots the function from the \"perspective division\" step in \
the viewing pipeline. It demonstrates how points in eye coordinates get \
mapped to NDC coordinates.

See Chapter 16: Background: Computer Graphics for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.420332278953122*^9, 3.420332429339367*^9}, {
  3.42704138375708*^9, 3.4270413933809185`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"<<", "\"\<BarCharts`\>\""}], ";", 
     RowBox[{"<<", "\"\<Histograms`\>\""}], ";", 
     RowBox[{"<<", "\"\<PieCharts`\>\""}]}], ")"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Output", " ", "results", " ", "to", " ", "folder", " ", "that", " ", 
    "this", " ", "file", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "example", " ", "near", " ", "and", " ", "far", " ", 
     "plane", " ", "distances"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"near", "=", "0.1`"}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   
   RowBox[{"(", 
    RowBox[{
     RowBox[{"far", "=", "4.`"}], ";"}], ")"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Define", " ", "the", " ", "function", " ", "that", " ", "maps", " ", 
      "eye", " ", "to", " ", "NDC", " ", "z"}], "-", "coordinates"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"zc", "[", "z_", "]"}], "=", 
      RowBox[{"near", "+", "far", "-", 
       FractionBox[
        RowBox[{"near", " ", "far"}], "z"]}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "the", " ", "function", " ", "for", " ", "z", " ", "behind", 
     " ", "and", " ", "in", " ", "front", " ", "of", " ", "the", " ", "eye"}],
     " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"zc", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Thickness", "[", "0.009`", "]"}], "}"}]}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<z-eye\>\"", ",", "\"\<z-NDC\>\""}], "}"}]}]}], "]"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Ouput", " ", "plot", " ", "to", " ", "postscript"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<persp_division.eps\>\"", ",", "%"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.420332439824444*^9, 3.420332612913333*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.009], LineBox[CompressedData["
1:eJwV03s41OkXAHCmWOQy7/fbFLElqVBRrSja7WxutdJYuWyJSHJpcispFaNt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     "]], LineBox[CompressedData["
1:eJwV03k41HsXAHA0uLP9fpOprrdIimzdqwWRck5Jqehq4WUwarjaZAsRo1xD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     "]], 
    LineBox[{{-0.001505011000627181, 
     5.012737250509032}, {-0.001497032119839133, 3.186507256399384}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"z-eye\"", TraditionalForm], 
    FormBox["\"z-NDC\"", TraditionalForm]},
  AxesOrigin->{0, 3.5},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{{-5, 5}, {3.186507256399384, 5.012737250509032}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.42033261613797*^9}],

Cell[BoxData["\<\"persp_division.eps\"\>"], "Output",
 CellChangeTimes->{3.420332616939122*^9}]
}, Open  ]]
},
WindowSize->{852, 740},
WindowMargins->{{Automatic, 57}, {Automatic, 77}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 568, 17, 267, "Input"],
Cell[CellGroupData[{
Cell[1161, 42, 3214, 82, 573, "Input"],
Cell[4378, 126, 6741, 119, 303, "Output"],
Cell[11122, 247, 95, 1, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
