(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17030,        476]
NotebookOptionsPosition[     16583,        458]
NotebookOutlinePosition[     17003,        474]
CellTagsIndexPosition[     16960,        471]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\


Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford


This notebook illustrates a special bivariate function, a plane, l(x,y) = \
1-x-y.
The plane is plotted for x and y over [0,1].

See Chapter 11: Computing with Multivariate Functions for details.

Updated May 2008\
\>", "Input",
 PageWidth->WindowWidth,
 CellChangeTimes->{{3.4201154925779886`*^9, 3.4201156235663404`*^9}, {
  3.4201158093835325`*^9, 3.4201158256268897`*^9}, {3.4201456063694944`*^9, 
  3.42014560961416*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Set", " ", "output", " ", "folder", " ", "to", " ", "folder", " ", "this",
     " ", "files", " ", "lives", " ", "in"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "plane", " ", "equation"}], " ", "*)"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"l", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"1", "-", "x", "-", "y"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "plot"}], " ", "*)"}], " ", "\[IndentingNewLine]", 
   
   RowBox[{"pic", "=", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"l", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"ColorFunction", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
         RowBox[{"Hue", "[", "z", "]"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ViewPoint", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
         
         RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}]}], "]"}]}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "plot", " ", "to", " ", "postscript", " ", "file"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<plane.eps\>\"", ",", "pic"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.420115627371813*^9, 3.420115695059142*^9}, {
   3.4201159493047295`*^9, 3.420115968272003*^9}, 3.420116050590371*^9, {
   3.420116096185934*^9, 3.420116104357685*^9}, {3.420116158916136*^9, 
   3.4201162257522416`*^9}, {3.420116261473606*^9, 3.4201162616438513`*^9}, {
   3.426362419420352*^9, 3.4263624231757517`*^9}, {3.4263624847242546`*^9, 
   3.4263624898516273`*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxd2E9oVEccwPG1hWJtbnpREVS2akGkIl48OAgiLmgpvbQ3xVYRyaKgHtpL
iyCIeNAohBw8GEGkLSVoWakoSopeFNEc/LcUNbTBEhvFetBTzO7M5xefC2GY
7743b96Hzb+3aNvur7Z/UKvV3kx9fTj1deqbXy4cWr53rXHRX5vPT04+T7tW
rB34tHEu6X8u+3FJu/Vf+vXpg8l6Yzj6jn1DA63meKpfnLPqQvNG9JlXn/T0
1f9Nt64tPV9vjET/+ZPZPzXbY+nwims3m+270Td9vf7/jX1/pw3928ZazXb0
icH9O+qN0TSj1nk9jr6wu89Hacvvt4503te/6+6nnS7vPDm3MbWefrZ73btp
/oLeM53r68+664+k7++sWdXZr761u86NdO/gx1c796c/7R4/nFavub+p46E/
7vZz6djEmQcdP71WXuZceZobeXLWeXLWeXLWeXLWeXLWeXLWeXLWeXLWeXLW
eXLWeXLWeXLWs+bQJc76i3z8Fc78eDpO52lu5MlZ58lZ58lZ58lZ58lZ58lZ
58lZ58lZ58lZ58lZ58k5+unsyVnPzsPhzIknZ52n83We5kaenHWenHWenHWe
nHWenHWenHWenHWenHWenKMXT8766+LJWd+Z9xPOPHhy1nly1nlaV+dpbuTJ
WefJWefJWefJWefJWefJWefJOXrx5Kzz5KzvKZ6c9fx5Hgln982Ts86Ts86T
s87T9XSe5kaenHWenHWenHWenHWenKMXT846T846T876q+LJOX4u5vsNZ/fH
k7POk7POk7POk7PO0z50nuZGnpx1npx1npyjF0/OOk/OOk/OOk/O+lDx5Kzn
nxvtcHYfPDnrPDnrPDnrPDnrPDnrPO1P52lu5Mk5evHkrPPkrPPkrPPkrPPk
rPcWT87x+yR7hrP98uSs8+Ss8+Ss8+Ss8+Ss8+Ss87Tv6MXT3MiTs86Ts86T
s86Ts86Ts76seHLW88/n0XC2L56cdZ6cdZ6cdZ6cdZ6cdZ6coxdPzjpP96Pz
NDfy5Kzz5Kzz5Kzz5Ky/LJ6c9S/y77twdn2enHWenHWenHWenHWenKMXT846
T846T846T/ep8zQ38uSs8+Ss8+Ssf1k8Ocff6fnvt3B2HZ6cdZ6cdZ6cdZ6c
oxdPzjpPzjpPzjpPzjpPzjpP96/zNDfy5Kzz5Kz/Vjw567Py/yPhbD2enHWe
nHWenKMXT846T846T846T846T846T846T846Ty46T3MjT856T/HkrOe/N8bD
2Xk8Oes8OUcvnpx1npx1npx1npx1npx1npx1npx1npx1npx1nrx0nubxnKN4
ctav5+dF4ez9Wnlx1j0P4Vztw+Gs+3+Tc/X4kXCO5wHFk3N1nXY4x/+1xZNz
df3RcNb9PuJcve5YOOu+3zlX9zMezjpPc+Pi/Pzzyj9/fHRzSWMwGT2v46+/
PDDW22xPpG9PpOOdUfc5t2707ud8MNZ3nuOtr+fvo+njjPZv7jqv8n5ifeu9
v8/qc8vp+4zPVdmnufOs//B2/8rPGn3JaP0f1u1ttZrPo/t8mntfNzda3/6c
N+vzeUffPa66/+l9VPffF/t3Xk9eJ/ZvHes7PvZf1nGcdVzX3HnWfwsCFJxR

   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
        "]]]}, {}, {}, {}}, 
    Line3DBox[{246, 1, 242, 227, 16, 31, 46, 61, 76, 91, 106, 121, 136, 151, 
     166, 181, 196, 231, 248, 211, 244, 236, 212, 213, 214, 215, 216, 217, 
     218, 219, 220, 221, 222, 223, 224, 233, 249, 225, 245, 237, 210, 195, 
     180, 165, 150, 135, 120, 105, 90, 75, 60, 45, 30, 229, 247, 15, 243, 235,
      14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 234, 246}]},
   VertexColors->{
     Hue[1.], 
     Hue[0.9642857142857142], 
     Hue[0.9285714285714286], 
     Hue[0.8928571428571428], 
     Hue[0.8571428571428571], 
     Hue[0.8214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.5], 
     Hue[0.9642857142857142], 
     Hue[0.9285714285714286], 
     Hue[0.8928571428571428], 
     Hue[0.8571428571428571], 
     Hue[0.8214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857143], 
     Hue[0.9285714285714286], 
     Hue[0.8928571428571428], 
     Hue[0.8571428571428571], 
     Hue[0.8214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142855`], 
     Hue[0.8928571428571428], 
     Hue[0.8571428571428571], 
     Hue[0.8214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714285`], 
     Hue[0.8571428571428571], 
     Hue[0.8214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.3571428571428571], 
     Hue[0.8214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285714], 
     Hue[0.7857142857142857], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428564`], 
     Hue[0.75], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999994`], 
     Hue[0.7142857142857142], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999983`], 
     Hue[0.21428571428571422`], 
     Hue[0.6785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999983`], 
     Hue[0.2142857142857141], 
     Hue[0.1785714285714285], 
     Hue[0.6428571428571428], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999983`], 
     Hue[0.2142857142857141], 
     Hue[0.17857142857142838`], 
     Hue[0.14285714285714277`], 
     Hue[0.6071428571428571], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999983`], 
     Hue[0.2142857142857141], 
     Hue[0.17857142857142838`], 
     Hue[0.14285714285714265`], 
     Hue[0.10714285714285705`], 
     Hue[0.5714285714285713], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999983`], 
     Hue[0.2142857142857141], 
     Hue[0.17857142857142838`], 
     Hue[0.14285714285714265`], 
     Hue[0.10714285714285694`], 
     Hue[0.07142857142857133], 
     Hue[0.5357142857142856], 
     Hue[0.4999999999999999], 
     Hue[0.4642857142857142], 
     Hue[0.42857142857142844`], 
     Hue[0.39285714285714274`], 
     Hue[0.357142857142857], 
     Hue[0.3214285714285713], 
     Hue[0.28571428571428553`], 
     Hue[0.24999999999999983`], 
     Hue[0.2142857142857141], 
     Hue[0.17857142857142838`], 
     Hue[0.14285714285714265`], 
     Hue[0.10714285714285694`], 
     Hue[0.07142857142857122], 
     Hue[0.03571428571428561], 
     Hue[0.5], 
     Hue[0.4642857142857143], 
     Hue[0.42857142857142855`], 
     Hue[0.39285714285714285`], 
     Hue[0.3571428571428571], 
     Hue[0.3214285714285714], 
     Hue[0.28571428571428564`], 
     Hue[0.24999999999999994`], 
     Hue[0.21428571428571422`], 
     Hue[0.1785714285714285], 
     Hue[0.14285714285714277`], 
     Hue[0.10714285714285705`], 
     Hue[0.07142857142857133], 
     Hue[0.03571428571428561], 
     Hue[0.], 
     Hue[0.9642857142857142], 
     Hue[0.9821428571428571], 
     Hue[0.4999999999999999], 
     Hue[0.4821428571428571], 
     Hue[0.4999999999999999], 
     Hue[0.5178571428571428], 
     Hue[0.03571428571428561], 
     Hue[0.017857142857142804`], 
     Hue[0.9821428571428571], 
     Hue[0.5178571428571428], 
     Hue[0.4821428571428571], 
     Hue[0.017857142857142804`], 
     Hue[0.9821428571428571], 
     Hue[0.5], 
     Hue[0.5], 
     Hue[0.017857142857142804`], 
     Hue[0.9910714285714285], 
     Hue[0.5089285714285714], 
     Hue[0.49107142857142855`], 
     Hue[0.008928571428571347], 
     Hue[0.9910714285714285], 
     Hue[0.49107142857142855`], 
     Hue[0.5089285714285714], 
     Hue[0.008928571428571347]},
   VertexNormals->CompressedData["
1:eJztxTERgCAUANB/koPBDAZgogARuHNmtoUt7GULNmlggTe8e3sf7dwiYi5p
ycddn+sttm3btm3btm37/w/8O+3R
    "]],
  Axes->True,
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  BoxRatios->{1, 1, 0.4},
  ImageSize->{360., 287.9027944041347},
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0, 1}, {0, 1}, {-0.9999998571428572, 0.9999998571428571}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{0.5848055089474636, -1.0570788186780642`, 1.2412038059105701`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.4201154545533123`*^9, {3.4201157043525057`*^9, 3.4201157142066755`*^9}, {
   3.4201159605408864`*^9, 3.420115968692608*^9}, 3.420116054846491*^9, 
   3.4201161108870735`*^9, {3.420116182540106*^9, 3.4201162267937393`*^9}, 
   3.420116262344859*^9, 3.426362426009827*^9, {3.426362485815824*^9, 
   3.4263624902822466`*^9}}]
}, Open  ]]
},
WindowSize->{830, 814},
WindowMargins->{{192, Automatic}, {Automatic, 30}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 584, 19, 286, "Input"],
Cell[CellGroupData[{
Cell[1177, 44, 2797, 70, 445, "Input"],
Cell[3977, 116, 12590, 339, 391, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
