(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36179,        708]
NotebookOptionsPosition[     35562,        686]
NotebookOutlinePosition[     35981,        702]
CellTagsIndexPosition[     35938,        699]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates polyhedra.

Figure 13.13 was created with this notebook.

See Chapter 13: Facets for details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.4203110953826437`*^9, 3.4203111287305956`*^9}, {
  3.426884213362006*^9, 3.4268842235065937`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "three", " ", "polyhedra"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"tet", " ", "=", " ", 
     RowBox[{"PolyhedronData", "[", "\"\<Tetrahedron\>\"", "]"}]}], ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"dod", " ", "=", " ", 
     RowBox[{"PolyhedronData", "[", "\"\<Dodecahedron\>\"", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"icosa", " ", "=", " ", 
     RowBox[{"PolyhedronData", "[", "\"\<Icosahedron\>\"", "]"}]}], ";"}], 
   "\n", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{"Yellow", ",", 
       RowBox[{"Opacity", "[", ".8", "]"}], ",", "tet"}], "}"}], "]"}], "  ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tpic", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
         RowBox[{"PolyhedronData", "[", 
          RowBox[{"\"\<Tetrahedron\>\"", ",", " ", "\"\<Faces\>\""}], "]"}]}],
         "}"}], ",", 
       RowBox[{"Lighting", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dpic", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
         RowBox[{"PolyhedronData", "[", 
          RowBox[{"\"\<Dodecahedron\>\"", ",", " ", "\"\<Faces\>\""}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Lighting", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ipic", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".5", "]"}], ",", 
         RowBox[{"Glow", "[", "Yellow", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", " ", 
         RowBox[{"PolyhedronData", "[", 
          RowBox[{"\"\<Icosahedron\>\"", ",", " ", "\"\<Faces\>\""}], "]"}]}],
         "}"}], ",", 
       RowBox[{"Lighting", "\[Rule]", "None"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{"{", 
     RowBox[{"tpic", ",", " ", "dpic", ",", " ", "ipic"}], "}"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"tet", ",", "dod", ",", "icoso", ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.67`"}], ",", 
          RowBox[{"-", "3.385`"}], ",", "3.02`"}], "}"}]}]}], "]"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<polyhedra.eps\>\"", ",", "pic"}], "]"}], 
    "\[IndentingNewLine]", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.420311136351554*^9, 3.420311211709914*^9}, {
   3.420311322298933*^9, 3.420311367343704*^9}, {3.4203114797353153`*^9, 
   3.4203114922833586`*^9}, {3.420311630932727*^9, 3.4203116775998306`*^9}, 
   3.4203117077031174`*^9, {3.4203117527979603`*^9, 3.420311753288666*^9}, {
   3.4203118029901333`*^9, 3.4203118240203733`*^9}, {3.42031191937749*^9, 
   3.420311981346597*^9}, {3.4203121189344387`*^9, 3.4203121231104436`*^9}, {
   3.4203121755057845`*^9, 3.4203122199396772`*^9}, {3.4203122499828773`*^9, 
   3.420312298362444*^9}, {3.4203125718657217`*^9, 3.420312596461088*^9}, {
   3.4203132818466244`*^9, 3.420313315034346*^9}, {3.4203133450875607`*^9, 
   3.420313387318285*^9}, {3.4203134254731493`*^9, 3.420313460413391*^9}, {
   3.42031356674629*^9, 3.420313591561973*^9}, {3.4203136737902117`*^9, 
   3.4203139428470964`*^9}, {3.4203150182935123`*^9, 3.4203150520320263`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], EdgeForm[GrayLevel[0.5]], Glow[
    RGBColor[1, 1, 0]], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
       Rational[-1, 2] 6^Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
      0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
      0.5773502691896258, 0, -0.20412414523193154`}}], 
    Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]]},
  Lighting->None]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.420313388890546*^9, 3.42031346209581*^9, 3.420313592162837*^9, {
   3.4203136867588596`*^9, 3.4203138155240145`*^9}, 3.420313854860578*^9, 
   3.4203139439186373`*^9, 3.420315018303527*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], EdgeForm[GrayLevel[0.5]], Glow[
    RGBColor[1, 1, 0]], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {
      0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {(Rational[1, 8] + 
        Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
        Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 24] 5^Rational[1, 2])^
       Rational[1, 2], 
       Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
        Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
       Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
       Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {(Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
       Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
        Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {(Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
       Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
        Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
        Rational[1, 2], 
       Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
        Rational[1, 2], Rational[
       1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
       Rational[1, 2], Rational[-1, 2], 
       Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 2], 
       Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2], 0, 
       Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[5, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
       Rational[1, 2], 0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
       Rational[1, 2]}, {
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), 
       Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
      Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), 
       Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
      Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
       Rational[1, 4] (-3 - 5^Rational[1, 2]), 
       Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
      Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
       Rational[1, 4] (3 + 5^Rational[1, 2]), 
       Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
        Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
      0, 0, -1.4012585384440737`}, {
      0.17841104488654497`, -1.3090169943749475`, 0.46708617948135783`}, {
      0.17841104488654497`, 1.3090169943749475`, 0.46708617948135783`}, {
      0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
      0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
      1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
      1.0444364486709836`, 0.8090169943749475, 
      0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
      0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
      0.46708617948135783`}, {
      1.2228474935575286`, -0.5, -0.46708617948135783`}, {1.2228474935575286`,
       0.5, -0.46708617948135783`}, {-0.9341723589627157, 
       0, -1.0444364486709836`}, {-0.46708617948135783`, -0.8090169943749475, 
      1.0444364486709836`}, {-0.46708617948135783`, 0.8090169943749475, 
      1.0444364486709836`}, {
      0.9341723589627157, 0, 
       1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
      0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
      1.3090169943749475`, -0.46708617948135783`}}], 
    Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
     11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
     13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7,
      16, 1, 14}, {16, 8, 4, 15, 1}}]]},
  ImageSize->{360., 416.9957432745343},
  Lighting->None,
  ViewPoint->{1.2740110721821993`, -3.132657125079056, 0.11556437447841184`},
  ViewVertical->{0.06407810665358316, -0.6271531284237449, 
   0.8084741064354992}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.420313388890546*^9, 3.42031346209581*^9, 3.420313592162837*^9, {
   3.4203136867588596`*^9, 3.4203138155240145`*^9}, 3.420313854860578*^9, 
   3.420313944058839*^9, 3.420315018303527*^9}],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], EdgeForm[GrayLevel[0.5]], Glow[
    RGBColor[1, 1, 0]], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
      0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
    Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
     5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
     3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 
     12, 6}, {3, 8, 10}, {9, 7, 3}}]]},
  Lighting->None]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.420313388890546*^9, 3.42031346209581*^9, 3.420313592162837*^9, {
   3.4203136867588596`*^9, 3.4203138155240145`*^9}, 3.420313854860578*^9, 
   3.420313944209055*^9, 3.420315018303527*^9}],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    Graphics3DBox[
     {Opacity[0.5], EdgeForm[GrayLevel[0.5]], Glow[
       RGBColor[1, 1, 0]], 
      GraphicsComplex3DBox[
       NCache[{{
         0, 0, Rational[2, 3]^Rational[1, 2] + 
          Rational[-1, 2] 6^Rational[-1, 2]}, {
         Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
          6^Rational[-1, 2]}, {
         Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
          6^Rational[-1, 2]}, {
         3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
         0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
         0.5773502691896258, 0, -0.20412414523193154`}}], 
       Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]]},
     Lighting->None], ",", 
    Graphics3DBox[
     {Opacity[0.5], EdgeForm[GrayLevel[0.5]], Glow[
       RGBColor[1, 1, 0]], 
      GraphicsComplex3DBox[
       NCache[{{
         0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
          Rational[1, 2]}, {
         0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {(Rational[1, 8] + 
           Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^
          Rational[1, 2]}, {(Rational[1, 8] + 
           Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^
          Rational[1, 2]}, {(Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-1 - 5^Rational[1, 2]), 
          Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {(Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (1 + 5^Rational[1, 2]), 
          Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {(Rational[5, 8] + 
           Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^
          Rational[1, 2]}, {(Rational[5, 8] + 
           Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^
          Rational[
           1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
           Rational[1, 2], 
          Rational[-1, 2], (Rational[1, 8] + 
           Rational[1, 24] 5^Rational[1, 2])^
          Rational[
           1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
           Rational[1, 2], Rational[
          1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
          Rational[1, 2]}, {(Rational[3, 4] + 
           Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2], 
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {(Rational[3, 4] + 
           Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[1, 2], 
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2], 0, 
          Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2], 
          Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2], 
          Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[5, 24] 5^Rational[1, 2])^
          Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
          0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
          Rational[1, 2]}, {
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {
         Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
          Rational[1, 4] (-3 - 5^Rational[1, 2]), 
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}, {
         Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
          Rational[1, 4] (3 + 5^Rational[1, 2]), 
          Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
           Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
         0, 0, -1.4012585384440737`}, {
         0.17841104488654497`, -1.3090169943749475`, 0.46708617948135783`}, {
         0.17841104488654497`, 1.3090169943749475`, 0.46708617948135783`}, {
         0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
         0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
         1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
         1.0444364486709836`, 0.8090169943749475, 
         0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
         0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
         0.46708617948135783`}, {
         1.2228474935575286`, -0.5, -0.46708617948135783`}, {
         1.2228474935575286`, 
         0.5, -0.46708617948135783`}, {-0.9341723589627157, 
          0, -1.0444364486709836`}, {-0.46708617948135783`, \
-0.8090169943749475, 1.0444364486709836`}, {-0.46708617948135783`, 
         0.8090169943749475, 1.0444364486709836`}, {
         0.9341723589627157, 0, 
          1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
         0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
         1.3090169943749475`, -0.46708617948135783`}}], 
       Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
        19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5,
         19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 
        14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]]},
     Lighting->None], ",", 
    Graphics3DBox[
     {Opacity[0.5], EdgeForm[GrayLevel[0.5]], Glow[
       RGBColor[1, 1, 0]], 
      GraphicsComplex3DBox[
       NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
         0, 0, 5 (50 - 10 5^Rational[1, 2])^
           Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
          0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
           Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
          Rational[-1, 2]}, {
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
           5^Rational[1, 2]), 
          Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
           5^Rational[1, 2]), Rational[
          1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
           5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
          Rational[-1, 2]}, {
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
           5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
          Rational[-1, 2]}, {
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2]), 
          Rational[-1, 
            2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
           Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2]), 
          Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
           Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2]), 
          Rational[-1, 
            2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
           Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2]), 
          Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
           Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
         0, 0, -0.9510565162951536}, {
         0, 0, 0.9510565162951536}, {-0.85065080835204, 
          0, -0.42532540417601994`}, {
         0.85065080835204, 0, 0.42532540417601994`}, {
         0.6881909602355868, -0.5, -0.42532540417601994`}, {
         0.6881909602355868, 
         0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
         0.42532540417601994`}, {-0.6881909602355868, 0.5, 
         0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
         0.8090169943749475, -0.42532540417601994`}, {
         0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
         0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
       Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
        12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10,
         8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4,
         5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]},
     Lighting->None]}], "}"}], "]"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.420313388890546*^9, 3.42031346209581*^9, 3.420313592162837*^9, {
   3.4203136867588596`*^9, 3.4203138155240145`*^9}, 3.420313854860578*^9, 
   3.420313944639674*^9, 3.420315018303527*^9}]
}, Open  ]]
},
WindowSize->{818, 840},
WindowMargins->{{23, Automatic}, {-2, Automatic}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 430, 15, 249, "Input"],
Cell[CellGroupData[{
Cell[1023, 40, 4264, 97, 643, "Input"],
Cell[5290, 139, 10639, 181, 513, 792, 16, "CachedBoxData", "BoxData", \
"Output"],
Cell[15932, 322, 5903, 106, 552, "Output"],
Cell[21838, 430, 3393, 61, 549, "Output"],
Cell[25234, 493, 10312, 190, 163, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
