(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4885,        147]
NotebookOptionsPosition[      4516,        132]
NotebookOutlinePosition[      4935,        148]
CellTagsIndexPosition[      4892,        145]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook illustrates how you plot a vectorfield.
Figure 9.1 was created with this notebook.

p(t) is population at a given time
p'(t) = c * p(t) describes population growth.
c is constant the depends on the particular population.
If we know the population at some time t_0, an initial value of p_0, then \
what is the population at some time t? 

Below we have plotted the slope p'(t) for pairs (t,p). The circles represent \
initial values. These initial values determine functions that follow the \
vectorfield.

Initial value ODE

See Chapter 9 : Computing Dynamic Processes for details.

Updated July 2008
\
\>", "Input",
 CellChangeTimes->{
  3.4260952802371745`*^9, {3.4260953251717873`*^9, 3.426095344048931*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "directory"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Load", " ", "the", " ", "vectorfield", " ", "package"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Needs", "[", "\"\<VectorFieldPlots`\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "a", " ", "vectorfield"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"vecfield", "=", 
     RowBox[{"VectorFieldPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"2", " ", "y"}], "]"}], "-", 
          RowBox[{"0.4`", " ", 
           SuperscriptBox["x", "2"]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"startpoint1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.02`", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"startpoint2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1.5`"}]}], "}"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "0.02`", "]"}]}]}], "]"}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{"vecfield", ",", "startpoint1", ",", "startpoint2"}], "}"}], 
     "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<slopefield_problem.eps\>\"", ",", "pic"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.42609530401136*^9, 3.426095307546443*^9}, {
  3.426095479633893*^9, 3.4260955410121503`*^9}, {3.4260956120442896`*^9, 
  3.426095640375027*^9}}]
},
WindowSize->{838, 749},
WindowMargins->{{60, Automatic}, {Automatic, 21}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 906, 27, 395, "Input"],
Cell[1477, 50, 3035, 80, 537, "Input"]
}
]
*)

(* End of internal cache information *)
