(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      3937,        122]
NotebookOptionsPosition[      3568,        107]
NotebookOutlinePosition[      3987,        123]
CellTagsIndexPosition[      3944,        120]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook is used for the Problems and Experiments for Chapter 11.

Figure 11.5 was created with this notebook.

See Chapter 11: Computing with Multivariate Functionsfor details.

Updated May 2008\
\>", "Input",
 CellChangeTimes->{{3.426367262043702*^9, 3.426367343510846*^9}},
 FormatType->"TextForm"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "output", " ", "folder"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "the", " ", "function", " ", "we", " ", "want"}], 
    " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"6", " ", "x", " ", "y"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "3"]}]}]}], ";"}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "it"}], " ", "*)"}], 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "3"}], ",", "0.9`"}], "}"}]}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "90"}], ",", 
       RowBox[{"ColorOutput", "\[Rule]", "GrayLevel"}]}], "]"}]}], ")"}], " ",
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<problem_multi.eps\>\"", ",", "pic"}], "]"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.4263673474264765`*^9, 3.4263673961164894`*^9}}]
},
WindowSize->{716, 744},
WindowMargins->{{34, Automatic}, {Automatic, 28}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 462, 15, 249, "Input"],
Cell[1033, 38, 2531, 67, 447, "Input"]
}
]
*)

(* End of internal cache information *)
