(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24723,        514]
NotebookOptionsPosition[     24233,        495]
NotebookOutlinePosition[     24653,        511]
CellTagsIndexPosition[     24610,        508]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates finding roots with piecewise linear interpolation.
Figures 10.1 and 10.3 were generated with this notebook.

Try setting the variable n below to n=4 and n=5. WIth n=5, the roots of the \
function can be found by intersecting the piecewise linear approximaiton's \
line segments with the line y=0. But this approach runs into problems with \
n=4 because the line segments do not intersect the line y=0.


See Chapter 10: Finding Roots for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.426339526942586*^9, 3.426339548763963*^9}, {
  3.4263396069976993`*^9, 3.426339653604717*^9}, {3.4263407761087985`*^9, 
  3.426340918123005*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Specify", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "a", " ", "function"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"N", "[", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", "0.1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "the", " ", "number", " ", "of", " ", "piecewise", " ", 
     "linear", " ", "points", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", "to", " ", "extract", " ", "from", 
     " ", "f"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", 
     RowBox[{"the", " ", "[", 
      RowBox[{"a", ",", "b"}], "]"}], " ", "the", " ", "domain", " ", "over", 
     " ", "which", " ", "to", " ", "evaluate", " ", "the", " ", "function"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"n", "=", 
     RowBox[{
     "4", " ", "used", " ", "generate", " ", "FIgure", " ", "10.3"}]}], "  ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"5", " ", "used", " ", "for", " ", "Figure", " ", "10.1"}], 
        " ", "..."}], " ", "and", " ", "some", " ", "other", " ", "combo", 
       " ", "of", " ", "a"}]}], ",", 
     RowBox[{
     "b", " ", "and", " ", "or", " ", "a", " ", "modification", " ", "of", 
      " ", 
      RowBox[{"f", ".", " ", "You"}], " ", "can", " ", "play", " ", "with", 
      " ", 
      RowBox[{"it", "!"}]}]}], " ", "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", "4"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"-", "1.2"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"b", "=", "2"}], ";"}], "\[IndentingNewLine]", "\n", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Create", " ", "a", " ", "plot", " ", "of", " ", "the", " ", "function", 
      " ", "and", " ", "the", " ", "line", " ", "y"}], "=", "0"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fctplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
          RowBox[{"Thickness", "[", "0.001", "]"}]}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
       RowBox[{"PlotRange", "->", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Generate", " ", "the", " ", "n", " ", "points", " ", "on", " ", "the", 
     " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"The", " ", "x"}], "-", 
     RowBox[{
     "values", " ", "are", " ", "uniformly", " ", "spaced", " ", "over", " ", 
      "the", " ", 
      RowBox[{"domain", " ", "[", 
       RowBox[{"a", ",", "b"}], "]"}]}]}], " ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"And", " ", "at", " ", "each", " ", "x"}], "-", "value"}], ",", 
     " ", 
     RowBox[{"we", " ", "evaluate", " ", "f"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "+", 
          FractionBox[
           RowBox[{"i", " ", 
            RowBox[{"(", 
             RowBox[{"b", "-", "a"}], ")"}]}], "n"]}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"a", "+", 
           FractionBox[
            RowBox[{"i", " ", 
             RowBox[{"(", 
              RowBox[{"b", "-", "a"}], ")"}]}], "n"]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "the", " ", "points", " ", "joined",
      " ", "by", " ", "line", " ", "segments"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"polyplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"points", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "plot", " ", "of", " ", "points", " ", "at", " ",
      "a", " ", "particular", " ", "pointsize"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointplot", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"points", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"PointSize", "[", "0.03", "]"}], "}"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Put", " ", "all", " ", "the", " ", "plots", " ", "together"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"fctplot", ",", "pointplot", ",", "polyplot"}], "]"}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Output", " ", "the", " ", "plot", " ", "to", " ", "a", " ", "postscript",
      " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<pw_linear_miss.eps\>\"", ",", "pic"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.426339660825099*^9, 3.4263400023762255`*^9}, {
  3.4263400468802195`*^9, 3.4263400475812273`*^9}, {3.426340083783283*^9, 
  3.426340174323474*^9}, {3.426340260978077*^9, 3.426340318370603*^9}, {
  3.426340369684389*^9, 3.4263403821423025`*^9}, {3.4263404685765886`*^9, 
  3.4263405560724015`*^9}, {3.4263405965506067`*^9, 3.426340680260976*^9}, {
  3.4263407621387105`*^9, 3.426340769919899*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwV1Hk41N0XAHCyZo2EIhVJSaheEr3uIGtRFCEVFaUURRprllJS9n1rjJR9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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], Thickness[0.001], 
     LineBox[CompressedData["
1:eJxN0H0sFHAYB/DLpHXzhyjdulXDuqRcyk66WnXquChzV3H8gayb5K2ZwiGk
NXPlRktOd9stGZGYER2ysPO64krEnDMcd7i483YcV23t+f2e7dl3n/+e7+MQ
Ec/hWRAIBP+/+y8/8yod3N0NrYT/o3fNtqKeRKashsw5H0fOe0qsP+SEHFYW
xSLaIRM0R+Mn9HqwV8zbZmEtsjxBEjR/CnlP0u6cHeQl8HRf68MC+0Vw0Htp
/COqDhxVVa8WWs6DheywkSKzBkyfMrUFf5sB94z5B3DeTYPj+LQQr/JJ8Kud
NsHa1AlweeR2uZ1GCdbmMzVfdCNgD1GinUryE1yh7vNYKFSA2Y4Hcn4k9IFV
tjG0KlU7OP2wQ0VnRwNYQKNcUTSIwNThAW/m45KL0HfpnBvftwncO17vR2TI
wQX0zWdG1ldwSaxnumXGd/DgWjddIhwCX6jTf5ALRsGSF+5nM5Xj4HuFR3il
hglwZmJLI8dpClw7J43sYqnB/a2/Rd5XZ9G9pb5D1g+0YN2MTdFo6jw4r92x
LiFZB77FlS44ByyCg7em2sTsJTC5slpSd1cPvrHLTRYQawCT3AItB2KWwcW3
LW6uZK2g/zDuTEuerIJ9XK6lacVrYMH4r0vkmnUw8/JBn/4aI7ilWs051rkB
ruzhSa16N8GU2lxyV7cJHPqGJnZVboGtGYWh+1Xb4KTZNErpmhksHRTnyzF3
tTWbZjCTJCaFyzqyjJ2WUYPZJEsdbjIiZz3n5yo2kSv4xSsGzIpIWfg+E7Kj
14YHF3PHasrkGGar8JTzmi1k6nVRGXEbOZD+yfYE5rK9xtk4zKzu5JfLmO9/
LCLYm5FFJY3RZzBr09cZfMy20aSq15jpXE9SC+YIJjdbiVlwOllnxvwHcfNj
Nw==
      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.03], 
     PointBox[{{-1.2, 1.3399999999999999`}, {-0.5599999999999998, 
      0.21359999999999982`}, {0.0800000000000003, -0.09359999999999996}, {
      0.7200000000000004, 0.41840000000000066`}, {1.3600000000000005`, 
      1.7496000000000014`}, {2.000000000000001, 
      3.9000000000000035`}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{-1.2, 1.3399999999999999`}, {-0.5599999999999998, 
      0.21359999999999982`}, {0.0800000000000003, -0.09359999999999996}, {
      0.7200000000000004, 0.41840000000000066`}, {1.3600000000000005`, 
      1.7496000000000014`}, {2.000000000000001, 3.9000000000000035`}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.426340059177902*^9, 3.4263400874986258`*^9}, {
   3.426340158060088*^9, 3.4263401752648273`*^9}, 3.4263403220959597`*^9, {
   3.4263403778060675`*^9, 3.4263403833740735`*^9}, {3.4263404945739713`*^9, 
   3.426340556663251*^9}, 3.426340617210314*^9, 3.426340762879776*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
},
WindowSize->{730, 726},
WindowMargins->{{-12, Automatic}, {Automatic, -1}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 856, 22, 357, "Input"],
Cell[CellGroupData[{
Cell[1449, 47, 6820, 175, 1145, "Input"],
Cell[8272, 224, 15945, 268, 310, 7577, 130, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
