(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45781,        857]
NotebookOptionsPosition[     45163,        835]
NotebookOutlinePosition[     45582,        851]
CellTagsIndexPosition[     45539,        848]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\

Mathematical Principles for Scientific Computing and Visualization  
http://www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook demonstrates piecewise linear interpolation.
Figure 8.2 was generated with this notebook.

Input: a function f(x). Here f(x) = x^2 + 100sin(x) + 10
Output: a piecewise linear approximation using 15 evaluations

Whenever we plot a curve on a computer, we are creating a piecewise linear \
function. Typically, the software evaluates the function at so many places \
that the pw linear nature cannot be detected.


See Chapter 8: Data Fitting for details.

Updated July 2008\
\>", "Input",
 CellChangeTimes->{{3.4259339100571203`*^9, 3.425933937456518*^9}, {
  3.425934027806435*^9, 3.425934213122907*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Clear", " ", "these", " ", "because", " ", "we", " ", "tend", " ", "to", 
    " ", "use", " ", "them", " ", "in", " ", "other", " ", "notebooks"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Specify", " ", "the", " ", "output", " ", "folder"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"ToFileName", "[", 
      RowBox[{"Extract", "[", 
       RowBox[{
        RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
         RowBox[{"NotebookInformation", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
        RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "function"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"100", "*", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "+", "10"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Evaluate", " ", "the", " ", "function", " ", "at", " ", "x"}], 
      "=", "1"}], ",", "2", ",", "3", ",", 
     RowBox[{"...", "15"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pw", ":=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "15"}], "}"}]}], " ", "]"}]}], " ", 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", 
     RowBox[{"function", ".", " ", "Mathematica"}], " ", "determines", " ", 
     "a", " ", "good", " ", "number", " ", "of", " ", "evaluations", " ", 
     "so", " ", "the", " ", "plot", " ", "looks", " ", 
     RowBox[{"smooth", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotf", " ", "=", " ", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "15"}], "}"}], ",", " ", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"Thickness", "[", "0.01", "]"}]}], " ", ",", " ", 
      RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Let", "'"}], "s", " ", "plot", " ", "the", " ", "pw", " ", 
     "linear", " ", "approximation", " ", "in", " ", "different", " ", 
     "styles"}], "  ", "*)"}], "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"First", " ", "plot", " ", "just", " ", "the", " ", "points"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotpw1", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"pw", ",", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"PointSize", "[", "0.02`", "]"}]}]}], "]"}]}], " ", "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "the", " ", "lines", " ", "connecting", " ", "the", " ", 
     "points", " ", "on", " ", "the", " ", "function"}], " ", "*)"}], "\n", 
   RowBox[{"plotpw2", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"pw", ",", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", 
      RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Now", " ", "put", " ", "them", " ", "all", " ", "together"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plotf", ",", "plotpw1", ",", "plotpw2"}], "}"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "postscript", " ", "file"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<pwlinear_approx.eps\>\"", ",", "pic"}], "]"}], 
   " "}]}]], "Input",
 CellChangeTimes->{{3.4259339456683264`*^9, 3.4259340237806463`*^9}, {
  3.4259342227167025`*^9, 3.425934302471384*^9}, {3.425934348107005*^9, 
  3.425934396977277*^9}, {3.4259355003238115`*^9, 3.4259355110692625`*^9}, {
  3.4259355913547072`*^9, 3.425935861423046*^9}, {3.4259358968039217`*^9, 
  3.425935906347645*^9}, {3.4259359380632496`*^9, 3.4259359415682898`*^9}, {
  3.4259359849005985`*^9, 3.4259360021754384`*^9}, {3.425936097682771*^9, 
  3.425936102109136*^9}, {3.425936134135187*^9, 3.425936163146904*^9}, {
  3.425936218196061*^9, 3.4259362318156447`*^9}, {3.426340037216323*^9, 
  3.426340038388008*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwVl3k8VO8Xx5WIihhLss1gBjGE7IZ77JJllH0pYSr0tQ2REFIJ2RKSKCKU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., 0},
  PlotRange->{{1, 15}, {-68.2290570751983, 313.9678913751661}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.425934305265402*^9, {3.425934357380339*^9, 3.425934386271883*^9}, {
   3.425935501575611*^9, 3.425935512821782*^9}, 3.4259355651670513`*^9, {
   3.425935598995694*^9, 3.425935651511208*^9}, 3.4259356857704706`*^9, 
   3.4259357255576816`*^9, {3.4259357603376927`*^9, 3.4259357777627487`*^9}, {
   3.4259358190220766`*^9, 3.425935861943795*^9}, 3.4259359068383503`*^9, 
   3.425935942259283*^9, 3.425936002696187*^9, {3.425936140564432*^9, 
   3.4259361640782433`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
    PointBox[{{1., 95.14709848078965}, {2., 104.92974268256818`}, {3., 
     33.112000805986725`}, {4., -49.68024953079282}, {
     5., -60.89242746631385}, {6., 18.058450180107414`}, {7., 
     124.6986598718789}, {8., 172.93582466233818`}, {9., 
     132.21184852417565`}, {10., 55.59788891106302}, {11., 
     31.000979344929647`}, {12., 100.3427081999565}, {13., 
     221.0167036826641}, {14., 305.06073556948706`}, {15., 
     300.02878401571166`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 15.}, {-60.89242746631385, 305.06073556948706`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.425934305265402*^9, {3.425934357380339*^9, 3.425934386271883*^9}, {
   3.425935501575611*^9, 3.425935512821782*^9}, 3.4259355651670513`*^9, {
   3.425935598995694*^9, 3.425935651511208*^9}, 3.4259356857704706`*^9, 
   3.4259357255576816`*^9, {3.4259357603376927`*^9, 3.4259357777627487`*^9}, {
   3.4259358190220766`*^9, 3.425935861943795*^9}, 3.4259359068383503`*^9, 
   3.425935942259283*^9, 3.425936002696187*^9, {3.425936140564432*^9, 
   3.4259361641082864`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 95.14709848078965}, {2., 104.92974268256818`}, {3., 
     33.112000805986725`}, {4., -49.68024953079282}, {
     5., -60.89242746631385}, {6., 18.058450180107414`}, {7., 
     124.6986598718789}, {8., 172.93582466233818`}, {9., 
     132.21184852417565`}, {10., 55.59788891106302}, {11., 
     31.000979344929647`}, {12., 100.3427081999565}, {13., 
     221.0167036826641}, {14., 305.06073556948706`}, {15., 
     300.02878401571166`}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 15.}, {-60.89242746631385, 305.06073556948706`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.425934305265402*^9, {3.425934357380339*^9, 3.425934386271883*^9}, {
   3.425935501575611*^9, 3.425935512821782*^9}, 3.4259355651670513`*^9, {
   3.425935598995694*^9, 3.425935651511208*^9}, 3.4259356857704706`*^9, 
   3.4259357255576816`*^9, {3.4259357603376927`*^9, 3.4259357777627487`*^9}, {
   3.4259358190220766`*^9, 3.425935861943795*^9}, 3.4259359068383503`*^9, 
   3.425935942259283*^9, 3.425936002696187*^9, {3.425936140564432*^9, 
   3.425936164128315*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJwVl3k8VO8Xx5WIihhLss1gBjGE7IZ77JJllH0pYSr0tQ2REFIJ2RKSKCKU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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[0.02], 
     PointBox[{{1., 95.14709848078965}, {2., 104.92974268256818`}, {3., 
      33.112000805986725`}, {4., -49.68024953079282}, {
      5., -60.89242746631385}, {6., 18.058450180107414`}, {7., 
      124.6986598718789}, {8., 172.93582466233818`}, {9., 
      132.21184852417565`}, {10., 55.59788891106302}, {11., 
      31.000979344929647`}, {12., 100.3427081999565}, {13., 
      221.0167036826641}, {14., 305.06073556948706`}, {15., 
      300.02878401571166`}}]}, {}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 95.14709848078965}, {2., 104.92974268256818`}, {3., 
      33.112000805986725`}, {4., -49.68024953079282}, {
      5., -60.89242746631385}, {6., 18.058450180107414`}, {7., 
      124.6986598718789}, {8., 172.93582466233818`}, {9., 
      132.21184852417565`}, {10., 55.59788891106302}, {11., 
      31.000979344929647`}, {12., 100.3427081999565}, {13., 
      221.0167036826641}, {14., 305.06073556948706`}, {15., 
      300.02878401571166`}}]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{2., 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{
  3.425934305265402*^9, {3.425934357380339*^9, 3.425934386271883*^9}, {
   3.425935501575611*^9, 3.425935512821782*^9}, 3.4259355651670513`*^9, {
   3.425935598995694*^9, 3.425935651511208*^9}, 3.4259356857704706`*^9, 
   3.4259357255576816`*^9, {3.4259357603376927`*^9, 3.4259357777627487`*^9}, {
   3.4259358190220766`*^9, 3.425935861943795*^9}, 3.4259359068383503`*^9, 
   3.425935942259283*^9, 3.425936002696187*^9, {3.425936140564432*^9, 
   3.4259361641583586`*^9}}],

Cell[BoxData["\<\"pwlinear_approx.eps\"\>"], "Output",
 CellChangeTimes->{
  3.425934305265402*^9, {3.425934357380339*^9, 3.425934386271883*^9}, {
   3.425935501575611*^9, 3.425935512821782*^9}, 3.4259355651670513`*^9, {
   3.425935598995694*^9, 3.425935651511208*^9}, 3.4259356857704706`*^9, 
   3.4259357255576816`*^9, {3.4259357603376927`*^9, 3.4259357777627487`*^9}, {
   3.4259358190220766`*^9, 3.425935861943795*^9}, 3.4259359068383503`*^9, 
   3.425935942259283*^9, 3.425936002696187*^9, {3.425936140564432*^9, 
   3.4259361642685165`*^9}}]
}, Open  ]]
},
WindowSize->{772, 804},
WindowMargins->{{24, Automatic}, {Automatic, 30}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 774, 22, 340, "Input"],
Cell[CellGroupData[{
Cell[1367, 47, 5020, 115, 819, "Input"],
Cell[6390, 164, 17304, 290, 310, "Output"],
Cell[23697, 456, 1311, 27, 310, "Output"],
Cell[25011, 485, 1291, 27, 310, "Output"],
Cell[26305, 514, 18292, 308, 310, "Output"],
Cell[44600, 824, 547, 8, 48, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
