(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24179,        459]
NotebookOptionsPosition[     23691,        440]
NotebookOutlinePosition[     24111,        456]
CellTagsIndexPosition[     24068,        453]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Mathematical Principles for Scientific Computing and Visualization
http : // www.farinhansford.com/books/scv
by Gerald Farin and Dianne Hansford

This notebook plots a sample transfer function. 

Figures  14.10 was created with this notebook.

See Chapter 14 : Visualizing Scalar Values over 2D for details.

Updated May 2008
\
\>", "Input",
 CellChangeTimes->{{3.4269468596636305`*^9, 3.4269468833276577`*^9}, {
  3.426946919719987*^9, 3.4269469373753743`*^9}},
 FormatType->"TextForm"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Set", " ", "the", " ", "output", " ", "folder"}], " ", "*)"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", "\[InvisibleSpace]", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "the", " ", "transfer", " ", "function"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{"pic", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "x", "]"}], "500"], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", 
          FractionBox["\[Pi]", "2"]}], ",", 
         FractionBox["\[Pi]", "2"]}], "}"}], ",", 
       RowBox[{"PlotPoints", "\[Rule]", "50"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Thickness", "[", "0.01`", "]"}]}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\"\<FontFamily\>\"", "\[Rule]", "\"\<Helvetica\>\""}], ",",
           
          RowBox[{"\"\<FontSize\>\"", "\[Rule]", "11"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Angle\>\"", ",", "\"\<Gray Value\>\""}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ")"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Output", " ", "to", " ", "a", " ", "postscript", " ", "file"}], 
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<reflines_transfer.eps\>\"", ",", "pic"}], "]"}], ";"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.4269469421622577`*^9, 3.4269470016578083`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[0.01], LineBox[CompressedData["
1:eJxN2nk0F98fP/CSJZE9SigiJdmyxXvmJREpWSu0WMpesodUQkhISLaEZGuz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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["\"Angle\"", TraditionalForm], 
    FormBox["\"Gray Value\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  BaseStyle->{"FontFamily" -> "Helvetica", "FontSize" -> 11},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.426946993315813*^9, 3.4269470025190463`*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztXWuoXFcVPnfuzL1zE00rihQEuQhC1T5SpVAroiC+EFF/iIIIjUFNfmhL
jSD6p/6xfxRBES2I+eGjPqqtRlurqWkTba2IEWmtWKG0WJK2eTRJqwTE8a5v
P85e63x7zzlnZm5q6KVnZrLPXt9ee+312o9z+u4de3Z99BM79uzeuWP97dfv
uG7X7p2fWn/btddvFC0vVdXSwY3r5euV/J5UVfiYbPw3OSQfUtLt9wX4Wq4c
0MT/Sz6HqmzjQsH2jvUvjb+GhVofb1Xr8gXzelVeJCv4HFmyKtfMCikbkLJX
taw3LLT/sTlgMNG27cOlHeU1VcyzNDlvkU+vt3POeJecI7lc6YYFt1blBiPc
SsrWixRtm69R2F1WtjbDYDDaeQueyerKvO6z6puh5+eZGJ93IefchWSHBfFg
08IlWusUHEGxkFAIZB/4Xmgqyd+YEFpB5erNW0N3zUBrhdeF59e0pL3a3d0m
XwO5wbzQ9nh33iIbkbLXubJJWnbFDHiXd+b+kqI0Xu9Exgxztaj4uGsS+XGk
uIJ0+7Wk3mVFZOYQaq5eGettc534A2n0sZZS2pqHONKt+p9bjKT8ZeYzrtIo
Vgu35G859thNVoL3ufDMmbNvPvynx+WqfoxPlEXiFxE+fdlVDz5wNNLe4mjX
jxw5HetZp9SlP4FTqN+AVwDdkvxacr/Sngk/kze98Sa5qp/gc/m+3btu2/XT
2x5EjQtJz7bVtLd+7rN3gupWR3vD3m/90dZTDLFZYL5zmeK8MVeo8DX52CIF
U9LaOTQ4qgUUhFmtOWFIWRRu27It5zHtCj6HomDjs2f/I5KT+y8gOuZ86TAt
23vjF+4eP4d681yiHWvzg9gu8GpqHGDt6WY3iZXaOFJD2P7w348duPaT+6o1
fKJMfnUq23Je0Y7SMrlOvuudezdKMWxf/9IXD8Vhy1tDLEMUSYwpYMr9rf8X
4lgs7diVXXPH7X/bTGtgCI3Ay1KFy6YPOa6XkrJXtCzzHAbT9D4En1IW620t
8yJ++5EPvP97gVZ+v/fQwUdQ4+KWvLB+sP4yWlbvZUb6caAG9ejOK3Fi43c1
KXsDKfPykdRR5AYJDpwcJbgVxwDpTLUisg5eX65/v/Ut35QU89UtWWCsZsVn
ygbxRqck+pd5zkWbmL9znR2F7DJcENJvCWcvIebn5m/VnQ4qyDtc0NmCq5Ux
itHVj5HIOdY7RJp88VQ2vvzVr9ybsgHPn2djJC4srf/Qhz/0Az9hCpBpCi8X
rLMAKU2m9ZEzKMhlGRYZnrTzFz/66MmiEa4VBO3hf8WHFZMNpvPj/Fio6dfj
Cl461JBxHn5kFfPwzo/cUh1VkO+4//ePpVUk6DpI5xRdrc989zuHG+qqgS46
fvzZtAqygAJvN3/+hv0NUXnIX7sqApFWkSa8AVFI6V5aH1qtIaV7aRXpfgmS
sqAhrdahIwxytSCoJxSkFbfYVglSOtoYRA1pVUE0tQRpzVOGy0BKcG1oVwHy
xpu+cX/DPDVkag9yHXnfe75dgrRKhLzIQ+7nI4jpGbPyVa4hUCINKa4qrQIH
UoC0jgNKpCHv+PSe2xt6mYX0GYo4snjjqMKjSrkWzdpvpcpqTcPBPqmArCpi
0BhjK1wVka9qyA/etf8fDWdSgLSqC1XUkDZSoEoBUsTRMDANSTtSgLS+WQRn
IKm4C5B2EKHdHvKunB6s5vFsdIKSpXjVSAwurYJgNM5DhoQ7XEi4NaT1ylgi
LEBaa0F9DWlbxawxDzm0PuAphSb6l95FXM+ieZnDa4cbTyg8mwlh2MbR9kYF
ZdCMWZWC7THGPKT4oUYY0JDWrUPxC5DWsMRPGUhrnjDnAiQ1fw1pW3VT3zwk
7ZWGtOJGsCpAUtlrSBvIMYIFSBv/oBce8jc5c17J41m9TfH2yVdy+MluH8YY
QJGto4B9eeSfEbzCySAIparX82DNzEeNuGkj/PZrOkTy0Py0pm1YR/1+Tae9
kNsQYKFp6/Pgdvs1bccOddzG2CSqwzDMgcJ1rE9bK1YDxbSLqsWc55O9mqZO
NtO0l4xNLqGa/TqeanQM9uXWrQPCfHc+rcM3lVu3uTo86jHrK7yGBlnib5Dc
YMg0QhxLvFomQhQgaX0NSVstQNoIgZmzhqQiKkDaHBKjoCHpmBcgaQ6pIWnQ
KUDSoOMhD+RMcpTHo0EnxWv6Fj9lic6ngYE8VGFwh1jQb5oRliHh3jtAIrXV
kLYKJoIFSMpCGdJtiGQhG6ntcYVm58dltGETgA53FiBZOY83nlJ41G0zvGVu
QYDWLFKj6QCJTFBD0klvAZK6Dg1pHZDYZQmSpsBlSLjJlWhsGSDU0kB2DbAG
4rzRhjWkbRXLTR0gkcGXISGRAuR1P/rhXxqDqCGtKkyDpJOCMiRcfgdIGISG
pC6/AElt1kPenZgpFte0O2mFh/lxige/UWCIeqEUoBradYcCGvWQCo1HDxbU
MpDw42VIuO4CJF310JC21RoytV/acBkIc6Y8b0MLeUKh2aVIyLeAZsO9RqOx
PovGZsDHinhQboY3KAQQzSJNkWaDtFYtvqgEaQMIvEYZEr6nAEndpYcsrw4M
tEsOs41ZGmw7wVnhTSNbLzRtJwyYDXRsGvqHQ3WV3rJezrdLA2GfdqtxWhZP
2/nuC2yh9/PgwunBaiizHLiDPtAacACmQ4ANG5fhrE9qtW3bH/nhr9wRK9t2
offULjr2Pmk9GHdoXRaRFtx68lxb2jLcSqFpm0oj7+3XNPbE/F+bpqkTbvgW
t283TPsks5WeuPc47dsoLQDYxS8sSHUBoMlFA8CdI7CS7YWXCfAsHfOQdJd7
Nkhavy0kENsD0f3VAm90B15DUiFnITGCJ+cLYHMmpMh+0q8ANi4koyzROa4g
qS1kICFmNvleOCTdZ85AYgHFQyLB4ZDUpWYg3UMHDhIxatMg7RIB5vMZSOS8
0yFpHM9AYug8pMpW2kIu13E8ZlvswJ7Gs3t32GefjUWaNmYgMW4eUj2PsemQ
2FqdDZJOIzKQkJ+HjA+wzA8yHCduAYlFg56QB6P3zAAgb/cA8ehtFwB/YhoA
MOQsgE96EtraIDIB4WSCkQl1y5wtLDF6ttRRy+MtIRNrtcdr1RNXZTwsa2RY
TE8+FyCpYFpAqkON/SERLwH5dBHDeVzcG1oMtuFxQqHROEnQpFMsRPZDE6l3
R4M3IGgy1izWZlYA+MtLHMBIObFgKaVZvx+cHtuaaTNhW3PwPBcTDHPkYqji
6cTPyv1wIyab4e7UevLkwChsBasEgqib1GOxvtcyBDmb7zXR9ntiWG3kOr2k
33iUBtNIzwJ2MjIs0HO782EhSUtHKoc0LNBUtyMLoyYLaD4xg74s1H7HHUZN
xrYESdc6dAigZ6CJpopasBxFu1maSS0cTUy3OxpSMoImAmW5kEc75BzHxv2Z
aV16wiP505aiGqaZV2HxAOlKSp7JkAZN9qUeS2ZObCIa2CdoksOwrEijUVmy
hSbI9NSm0mZXME4qKHo430Bllxk0FM2hFgflEuWpUPSBBgOVXU7QUNRnDqJt
zQLQmRd7sAnr+gYqndyrhEND0ZhcgFLxfWFQdLvIQKWTeKztcCia8hWgVPq4
MCj6ZI6Bwqh6KGxPcigaugxUdt6/MCj6DFXDXNQSggfAM5bwe6bl7NLBXAir
NbtNnr4mQr7TNQL12LKGoTErgcnO4zcFJjxKGWAwLh4GC/cUZkyDTgIDsZ/u
TdJusutSqPjaFz/TwkqCx03m+2r1oFeGn60XAlTgIH3WP7dGMF8OQlw7dxyE
aBYWuYKDcstg/jM4Nik+tcjmh+nLR8Q2WQztM8dK9M4swqsmRbfn0OSUTlsO
QgAVDsQKWFydLwchLjMOcgsM8+UgnnvwHITJvuFAnXRozGzHZmgtaBjDidc0
Fs89qHd29JziTAhhTVAQpDdsb0Ej0KcnPEJuFuwRfidf7v4wHDoUMpGuJ8MK
CyPz++2BJBtsmzTDQBOuwRSyapU9/SiUbi1hKjkLqkKeDaaanB0Z7EDOzqtb
chWDy+TQ2g1yt7ogJWfS+o1nf3CIeKP+cHpVeJoqpmkqjpxSlOx0bD9K/Lum
xIhySvZcR24Opij5FCWJVnGidFo1yB53SRpU7k6zyp6CSSjVvEVTshPrCaXy
JJqSZfEJpfIgmlIy3gKl8hye8t7anLEXZBWuOpPUa54VqUVv7PaUIrN2m5Ip
g9Nk9nnBlmTW0FIytSCkyezRpprsmbTe0Bqb1z912Pu0QramAgLvLGOC1SSz
5+tTMmUkmsweIUjJlKprMqvqKRmW2TmZ1daUDIvInMyqakqmQpUnu8/JXulf
TaG2fD3FL/DFjoLy2YmfuajTU3ULSt0KLeTfOdzYcEDq4zOW1PRENM/MpQUM
m+9AaAF5ybNzgcfs38BDwXrBr1p4MdUw3k5CvaTCyoYxkPjs7F+zI/tTzCGq
418edp+pLn9tXxHMDsl5+f5cvjq9b7gAxrpev+2XPf/oCdl7dqffwj96/t9P
2vw+EGUzcb9Qeg/p5H+n3kIeP6p9BBl3V7QcRzdRCFWZvea53VvRWAuDOD4P
ufLvZ/WSv7wws1qTvPpOK+2WLD7HyLwdz74+b7riPuBIbya3RryN/Dy04WhU
F+0IlbHav8yxWfXhzn0i28ZaSQzfrC8ljAyjmfdWFvivFTPrhZK7nJnVwr2R
QWg1+jjy8dc808yJrhYUePqefuR3PLOysA4VjGIcLSz/flKmFzSkkbKZ3206
cw+ZuMPv2rVkdTDftfYZYwdRTNr6aV12UbbjTE112T9dU3Xwsq/q7AHWJvJW
S/8DCBItLA==\
\>"]]
}, Open  ]]
},
WindowSize->{763, 818},
WindowMargins->{{204, Automatic}, {Automatic, 47}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 20, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 497, 16, 261, "Input"],
Cell[CellGroupData[{
Cell[1090, 41, 2227, 53, 467, "Input"],
Cell[3320, 96, 20355, 341, 317, 15336, 257, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

